/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.i18n;

import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ReportI18n {
    private static final String BUNDLE_NAME = "com.geolocsystems.prismcentral.export.i18n.messages";
    private static final Map<String, ResourceBundle> RESOURCES_MAP = new HashMap<String, ResourceBundle>();

    private ReportI18n() {
    }

    public static String getString(String key) {
        return ReportI18n.getString(key, null);
    }

    public static String getString(String key, String defaut) {
        try {
            Locale locale = ReportI18n.getLocale();
            String language = locale.getLanguage();
            if (!RESOURCES_MAP.containsKey(language)) {
                RESOURCES_MAP.put(language, ResourceBundle.getBundle(BUNDLE_NAME, locale));
            }
            return RESOURCES_MAP.get(language).getString(key);
        }
        catch (MissingResourceException e) {
            if (defaut == null) {
                return String.valueOf('!') + key + '!';
            }
            return defaut;
        }
    }

    private static Locale getLocale() {
        String code = ConfigurationFactory.getInstance().get("report.lang");
        return new Locale(code);
    }
}

