/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.csv;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAlternat;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampImages;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLabel;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampPatrouilleProcedure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampRadioBouton;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampSignature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.tunnel.PointParticulier;
import com.geolocsystems.prismandroid.model.tunnel.Tube;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;

public class CSVComposantFactory
implements IComposantFactory {
    private static final String SEPARATEUR = "\";\"";
    private static final String ESPACE = " ";
    private static final String ENTETE_HEURE = "heure";
    private static final String ENTETE_DATE = "date";
    private List<Tunnel> tunnels;
    private int NB_CAR = 0;
    private IBusinessService service;
    private DateFormat dateFormat;
    private DateFormat heureFormat;
    private DateFormat dateHeureFormat;

    public CSVComposantFactory(IBusinessService service) {
        Locale locale = new Locale(ConfigurationFactory.getInstance().get("report.lang"));
        this.dateFormat = new SimpleDateFormat(ReportI18n.getString("format.date"), locale);
        this.heureFormat = new SimpleDateFormat(ReportI18n.getString("format.heure"), locale);
        this.dateHeureFormat = new SimpleDateFormat(ReportI18n.getString("format.dateheure"), locale);
        this.service = service;
        if (service != null) {
            this.tunnels = service.getTunnels();
            this.NB_CAR = service.getConfiguration().getInt("csv.export.axe.caracteres.min", 0);
        } else {
            this.tunnels = null;
            this.NB_CAR = 0;
        }
    }

    public Object createView(ChampAlternat c) {
        throw new RuntimeException("not implemented");
    }

    public Object createView(ChampEntier c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        if (!c.isCheckbox() || c.isChecked()) {
            champCSV.setValeur(String.valueOf(c.getValeur()));
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampDecimal c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        if (!c.isCheckbox() || c.isChecked()) {
            champCSV.setValeur(String.valueOf(c.getValeur()));
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampDropListe c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampLabel c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    private String getLibelleChamp(ChampCSV c, String defaut) {
        if (c != null) {
            return ReportI18n.getString("champ.csv." + c.getCode() + ".libelle", defaut);
        }
        return c.getLibelle();
    }

    public Object createView(ChampLocalisation c) {
        PointParticulier pp;
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        boolean axe = c.getAxe() != null;
        boolean sensPr = axe && c.getSensPr() != -1;
        int sensPrRapport = 0;
        switch (c.getSensPr()) {
            case -1: {
                sensPrRapport = 0;
                break;
            }
            case 1: {
                sensPrRapport = 1;
                break;
            }
            case 0: {
                sensPrRapport = 2;
                break;
            }
            case 2: {
                sensPrRapport = 3;
            }
        }
        boolean prDebut = sensPr && c.getPrDebut() != -1;
        boolean absPrDebut = prDebut && c.getAbsPrDebut() != -1;
        boolean prFin = sensPr && c.getPrFin() != -1;
        boolean absPrFin = prFin && c.getAbsPrFin() != -1;
        boolean adresseDebut = !GLS.estVide((String)c.getAdresseDebut());
        ChampCSV champCSV = new ChampCSV();
        champCSV.setCode("axe");
        champCSV.setLibelle(this.getLibelleChamp(champCSV, "axe"));
        champCSV.setValeur(axe ? this.formatAxe(c.getAxe()) : "");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setCode("voie");
        champCSV.setLibelle("voie");
        champCSV.setValeur(!GLS.estVide((String)c.getVoie()) ? c.getVoie() : "");
        champsCSV.add(champCSV);
        if (prDebut) {
            champCSV = new ChampCSV();
            champCSV.setCode("sensPR");
            champCSV.setLibelle("sensPR");
            champCSV.setValeur(sensPr ? "" + sensPrRapport : "");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setCode("DptPRDebut");
            champCSV.setLibelle("DptPRDebut");
            champCSV.setValeur(c.getDeptDebut() != null && !GLS.egal((String)c.getDeptDebut(), (String)"-1") ? c.getDeptDebut() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setCode("PRDebut");
            champCSV.setLibelle(this.getLibelleChamp(champCSV, "PRDebut"));
            champCSV.setValeur(prDebut ? "" + c.getPrDebut() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setCode("AbsPRDebut");
            champCSV.setLibelle(this.getLibelleChamp(champCSV, "AbsPRDebut"));
            champCSV.setValeur(absPrDebut ? "" + c.getAbsPrDebut() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("DptPRFin");
            champCSV.setCode("DptPRFin");
            champCSV.setValeur(c.getDeptFin() != null && !GLS.egal((String)c.getDeptFin(), (String)"-1") ? c.getDeptFin() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle(this.getLibelleChamp(champCSV, "PRFin"));
            champCSV.setCode("PRFin");
            champCSV.setValeur(prFin ? "" + c.getPrFin() : "");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("AbsPRFin");
            champCSV.setCode("AbsPRFin");
            champCSV.setValeur(absPrFin ? "" + c.getAbsPrFin() : "");
            champsCSV.add(champCSV);
        }
        champCSV = new ChampCSV();
        champCSV.setLibelle("Longueur");
        champCSV.setCode("Longueur");
        champCSV.setValeur(absPrFin ? "" + c.getLongueur() : "0");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setCode("Commune");
        champCSV.setLibelle(this.getLibelleChamp(champCSV, "Commune"));
        champCSV.setValeur(c.getCommune() == null ? "" : c.getCommune());
        champsCSV.add(champCSV);
        if (adresseDebut) {
            champCSV = new ChampCSV();
            champCSV.setLibelle("AdresseDebut");
            champCSV.setCode("AdresseDebut");
            champCSV.setValeur(c.getAdresseDebut() == null ? "" : c.getAdresseDebut());
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("AdresseFin");
            champCSV.setCode("AdresseFin");
            champCSV.setValeur(c.getAdresseFin() == null ? "" : c.getAdresseFin());
            champsCSV.add(champCSV);
        }
        champCSV = new ChampCSV();
        champCSV.setLibelle("CoordDebut");
        champCSV.setCode("CoordDebut");
        champCSV.setValeur(c.getPositionDebut() != null ? String.valueOf(c.getPositionDebut().getX()) + ESPACE + c.getPositionDebut().getY() : "");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("XDebut");
        champCSV.setCode("XDebut");
        champCSV.setValeur(c.getPositionDebut() != null ? "" + c.getPositionDebut().getX() : "");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("YDebut");
        champCSV.setCode("YDebut");
        champCSV.setValeur(c.getPositionDebut() != null ? "" + c.getPositionDebut().getY() : "");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("CoordFin");
        champCSV.setCode("CoordFin");
        champCSV.setValeur(c.getPositionFin() != null ? String.valueOf(c.getPositionFin().getX()) + ESPACE + c.getPositionFin().getY() : "");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("XFin");
        champCSV.setCode("XFin");
        champCSV.setValeur(c.getPositionFin() != null ? "" + c.getPositionFin().getX() : "");
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("YFin");
        champCSV.setCode("YFin");
        champCSV.setValeur(c.getPositionFin() != null ? "" + c.getPositionFin().getY() : "");
        champsCSV.add(champCSV);
        if (!GLS.estVide((String)c.getCategorie())) {
            champCSV = new ChampCSV();
            champCSV.setLibelle("Cat\u00e9gorie");
            champCSV.setCode("Cat\u00e9gorie");
            champCSV.setValeur(c.getCategorie());
            champsCSV.add(champCSV);
        }
        if (!GLS.estVide((String)c.getTrafic())) {
            champCSV = new ChampCSV();
            champCSV.setLibelle("Trafic");
            champCSV.setCode("Trafic");
            champCSV.setValeur(c.getTrafic());
            champsCSV.add(champCSV);
        }
        if (!GLS.estVide((String)c.getComplementLocalisation())) {
            champCSV = new ChampCSV();
            champCSV.setLibelle("Compl\u00e9ment \u00e0 la localisation");
            champCSV.setCode("Compl\u00e9ment \u00e0 la localisation");
            champCSV.setValeur(c.getComplementLocalisation());
            champsCSV.add(champCSV);
        }
        if (!GLS.estVide((String)c.getDirection())) {
            champCSV = new ChampCSV();
            champCSV.setLibelle("Direction");
            champCSV.setCode("Direction");
            champCSV.setValeur(c.getDirection());
            champsCSV.add(champCSV);
        }
        if (c.getPointParticulier() != -1 && !GLS.estVide(this.tunnels) && (pp = MetierCommun.getPointParticulier((int)c.getPointParticulier(), this.tunnels)) != null) {
            Tunnel tunnel = MetierCommun.getTunnel((int)pp.getTunnel(), this.tunnels);
            Tube tube = MetierCommun.getTube((int)pp.getTube(), this.tunnels);
            if (tunnel != null && !GLS.estVide((String)tunnel.getLibelle())) {
                champCSV = new ChampCSV();
                champCSV.setLibelle("Tunnel");
                champCSV.setCode("Tunnel");
                champCSV.setValeur(tunnel.getLibelle());
                champsCSV.add(champCSV);
            }
            if (tube != null && !GLS.estVide((String)tube.getLibelle())) {
                champCSV = new ChampCSV();
                champCSV.setLibelle("Sens tunnel");
                champCSV.setCode("Sens tunnel");
                champCSV.setValeur(tube.getLibelle());
                champsCSV.add(champCSV);
            }
            if (!GLS.estVide((String)pp.getLibelle())) {
                champCSV = new ChampCSV();
                champCSV.setLibelle("Point particulier tunnel");
                champCSV.setCode("Point particulier tunnel");
                champCSV.setValeur(pp.getLibelle());
                champsCSV.add(champCSV);
            }
        }
        return champsCSV;
    }

    public Object createView(ChampMultiCheckBox c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setCode(c.getNom());
        if (c.getValeurs().size() == 1) {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle((String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            } else {
                champCSV.setLibelle(String.valueOf(c.getLibelle()) + " - " + (String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            }
        } else {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle(c.getNom());
            } else {
                champCSV.setLibelle(c.getLibelle());
            }
            String valeur = "";
            for (String item : c.getValeursSelectionnee()) {
                valeur = String.valueOf(valeur) + ESPACE + item;
            }
            if (c.getAutreValeur() != null) {
                valeur = String.valueOf(valeur) + ESPACE + c.getAutreValeur().replace("\"", "\"\"");
            }
            champCSV.setValeur(valeur);
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampChoixImageMultiple c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setCode(c.getNom());
        if (c.getValeurs().size() == 1) {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle((String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            } else {
                champCSV.setLibelle(String.valueOf(c.getLibelle()) + " - " + (String)c.getValeurs().get(0));
                if (!c.getValeursSelectionnee().isEmpty()) {
                    champCSV.setValeur(ReportI18n.getString("oui"));
                } else {
                    champCSV.setValeur(ReportI18n.getString("non"));
                }
            }
        } else {
            if (c.getLibelle() == null || c.getLibelle().isEmpty()) {
                champCSV.setLibelle(c.getNom());
            } else {
                champCSV.setLibelle(c.getLibelle());
            }
            String valeur = "";
            for (String item : c.getValeursSelectionnee()) {
                valeur = String.valueOf(valeur) + ESPACE + item;
            }
            if (c.getAutreValeur() != null) {
                valeur = String.valueOf(valeur) + ESPACE + c.getAutreValeur().replace("\"", "\"\"");
            }
            champCSV.setValeur(valeur);
        }
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampMultiple c) {
        ArrayList champsCSV = new ArrayList();
        for (Champ champ : c.getChamps()) {
            List champsTmp = (List)champ.getView((IComposantFactory)this);
            for (ChampCSV ccsv : champsTmp) {
                if (GLS.estVide((String)c.getLibelle())) {
                    ccsv.setLibelle(String.valueOf(c.getNom()) + " - " + ccsv.getLibelle());
                    continue;
                }
                if (c.getLibelle().contains(" - ")) continue;
                ccsv.setLibelle(String.valueOf(c.getLibelle()) + " - " + ccsv.getLibelle());
            }
            champsCSV.addAll(champsTmp);
        }
        return champsCSV;
    }

    public Object createView(ChampRadioBouton c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeurSelectionnee());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampTexte c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur() == null ? "" : c.getValeur().replace("\"", "\"\""));
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampVraiFaux c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeur() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampVehiculeEnCause c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle("VehiculesLegers");
        champCSV.setCode("VehiculesLegers");
        champCSV.setValeur("" + c.getVl());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("PoidsLourds");
        champCSV.setCode("PoidsLourds");
        champCSV.setValeur("" + c.getPl());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("TransportsEnCommun");
        champCSV.setCode("TransportsEnCommun");
        champCSV.setValeur("" + c.getVtc());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Motos");
        champCSV.setCode("Motos");
        champCSV.setValeur("" + c.getMoto());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Velos");
        champCSV.setCode("Velos");
        champCSV.setValeur("" + c.getVelo());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("TransportMatiereDangereuse");
        champCSV.setCode("TransportMatiereDangereuse");
        champCSV.setValeur("" + c.getTmd());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("PietonsCycles");
        champCSV.setCode("PietonsCycles");
        champCSV.setValeur("" + c.getPietonCycle());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("CampingCars");
        champCSV.setCode("CampingCars");
        champCSV.setValeur("" + c.getCampingCar());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Deuxroues");
        champCSV.setCode("Deuxroues");
        champCSV.setValeur("" + c.getDeuxRoues());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Scooter");
        champCSV.setCode("Scooter");
        champCSV.setValeur("" + c.getScooter());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Caravane");
        champCSV.setCode("Caravane");
        champCSV.setValeur("" + c.getCaravane());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Train");
        champCSV.setCode("Train");
        champCSV.setValeur("" + c.getTrain());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Tramway");
        champCSV.setCode("Tramway");
        champCSV.setValeur("" + c.getTramway());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("EnginsAgricoles");
        champCSV.setCode("EnginsAgricoles");
        champCSV.setValeur("" + c.getEnginAgricole());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Animaux");
        champCSV.setCode("Animaux");
        champCSV.setValeur("" + c.getAnimaux());
        champsCSV.add(champCSV);
        champCSV = new ChampCSV();
        champCSV.setLibelle("Autres");
        champCSV.setCode("Autres");
        champCSV.setValeur("" + c.getAutres());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampDate c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        if (c.isChecked() && c.getAnnee() != 3) {
            GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour());
            ChampCSV champCSV = new ChampCSV();
            champCSV.setLibelle(c.getLibelle());
            champCSV.setCode(c.getNom());
            champCSV.setValeur(this.dateFormat.format(cal.getTime()));
            champsCSV.add(champCSV);
        }
        return champsCSV;
    }

    public Object createView(ChampDateHeure c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        if (c.isChecked() && c.getAnnee() != 3) {
            if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
                GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour(), c.getHeure(), c.getMinute());
                ChampCSV champCSVDate = new ChampCSV();
                champCSVDate.setLibelle(String.valueOf(c.getLibelle()) + "-" + ENTETE_DATE);
                champCSVDate.setCode(c.getNom().concat(ENTETE_DATE));
                champCSVDate.setValeur(this.dateFormat.format(cal.getTime()));
                champsCSV.add(champCSVDate);
                ChampCSV champCSVHeure = new ChampCSV();
                champCSVHeure.setLibelle(String.valueOf(c.getLibelle()) + "-" + ENTETE_HEURE);
                champCSVHeure.setCode(c.getNom().concat(ENTETE_HEURE));
                champCSVHeure.setValeur(this.heureFormat.format(cal.getTime()));
                champsCSV.add(champCSVHeure);
            } else {
                GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour(), c.getHeure(), c.getMinute());
                ChampCSV champCSV = new ChampCSV();
                champCSV.setLibelle(c.getLibelle());
                champCSV.setCode(c.getNom());
                champCSV.setValeur(this.dateHeureFormat.format(cal.getTime()));
                champsCSV.add(champCSV);
            }
        }
        return champsCSV;
    }

    public Object createView(ChampHeure c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        if (c.isChecked()) {
            GregorianCalendar cal = new GregorianCalendar(0, 0, 0, c.getHeure(), c.getMinute());
            ChampCSV champCSV = new ChampCSV();
            champCSV.setLibelle(c.getLibelle());
            champCSV.setCode(c.getNom());
            champCSV.setValeur(this.heureFormat.format(cal.getTime()));
            champsCSV.add(champCSV);
        }
        return champsCSV;
    }

    public void setChampLectureSeule(boolean lectureSeule) {
    }

    public Object createView(ChampPatrouilleProcedure c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        if (this.competenceVide(c)) {
            ChampCSV champCSV = new ChampCSV();
            champCSV.setLibelle("Competence");
            champCSV.setCode("Competence");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("Urgence");
            champCSV.setCode("Urgence");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("ActionImmediate");
            champCSV.setCode("ActionImmediate");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("MesurePrise");
            champCSV.setCode("MesurePrise");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("CompteRenduFait");
            champCSV.setCode("CompteRenduFait");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
        } else if (this.competenceCg(c)) {
            ChampCSV champCSV = new ChampCSV();
            champCSV.setLibelle("Competence");
            champCSV.setCode("Competence");
            champCSV.setValeur(c.getValeur().getCompetence());
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("Urgence");
            champCSV.setCode("Urgence");
            champCSV.setValeur(c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
            champsCSV.add(champCSV);
            if (c.getValeur().isUrgence()) {
                champCSV = new ChampCSV();
                champCSV.setLibelle("ActionImmediate");
                champCSV.setCode("ActionImmediate");
                champCSV.setValeur(c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                champsCSV.add(champCSV);
                champCSV = new ChampCSV();
                champCSV.setLibelle("MesurePrise");
                champCSV.setCode("MesurePrise");
                champCSV.setValeur(c.getValeur().getMesure());
                champsCSV.add(champCSV);
                champCSV = new ChampCSV();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur("");
                champsCSV.add(champCSV);
            } else {
                champCSV = new ChampCSV();
                champCSV.setLibelle("ActionImmediate");
                champCSV.setCode("ActionImmediate");
                champCSV.setValeur("");
                champsCSV.add(champCSV);
                champCSV = new ChampCSV();
                champCSV.setLibelle("MesurePrise");
                champCSV.setCode("MesurePrise");
                champCSV.setValeur("");
                champsCSV.add(champCSV);
                champCSV = new ChampCSV();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur("");
                champsCSV.add(champCSV);
            }
        } else {
            ChampCSV champCSV = new ChampCSV();
            champCSV.setLibelle("Competence");
            champCSV.setCode("Competence");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("Urgence");
            champCSV.setCode("Urgence");
            champCSV.setValeur(c.getValeur().isUrgence() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("ActionImmediate");
            champCSV.setCode("ActionImmediate");
            champCSV.setValeur(c.getValeur().getImmediate() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("MesurePrise");
            champCSV.setCode("MesurePrise");
            champCSV.setValeur(c.getValeur().getMesure());
            champsCSV.add(champCSV);
            champCSV = new ChampCSV();
            champCSV.setLibelle("CompteRenduFait");
            champCSV.setCode("CompteRenduFait");
            champCSV.setValeur("");
            champsCSV.add(champCSV);
            if (c.getValeur().getCompteRendu()) {
                champCSV = new ChampCSV();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur(c.getValeur().getCompetence());
                champsCSV.add(champCSV);
            } else {
                champCSV = new ChampCSV();
                champCSV.setLibelle("CompteRenduFait");
                champCSV.setCode("CompteRenduFait");
                champCSV.setValeur("");
                champsCSV.add(champCSV);
            }
        }
        return champsCSV;
    }

    private boolean competenceVide(ChampPatrouilleProcedure champ) {
        return champ.getValeur().getCompetence() == null || champ.getValeur().getCompetence().equals("");
    }

    private boolean competenceCg(ChampPatrouilleProcedure champ) {
        String competenceCg = champ.getCompetenceCg();
        String competenceSelect = champ.getValeur().getCompetence();
        boolean isCompetenceCg = competenceCg.equals(competenceSelect);
        return isCompetenceCg;
    }

    public Object createView(ChampChoixImage c) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(c.getLibelle());
        champCSV.setCode(c.getNom());
        champCSV.setValeur(c.getValeurSelectionnee());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampImages champImage) {
        return null;
    }

    public Object createView(ChampSignature champSignature) {
        return null;
    }

    public Object createView(ChampDocuments champDocuements) {
        return null;
    }

    public Object createView(ChampCoucheBox champCoucheBox) {
        ArrayList<ChampCSV> champsCSV = new ArrayList<ChampCSV>();
        ChampCSV champCSV = new ChampCSV();
        champCSV.setLibelle(champCoucheBox.getLibelle());
        champCSV.setCode(champCoucheBox.getNom());
        champCSV.setValeur(champCoucheBox.getNomCouche());
        champsCSV.add(champCSV);
        return champsCSV;
    }

    public Object createView(ChampOneDrive champOneDrive) {
        return null;
    }

    private String formatAxe(String axe) {
        if (axe.length() >= this.NB_CAR) {
            return axe;
        }
        String[] axeDecompose = axe.split("(?=\\d)(?<=\\D)(?=\\d)");
        if (axeDecompose.length < 2) {
            return axe;
        }
        String retour = "";
        if (axeDecompose.length == 2) {
            retour = axeDecompose[0];
            int i = axe.length();
            while (i < this.NB_CAR) {
                retour = String.valueOf(retour) + "0";
                ++i;
            }
            retour = String.valueOf(retour) + axeDecompose[1];
        } else {
            retour = String.valueOf(axeDecompose[0]) + axeDecompose[1];
            int i = axe.length();
            while (i < this.NB_CAR) {
                retour = String.valueOf(retour) + "0";
                ++i;
            }
            retour = String.valueOf(retour) + axeDecompose[2];
        }
        return retour;
    }
}

