/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.apachepoi;

import com.geolocsystems.prismbirtbean.PatrouilleSemaineBean;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineCentreBean;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineDelegationBean;
import com.geolocsystems.prismbirtbean.PatrouilleSemaineList;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.factory.ApacheFactory;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class APPatrouilleSemaineExport {
    private IBusinessService businessService;
    private PatrouilleSemaineList patrouilleSemaineList;
    private boolean exportInPdf = false;

    public APPatrouilleSemaineExport(IBusinessService services) {
        this.businessService = services;
    }

    public InputStream export(PatrouilleSemaineList patrouilleSemaineList, String format) {
        this.patrouilleSemaineList = patrouilleSemaineList;
        this.exportInPdf = format.endsWith("PDF");
        return this.runReport();
    }

    private InputStream runReport() {
        BufferedInputStream retour = null;
        ApacheFactory factory = new ApacheFactory();
        XSSFWorkbook workbook = null;
        try {
            workbook = new XSSFWorkbook();
            XSSFSheet dataSheet = workbook.createSheet("DPEE_TTISR_TAB_SuiviUtilisation");
            XSSFCellStyle cswrap = workbook.createCellStyle();
            cswrap.setWrapText(true);
            cswrap.setAlignment(HorizontalAlignment.CENTER);
            cswrap.setBorderTop(BorderStyle.THIN);
            cswrap.setBorderBottom(BorderStyle.THIN);
            cswrap.setBorderLeft(BorderStyle.THIN);
            cswrap.setBorderRight(BorderStyle.THIN);
            IndexedColorMap colorMap = workbook.getStylesSource().getIndexedColors();
            HashMap<Integer, XSSFColor> colors = new HashMap<Integer, XSSFColor>();
            colors.put(0, new XSSFColor(new Color(255, 255, 102), colorMap));
            colors.put(1, new XSSFColor(new Color(153, 255, 255), colorMap));
            colors.put(2, new XSSFColor(new Color(51, 255, 153), colorMap));
            HashMap<Integer, XSSFCellStyle> cstitles = new HashMap<Integer, XSSFCellStyle>();
            int index = 0;
            while (index < 3) {
                XSSFCellStyle cstitle = workbook.createCellStyle();
                cstitle.setFillForegroundColor((XSSFColor)colors.get(index));
                cstitle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                cstitle.setAlignment(HorizontalAlignment.CENTER);
                cstitle.setBorderTop(BorderStyle.THIN);
                cstitle.setBorderBottom(BorderStyle.THIN);
                cstitle.setBorderLeft(BorderStyle.THIN);
                cstitle.setBorderRight(BorderStyle.THIN);
                cstitles.put(index, cstitle);
                ++index;
            }
            XSSFCellStyle cscenter = workbook.createCellStyle();
            cscenter.setAlignment(HorizontalAlignment.CENTER);
            cscenter.setBorderTop(BorderStyle.THIN);
            cscenter.setBorderBottom(BorderStyle.THIN);
            cscenter.setBorderLeft(BorderStyle.THIN);
            cscenter.setBorderRight(BorderStyle.THIN);
            XSSFCellStyle csright = workbook.createCellStyle();
            csright.setFillForegroundColor(new XSSFColor(new Color(204, 204, 204), colorMap));
            csright.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            csright.setAlignment(HorizontalAlignment.RIGHT);
            XSSFCellStyle csleft = workbook.createCellStyle();
            csleft.setBorderTop(BorderStyle.THIN);
            csleft.setBorderBottom(BorderStyle.THIN);
            csleft.setBorderLeft(BorderStyle.THIN);
            csleft.setBorderRight(BorderStyle.THIN);
            dataSheet.createRow(0);
            dataSheet.createRow(1);
            dataSheet.createRow(2);
            dataSheet.getRow(0).createCell(0);
            dataSheet.getRow(0).getCell(0).setCellValue("Utilisation tablette / CEI et PA *");
            dataSheet.addMergedRegion(new CellRangeAddress(0, 2, 0, 0));
            dataSheet.getRow(0).getCell(0).setCellStyle((CellStyle)cswrap);
            int indexCentre = 0;
            int indexDelegation = 0;
            int indexDelegationPrecedent = 0;
            HashMap<Object, Integer> indexCentreMap = new HashMap<Object, Integer>();
            for (String delegation : this.patrouilleSemaineList.getDelegations()) {
                CellStyle cstitle = (CellStyle)cstitles.get(indexDelegation % cstitles.size());
                indexDelegationPrecedent = indexCentre * 3 + 1;
                dataSheet.getRow(0).createCell(indexCentre * 3 + 1);
                dataSheet.getRow(0).createCell(indexCentre * 3 + 2);
                dataSheet.getRow(0).getCell(indexCentre * 3 + 1).setCellValue(delegation);
                dataSheet.getRow(0).getCell(indexCentre * 3 + 1).setCellStyle(cstitle);
                for (Object centre : (ArrayList)this.patrouilleSemaineList.getCentres().get(delegation)) {
                    dataSheet.getRow(1).createCell(indexCentre * 3 + 1);
                    dataSheet.getRow(1).createCell(indexCentre * 3 + 2);
                    dataSheet.getRow(1).createCell(indexCentre * 3 + 3);
                    dataSheet.getRow(2).createCell(indexCentre * 3 + 1);
                    dataSheet.getRow(2).createCell(indexCentre * 3 + 2);
                    dataSheet.getRow(2).createCell(indexCentre * 3 + 3);
                    dataSheet.getRow(1).getCell(indexCentre * 3 + 1).setCellValue((String)centre);
                    dataSheet.getRow(1).getCell(indexCentre * 3 + 1).setCellStyle(cstitle);
                    dataSheet.getRow(1).getCell(indexCentre * 3 + 2).setCellStyle(cstitle);
                    dataSheet.getRow(1).getCell(indexCentre * 3 + 3).setCellStyle(cstitle);
                    dataSheet.addMergedRegion(new CellRangeAddress(1, 1, indexCentre * 3 + 1, indexCentre * 3 + 3));
                    dataSheet.getRow(2).getCell(indexCentre * 3 + 1).setCellValue("Patrouille");
                    dataSheet.getRow(2).getCell(indexCentre * 3 + 1).setCellStyle(cstitle);
                    dataSheet.getRow(2).getCell(indexCentre * 3 + 2).setCellValue("Nb evts cr\u00e9es");
                    dataSheet.getRow(2).getCell(indexCentre * 3 + 2).setCellStyle(cstitle);
                    dataSheet.getRow(2).getCell(indexCentre * 3 + 3).setCellValue("Nb evts clotur\u00e9s");
                    dataSheet.getRow(2).getCell(indexCentre * 3 + 3).setCellStyle(cstitle);
                    indexCentreMap.put(centre, indexCentre);
                    ++indexCentre;
                }
                ++indexDelegation;
                dataSheet.addMergedRegion(new CellRangeAddress(0, 0, indexDelegationPrecedent, indexCentre * 3));
            }
            int anneePrec = 0;
            int indexSemaine = 0;
            for (PatrouilleSemaineBean beanSemaine : this.patrouilleSemaineList.getPatrouilleSemaineBeanList()) {
                if (anneePrec != beanSemaine.getAnnee()) {
                    anneePrec = beanSemaine.getAnnee();
                    dataSheet.createRow(indexSemaine + 3);
                    dataSheet.getRow(indexSemaine + 3).createCell(0);
                    dataSheet.getRow(indexSemaine + 3).getCell(0).setCellValue((double)anneePrec);
                    dataSheet.getRow(indexSemaine + 3).getCell(0).setCellStyle((CellStyle)csright);
                    dataSheet.getRow(indexSemaine + 3).createCell(1);
                    dataSheet.addMergedRegion(new CellRangeAddress(indexSemaine + 3, indexSemaine + 3, 1, indexCentre * 3));
                    dataSheet.getRow(indexSemaine + 3).getCell(1).setCellStyle((CellStyle)csright);
                    ++indexSemaine;
                }
                dataSheet.createRow(indexSemaine + 3);
                dataSheet.getRow(indexSemaine + 3).createCell(0);
                dataSheet.getRow(indexSemaine + 3).getCell(0).setCellValue("Semaine " + beanSemaine.getNumSemaine());
                dataSheet.getRow(indexSemaine + 3).getCell(0).setCellStyle((CellStyle)csleft);
                int indexCell = 1;
                while (indexCell <= indexCentre * 3) {
                    dataSheet.getRow(indexSemaine + 3).createCell(indexCell);
                    dataSheet.getRow(indexSemaine + 3).getCell(indexCell).setCellValue("non");
                    dataSheet.getRow(indexSemaine + 3).getCell(indexCell).setCellStyle((CellStyle)cscenter);
                    ++indexCell;
                }
                for (String key : indexCentreMap.keySet()) {
                    Log.debug(key);
                }
                for (PatrouilleSemaineDelegationBean beanDelegation : beanSemaine.getDelegationsBean()) {
                    for (PatrouilleSemaineCentreBean beanCentre : beanDelegation.getCentres()) {
                        Log.debug(String.valueOf(beanDelegation.getNomDelegation()) + beanCentre.getNomCentre());
                        int index2 = (Integer)indexCentreMap.get(beanCentre.getNomCentre());
                        dataSheet.getRow(indexSemaine + 3).getCell(index2 * 3 + 1).setCellValue(beanCentre.getPatrouille() > 0 ? "oui" : "non");
                        dataSheet.getRow(indexSemaine + 3).getCell(index2 * 3 + 2).setCellValue((double)beanCentre.getNbEvtsCrees());
                        dataSheet.getRow(indexSemaine + 3).getCell(index2 * 3 + 3).setCellValue((double)beanCentre.getNbEvtsClotures());
                    }
                }
                ++indexSemaine;
            }
            int i = 0;
            while (i <= indexCentre * 3) {
                dataSheet.autoSizeColumn(i);
                ++i;
            }
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)workbook);
            String fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("dir.tmp")) + "/" + System.nanoTime() + ".xlsx";
            FileOutputStream output = new FileOutputStream(fileDestination);
            workbook.write((OutputStream)output);
            ((OutputStream)output).close();
            workbook.close();
            File outfile = new File(fileDestination);
            try {
                retour = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("Done");
        }
        catch (FileNotFoundException e) {
            Log.error("FileNotFoundException", e);
        }
        catch (IOException e) {
            Log.error("IOException", e);
        }
        catch (Exception e) {
            Log.error("Exception", e);
        }
        workbook = null;
        System.out.println("End");
        return retour;
    }
}

