/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.apachepoi;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class APFactory {
    static String[] codes = new String[]{"delegation", "centre", "recepteurAppel", "appelSortant", "dateCreation", "periodeIntervention", "declenchementIntervention", "axe", "PRDebut", "AbsPRDebut", "Commune", "agglo", "Nature", "dateDeclenchementInterventionHeure", "dateArriveeSiteHeure", "dateDepartSiteHeure", "dateFinInterventionHeure", "dureeIntervention", "commentaire", "typeIntervention", "moment", "nbVoie", "trafficMoyen", "partPoidsLourds", "vitesseRegl", "vitessePrat", "ptSingulier", "distanceVisibiliteSens1", "distanceVisibiliteSens2", "presencePietons", "presenceCyclistes", "presenceBus", "presenceTransportsExc", "voieEstOuest", "nbVoieFerrees", "nbTrainMoyen", "periodeExploitationDebut", "periodeExploitationFin", "vitesseLimite", "ligneElectrifiee", "nbCollisionsTrain", "nbHeurt", "nbTue", "nbCollisionsNuit", "inscritPSN", "PNNum", "pk", "enAgglo", "departement", "routeOuVoie", "nomLigneFerroviaire", "dateDiagdate", "dateDiagheure", "classement", "typePN", "largeurChausseePN", "longueurPNBarriere", "angleVFRoute", "profilDifficile", "fermetureProlongees", "natureEnvironnement", "descriptionEnvironnement", "activites", "panneauxPub", "eclairagePublic", "projetEnCours", "projetEnCoursDetail", "commentairesEnvironnement", "PNGeometrieI1Sens1", "PNGeometrieI1Sens2", "PNGeometrieI1Commentaire", "PNGeometrieI1Actions", "PNGeometrieI1SuiteDonneeRetenue", "PNGeometrieI1SuiteDonneeDate", "PNGeometrieI1SuiteDonneeGestionnaire", "PNGeometrieI2Sens1", "PNGeometrieI2Sens2", "PNGeometrieI2Commentaire", "PNGeometrieI2Actions", "PNGeometrieI2SuiteDonneeRetenue", "PNGeometrieI2SuiteDonneeDate", "PNGeometrieI2SuiteDonneeGestionnaire", "PNGeometrieI3Sens1", "PNGeometrieI3Sens2", "PNGeometrieI3Commentaire", "PNGeometrieI3Actions", "PNGeometrieI3SuiteDonneeRetenue", "PNGeometrieI3SuiteDonneeDate", "PNGeometrieI3SuiteDonneeGestionnaire", "PNVisibiliteII1Sens1", "PNVisibiliteII1Sens2", "PNVisibiliteII1Commentaire", "PNVisibiliteII1Actions", "PNVisibiliteII1SuiteDonneeRetenue", "PNVisibiliteII1SuiteDonneeDate", "PNVisibiliteII1SuiteDonneeGestionnaire", "PNVisibiliteII2Sens1", "PNVisibiliteII2Sens2", "PNVisibiliteII2Commentaire", "PNVisibiliteII2Actions", "PNVisibiliteII2SuiteDonneeRetenue", "PNVisibiliteII2SuiteDonneeDate", "PNVisibiliteII2SuiteDonneeGestionnaire", "PNVisibiliteII3Sens1", "PNVisibiliteII3Sens2", "PNVisibiliteII3Commentaire", "PNVisibiliteII3Actions", "PNVisibiliteII3SuiteDonneeRetenue", "PNVisibiliteII3SuiteDonneeDate", "PNVisibiliteII3SuiteDonneeGestionnaire", "PNLisibiliteIII1Sens1", "PNLisibiliteIII1Sens2", "PNLisibiliteIII1Commentaire", "PNLisibiliteIII1Actions", "PNLisibiliteIII1SuiteDonneeRetenue", "PNLisibiliteIII1SuiteDonneeDate", "PNLisibiliteIII1SuiteDonneeGestionnaire", "PNLisibiliteIII2Sens1", "PNLisibiliteIII2Sens2", "PNLisibiliteIII2Commentaire", "PNLisibiliteIII2Actions", "PNLisibiliteIII2SuiteDonneeRetenue", "PNLisibiliteIII2SuiteDonneeDate", "PNLisibiliteIII2SuiteDonneeGestionnaire", "PNLisibiliteIII3Sens1", "PNLisibiliteIII3Sens2", "PNLisibiliteIII3Commentaire", "PNLisibiliteIII3Actions", "PNLisibiliteIII3SuiteDonneeRetenue", "PNLisibiliteIII3SuiteDonneeDate", "PNLisibiliteIII3SuiteDonneeGestionnaire", "PNLisibiliteIII4Sens1", "PNLisibiliteIII4Sens2", "PNLisibiliteIII4Commentaire", "PNLisibiliteIII4Actions", "PNLisibiliteIII4SuiteDonneeRetenue", "PNLisibiliteIII4SuiteDonneeDate", "PNLisibiliteIII4SuiteDonneeGestionnaire", "PNModesActifsIV1Sens1", "PNModesActifsIV1Sens2", "PNModesActifsIV1Commentaire", "PNModesActifsIV1Actions", "PNModesActifsIV1SuiteDonneeRetenue", "PNModesActifsIV1SuiteDonneeDate", "PNModesActifsIV1SuiteDonneeGestionnaire", "PNModesActifsIV2Sens1", "PNModesActifsIV2Sens2", "PNModesActifsIV2Commentaire", "PNModesActifsIV2Actions", "PNModesActifsIV2SuiteDonneeRetenue", "PNModesActifsIV2SuiteDonneeDate", "PNModesActifsIV2SuiteDonneeGestionnaire", "PNModesActifsIV3Sens1", "PNModesActifsIV3Sens2", "PNModesActifsIV3Commentaire", "PNModesActifsIV3Actions", "PNModesActifsIV3SuiteDonneeRetenue", "PNModesActifsIV3SuiteDonneeDate", "PNModesActifsIV3SuiteDonneeGestionnaire", "PNAutreVSens1", "PNAutreVSens2", "PNAutreVCommentaire", "PNAutreVActions", "PNAutreVSuiteDonneeRetenue", "PNAutreVSuiteDonneeDate", "PNAutreVSuiteDonneeGestionnaire"};

    public static String getValue(Evenement evt, HashMap<String, String> valeurs, String code) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        switch (code) {
            case "delegation": {
                return evt.getDistrict();
            }
            case "centre": {
                return evt.getCei();
            }
            case "dateCreation": {
                return sdfDate.format(new Date(evt.getDateCreation()));
            }
            case "periodeIntervention": {
                return valeurs.get("periodeIntervention");
            }
            case "declenchementIntervention": {
                return valeurs.get("declenchementIntervention");
            }
            case "axe": {
                return evt.getLocalisation().getAxe();
            }
            case "PRDebut": {
                return "" + evt.getLocalisation().getPrDebut();
            }
            case "AbsPRDebut": {
                return "" + evt.getLocalisation().getAbsPrDebut();
            }
            case "Commune": {
                return evt.getLocalisation().getCommune();
            }
            case "dureeIntervention": {
                try {
                    String[] dateDebut = valeurs.get("dateDeclenchementInterventionheure").split(":");
                    String[] dateFin = valeurs.get("dateFinInterventionheure").split(":");
                    Integer diffHeure = Integer.valueOf(dateFin[0]) - Integer.valueOf(dateDebut[0]);
                    Integer diffMinutes = Integer.valueOf(dateFin[1]) - Integer.valueOf(dateDebut[1]);
                    if (diffMinutes < 0) {
                        diffMinutes = diffMinutes + 60;
                        diffHeure = diffHeure + 1;
                    }
                    String diff = "";
                    if (diffHeure < 10) {
                        diff = String.valueOf(diff) + "0";
                    }
                    diff = String.valueOf(diff) + diffHeure + ":";
                    if (diffMinutes < 10) {
                        diff = String.valueOf(diff) + "0";
                    }
                    diff = String.valueOf(diff) + diffMinutes;
                    return diff;
                }
                catch (Exception e) {
                    Log.debug(e.getLocalizedMessage());
                    return "";
                }
            }
        }
        return valeurs.get(code);
    }
}

