/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export.apachepoi;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.StatsCamionsVHBean;
import com.geolocsystems.prismcentral.beans.StatsCamionsVHCentreBean;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class APCamionsVHExport {
    private StatsCamionsVHBean statCamions;

    public InputStream export(StatsCamionsVHBean statCamions) {
        this.statCamions = statCamions;
        return this.runReport();
    }

    private InputStream runReport() {
        BufferedInputStream retour = null;
        XSSFWorkbook workbook = null;
        try {
            workbook = new XSSFWorkbook();
            XSSFSheet dataSheet = workbook.createSheet("Statistiques Camions VH");
            XSSFCellStyle cswrap = workbook.createCellStyle();
            cswrap.setWrapText(true);
            cswrap.setAlignment(HorizontalAlignment.CENTER);
            cswrap.setBorderTop(BorderStyle.THIN);
            cswrap.setBorderBottom(BorderStyle.THIN);
            cswrap.setBorderLeft(BorderStyle.THIN);
            cswrap.setBorderRight(BorderStyle.THIN);
            XSSFCellStyle csnormal = workbook.createCellStyle();
            csnormal.setBorderTop(BorderStyle.THIN);
            csnormal.setBorderBottom(BorderStyle.THIN);
            csnormal.setBorderLeft(BorderStyle.THIN);
            csnormal.setBorderRight(BorderStyle.THIN);
            XSSFCellStyle cscenter = workbook.createCellStyle();
            cscenter.setAlignment(HorizontalAlignment.CENTER);
            cscenter.setBorderTop(BorderStyle.THIN);
            cscenter.setBorderBottom(BorderStyle.THIN);
            cscenter.setBorderLeft(BorderStyle.THIN);
            cscenter.setBorderRight(BorderStyle.THIN);
            XSSFCellStyle csmiddle = workbook.createCellStyle();
            csmiddle.setAlignment(HorizontalAlignment.CENTER);
            csmiddle.setVerticalAlignment(VerticalAlignment.CENTER);
            csmiddle.setBorderTop(BorderStyle.THIN);
            csmiddle.setBorderBottom(BorderStyle.THIN);
            csmiddle.setBorderLeft(BorderStyle.THIN);
            csmiddle.setBorderRight(BorderStyle.THIN);
            XSSFCellStyle csright = workbook.createCellStyle();
            csright.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            csright.setAlignment(HorizontalAlignment.RIGHT);
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            Calendar dateDebut = Calendar.getInstance();
            dateDebut.setTime(this.statCamions.getDateDebut());
            Calendar dateFin = Calendar.getInstance();
            dateFin.setTime(this.statCamions.getDateFin());
            List<Calendar> listeDate = this.getDatesBetween(dateDebut, dateFin);
            HashMap<Integer, String> mapMois = new HashMap<Integer, String>();
            mapMois.put(0, "Janvier");
            mapMois.put(1, "F\u00e9vrier");
            mapMois.put(2, "Mars");
            mapMois.put(3, "Avril");
            mapMois.put(4, "Mai");
            mapMois.put(5, "Juin");
            mapMois.put(6, "Juillet");
            mapMois.put(7, "Ao\u00fbt");
            mapMois.put(8, "Septembre");
            mapMois.put(9, "Octobre");
            mapMois.put(10, "Novembre");
            mapMois.put(11, "D\u00e9cembre");
            dataSheet.createRow(0);
            dataSheet.createRow(1);
            dataSheet.createRow(2);
            dataSheet.getRow(1).createCell(0);
            dataSheet.getRow(1).getCell(0).setCellValue("du : " + sdf.format(new Date(this.statCamions.getDateDebut().getTime())) + " au : " + sdf.format(new Date(this.statCamions.getDateFin().getTime())));
            dataSheet.getRow(1).getCell(0).setCellStyle((CellStyle)cscenter);
            dataSheet.getRow(2).createCell(0);
            dataSheet.getRow(2).getCell(0).setCellValue("CEI");
            dataSheet.getRow(2).getCell(0).setCellStyle((CellStyle)cscenter);
            dataSheet.getRow(2).createCell(1);
            dataSheet.getRow(2).getCell(1).setCellValue("Prestation");
            dataSheet.getRow(2).getCell(1).setCellStyle((CellStyle)cscenter);
            int index = 2;
            int lastYear = -1;
            int indexYear = -1;
            int lastMonth = -1;
            int indexMonth = -1;
            HashMap<Calendar, Integer> mapCalendar = new HashMap<Calendar, Integer>();
            for (Calendar dateJour : listeDate) {
                mapCalendar.put(dateJour, index);
                dataSheet.getRow(0).createCell(index);
                dataSheet.getRow(1).createCell(index);
                dataSheet.getRow(2).createCell(index);
                if (lastYear != dateJour.get(1)) {
                    if (indexYear != -1) {
                        dataSheet.addMergedRegion(new CellRangeAddress(0, 0, indexYear, index - 1));
                    }
                    dataSheet.getRow(0).getCell(index).setCellValue((double)dateJour.get(1));
                    lastYear = dateJour.get(1);
                    indexYear = index;
                }
                if (lastMonth != dateJour.get(2)) {
                    if (indexMonth != -1) {
                        dataSheet.addMergedRegion(new CellRangeAddress(1, 1, indexMonth, index - 1));
                    }
                    dataSheet.getRow(1).getCell(index).setCellValue((String)mapMois.get(dateJour.get(2)));
                    lastMonth = dateJour.get(2);
                    indexMonth = index;
                }
                dataSheet.getRow(2).getCell(index).setCellValue((double)dateJour.get(5));
                dataSheet.getRow(0).getCell(index).setCellStyle((CellStyle)cscenter);
                dataSheet.getRow(1).getCell(index).setCellStyle((CellStyle)cscenter);
                dataSheet.getRow(2).getCell(index).setCellStyle((CellStyle)cscenter);
                ++index;
            }
            if (indexYear != -1) {
                dataSheet.addMergedRegion(new CellRangeAddress(0, 0, indexYear, index - 1));
            }
            if (indexMonth != -1) {
                dataSheet.addMergedRegion(new CellRangeAddress(1, 1, indexMonth, index - 1));
            }
            dataSheet.getRow(2).createCell(index);
            dataSheet.getRow(2).getCell(index).setCellValue("Total");
            dataSheet.getRow(2).getCell(index).setCellStyle((CellStyle)cscenter);
            String lastCentre = "";
            int indexCentre = 1;
            int totalCamion = 0;
            int totalCamionDATI = 0;
            int totalCamionCentre = 0;
            int totalCamionDATICentre = 0;
            for (StatsCamionsVHCentreBean centre : this.statCamions.getStatsCentres()) {
                if (!lastCentre.equals(centre.getCentre())) {
                    if (indexCentre > 1) {
                        dataSheet.getRow(indexCentre).createCell(index);
                        dataSheet.getRow(indexCentre).getCell(index).setCellValue((double)totalCamionCentre);
                        dataSheet.getRow(indexCentre).getCell(index).setCellStyle((CellStyle)csnormal);
                        dataSheet.getRow(indexCentre + 1).createCell(index);
                        dataSheet.getRow(indexCentre + 1).getCell(index).setCellValue((double)totalCamionDATICentre);
                        dataSheet.getRow(indexCentre + 1).getCell(index).setCellStyle((CellStyle)csnormal);
                        totalCamion += totalCamionCentre;
                        totalCamionDATI += totalCamionDATICentre;
                        totalCamionCentre = 0;
                        totalCamionDATICentre = 0;
                    }
                    lastCentre = centre.getCentre();
                    dataSheet.createRow(indexCentre += 2);
                    dataSheet.createRow(indexCentre + 1);
                    dataSheet.getRow(indexCentre).createCell(0);
                    dataSheet.getRow(indexCentre + 1).createCell(0);
                    dataSheet.addMergedRegion(new CellRangeAddress(indexCentre, indexCentre + 1, 0, 0));
                    dataSheet.getRow(indexCentre).getCell(0).setCellValue(centre.getCentre());
                    dataSheet.getRow(indexCentre).getCell(0).setCellStyle((CellStyle)csmiddle);
                    dataSheet.getRow(indexCentre).createCell(1);
                    dataSheet.getRow(indexCentre).getCell(1).setCellValue("Sortie camions");
                    dataSheet.getRow(indexCentre).getCell(1).setCellStyle((CellStyle)csnormal);
                    dataSheet.getRow(indexCentre + 1).createCell(1);
                    dataSheet.getRow(indexCentre + 1).getCell(1).setCellValue("DATI");
                    dataSheet.getRow(indexCentre + 1).getCell(1).setCellStyle((CellStyle)csnormal);
                    int indexTmp = 2;
                    for (Calendar dateJour : listeDate) {
                        dataSheet.getRow(indexCentre).createCell(indexTmp);
                        dataSheet.getRow(indexCentre).getCell(indexTmp).setCellValue(0.0);
                        dataSheet.getRow(indexCentre).getCell(indexTmp).setCellStyle((CellStyle)csnormal);
                        dataSheet.getRow(indexCentre + 1).createCell(indexTmp);
                        dataSheet.getRow(indexCentre + 1).getCell(indexTmp).setCellValue(0.0);
                        dataSheet.getRow(indexCentre + 1).getCell(indexTmp).setCellStyle((CellStyle)csnormal);
                        ++indexTmp;
                    }
                }
                int indexCol = (Integer)mapCalendar.get(centre.getDate());
                dataSheet.getRow(indexCentre).createCell(indexCol);
                dataSheet.getRow(indexCentre).getCell(indexCol).setCellValue((double)centre.getCamions());
                dataSheet.getRow(indexCentre).getCell(indexCol).setCellStyle((CellStyle)csnormal);
                dataSheet.getRow(indexCentre + 1).createCell(indexCol);
                dataSheet.getRow(indexCentre + 1).getCell(indexCol).setCellValue((double)centre.getCamionsDati());
                dataSheet.getRow(indexCentre + 1).getCell(indexCol).setCellStyle((CellStyle)csnormal);
                totalCamionCentre += centre.getCamions();
                totalCamionDATICentre += centre.getCamionsDati();
            }
            if (indexCentre > 3) {
                dataSheet.getRow(indexCentre).createCell(index);
                dataSheet.getRow(indexCentre).getCell(index).setCellValue((double)totalCamionCentre);
                dataSheet.getRow(indexCentre).getCell(index).setCellStyle((CellStyle)csnormal);
                dataSheet.getRow(indexCentre + 1).createCell(index);
                dataSheet.getRow(indexCentre + 1).getCell(index).setCellValue((double)totalCamionDATICentre);
                dataSheet.getRow(indexCentre + 1).getCell(index).setCellStyle((CellStyle)csnormal);
                totalCamion += totalCamionCentre;
                totalCamionDATI += totalCamionDATICentre;
                totalCamionCentre = 0;
                totalCamionDATICentre = 0;
            }
            dataSheet.createRow(indexCentre += 2);
            dataSheet.createRow(indexCentre + 1);
            dataSheet.getRow(indexCentre).createCell(0);
            dataSheet.getRow(indexCentre + 1).createCell(0);
            dataSheet.addMergedRegion(new CellRangeAddress(indexCentre, indexCentre + 1, 0, 0));
            dataSheet.getRow(indexCentre).getCell(0).setCellValue("Total");
            dataSheet.getRow(indexCentre).getCell(0).setCellStyle((CellStyle)csmiddle);
            dataSheet.getRow(indexCentre + 1).getCell(0).setCellStyle((CellStyle)csmiddle);
            dataSheet.getRow(indexCentre).createCell(1);
            dataSheet.getRow(indexCentre).getCell(1).setCellValue("Sortie camions");
            dataSheet.getRow(indexCentre).getCell(1).setCellStyle((CellStyle)csnormal);
            dataSheet.getRow(indexCentre + 1).createCell(1);
            dataSheet.getRow(indexCentre + 1).getCell(1).setCellValue("DATI");
            dataSheet.getRow(indexCentre + 1).getCell(1).setCellStyle((CellStyle)csnormal);
            dataSheet.getRow(indexCentre).createCell(index);
            dataSheet.getRow(indexCentre).getCell(index).setCellValue((double)totalCamion);
            dataSheet.getRow(indexCentre).getCell(index).setCellStyle((CellStyle)csnormal);
            dataSheet.getRow(indexCentre + 1).createCell(index);
            dataSheet.getRow(indexCentre + 1).getCell(index).setCellValue((double)totalCamionDATI);
            dataSheet.getRow(indexCentre + 1).getCell(index).setCellStyle((CellStyle)csnormal);
            int i = 0;
            while (i < listeDate.size() + 2) {
                dataSheet.autoSizeColumn(i);
                ++i;
            }
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)workbook);
            String fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("dir.tmp")) + "/" + System.nanoTime() + ".xlsx";
            FileOutputStream output = new FileOutputStream(fileDestination);
            workbook.write((OutputStream)output);
            ((OutputStream)output).close();
            workbook.close();
            File outfile = new File(fileDestination);
            try {
                retour = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            System.out.println("Done");
        }
        catch (FileNotFoundException e) {
            Log.error("FileNotFoundException", e);
        }
        catch (IOException e) {
            Log.error("IOException", e);
        }
        catch (Exception e) {
            Log.error("Exception", e);
        }
        workbook = null;
        System.out.println("End");
        return retour;
    }

    public List<Calendar> getDatesBetween(Calendar startDate, Calendar endDate) {
        ArrayList<Calendar> datesInRange = new ArrayList<Calendar>();
        Calendar calendar = startDate;
        Calendar endCalendar = endDate;
        while (calendar.before(endCalendar)) {
            Calendar result = (Calendar)calendar.clone();
            datesInRange.add(result);
            calendar.add(5, 1);
        }
        return datesInRange;
    }
}

