/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.SyntheseTableauBordPCBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordPCLineBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class SyntheseTableauBordStatistiqueSchemaRoutierExport {
    private static IReportRunnable design = null;
    private IReportEngine birtReportEngine = null;
    private EngineConfig config = null;
    private String format;
    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> syntheseTableauBordSchemaRoutier;
    private String imageStatSchemaRoutier;
    private String dateMin;
    private boolean afficheHoraire;
    private String fileDestination = "";
    private BirtEngine birtEngine = null;

    public InputStream export(List<SyntheseTableauBordStatistiqueSchemaRoutierBean> syntheseTableauBordStatistiqueSchemaRoutier, String imageFrequencePatrouille, String format, String dateMin, boolean afficheHoraire) {
        this.format = format;
        this.syntheseTableauBordSchemaRoutier = syntheseTableauBordStatistiqueSchemaRoutier;
        this.imageStatSchemaRoutier = imageFrequencePatrouille;
        this.dateMin = dateMin;
        this.afficheHoraire = afficheHoraire;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            String odtFileName = ConfigurationFactory.getInstance().get("synthese.stat.schema_routier.design");
            if (odtFileName == null) {
                odtFileName = "";
            }
            design = this.birtReportEngine.openReportDesign(odtFileName);
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, String> valeurs = new HashMap<String, String>();
            task.getAppContext().put("syntheseTableauBordSchemaRoutier", this.syntheseTableauBordSchemaRoutier);
            task.getAppContext().put("imageStatSchemaRoutier", this.imageStatSchemaRoutier);
            String delegation = "Toutes";
            String centre = "Tous";
            valeurs.put("delegation", delegation);
            valeurs.put("centre", centre);
            valeurs.put("dateMin", this.dateMin);
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else if (IExportService.FORMATS.estXLS((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLS");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("dir.tmp")) + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }

    private List<SyntheseTableauBordPCBean> returnDummySyntheseTableauBordPCList() {
        ArrayList<SyntheseTableauBordPCBean> retour = new ArrayList<SyntheseTableauBordPCBean>();
        int nbSecteurs = 3;
        int i = 0;
        while (i < nbSecteurs) {
            SyntheseTableauBordPCBean tableauBord = new SyntheseTableauBordPCBean();
            tableauBord.setNomGroupe("NomGroupe" + i);
            int nbCentres = this.numAleatoire(1, 10);
            ArrayList<SyntheseTableauBordPCLineBean> syntheseTableauBordPCLineList = new ArrayList<SyntheseTableauBordPCLineBean>();
            Integer[] totalParMois = new Integer[13];
            int k = 0;
            while (k < 13) {
                totalParMois[k] = 0;
                ++k;
            }
            int j = 0;
            while (j < nbCentres) {
                SyntheseTableauBordPCLineBean tableauBordPCLineBean = new SyntheseTableauBordPCLineBean();
                tableauBordPCLineBean.setNom("Nom" + j);
                int total = 0;
                Integer[] nbMois = new Integer[12];
                int k2 = 0;
                while (k2 < 12) {
                    int nb = this.numAleatoire(0, 25);
                    nbMois[k2] = nb;
                    total += nb;
                    ++k2;
                }
                tableauBordPCLineBean.setNbMois(nbMois);
                tableauBordPCLineBean.setTotal(total);
                syntheseTableauBordPCLineList.add(tableauBordPCLineBean);
                ++j;
            }
            tableauBord.setSyntheseTableauBordPCLine(syntheseTableauBordPCLineList);
            retour.add(tableauBord);
            ++i;
        }
        return retour;
    }

    private int numAleatoire() {
        return this.numAleatoire(1, 999);
    }

    private int numAleatoire(int min, int max) {
        return min + (int)(Math.random() * (double)(max - min + 1));
    }
}

