/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.beans.DebutFinIntervention;
import com.geolocsystems.prismcentral.beans.InterventionAgentBean;
import com.geolocsystems.prismcentral.beans.SyntheseInterventionAgentBean;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.HashMap;

public class SyntheseInterventionAgentExportCSV {
    public InputStream exportCSV(SyntheseInterventionAgentBean syntheseBean) {
        StringBuffer sbCriteres = new StringBuffer();
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbTitre = new StringBuffer();
        StringBuffer sbRetour = new StringBuffer();
        HashMap<String, String> jourSemaine = new HashMap<String, String>();
        jourSemaine.put("1", "Lundi");
        jourSemaine.put("2", "Mardi");
        jourSemaine.put("3", "Mercredi");
        jourSemaine.put("4", "Jeudi");
        jourSemaine.put("5", "Vendredi");
        jourSemaine.put("6", "Samedi");
        jourSemaine.put("7", "Dimanche");
        SimpleDateFormat sdfJour = new SimpleDateFormat("u");
        SimpleDateFormat sdfJourMois = new SimpleDateFormat("dd/MM");
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/YYYY");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("dd/MM/YYYY HH:mm");
        SimpleDateFormat sdfHeureMinute = new SimpleDateFormat("HH:mm");
        sbTitre.append("\"Titre\";\"" + syntheseBean.getTitre() + "\";");
        sbTitre.append("\n");
        sbTitre.append("\"Date de d\u00e9but\";\"" + sdfDate.format(syntheseBean.getDateDebut()) + "\";");
        sbTitre.append("\n");
        sbTitre.append("\"Date de fin\";\"" + sdfDate.format(syntheseBean.getDateFin()) + "\";");
        sbTitre.append("\n");
        if (syntheseBean.getDelegation() != null) {
            sbTitre.append("\"" + syntheseBean.getDelegationTitre() + "\";\"" + syntheseBean.getDelegation() + "\";");
            sbTitre.append("\n");
        }
        if (syntheseBean.getCentre() != null) {
            sbTitre.append("\"" + syntheseBean.getCentreTitre() + "\";\"" + syntheseBean.getCentre() + "\";");
            sbTitre.append("\n");
        }
        for (InterventionAgentBean syntheseAgentBean : syntheseBean.getInterventionAgentList()) {
            sbContenu.append("\n");
            sbContenu.append("\"Agent\";");
            sbContenu.append("\"" + syntheseAgentBean.getNomAgent() + "\";");
            sbContenu.append("\"Jour\";");
            sbContenu.append("\"D\u00e9but d'intervention\";");
            sbContenu.append("\"Fin d'intervention\";");
            sbContenu.append("\"Dur\u00e9e d'intervention\";");
            sbContenu.append("\"Total journalier\";");
            sbContenu.append("\n");
            String jourPrec = "";
            for (DebutFinIntervention dates : syntheseAgentBean.getDates()) {
                sbContenu.append("\"\";");
                sbContenu.append("\"\";");
                if (jourPrec.equals(sdfDate.format(dates.getDateDebut()))) {
                    sbContenu.append("\"\";");
                } else {
                    sbContenu.append("\"" + (String)jourSemaine.get(sdfJour.format(dates.getDateDebut())) + " " + sdfJourMois.format(dates.getDateDebut()) + "\";");
                }
                if (dates.getDateDebut() != null) {
                    sbContenu.append("\"" + sdfHeure.format(dates.getDateDebut()) + "\";");
                } else {
                    sbContenu.append("\"\";");
                }
                if (dates.getDateFin() != null) {
                    sbContenu.append("\"" + sdfHeure.format(dates.getDateFin()) + "\";");
                } else {
                    sbContenu.append("\"\";");
                }
                if (dates.getDuree() != -1.0) {
                    sbContenu.append(String.valueOf(("\"" + dates.getDuree()).replace(".", ",")) + "\";");
                } else {
                    sbContenu.append("\"\";");
                }
                if (!jourPrec.equals(sdfDate.format(dates.getDateDebut()))) {
                    sbContenu.append(String.valueOf(("\"" + syntheseAgentBean.getDureeJournee(sdfDate.format(dates.getDateDebut()), sdfDate)).replace(".", ",")) + "\";");
                }
                sbContenu.append("\n");
                jourPrec = sdfDate.format(dates.getDateDebut());
            }
        }
        sbRetour.append(sbCriteres);
        sbRetour.append(sbTitre);
        sbRetour.append(sbContenu);
        return new ByteArrayInputStream(sbRetour.toString().getBytes(Charset.forName("windows-1252")));
    }
}

