/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismbirtbean.RapportEvenementBean;
import com.geolocsystems.prismcentral.ConstantesCSV;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Partenaire;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.FicheTravailExport;
import com.geolocsystems.prismcentral.export.FicheTravailTableauExport;
import com.geolocsystems.prismcentral.export.PatrimoineExport;
import com.geolocsystems.prismcentral.export.RapportConstatExport;
import com.geolocsystems.prismcentral.export.apachepoi.APModelExport;
import com.geolocsystems.prismcentral.export.apachepoi.APSituationExport;
import com.geolocsystems.prismcentral.export.csv.CSVComposantFactory;
import com.geolocsystems.prismcentral.export.csv.CSVUtils;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import com.geolocsystems.prismcentral.export.factory.RapportEvenementBeanFactory;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentral.export.json.ChampJSON;
import com.geolocsystems.prismcentral.export.json.JSONComposantFactory;
import com.geolocsystems.prismcentral.export.json.JSONUtils;
import com.geolocsystems.prismcentral.export.libreoffice.SituationExportLibreOffice;
import com.geolocsystems.prismcentral.export.partenaire.axione.PartenaireAxioneExport;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.CSV;
import gls.outils.GLS;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SituationExport {
    public static final String TYPE_BIRT = "birt";
    public static final String TYPE_PATRIMOINE = "patrimoine";
    public static final String TYPE_BIRT_EVENEMENT_V2 = "birt_v2";
    private IBusinessService service;
    private final PartenaireAxioneExport partenaireAxione;

    public SituationExport(IBusinessService service) {
        this.service = service;
        this.partenaireAxione = new PartenaireAxioneExport(this.service);
    }

    public InputStream export(Object listSituation, String format, PrismCentralUser user, List<String[]> criteres, String typeExport, Map<String, Object> parametres, String document) {
        System.out.println(format);
        System.out.println(typeExport);
        if (GLS.estVide((String)typeExport)) {
            return this.exportPaper((List)listSituation, user, format, criteres);
        }
        if (typeExport.equals("photos")) {
            System.out.println("PHOTOS");
            return this.exportPhotos((List)listSituation);
        }
        if (typeExport.equals("csv")) {
            LinkedHashMap<String, String> paramChampsCsv = null;
            String champs = (String)parametres.get("champs");
            if (champs != null) {
                String[] valeursChamps;
                paramChampsCsv = new LinkedHashMap<String, String>();
                String[] stringArray = valeursChamps = champs.split(";");
                int n = valeursChamps.length;
                int n2 = 0;
                while (n2 < n) {
                    String valeurChamps = stringArray[n2];
                    paramChampsCsv.put(valeurChamps, valeurChamps);
                    ++n2;
                }
                return this.exportCSV((List)listSituation, criteres, paramChampsCsv);
            }
            return this.exportCSV((List)listSituation, criteres, (Map)parametres.get("champsCsv"));
        }
        if (typeExport.equals(TYPE_BIRT)) {
            if (parametres == null) {
                parametres = new HashMap<String, Object>();
            }
            parametres.put("Historisee", false);
            return this.exportFicheTravail((List)listSituation, parametres, document, format);
        }
        if (typeExport.equals("birt-historique")) {
            if (parametres == null) {
                parametres = new HashMap<String, Object>();
            }
            parametres.put("Historisee", true);
            return this.exportFicheTravail((List)listSituation, parametres, document, format);
        }
        if (typeExport.equals("birt-tableau") || typeExport.equals("birt-tableau-image")) {
            return this.exportFicheTravailTableau((List)listSituation, parametres, document, format);
        }
        if (typeExport.equals(IExportService.FORMATS.TYPE_RAPPORT_CONSTAT) || typeExport.equals(IExportService.FORMATS.TYPE_RAPPORT_CONSTAT)) {
            return this.exportRapportConstat((List)listSituation, parametres, document, format);
        }
        if (typeExport.equals("apache-poi")) {
            return this.exportAPSituation((List)listSituation, parametres, document, format);
        }
        if (typeExport.equals("apache-poi-test")) {
            return this.exportAPModel((List)listSituation, parametres, document, format);
        }
        return this.exportPaper((List)listSituation, user, format, criteres);
    }

    private InputStream exportAPSituation(List<Situation> listSituation, Map<String, Object> parametres, String document, String format) {
        APSituationExport export = new APSituationExport(this.service);
        try {
            return export.export(listSituation, parametres, document, format);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration export", e);
            return null;
        }
    }

    private InputStream exportAPModel(List<Situation> listSituation, Map<String, Object> parametres, String document, String format) {
        APModelExport export = new APModelExport(this.service);
        try {
            return export.export(listSituation, parametres, document, format);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration export", e);
            return null;
        }
    }

    public InputStream exportPatrimoineCSV(List<Situation> listSituation, List<String[]> criteres) {
        InputStream retour = null;
        HashMap mapEvenements = new HashMap();
        for (Situation situation : listSituation) {
            for (Evenement evenement : situation.getEvenements()) {
                String codeNature = evenement.getValeurNature().getCode();
                List<Object> liste = new ArrayList<Evenement>();
                if (mapEvenements.get(codeNature) != null) {
                    liste = (List)mapEvenements.get(codeNature);
                }
                liste.add(evenement);
                mapEvenements.put(codeNature, liste);
            }
        }
        Map natures = this.service.getNatures();
        for (String nature : mapEvenements.keySet()) {
            if (natures.get(nature) != null) {
                retour = new PatrimoineExport(this.service).csv((Nature)natures.get(nature), (List)mapEvenements.get(nature));
                continue;
            }
            Log.error("exportPatrimoineCSV nature [" + nature + "] non trouv\u00e9e");
        }
        return retour;
    }

    public InputStream exportPhotos(List<Situation> situations) {
        try {
            return new FileInputStream(MetierCommun.instanceOf().zipPhotos(situations, this.service));
        }
        catch (Exception e) {
            throw new RuntimeException("Impossible de g\u00e9n\u00e9rer les photos", e);
        }
    }

    public InputStream exportCSV(List<Situation> situations, List<String[]> criteres, Map<String, String> colonnesAffichees) {
        if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.export.memoire", true)) {
            return this.exportCSVMemoire(situations, criteres, colonnesAffichees);
        }
        return this.exportCSVFile(situations, criteres, colonnesAffichees);
    }

    public InputStream exportCSVMemoire(List<Situation> situations, List<String[]> criteres, Map<String, String> colonnesAffichees) {
        Log.debug("Debut exportCSV");
        StringBuffer sbCriteres = new StringBuffer();
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbTitre = new StringBuffer();
        StringBuffer sbRetour = new StringBuffer();
        Map natures = this.service.getNatures();
        if (colonnesAffichees == null) {
            colonnesAffichees = CSVUtils.getListeChamps(this.service, situations, natures);
        }
        ArrayList listMapValeurs = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        CSVComposantFactory factory = new CSVComposantFactory(this.service);
        List situationsDistinct = situations.stream().distinct().collect(Collectors.toList());
        for (Situation situation : situationsDistinct) {
            for (Evenement evenement : situation.getEvenements()) {
                HashMap<String, String> mapCsv = new HashMap<String, String>();
                Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
                n.chargerValeurs(evenement.getValeurNature());
                List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                for (Champ c : listeChamp) {
                    List champscsv = (List)c.getView((IComposantFactory)factory);
                    if (champscsv != null) {
                        for (ChampCSV champcsv : champscsv) {
                            mapCsv.put(champcsv.getCode(), champcsv.getValeur());
                        }
                        continue;
                    }
                    System.out.println();
                }
                mapCsv.put("ID EVT", "" + evenement.getkEventid());
                mapCsv.put(ConstantesCSV.CSV_CT, evenement.getCei());
                if (n.getLabel() != null) {
                    mapCsv.put("Nature", n.getLabel());
                } else {
                    mapCsv.put("Nature", "");
                }
                mapCsv.put("description", evenement.getValeurNature().getDescription().getValeur());
                mapCsv.put(ConstantesCSV.CSV_DELEGATION, evenement.getDistrict());
                mapCsv.put("lu", evenement.isLu() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
                    mapCsv.put("Date cr\u00e9ation", sdfDate.format(new Date(evenement.getDateCreation())));
                    mapCsv.put("Heure cr\u00e9ation", sdfHeure.format(new Date(evenement.getDateCreation())));
                    mapCsv.put("Date mise \u00e0 jour", sdfDate.format(new Date(evenement.getDateMaj())));
                    mapCsv.put("Heure mise \u00e0 jour", sdfHeure.format(new Date(evenement.getDateMaj())));
                } else {
                    mapCsv.put("Date cr\u00e9ation", sdf.format(new Date(evenement.getDateCreation())));
                    mapCsv.put("Date mise \u00e0 jour", sdf.format(new Date(evenement.getDateMaj())));
                }
                mapCsv.put("Termin\u00e9", evenement.isTermine() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                mapCsv.put("Annul\u00e9", evenement.isAnnule() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                mapCsv.put("Programm\u00e9", evenement.isProgramme() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                mapCsv.put("Erreur", evenement.getErreur());
                mapCsv.put("Code utilisateur", this.service.getUtilisateur(evenement.getCodeUtilisateur()).getNom());
                mapCsv.put("Code \u00e9v\u00e8nement", evenement.getCodeEvenement());
                mapCsv.put("Photos", "" + evenement.getPhotos().size());
                PrismCentralUser createur = this.service.getUtilisateur(evenement.getIdCreateur());
                if (createur != null) {
                    mapCsv.put("Code cr\u00e9ateur", createur.getNom());
                } else {
                    mapCsv.put("Code cr\u00e9ateur", "");
                }
                listMapValeurs.add(mapCsv);
            }
        }
        if (criteres != null) {
            Iterator<Object> iterator = criteres.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                String[] stringArray2 = stringArray = (String[])iterator.next();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray2[n2];
                    sbCriteres.append("\"" + element + "\";");
                    ++n2;
                }
                sbCriteres.append("\n");
            }
        }
        for (String string : colonnesAffichees.keySet()) {
            sbTitre.append(CSV.toCSV((String)string)).append(";");
        }
        sbTitre.append("\n");
        for (Map map : listMapValeurs) {
            StringBuffer evenementCsv = new StringBuffer();
            for (String colonne : colonnesAffichees.keySet()) {
                evenementCsv.append(CSV.toCSV((String)((String)map.get(colonne)))).append(";");
            }
            sbContenu.append(evenementCsv.toString());
            sbContenu.append("\n");
        }
        sbRetour.append(sbCriteres);
        sbRetour.append(sbTitre);
        sbRetour.append(sbContenu);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sbRetour.toString().getBytes(Charset.forName("windows-1252")));
        Log.debug("Fin exportCSV");
        return byteArrayInputStream;
    }

    public InputStream exportCSVFile(List<Situation> situations, List<String[]> criteres, Map<String, String> colonnesAffichees) {
        Log.debug("Debut exportCSV");
        StringBuffer sbCriteres = new StringBuffer();
        StringBuffer sbTitre = new StringBuffer();
        Map natures = this.service.getNatures();
        if (colonnesAffichees == null) {
            colonnesAffichees = CSVUtils.getListeChamps(this.service, situations, natures);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        CSVComposantFactory factory = new CSVComposantFactory(this.service);
        List situationsDistinct = situations.stream().distinct().collect(Collectors.toList());
        if (criteres != null) {
            Iterator<Object> iterator = criteres.iterator();
            while (iterator.hasNext()) {
                String[] critere;
                String[] stringArray = critere = (String[])iterator.next();
                int n = critere.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    sbCriteres.append("\"" + element + "\";");
                    ++n2;
                }
                sbCriteres.append("\n");
            }
        }
        for (String colonne : colonnesAffichees.keySet()) {
            sbTitre.append(CSV.toCSV((String)colonne)).append(";");
        }
        sbTitre.append("\n");
        BufferedInputStream bis = null;
        try {
            String fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("dir.tmp")) + "/" + System.nanoTime() + ".csv";
            FileOutputStream outputStream = new FileOutputStream(fileDestination);
            outputStream.write(sbCriteres.toString().getBytes(Charset.forName("windows-1252")));
            outputStream.write(sbTitre.toString().getBytes(Charset.forName("windows-1252")));
            HashMap<String, String> mapCsv = new HashMap<String, String>();
            long start2 = System.currentTimeMillis();
            for (Situation s : situationsDistinct) {
                for (Evenement evenement : s.getEvenements()) {
                    if (evenement.getPhotos() != null && evenement.getPhotos().size() > 0) {
                        Log.error("****** PHOTO ****************");
                    }
                    Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
                    n.chargerValeurs(evenement.getValeurNature());
                    List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                    for (Champ c : listeChamp) {
                        List champscsv = (List)c.getView((IComposantFactory)factory);
                        if (champscsv != null) {
                            for (ChampCSV champcsv : champscsv) {
                                mapCsv.put(champcsv.getCode(), champcsv.getValeur());
                            }
                            continue;
                        }
                        System.out.println();
                    }
                    mapCsv.put("ID EVT", "" + evenement.getkEventid());
                    mapCsv.put(ConstantesCSV.CSV_CT, evenement.getCei());
                    if (n.getLabel() != null) {
                        mapCsv.put("Nature", n.getLabel());
                    } else {
                        mapCsv.put("Nature", "");
                    }
                    mapCsv.put("description", evenement.getValeurNature().getDescription().getValeur());
                    mapCsv.put(ConstantesCSV.CSV_DELEGATION, evenement.getDistrict());
                    mapCsv.put("lu", evenement.isLu() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                    if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
                        mapCsv.put("Date cr\u00e9ation", sdfDate.format(new Date(evenement.getDateCreation())));
                        mapCsv.put("Heure cr\u00e9ation", sdfHeure.format(new Date(evenement.getDateCreation())));
                        mapCsv.put("Date mise \u00e0 jour", sdfDate.format(new Date(evenement.getDateMaj())));
                        mapCsv.put("Heure mise \u00e0 jour", sdfHeure.format(new Date(evenement.getDateMaj())));
                    } else {
                        mapCsv.put("Date cr\u00e9ation", sdf.format(new Date(evenement.getDateCreation())));
                        mapCsv.put("Date mise \u00e0 jour", sdf.format(new Date(evenement.getDateMaj())));
                    }
                    mapCsv.put("Termin\u00e9", evenement.isTermine() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                    mapCsv.put("Annul\u00e9", evenement.isAnnule() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                    mapCsv.put("Programm\u00e9", evenement.isProgramme() ? ReportI18n.getString("oui") : ReportI18n.getString("non"));
                    mapCsv.put("Erreur", evenement.getErreur());
                    mapCsv.put("Code utilisateur", this.service.getUtilisateur(evenement.getCodeUtilisateur()).getNom());
                    mapCsv.put("Code \u00e9v\u00e8nement", evenement.getCodeEvenement());
                    mapCsv.put("Photos", "" + evenement.getPhotos().size());
                    PrismCentralUser createur = this.service.getUtilisateur(evenement.getIdCreateur());
                    if (createur != null) {
                        mapCsv.put("Code cr\u00e9ateur", createur.getNom());
                    } else {
                        mapCsv.put("Code cr\u00e9ateur", "");
                    }
                    StringBuffer evenementCsv = new StringBuffer();
                    for (String colonne : colonnesAffichees.keySet()) {
                        evenementCsv.append(CSV.toCSV((String)((String)mapCsv.get(colonne)))).append(";");
                    }
                    mapCsv.clear();
                    evenementCsv.append("\n");
                    outputStream.write(evenementCsv.toString().getBytes(Charset.forName("windows-1252")));
                }
            }
            System.out.println("Test clear : " + (System.currentTimeMillis() - start2));
            outputStream.close();
            bis = new BufferedInputStream(new FileInputStream(fileDestination));
        }
        catch (IOException e) {
            Log.error(e);
        }
        Log.debug("Fin exportCSV");
        return bis;
    }

    public InputStream exportCSV(List<Situation> listSituation, List<String[]> criteres) {
        StringBuffer sbCriteres = new StringBuffer();
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbTitre = new StringBuffer();
        StringBuffer sbRetour = new StringBuffer();
        Map natures = this.service.getNatures();
        CSVComposantFactory factory = new CSVComposantFactory(this.service);
        if (criteres != null) {
            Iterator<String[]> iterator = criteres.iterator();
            while (iterator.hasNext()) {
                String[] critere;
                String[] stringArray = critere = iterator.next();
                int n = critere.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    sbCriteres.append("\"" + element + "\";");
                    ++n2;
                }
                sbCriteres.append("\n");
            }
        }
        sbTitre.append("\"" + ReportI18n.getString("global_centre") + "\";\"CODE_EVENEMENT\";\"dateCreation\";\"dateMaj\";\"termine\";\"lu\";\"etat\";\"erreur\";\"codeUtilisateur\";");
        sbTitre.append("\"nbPhotos\";\"nature\";");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        ArrayList<String> colonnes = new ArrayList<String>();
        ArrayList<String> codesColonnes = new ArrayList<String>();
        for (Situation situation : listSituation) {
            for (Evenement evenement : situation.getEvenements()) {
                sbContenu.append("\n");
                sbContenu.append("\"" + evenement.getCei() + "\";");
                sbContenu.append("\"" + evenement.getCodeEvenement() + "\";");
                sbContenu.append("\"" + sdf.format(new Date(evenement.getDateCreation())) + "\";");
                sbContenu.append("\"" + sdf.format(new Date(evenement.getDateMaj())) + "\";");
                if (evenement.isTermine()) {
                    sbContenu.append("\"oui\";");
                } else {
                    sbContenu.append("\"non\";");
                }
                if (evenement.isLu()) {
                    sbContenu.append("\"oui\";");
                } else {
                    sbContenu.append("\"non\";");
                }
                sbContenu.append("\"" + evenement.getEtat() + "\";");
                if (evenement.getErreur() != null) {
                    sbContenu.append("\"" + evenement.getErreur() + "\";");
                } else {
                    sbContenu.append("\"\";");
                }
                sbContenu.append("\"" + evenement.getCodeUtilisateur() + "\";");
                sbContenu.append("\"" + evenement.getPhotos().size() + "\";");
                sbContenu.append("\"" + evenement.getValeurNature().getCode() + "\";");
                Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
                n.chargerValeurs(evenement.getValeurNature());
                List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                ArrayList<String> valeurs = new ArrayList<String>();
                for (Champ c : listeChamp) {
                    int index = 0;
                    List champscsv = (List)c.getView((IComposantFactory)factory);
                    for (ChampCSV champcsv : champscsv) {
                        if (!colonnes.contains(champcsv.getLibelle())) {
                            colonnes.add(champcsv.getLibelle());
                            codesColonnes.add(champcsv.getCode());
                        }
                        index = colonnes.indexOf(champcsv.getLibelle());
                        while (index > valeurs.size()) {
                            valeurs.add(valeurs.size(), null);
                        }
                        if (valeurs.size() > index) {
                            valeurs.remove(index);
                        }
                        valeurs.add(index, champcsv.getValeur());
                    }
                }
                int i = 0;
                while (i < colonnes.size()) {
                    if (i < valeurs.size()) {
                        if (!GLS.estVide((String)((String)valeurs.get(i)))) {
                            sbContenu.append("\"" + (String)valeurs.get(i) + "\";");
                        } else {
                            sbContenu.append("\"\";");
                        }
                    }
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < colonnes.size()) {
            sbTitre.append("\"" + (String)colonnes.get(i) + "\";");
            ++i;
        }
        sbRetour.append(sbCriteres);
        sbRetour.append(sbTitre);
        sbRetour.append(sbContenu);
        return new ByteArrayInputStream(sbRetour.toString().getBytes(Charset.forName("windows-1252")));
    }

    public InputStream exportPaper(List<Situation> listSituation, PrismCentralUser user, String format, List<String[]> criteres) {
        SituationExportLibreOffice export = new SituationExportLibreOffice(this.service);
        try {
            return export.generate(listSituation, format, user, criteres);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration pdf", e);
            return null;
        }
    }

    public InputStream exportFicheTravail(List<Situation> listSituation, Map<String, Object> parametres, String document, String format) {
        ArrayList<Integer> listId = new ArrayList<Integer>();
        for (Situation situation : listSituation) {
            for (Evenement evenement : situation.getEvenements()) {
                listId.add(evenement.getkEventid());
            }
        }
        FicheTravailExport export = new FicheTravailExport(this.service);
        try {
            return export.export(listId, parametres, document, format);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration pdf", e);
            return null;
        }
    }

    public InputStream exportFicheTravailTableau(List<Situation> evenementsString, Map<String, Object> parametres, String document, String format) {
        FicheTravailTableauExport export = new FicheTravailTableauExport();
        try {
            return export.export(evenementsString, parametres, document, format);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration export tableau", e);
            return null;
        }
    }

    private InputStream exportRapportConstat(List<Situation> listSituation, Map<String, Object> parametres, String document, String format) {
        if (listSituation.isEmpty()) {
            return null;
        }
        List<RapportEvenementBean> rapportEvenementBeans = new RapportEvenementBeanFactory(this.service).convert(listSituation);
        RapportConstatExport export = new RapportConstatExport(this.service);
        try {
            return export.export(rapportEvenementBeans, parametres, document, format);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration du rapport constat", e);
            return null;
        }
    }

    public InputStream exportBirt(List<Situation> listSituation, PrismCentralUser user, String format) {
        return null;
    }

    public InputStream exportJSON(List<Situation> situations, Map<String, String> colonnesAffichees) {
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbRetour = new StringBuffer();
        Map natures = this.service.getNatures();
        if (colonnesAffichees == null) {
            colonnesAffichees = JSONUtils.getListeChamps(situations, natures);
        }
        ArrayList listMapValeurs = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        SimpleDateFormat sdfDate = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfHeure = new SimpleDateFormat("HH:mm");
        JSONComposantFactory factory = new JSONComposantFactory();
        for (Situation s : situations) {
            for (Evenement evenement : s.getEvenements()) {
                HashMap<String, String> mapCsv = new HashMap<String, String>();
                Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
                n.chargerValeurs(evenement.getValeurNature());
                List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
                for (Champ c : listeChamp) {
                    List champscsv = (List)c.getView((IComposantFactory)factory);
                    for (ChampJSON champcsv : champscsv) {
                        if (champcsv.isChaine()) {
                            mapCsv.put(champcsv.getCode(), JSONUtils.getChaine(champcsv.getValeur()));
                            continue;
                        }
                        mapCsv.put(champcsv.getCode(), champcsv.getValeur());
                    }
                }
                mapCsv.put("ID EVT", "" + evenement.getkEventid());
                mapCsv.put(ConstantesCSV.CSV_CT, JSONUtils.getChaine(evenement.getCei()));
                mapCsv.put("description", JSONUtils.getChaine(evenement.getValeurNature().getDescription().getValeur()));
                mapCsv.put(ConstantesCSV.CSV_DELEGATION, JSONUtils.getChaine(evenement.getDistrict()));
                mapCsv.put("lu", JSONUtils.getChaine(evenement.isLu() ? ReportI18n.getString("oui") : ReportI18n.getString("non")));
                if (ConfigurationFactory.getInstance().getBoolean("fiche.evenement.csv.date.heure.separe", false)) {
                    mapCsv.put("Date cr\u00e9ation", JSONUtils.getChaine(sdfDate.format(new Date(evenement.getDateCreation()))));
                    mapCsv.put("Heure cr\u00e9ation", JSONUtils.getChaine(sdfHeure.format(new Date(evenement.getDateCreation()))));
                    mapCsv.put("Date mise \u00e0 jour", JSONUtils.getChaine(sdfDate.format(new Date(evenement.getDateMaj()))));
                    mapCsv.put("Heure mise \u00e0 jour", JSONUtils.getChaine(sdfHeure.format(new Date(evenement.getDateMaj()))));
                } else {
                    mapCsv.put("Date cr\u00e9ation", JSONUtils.getChaine(sdf.format(new Date(evenement.getDateCreation()))));
                    mapCsv.put("Date mise \u00e0 jour", JSONUtils.getChaine(sdf.format(new Date(evenement.getDateMaj()))));
                }
                mapCsv.put("Termin\u00e9", JSONUtils.getChaine(evenement.isTermine() ? ReportI18n.getString("oui") : ReportI18n.getString("non")));
                mapCsv.put("Annul\u00e9", JSONUtils.getChaine(evenement.isAnnule() ? ReportI18n.getString("oui") : ReportI18n.getString("non")));
                mapCsv.put("Programm\u00e9", JSONUtils.getChaine(evenement.isProgramme() ? ReportI18n.getString("oui") : ReportI18n.getString("non")));
                mapCsv.put("Erreur", JSONUtils.getChaine(evenement.getErreur()));
                mapCsv.put("Code utilisateur", JSONUtils.getChaine(this.service.getUtilisateur(evenement.getCodeUtilisateur()).getNom()));
                mapCsv.put("Code \u00e9v\u00e8nement", JSONUtils.getChaine(evenement.getCodeEvenement()));
                mapCsv.put("Photos", JSONUtils.getChaine("" + evenement.getPhotos().size()));
                listMapValeurs.add(mapCsv);
            }
        }
        boolean bFirst = true;
        sbContenu.append("[");
        sbContenu.append("\n");
        for (Map map : listMapValeurs) {
            if (bFirst) {
                bFirst = false;
            } else {
                sbContenu.append(",");
            }
            sbContenu.append("{");
            sbContenu.append("\n");
            StringBuffer evenementCsv = new StringBuffer();
            boolean bFirstChamp = true;
            for (String colonne : colonnesAffichees.keySet()) {
                if (bFirstChamp) {
                    bFirstChamp = false;
                } else {
                    evenementCsv.append(",");
                }
                evenementCsv.append("\"");
                evenementCsv.append(colonne);
                evenementCsv.append("\":");
                evenementCsv.append((String)map.get(colonne));
                evenementCsv.append("\n");
            }
            sbContenu.append(evenementCsv.toString());
            sbContenu.append("\n");
            sbContenu.append("}");
        }
        sbContenu.append("]");
        sbRetour.append(sbContenu);
        return new ByteArrayInputStream(sbRetour.toString().getBytes(Charset.forName("windows-1252")));
    }

    public void export(List<Partenaire> partenaires, Evenement evenement) throws Exception {
        for (Partenaire p : partenaires) {
            if (!GLS.egal((String)p.getFormatEchange(), (String)"WS_AXIONE")) continue;
            try {
                this.partenaireAxione.exportEvenement(p, evenement);
            }
            catch (Throwable e) {
                Log.error("[ERR EXPORT EVENEMENT AXIONE] " + p.getLibelle() + " - " + evenement.getCodeEvenement(), e);
                throw e;
            }
        }
    }
}

