/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismandroid.IFiltreReleve;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Releve;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentral.export.shp.DebroussaillageShapeWriter;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import gls.outils.CSV;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.zip.ZIP;
import gls.utils.transfert.ImageAppareilPhoto;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;

public class ReleveExport {
    private static final long serialVersionUID = 1L;
    private final ByteArrayOutputStream os = new ByteArrayOutputStream();
    private static int MAX_LARGEUR_CARTE = 550;
    private static int MAX_HAUTEUR_CARTE = 550;
    private static int MAX_LARGEUR_LEGENDE = 183;
    private static int MAX_HAUTEUR_LEGENDE = 91;
    private Image carteFauchage = null;
    private Font titleFont = new Font(Font.FontFamily.TIMES_ROMAN, 18.0f, 1);
    private Font headerFont = new Font(Font.FontFamily.TIMES_ROMAN, 14.0f, 1);
    private List<Releve> tronconsFauchage;
    private String filtreFauchage;
    private String chemin;
    private static float marginTop = 25.0f;
    private static float marginBottom = 25.0f;
    private static float marginLeft = 10.0f;
    private static float marginRight = 10.0f;

    public InputStream export(List<IFiltreReleve> ffauchage, String format) {
        IFiltreReleve fauchage = ffauchage.get(0);
        this.filtreFauchage = fauchage.getLibelle();
        this.tronconsFauchage = fauchage.getTroncons();
        this.chemin = fauchage.getChemin();
        if (IExportService.FORMATS.estCSV((String)format)) {
            return this.exportCSV();
        }
        if (IExportService.FORMATS.estPDF((String)format)) {
            return this.exportPDF();
        }
        if (IExportService.FORMATS.estZIP((String)format) || IExportService.FORMATS.estSHP((String)format)) {
            return this.exportSHP();
        }
        return null;
    }

    private InputStream exportSHP() {
        DebroussaillageShapeWriter dsw = new DebroussaillageShapeWriter();
        String nomFichier = this.getFileName();
        String cheminComplet = this.getChemin().concat(nomFichier).concat(".").concat("SHP");
        Log.debug("[RELEVE DEBROUSAILLAGE] Chemin fichier shape " + cheminComplet);
        try {
            if (dsw.writeReleve(cheminComplet, this.tronconsFauchage)) {
                Vector l = Fichier.getFichiersFiltres((String)this.getChemin(), (String)nomFichier, (String)"*");
                Vector<String> listeNomFichier = new Vector<String>();
                for (File f : l) {
                    listeNomFichier.add(f.getAbsolutePath());
                }
                File z = ZIP.zipper(listeNomFichier, (String)this.getChemin(), (String)nomFichier, (String)"ZIP");
                Log.debug("[RELEVE DEBROUSAILLAGE] Chemin fichier zip " + this.getChemin() + " / " + nomFichier);
                return new FileInputStream(z);
            }
            Log.error("[RELEVE DEBROUSAILLAGE] ERROR CREATION SHP");
        }
        catch (Throwable e) {
            Log.error("[RELEVE DEBROUSAILLAGE] ERROR CREATION ZIP SHP", e);
        }
        return null;
    }

    public List<String> getExportFormat() {
        ArrayList<String> formats = new ArrayList<String>();
        for (String format : IExportService.FORMATS.getListe((int)1)) {
            formats.add(format);
        }
        return formats;
    }

    public boolean formatExportExist(String format) {
        switch (format) {
            case "CSV": {
                return true;
            }
            case "PDF": {
                return true;
            }
            case "SHP": {
                return true;
            }
        }
        return false;
    }

    private String getDebutFichierSHP(String chemin) {
        return chemin.substring(0, chemin.length() - 4);
    }

    public String getFileName() {
        return MetierCommun.instanceOf().genereIdentifiantUnique("cartoReleve");
    }

    public InputStream exportCSV() {
        StringBuffer sbContenu = new StringBuffer();
        sbContenu.append(CSV.toCSV((String)this.filtreFauchage));
        sbContenu.append("\n");
        sbContenu.append("\n");
        sbContenu.append("\"VOIE\";\"AXE_DEBUT\";\"PRDEBUT\";\"COMMUNE_DEBUT\";\"AXE_FIN\";\"PRFIN\";\"COMUNE_FIN\"");
        sbContenu.append(";\"ARBRE\";\"CLOTURE\";\"DENSE\";\"LARGEUR 4m\";\"LARGEUR 20m\";\"ZNC\";\"ZAD\";\"ZD\";\"DATE\";\"LONGUEUR\"");
        for (Releve t : this.tronconsFauchage) {
            sbContenu.append("\n");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getVoie())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getAxeDebut())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getPrDebut())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getCommuneDebut())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getAxeFin())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getPrFin())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getCommuneFin())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getArbre())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getCloture())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getDense())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getLargeur4m())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getLargeur20m())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getZnc())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getZad())) + ";");
            sbContenu.append(String.valueOf(CSV.toCSV((String)t.getZd())) + ";");
            GLS.getDate();
            Calendar calendar = t.getDate();
            GLS.getDate();
            sbContenu.append(String.valueOf(CSV.toCSV((String)GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateComplete))) + ";");
            sbContenu.append(CSV.toCSV((int)t.getLongueur()));
        }
        return new ByteArrayInputStream(sbContenu.toString().getBytes(Charset.forName("windows-1252")));
    }

    public InputStream exportPDF() {
        try {
            Document document = new Document(PageSize.A4.rotate(), marginLeft, marginRight, marginTop, marginBottom);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(this.os.toByteArray());
    }

    public void formaterPDF() {
        try {
            Document document = new Document(PageSize.A4.rotate(), marginLeft, marginRight, marginTop, marginBottom);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)this.os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addMetaData(Document document) {
        document.addTitle("");
        document.addSubject("");
        document.addKeywords("");
        document.addAuthor("");
        document.addCreator("");
    }

    private void redimensionner(com.itextpdf.text.Image img, int largeur, int hauteur) {
        float width = img.getWidth();
        float height = img.getHeight();
        float newWidth = largeur;
        float newHeight = hauteur;
        if (width > height) {
            newHeight = height * newWidth / width;
            img.scaleAbsolute(newWidth, newHeight);
        } else {
            newWidth = width * newHeight / height;
            img.scaleAbsolute(newWidth, newHeight);
        }
    }

    private void addCarto(Document document) {
        com.itextpdf.text.Image img = null;
        try {
            img = com.itextpdf.text.Image.getInstance((byte[])ReleveExport.getImagesBytes(this.carteFauchage));
            this.redimensionner(img, MAX_LARGEUR_CARTE, MAX_HAUTEUR_CARTE);
            img.setAbsolutePosition(marginLeft + 130.0f, document.top() - (float)MAX_HAUTEUR_CARTE - 10.0f);
            document.add((Element)img);
        }
        catch (Exception e) {
            Log.error("", e);
        }
        try {
            img = com.itextpdf.text.Image.getInstance((String)ConfigurationFactory.getInstance().get("carto.fauchage.pdf.legende"));
            this.redimensionner(img, MAX_LARGEUR_LEGENDE, MAX_HAUTEUR_LEGENDE);
            img.setAbsolutePosition(marginLeft + 140.0f, document.bottom() + 5.0f);
            document.add((Element)img);
        }
        catch (Exception e) {
            Log.error("", e);
        }
    }

    private void addEntete(Document document) {
        this.addEmptyLine(document, 10);
        Paragraph paragrapheTitre = new Paragraph(this.filtreFauchage, this.titleFont);
        paragrapheTitre.setAlignment(1);
        try {
            document.add((Element)paragrapheTitre);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addContent(Document document) throws DocumentException {
        this.addEntete(document);
        document.add((Element)Chunk.NEXTPAGE);
        this.addCarto(document);
        document.add((Element)Chunk.NEXTPAGE);
        this.addTable(document);
    }

    public static BufferedImage toBufferedImage(Image source) throws IllegalArgumentException {
        if (source == null) {
            return null;
        }
        if (source instanceof BufferedImage) {
            return (BufferedImage)source;
        }
        int width = source.getWidth(null);
        int height = source.getHeight(null);
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Bad size !!!");
        }
        BufferedImage result = new BufferedImage(width, height, 1);
        Graphics2D graphics = result.createGraphics();
        graphics.drawImage(source, 0, 0, null);
        graphics.dispose();
        return result;
    }

    public static byte[] getImagesBytes(Image img) {
        byte[] result = null;
        BufferedImage buf = ImageAppareilPhoto.toBufferedImage((Image)img, (int)6, (boolean)false);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        try {
            ImageIO.write((RenderedImage)buf, "png", baos);
            baos.flush();
            result = baos.toByteArray();
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private void addTable(Document document) throws BadElementException {
        Paragraph paragrapheTable = new Paragraph();
        PdfPTable table = null;
        float[] colsWidth = new float[]{2.0f, 4.0f, 5.0f, 8.0f};
        table = new PdfPTable(colsWidth);
        table.setHeaderRows(1);
        for (Releve t : this.tronconsFauchage) {
            GLS.getDate();
            Calendar calendar = t.getDate();
            GLS.getDate();
            String date = GLSDate.toDate((Calendar)calendar, (DateFormat)GLSDate.formatDateJour);
            table.addCell(t.getVoie());
            table.addCell(String.valueOf(ReportI18n.getString("dupr")) + t.getAxeDebut() + " - " + t.getPrDebut() + " " + ReportI18n.getString("aupr") + t.getAxeFin() + " - " + t.getPrFin());
            table.addCell(date);
        }
        paragrapheTable.add((Element)table);
        try {
            document.add((Element)paragrapheTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addEmptyLine(Document document, int number) {
        int i = 0;
        while (i < number) {
            try {
                document.add((Element)new Paragraph(" "));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public String getChemin() {
        return this.chemin;
    }

    public void setChemin(String chemin) {
        this.chemin = chemin;
    }

    static class HeaderFooter
    extends PdfPageEventHelper {
        HeaderFooter() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (document.getPageNumber() == 1) {
                ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)new Phrase(""), (float)((document.left() + document.right()) / 2.0f), (float)(document.bottom() - marginBottom / 2.0f), (float)0.0f);
            }
            try {
                com.itextpdf.text.Image image = com.itextpdf.text.Image.getInstance((String)ConfigurationFactory.getInstance().get("logo"));
                float width = image.getWidth();
                float height = image.getHeight();
                float newWidth = 100.0f;
                float newHeight = 100.0f;
                if (width > height) {
                    newHeight = height * 100.0f / width;
                    image.scaleAbsolute(100.0f, newHeight);
                } else {
                    newWidth = width * 100.0f / height;
                    image.scaleAbsolute(newWidth, 100.0f);
                }
                image.setAbsolutePosition(5.0f, document.top() - newHeight - 5.0f);
                document.add((Element)image);
            }
            catch (BadElementException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        }
    }
}

