/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAlternat;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampImages;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLabel;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampPatrouilleProcedure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampRadioBouton;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampSignature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.PrismI18n;
import gls.outils.GLS;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public class PublicationComposantFactory
implements IComposantFactory {
    private static final String ESPACE = " ";
    private DateFormat dateFormat;
    private DateFormat heureFormat;
    private DateFormat dateHeureFormat;
    private Map<String, String[]> valeursReformulees2;

    public PublicationComposantFactory(Map<String, String[]> valeursReformulees2) {
        this.valeursReformulees2 = valeursReformulees2;
        this.dateFormat = new SimpleDateFormat(PrismI18n.getString("publication.format.date"));
        this.heureFormat = new SimpleDateFormat(PrismI18n.getString("publication.format.heure"));
        this.dateHeureFormat = new SimpleDateFormat(PrismI18n.getString("publication.format.dateheure"));
    }

    public Object createView(ChampAlternat c) {
        throw new RuntimeException("not implemented");
    }

    public Object createView(ChampEntier c) {
        if (!c.isCheckbox() || c.isChecked()) {
            return String.valueOf(c.getValeur());
        }
        return PrismI18n.getString("publication.vide");
    }

    public Object createView(ChampDecimal c) {
        if (!c.isCheckbox() || c.isChecked()) {
            return String.valueOf(c.getValeur());
        }
        return PrismI18n.getString("publication.vide");
    }

    public Object createView(ChampDropListe c) {
        return this.getValeurReformulee((Champ)c, c.getValeurs(), c.getValeur());
    }

    public Object createView(ChampLabel c) {
        return c.getValeur();
    }

    public Object createView(ChampLocalisation c) {
        StringBuffer buf = new StringBuffer();
        if (c.getCommune() != null) {
            buf.append(c.getCommune()).append(" / ");
        }
        if (c.getAxe() != null) {
            buf.append(c.getAxe());
        }
        return buf.toString();
    }

    public Object createView(ChampMultiCheckBox c) {
        ArrayList<String> valeursReformulees = new ArrayList<String>();
        for (String item : c.getValeursSelectionnee()) {
            valeursReformulees.add(this.getValeurReformulee((Champ)c, c.getValeurs(), item));
        }
        if (c.getAutreValeur() != null) {
            valeursReformulees.add(c.getAutreValeur());
        }
        return GLS.getString(valeursReformulees, (String)", ");
    }

    public Object createView(ChampMultiple c) {
        StringBuffer buf = new StringBuffer();
        for (Champ champ : c.getChamps()) {
            Object valeur = champ.getView((IComposantFactory)this);
            if (GLS.estVide((String)GLS.getString((Object)valeur))) continue;
            buf.append(valeur).append(ESPACE);
        }
        return buf.toString();
    }

    public Object createView(ChampRadioBouton c) {
        return this.getValeurReformulee((Champ)c, c.getValeurs(), c.getValeurSelectionnee());
    }

    public Object createView(ChampTexte c) {
        return c.getValeur() == null ? "" : c.getValeur();
    }

    public Object createView(ChampVraiFaux c) {
        return String.valueOf(c.getLibelle()) + " : " + (c.getValeur() ? PrismI18n.getString("publication.oui") : PrismI18n.getString("publication.non"));
    }

    public Object createView(ChampVehiculeEnCause c) {
        StringBuffer buf = new StringBuffer();
        int index = 0;
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.vl", c.getVl(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.pl", c.getPl(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.tc", c.getVtc(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.velo", c.getVelo(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.tmd", c.getTmd(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.autres", c.getAutres(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.pietonCycle", c.getPietonCycle(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.moto", c.getMoto(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.campingCar", c.getCampingCar(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.enginAgricole", c.getEnginAgricole(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.scooter", c.getScooter(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.animaux", c.getAnimaux(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.deuxRoues", c.getDeuxRoues(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.caravane", c.getCaravane(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.train", c.getTrain(), c, index++);
        this.addVehiculeEnCauseItem(buf, "vehiculeencause.tramway", c.getTramway(), c, index++);
        return buf.toString();
    }

    private void addVehiculeEnCauseItem(StringBuffer buff, String i18nKey, int nb, ChampVehiculeEnCause c, int index) {
        if (nb > 0) {
            String[] valeursReformulees = this.valeursReformulees2.get(c.getNom());
            if (valeursReformulees != null) {
                if (index >= 0 && index < valeursReformulees.length) {
                    buff.append(nb).append(ESPACE).append(valeursReformulees[index]).append(", ");
                }
            } else {
                buff.append(nb).append(ESPACE).append(PrismI18n.getString(i18nKey)).append(", ");
            }
        }
    }

    public Object createView(ChampDate c) {
        GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour());
        return String.valueOf(c.getLibelle()) + " : " + this.dateFormat.format(cal.getTime());
    }

    public Object createView(ChampDateHeure c) {
        GregorianCalendar cal = new GregorianCalendar(c.getAnnee(), c.getMois(), c.getJour(), c.getHeure(), c.getMinute());
        return String.valueOf(c.getLibelle()) + " : " + this.dateHeureFormat.format(cal.getTime());
    }

    public Object createView(ChampHeure c) {
        GregorianCalendar cal = new GregorianCalendar(0, 0, 0, c.getHeure(), c.getMinute());
        return String.valueOf(c.getLibelle()) + " : " + this.heureFormat.format(cal.getTime());
    }

    public void setChampLectureSeule(boolean lectureSeule) {
    }

    public Object createView(ChampPatrouilleProcedure c) {
        return PrismI18n.getString("publication.procedurepatrouille");
    }

    public Object createView(ChampChoixImage c) {
        return this.getValeurReformulee((Champ)c, c.getValeurs(), c.getValeurSelectionnee());
    }

    private String getValeurReformulee(Champ c, List<String> liste, String valeur) {
        int index;
        String[] valeursReformulees = this.valeursReformulees2.get(c.getNom());
        if (valeursReformulees != null && (index = liste.indexOf(valeur)) >= 0 && index < valeursReformulees.length) {
            return valeursReformulees[index];
        }
        return valeur;
    }

    public Object createView(ChampChoixImageMultiple c) {
        ArrayList<String> valeursReformulees = new ArrayList<String>();
        for (String item : c.getValeursSelectionnee()) {
            valeursReformulees.add(this.getValeurReformulee((Champ)c, c.getValeurs(), item));
        }
        if (c.getAutreValeur() != null) {
            valeursReformulees.add(c.getAutreValeur());
        }
        return GLS.getString(valeursReformulees, (String)", ");
    }

    public Object createView(ChampImages champImage) {
        return null;
    }

    public Object createView(ChampSignature champSignature) {
        return null;
    }

    public Object createView(ChampDocuments champDocuments) {
        return null;
    }

    public Object createView(ChampCoucheBox champCoucheBox) {
        return null;
    }

    public Object createView(ChampOneDrive champOneDrive) {
        return null;
    }
}

