/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismbirtbean.PatrouilleSemaineList;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentral.export.apachepoi.APPatrouilleSemaineExport;
import com.geolocsystems.prismcentral.service.BusinessServiceDAO;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class PatrouilleSemaineExport {
    private static IReportRunnable design = null;
    private IReportEngine birtReportEngine = null;
    private String format;
    private PatrouilleSemaineList patrouilleSemaineList;
    private String fileDestination = "";
    private BirtEngine birtEngine = null;

    public InputStream export(PatrouilleSemaineList patrouilleSemaineList, String format) {
        this.format = format;
        this.patrouilleSemaineList = patrouilleSemaineList;
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport2();
    }

    private InputStream runReport2() {
        BusinessServiceDAO businessService = new BusinessServiceDAO();
        APPatrouilleSemaineExport export = new APPatrouilleSemaineExport(businessService);
        try {
            return export.export(this.patrouilleSemaineList, this.format);
        }
        catch (Exception e) {
            Log.error("Erreur g\u00e9n\u00e9ration export", e);
            return null;
        }
    }

    public InputStream runReport() {
        Log.debug("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            design = this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("patrouille.semaine.design"));
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap valeurs = new HashMap();
            task.getAppContext().put("PatrouilleSemaineList", this.patrouilleSemaineList);
            task.getAppContext().put("libraryPass", ConfigurationFactory.getInstance().get("synthese.patrouille.lib.path"));
            task.setParameterValues(valeurs);
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else if (IExportService.FORMATS.estXLSX((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLSX");
            } else if (IExportService.FORMATS.estXLS((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLS");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("dir.tmp")) + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

