/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.NatureExport;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.csv.CSVComposantFactory;
import com.geolocsystems.prismcentral.export.csv.ChampCSV;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatrimoineExport {
    private IBusinessService service;

    public PatrimoineExport(IBusinessService service) {
        this.service = service;
    }

    public InputStream csv(Nature nature, List<Evenement> listPatrimoine) {
        NatureExport natureExport = this.service.getNatureExport(nature, "csv");
        if (natureExport != null) {
            return this.export(listPatrimoine, natureExport.getTitre(), natureExport.getChamps());
        }
        Log.warn("Export de " + nature + " non d\u00e9fini");
        return null;
    }

    private InputStream export(List<Evenement> listPatrimoine, String titre, String champs) {
        StringBuffer sbContenu = new StringBuffer();
        StringBuffer sbTitre = new StringBuffer();
        StringBuffer sbRetour = new StringBuffer();
        Map natures = this.service.getNatures();
        LinkedHashMap<String, String> mapTitresDeb = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> mapTitresMid = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> mapTitresFin = new LinkedHashMap<String, String>();
        ArrayList listMapValeurs = new ArrayList();
        CSVComposantFactory factory = new CSVComposantFactory(this.service);
        for (Evenement evenement : listPatrimoine) {
            Object champcsv22;
            Nature n = (Nature)DeepCopy.copy((Object)((Nature)natures.get(evenement.getValeurNature().getCode())));
            for (Champ c : n.getChamps()) {
                List champscsv = (List)c.getView((IComposantFactory)factory);
                for (Object champcsv22 : champscsv) {
                    if (mapTitresMid.containsKey(((ChampCSV)champcsv22).getCode())) continue;
                    if ("".equals(((ChampCSV)champcsv22).getLibelle())) {
                        mapTitresMid.put(((ChampCSV)champcsv22).getCode(), ((ChampCSV)champcsv22).getCode());
                        continue;
                    }
                    mapTitresMid.put(((ChampCSV)champcsv22).getCode(), ((ChampCSV)champcsv22).getLibelle());
                }
            }
            n.chargerValeurs(evenement.getValeurNature());
            List listeChamp = MetierCommun.getChampsFiltresTest((Nature)n);
            ArrayList<String> champsValide = new ArrayList<String>();
            champcsv22 = listeChamp.iterator();
            while (champcsv22.hasNext()) {
                Champ champ = (Champ)champcsv22.next();
                champsValide.add(champ.getNom());
            }
            LinkedHashMap<String, Champ> mapChamp = new LinkedHashMap<String, Champ>();
            for (Champ c : n.getChamps()) {
                mapChamp.put(c.getNom(), c);
            }
            if ("*".equals(champs)) {
                LinkedHashMap<String, String> mapValeurs = new LinkedHashMap<String, String>();
                if (!mapTitresDeb.containsKey("ID EVT")) {
                    mapTitresDeb.put("ID EVT", "ID EVT");
                }
                mapValeurs.put("ID EVT", "" + evenement.getkEventid());
                if (!mapTitresDeb.containsKey("CTCG")) {
                    mapTitresDeb.put("CTCG", "CTCG");
                }
                mapValeurs.put("CTCG", evenement.getCei());
                if (!mapTitresDeb.containsKey("Cat\u00e9gorie")) {
                    mapTitresDeb.put("Cat\u00e9gorie", "Cat\u00e9gorie");
                }
                mapValeurs.put("Cat\u00e9gorie", evenement.getValeurNature().getDescription().getValeur());
                if (!mapTitresDeb.containsKey("RD")) {
                    mapTitresDeb.put("RD", "RD");
                }
                mapValeurs.put("RD", evenement.getLocalisation().getAxe());
                if (!mapTitresDeb.containsKey("PR")) {
                    mapTitresDeb.put("PR", "PR");
                }
                if (!mapTitresDeb.containsKey("Sens")) {
                    mapTitresDeb.put("Sens", "Sens");
                }
                if (evenement.getLocalisation().getSensPr() != -1) {
                    if (evenement.getLocalisation().getPrDebut() != -1) {
                        mapValeurs.put("PR", String.valueOf(evenement.getLocalisation().getPrDebut()) + "+" + evenement.getLocalisation().getAbsPrDebut());
                    } else {
                        mapValeurs.put("PR", "");
                    }
                    mapValeurs.put("Sens", "" + evenement.getLocalisation().getSensPr());
                } else {
                    mapValeurs.put("PR", "");
                    mapValeurs.put("Sens", "");
                }
                Set keySet = ((HashMap)mapChamp).keySet();
                for (String key : keySet) {
                    Champ champ = (Champ)((HashMap)mapChamp).get(key);
                    List champscsv = (List)champ.getView((IComposantFactory)factory);
                    for (ChampCSV champcsv3 : champscsv) {
                        mapValeurs.put(champcsv3.getCode(), champcsv3.getValeur());
                    }
                }
                if (!mapTitresFin.containsKey("PHOTOS")) {
                    mapTitresFin.put("PHOTOS", "PHOTOS");
                }
                mapValeurs.put("PHOTOS", "" + evenement.getPhotos().size());
                if (!mapTitresFin.containsKey("Latitude")) {
                    mapTitresFin.put("Latitude", "Latitude");
                }
                mapValeurs.put("Latitude", "" + evenement.getLocalisation().getPositionDebut().getX());
                if (!mapTitresFin.containsKey("Longitude")) {
                    mapTitresFin.put("Longitude", "Longitude");
                }
                mapValeurs.put("Longitude", "" + evenement.getLocalisation().getPositionDebut().getY());
                listMapValeurs.add(mapValeurs);
                continue;
            }
            sbContenu.append("\n");
            sbContenu.append("\"" + evenement.getkEventid() + "\";");
            sbContenu.append("\"" + evenement.getCei() + "\";");
            sbContenu.append("\"" + evenement.getValeurNature().getDescription().getValeur() + "\";");
            sbContenu.append("\"" + evenement.getLocalisation().getAxe() + "\";");
            if (evenement.getLocalisation().getSensPr() != -1) {
                if (evenement.getLocalisation().getPrDebut() != -1) {
                    sbContenu.append("\"" + evenement.getLocalisation().getPrDebut() + "+" + evenement.getLocalisation().getAbsPrDebut() + "\";");
                } else {
                    sbContenu.append("\"\";");
                }
                sbContenu.append("\"" + evenement.getLocalisation().getSensPr() + "\";");
            } else {
                sbContenu.append("\"\";");
                sbContenu.append("\"\";");
            }
            String[] stringArray = champs.split(";");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String valeur;
                Object champ = stringArray[n3];
                if (((String)champ).contains(":")) {
                    valeur = "";
                    String[] stringArray2 = ((String)champ).split(":");
                    int n4 = stringArray2.length;
                    int champcsv3 = 0;
                    while (champcsv3 < n4) {
                        String champTmp = stringArray2[champcsv3];
                        if (((HashMap)mapChamp).get(champTmp) != null && champsValide.contains(champTmp)) {
                            Champ ch = (Champ)((HashMap)mapChamp).get(champTmp);
                            List champscsv = (List)ch.getView((IComposantFactory)factory);
                            for (ChampCSV champcsv4 : champscsv) {
                                valeur = String.valueOf(valeur) + champcsv4.getValeur();
                            }
                        }
                        ++champcsv3;
                    }
                    sbContenu.append("\"" + valeur + "\";");
                } else {
                    valeur = "";
                    if (((HashMap)mapChamp).get(champ) != null && champsValide.contains(champ)) {
                        Champ ch = (Champ)((HashMap)mapChamp).get(champ);
                        List champscsv = (List)ch.getView((IComposantFactory)factory);
                        for (ChampCSV champcsv5 : champscsv) {
                            valeur = String.valueOf(valeur) + champcsv5.getValeur();
                        }
                    }
                    sbContenu.append("\"" + valeur + "\";");
                }
                ++n3;
            }
            sbContenu.append("\"" + evenement.getPhotos().size() + "\";");
            sbContenu.append("\"" + evenement.getLocalisation().getPositionDebut().getX() + "\";");
            sbContenu.append("\"" + evenement.getLocalisation().getPositionDebut().getY() + "\";");
        }
        if ("*".equals(champs)) {
            for (String string : mapTitresDeb.keySet()) {
                sbTitre.append("\"" + (String)mapTitresDeb.get(string) + "\";");
            }
            for (String string : mapTitresMid.keySet()) {
                sbTitre.append("\"" + (String)mapTitresMid.get(string) + "\";");
            }
            for (String string : mapTitresFin.keySet()) {
                sbTitre.append("\"" + (String)mapTitresFin.get(string) + "\";");
            }
            sbRetour.append(sbTitre);
            for (Map map : listMapValeurs) {
                sbContenu.append("\n");
                for (String key : mapTitresDeb.keySet()) {
                    if (map.get(key) != null) {
                        sbContenu.append("\"" + (String)map.get(key) + "\";");
                        continue;
                    }
                    sbContenu.append("\"\";");
                }
                for (String key : mapTitresMid.keySet()) {
                    if (map.get(key) != null) {
                        sbContenu.append("\"" + (String)map.get(key) + "\";");
                        continue;
                    }
                    sbContenu.append("\"\";");
                }
                for (String key : mapTitresFin.keySet()) {
                    if (map.get(key) != null) {
                        sbContenu.append("\"" + (String)map.get(key) + "\";");
                        continue;
                    }
                    sbContenu.append("\"\";");
                }
            }
            sbRetour.append(sbContenu);
        } else {
            sbTitre.append("\"ID EVT\";\"CTCG\";\"Cat\u00e9gorie\";\"RD\";\"PR\";\"Sens\";");
            sbTitre.append(titre);
            sbTitre.append(";\"PHOTOS\";\"Latitude\";\"Longitude\"");
            sbRetour.append(sbTitre);
            sbRetour.append(sbContenu);
        }
        return new ByteArrayInputStream(sbRetour.toString().getBytes(Charset.forName("windows-1252")));
    }
}

