/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;

public class FicheTravailTableauExport {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    EngineConfig config = null;
    String[] evenements;
    String fileDestination = "";
    String format;
    BirtEngine birtEngine = null;
    private String document = null;
    private Map<String, Object> parametres;

    public InputStream export(List<String> evenements) {
        this.evenements = new String[evenements.size()];
        int index = 0;
        while (index < evenements.size()) {
            this.evenements[index] = evenements.get(index);
            ++index;
        }
        this.format = "PDF";
        return this.exporter();
    }

    public InputStream export(List<Situation> situations, Map<String, Object> parametres, String document, String format) {
        this.parametres = parametres;
        List evenements = (List)parametres.get("evtString");
        this.document = document;
        this.format = format;
        if (parametres.get("libelles") != null) {
            Log.debug("-----------");
            Log.debug(parametres.get("libelles"));
            this.evenements = new String[evenements.size() + 1];
            this.evenements[0] = (String)parametres.get("libelles");
            int index = 0;
            while (index < evenements.size()) {
                Log.debug(evenements.get(index));
                this.evenements[index + 1] = (String)evenements.get(index);
                ++index;
            }
            Log.debug("-----------");
        } else {
            this.evenements = new String[evenements.size()];
            int index = 0;
            while (index < evenements.size()) {
                this.evenements[index] = (String)evenements.get(index);
                ++index;
            }
        }
        return this.exporter();
    }

    public InputStream exporter() {
        return this.runReport();
    }

    public InputStream runReport() {
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            PDFRenderOption renderOption;
            if (design == null) {
                design = this.document != null ? this.birtReportEngine.openReportDesign(String.valueOf(ConfigurationFactory.getInstance().get("design.path")) + this.document) : this.birtReportEngine.openReportDesign(ConfigurationFactory.getInstance().get("stats.fiches.travail.tableau.design"));
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, String[]> valeurs = new HashMap<String, String[]>();
            valeurs.put("evenements", this.evenements);
            task.setParameterValues(valeurs);
            if (this.parametres.get("imageWMS") != null) {
                task.getAppContext().put("imageWMS", this.parametres.get("imageWMS"));
            }
            if (IExportService.FORMATS.estPDF((String)this.format)) {
                renderOption = new PDFRenderOption();
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
            } else if (IExportService.FORMATS.estODT((String)this.format)) {
                renderOption = new RenderOption();
                renderOption.setEmitterID("org.eclipse.birt.report.engine.emitter.odt");
                renderOption.setOutputFormat("ODT");
            } else if (IExportService.FORMATS.estXLSX((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLSX");
            } else if (IExportService.FORMATS.estXLS((String)this.format)) {
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFormat("XLS");
            } else {
                renderOption = new HTMLRenderOption();
                renderOption.setOutputFormat("DOC");
            }
            this.fileDestination = "";
            this.fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("dir.tmp")) + "/" + System.nanoTime() + "." + this.format.toLowerCase();
            renderOption.setOutputFileName(this.fileDestination);
            renderOption.closeOutputStreamOnExit(true);
            Log.debug("renderOption : " + renderOption);
            Log.debug("renderOption EmitterId : " + renderOption.getEmitterID());
            task.setRenderOption((IRenderOption)renderOption);
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            renderOption = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

