/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prism.localisation.ICartoServiceData;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.IMailService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.util.List;
import java.util.Vector;
import prism.commun.DistrictAdmin;
import prism.commun.vh.MetiersVH;
import prism.commun.vh.document.synthese.SyntheseDir;

public class ExportSerpeVH {
    private IBusinessService business;
    private ICartoServiceData carto;
    private IMailService mail;

    public ExportSerpeVH(IBusinessService business, ICartoServiceData carto, IMailService mail) {
        this.business = business;
        this.carto = carto;
        this.mail = mail;
    }

    public void exporter() {
        SyntheseDir s = new SyntheseDir();
        MetiersVH m = new MetiersVH();
        Vector<DistrictAdmin> v = new Vector<DistrictAdmin>();
        String nomFichierPdf = ConfigurationFactory.getInstance().get("dir.tmp").concat(GLS.genererNumeroUnique((String)"situationVH")).concat(".pdf");
        for (Delegation d : this.business.getDelegations()) {
            List l = this.business.getBarreauxVH(d.getNom(), null, false);
            DistrictAdmin district = new DistrictAdmin();
            district.setLibelle(d.getNom());
            district.setEvenementsVh(MetiersVH.convertir((List)l));
            v.add(district);
        }
        String logo = ConfigurationFactory.getInstance().get("logo");
        String cheminCarto = this.carto.getCarto().getCheminCarto();
        String cheminFondsCarto = this.carto.getCarto().getCheminImageFondCarto();
        try {
            s.genererSynthese(nomFichierPdf, logo, ConfigurationFactory.getInstance().get("zoneroutiere"), cheminCarto, cheminFondsCarto, cheminCarto, this.business.getSyntheseSerpeVH().getCommentaire(), v, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

