/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2Groupe;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2Ligne;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.mail.MailService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class BulletinMediaVH2Export {
    private static final int ROW_DATE_HEURE = 3;
    private static int ROW_LIGNE_1 = 6;
    private static int ROW_ALTITUDE_CAMION = 93;
    private static int ROW_EQUIPEMENT_INTERDICTION = 95;
    private static int ROW_TEXTE_1 = 98;
    private static final int COL_DATE = 5;
    private static final int COL_HEURE = 7;
    private static final int COL_ALTITUDE = 0;
    private static final int COL_CAMIONS = 5;
    private static final int COL_EQUIPEMENT = 2;
    private static final int COL_INTERDICTION = 6;
    private static final int COL_TEXTE = 1;
    private static final boolean EXPORT_IN_PDF = false;
    private BulletinMediaVH2 bulletin;
    private String fileDestination;
    private String fileName;
    private IBusinessService businessService;
    private boolean envoisPossible;

    public BulletinMediaVH2Export(BulletinMediaVH2 bulletin) {
        this.bulletin = bulletin;
    }

    public boolean exporter(IBusinessService businessService) {
        this.envoisPossible = false;
        this.businessService = businessService;
        boolean retour = this.runReport();
        this.sendReport();
        return retour;
    }

    public boolean runReport() {
        boolean retour = false;
        String fileNameModele = this.businessService.getConfiguration().getString("vh.bulletin.media.xlsm");
        String constantes = this.businessService.getConfiguration().getString("vh.bulletin.media.constantes", "");
        if (!"".equals(constantes)) {
            String[] constantesList;
            String[] stringArray = constantesList = constantes.split(";");
            int n = constantesList.length;
            int n2 = 0;
            while (n2 < n) {
                String constante = stringArray[n2];
                String[] keyValue = constante.split(":");
                if ("CAMION".equals(keyValue[0])) {
                    ROW_ALTITUDE_CAMION = Integer.valueOf(keyValue[1]);
                } else if ("EQUIPEMENT".equals(keyValue[0])) {
                    ROW_EQUIPEMENT_INTERDICTION = Integer.valueOf(keyValue[1]);
                } else if ("TEXTE".equals(keyValue[0])) {
                    ROW_TEXTE_1 = Integer.valueOf(keyValue[1]);
                } else if ("LIGNE".equals(keyValue[0])) {
                    ROW_LIGNE_1 = Integer.valueOf(keyValue[1]);
                }
                ++n2;
            }
        }
        Log.debug("fileNameModele :" + fileNameModele);
        XSSFWorkbook workbook = null;
        try {
            try {
                workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(fileNameModele)));
            }
            catch (FileNotFoundException e) {
                Log.error("FileNotFoundException", e);
            }
            if (workbook == null) {
                fileNameModele = "C:/Temp/Bulletin_media_CEA.xlsm";
            }
            workbook = new XSSFWorkbook((InputStream)new FileInputStream(new File(fileNameModele)));
            XSSFSheet dataSheet = workbook.getSheetAt(0);
            SimpleDateFormat formatDate = new SimpleDateFormat("dd/MM/YYYY");
            SimpleDateFormat formatHeure = new SimpleDateFormat("HH:mm");
            dataSheet.getRow(3).getCell(5).setCellValue(formatDate.format(this.bulletin.getDateBulletin()));
            dataSheet.getRow(3).getCell(7).setCellValue(formatHeure.format(this.bulletin.getDateBulletin()));
            int indexHeure = 3;
            for (Integer key : this.bulletin.getHeures_affichees().keySet()) {
                dataSheet.getRow(ROW_LIGNE_1).getCell(indexHeure).setCellValue((String)this.bulletin.getHeures_affichees().get(key));
                ++indexHeure;
            }
            for (Integer id_groupe : this.bulletin.getLignes().keySet()) {
                boolean afficheInterdiction = false;
                for (BulletinMediaVH2Groupe groupe : this.bulletin.getGroupes()) {
                    if (groupe.getId_groupe() != id_groupe.intValue()) continue;
                    afficheInterdiction = groupe.getAffiche_interdiction();
                }
                for (BulletinMediaVH2Ligne ligne : ((TreeMap)this.bulletin.getLignes().get(id_groupe)).values()) {
                    indexHeure = 3;
                    for (Integer key : this.bulletin.getHeures_affichees().keySet()) {
                        dataSheet.getRow(ROW_LIGNE_1 + ligne.getLigne()).getCell(indexHeure).setCellValue((String)ligne.getCcParHeure().get(key));
                        ++indexHeure;
                    }
                    if (!afficheInterdiction || !ligne.isAfficheInterdiction()) continue;
                    if (ligne.isInterdiction()) {
                        dataSheet.getRow(ROW_LIGNE_1 + ligne.getLigne()).getCell(this.bulletin.getHeures_affichees().keySet().size() + 3).setCellValue("oui");
                        continue;
                    }
                    dataSheet.getRow(ROW_LIGNE_1 + ligne.getLigne()).getCell(this.bulletin.getHeures_affichees().keySet().size() + 3).setCellValue("non");
                }
            }
            dataSheet.getRow(ROW_ALTITUDE_CAMION).getCell(0).setCellValue("" + this.bulletin.getLimitePluieNeige());
            dataSheet.getRow(ROW_ALTITUDE_CAMION).getCell(5).setCellValue("" + this.bulletin.getNbCamions());
            if (this.bulletin.getEquipement().booleanValue()) {
                dataSheet.getRow(ROW_EQUIPEMENT_INTERDICTION).getCell(2).setCellValue("oui");
            } else {
                dataSheet.getRow(ROW_EQUIPEMENT_INTERDICTION).getCell(2).setCellValue("non");
            }
            if (this.bulletin.getInterdiction().booleanValue()) {
                dataSheet.getRow(ROW_EQUIPEMENT_INTERDICTION).getCell(6).setCellValue("oui");
            } else {
                dataSheet.getRow(ROW_EQUIPEMENT_INTERDICTION).getCell(6).setCellValue("non");
            }
            dataSheet.getRow(ROW_TEXTE_1).getCell(1).setCellValue(this.bulletin.getTexteLibre1());
            dataSheet.getRow(ROW_TEXTE_1 + 2).getCell(1).setCellValue(this.bulletin.getTexteLibre2());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String dateHeure = sdf.format(new Date(this.bulletin.getDateBulletin().getTime()));
            XSSFFormulaEvaluator.evaluateAllFormulaCells((XSSFWorkbook)workbook);
            this.fileDestination = "";
            this.fileName = "bulletinMedia-" + dateHeure + ".xlsm";
            this.fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("vh.bulletin.media.chemin")) + this.fileName;
            Log.debug("bulletin media vh " + this.fileDestination);
            FileOutputStream output = new FileOutputStream(this.fileDestination);
            workbook.write((OutputStream)output);
            ((OutputStream)output).close();
            workbook.close();
            this.envoisPossible = true;
            System.out.println("Done");
            retour = true;
        }
        catch (FileNotFoundException e) {
            Log.error("FileNotFoundException", e);
        }
        catch (IOException e) {
            Log.error("IOException", e);
        }
        catch (Exception e) {
            Log.error("Exception", e);
        }
        workbook = null;
        System.out.println("End");
        return retour;
    }

    public void sendReport() {
        MailService mailService = new MailService(this.businessService, null);
        if (this.envoisPossible) {
            Log.info("envois du bulletin media vh " + this.fileDestination);
            mailService.bulletinVH(new File(this.fileDestination), this.fileName);
        } else {
            Log.error("pb d'envois du bulletin media vh " + this.fileDestination);
        }
    }

    public String exportInPdf(String file, String fileName) {
        try {
            int timeout = 1;
            TimeUnit minutes = TimeUnit.MINUTES;
            Path tempScript = Files.createTempFile("script", ".vbs", new FileAttribute[0]);
            String pathVbsScript = this.businessService.getConfiguration().getString("vh.bulletin.media.vbs.pdf");
            System.out.println("Path for vbs script is: '" + pathVbsScript + "'");
            List<String> script = null;
            try {
                script = Files.readAllLines(new File(pathVbsScript).toPath());
            }
            catch (FileNotFoundException e) {
                Log.error("FileNotFoundException", e);
            }
            if (script == null) {
                script = Files.readAllLines(new File("C:\\Temp\\VBA\\XLStoPDF.vbs").toPath());
            }
            String templateFile = file;
            templateFile = templateFile.replace("\\", "\\\\");
            String pdfFile = String.valueOf(ConfigurationFactory.getInstance().get("vh.bulletin.media.chemin")) + fileName;
            pdfFile = pdfFile.replace("\\", "\\\\");
            System.out.println("script is: " + script);
            int i = 0;
            while (i < script.size()) {
                script.set(i, script.get(i).replaceAll("XL_FILE", templateFile));
                script.set(i, script.get(i).replaceAll("PDF_FILE", pdfFile));
                ++i;
            }
            Files.write(tempScript, script, new OpenOption[0]);
            ProcessBuilder pb = new ProcessBuilder("wscript", tempScript.toString());
            Process process = pb.start();
            Boolean success = process.waitFor(timeout, minutes);
            if (!success.booleanValue()) {
                System.out.println("Error: Could not convert PDF within " + timeout + " " + (Object)((Object)minutes));
                process.destroy();
            } else {
                System.out.println("Process to run visual basic script for pdf conversion succeeded.");
            }
            return pdfFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

