/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.export.BirtEngine;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.api.EXCELRenderOption;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.PDFRenderOption;

public class BirtExport {
    private static IReportRunnable design = null;
    IReportEngine birtReportEngine = null;
    private String fileDestination = "";
    private BirtEngine birtEngine = null;
    private Map<String, Object> parametres;
    private String document;
    private String format;

    public InputStream export(Map<String, Object> parametres, String document, String format) {
        this.parametres = parametres;
        this.document = document;
        this.format = format;
        return this.runReport();
    }

    public InputStream runReport() {
        System.out.println("runReport");
        BirtEngine birtEngine = new BirtEngine();
        BufferedInputStream reponse = null;
        this.birtReportEngine = birtEngine.getBirtEngine();
        try {
            EXCELRenderOption renderOption;
            if (design == null) {
                design = this.birtReportEngine.openReportDesign(String.valueOf(ConfigurationFactory.getInstance().get("design.path")) + this.document);
            }
            IRunAndRenderTask task = this.birtReportEngine.createRunAndRenderTask(design);
            HashMap<String, Object> valeurs = new HashMap<String, Object>();
            valeurs.put("JDBCUrl", ConfigurationFactory.getInstance().get("jdbc.url"));
            valeurs.put("JDBCUser", ConfigurationFactory.getInstance().get("jdbc.username"));
            valeurs.put("JDBCPassword", ConfigurationFactory.getInstance().get("jdbc.password"));
            for (Map.Entry<String, Object> parametre : this.parametres.entrySet()) {
                valeurs.put(parametre.getKey(), parametre.getValue());
            }
            task.setParameterValues(valeurs);
            this.fileDestination = String.valueOf(ConfigurationFactory.getInstance().get("export.path")) + File.separator;
            if (this.format.equals("XLS")) {
                this.fileDestination = String.valueOf(this.fileDestination) + "birt_" + System.currentTimeMillis() + ".xls";
                renderOption = new EXCELRenderOption();
                renderOption.setOutputFileName(this.fileDestination);
                renderOption.setOutputFormat("xls_spudsoft");
                renderOption.closeOutputStreamOnExit(true);
                task.setRenderOption((IRenderOption)renderOption);
                renderOption = null;
            } else {
                this.fileDestination = String.valueOf(this.fileDestination) + "birt_" + System.currentTimeMillis() + ".pdf";
                renderOption = new PDFRenderOption();
                renderOption.setOutputFileName(this.fileDestination);
                renderOption.setOutputFormat("PDF");
                renderOption.setOption("pdfRenderOption.textWrapping", (Object)true);
                renderOption.closeOutputStreamOnExit(true);
                task.setRenderOption((IRenderOption)renderOption);
                renderOption = null;
            }
            task.run();
            task.close();
            valeurs.clear();
            valeurs = null;
            design = null;
            task = null;
            File outfile = new File(this.fileDestination);
            try {
                reponse = new BufferedInputStream(new FileInputStream(outfile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            outfile.delete();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        System.out.println("fin runReport");
        return reponse;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.birtEngine.destroyBirtEngine();
        design = null;
        this.birtReportEngine = null;
    }
}

