/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.export;

import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.data.IExportService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BarreauVHExport {
    private List<BarreauVHHisto> barreauxVHHisto = null;
    private String delegation;
    private String centre;
    private Date dateDebut;
    private Date dateFin;
    private HashMap<String, String> mapNomsCircuits;
    private Map<String, Object> parameters;
    private Font titleFont = new Font(Font.FontFamily.HELVETICA, 12.0f, 1);
    private Font headerFont = new Font(Font.FontFamily.HELVETICA, 10.0f, 0);
    private Font headerFontBold = new Font(Font.FontFamily.HELVETICA, 10.0f, 1);
    private Font commentFontNormal = new Font(Font.FontFamily.HELVETICA, 6.0f, 0);
    private Font commentFontBold = new Font(Font.FontFamily.HELVETICA, 6.0f, 0);
    private static float marginTop = 25.0f;
    private static float marginBottom = 25.0f;
    private static float marginLeft = 0.0f;
    private static float marginRight = 0.0f;

    public InputStream export(List<BarreauVHHisto> listBarreauVH, String format, Map<String, Object> parameters, String delegation, String centre, Date dateDebut, Date dateFin, HashMap<String, String> mapNomsCircuits) {
        this.barreauxVHHisto = listBarreauVH;
        this.delegation = delegation;
        this.centre = centre;
        this.dateDebut = dateDebut;
        this.dateFin = dateFin;
        this.mapNomsCircuits = mapNomsCircuits;
        this.parameters = parameters;
        if (IExportService.FORMATS.estPDF((String)format)) {
            return this.exportPDF();
        }
        if (IExportService.FORMATS.estCSV((String)format)) {
            return this.exportCSV();
        }
        return null;
    }

    public InputStream export(List<BarreauVHHisto> listBarreauVH, Map<String, Object> parameters) {
        this.barreauxVHHisto = listBarreauVH;
        this.parameters = parameters;
        return this.exportPDF(listBarreauVH);
    }

    public List<String> getExportFormat() {
        ArrayList<String> formats = new ArrayList<String>();
        for (String format : IExportService.FORMATS.getListe((int)4)) {
            formats.add(format);
        }
        return formats;
    }

    public String getFileName(List<BarreauVHHisto> listBarreauVH, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdfFile = new SimpleDateFormat("yyyyMMdd");
        StringBuffer sbDate = new StringBuffer("HistoriqueBarreauVH");
        sbDate.append("_");
        sbDate.append(sdfFile.format(this.dateDebut.toString()));
        sbDate.append(".");
        sbDate.append(IExportService.FORMATS.getExtension((String)format));
        return sbDate.toString();
    }

    /*
     * Exception decompiling
     */
    public InputStream exportCSV() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[23] lbl288 : CaseStatement: default:\u000a, @NONE, blocks:[23] lbl288 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void rajoutChampsCSV(StringBuffer sbContenu, String valeur, boolean dernierChamps) {
        sbContenu.append("\"");
        sbContenu.append(valeur);
        sbContenu.append("\"");
        if (!dernierChamps) {
            sbContenu.append(";");
        }
    }

    public InputStream exportPDF() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Rectangle p = PageSize.A4.rotate();
            p.setBorder(0);
            Document document = new Document(p);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContent(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    public InputStream exportPDF(List<BarreauVHHisto> barreaux) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Rectangle p = PageSize.A4.rotate();
            p.setBorder(0);
            Document document = new Document(p);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)os);
            HeaderFooter event = new HeaderFooter();
            writer.setPageEvent((PdfPageEvent)event);
            document.open();
            this.addMetaData(document);
            this.addContentHistorique(document);
            document.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    private void addMetaData(Document document) {
        document.addTitle("");
        document.addSubject("");
        document.addKeywords("");
        document.addAuthor("");
        document.addCreator("");
    }

    private void redimensionner(Image img, int largeur, int hauteur) {
        float width = img.getWidth();
        float height = img.getHeight();
        float newWidth = largeur;
        float newHeight = hauteur;
        if (width > height) {
            newHeight = height * newWidth / width;
            img.scaleAbsolute(newWidth, newHeight);
        } else {
            newWidth = width * newHeight / height;
            img.scaleAbsolute(newWidth, newHeight);
        }
    }

    private void addContent(Document document) throws DocumentException {
        Paragraph entete = new Paragraph();
        entete.setAlignment(0);
        this.addEmptyLine(entete, 1);
        String texte = "";
        try {
            Image image = Image.getInstance((String)(String.valueOf(ConfigurationFactory.getInstance().get("design.path")) + "images/logo.jpg"));
            this.redimensionner(image, 100, 100);
            entete.add((Element)image);
            this.addEmptyLine(entete, 1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        texte = ReportI18n.getString("report.historique_BarreauVH.title");
        PdfPTable tableTile = new PdfPTable(1);
        PdfPCell cellTile = new PdfPCell(new Phrase(texte, this.titleFont));
        cellTile.setHorizontalAlignment(1);
        tableTile.addCell(cellTile);
        entete.add((Element)tableTile);
        PdfPTable table = null;
        float[] colsWidth = new float[]{1.0f, 1.0f};
        table = new PdfPTable(colsWidth);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        PdfPCell cell = new PdfPCell(new Phrase(ReportI18n.getString("global.critere"), this.headerFontBold));
        table.addCell(cell);
        table.addCell(new Phrase(ReportI18n.getString("global.valeur"), this.headerFontBold));
        cell = new PdfPCell(new Phrase(ReportI18n.getString("global.delegation"), this.headerFont));
        table.addCell(cell);
        table.addCell(this.delegation);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("global.centre"), this.headerFont));
        table.addCell(cell);
        table.addCell(this.centre);
        cell = new PdfPCell(new Phrase(ReportI18n.getString("vh.historiqueCCH.datefiled.name.debut"), this.headerFont));
        table.addCell(cell);
        table.addCell(new Phrase(sdf.format(this.dateDebut), this.headerFont));
        cell = new PdfPCell(new Phrase(ReportI18n.getString("vh.historiqueCCH.datefiled.name.fin"), this.headerFont));
        table.addCell(cell);
        table.addCell(new Phrase(sdf.format(this.dateFin), this.headerFont));
        Paragraph paragrapheTable = new Paragraph();
        paragrapheTable.add((Element)table);
        this.addEmptyLine(entete, 1);
        entete.add((Element)paragrapheTable);
        this.addEmptyLine(entete, 2);
        document.add((Element)entete);
        this.addEmptyLine(entete, 2);
        Paragraph contenu = new Paragraph();
        contenu.setIndentationLeft(0.0f);
        contenu.setAlignment(0);
        contenu.setLeading(0.0f);
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    private void addContentHistorique(Document document) throws DocumentException {
        Paragraph entete = new Paragraph();
        entete.setAlignment(0);
        this.addEmptyLine(entete, 1);
        String texte = "";
        try {
            Image image = Image.getInstance((String)(String.valueOf(ConfigurationFactory.getInstance().get("design.path")) + "images/logo.jpg"));
            this.redimensionner(image, 100, 100);
            entete.add((Element)image);
            this.addEmptyLine(entete, 1);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH:mm");
        String dateGeneration = this.parameters.get("dateHistorique") != null ? sdf.format(this.parameters.get("dateHistorique")) : sdf.format(GregorianCalendar.getInstance().getTime());
        texte = String.valueOf(ReportI18n.getString("report.historique_BarreauVH.journee.title")) + this.barreauxVHHisto.get(0).getLibelle() + " - " + dateGeneration;
        PdfPTable tableTile = new PdfPTable(1);
        PdfPCell cellTile = new PdfPCell(new Phrase(String.valueOf(texte) + "\n ", this.titleFont));
        cellTile.setHorizontalAlignment(1);
        tableTile.addCell(cellTile);
        entete.add((Element)tableTile);
        this.addEmptyLine(entete, 2);
        document.add((Element)entete);
        this.addEmptyLine(entete, 2);
        Paragraph contenu = new Paragraph();
        contenu.setIndentationLeft(0.0f);
        contenu.setAlignment(0);
        contenu.setLeading(0.0f);
        this.createTable(contenu);
        document.add((Element)contenu);
    }

    /*
     * Exception decompiling
     */
    private void createTable(Paragraph contenu) throws BadElementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[24] lbl367 : CaseStatement: default:\u000a, @NONE, blocks:[24] lbl367 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addCellCenter(PdfPTable table, Phrase phrase) {
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        table.addCell(cell);
    }

    private void addEmptyLine(Paragraph paragraph, int number) {
        int i = 0;
        while (i < number) {
            paragraph.add((Element)new Paragraph(" "));
            ++i;
        }
    }

    public String getDelegation() {
        return this.delegation;
    }

    public void setDelegation(String delegation) {
        this.delegation = delegation;
    }

    public String getCentre() {
        return this.centre;
    }

    public void setCentre(String centre) {
        this.centre = centre;
    }

    public Date getDateDebut() {
        return this.dateDebut;
    }

    public void setDateDebut(Date dateDebut) {
        this.dateDebut = dateDebut;
    }

    public Date getDateFin() {
        return this.dateFin;
    }

    public void setDateFin(Date dateFin) {
        this.dateFin = dateFin;
    }

    static class HeaderFooter
    extends PdfPageEventHelper {
        HeaderFooter() {
        }

        public void onEndPage(PdfWriter writer, Document document) {
        }
    }
}

