/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.beans;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class EvenementStatistiqueBean {
    int id;
    String agregation;
    String centre;
    String nature;
    String natureLibelle;
    String axe;
    int nbEvenements;
    int nbEvenementsTraites;
    long tempsTraitementEvenements;
    Map<String, Integer> nbEvenementsParNature;
    Map<String, Integer> nbEvenementsParCentre;
    Map<String, Integer> nbEvenementsParAxe;
    Map<String, Map<String, Integer>> nbEvenementsParSousNature;
    Map<String, Map<String, Integer>> nbEvenementsTraiteParSousNature;
    Map<String, Map<String, Long>> tempsTraitementParSousNature;
    Map<String, Map<String, Long>> tempsMoyenTraitementParSousNature;
    Map<String, String> labelsNatures;
    Map<String, String> filtres;

    public EvenementStatistiqueBean(Evenement evenement, String agregation) {
        this.agregation = agregation;
        this.nbEvenementsParNature = new HashMap<String, Integer>();
        this.nbEvenementsParCentre = new HashMap<String, Integer>();
        this.nbEvenementsParAxe = new HashMap<String, Integer>();
        this.nbEvenementsParSousNature = new HashMap<String, Map<String, Integer>>();
        this.nbEvenementsTraiteParSousNature = new HashMap<String, Map<String, Integer>>();
        this.tempsTraitementParSousNature = new HashMap<String, Map<String, Long>>();
        this.tempsMoyenTraitementParSousNature = new HashMap<String, Map<String, Long>>();
        this.labelsNatures = new HashMap<String, String>();
        this.nbEvenements = 1;
        this.tempsTraitementEvenements = 0L;
        this.nbEvenementsTraites = 0;
        if ("Centre".equals(agregation)) {
            this.centre = evenement.getCei();
        }
        if ("Nature".equals(this.agregation)) {
            this.nature = evenement.getValeurNature().getCode();
        }
        if ("Axe".equals(this.agregation)) {
            this.axe = evenement.getLocalisation().getAxe();
        }
        Integer nbEvenementNature = 0;
        Integer nbEvenementCentre = 0;
        Integer nbEvenementAxe = 0;
        Integer nbEvenementSousNature = 0;
        String keyNature = evenement.getValeurNature().getCode();
        String keyCentre = evenement.getCei();
        String keyAxe = evenement.getLocalisation().getAxe();
        String keySousNature = evenement.getValeurNature().getDescription().getValeur();
        if (this.nbEvenementsParNature.containsKey(keyNature)) {
            nbEvenementNature = this.nbEvenementsParNature.get(keyNature);
        }
        this.nbEvenementsParNature.put(keyNature, nbEvenementNature + 1);
        if (this.nbEvenementsParCentre.containsKey(keyCentre)) {
            nbEvenementCentre = this.nbEvenementsParCentre.get(keyCentre);
        }
        this.nbEvenementsParCentre.put(keyCentre, nbEvenementCentre + 1);
        if (this.nbEvenementsParAxe.containsKey(keyAxe)) {
            nbEvenementAxe = this.nbEvenementsParAxe.get(keyAxe);
        }
        this.nbEvenementsParAxe.put(keyAxe, nbEvenementAxe + 1);
        if (this.nbEvenementsParSousNature.containsKey(keyNature)) {
            if (this.nbEvenementsParSousNature.get(keyNature).containsKey(keySousNature)) {
                nbEvenementSousNature = this.nbEvenementsParSousNature.get(keyNature).get(keySousNature);
            } else {
                this.tempsTraitementParSousNature.get(keyNature).put(keySousNature, 0L);
                this.nbEvenementsTraiteParSousNature.get(keyNature).put(keySousNature, 0);
            }
            this.nbEvenementsParSousNature.get(keyNature).put(keySousNature, nbEvenementSousNature + 1);
        } else {
            this.nbEvenementsParSousNature.put(keyNature, new HashMap());
            this.nbEvenementsParSousNature.get(keyNature).put(keySousNature, nbEvenementSousNature + 1);
            this.tempsTraitementParSousNature.put(keyNature, new HashMap());
            this.tempsTraitementParSousNature.get(keyNature).put(keySousNature, 0L);
            this.nbEvenementsTraiteParSousNature.put(keyNature, new HashMap());
            this.nbEvenementsTraiteParSousNature.get(keyNature).put(keySousNature, 0);
        }
        if (evenement.isTermine()) {
            ++this.nbEvenementsTraites;
            this.tempsTraitementEvenements += evenement.getDateFin() - evenement.getDateCreation();
            long tempsTraitementSousNature = this.tempsTraitementParSousNature.get(keyNature).get(keySousNature);
            int nbEvenementsTraiteSousNature = this.nbEvenementsTraiteParSousNature.get(keyNature).get(keySousNature);
            this.tempsTraitementParSousNature.get(keyNature).put(keySousNature, tempsTraitementSousNature += evenement.getDateFin() - evenement.getDateCreation());
            this.nbEvenementsTraiteParSousNature.get(keyNature).put(keySousNature, nbEvenementsTraiteSousNature + 1);
        }
    }

    public Map<String, String> getLabelsNatures() {
        return this.labelsNatures;
    }

    public void setLabelsNatures(Map<String, String> labelsNatures) {
        this.labelsNatures = labelsNatures;
    }

    public void AjouterEvenement(Evenement evenement) {
        if ("Centre".equals(this.agregation)) {
            this.centre = evenement.getCei();
        }
        if ("Nature".equals(this.agregation)) {
            this.nature = evenement.getValeurNature().getCode();
        }
        if ("Axe".equals(this.agregation)) {
            this.axe = evenement.getLocalisation().getAxe();
        }
        ++this.nbEvenements;
        Integer nbEvenementNature = 0;
        Integer nbEvenementCentre = 0;
        Integer nbEvenementAxe = 0;
        Integer nbEvenementSousNature = 0;
        String keyNature = evenement.getValeurNature().getCode();
        String keyCentre = evenement.getCei();
        String keyAxe = evenement.getLocalisation().getAxe();
        String keySousNature = evenement.getValeurNature().getDescription().getValeur();
        if (this.nbEvenementsParNature.containsKey(keyNature)) {
            nbEvenementNature = this.nbEvenementsParNature.get(keyNature);
        }
        this.nbEvenementsParNature.put(keyNature, nbEvenementNature + 1);
        if (this.nbEvenementsParCentre.containsKey(keyCentre)) {
            nbEvenementCentre = this.nbEvenementsParCentre.get(keyCentre);
        }
        this.nbEvenementsParCentre.put(keyCentre, nbEvenementCentre + 1);
        if (this.nbEvenementsParAxe.containsKey(keyAxe)) {
            nbEvenementAxe = this.nbEvenementsParAxe.get(keyAxe);
        }
        this.nbEvenementsParAxe.put(keyAxe, nbEvenementAxe + 1);
        if (this.nbEvenementsParSousNature.containsKey(keyNature)) {
            if (this.nbEvenementsParSousNature.get(keyNature).containsKey(keySousNature)) {
                nbEvenementSousNature = this.nbEvenementsParSousNature.get(keyNature).get(keySousNature);
            } else {
                this.tempsTraitementParSousNature.get(keyNature).put(keySousNature, 0L);
                this.nbEvenementsTraiteParSousNature.get(keyNature).put(keySousNature, 0);
            }
            this.nbEvenementsParSousNature.get(keyNature).put(keySousNature, nbEvenementSousNature + 1);
        } else {
            this.nbEvenementsParSousNature.put(keyNature, new HashMap());
            this.nbEvenementsParSousNature.get(keyNature).put(keySousNature, nbEvenementSousNature + 1);
            this.tempsTraitementParSousNature.put(keyNature, new HashMap());
            this.tempsTraitementParSousNature.get(keyNature).put(keySousNature, 0L);
            this.nbEvenementsTraiteParSousNature.put(keyNature, new HashMap());
            this.nbEvenementsTraiteParSousNature.get(keyNature).put(keySousNature, 0);
        }
        if (evenement.isTermine()) {
            ++this.nbEvenementsTraites;
            this.tempsTraitementEvenements += evenement.getDateFin() - evenement.getDateCreation();
            long tempsTraitementSousNature = this.tempsTraitementParSousNature.get(keyNature).get(keySousNature);
            int nbEvenementsTraiteSousNature = this.nbEvenementsTraiteParSousNature.get(keyNature).get(keySousNature);
            this.tempsTraitementParSousNature.get(keyNature).put(keySousNature, tempsTraitementSousNature += evenement.getDateFin() - evenement.getDateCreation());
            this.nbEvenementsTraiteParSousNature.get(keyNature).put(keySousNature, nbEvenementsTraiteSousNature + 1);
        }
    }

    public void calculTempsMoyenTraitement(long unite) {
        for (String keyNature : this.tempsTraitementParSousNature.keySet()) {
            for (String keySousNature : this.tempsTraitementParSousNature.get(keyNature).keySet()) {
                long tempsTraitement = this.tempsTraitementParSousNature.get(keyNature).get(keySousNature);
                long nbEvenementTraite = this.nbEvenementsTraiteParSousNature.get(keyNature).get(keySousNature).intValue();
                if (nbEvenementTraite <= 0L) continue;
                if (!this.tempsMoyenTraitementParSousNature.containsKey(keyNature)) {
                    this.tempsMoyenTraitementParSousNature.put(keyNature, new HashMap());
                }
                long tempsMoyenTraitement = tempsTraitement / nbEvenementTraite / unite;
                this.tempsMoyenTraitementParSousNature.get(keyNature).put(keySousNature, tempsMoyenTraitement);
            }
        }
    }

    public String getCentre() {
        return this.centre;
    }

    public void setCentre(String centre) {
        this.centre = centre;
    }

    public String getNature() {
        return this.nature;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getAxe() {
        return this.axe;
    }

    public void setAxe(String axe) {
        this.axe = axe;
    }

    public int getNbEvenements() {
        return this.nbEvenements;
    }

    public void setNbEvenements(int nbEvenements) {
        this.nbEvenements = nbEvenements;
    }

    public int getNbEvenementsTraites() {
        return this.nbEvenementsTraites;
    }

    public void setNbEvenementsTraites(int nbEvenementsTraites) {
        this.nbEvenementsTraites = nbEvenementsTraites;
    }

    public long getTempsTraitementEvenements() {
        return this.tempsTraitementEvenements;
    }

    public void setTempsTraitementEvenements(long tempsTraitementEvenements) {
        this.tempsTraitementEvenements = tempsTraitementEvenements;
    }

    public Map<String, Integer> getNbEvenementsParNature() {
        return this.nbEvenementsParNature;
    }

    public void setNbEvenementsParNature(Map<String, Integer> nbEvenementsParNature) {
        this.nbEvenementsParNature = nbEvenementsParNature;
    }

    public Set<String> getNatures() {
        return this.nbEvenementsParNature.keySet();
    }

    public Map<String, Integer> getNbEvenementsParCentre() {
        return this.nbEvenementsParCentre;
    }

    public void setNbEvenementsParCentre(Map<String, Integer> nbEvenementsParCentre) {
        this.nbEvenementsParCentre = nbEvenementsParCentre;
    }

    public Map<String, Integer> getNbEvenementsParAxe() {
        return this.nbEvenementsParAxe;
    }

    public void setNbEvenementsParAxe(Map<String, Integer> nbEvenementsParAxe) {
        this.nbEvenementsParAxe = nbEvenementsParAxe;
    }

    public Set<String> getCentres() {
        return this.nbEvenementsParCentre.keySet();
    }

    public Integer getNbEvenementsAssainissement() {
        return this.nbEvenementsParNature.get("assainissement");
    }

    public Integer getNbEvenementsChaussee() {
        return this.nbEvenementsParNature.get("chaussee");
    }

    public Integer getNbEvenementsDependance() {
        return this.nbEvenementsParNature.get("dependance");
    }

    public Integer getNbEvenementsSignalisation() {
        return this.nbEvenementsParNature.get("signalisation");
    }

    public Map<String, Map<String, Integer>> getNbEvenementsParSousNature() {
        return this.nbEvenementsParSousNature;
    }

    public void setNbEvenementsParSousNature(Map<String, Map<String, Integer>> nbEvenementsParSousNature) {
        this.nbEvenementsParSousNature = nbEvenementsParSousNature;
    }

    public Map<String, Map<String, Integer>> getNbEvenementsTraiteParSousNature() {
        return this.nbEvenementsTraiteParSousNature;
    }

    public void setNbEvenementsTraiteParSousNature(Map<String, Map<String, Integer>> nbEvenementsTraiteParSousNature) {
        this.nbEvenementsTraiteParSousNature = nbEvenementsTraiteParSousNature;
    }

    public Map<String, Map<String, Long>> getTempsTraitementParSousNature() {
        return this.tempsTraitementParSousNature;
    }

    public void setTempsTraitementParSousNature(Map<String, Map<String, Long>> tempsTraitementParSousNature) {
        this.tempsTraitementParSousNature = tempsTraitementParSousNature;
    }

    public Map<String, Map<String, Long>> getTempsMoyenTraitementParSousNature() {
        return this.tempsMoyenTraitementParSousNature;
    }

    public void setTempsMoyenTraitementParSousNature(Map<String, Map<String, Long>> tempsMoyenTraitementParSousNature) {
        this.tempsMoyenTraitementParSousNature = tempsMoyenTraitementParSousNature;
    }

    public String getAgregation() {
        return this.agregation;
    }

    public void setAgregation(String agregation) {
        this.agregation = agregation;
    }

    public String getNatureLibelle() {
        return this.natureLibelle;
    }

    public void setNatureLibelle(String natureLibelle) {
        this.natureLibelle = natureLibelle;
    }

    public Map<String, String> getFiltres() {
        return this.filtres;
    }

    public void setFiltres(Map<String, String> filtres) {
        this.filtres = filtres;
    }
}

