/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.beans;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismcentral.beans.DynamicExport;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import gls.outils.GLS;
import gls.outils.GLSDate;
import java.util.Calendar;

public class DynamicVehiculeExport
extends DynamicExport {
    public static final String X = "x";
    public static final String Y = "y";
    public static final String AXE = "axe";
    public static final String DATE = "date";
    public static final String CODE_VEHICULE = "codeVehicule";
    public static final String VEHICULE_ANONYMISE = "vehiculeAnonymise";
    public static final String IMMAT_VEHICULE = "immatVehicule";
    public static final String SAL = "sel";
    public static final String DEN = "den";
    public static final String CCH = "cch";
    public static final String TRACE = "trace";
    public static final String MM = "mm";
    public static final String CAP = "cap";
    public static final String VITESSE = "vitesse";
    public static final String ID_WAZE = "id";
    public static final String LOCATION_WAZE = "location";
    public static final String STATUS_WAZE = "status";
    public static final String HEADING_WAZE = "heading";
    public static final String SPEED_WAZE = "speed_kmh";
    public static final String TYPE_WAZE = "type";
    public static final String SUBTYPE_WAZE = "subtype";
    public static final String POLYLINE_WAZE = "polyline";
    public static final String DIRECTION_WAZE = "direction";
    public static final String STREET_WAZE = "street";
    public static final String STARTTIME_WAZE = "starttime";
    public static final String ENDTIME_WAZE = "endtime";
    public static final String DESCRIPTION_WAZE = "description";
    public static final String[] CHAMPS_DEFAUT = new String[]{"x", "y", "axe", "codeVehicule", "date", "cch", "sel", "den", "mm"};

    public DynamicVehiculeExport(MapDescription champsAExporter) {
        super(champsAExporter);
    }

    public static DynamicVehiculeExport convert(MapDescription champsAExporter, VehiculeEnIntervention v, Extension configuration) {
        return DynamicVehiculeExport.convert(champsAExporter, v, configuration, null);
    }

    public static DynamicVehiculeExport convert(MapDescription champsAExporter, VehiculeEnIntervention v, Extension configuration, String typeExportWaze) {
        DynamicVehiculeExport d = new DynamicVehiculeExport(champsAExporter);
        d.ajouter(X, v.getX());
        d.ajouter(Y, v.getY());
        d.ajouter(CODE_VEHICULE, v.getCode());
        int hash = v.getCode().hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        d.ajouter(VEHICULE_ANONYMISE, hash);
        d.ajouter(IMMAT_VEHICULE, v.getImmatriculation());
        d.ajouter(CCH, v.getCch());
        d.ajouter(SAL, v.getDebitSel());
        d.ajouter(DEN, v.getLameBaissee());
        d.ajouter(AXE, v.getAxe());
        d.ajouter(MM, v.getModuleMetier());
        GLS.getDate();
        GLS.getDate();
        d.ajouter(DATE, GLSDate.toDateComplete((Calendar)GLSDate.toDate((long)v.getDatePosition())));
        d.ajouter(VITESSE, v.getVitesse());
        d.ajouter(CAP, v.getCap());
        d.ajouter(ID_WAZE, "" + hash);
        d.ajouter(SPEED_WAZE, "" + v.getVitesse());
        d.ajouter(HEADING_WAZE, "" + Math.round(v.getCap()));
        d.ajouter(LOCATION_WAZE, String.valueOf((float)v.getY()) + " " + (float)v.getX());
        if (typeExportWaze != null && "typeExportWazeIncidents".equals(typeExportWaze)) {
            d.ajouter(TYPE_WAZE, "HAZARD");
        } else {
            d.ajouter(TYPE_WAZE, "SNOW");
        }
        if (configuration != null && configuration.getBoolean("publication.waze.esh.workingnotworking", false)) {
            if (v.getLameBaissee() > 0 || v.getDebitSel() > 0) {
                d.ajouter(STATUS_WAZE, "WORKING");
            } else {
                d.ajouter(STATUS_WAZE, "NOT_WORKING");
            }
        } else {
            d.ajouter(STATUS_WAZE, "WORKING");
        }
        d.ajouter(SUBTYPE_WAZE, "HAZARD_ON_ROAD_EMERGENCY_VEHICLE");
        StringBuffer sb = new StringBuffer();
        sb.append((float)v.getY());
        sb.append(" ");
        sb.append((float)v.getX());
        if (v.getXOld() > -1000.0) {
            sb.append(" ");
            sb.append((float)v.getYOld());
            sb.append(" ");
            sb.append((float)v.getXOld());
        }
        d.ajouter(POLYLINE_WAZE, sb.toString());
        d.ajouter(DIRECTION_WAZE, "ONE_DIRECTION");
        if (GLS.estVide((String)v.getAxe())) {
            d.ajouter(STREET_WAZE, "Route inconnue");
        } else {
            d.ajouter(STREET_WAZE, v.getAxe());
        }
        if (configuration != null) {
            d.ajouter(DESCRIPTION_WAZE, configuration.getString("publication.waze.description." + v.getModuleMetier(), "V\u00e9hicule d\u2019urgence en intervention"));
        }
        if (v.getParametres() != null) {
            for (String k : v.getParametres().getCles()) {
                d.ajouter(k, v.getParametres().getString(k, ""));
            }
        }
        return d;
    }
}

