/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral;

import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class PrismI18n {
    private static final String BUNDLE_NAME = "com.geolocsystems.prismcentral.messages";
    private static final Map<String, ResourceBundle> RESOURCES_MAP = new HashMap<String, ResourceBundle>();

    private PrismI18n() {
    }

    public static String getString(String key) {
        try {
            Locale locale;
            block25: {
                locale = Locale.getDefault();
                if (ConfigurationFactory.getInstance().get("force.locale") == null) break block25;
                switch (ConfigurationFactory.getInstance().get("force.locale")) {
                    case "DE": {
                        locale = Locale.GERMAN;
                        break;
                    }
                    case "FR": {
                        locale = Locale.FRANCE;
                        break;
                    }
                    case "EN": {
                        locale = Locale.ENGLISH;
                        break;
                    }
                    case "ES": {
                        locale = new Locale("es", "ES");
                        break;
                    }
                    case "IT": {
                        locale = Locale.ITALIAN;
                        break;
                    }
                    case "PT": {
                        locale = new Locale("pt", "PT");
                    }
                }
            }
            String language = locale.getLanguage();
            Log.debug("language : " + language);
            if (!RESOURCES_MAP.containsKey(language)) {
                RESOURCES_MAP.put(language, ResourceBundle.getBundle(BUNDLE_NAME, locale));
            }
            return RESOURCES_MAP.get(language).getString(key);
        }
        catch (Exception e) {
            Log.warn("Erreur I18n", e);
            return String.valueOf('!') + key + '!';
        }
    }
}

