/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IPublicationDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IVhDAO;
import com.geolocsystems.prismcentral.DAO.Jdbc.ReferentielDAOJDBC;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.AxeVH;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.BulletinInforoute;
import com.geolocsystems.prismcentral.beans.BulletinInforouteLigne;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2Groupe;
import com.geolocsystems.prismcentral.beans.BulletinMediaVH2Ligne;
import com.geolocsystems.prismcentral.beans.BulletinVH;
import com.geolocsystems.prismcentral.beans.CircuitESVHBean;
import com.geolocsystems.prismcentral.beans.GroupeMediaVH;
import com.geolocsystems.prismcentral.beans.LigneMediaVH;
import com.geolocsystems.prismcentral.beans.PatrouilleVH;
import com.geolocsystems.prismcentral.beans.PrESVHBean;
import com.geolocsystems.prismcentral.beans.SecteurSecondaireVH;
import com.geolocsystems.prismcentral.beans.SecteurVH;
import com.geolocsystems.prismcentral.beans.StatsCamionsVHBean;
import com.geolocsystems.prismcentral.beans.StatsCamionsVHCentreBean;
import com.geolocsystems.prismcentral.beans.TronconESVHBean;
import com.geolocsystems.prismcentral.beans.TypeAxeVH;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import gls.outils.Util;
import gls.outils.sql.SQL;
import java.awt.geom.Point2D;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.postgis.Geometry;

public class VhDAOJDBC
implements IVhDAO {
    private static final String SQL_PATROUILLE_SELECT = "SELECT nom_ct, datetime FROM b_patrouille WHERE nom_ct = ? AND datetime BETWEEN ? AND ?";
    private static final String SQL_PATROUILLE_SELECT_SANS_CT = "SELECT nom_ct, datetime FROM b_patrouille WHERE datetime BETWEEN ? AND ?";
    private static final String SQL_PATROUILLE_DELETE = "DELETE FROM b_patrouille WHERE nom_ct = ? AND datetime BETWEEN ? AND ?";
    private static final String SQL_PATROUILLE_INSERT = "INSERT INTO b_patrouille (nom_ct, datetime) VALUES (?, ?)";
    private static final String SQL_MAX_ID_BULLETIN = "SELECT MAX(id) as id FROM bulletin LIMIT 1";
    private static final String SQL_DERNIER_ID_BULLETIN = "SELECT MAX(id) as id FROM bulletin WHERE nom_ct = ? GROUP BY nom_ct LIMIT 1";
    private static final String SQL_GET_BULLETIN_BY_ID = "SELECT id, datetime, num_situation, redacteur, nb_camion, nb_camion_dati, nom_ct, datetime_save FROM bulletin WHERE id = ? AND nom_ct = ?";
    private static final String SQL_INSERT_BULLETIN = "INSERT INTO bulletin (id, datetime, num_situation, nom_ct, redacteur, nb_camion, nb_camion_dati, datetime_save) VALUES (?,?,?,?,?,?, ?, now())";
    private static final String SQL_NEW_ID_BULLETIN = "SELECT nextval('bulletin_id_seq') as id_bulletin";
    private static final String SQL_UPDATE_BULLETIN = "UPDATE bulletin SET datetime = ? , num_situation = ?, redacteur = ?, nb_camion = ?, nb_camion_dati = ? WHERE nom_ct = ? AND id = ?";
    private static final String SQL_AXE_EXIST = "SELECT 'a' FROM b_axe_bulletin WHERE id_axe = ? AND id_bulletin = ? AND nom_ct = ''";
    private static final String SQL_UPDATE_AXE = "UPDATE b_axe_bulletin SET remarques = ? WHERE id_axe = ? AND id_bulletin = ? AND nom_ct = ''";
    private static final String SQL_INSERT_AXE = "INSERT INTO b_axe_bulletin (id_axe, id_bulletin, nom_ct, remarques) VALUES (?, ?, '', ?)";
    private static final String SQL_SECTEUR_EXIST = "SELECT 'a' FROM b_secteur_bulletin WHERE id_secteur = ? AND id_bulletin = ?";
    private static final String SQL_UPDATE_SECTEUR = "UPDATE b_secteur_bulletin SET condition_circulation = ?, etat_chaussee = ?, intervention = ?, precipitation = ?, remarques = ?, h_appel = ?, interdiction = ? WHERE id_secteur = ? AND id_bulletin = ?";
    private static final String SQL_INSERT_SECTEUR = "INSERT INTO b_secteur_bulletin (id_secteur, id_bulletin, condition_circulation, etat_chaussee, intervention, precipitation, remarques, h_appel, interdiction) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_SECTEUR_SECONDAIRE_EXIST = "SELECT 'a' FROM b_axe_bulletin WHERE id_axe = ? AND id_bulletin = ? AND nom_ct = ?";
    private static final String SQL_UPDATE_SECTEUR_SECONDAIRE = "UPDATE b_axe_bulletin SET condition_circulation = ?, etat_chaussee = ?, intervention = ?, precipitation = ?, remarques = ?, h_appel = ? WHERE id_axe = ? AND id_bulletin = ? AND nom_ct = ?";
    private static final String SQL_INSERT_SECTEUR_SECONDAIRE = "INSERT INTO b_axe_bulletin (id_axe, id_bulletin, nom_ct, condition_circulation, etat_chaussee, intervention, precipitation, remarques, h_appel) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String SQL_SELECT_TYPE_AXE = "SELECT id, nom FROM b_type_axe ORDER BY id";
    private static final String SQL_SELECT_INFO_TYPE_AXE = "SELECT difficulte, meteo, altitude, conditions FROM b_type_axe_bulletin WHERE id_type_axe = ? AND id_bulletin = ?";
    private static final String SQL_GET_NOM_AXE = "SELECT nom FROM b_axe WHERE id = ?";
    private static final String SQL_GET_SECTEUR_BY_TYPE_AXE = "SELECT id, nom, niveau_service, id_axe, ordre FROM b_secteur WHERE id_axe IN (SELECT DISTINCT id FROM b_axe WHERE id_type_axe = ?) ORDER BY ordre ASC, niveau_service ASC";
    private static final String SQL_SELECT_TYPE_AXE_BY_CT = "SELECT id, nom FROM b_type_axe WHERE id IN (SELECT DISTINCT(ba.id_type_axe) FROM b_axe ba, b_secteur bs, b_secteur_ct bsc WHERE ba.id = bs.id_axe AND bs.id = bsc.id_secteur AND bsc.nom_ct = ?) ORDER BY id";
    private static final String SQL_GET_AXE_BY_TYPE_AXE = "SELECT id, nom FROM b_axe WHERE id_type_axe = ? AND nom <> '' AND id IN (SELECT DISTINCT(bs.id_axe) FROM b_secteur bs, b_secteur_ct bsc WHERE bs.id = bsc.id_secteur)ORDER BY ordre ASC, id ASC";
    private static final String SQL_GET_AXE_BY_TYPE_AXE_BY_CT = "SELECT id, nom FROM b_axe WHERE id_type_axe = ? AND id IN (SELECT DISTINCT(bs.id_axe) FROM b_secteur bs, b_secteur_ct bsc WHERE bs.id = bsc.id_secteur AND bsc.nom_ct = ?)ORDER BY ordre ASC, id ASC";
    private static final String SQL_SELECT_INFO_SECTEUR = "SELECT condition_circulation, etat_chaussee, intervention, precipitation, remarques, h_appel FROM b_secteur_bulletin WHERE id_secteur = ? AND id_bulletin = ?";
    private static final String SQL_SELECT_INFO_AXE = "SELECT remarques FROM b_axe_bulletin WHERE id_axe = ? AND nom_ct = '' AND id_bulletin = ?";
    private static final String SQL_GET_SECTEUR_SECONDAIRE_BY_AXE = "SELECT DISTINCT nom_ct FROM b_secteur_ct WHERE id_secteur IN (SELECT DISTINCT id FROM b_secteur WHERE id_axe = ?) ORDER BY nom_ct ASC";
    private static final String SQL_SELECT_INFO_SECTEUR_SECONDAIRE = "SELECT condition_circulation, etat_chaussee, intervention, precipitation, remarques, h_appel FROM b_axe_bulletin WHERE id_axe = ? AND nom_ct = ? AND id_bulletin = ?";
    private static final String SQL_GET_SECTEUR_BY_AXE = "SELECT id, nom, niveau_service FROM b_secteur WHERE id_axe = ? AND id IN (SELECT DISTINCT(bsc.id_secteur) FROM b_secteur_ct bsc WHERE bsc.nom_ct = ?) ORDER BY niveau_service ASC";
    private static final String SQL_SELECT_SECTEUR_NOM_CT = "SELECT nom_ct FROM b_secteur_ct WHERE id_secteur = ? ORDER BY nom_ct ASC";
    private static final String SQL_GET_STRUCTURE_GROUPE_MEDIA = "SELECT g.id as groupe_id, g.libelle as groupe_libelle, g.informations_generale as groupe_informations_generale, l.id as ligne_id, l.libelle as ligne_libelle, l.complement_libelle as ligne_complement_libelle FROM bulletin_media_groupe g, bulletin_media_ligne l WHERE l.id_groupe = g.id ORDER BY g.ordre ASC, l.ordre ASC";
    private static final String SQL_GET_INFORMATIONS_GROUPE_MEDIA = "SELECT bm.id as id_bulletin, bm.date_bulletin as bulletin_date, bm.prochain_bulletin as bulletin_prochain, bmi.id_groupe, bmi.id_ligne, bmi.informations, g.id as groupe_id, g.libelle as groupe_libelle, g.informations_generale as groupe_informations_generale, l.id as ligne_id, l.libelle as ligne_libelle, l.complement_libelle as ligne_complement_libelle FROM bulletin_media bm, bulletin_media_informations bmi, bulletin_media_groupe g, bulletin_media_ligne l WHERE bmi.id_bulletin = bm.id AND bm.id = (SELECT bm.id FROM bulletin_media bm ORDER BY bm.id DESC LIMIT 1) AND ((g.id = bmi.id_groupe AND l.id_groupe = g.id) OR (g.id = l.id_groupe AND l.id = bmi.id_ligne)) ORDER BY g.id ASC, l.id ASC";
    private static final String SQL_NEW_ID_BULLETIN_MEDIA = "SELECT nextval('bulletin_media_id_seq') as id_bulletin";
    private static final String SQL_ENREGISTRER_INFORMATIONS_MEDIA = "INSERT INTO bulletin_media (id, date_bulletin, prochain_bulletin) VALUES (?, ?, ?)";
    private static final String SQL_ENREGISTRER_INFORMATIONS_GROUPE_MEDIA = "INSERT INTO bulletin_media_informations (id_bulletin, id_groupe, informations, id_ligne) VALUES (?, ?, ?, -1)";
    private static final String SQL_ENREGISTRER_INFORMATIONS_LIGNE_MEDIA = "INSERT INTO bulletin_media_informations (id_bulletin, id_ligne, informations, id_groupe) VALUES (?, ?, ?, -1)";
    private static final String SQL_GET_ALL_TRONCONS = "SELECT tce.*, c.nom FROM donnees_metier.troncon_circuit_ext tce, prism.circuit c WHERE tce.idcircuit = c.id AND c.id = ANY(?)";
    private static final String SQL_GET_TRONCONS = "SELECT * FROM donnees_metier.troncon_circuit_ext tce, circuit c WHERE tce.idcircuit = ? AND c.id = tce.idcircuit ORDER BY indice";
    private static final String SQL_GET_TRONCONS_ESVH = "SELECT * FROM vh.donnees_vh_troncon WHERE id = ANY(?) ";
    private static final String SQL_GET_PRS_ESVH = "SELECT * FROM vh.evenement_vh WHERE (id_circuit IN (SELECT id FROM prism.circuit WHERE delegation=?)) AND zone_routiere = ?";
    private static final String SQL_GET_ALL_PRS_ESVH = "SELECT * FROM vh.evenement_vh WHERE zone_routiere = ?";
    private static final String SQL_GET_LAST_CIRCUITS_ESVH_BY_DELEGATION = "SELECT DISTINCT c.nom, tce.idcircuit, c.delegation, dvt.date FROM prism.circuit c, donnees_metier.troncon_circuit_ext tce, vh.donnees_vh_troncon dvt WHERE dvt.id = tce.id AND c.id = tce.idcircuit AND c.delegation = ? ORDER BY dvt.date DESC LIMIT 30";
    private static final String SQL_GET_LAST_CIRCUITS_ESVH = "SELECT DISTINCT c.nom, tce.idcircuit, c.delegation, dvt.date FROM prism.circuit c, donnees_metier.troncon_circuit_ext tce, vh.donnees_vh_troncon dvt WHERE dvt.id = tce.id and c.id = tce.idcircuit ORDER BY dvt.date DESC LIMIT 30";
    private static final String SQL_DELETE_ALL_TRONCONS_ESVH = "DELETE FROM vh.donnees_vh_troncon WHERE id IN (SELECT tce.id FROM donnees_metier.troncon_circuit_ext tce WHERE tce.idcircuit = ANY(?))";
    private static final String SQL_REFRESH_ALL_TRONCONS_ESVH = "UPDATE vh.donnees_vh_troncon SET date = CURRENT_TIMESTAMP WHERE id IN (SELECT tce.id FROM donnees_metier.troncon_circuit_ext tce WHERE tce.idcircuit = ANY(?))";
    private static final String SQL_INSERT_TRONCONS_ESVH = "INSERT INTO vh.donnees_vh_troncon (id, etat_chaussee, cch, date) VALUES (?, ?, ?, CURRENT_TIMESTAMP)";
    private static final String SQL_INSERT_TRONCONS_ESVH_LINE = ",(?, ?, ?, CURRENT_TIMESTAMP)";
    private static final String SQL_UPDATE_TRONCONS_ESVH = "UPDATE vh.donnees_vh_troncon SET etat_chaussee = d2.etat_chaussee, cch = d2.cch, date = CURRENT_TIMESTAMP FROM (VALUES ";
    private static final String SQL_UPDATE_TRONCONS_ESVH_LINE = "(?, ?, ?)";
    private static final String SQL_UPDATE_TRONCONS_ESVH_END = ") AS d2(id, etat_chaussee, cch) WHERE d2.id = donnees_vh_troncon.id";
    private static final String SQL_UPDATE_PRS_ESVH = "UPDATE vh.evenement_vh SET etat = e2.etat_chaussee, cch = e2.cch, date = CURRENT_TIMESTAMP FROM (VALUES ";
    private static final String SQL_UPDATE_PRS_ESVH_LINE = "(?, ?, ?)";
    private static final String SQL_UPDATE_PRS_ESVH_END = ") AS e2(id, etat_chaussee, cch) WHERE e2.id = evenement_vh.id";
    private static final String SQL_REFRESH_TRONCONS_ESVH = "UPDATE vh.donnees_vh_troncon SET date = CURRENT_TIMESTAMP WHERE id = ANY(?)";
    private static final String SQL_REFRESH_PRS_ESVH = "UPDATE vh.evenement_vh SET date = CURRENT_TIMESTAMP WHERE id = ANY(?)";
    private static final String SQL_DELETE_PRS_ESVH = "DELETE FROM vh.evenement_vh WHERE id = ANY(?)";
    private static final String SQL_ADD_PR_DYNAMIQUE = "INSERT INTO vh.evenement_vh(axe, date, prdebut, prfin, abscisseprfin, abscisseprdebut, etat, zone_routiere, id_circuit, id, coordonnees, longueur, cch)\tVALUES (?, CURRENT_TIMESTAMP, ?, ?, ?, ?, ?, ?, ?, ?,GeomFromText(?,?), ?, ?);";
    private static final String SQL_TRONCONS_VH_A_RENOUVELER = "SELECT * FROM donnees_metier.troncon_circuit_ext tce, vh.donnees_vh_troncon dvt WHERE tce.delegation = ? AND tce.id = dvt.id AND dvt.date < ?";
    private static final String SQL_PRS_VH_A_RENOUVELER = "SELECT * FROM vh.evenement_vh ev WHERE ev.date < ?";
    private static final String SQL_TRONCONS_VH_MIS_A_JOUR = "SELECT * FROM donnees_metier.troncon_circuit_ext tce, vh.donnees_vh_troncon dvt WHERE tce.id = dvt.id AND (dvt.date > ? OR tce.maj > ?) ";
    private static final String SQL_CAMIONS_VH = "select b.nom_ct, date_trunc('day',b.datetime) as jour, max(b.nb_camion) as max_camion, max(b.nb_camion_dati) as max_camion_dati from bulletin b where b.nom_ct = ANY(?) and b.datetime > ? and b.datetime < ? group by b.nom_ct, jour ORDER BY b.nom_ct ASC, jour ASC";
    private DAOFactory daoFactory;
    private IPublicationDAO pubDAO;
    private IReferentielDAO refDAO;
    static HashMap<String, String> synchro = new HashMap();

    public VhDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO, IPublicationDAO pubDAO) {
        this.daoFactory = daoFactory;
        this.pubDAO = pubDAO;
        this.refDAO = refDAO;
    }

    @Override
    public void updatePatrouilleVH(PatrouilleVH patrouille) {
        Calendar cal;
        Connection connection = null;
        PreparedStatement pstm = null;
        String req = SQL_PATROUILLE_DELETE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, patrouille.getNomCT());
                cal = patrouille.getDate();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                pstm.setTimestamp(2, new Timestamp(cal.getTimeInMillis()));
                cal.set(11, 23);
                cal.set(12, 59);
                pstm.setTimestamp(3, new Timestamp(cal.getTimeInMillis()));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (patrouille.getHeure() != 0 || patrouille.getMinute() != 0) {
            cal = patrouille.getDate();
            cal.set(11, patrouille.getHeure());
            cal.set(12, patrouille.getMinute());
            connection = null;
            pstm = null;
            req = SQL_PATROUILLE_INSERT;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(req);
                    pstm.setString(1, patrouille.getNomCT());
                    pstm.setTimestamp(2, new Timestamp(patrouille.getDate().getTimeInMillis()));
                    pstm.execute();
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            finally {
                DAOUtil.close(connection, pstm);
            }
        }
    }

    @Override
    public List<PatrouilleVH> getPatrouillesVH(Calendar date) {
        return this.getPatrouillesVH(date, date);
    }

    @Override
    public List<PatrouilleVH> getPatrouillesVH(Calendar dateDebut, Calendar dateFin) {
        ArrayList<PatrouilleVH> patrouillesVH = new ArrayList<PatrouilleVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_PATROUILLE_SELECT_SANS_CT;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                Calendar calDebut = dateDebut;
                calDebut.set(11, 0);
                calDebut.set(12, 0);
                calDebut.set(13, 0);
                pstm.setTimestamp(1, new Timestamp(calDebut.getTimeInMillis()));
                Calendar calFin = dateFin;
                calFin.set(11, 23);
                calFin.set(12, 59);
                pstm.setTimestamp(2, new Timestamp(calFin.getTimeInMillis()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PatrouilleVH patrouilleVH = new PatrouilleVH();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(rs.getTimestamp("datetime").getTime());
                    patrouilleVH.setDate(calendar);
                    patrouilleVH.setHeure(calendar.get(11));
                    patrouilleVH.setMinute(calendar.get(12));
                    patrouilleVH.setNomCT(rs.getString("nom_ct"));
                    patrouillesVH.add(patrouilleVH);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouillesVH;
    }

    @Override
    public int getDernierIdBulletin(String nomCT) {
        int idBulletin = 0;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_DERNIER_ID_BULLETIN;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, nomCT);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    idBulletin = rs.getInt("id");
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return idBulletin;
    }

    public int getMaxIdBulletin() {
        int idBulletin = 0;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_MAX_ID_BULLETIN;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    idBulletin = rs.getInt("id");
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return idBulletin;
    }

    @Override
    public HashMap<String, BulletinVH> getDerniersBulletinsCTCG() {
        HashMap<String, BulletinVH> derniersBulletins = new HashMap<String, BulletinVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT b1.* FROM prism.bulletin b1 WHERE b1.id = (SELECT MAX(b2.id) as max_id FROM prism.bulletin b2 WHERE b2.nom_ct = b1.nom_ct) AND nom_ct <> ''";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String minute;
                    String mois;
                    String moisTmp;
                    BulletinVH bulletin = new BulletinVH();
                    bulletin.setId(rs.getInt("id"));
                    Calendar cal = Calendar.getInstance();
                    String jourTmp = Integer.valueOf(cal.get(5)).toString();
                    if (jourTmp.length() < 2) {
                        jourTmp = "0" + jourTmp;
                    }
                    if ((moisTmp = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
                        moisTmp = "0" + moisTmp;
                    }
                    String dateJour = String.valueOf(jourTmp) + "/" + moisTmp + "/" + cal.get(1);
                    cal.setTime(rs.getTimestamp("datetime"));
                    String jour = Integer.valueOf(cal.get(5)).toString();
                    if (jour.length() < 2) {
                        jour = "0" + jour;
                    }
                    if ((mois = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
                        mois = "0" + mois;
                    }
                    bulletin.setDate(String.valueOf(jour) + "/" + mois + "/" + cal.get(1));
                    String heures = Integer.valueOf(cal.get(11)).toString();
                    if (heures.length() < 2) {
                        heures = "0" + heures;
                    }
                    if ((minute = Integer.valueOf(cal.get(12)).toString()).length() < 2) {
                        minute = "0" + minute;
                    }
                    bulletin.setHeure(String.valueOf(heures) + ":" + minute);
                    bulletin.setDatetime(String.valueOf(cal.get(1)) + "/" + mois + "/" + jour + " " + heures + ":" + minute);
                    bulletin.setNumSituation(rs.getInt("num_situation"));
                    bulletin.setNbCamion(rs.getInt("nb_camion"));
                    bulletin.setNbCamionDATI(rs.getInt("nb_camion_dati"));
                    if (bulletin.getDate().equals(dateJour)) {
                        bulletin.setNumSituation(rs.getInt("num_situation") + 1);
                    } else if (rs.getString("nom_ct") == null || rs.getString("nom_ct").equals("")) {
                        bulletin.setNumSituation(0);
                        bulletin.setNbCamion(0);
                        bulletin.setNbCamionDATI(0);
                    } else {
                        bulletin.setNumSituation(1);
                        bulletin.setNbCamion(0);
                        bulletin.setNbCamionDATI(0);
                    }
                    bulletin.setRedacteur(rs.getString("redacteur"));
                    bulletin.setNomCT(rs.getString("nom_ct"));
                    derniersBulletins.put(rs.getString("nom_ct"), bulletin);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return derniersBulletins;
    }

    @Override
    public BulletinVH getBulletin(int id, String nomCT) {
        BulletinVH bulletin = new BulletinVH();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_BULLETIN_BY_ID;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, id);
                pstm.setString(2, nomCT);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    String seconde;
                    String minute;
                    String mois;
                    String moisTmp;
                    bulletin.setId(rs.getInt("id"));
                    Calendar cal = Calendar.getInstance();
                    String jourTmp = Integer.valueOf(cal.get(5)).toString();
                    if (jourTmp.length() < 2) {
                        jourTmp = "0" + jourTmp;
                    }
                    if ((moisTmp = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
                        moisTmp = "0" + moisTmp;
                    }
                    String dateJour = String.valueOf(jourTmp) + "/" + moisTmp + "/" + cal.get(1);
                    cal.setTime(rs.getTimestamp("datetime"));
                    String jour = Integer.valueOf(cal.get(5)).toString();
                    if (jour.length() < 2) {
                        jour = "0" + jour;
                    }
                    if ((mois = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
                        mois = "0" + mois;
                    }
                    bulletin.setDate(String.valueOf(jour) + "/" + mois + "/" + cal.get(1));
                    String heures = Integer.valueOf(cal.get(11)).toString();
                    if (heures.length() < 2) {
                        heures = "0" + heures;
                    }
                    if ((minute = Integer.valueOf(cal.get(12)).toString()).length() < 2) {
                        minute = "0" + minute;
                    }
                    bulletin.setHeure(String.valueOf(heures) + ":" + minute);
                    bulletin.setDatetime(String.valueOf(cal.get(1)) + "/" + mois + "/" + jour + " " + heures + ":" + minute);
                    cal.setTime(rs.getTimestamp("datetime_save"));
                    jour = Integer.valueOf(cal.get(5)).toString();
                    if (jour.length() < 2) {
                        jour = "0" + jour;
                    }
                    if ((mois = Integer.valueOf(cal.get(2) + 1).toString()).length() < 2) {
                        mois = "0" + mois;
                    }
                    bulletin.setDate(String.valueOf(jour) + "/" + mois + "/" + cal.get(1));
                    heures = Integer.valueOf(cal.get(11)).toString();
                    if (heures.length() < 2) {
                        heures = "0" + heures;
                    }
                    if ((minute = Integer.valueOf(cal.get(12)).toString()).length() < 2) {
                        minute = "0" + minute;
                    }
                    if ((seconde = Integer.valueOf(cal.get(13)).toString()).length() < 2) {
                        seconde = "0" + minute;
                    }
                    bulletin.setDatetimeSave(String.valueOf(cal.get(1)) + "/" + mois + "/" + jour + " " + heures + ":" + minute + ":" + seconde);
                    bulletin.setNumSituation(rs.getInt("num_situation"));
                    bulletin.setNbCamion(rs.getInt("nb_camion"));
                    bulletin.setNbCamionDATI(rs.getInt("nb_camion_dati"));
                    if (bulletin.getDate().equals(dateJour)) {
                        bulletin.setNumSituation(rs.getInt("num_situation") + 1);
                    } else if (rs.getString("nom_ct") == null || rs.getString("nom_ct").equals("")) {
                        bulletin.setNumSituation(0);
                        bulletin.setNbCamion(0);
                        bulletin.setNbCamionDATI(0);
                    } else {
                        bulletin.setNumSituation(1);
                        bulletin.setNbCamion(0);
                        bulletin.setNbCamionDATI(0);
                    }
                    bulletin.setRedacteur(rs.getString("redacteur"));
                    bulletin.setNomCT(rs.getString("nom_ct"));
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return bulletin;
    }

    public int recupIdBulletin() {
        int idBulletin = 0;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_NEW_ID_BULLETIN;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    idBulletin = rs.getInt("id_bulletin");
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return idBulletin;
    }

    @Override
    public void enregistrerBulletin(BulletinVH bulletin) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        try {
            date = sdf.parse(String.valueOf(bulletin.getDate()) + " " + bulletin.getHeure());
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        Timestamp dateTime = new Timestamp(date.getTime());
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        bulletin.setId(this.getMaxIdBulletin() + 1);
        int indexTypeAxe = 0;
        while (indexTypeAxe < bulletin.getNbTypesAxe()) {
            this.enregistrerTypeAxe((TypeAxeVH)bulletin.getTypesAxe().get(indexTypeAxe), bulletin.getId());
            ++indexTypeAxe;
        }
        try {
            try {
                String req = SQL_INSERT_BULLETIN;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, bulletin.getId());
                pstm.setTimestamp(2, dateTime);
                pstm.setInt(3, bulletin.getNumSituation());
                pstm.setString(4, bulletin.getNomCT());
                pstm.setString(5, bulletin.getRedacteur());
                pstm.setInt(6, bulletin.getNbCamion());
                pstm.setInt(7, bulletin.getNbCamionDATI());
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void enregistrerTypeAxe(TypeAxeVH typeAxe, int idBulletin) {
        int indexAxe = 0;
        while (indexAxe < typeAxe.getNbAxes()) {
            this.enregistrerAxe((AxeVH)typeAxe.getAxes().get(indexAxe), idBulletin);
            int indexSecteur = 0;
            while (indexSecteur < ((AxeVH)typeAxe.getAxes().get(indexAxe)).getNbSecteurs()) {
                this.enregistrerSecteur((SecteurVH)((AxeVH)typeAxe.getAxes().get(indexAxe)).getSecteurs().get(indexSecteur), idBulletin);
                ++indexSecteur;
            }
            indexSecteur = 0;
            while (indexSecteur < ((AxeVH)typeAxe.getAxes().get(indexAxe)).getNbSecteursSecondaire()) {
                this.enregistrerSecteurSecondaire((SecteurSecondaireVH)((AxeVH)typeAxe.getAxes().get(indexAxe)).getSecteursSecondaire().get(indexSecteur), idBulletin);
                ++indexSecteur;
            }
            ++indexAxe;
        }
        int indexSecteur = 0;
        while (indexSecteur < typeAxe.getNbSecteurs()) {
            this.enregistrerSecteur((SecteurVH)typeAxe.getSecteurs().get(indexSecteur), idBulletin);
            ++indexSecteur;
        }
    }

    public void enregistrerAxe(AxeVH axe, int idBulletin) {
        boolean AxeBulletinExiste = false;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String req = SQL_AXE_EXIST;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, axe.getId());
                pstm.setInt(2, idBulletin);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    AxeBulletinExiste = true;
                }
                pstm.close();
                pstm = null;
                if (AxeBulletinExiste) {
                    req = SQL_UPDATE_AXE;
                    pstm = connection.prepareStatement(req);
                    pstm.setString(1, axe.getRemarques());
                    pstm.setInt(2, axe.getId());
                    pstm.setInt(3, idBulletin);
                    pstm.executeUpdate();
                    pstm.close();
                } else {
                    req = SQL_INSERT_AXE;
                    pstm = connection.prepareStatement(req);
                    pstm.setInt(1, axe.getId());
                    pstm.setInt(2, idBulletin);
                    pstm.setString(3, axe.getRemarques());
                    pstm.executeUpdate();
                    pstm.close();
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void enregistrerSecteur(SecteurVH secteur, int idBulletin) {
        boolean SecteurBulletinExiste = false;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        secteur.updatePrecipitation();
        try {
            try {
                String req = SQL_SECTEUR_EXIST;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, secteur.getId());
                pstm.setInt(2, idBulletin);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    SecteurBulletinExiste = true;
                }
                pstm.close();
                pstm = null;
                if (SecteurBulletinExiste) {
                    req = SQL_UPDATE_SECTEUR;
                    pstm = connection.prepareStatement(req);
                    if (secteur.getConditionCirculation() != null) {
                        pstm.setString(1, secteur.getConditionCirculation());
                    } else {
                        pstm.setString(1, "");
                    }
                    if (secteur.getEtatChaussee() != null) {
                        pstm.setString(2, secteur.getEtatChaussee());
                    } else {
                        pstm.setString(2, "");
                    }
                    if (secteur.getIntervention() != null) {
                        pstm.setString(3, secteur.getIntervention());
                    } else {
                        pstm.setString(3, "");
                    }
                    pstm.setInt(4, secteur.getPrecipitation());
                    pstm.setString(5, secteur.getRemarques());
                    pstm.setString(6, secteur.gethAppel());
                    pstm.setBoolean(7, secteur.isInterdiction());
                    pstm.setInt(8, secteur.getId());
                    pstm.setInt(9, idBulletin);
                    pstm.executeUpdate();
                    pstm.close();
                } else {
                    req = SQL_INSERT_SECTEUR;
                    pstm = connection.prepareStatement(req);
                    pstm.setInt(1, secteur.getId());
                    pstm.setInt(2, idBulletin);
                    if (secteur.getConditionCirculation() != null) {
                        pstm.setString(3, secteur.getConditionCirculation());
                    } else {
                        pstm.setString(3, "");
                    }
                    if (secteur.getEtatChaussee() != null) {
                        pstm.setString(4, secteur.getEtatChaussee());
                    } else {
                        pstm.setString(4, "");
                    }
                    if (secteur.getIntervention() != null) {
                        pstm.setString(5, secteur.getIntervention());
                    } else {
                        pstm.setString(5, "");
                    }
                    pstm.setInt(6, secteur.getPrecipitation());
                    pstm.setString(7, secteur.getRemarques());
                    pstm.setString(8, secteur.gethAppel());
                    pstm.setBoolean(9, secteur.isInterdiction());
                    pstm.executeUpdate();
                    pstm.close();
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    public void enregistrerSecteurSecondaire(SecteurSecondaireVH secteurSecondaire, int idBulletin) {
        boolean AxeBulletinExiste = false;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String req = SQL_SECTEUR_SECONDAIRE_EXIST;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, secteurSecondaire.getIdAxe());
                pstm.setInt(2, idBulletin);
                pstm.setString(3, secteurSecondaire.getNomCT());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    AxeBulletinExiste = true;
                }
                pstm.close();
                pstm = null;
                if (AxeBulletinExiste) {
                    req = SQL_UPDATE_SECTEUR_SECONDAIRE;
                    pstm = connection.prepareStatement(req);
                    if (secteurSecondaire.getConditionCirculation() != null) {
                        pstm.setString(1, secteurSecondaire.getConditionCirculation());
                    } else {
                        pstm.setString(1, "");
                    }
                    if (secteurSecondaire.getEtatChaussee() != null) {
                        pstm.setString(2, secteurSecondaire.getEtatChaussee());
                    } else {
                        pstm.setString(2, "");
                    }
                    if (secteurSecondaire.getIntervention() != null) {
                        pstm.setString(3, secteurSecondaire.getIntervention());
                    } else {
                        pstm.setString(3, "");
                    }
                    pstm.setInt(4, secteurSecondaire.getPrecipitation());
                    pstm.setString(5, secteurSecondaire.getRemarques());
                    pstm.setString(6, secteurSecondaire.gethAppel());
                    pstm.setInt(7, secteurSecondaire.getIdAxe());
                    pstm.setInt(8, idBulletin);
                    pstm.setString(9, secteurSecondaire.getNomCT());
                    pstm.executeUpdate();
                    pstm.close();
                } else {
                    req = SQL_INSERT_SECTEUR_SECONDAIRE;
                    pstm = connection.prepareStatement(req);
                    pstm.setInt(1, secteurSecondaire.getIdAxe());
                    pstm.setInt(2, idBulletin);
                    pstm.setString(3, secteurSecondaire.getNomCT());
                    if (secteurSecondaire.getConditionCirculation() != null) {
                        pstm.setString(4, secteurSecondaire.getConditionCirculation());
                    } else {
                        pstm.setString(4, "");
                    }
                    if (secteurSecondaire.getEtatChaussee() != null) {
                        pstm.setString(5, secteurSecondaire.getEtatChaussee());
                    } else {
                        pstm.setString(5, "");
                    }
                    if (secteurSecondaire.getIntervention() != null) {
                        pstm.setString(6, secteurSecondaire.getIntervention());
                    } else {
                        pstm.setString(6, "");
                    }
                    pstm.setInt(7, secteurSecondaire.getPrecipitation());
                    pstm.setString(8, secteurSecondaire.getRemarques());
                    pstm.setString(9, secteurSecondaire.gethAppel());
                    pstm.executeUpdate();
                    pstm.close();
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public PatrouilleVH getPatrouilleVH(String nomCT, Calendar date) {
        PatrouilleVH patrouille = new PatrouilleVH();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_PATROUILLE_SELECT;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, nomCT);
                Calendar cal = date;
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                pstm.setTimestamp(2, new Timestamp(cal.getTimeInMillis()));
                cal.set(11, 23);
                cal.set(12, 59);
                pstm.setTimestamp(3, new Timestamp(cal.getTimeInMillis()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(rs.getTimestamp("datetime").getTime());
                    patrouille.setDate(calendar);
                    patrouille.setHeure(calendar.get(11));
                    patrouille.setMinute(calendar.get(12));
                    patrouille.setNomCT(rs.getString("nom_ct"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return patrouille;
    }

    @Override
    public List<TypeAxeVH> getTypesAxe(int typeBulletin, int idBulletin) {
        ArrayList<TypeAxeVH> typesAxe = new ArrayList<TypeAxeVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String req = SQL_SELECT_TYPE_AXE;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TypeAxeVH typeAxe = new TypeAxeVH(rs.getInt("id"), rs.getString("nom"));
                    if ((typeAxe = this.getTypeAxeBulletin(typeAxe, idBulletin)).getId() != 3) {
                        typeAxe.setSecteurs(this.getSecteurs(typeAxe.getId(), idBulletin));
                    } else {
                        typeAxe.setAxes(this.getAxes(typeAxe.getId(), "", idBulletin));
                    }
                    typeAxe.setNbAxes(typeAxe.getAxes().size());
                    typeAxe.setNbSecteurs(typeAxe.getSecteurs().size());
                    typesAxe.add(typeAxe);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return typesAxe;
    }

    @Override
    public List<TypeAxeVH> getTypesAxeV2(int typeBulletin, int idBulletin) {
        TypeAxeVH typeAxe;
        ArrayList<Integer> indexTypeAxeOrdonnee = new ArrayList<Integer>();
        HashMap<Integer, TypeAxeVH> typesAxe = new HashMap<Integer, TypeAxeVH>();
        HashMap<Integer, AxeVH> axes = new HashMap<Integer, AxeVH>();
        HashMap<Integer, SecteurVH> secteurs = new HashMap<Integer, SecteurVH>();
        HashMap<String, SecteurSecondaireVH> secteursSecondaire = new HashMap<String, SecteurSecondaireVH>();
        HashMap<Integer, TypeAxeVH> typesAxeBulletin = this.getTypesAxeBulletin(idBulletin);
        HashMap<Integer, SecteurVH> secteursBulletin = this.getSecteursBulletin(idBulletin);
        HashMap<Integer, AxeVH> axesBulletin = this.getAxesBulletin(idBulletin);
        HashMap<String, SecteurSecondaireVH> secteursSecondaireBulletin = this.getSecteursSecondaireBulletin(idBulletin);
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT bta.id as type_axe_id, bta.ordre as type_axe_ordre, bta.nom as type_axe_nom, ba.id as axe_id, bs.id as secteur_id, bs.nom as secteur_nom, bs.niveau_service as secteur_niveau_service, bs.ordre as ordre_secteur FROM prism.b_type_axe bta,\tprism.b_axe ba,\tprism.b_secteur bs WHERE ba.id_type_axe = bta.id AND bs.id_axe = ba.id AND bta.id != 3 ORDER BY bta.ordre ASC, bs.ordre ASC, ba.ordre ASC, bs.niveau_service ASC";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    if (typesAxe.get(rs.getInt("type_axe_id")) == null) {
                        indexTypeAxeOrdonnee.add(rs.getInt("type_axe_id"));
                        typeAxe = new TypeAxeVH(rs.getInt("type_axe_id"), rs.getString("type_axe_nom"));
                        if (typesAxeBulletin.get(typeAxe.getId()) != null) {
                            typeAxe.setDifficulte(typesAxeBulletin.get(typeAxe.getId()).getDifficulte());
                            typeAxe.setMeteo(typesAxeBulletin.get(typeAxe.getId()).getMeteo());
                            typeAxe.setAltitude(typesAxeBulletin.get(typeAxe.getId()).getAltitude());
                            typeAxe.setConditions(typesAxeBulletin.get(typeAxe.getId()).getConditions());
                        }
                        typesAxe.put(typeAxe.getId(), typeAxe);
                    }
                    if (secteurs.get(rs.getInt("secteur_id")) != null) continue;
                    SecteurVH secteur = new SecteurVH(rs.getInt("secteur_id"), rs.getString("secteur_nom"), rs.getString("secteur_niveau_service"));
                    secteur.setNomAxe(this.getNomAxe(rs.getInt("axe_id")));
                    secteur.setNomCT(this.getSecteurNomCT(secteur.getId()));
                    secteur.setOrdre(rs.getInt("ordre_secteur"));
                    secteur.setResponsable(this.getSecteurNomCT(secteur.getId()));
                    secteur.setSource("op\u00e9rateur");
                    if (secteursBulletin.get(secteur.getId()) != null) {
                        secteur.setConditionCirculation(secteursBulletin.get(secteur.getId()).getConditionCirculation());
                        secteur.setEtatChaussee(secteursBulletin.get(secteur.getId()).getEtatChaussee());
                        secteur.setIntervention(secteursBulletin.get(secteur.getId()).getIntervention());
                        secteur.setPrecipitation(secteursBulletin.get(secteur.getId()).getPrecipitation());
                        secteur.setRemarques(secteursBulletin.get(secteur.getId()).getRemarques());
                        secteur.sethAppel(secteursBulletin.get(secteur.getId()).gethAppel());
                        secteur.setInterdiction(secteursBulletin.get(secteur.getId()).isInterdiction());
                    }
                    secteurs.put(secteur.getId(), secteur);
                    ((TypeAxeVH)typesAxe.get(rs.getInt("type_axe_id"))).addSecteur(secteur);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        connection = null;
        pstm = null;
        rs = null;
        req = "SELECT DISTINCT bta.id as type_axe_id, bta.nom as type_axe_nom, ba.id as axe_id, ba.nom as axe_nom, ba.ordre as axe_ordre, bsc.nom_ct as secteur_nom_ct FROM prism.b_secteur_ct bsc, prism.b_secteur bs, prism.b_axe ba, prism.b_type_axe bta WHERE bsc.id_secteur = bs.id AND bs.id_axe = ba.id AND ba.id_type_axe = bta.id AND bta.id = 3 AND ba.nom <> '' ORDER BY ba.ordre ASC, ba.id ASC, bsc.nom_ct ASC";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    if (typesAxe.get(rs.getInt("type_axe_id")) == null) {
                        indexTypeAxeOrdonnee.add(rs.getInt("type_axe_id"));
                        typeAxe = new TypeAxeVH(rs.getInt("type_axe_id"), rs.getString("type_axe_nom"));
                        if (typesAxeBulletin.get(typeAxe.getId()) != null) {
                            typeAxe.setDifficulte(typesAxeBulletin.get(typeAxe.getId()).getDifficulte());
                            typeAxe.setMeteo(typesAxeBulletin.get(typeAxe.getId()).getMeteo());
                            typeAxe.setAltitude(typesAxeBulletin.get(typeAxe.getId()).getAltitude());
                            typeAxe.setConditions(typesAxeBulletin.get(typeAxe.getId()).getConditions());
                        }
                        typesAxe.put(typeAxe.getId(), typeAxe);
                    }
                    if (axes.get(rs.getInt("axe_id")) == null) {
                        AxeVH axe = new AxeVH(rs.getInt("axe_id"), rs.getString("axe_nom"));
                        if (axesBulletin.get(axe.getId()) != null) {
                            axe.setRemarques(axesBulletin.get(axe.getId()).getRemarques());
                        }
                        axes.put(axe.getId(), axe);
                        ((TypeAxeVH)typesAxe.get(rs.getInt("type_axe_id"))).addAxe(axe);
                    }
                    if (secteursSecondaire.get(String.valueOf(rs.getInt("axe_id")) + rs.getString("secteur_nom_ct")) != null) continue;
                    SecteurSecondaireVH secteurSecondaire = new SecteurSecondaireVH(rs.getInt("axe_id"), rs.getString("secteur_nom_ct"));
                    secteurSecondaire.setResponsable(rs.getString("secteur_nom_ct"));
                    secteurSecondaire.setSource("op\u00e9rateur");
                    if (secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()) != null) {
                        secteurSecondaire.setConditionCirculation(secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()).getConditionCirculation());
                        secteurSecondaire.setEtatChaussee(secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()).getEtatChaussee());
                        secteurSecondaire.setIntervention(secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()).getIntervention());
                        secteurSecondaire.setPrecipitation(secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()).getPrecipitation());
                        secteurSecondaire.setRemarques(secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()).getRemarques());
                        secteurSecondaire.sethAppel(secteursSecondaireBulletin.get(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT()).gethAppel());
                    }
                    secteursSecondaire.put(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT(), secteurSecondaire);
                    ((AxeVH)axes.get(rs.getInt("axe_id"))).addSecteurSecondaire(secteurSecondaire);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        ArrayList<TypeAxeVH> typesAxeReturn = new ArrayList<TypeAxeVH>();
        Iterator iterator = indexTypeAxeOrdonnee.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            typesAxeReturn.add((TypeAxeVH)typesAxe.get(index));
        }
        return typesAxeReturn;
    }

    public List<SecteurVH> getSecteurs(int idTypeAxe, int idBulletin) {
        ArrayList<SecteurVH> secteurs = new ArrayList<SecteurVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_SECTEUR_BY_TYPE_AXE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idTypeAxe);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    SecteurVH secteur = new SecteurVH(rs.getInt("id"), rs.getString("nom"), rs.getString("niveau_service"));
                    secteur.setOrdre(rs.getInt("ordre"));
                    secteur.setNomAxe(this.getNomAxe(rs.getInt("id_axe")));
                    secteur = this.getSecteurBulletin(secteur, idBulletin);
                    secteur.setNomCT(this.getSecteurNomCT(secteur.getId()));
                    secteurs.add(secteur);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteurs;
    }

    public SecteurVH getSecteurBulletin(SecteurVH secteur, int idBulletin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_SELECT_INFO_SECTEUR;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, secteur.getId());
                pstm.setInt(2, idBulletin);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    secteur.setConditionCirculation(rs.getString("condition_circulation"));
                    secteur.setEtatChaussee(rs.getString("etat_chaussee"));
                    secteur.setIntervention(rs.getString("intervention"));
                    secteur.setPrecipitation(rs.getInt("precipitation"));
                    if (rs.getString("remarques") == null) {
                        secteur.setRemarques("");
                    } else {
                        secteur.setRemarques(rs.getString("remarques"));
                    }
                    if (rs.getString("h_appel") == null) {
                        secteur.sethAppel("");
                    } else {
                        secteur.sethAppel(rs.getString("h_appel"));
                    }
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteur;
    }

    public HashMap<Integer, SecteurVH> getSecteursBulletin(int idBulletin) {
        HashMap<Integer, SecteurVH> secteursBulletin = new HashMap<Integer, SecteurVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT id_secteur, condition_circulation, etat_chaussee, intervention, precipitation, remarques, h_appel, interdiction FROM b_secteur_bulletin WHERE id_bulletin = ? ORDER BY id_secteur ASC";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idBulletin);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    SecteurVH secteur = new SecteurVH(rs.getInt("id_secteur"), "", "");
                    if (rs.getString("condition_circulation") == null) {
                        secteur.setConditionCirculation("");
                    } else {
                        secteur.setConditionCirculation(rs.getString("condition_circulation"));
                    }
                    if (rs.getString("etat_chaussee") == null) {
                        secteur.setEtatChaussee("");
                    } else {
                        secteur.setEtatChaussee(rs.getString("etat_chaussee"));
                    }
                    if (rs.getString("intervention") == null) {
                        secteur.setIntervention("");
                    } else {
                        secteur.setIntervention(rs.getString("intervention"));
                    }
                    secteur.setPrecipitation(rs.getInt("precipitation"));
                    if (rs.getString("remarques") == null) {
                        secteur.setRemarques("");
                    } else {
                        secteur.setRemarques(rs.getString("remarques"));
                    }
                    if (rs.getString("h_appel") == null) {
                        secteur.sethAppel("");
                    } else {
                        secteur.sethAppel(rs.getString("h_appel"));
                    }
                    secteur.setInterdiction(rs.getBoolean("interdiction"));
                    secteursBulletin.put(secteur.getId(), secteur);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteursBulletin;
    }

    public String getSecteurNomCT(int idSecteur) {
        String nomCT = "";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_SELECT_SECTEUR_NOM_CT;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idSecteur);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    if (!nomCT.equals("")) {
                        nomCT = String.valueOf(nomCT) + " - ";
                    }
                    nomCT = String.valueOf(nomCT) + rs.getString("nom_ct");
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return nomCT;
    }

    public String getNomAxe(int idAxe) {
        String nomAxe = "";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_NOM_AXE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idAxe);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    nomAxe = String.valueOf(nomAxe) + rs.getString("nom");
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return nomAxe;
    }

    public TypeAxeVH getTypeAxeBulletin(TypeAxeVH typeAxe, int idBulletin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_SELECT_INFO_TYPE_AXE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, typeAxe.getId());
                pstm.setInt(2, idBulletin);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    typeAxe.setDifficulte(rs.getString("difficulte"));
                    typeAxe.setMeteo(rs.getString("meteo"));
                    typeAxe.setAltitude(rs.getString("altitude"));
                    typeAxe.setConditions(rs.getString("conditions"));
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return typeAxe;
    }

    public HashMap<Integer, TypeAxeVH> getTypesAxeBulletin(int idBulletin) {
        HashMap<Integer, TypeAxeVH> typesAxe = new HashMap<Integer, TypeAxeVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT id_type_axe, difficulte, meteo, altitude, conditions FROM b_type_axe_bulletin WHERE id_bulletin = ? ORDER BY id_type_axe";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idBulletin);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TypeAxeVH typeAxe = new TypeAxeVH(rs.getInt("id_type_axe"), "");
                    typeAxe.setDifficulte(rs.getString("difficulte"));
                    typeAxe.setMeteo(rs.getString("meteo"));
                    typeAxe.setAltitude(rs.getString("altitude"));
                    typeAxe.setConditions(rs.getString("conditions"));
                    typesAxe.put(typeAxe.getId(), typeAxe);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return typesAxe;
    }

    @Override
    public List<TypeAxeVH> getTypesAxe(String nomCT, int idBulletin) {
        ArrayList<TypeAxeVH> typesAxe = new ArrayList<TypeAxeVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_SELECT_TYPE_AXE_BY_CT;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, nomCT);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TypeAxeVH typeAxe = new TypeAxeVH(rs.getInt("id"), rs.getString("nom"));
                    typeAxe = this.getTypeAxeBulletin(typeAxe, idBulletin);
                    typeAxe.setAxes(this.getAxes(typeAxe.getId(), nomCT, idBulletin));
                    typeAxe.setNbAxes(typeAxe.getAxes().size());
                    typesAxe.add(typeAxe);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return typesAxe;
    }

    @Override
    public List<TypeAxeVH> getTypesAxeV2(String nomCT, int idBulletin) {
        ArrayList<Integer> indexTypeAxeOrdonnee = new ArrayList<Integer>();
        HashMap<Integer, TypeAxeVH> typesAxe = new HashMap<Integer, TypeAxeVH>();
        HashMap<Integer, AxeVH> axes = new HashMap<Integer, AxeVH>();
        HashMap<Integer, SecteurVH> secteurs = new HashMap<Integer, SecteurVH>();
        HashMap<Integer, TypeAxeVH> typesAxeBulletin = this.getTypesAxeBulletin(idBulletin);
        HashMap<Integer, SecteurVH> secteursBulletin = this.getSecteursBulletin(idBulletin);
        HashMap<Integer, AxeVH> axesBulletin = this.getAxesBulletin(idBulletin);
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT bta.id as type_axe_id, bta.ordre as type_axe_ordre, bta.nom as type_axe_nom, ba.id as axe_id, ba.nom as axe_nom, bs.id as secteur_id, bs.nom as secteur_nom, bs.niveau_service as secteur_niveau_service FROM prism.b_type_axe bta, prism.b_axe ba, prism.b_secteur bs, prism.b_secteur_ct bsc WHERE bsc.nom_ct = ? AND bs.id = bsc.id_secteur AND bs.id_axe = ba.id\tAND ba.id_type_axe = bta.id ORDER BY bta.ordre ASC, ba.ordre ASC, ba.id ASC, bs.niveau_service ASC";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setString(1, nomCT);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    if (typesAxe.get(rs.getInt("type_axe_id")) == null) {
                        indexTypeAxeOrdonnee.add(rs.getInt("type_axe_id"));
                        TypeAxeVH typeAxe = new TypeAxeVH(rs.getInt("type_axe_id"), rs.getString("type_axe_nom"));
                        if (typesAxeBulletin.get(typeAxe.getId()) != null) {
                            typeAxe.setDifficulte(typesAxeBulletin.get(typeAxe.getId()).getDifficulte());
                            typeAxe.setMeteo(typesAxeBulletin.get(typeAxe.getId()).getMeteo());
                            typeAxe.setAltitude(typesAxeBulletin.get(typeAxe.getId()).getAltitude());
                            typeAxe.setConditions(typesAxeBulletin.get(typeAxe.getId()).getConditions());
                        }
                        typesAxe.put(typeAxe.getId(), typeAxe);
                    }
                    if (axes.get(rs.getInt("axe_id")) == null) {
                        AxeVH axe = new AxeVH(rs.getInt("axe_id"), rs.getString("axe_nom"));
                        if (axesBulletin.get(axe.getId()) != null) {
                            axe.setRemarques(axesBulletin.get(axe.getId()).getRemarques());
                        }
                        axes.put(axe.getId(), axe);
                        ((TypeAxeVH)typesAxe.get(rs.getInt("type_axe_id"))).addAxe(axe);
                    }
                    if (secteurs.get(rs.getInt("secteur_id")) != null) continue;
                    SecteurVH secteur = new SecteurVH(rs.getInt("secteur_id"), rs.getString("secteur_nom"), rs.getString("secteur_niveau_service"));
                    if (secteursBulletin.get(secteur.getId()) != null) {
                        secteur.setConditionCirculation(secteursBulletin.get(secteur.getId()).getConditionCirculation());
                        secteur.setEtatChaussee(secteursBulletin.get(secteur.getId()).getEtatChaussee());
                        secteur.setIntervention(secteursBulletin.get(secteur.getId()).getIntervention());
                        secteur.setPrecipitation(secteursBulletin.get(secteur.getId()).getPrecipitation());
                        secteur.setRemarques(secteursBulletin.get(secteur.getId()).getRemarques());
                        secteur.sethAppel(secteursBulletin.get(secteur.getId()).gethAppel());
                    }
                    secteurs.put(secteur.getId(), secteur);
                    ((AxeVH)axes.get(rs.getInt("axe_id"))).addSecteur(secteur);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        ArrayList<TypeAxeVH> typesAxeReturn = new ArrayList<TypeAxeVH>();
        Iterator iterator = indexTypeAxeOrdonnee.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            typesAxeReturn.add((TypeAxeVH)typesAxe.get(index));
        }
        return typesAxeReturn;
    }

    public List<AxeVH> getAxes(int idTypeAxe, String nomCT, int idBulletin) {
        ArrayList<AxeVH> axes = new ArrayList<AxeVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "";
        req = nomCT.equals("") ? SQL_GET_AXE_BY_TYPE_AXE : SQL_GET_AXE_BY_TYPE_AXE_BY_CT;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idTypeAxe);
                if (!nomCT.equals("")) {
                    pstm.setString(2, nomCT);
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    AxeVH axe = new AxeVH(rs.getInt("id"), rs.getString("nom"));
                    axe = this.getAxeBulletin(axe, idBulletin);
                    if (nomCT.equals("")) {
                        axe.setSecteursSecondaire(this.getSecteursSecondaire(axe.getId(), idBulletin));
                        axe.setNbSecteursSecondaire(axe.getSecteursSecondaire().size());
                    } else {
                        axe.setSecteurs(this.getSecteurs(axe.getId(), nomCT, idBulletin));
                        axe.setNbSecteurs(axe.getSecteurs().size());
                    }
                    axes.add(axe);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return axes;
    }

    public AxeVH getAxeBulletin(AxeVH axe, int idBulletin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_SELECT_INFO_AXE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, axe.getId());
                pstm.setInt(2, idBulletin);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    axe.setRemarques(rs.getString("remarques"));
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return axe;
    }

    public HashMap<Integer, AxeVH> getAxesBulletin(int idBulletin) {
        HashMap<Integer, AxeVH> axesBulletin = new HashMap<Integer, AxeVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT bab.id_axe, bab.remarques FROM b_axe_bulletin bab, b_axe ba WHERE bab.nom_ct = '' AND bab.id_bulletin = ? AND bab.id_axe = ba.id ORDER BY ba.ordre, bab.id_axe ASC";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idBulletin);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    AxeVH axe = new AxeVH(rs.getInt("id_axe"), "");
                    axe.setRemarques(rs.getString("remarques"));
                    axesBulletin.put(axe.getId(), axe);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return axesBulletin;
    }

    public List<SecteurSecondaireVH> getSecteursSecondaire(int idAxe, int idBulletin) {
        ArrayList<SecteurSecondaireVH> secteurs = new ArrayList<SecteurSecondaireVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_SECTEUR_SECONDAIRE_BY_AXE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idAxe);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    SecteurSecondaireVH secteur = new SecteurSecondaireVH(idAxe, rs.getString("nom_ct"));
                    secteur = this.getSecteurSecondaireBulletin(secteur, idBulletin);
                    secteurs.add(secteur);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteurs;
    }

    public SecteurSecondaireVH getSecteurSecondaireBulletin(SecteurSecondaireVH secteurSecondaire, int idBulletin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_SELECT_INFO_SECTEUR_SECONDAIRE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, secteurSecondaire.getIdAxe());
                pstm.setString(2, secteurSecondaire.getNomCT());
                pstm.setInt(3, idBulletin);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    secteurSecondaire.setConditionCirculation(rs.getString("condition_circulation"));
                    secteurSecondaire.setEtatChaussee(rs.getString("etat_chaussee"));
                    secteurSecondaire.setIntervention(rs.getString("intervention"));
                    secteurSecondaire.setPrecipitation(rs.getInt("precipitation"));
                    secteurSecondaire.setRemarques(rs.getString("remarques"));
                    secteurSecondaire.sethAppel(rs.getString("h_appel"));
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteurSecondaire;
    }

    public HashMap<String, SecteurSecondaireVH> getSecteursSecondaireBulletin(int idBulletin) {
        HashMap<String, SecteurSecondaireVH> secteursSecondaireBulletin = new HashMap<String, SecteurSecondaireVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = "SELECT id_axe, nom_ct, condition_circulation, etat_chaussee, intervention, precipitation, remarques, h_appel FROM b_axe_bulletin WHERE id_bulletin = ? ORDER BY id_axe ASC, nom_ct ASC";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idBulletin);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    SecteurSecondaireVH secteurSecondaire = new SecteurSecondaireVH(rs.getInt("id_axe"), rs.getString("nom_ct"));
                    secteurSecondaire.setConditionCirculation(rs.getString("condition_circulation"));
                    secteurSecondaire.setEtatChaussee(rs.getString("etat_chaussee"));
                    secteurSecondaire.setIntervention(rs.getString("intervention"));
                    secteurSecondaire.setPrecipitation(rs.getInt("precipitation"));
                    secteurSecondaire.setRemarques(rs.getString("remarques"));
                    secteurSecondaire.sethAppel(rs.getString("h_appel"));
                    secteursSecondaireBulletin.put(String.valueOf(secteurSecondaire.getIdAxe()) + secteurSecondaire.getNomCT(), secteurSecondaire);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteursSecondaireBulletin;
    }

    public List<SecteurVH> getSecteurs(int idAxe, String nomCT, int idBulletin) {
        ArrayList<SecteurVH> secteurs = new ArrayList<SecteurVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_SECTEUR_BY_AXE;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, idAxe);
                pstm.setString(2, nomCT);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    SecteurVH secteur = new SecteurVH(rs.getInt("id"), rs.getString("nom"), rs.getString("niveau_service"));
                    secteur = this.getSecteurBulletin(secteur, idBulletin);
                    secteurs.add(secteur);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return secteurs;
    }

    @Override
    public BulletinMediaVH getStructureBulletinMediaVH() {
        BulletinMediaVH bulletinMedia = new BulletinMediaVH();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_STRUCTURE_GROUPE_MEDIA;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                GroupeMediaVH groupe = null;
                ArrayList<GroupeMediaVH> listeGroupes = new ArrayList<GroupeMediaVH>();
                ArrayList<LigneMediaVH> listeLignes = null;
                while (rs.next()) {
                    if (groupe == null) {
                        groupe = new GroupeMediaVH(rs.getInt("groupe_id"), rs.getString("groupe_libelle"), rs.getBoolean("groupe_informations_generale"));
                        listeLignes = new ArrayList<LigneMediaVH>();
                    } else if (groupe.getId() != rs.getInt("groupe_id")) {
                        groupe.setLignes((List)listeLignes);
                        listeGroupes.add(groupe);
                        groupe = new GroupeMediaVH(rs.getInt("groupe_id"), rs.getString("groupe_libelle"), rs.getBoolean("groupe_informations_generale"));
                        listeLignes = new ArrayList();
                    }
                    LigneMediaVH ligne = new LigneMediaVH(rs.getInt("ligne_id"), rs.getString("ligne_libelle"), rs.getString("ligne_complement_libelle"));
                    listeLignes.add(ligne);
                }
                if (groupe != null) {
                    if (listeLignes.size() >= 0) {
                        groupe.setLignes((List)listeLignes);
                    }
                    listeGroupes.add(groupe);
                }
                bulletinMedia.setGroupes(listeGroupes);
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return bulletinMedia;
    }

    @Override
    public BulletinMediaVH getInformationsBulletinMediaVH() {
        BulletinMediaVH bulletinMedia = new BulletinMediaVH();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_GET_INFORMATIONS_GROUPE_MEDIA;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                GroupeMediaVH groupe = null;
                ArrayList<GroupeMediaVH> listeGroupes = new ArrayList<GroupeMediaVH>();
                ArrayList<LigneMediaVH> listeLignes = null;
                while (rs.next()) {
                    if (groupe == null) {
                        groupe = new GroupeMediaVH(rs.getInt("groupe_id"), rs.getString("groupe_libelle"), rs.getBoolean("groupe_informations_generale"), rs.getString("informations"));
                        bulletinMedia.setDateBulletin(rs.getTimestamp("bulletin_date"));
                        bulletinMedia.setProchain(rs.getString("bulletin_prochain"));
                        listeLignes = new ArrayList<LigneMediaVH>();
                    } else if (groupe.getId() != rs.getInt("groupe_id")) {
                        groupe.setLignes((List)listeLignes);
                        listeGroupes.add(groupe);
                        groupe = new GroupeMediaVH(rs.getInt("groupe_id"), rs.getString("groupe_libelle"), rs.getBoolean("groupe_informations_generale"), rs.getString("informations"));
                        bulletinMedia.setDateBulletin(rs.getTimestamp("bulletin_date"));
                        bulletinMedia.setProchain(rs.getString("bulletin_prochain"));
                        listeLignes = new ArrayList();
                    }
                    if (rs.getInt("id_ligne") == -1) continue;
                    LigneMediaVH ligne = new LigneMediaVH(rs.getInt("ligne_id"), rs.getString("ligne_libelle"), rs.getString("ligne_complement_libelle"), rs.getString("informations"));
                    listeLignes.add(ligne);
                }
                if (groupe != null) {
                    if (listeLignes.size() >= 0) {
                        groupe.setLignes((List)listeLignes);
                    }
                    listeGroupes.add(groupe);
                }
                bulletinMedia.setGroupes(listeGroupes);
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return bulletinMedia;
    }

    public int recupIdBulletinMedia() {
        int idBulletin = 0;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_NEW_ID_BULLETIN_MEDIA;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    idBulletin = rs.getInt("id_bulletin");
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return idBulletin;
    }

    @Override
    public void enregistrerBulletinMedia(BulletinMediaVH bulletinMedia) {
        Connection connection = null;
        PreparedStatement pstm = null;
        String req = SQL_ENREGISTRER_INFORMATIONS_MEDIA;
        try {
            try {
                bulletinMedia.setId(this.recupIdBulletinMedia());
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, bulletinMedia.getId());
                pstm.setTimestamp(2, bulletinMedia.getDateBulletin());
                pstm.setString(3, bulletinMedia.getProchain());
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        for (GroupeMediaVH groupe : bulletinMedia.getGroupes()) {
            if (groupe.isInformationsGenerale()) {
                this.enregistrerGroupeBulletinMedia(bulletinMedia.getId(), groupe);
            }
            for (LigneMediaVH ligne : groupe.getLignes()) {
                this.enregistrerLigneBulletinMedia(bulletinMedia.getId(), ligne);
            }
        }
    }

    private void enregistrerGroupeBulletinMedia(int id_bulletin, GroupeMediaVH groupe) {
        Connection connection = null;
        PreparedStatement pstm = null;
        String req = SQL_ENREGISTRER_INFORMATIONS_GROUPE_MEDIA;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, id_bulletin);
                pstm.setInt(2, groupe.getId());
                pstm.setString(3, groupe.getInformations());
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    private void enregistrerLigneBulletinMedia(int id_bulletin, LigneMediaVH ligne) {
        Connection connection = null;
        PreparedStatement pstm = null;
        String req = SQL_ENREGISTRER_INFORMATIONS_LIGNE_MEDIA;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setInt(1, id_bulletin);
                pstm.setInt(2, ligne.getId());
                pstm.setString(3, ligne.getInformations());
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public List<TronconESVHBean> getEtatSurfaceVHTroncons(String idCircuit) {
        LinkedHashMap<String, TronconESVHBean> troncons = new LinkedHashMap<String, TronconESVHBean>();
        ArrayList<Integer> tronconIds = new ArrayList<Integer>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_TRONCONS);
                pstm.setInt(1, Integer.valueOf(idCircuit));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("id"));
                    tronconIds.add(rs.getInt("id"));
                    troncon.setCircuit(rs.getString("nom"));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDescription(rs.getString("description"));
                    troncon.setObligatoire(rs.getBoolean("obligatoire"));
                    troncon.setTronconId(rs.getString("troncon_id"));
                    TronconESVHBean tronconESVH = new TronconESVHBean(troncon);
                    troncons.put(troncon.getId(), tronconESVH);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        connection = null;
        pstm = null;
        rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_TRONCONS_ESVH);
                Array tronconIdsArray = connection.createArrayOf("int", tronconIds.toArray());
                pstm.setArray(1, tronconIdsArray);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconESVHBean tronconBean = (TronconESVHBean)troncons.get(rs.getString("id"));
                    if (!rs.getString("etat_chaussee").equals("")) {
                        tronconBean.setEtatSurface(Integer.valueOf(rs.getString("etat_chaussee")).intValue());
                    }
                    tronconBean.setDate((Date)rs.getTimestamp("date"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        return new ArrayList<TronconESVHBean>(troncons.values());
    }

    @Override
    public List<PrESVHBean> getEtatSurfaceVHPrs(String delegation) {
        ArrayList<PrESVHBean> prs = new ArrayList<PrESVHBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_PRS_ESVH);
                pstm.setString(1, String.valueOf(delegation));
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PrESVHBean pr = new PrESVHBean(rs.getString("id_circuit"), rs.getString("id"), rs.getString("axe"), rs.getInt("prdebut"), rs.getInt("prfin"), rs.getInt("abscisseprdebut"), rs.getInt("abscisseprfin"), rs.getInt("etat"), (Date)rs.getTimestamp("date"));
                    prs.add(pr);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return prs;
    }

    @Override
    public List<PrESVHBean> getEtatSurfaceVHPrs() {
        ArrayList<PrESVHBean> prs = new ArrayList<PrESVHBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_ALL_PRS_ESVH);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PrESVHBean pr = new PrESVHBean(rs.getString("id_circuit"), rs.getString("id"), rs.getString("axe"), rs.getInt("prdebut"), rs.getInt("prfin"), rs.getInt("abscisseprdebut"), rs.getInt("abscisseprfin"), rs.getInt("etat"), (Date)rs.getTimestamp("date"));
                    prs.add(pr);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return prs;
    }

    @Override
    public void saveEtatSurfaceVH(List<String> circuitIds, int etatSurface) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_DELETE_ALL_TRONCONS_ESVH);
                Array circuitIdsArray = connection.createArrayOf("int", circuitIds.toArray());
                pstm.setArray(1, circuitIdsArray);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        ArrayList<TronconESVHBean> troncons = new ArrayList<TronconESVHBean>();
        ArrayList<Integer> tronconIds = new ArrayList<Integer>();
        connection = null;
        pstm = null;
        rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_ALL_TRONCONS);
                Array circuitIdsArray = connection.createArrayOf("int", circuitIds.toArray());
                pstm.setArray(1, circuitIdsArray);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("id"));
                    tronconIds.add(rs.getInt("id"));
                    troncon.setCircuit(rs.getString("nom"));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDescription(rs.getString("description"));
                    troncon.setObligatoire(rs.getBoolean("obligatoire"));
                    troncon.setTronconId(rs.getString("troncon_id"));
                    TronconESVHBean tronconESVH = new TronconESVHBean(troncon, etatSurface);
                    troncons.add(tronconESVH);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        connection = null;
        pstm = null;
        rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer(SQL_INSERT_TRONCONS_ESVH);
                int i = 0;
                while (i < troncons.size() - 1) {
                    req.append(SQL_INSERT_TRONCONS_ESVH_LINE);
                    ++i;
                }
                pstm = connection.prepareStatement(req.toString());
                i = 0;
                for (TronconESVHBean troncon : troncons) {
                    pstm.setInt(3 * i + 1, Integer.valueOf(troncon.getTroncon().getId()));
                    pstm.setInt(3 * i + 2, etatSurface);
                    pstm.setString(3 * i + 3, "ES" + etatSurface);
                    ++i;
                }
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void updateEtatSurfaceVHCircuits(List<String> circuitIds) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_REFRESH_ALL_TRONCONS_ESVH);
                Array circuitIdsArray = connection.createArrayOf("int", circuitIds.toArray());
                pstm.setArray(1, circuitIdsArray);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void saveEtatSurfaceVHTroncons(List<TronconESVHBean> tronconsESVH) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer(SQL_UPDATE_TRONCONS_ESVH);
                int i = 0;
                while (i < tronconsESVH.size() - 1) {
                    req.append("(?, ?, ?),");
                    ++i;
                }
                req.append("(?, ?, ?)");
                req.append(SQL_UPDATE_TRONCONS_ESVH_END);
                pstm = connection.prepareStatement(req.toString());
                i = 0;
                for (TronconESVHBean tronconESVH : tronconsESVH) {
                    pstm.setInt(i * 3 + 1, Integer.valueOf(tronconESVH.getTroncon().getId()));
                    pstm.setInt(i * 3 + 2, tronconESVH.getEtatSurface());
                    pstm.setString(i * 3 + 3, "ES" + tronconESVH.getEtatSurface());
                    ++i;
                }
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void updateEtatSurfaceVHTroncons(List<TronconESVHBean> tronconsESVH) {
        ArrayList<Integer> tronconIds = new ArrayList<Integer>();
        for (TronconESVHBean tronconESVH : tronconsESVH) {
            tronconIds.add(Integer.valueOf(tronconESVH.getTroncon().getId()));
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_REFRESH_TRONCONS_ESVH);
                Array tronconIdsArray = connection.createArrayOf("int", tronconIds.toArray());
                pstm.setArray(1, tronconIdsArray);
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void saveEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer(SQL_UPDATE_PRS_ESVH);
                int i = 0;
                while (i < prsESVH.size() - 1) {
                    req.append("(?, ?, ?),");
                    ++i;
                }
                req.append("(?, ?, ?)");
                req.append(SQL_UPDATE_PRS_ESVH_END);
                pstm = connection.prepareStatement(req.toString());
                i = 0;
                for (PrESVHBean prESVH : prsESVH) {
                    pstm.setString(i * 3 + 1, prESVH.getId());
                    pstm.setInt(i * 3 + 2, prESVH.getEtatSurface());
                    pstm.setString(i * 3 + 3, "ES" + prESVH.getEtatSurface());
                    ++i;
                }
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void updateEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
        ArrayList<String> prIds = new ArrayList<String>();
        for (PrESVHBean prESVH : prsESVH) {
            prIds.add(prESVH.getId());
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_REFRESH_PRS_ESVH);
                Array prIdsArray = connection.createArrayOf("text", prIds.toArray());
                pstm.setArray(1, prIdsArray);
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void addEtatSurfaceVHPr(PrESVHBean prESVH) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_ADD_PR_DYNAMIQUE);
                pstm.setString(1, prESVH.getRd());
                pstm.setInt(2, prESVH.getPrDeb());
                pstm.setInt(3, prESVH.getPrFin());
                pstm.setInt(4, prESVH.getAbscissePrDeb());
                pstm.setInt(5, prESVH.getAbscissePrFin());
                pstm.setInt(6, prESVH.getEtatSurface());
                pstm.setString(7, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(8, 0);
                pstm.setString(9, "ESVH" + System.currentTimeMillis());
                if (prESVH.getX() == null || prESVH.getX().length == 0) {
                    pstm.setString(10, SQL.getGeometryLineUTM((float[])new float[]{0.0f, 0.0f}, (float[])new float[]{0.0f, 0.0f}));
                } else if (prESVH.getX().length == 1) {
                    pstm.setString(10, SQL.getGeometryLineUTM((float[])new float[]{prESVH.getX()[0], prESVH.getX()[0]}, (float[])new float[]{prESVH.getY()[0], prESVH.getY()[0]}));
                } else {
                    pstm.setString(10, SQL.getGeometryLineUTM((float[])prESVH.getX(), (float[])prESVH.getY()));
                }
                String projection = ConfigurationFactory.getInstance().get("bdd.projection");
                pstm.setInt(11, Integer.valueOf(projection));
                pstm.setDouble(12, prESVH.getLongueur());
                pstm.setString(13, "ES" + prESVH.getEtatSurface());
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public void deleteEtatSurfaceVHPrs(List<PrESVHBean> prsESVH) {
        ArrayList<String> prIds = new ArrayList<String>();
        for (PrESVHBean prESVH : prsESVH) {
            prIds.add(prESVH.getId());
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_DELETE_PRS_ESVH);
                Array prIdsArray = connection.createArrayOf("text", prIds.toArray());
                pstm.setArray(1, prIdsArray);
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.pubDAO.datePublicationMaj();
    }

    @Override
    public List<TronconESVHBean> getTronconsVHaRenouveler(String delegation, long ageMax) {
        ArrayList<TronconESVHBean> troncons = new ArrayList<TronconESVHBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TRONCONS_VH_A_RENOUVELER);
                pstm.setString(1, delegation);
                pstm.setTimestamp(2, new Timestamp(System.currentTimeMillis() - ageMax));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("id"));
                    troncon.setCircuit(rs.getString("idcircuit"));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDescription(rs.getString("description"));
                    troncon.setObligatoire(rs.getBoolean("obligatoire"));
                    troncon.setTronconId(rs.getString("troncon_id"));
                    TronconESVHBean tronconESVH = new TronconESVHBean(troncon);
                    troncons.add(tronconESVH);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    @Override
    public List<PrESVHBean> getPrsVHaRenouveler(String delegation, long ageMax) {
        ArrayList<PrESVHBean> prsESVH = new ArrayList<PrESVHBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_PRS_VH_A_RENOUVELER);
                pstm.setTimestamp(1, new Timestamp(System.currentTimeMillis() - ageMax));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PrESVHBean pr = new PrESVHBean(rs.getString("id_circuit"), rs.getString("id"), rs.getString("axe"), rs.getInt("prdebut"), rs.getInt("prfin"), rs.getInt("abscisseprdebut"), rs.getInt("abscisseprfin"), rs.getInt("etat"), (Date)rs.getTimestamp("date"));
                    prsESVH.add(pr);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return prsESVH;
    }

    @Override
    public void updateBarreauVH(BarreauVH barreau) {
        this.updateBarreauVH(barreau, true);
    }

    @Override
    public void updateBarreauVHCCH(BarreauVH barreau) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                this.updateBarreauVH(connection, barreau, true, true);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    @Override
    public void updateBarreauVHCCH(BarreauVH barreau, boolean force) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                this.updateBarreauVH(connection, barreau, force, true);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    @Override
    public void updateBarreauVH(Date dateDerniereMaj, BarreauVH barreauType, String statutMin) {
        Connection connection = null;
        boolean dateVariable = true;
        String requete = "UPDATE donnees_metier.troncon_circuit_ext SET status=?, maj=?, id_patrouilleur=?, maj_id_partenaire=? WHERE ";
        String requeteVH = "UPDATE vh.donnees_vh_troncon SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, duree=?, date=?, publie=?, mcig_id=? WHERE ";
        if (dateVariable) {
            requete = String.valueOf(requete) + " (select (date + interval '1h' * duree) from vh.donnees_vh_troncon < ? AND cch != ?";
        }
        requete = String.valueOf(requete) + " maj < ? AND status != ?";
        requeteVH = String.valueOf(requeteVH) + " date < ? AND cch != ?";
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, barreauType.getStatus());
                pstm.setTimestamp(2, new Timestamp(barreauType.getMajDate().getTime()));
                pstm.setString(3, barreauType.getIdPatrouilleur());
                pstm.setInt(4, barreauType.getMajIdPartenaire());
                pstm.setTimestamp(5, new Timestamp(dateDerniereMaj.getTime()));
                pstm.setString(6, statutMin);
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement(requeteVH);
                int i = 1;
                pstm.setString(i++, barreauType.getStatus());
                pstm.setString(i++, barreauType.getCch2());
                pstm.setString(i++, barreauType.getTendanceCC());
                pstm.setString(i++, barreauType.getTraitement());
                pstm.setString(i++, barreauType.getMeteo());
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaire(), (int)100));
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaireInterne(), (int)200));
                pstm.setString(i++, barreauType.getEquipements());
                pstm.setString(i++, barreauType.getEtatChaussee());
                pstm.setString(i++, barreauType.getTemperature());
                pstm.setString(i++, barreauType.getVent());
                pstm.setInt(i++, barreauType.getDuree());
                pstm.setTimestamp(i++, new Timestamp(barreauType.getMajDate().getTime()));
                pstm.setBoolean(i++, barreauType.isPublie());
                pstm.setString(i++, barreauType.getMcig());
                pstm.setTimestamp(i++, new Timestamp(dateDerniereMaj.getTime()));
                pstm.setString(i++, statutMin);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (this.refDAO.getConfiguration().getBoolean("mct.barreaux.historise", false)) {
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    try {
                        for (BarreauVH barreau : this.getBarreauxVH(true)) {
                            this.historiseBarreau(connection, barreau, false);
                        }
                    }
                    catch (Exception e) {
                        Log.error("Erreur historisation Barreaux", e);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            finally {
                DAOUtil.close(connection, null);
            }
        }
    }

    private String getValeurVh(String valeur) {
        return this.getValeurVh(valeur, "NR");
    }

    private String getValeurVh(String valeur, String valeurNr) {
        if (GLS.estVide((String)valeur)) {
            return valeurNr;
        }
        return valeur;
    }

    @Override
    public boolean updateBarreauVHPublication(Date dateDerniereMaj, BarreauVH barreauType, String statutMin) {
        boolean res;
        Connection connection = null;
        String requeteVH = "UPDATE vh.donnees_vh_troncon_publie SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, duree=?, date=?, publie=?, mcig_id=? WHERE ";
        requeteVH = String.valueOf(requeteVH) + " date < ? AND cch != ?";
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requeteVH);
                int i = 1;
                pstm.setString(i++, barreauType.getStatus());
                pstm.setString(i++, barreauType.getCch2());
                pstm.setString(i++, barreauType.getTendanceCC());
                pstm.setString(i++, barreauType.getTraitement());
                pstm.setString(i++, barreauType.getMeteo());
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaire(), (int)100));
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaireInterne(), (int)200));
                pstm.setString(i++, barreauType.getEquipements());
                pstm.setString(i++, barreauType.getEtatChaussee());
                pstm.setString(i++, barreauType.getTemperature());
                pstm.setString(i++, barreauType.getVent());
                pstm.setInt(i++, barreauType.getDuree());
                pstm.setTimestamp(i++, new Timestamp(barreauType.getMajDate().getTime()));
                pstm.setBoolean(i++, barreauType.isPublie());
                pstm.setString(i++, barreauType.getMcig());
                pstm.setTimestamp(i++, new Timestamp(dateDerniereMaj.getTime()));
                pstm.setString(i++, statutMin);
                res = pstm.executeUpdate() > 0;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (this.refDAO.getConfiguration().getBoolean("mct.barreaux.historise", false)) {
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    try {
                        for (BarreauVH barreau : this.getBarreauxVHPublie(true)) {
                            this.historiseBarreauPublie(connection, barreau, false);
                        }
                    }
                    catch (Exception e) {
                        Log.error("Erreur historisation Barreaux", e);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            finally {
                DAOUtil.close(connection, null);
            }
        }
        return res;
    }

    @Override
    public void updateBarreauVHDonnesExterne(List<BarreauVH> barreaux) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                for (BarreauVH barreauVH : barreaux) {
                    this.updateBarreauVHDonnesExterne(connection, barreauVH);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, null);
        }
    }

    @Override
    public void updateBarreauVHDonnesExterne(Connection connection, BarreauVH barreau) {
        String requeteVH = "UPDATE donnees_externes.donnees_vh_troncon SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, duree=?, date=?, mcig_id=? WHERE troncon_id=? ";
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement(requeteVH);
                int i = 1;
                pstm.setString(i++, barreau.getStatus());
                pstm.setString(i++, barreau.getCch2());
                pstm.setString(i++, barreau.getTendanceCC());
                pstm.setString(i++, this.getValeurVh(barreau.getTraitement()));
                pstm.setString(i++, this.getValeurVh(barreau.getMeteo()));
                pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaire(), (int)100));
                pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaireInterne(), (int)200));
                pstm.setString(i++, this.getValeurVh(barreau.getEquipements()));
                pstm.setString(i++, this.getValeurVh(barreau.getEtatChaussee()));
                pstm.setString(i++, this.getValeurVh(barreau.getTemperature()));
                pstm.setString(i++, this.getValeurVh(barreau.getVent()));
                pstm.setInt(i++, barreau.getDuree());
                pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                pstm.setString(i++, barreau.getMcig());
                pstm.setString(i++, barreau.getTronconID());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(null, pstm);
        }
    }

    @Override
    public boolean updateBarreauVHDonnesExterne(Date dateDerniereMaj, BarreauVH barreauType, String statutMin) {
        boolean res;
        Connection connection = null;
        String requeteVH = "UPDATE donnees_externes.donnees_vh_troncon SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, duree=?, date=?, publie=?, mcig_id=? WHERE ";
        requeteVH = String.valueOf(requeteVH) + " date < ? AND cch != ?";
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requeteVH);
                int i = 1;
                pstm.setString(i++, barreauType.getStatus());
                pstm.setString(i++, barreauType.getCch2());
                pstm.setString(i++, barreauType.getTendanceCC());
                pstm.setString(i++, barreauType.getTraitement());
                pstm.setString(i++, barreauType.getMeteo());
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaire(), (int)100));
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaireInterne(), (int)200));
                pstm.setString(i++, barreauType.getEquipements());
                pstm.setString(i++, barreauType.getEtatChaussee());
                pstm.setString(i++, barreauType.getTemperature());
                pstm.setString(i++, barreauType.getVent());
                pstm.setInt(i++, barreauType.getDuree());
                pstm.setTimestamp(i++, new Timestamp(barreauType.getMajDate().getTime()));
                pstm.setBoolean(i++, barreauType.isPublie());
                pstm.setString(i++, barreauType.getMcig());
                pstm.setTimestamp(i++, new Timestamp(dateDerniereMaj.getTime()));
                pstm.setString(i++, statutMin);
                res = pstm.executeUpdate() > 0;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return res;
    }

    @Override
    public boolean updateBarreauVHPublicationDureeValiditeVariable(Date dateDerniereMaj, BarreauVH barreauType, String statutMin) {
        Connection connection = null;
        boolean response = true;
        String requeteVH = "UPDATE vh.donnees_vh_troncon_publie SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, date=?, publie=?, mcig_id=? WHERE ";
        requeteVH = String.valueOf(requeteVH) + " (date + interval '1h' * duree) < ? AND cch != ?";
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requeteVH);
                int i = 1;
                pstm.setString(i++, barreauType.getStatus());
                pstm.setString(i++, barreauType.getCch2());
                pstm.setString(i++, barreauType.getTendanceCC());
                pstm.setString(i++, barreauType.getTraitement());
                pstm.setString(i++, barreauType.getMeteo());
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaire(), (int)100));
                pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaireInterne(), (int)200));
                pstm.setString(i++, barreauType.getEquipements());
                pstm.setString(i++, barreauType.getEtatChaussee());
                pstm.setString(i++, barreauType.getTemperature());
                pstm.setString(i++, barreauType.getVent());
                pstm.setTimestamp(i++, new Timestamp(barreauType.getMajDate().getTime()));
                pstm.setBoolean(i++, barreauType.isPublie());
                pstm.setString(i++, barreauType.getMcig());
                pstm.setTimestamp(i++, new Timestamp(dateDerniereMaj.getTime()));
                pstm.setString(i++, statutMin);
                pstm.executeUpdate();
                int ret = pstm.getUpdateCount();
                if (ret == 0) {
                    response = false;
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (this.refDAO.getConfiguration().getBoolean("mct.barreaux.historise", false)) {
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    try {
                        for (BarreauVH barreau : this.getBarreauxVHPublie(true)) {
                            this.historiseBarreauPublie(connection, barreau, false);
                        }
                    }
                    catch (Exception e) {
                        Log.error("Erreur historisation Barreaux", e);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            finally {
                DAOUtil.close(connection, null);
            }
        }
        return response;
    }

    @Override
    public boolean updateBarreauVHDureeValiditeVariable(Date dateDerniereMaj, BarreauVH barreauType, String statutMin) {
        Connection connection = null;
        boolean response = true;
        String requeteSelect = "select id from donnees_metier.troncon_circuit_ext FOR UPDATE";
        String requete = "update donnees_metier.troncon_circuit_ext set status=?, maj=?, id_patrouilleur=?, maj_id_partenaire=? where ";
        String requeteVH = "UPDATE vh.donnees_vh_troncon SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, date=?, publie=?, mcig_id=? WHERE ";
        requeteVH = String.valueOf(requeteVH) + " (date + interval '1h' * duree) < ? AND cch != ?";
        requete = String.valueOf(requete) + " (select (date + interval '1h' * duree) from vh.donnees_vh_troncon d where donnees_metier.troncon_circuit_ext.id = d.id) < ? AND status != ?";
        boolean utiliserSelectForUpdate = false;
        utiliserSelectForUpdate = this.refDAO.getConfiguration().getBoolean("vh.selectForUpdate", false);
        try {
            connection = this.daoFactory.getConnection();
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
        PreparedStatement pstm = null;
        try {
            try {
                try {
                    if (utiliserSelectForUpdate) {
                        connection.setAutoCommit(false);
                        pstm = connection.prepareStatement(requeteSelect);
                        pstm.executeQuery();
                        DAOUtil.close(null, pstm);
                    }
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, barreauType.getStatus());
                    pstm.setTimestamp(2, new Timestamp(barreauType.getMajDate().getTime()));
                    pstm.setString(3, barreauType.getIdPatrouilleur());
                    pstm.setInt(4, barreauType.getMajIdPartenaire());
                    pstm.setTimestamp(5, new Timestamp(dateDerniereMaj.getTime()));
                    pstm.setString(6, statutMin);
                    pstm.execute();
                    DAOUtil.close(pstm);
                    pstm = connection.prepareStatement(requeteVH);
                    int i = 1;
                    pstm.setString(i++, barreauType.getStatus());
                    pstm.setString(i++, barreauType.getCch2());
                    pstm.setString(i++, barreauType.getTendanceCC());
                    pstm.setString(i++, barreauType.getTraitement());
                    pstm.setString(i++, barreauType.getMeteo());
                    pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaire(), (int)100));
                    pstm.setString(i++, Util.limiterTaille((String)barreauType.getCommentaireInterne(), (int)200));
                    pstm.setString(i++, barreauType.getEquipements());
                    pstm.setString(i++, barreauType.getEtatChaussee());
                    pstm.setString(i++, barreauType.getTemperature());
                    pstm.setString(i++, barreauType.getVent());
                    pstm.setTimestamp(i++, new Timestamp(barreauType.getMajDate().getTime()));
                    pstm.setBoolean(i++, barreauType.isPublie());
                    pstm.setString(i++, barreauType.getMcig());
                    pstm.setTimestamp(i++, new Timestamp(dateDerniereMaj.getTime()));
                    pstm.setString(i++, statutMin);
                    pstm.executeUpdate();
                    int ret = pstm.getUpdateCount();
                    if (ret == 0) {
                        response = false;
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm);
                throw throwable;
            }
            DAOUtil.close(null, pstm);
            if (this.refDAO.getConfiguration().getBoolean("mct.barreaux.historise", false)) {
                try {
                    for (BarreauVH barreau : this.getBarreauxVH(true)) {
                        this.historiseBarreau(connection, barreau, false);
                    }
                }
                catch (Exception e) {
                    Log.error("Erreur historisation Barreaux", e);
                }
            }
            if (utiliserSelectForUpdate) {
                try {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            if (connection != null) {
                DAOUtil.close(connection);
            }
        }
        return response;
    }

    public void updateBarreauVH(Connection connection, BarreauVH barreau, boolean force, boolean justeCCH) {
        String requeteSelect = "select id from donnees_metier.troncon_circuit_ext WHERE id=";
        String requete = "UPDATE donnees_metier.troncon_circuit_ext SET status=?, maj=?, id_patrouilleur=?, maj_id_partenaire=? WHERE id=";
        String requeteVH = justeCCH ? "UPDATE vh.donnees_vh_troncon SET cch=?, tendancecc=?, date=?, mcig_id=? WHERE id= " : "UPDATE vh.donnees_vh_troncon SET cch=?, cch2=?, tendancecc=?, traitement=?, meteo=?, commentaire=?, commentaire_interne=?,  equipements=?, etat_chaussee=?, temperature=?, vent=?, duree=?, date=?, mcig_id=? WHERE id=";
        if (barreau.getId() == null || barreau.getId().length() == 0) {
            requete = String.valueOf(requete) + "(select id from donnees_metier.troncon_circuit_ext where troncon_id=?) ";
            requeteVH = String.valueOf(requeteVH) + "(select id from donnees_metier.troncon_circuit_ext where troncon_id=?) ";
            requeteSelect = String.valueOf(requeteSelect) + "(select id from donnees_metier.troncon_circuit_ext where troncon_id=?) FOR UPDATE";
        } else {
            requete = String.valueOf(requete) + "? ";
            requeteVH = String.valueOf(requeteVH) + "? ";
            requeteSelect = String.valueOf(requeteSelect) + "? FOR UPDATE";
        }
        if (!force) {
            requete = String.valueOf(requete) + " and maj < ?";
            requeteVH = String.valueOf(requeteVH) + " and date < ?";
        }
        PreparedStatement pstm = null;
        boolean ret = false;
        boolean utiliserSelectForUpdate = false;
        utiliserSelectForUpdate = this.refDAO.getConfiguration().getBoolean("vh.selectForUpdate", false);
        if (utiliserSelectForUpdate) {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        try {
            try {
                if (utiliserSelectForUpdate) {
                    pstm = connection.prepareStatement(requeteSelect);
                    if (barreau.getId() == null || barreau.getId().length() == 0) {
                        pstm.setString(1, barreau.getTronconID());
                    } else {
                        pstm.setInt(1, Integer.valueOf(barreau.getId()));
                    }
                    pstm.executeQuery();
                    DAOUtil.close(null, pstm);
                }
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, barreau.getStatus());
                pstm.setTimestamp(2, new Timestamp(barreau.getMajDate().getTime()));
                pstm.setString(3, barreau.getIdPatrouilleur());
                pstm.setInt(4, barreau.getMajIdPartenaire());
                if (barreau.getId() == null || barreau.getId().length() == 0) {
                    pstm.setString(5, barreau.getTronconID());
                } else {
                    pstm.setInt(5, Integer.valueOf(barreau.getId()));
                }
                if (!force) {
                    pstm.setTimestamp(6, new Timestamp(barreau.getMajDate().getTime()));
                }
                pstm.executeUpdate();
                ret = pstm.getUpdateCount() > 0;
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement(requeteVH);
                int i = 1;
                pstm.setString(i++, barreau.getStatus());
                if (!justeCCH) {
                    pstm.setString(i++, barreau.getCch2());
                }
                pstm.setString(i++, barreau.getTendanceCC());
                if (!justeCCH) {
                    pstm.setString(i++, this.getValeurVh(barreau.getTraitement()));
                    pstm.setString(i++, this.getValeurVh(barreau.getMeteo()));
                    pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaire(), (int)100));
                    pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaireInterne(), (int)200));
                    pstm.setString(i++, this.getValeurVh(barreau.getEquipements()));
                    pstm.setString(i++, this.getValeurVh(barreau.getEtatChaussee()));
                    pstm.setString(i++, this.getValeurVh(barreau.getTemperature()));
                    pstm.setString(i++, this.getValeurVh(barreau.getVent()));
                    pstm.setInt(i++, barreau.getDuree());
                }
                pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                pstm.setString(i++, barreau.getMcig());
                if (barreau.getId() == null || barreau.getId().length() == 0) {
                    pstm.setString(i++, barreau.getTronconID());
                } else {
                    pstm.setInt(i++, Integer.valueOf(barreau.getId()));
                }
                if (!force) {
                    pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                }
                pstm.executeUpdate();
                ret = pstm.getUpdateCount() > 0;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm);
            throw throwable;
        }
        DAOUtil.close(null, pstm);
        try {
            if (this.refDAO.getConfiguration().getBoolean("mct.barreaux.historise", false) && ret) {
                this.historiseBarreau(connection, barreau, justeCCH);
            }
        }
        catch (Exception e) {
            Log.error("Erreur historisation Barreaux", e);
        }
        if (utiliserSelectForUpdate) {
            try {
                connection.commit();
                connection.setAutoCommit(true);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void historiseBarreau(Connection connection, BarreauVH barreau, boolean justeCCH) {
        PreparedStatement pstm = null;
        PreparedStatement pstm2 = null;
        ResultSet rs = null;
        String shared = null;
        Object object = synchro;
        synchronized (object) {
            String idBarreau = barreau.getId() == null || barreau.getId().length() == 0 ? barreau.getTronconID() : barreau.getId();
            if (!synchro.containsKey(idBarreau)) {
                synchro.put(idBarreau, idBarreau);
            }
            shared = synchro.get(idBarreau);
        }
        object = shared;
        synchronized (object) {
            String requeteVHHistorique;
            block34: {
                BarreauVHHisto barreauOld;
                String requeteVHHistoriqueDateFin;
                block35: {
                    String requeteVHHistoriqueConsult;
                    String requeteId = barreau.getId() == null || barreau.getId().length() == 0 ? "(select id from donnees_metier.troncon_circuit_ext where troncon_id=?) " : "? ";
                    requeteVHHistoriqueDateFin = "update vh.donnees_vh_troncon_hist SET datefin = ?, utilisateur = ? where id = ? and datedebut = ? ";
                    if (justeCCH) {
                        requeteVHHistorique = "insert into vh.donnees_vh_troncon_hist (cch,tendancecc,date,utilisateur,id,datedebut, datefin,mcig_id) values (?,?,?,?," + requeteId + ",?,?,?)";
                        requeteVHHistoriqueConsult = "select * from vh.donnees_vh_troncon_hist where id = " + requeteId + " order by datedebut desc limit 1";
                    } else {
                        requeteVHHistorique = "insert into vh.donnees_vh_troncon_hist (cch,cch2,tendancecc,traitement,meteo,commentaire,commentaire_interne,equipements,etat_chaussee,temperature,vent,duree,date,utilisateur,id,datedebut, datefin,mcig_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?," + requeteId + ",?,?,?)";
                        requeteVHHistoriqueConsult = "select * from vh.donnees_vh_troncon_hist where id = " + requeteId + " order by datedebut desc limit 1";
                    }
                    barreauOld = null;
                    pstm = connection.prepareStatement(requeteVHHistoriqueConsult);
                    if (barreau.getId() == null || barreau.getId().length() == 0) {
                        pstm.setString(1, barreau.getTronconID());
                    } else {
                        pstm.setInt(1, Integer.valueOf(barreau.getId()));
                    }
                    rs = pstm.executeQuery();
                    if (!rs.next()) break block34;
                    barreauOld = new BarreauVHHisto();
                    barreauOld.setStatus(rs.getString("cch"));
                    if (!justeCCH) {
                        barreauOld.setCch2(rs.getString("cch2"));
                    }
                    barreauOld.setTendanceCC(rs.getString("tendancecc"));
                    if (!justeCCH) {
                        barreauOld.setTraitement(rs.getString("traitement"));
                        barreauOld.setMeteo(rs.getString("meteo"));
                        barreauOld.setCommentaire(rs.getString("commentaire"));
                        barreauOld.setCommentaireInterne(rs.getString("commentaire_interne"));
                        barreauOld.setEquipements(rs.getString("equipements"));
                        barreauOld.setEtatChaussee(rs.getString("etat_chaussee"));
                        barreauOld.setTemperature(rs.getString("temperature"));
                        barreauOld.setVent(rs.getString("vent"));
                        barreauOld.setDuree(rs.getInt("duree"));
                    }
                    barreauOld.setMajDate(new Date(rs.getTimestamp("date").getTime()));
                    barreauOld.setDateDebut(new Date(rs.getTimestamp("datedebut").getTime()));
                    if (rs.getTimestamp("datefin") != null) {
                        barreauOld.setDateFin(new Date(rs.getTimestamp("datefin").getTime()));
                    } else {
                        barreauOld.setDateFin(null);
                    }
                    barreauOld.setUtilisateur(rs.getString("utilisateur"));
                    barreauOld.setMcig(rs.getString("mcig_id"));
                    barreauOld.setId("" + rs.getInt("id"));
                    barreauOld.setDateFin(barreau.getMajDate());
                    if (!barreauOld.equals(barreau, justeCCH)) break block35;
                    DAOUtil.close(null, pstm, rs);
                    return;
                }
                try {
                    try {
                        try {
                            try {
                                pstm2 = connection.prepareStatement(requeteVHHistoriqueDateFin);
                                pstm2.setTimestamp(1, new Timestamp(barreau.getMajDate().getTime()));
                                pstm2.setString(2, barreau.getIdPatrouilleur());
                                pstm2.setInt(3, Integer.valueOf(barreauOld.getId()));
                                pstm2.setTimestamp(4, new Timestamp(barreauOld.getDateDebut().getTime()));
                                pstm2.execute();
                            }
                            catch (SQLException e) {
                                throw new DAOException(e);
                            }
                        }
                        finally {
                            DAOUtil.close(null, pstm2);
                        }
                    }
                    catch (SQLException e) {
                        throw new DAOException(e);
                    }
                }
                catch (Throwable throwable) {
                    DAOUtil.close(null, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(null, pstm, rs);
            try {
                try {
                    pstm = connection.prepareStatement(requeteVHHistorique);
                    int i = 1;
                    pstm.setString(i++, barreau.getStatus());
                    if (!justeCCH) {
                        pstm.setString(i++, barreau.getCch2());
                    }
                    pstm.setString(i++, barreau.getTendanceCC());
                    if (!justeCCH) {
                        pstm.setString(i++, this.getValeurVh(barreau.getTraitement()));
                        pstm.setString(i++, this.getValeurVh(barreau.getMeteo()));
                        pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaire(), (int)100));
                        pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaireInterne(), (int)200));
                        pstm.setString(i++, this.getValeurVh(barreau.getEquipements()));
                        pstm.setString(i++, this.getValeurVh(barreau.getEtatChaussee()));
                        pstm.setString(i++, this.getValeurVh(barreau.getTemperature()));
                        pstm.setString(i++, this.getValeurVh(barreau.getVent()));
                        pstm.setInt(i++, barreau.getDuree());
                    }
                    pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                    pstm.setString(i++, barreau.getIdPatrouilleur());
                    if (barreau.getId() == null || barreau.getId().length() == 0) {
                        pstm.setString(i++, barreau.getTronconID());
                    } else {
                        pstm.setInt(i++, Integer.valueOf(barreau.getId()));
                    }
                    pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                    pstm.setNull(i++, 93);
                    pstm.setString(i++, barreau.getMcig());
                    pstm.execute();
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            finally {
                DAOUtil.close(null, pstm);
            }
        }
    }

    private void historiseBarreauPublie(Connection connection, BarreauVH barreau, boolean justeCCH) {
        String requeteVHHistorique;
        ResultSet rs;
        PreparedStatement pstm;
        block27: {
            BarreauVHHisto barreauOld;
            String requeteVHHistoriqueDateFin;
            PreparedStatement pstm2;
            block28: {
                String requeteVHHistoriqueConsult;
                pstm = null;
                pstm2 = null;
                rs = null;
                String requeteId = barreau.getId() == null || barreau.getId().length() == 0 ? "(select id from donnees_metier.troncon_circuit_ext where troncon_id=?) " : "? ";
                requeteVHHistoriqueDateFin = "update vh.donnees_vh_troncon_publie_hist SET datefin = ?, utilisateur = ? where id = ? and datedebut = ? ";
                if (justeCCH) {
                    requeteVHHistorique = "insert into vh.donnees_vh_troncon_publie_hist (cch,tendancecc,date,utilisateur,id,datedebut, datefin, micg_id) values (?,?,?,?," + requeteId + ",?,?,?)";
                    requeteVHHistoriqueConsult = "select * from vh.donnees_vh_troncon_publie_hist where id = " + requeteId + " order by datedebut desc limit 1";
                } else {
                    requeteVHHistorique = "insert into vh.donnees_vh_troncon_publie_hist (cch,cch2,tendancecc,traitement,meteo,commentaire,commentaire_interne,equipements,etat_chaussee,temperature,vent,duree,date,utilisateur,id,datedebut, datefin, mcig_id) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?," + requeteId + ",?,?,?)";
                    requeteVHHistoriqueConsult = "select * from vh.donnees_vh_troncon_publie_hist where id = " + requeteId + " order by datedebut desc limit 1";
                }
                barreauOld = null;
                pstm = connection.prepareStatement(requeteVHHistoriqueConsult);
                if (barreau.getId() == null || barreau.getId().length() == 0) {
                    pstm.setString(1, barreau.getTronconID());
                } else {
                    pstm.setInt(1, Integer.valueOf(barreau.getId()));
                }
                rs = pstm.executeQuery();
                if (!rs.next()) break block27;
                barreauOld = new BarreauVHHisto();
                barreauOld.setStatus(rs.getString("cch"));
                if (!justeCCH) {
                    barreauOld.setCch2(rs.getString("cch2"));
                }
                barreauOld.setTendanceCC(rs.getString("tendancecc"));
                if (!justeCCH) {
                    barreauOld.setTraitement(rs.getString("traitement"));
                    barreauOld.setMeteo(rs.getString("meteo"));
                    barreauOld.setCommentaire(rs.getString("commentaire"));
                    barreauOld.setCommentaireInterne(rs.getString("commentaire_interne"));
                    barreauOld.setEquipements(rs.getString("equipements"));
                    barreauOld.setEtatChaussee(rs.getString("etat_chaussee"));
                    barreauOld.setTemperature(rs.getString("temperature"));
                    barreauOld.setVent(rs.getString("vent"));
                    barreauOld.setDuree(rs.getInt("duree"));
                }
                barreauOld.setMajDate(new Date(rs.getTimestamp("date").getTime()));
                barreauOld.setDateDebut(new Date(rs.getTimestamp("datedebut").getTime()));
                if (rs.getTimestamp("datefin") != null) {
                    barreauOld.setDateFin(new Date(rs.getTimestamp("datefin").getTime()));
                } else {
                    barreauOld.setDateFin(null);
                }
                barreauOld.setUtilisateur(rs.getString("utilisateur"));
                barreauOld.setMcig(rs.getString("mcig_id"));
                barreauOld.setId("" + rs.getInt("id"));
                barreauOld.setDateFin(barreau.getMajDate());
                if (!barreauOld.equals(barreau, justeCCH)) break block28;
                DAOUtil.close(null, pstm, rs);
                return;
            }
            try {
                try {
                    try {
                        try {
                            pstm2 = connection.prepareStatement(requeteVHHistoriqueDateFin);
                            pstm2.setTimestamp(1, new Timestamp(barreau.getMajDate().getTime()));
                            pstm2.setString(2, barreau.getIdPatrouilleur());
                            pstm2.setInt(3, Integer.valueOf(barreauOld.getId()));
                            pstm2.setTimestamp(4, new Timestamp(barreauOld.getDateDebut().getTime()));
                            pstm2.execute();
                        }
                        catch (SQLException e) {
                            throw new DAOException(e);
                        }
                    }
                    finally {
                        DAOUtil.close(null, pstm2);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(null, pstm, rs);
        try {
            try {
                pstm = connection.prepareStatement(requeteVHHistorique);
                int i = 1;
                pstm.setString(i++, barreau.getStatus());
                if (!justeCCH) {
                    pstm.setString(i++, barreau.getCch2());
                }
                pstm.setString(i++, barreau.getTendanceCC());
                if (!justeCCH) {
                    pstm.setString(i++, this.getValeurVh(barreau.getTraitement()));
                    pstm.setString(i++, this.getValeurVh(barreau.getMeteo()));
                    pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaire(), (int)100));
                    pstm.setString(i++, Util.limiterTaille((String)barreau.getCommentaireInterne(), (int)200));
                    pstm.setString(i++, this.getValeurVh(barreau.getEquipements()));
                    pstm.setString(i++, this.getValeurVh(barreau.getEtatChaussee()));
                    pstm.setString(i++, this.getValeurVh(barreau.getTemperature()));
                    pstm.setString(i++, this.getValeurVh(barreau.getVent()));
                    pstm.setInt(i++, barreau.getDuree());
                }
                pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                pstm.setString(i++, barreau.getIdPatrouilleur());
                if (barreau.getId() == null || barreau.getId().length() == 0) {
                    pstm.setString(i++, barreau.getTronconID());
                } else {
                    pstm.setInt(i++, Integer.valueOf(barreau.getId()));
                }
                pstm.setTimestamp(i++, new Timestamp(barreau.getMajDate().getTime()));
                pstm.setNull(i++, 93);
                pstm.setString(i++, barreau.getMcig());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(null, pstm);
        }
    }

    private void historiseSynthesePublie() {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO vh.synthese_publie_hist(commentaire, nom , date) SELECT commentaire, nom , date FROM vh.synthese_publie");
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void updateBarreauVH(BarreauVH barreau, boolean force) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                this.updateBarreauVH(connection, barreau, force, false);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    @Override
    public void updateBarreauxVH(List<BarreauVH> barreaux) {
        this.updateBarreauxVH(barreaux, true);
    }

    @Override
    public void updateBarreauxVH(List<BarreauVH> barreaux, boolean force) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                for (BarreauVH barreau : barreaux) {
                    this.updateBarreauVH(connection, barreau, force, false);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    @Override
    public List<CircuitESVHBean> getDerniersCircuitsVHModifies(String delegation) {
        ArrayList<CircuitESVHBean> circuits = new ArrayList<CircuitESVHBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                if (delegation != null) {
                    pstm = connection.prepareStatement(SQL_GET_LAST_CIRCUITS_ESVH_BY_DELEGATION);
                    pstm.setString(1, String.valueOf(delegation));
                } else {
                    pstm = connection.prepareStatement(SQL_GET_LAST_CIRCUITS_ESVH);
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    CircuitESVHBean circuit = new CircuitESVHBean(rs.getString("idcircuit"), rs.getString("nom"), rs.getString("delegation"), (Date)rs.getTimestamp("date"));
                    circuits.add(circuit);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return circuits;
    }

    @Override
    public List<BarreauVH> getTronconsVHMiseAJour(Date dateDerniereVerification) {
        ArrayList<BarreauVH> troncons = new ArrayList<BarreauVH>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TRONCONS_VH_MIS_A_JOUR);
                pstm.setTimestamp(1, new Timestamp(dateDerniereVerification.getTime()));
                pstm.setTimestamp(2, new Timestamp(dateDerniereVerification.getTime()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH barreau = new BarreauVH();
                    barreau.setId(rs.getString("id"));
                    barreau.setCircuit(rs.getString("idcircuit"));
                    barreau.setAxe(rs.getString("axe"));
                    barreau.setDescription(rs.getString("description"));
                    barreau.setObligatoire(rs.getBoolean("obligatoire"));
                    barreau.setTronconId(rs.getString("troncon_id"));
                    barreau.setMajDate((Date)rs.getDate("maj"));
                    barreau.setIdPatrouilleur(rs.getString("id_patrouilleur"));
                    troncons.add(barreau);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    @Override
    public void publierCopieBarreauxVH() {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM vh.donnees_vh_troncon_publie");
                pstm.execute();
                pstm.close();
                pstm = connection.prepareStatement("INSERT INTO vh.donnees_vh_troncon_publie SELECT * FROM vh.donnees_vh_troncon");
                pstm.execute();
                pstm.close();
                pstm = connection.prepareStatement("DELETE FROM vh.synthese_publie");
                pstm.execute();
                pstm.close();
                pstm = connection.prepareStatement("INSERT INTO vh.synthese_publie SELECT * FROM vh.synthese");
                pstm.execute();
                pstm = connection.prepareStatement("UPDATE vh.synthese_publie SET date = now()");
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (this.refDAO.getConfiguration().getBoolean("mct.barreaux.historise", false)) {
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    try {
                        for (BarreauVH barreau : this.getBarreauxVHPublie(true)) {
                            this.historiseBarreauPublie(connection, barreau, false);
                        }
                        this.historiseSynthesePublie();
                    }
                    catch (Exception e) {
                        Log.error("Erreur historisation Barreaux", e);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            finally {
                DAOUtil.close(connection, null);
            }
        }
    }

    @Override
    public List<BarreauVH> getBarreauxVHPublie(boolean sansCoordoonees) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon_publie WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon_publie.id ORDER BY indice, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    troncon.setMajDate(new Date(rs.getTimestamp("date").getTime()));
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    public List<BarreauVH> getBarreauxVH(boolean sansCoordoonees) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id ORDER BY indice, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    troncon.setMajDate(new Date(rs.getTimestamp("date").getTime()));
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public void depublierCopieSyntheseVH() {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM vh.synthese_publie");
                Log.debug(pstm.toString());
                pstm.execute();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public Date getHistoriqueCCHDate(Date dateHistoriqueRecherche) {
        Connection connection = null;
        PreparedStatement pstm = null;
        Date dateResult = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT date FROM vh.synthese_publie_hist WHERE date <= ? ORDER BY date DESC LIMIT 1");
                pstm.setTimestamp(1, new Timestamp(dateHistoriqueRecherche.getTime()));
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                Timestamp datePublication = null;
                if (rs.next()) {
                    datePublication = rs.getTimestamp(1);
                    dateResult = new Date(datePublication.getTime());
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return dateResult;
    }

    @Override
    public List<BarreauVH> getHistoriqueCCHTroncon(Date datePublication) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ArrayList<BarreauVH> barreaux = new ArrayList<BarreauVH>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT tc.coordonnees as coordonnees, tc.id as id, tc.troncon_id as troncon_id, h.cch as cch FROM donnees_metier.troncon_circuit_ext tc, vh.donnees_vh_troncon_publie_hist h WHERE tc.id = h.id AND h.datedebut <= ? AND (? < h.datefin OR datefin is null)");
                pstm.setTimestamp(1, new Timestamp(datePublication.getTime()));
                pstm.setTimestamp(2, new Timestamp(datePublication.getTime()));
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH barreau = new BarreauVH();
                    VhDAOJDBC.fabriqueBarreauLight(rs, barreau);
                    barreaux.add(barreau);
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return barreaux;
    }

    public static void fabriqueBarreauLight(ResultSet rs, BarreauVH barreau) throws SQLException {
        barreau.setId(rs.getString("id"));
        barreau.setTronconID(rs.getString("troncon_id"));
        try {
            if (rs.getObject("coordonnees") != null) {
                Vector<Double> xs = new Vector<Double>();
                Vector<Double> ys = new Vector<Double>();
                Vector coordPArGeometry = SQL.getPoints2DByGeometry((Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                int k = 0;
                while (k < coordPArGeometry.size()) {
                    Vector coord = (Vector)coordPArGeometry.get(k);
                    int nbPoint = coord.size();
                    int i = 0;
                    while (i < nbPoint) {
                        xs.add(((Point2D.Double)coord.get((int)i)).x);
                        ys.add(((Point2D.Double)coord.get((int)i)).y);
                        ++i;
                    }
                    ++k;
                }
                float[] xf = new float[xs.size()];
                float[] yf = new float[ys.size()];
                int i = 0;
                while (i < xf.length) {
                    xf[i] = new Double((Double)xs.get(i)).floatValue();
                    yf[i] = new Double((Double)ys.get(i)).floatValue();
                    ++i;
                }
                barreau.setX(xf);
                barreau.setY(yf);
                try {
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    int k2 = 0;
                    while (k2 < coordPArGeometry.size()) {
                        Vector coord = (Vector)coordPArGeometry.get(k2);
                        int nbPoint = coord.size();
                        double[] x = new double[nbPoint];
                        double[] y = new double[nbPoint];
                        int i2 = 0;
                        while (i2 < nbPoint) {
                            x[i2] = ((Point2D.Double)coord.get((int)i2)).x;
                            y[i2] = ((Point2D.Double)coord.get((int)i2)).y;
                            ++i2;
                        }
                        xsML.add(x);
                        ysML.add(y);
                        ++k2;
                    }
                    barreau.setXs(xsML);
                    barreau.setYs(ysML);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            barreau.setX(null);
            barreau.setY(null);
        }
        try {
            barreau.setCch(rs.getString("cch"));
        }
        catch (Exception ex) {
            barreau.setMajIdPartenaire(-1);
        }
    }

    @Override
    public List<BarreauVH> getHistoriqueTronconVH(Date dateHistoriqueRecherche) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ArrayList<BarreauVH> barreaux = new ArrayList<BarreauVH>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT tc.coordonnees as coordonnees, tc.id as id, tc.troncon_id as troncon_id, h.cch as cch FROM donnees_metier.troncon_circuit_ext tc, vh.donnees_vh_troncon_hist h WHERE tc.id = h.id AND h.datedebut <= ? AND (? < h.datefin OR datefin is null)");
                pstm.setTimestamp(1, new Timestamp(dateHistoriqueRecherche.getTime()));
                pstm.setTimestamp(2, new Timestamp(dateHistoriqueRecherche.getTime()));
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH barreau = new BarreauVH();
                    VhDAOJDBC.fabriqueBarreauLight(rs, barreau);
                    barreaux.add(barreau);
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return barreaux;
    }

    @Override
    public List<String> getCentresBulletin() {
        ArrayList<String> retour = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT DISTINCT nom_ct, type_patrouille FROM b_patrouille_ct ORDER BY type_patrouille DESC, nom_ct ASC");
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    retour.add(rs.getString("nom_ct"));
                }
                System.out.println("getCentresBulletin : " + retour);
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    @Override
    public List<String> getCentresBulletinOrdonnees() {
        ArrayList<String> retour = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT DISTINCT nom, ordre FROM b_centre_ordonnees ORDER BY ordre ASC");
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    retour.add(rs.getString("nom"));
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return retour;
    }

    @Override
    public BulletinMediaVH2 initBulletinMediaVH() {
        BulletinMediaVH2 retour = new BulletinMediaVH2();
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                retour = this.initBulletinMediaVH(connection);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
        return retour;
    }

    public BulletinMediaVH2 initBulletinMediaVH(Connection connection) {
        BulletinMediaVH2 retour = new BulletinMediaVH2();
        retour.setGroupes(this.initGroupes(connection));
        retour.setHeures(this.initHeures(connection));
        retour.putLignes(this.initLignes(connection));
        return retour;
    }

    private List<BulletinMediaVH2Groupe> initGroupes(Connection connection) {
        ArrayList<BulletinMediaVH2Groupe> retour = new ArrayList<BulletinMediaVH2Groupe>();
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement("SELECT id_groupe, nom_groupe, affiche_interdiction, ordre FROM bulletin_media_2_groupe ORDER BY ordre ASC");
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    BulletinMediaVH2Groupe groupe = new BulletinMediaVH2Groupe(rs.getInt("id_groupe"), rs.getString("nom_groupe"), Boolean.valueOf(rs.getBoolean("affiche_interdiction")), rs.getInt("ordre"));
                    retour.add(groupe);
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
        return retour;
    }

    private Map<Integer, TreeMap<Integer, BulletinMediaVH2Ligne>> initLignes(Connection connection) {
        HashMap<Integer, TreeMap<Integer, BulletinMediaVH2Ligne>> retour = new HashMap<Integer, TreeMap<Integer, BulletinMediaVH2Ligne>>();
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement("SELECT id_ligne, id_groupe, nom_ligne, ligne, id_axe, id_secteur, affiche_interdiction FROM bulletin_media_2_structure ORDER BY id_groupe ASC, id_ligne ASC");
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    BulletinMediaVH2Ligne ligne = new BulletinMediaVH2Ligne(rs.getInt("id_ligne"), rs.getInt("id_groupe"), rs.getString("nom_ligne"), rs.getInt("ligne"), rs.getInt("id_axe"), rs.getInt("id_secteur"), rs.getBoolean("affiche_interdiction"));
                    TreeMap liste = null;
                    liste = retour.containsKey(rs.getInt("id_groupe")) ? (TreeMap)retour.get(rs.getInt("id_groupe")) : new TreeMap();
                    liste.put(ligne.getId_ligne(), ligne);
                    retour.put(rs.getInt("id_groupe"), liste);
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
        return retour;
    }

    private Map<Integer, String> initHeures(Connection connection) {
        HashMap<Integer, String> retour = new HashMap<Integer, String>();
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement("SELECT id_heure, nom_heure FROM bulletin_media_2_heure ORDER BY id_heure ASC");
                Log.debug(pstm.toString());
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    retour.put(rs.getInt("id_heure"), rs.getString("nom_heure"));
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
        return retour;
    }

    @Override
    public BulletinInforoute getDernierBulletinInforoute() {
        Connection connection = null;
        BulletinInforoute retour = new BulletinInforoute();
        HashMap<Integer, BulletinInforouteLigne> lignes = new HashMap<Integer, BulletinInforouteLigne>();
        HashMap<Integer, BulletinInforouteLigne> lignesMedia = new HashMap<Integer, BulletinInforouteLigne>();
        try {
            try {
                BulletinInforouteLigne ligne;
                BulletinInforouteLigne ligne1;
                BulletinInforouteLigne ligne2;
                BulletinInforouteLigne ligne32;
                connection = this.daoFactory.getConnection();
                PreparedStatement pstm = null;
                pstm = connection.prepareStatement("SELECT id, datetime, nb_camion FROM bulletin WHERE id = (SELECT max(id) FROM bulletin WHERE nom_ct = '') AND nom_ct = ''");
                ResultSet rs = pstm.executeQuery();
                int idBulletin = -1;
                while (rs.next()) {
                    retour.setDateTime(rs.getTimestamp("datetime"));
                    idBulletin = rs.getInt("id");
                    retour.setNbCamions(rs.getInt("nb_camion"));
                }
                rs.close();
                pstm.close();
                pstm = connection.prepareStatement("SELECT bms.id_ligne, bms.id_groupe, bms.id_secteur, bms.id_inforoute, bs.condition_circulation, bs.etat_chaussee, bs.intervention, bs.precipitation, bs.remarques, bs.interdiction FROM bulletin_media_2_structure bms, b_secteur_bulletin bs WHERE bs.id_secteur = bms.id_secteur AND bs.id_bulletin = (SELECT max(id) FROM bulletin WHERE nom_ct = '' AND datetime > date_trunc('day',current_timestamp)) ORDER BY id_ligne;");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    if (lignesMedia.get(rs.getInt("id_ligne")) == null) {
                        ligne32 = new BulletinInforouteLigne(rs.getInt("id_groupe"), rs.getInt("id_ligne"), rs.getInt("id_inforoute"), rs.getString("condition_circulation"), rs.getString("remarques"), rs.getInt("precipitation"), rs.getString("intervention"), rs.getString("etat_chaussee"), Boolean.valueOf(rs.getBoolean("interdiction")));
                        lignesMedia.put(rs.getInt("id_ligne"), ligne32);
                        continue;
                    }
                    ligne2 = new BulletinInforouteLigne(rs.getInt("id_groupe"), rs.getInt("id_ligne"), rs.getInt("id_inforoute"), rs.getString("condition_circulation"), rs.getString("remarques"), rs.getInt("precipitation"), rs.getString("intervention"), rs.getString("etat_chaussee"), Boolean.valueOf(false));
                    ligne1 = (BulletinInforouteLigne)lignesMedia.get(rs.getInt("id_ligne"));
                    ligne = this.GetLigneMax(ligne1, ligne2);
                    lignesMedia.put(rs.getInt("id_ligne"), ligne);
                }
                rs.close();
                pstm.close();
                pstm = connection.prepareStatement("SELECT bms.id_ligne, bms.id_groupe,  bms.id_axe, bms.id_inforoute, ba.condition_circulation, ba.etat_chaussee, ba.intervention, ba.precipitation, ba.remarques FROM bulletin_media_2_structure bms, b_axe_bulletin ba WHERE ba.id_axe = bms.id_axe AND ba.id_bulletin = (SELECT max(id) FROM bulletin WHERE nom_ct = '' AND datetime > date_trunc('day',current_timestamp)) ORDER BY id_ligne;");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    if (lignesMedia.get(rs.getInt("id_ligne")) == null) {
                        ligne32 = new BulletinInforouteLigne(rs.getInt("id_groupe"), rs.getInt("id_ligne"), rs.getInt("id_inforoute"), rs.getString("condition_circulation"), rs.getString("remarques"), rs.getInt("precipitation"), rs.getString("intervention"), rs.getString("etat_chaussee"), Boolean.valueOf(false));
                        lignesMedia.put(rs.getInt("id_ligne"), ligne32);
                        continue;
                    }
                    ligne2 = new BulletinInforouteLigne(rs.getInt("id_groupe"), rs.getInt("id_ligne"), rs.getInt("id_inforoute"), rs.getString("condition_circulation"), rs.getString("remarques"), rs.getInt("precipitation"), rs.getString("intervention"), rs.getString("etat_chaussee"), Boolean.valueOf(false));
                    ligne1 = (BulletinInforouteLigne)lignesMedia.get(rs.getInt("id_ligne"));
                    ligne = this.GetLigneMax(ligne1, ligne2);
                    lignesMedia.put(rs.getInt("id_ligne"), ligne);
                }
                for (BulletinInforouteLigne ligne32 : lignesMedia.values()) {
                    if (lignes.get(ligne32.getId()) == null) {
                        lignes.put(ligne32.getId(), ligne32);
                        continue;
                    }
                    BulletinInforouteLigne ligneTmp = this.GetLigneMax(ligne32, (BulletinInforouteLigne)lignes.get(ligne32.getId()));
                    lignes.put(ligneTmp.getId(), ligneTmp);
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
        retour.setLignes(lignes);
        retour.setLignesMedia(lignesMedia);
        return retour;
    }

    public BulletinInforouteLigne GetLigneMax(BulletinInforouteLigne ligne1, BulletinInforouteLigne ligne2) {
        BulletinInforouteLigne retour = new BulletinInforouteLigne(ligne1.getId_groupe(), ligne1.getId_ligne(), ligne1.getId(), this.ConditionCirculationMax(ligne1.getCc(), ligne2.getCc()), String.valueOf(ligne1.getCommentaire()) + ligne2.getCommentaire(), this.PrecipitationMax(ligne1.getEtatPrecipitation(), ligne2.getEtatPrecipitation()), this.InterventionMax(ligne1.getCodeIntervention(), ligne2.getCodeIntervention()), this.EtatChausseeMax(ligne1.getCodeEtatChaussee(), ligne2.getCodeEtatChaussee()), Boolean.valueOf(ligne1.getInterdiction() != false || ligne2.getInterdiction() != false));
        return retour;
    }

    private String ConditionCirculationMax(String CC1, String CC2) {
        String CCFinal = "";
        if (CC1 == null || CC2 == null) {
            Log.warn("CC1 == " + CC1);
            Log.warn("CC2 == " + CC2);
        }
        if ("C4".equals(CC1) || "C4".equals(CC2)) {
            CCFinal = "C4";
        } else if ("C3".equals(CC1) || "C3".equals(CC2)) {
            CCFinal = "C3";
        } else if ("C2".equals(CC1) || "C2".equals(CC2)) {
            CCFinal = "C2";
        } else if ("C1".equals(CC1) || "C1".equals(CC2)) {
            CCFinal = "C1";
        }
        return CCFinal;
    }

    private String InterventionMax(String Int1, String Int2) {
        String IntFinal = "";
        if ("E".equals(Int1) || "E".equals(Int2)) {
            IntFinal = "E";
        } else if ("T".equals(Int1) || "T".equals(Int2)) {
            IntFinal = "T";
        }
        return IntFinal;
    }

    private String EtatChausseeMax(String EtC1, String EtC2) {
        String EtCFinal = "";
        if ("V".equals(EtC1) || "V".equals(EtC2)) {
            EtCFinal = "V";
        } else if ("E".equals(EtC1) || "E".equals(EtC2)) {
            EtCFinal = "E";
        } else if ("L".equals(EtC1) || "L".equals(EtC2)) {
            EtCFinal = "L";
        } else if ("N".equals(EtC1) || "N".equals(EtC2)) {
            EtCFinal = "N";
        } else if ("G".equals(EtC1) || "G".equals(EtC2)) {
            EtCFinal = "G";
        } else if ("H".equals(EtC1) || "H".equals(EtC2)) {
            EtCFinal = "H";
        } else if ("S".equals(EtC1) || "S".equals(EtC2)) {
            EtCFinal = "S";
        }
        return EtCFinal;
    }

    private int PrecipitationMax(int Pre1, int Pre2) {
        int PreFinal = 0;
        if (Pre1 == 1 || Pre2 == 1 || Pre1 == 3 || Pre2 == 3 || Pre1 == 5 || Pre2 == 5 || Pre1 == 7 || Pre2 == 7) {
            PreFinal = 1;
        } else if (Pre1 == 2 || Pre2 == 2 || Pre1 == 6 || Pre2 == 6) {
            PreFinal = 2;
        } else if (Pre1 == 4 || Pre2 == 4) {
            PreFinal = 4;
        }
        return PreFinal;
    }

    @Override
    public BulletinMediaVH2 getDernierBulletinMediaVH() {
        Connection connection = null;
        BulletinMediaVH2 retour = new BulletinMediaVH2();
        try {
            try {
                connection = this.daoFactory.getConnection();
                retour = this.initBulletinMediaVH(connection);
                Timestamp dateTimeBulletin = null;
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Timestamp today = new Timestamp(cal.getTimeInMillis());
                PreparedStatement pstm = null;
                try {
                    try {
                        String SQLGetLastIdBulletin = "(SELECT id_bulletin FROM bulletin_media_2 ORDER BY datetime_save DESC LIMIT 1)";
                        pstm = connection.prepareStatement("SELECT id_bulletin, nb_camions, limite_neige, interdiction, equipements, texte_libre_1, texte_libre_2, datetime FROM bulletin_media_2 WHERE id_bulletin = " + SQLGetLastIdBulletin);
                        Log.debug(pstm.toString());
                        ResultSet rs = pstm.executeQuery();
                        while (rs.next()) {
                            retour.setId(rs.getInt("id_bulletin"));
                            dateTimeBulletin = rs.getTimestamp("datetime");
                            if (!dateTimeBulletin.after(today)) continue;
                            retour.setNbCamions(rs.getInt("nb_camions"));
                            retour.setLimitePluieNeige(rs.getInt("limite_neige"));
                            retour.setInterdiction(Boolean.valueOf(rs.getBoolean("interdiction")));
                            retour.setEquipement(Boolean.valueOf(rs.getBoolean("equipements")));
                            retour.setTexteLibre1(rs.getString("texte_libre_1"));
                            retour.setTexteLibre2(rs.getString("texte_libre_2"));
                        }
                        rs.close();
                        pstm.close();
                        if (dateTimeBulletin != null && dateTimeBulletin.after(today)) {
                            pstm = connection.prepareStatement("SELECT s.id_groupe, l.id_ligne, l.interdiction FROM bulletin_media_2_structure s, bulletin_media_2_ligne l WHERE s.id_ligne = l.id_ligne AND l.id_bulletin = " + SQLGetLastIdBulletin + " ORDER BY s.id_ligne");
                            Log.debug(pstm.toString());
                            rs = pstm.executeQuery();
                            while (rs.next()) {
                                ((BulletinMediaVH2Ligne)((TreeMap)retour.getLignes().get(rs.getInt("id_groupe"))).get(rs.getInt("id_ligne"))).setInterdiction(rs.getBoolean("interdiction"));
                            }
                            rs.close();
                            pstm.close();
                            pstm = connection.prepareStatement("SELECT s.id_groupe, c.id_ligne, c.id_heure, c.conditions FROM bulletin_media_2_structure s, bulletin_media_2_cc c WHERE s.id_ligne = c.id_ligne AND c.id_bulletin = " + SQLGetLastIdBulletin + " ORDER BY s.id_ligne");
                            Log.debug(pstm.toString());
                            rs = pstm.executeQuery();
                            while (rs.next()) {
                                ((BulletinMediaVH2Ligne)((TreeMap)retour.getLignes().get(rs.getInt("id_groupe"))).get(rs.getInt("id_ligne"))).getCcParHeure().put(rs.getInt("id_heure"), rs.getString("conditions"));
                            }
                            rs.close();
                            pstm.close();
                        } else {
                            Log.info("Pas de pr\u00e9cendent bulletin media aujourd'hui");
                        }
                        try {
                            BulletinInforoute bulletinInforoute = this.getDernierBulletinInforoute();
                            HashMap<Integer, Timestamp> heureTimestampMin = new HashMap<Integer, Timestamp>();
                            HashMap<Integer, Timestamp> heureTimestampMax = new HashMap<Integer, Timestamp>();
                            Calendar calHeure = Calendar.getInstance();
                            calHeure.set(11, 0);
                            calHeure.set(12, 0);
                            Timestamp heureMin = new Timestamp(calHeure.getTimeInMillis());
                            Iterator iterator = retour.getHeures().keySet().iterator();
                            while (iterator.hasNext()) {
                                int key = (Integer)iterator.next();
                                calHeure = Calendar.getInstance();
                                String[] heure = ((String)retour.getHeures().get(key)).split("h");
                                calHeure.set(11, Integer.valueOf(heure[0]));
                                calHeure.set(12, Integer.valueOf(heure[1]));
                                heureTimestampMax.put(key, new Timestamp(calHeure.getTimeInMillis()));
                                heureTimestampMin.put(key, heureMin);
                                heureMin = new Timestamp(calHeure.getTimeInMillis());
                            }
                            System.out.println(heureTimestampMin);
                            System.out.println(heureTimestampMax);
                            Timestamp bulletinInforouteTimestamp = bulletinInforoute.getDateTime();
                            Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
                            System.out.println(bulletinInforouteTimestamp);
                            System.out.println(now);
                            if (bulletinInforouteTimestamp.after(dateTimeBulletin) && bulletinInforouteTimestamp.after(today)) {
                                retour.setNbCamions(bulletinInforoute.getNbCamions());
                            }
                            Iterator iterator2 = retour.getHeures().keySet().iterator();
                            while (iterator2.hasNext()) {
                                int key = (Integer)iterator2.next();
                                if (!now.after((Timestamp)heureTimestampMin.get(key))) continue;
                                for (BulletinInforouteLigne ligne : bulletinInforoute.getLignesMedia().values()) {
                                    if (((BulletinMediaVH2Ligne)((TreeMap)retour.getLignes().get(ligne.getId_groupe())).get(ligne.getId_ligne())).getCcParHeure().get(key) == null || bulletinInforouteTimestamp.after(dateTimeBulletin) && now.before((Timestamp)heureTimestampMax.get(key))) {
                                        ((BulletinMediaVH2Ligne)((TreeMap)retour.getLignes().get(ligne.getId_groupe())).get(ligne.getId_ligne())).getCcParHeure().put(key, ligne.toCC());
                                    }
                                    if (!bulletinInforouteTimestamp.after(dateTimeBulletin)) continue;
                                    ((BulletinMediaVH2Ligne)((TreeMap)retour.getLignes().get(ligne.getId_groupe())).get(ligne.getId_ligne())).setInterdiction(ligne.getInterdiction().booleanValue());
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.error("erreur recuperation info bulletinMedia", e);
                        }
                    }
                    catch (SQLException e) {
                        throw new DAOException(e);
                    }
                }
                catch (Throwable throwable) {
                    DAOUtil.close(pstm);
                    throw throwable;
                }
                DAOUtil.close(pstm);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
        return retour;
    }

    @Override
    public BulletinMediaVH2 getBulletinMediaVH(int id_bulletin) {
        Connection connection = null;
        BulletinMediaVH2 retour = new BulletinMediaVH2();
        try {
            try {
                connection = this.daoFactory.getConnection();
                retour = this.initBulletinMediaVH(connection);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
        return retour;
    }

    private int getDernierIdBulletinMediaVH2(Connection connection) {
        int retour = 1;
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement("SELECT max(id_bulletin) idmax FROM bulletin_media_2");
                ResultSet rs = pstm.executeQuery();
                if (rs.next()) {
                    retour = rs.getInt("idmax") + 1;
                }
                rs.close();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
        return retour;
    }

    @Override
    public void enregistrerBulletinMediaVH2(BulletinMediaVH2 bulletin) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                bulletin.setId(this.getDernierIdBulletinMediaVH2(connection));
                this.insertBulletinMedia2ligne(bulletin, connection);
                this.insertBulletinMedia2cc(bulletin, connection);
                this.insertBulletinMedia2(bulletin, connection);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    public void insertBulletinMedia2(BulletinMediaVH2 bulletin, Connection connection) {
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement("INSERT INTO prism.bulletin_media_2( id_bulletin, datetime, datetime_save, id_utilisateur, nb_camions, limite_neige, interdiction, equipements, texte_libre_1, texte_libre_2) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
                pstm.setInt(1, bulletin.getId());
                pstm.setTimestamp(2, bulletin.getDateBulletin());
                pstm.setTimestamp(3, bulletin.getDateSave());
                pstm.setInt(4, bulletin.getIdUtilisateur());
                pstm.setInt(5, bulletin.getNbCamions());
                pstm.setInt(6, bulletin.getLimitePluieNeige());
                pstm.setBoolean(7, bulletin.getInterdiction());
                pstm.setBoolean(8, bulletin.getEquipement());
                pstm.setString(9, bulletin.getTexteLibre1());
                pstm.setString(10, bulletin.getTexteLibre2());
                Log.debug(pstm.toString());
                pstm.executeUpdate();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
    }

    public void insertBulletinMedia2ligne(BulletinMediaVH2 bulletin, Connection connection) {
        PreparedStatement pstm = null;
        try {
            try {
                String sql = "INSERT INTO prism.bulletin_media_2_ligne( id_bulletin, id_ligne, interdiction) VALUES ";
                String sqlValue = "";
                for (Integer key : bulletin.getLignes().keySet()) {
                    for (BulletinMediaVH2Ligne ligne : ((TreeMap)bulletin.getLignes().get(key)).values()) {
                        if (!"".equals(sqlValue)) {
                            sqlValue = String.valueOf(sqlValue) + ", ";
                        }
                        sqlValue = String.valueOf(sqlValue) + "(?, ?, ?)";
                    }
                }
                sql = String.valueOf(sql) + sqlValue + ";";
                pstm = connection.prepareStatement(sql);
                int index = 0;
                for (Integer key : bulletin.getLignes().keySet()) {
                    for (BulletinMediaVH2Ligne ligne : ((TreeMap)bulletin.getLignes().get(key)).values()) {
                        pstm.setInt(index * 3 + 1, bulletin.getId());
                        pstm.setInt(index * 3 + 2, ligne.getId_ligne());
                        pstm.setBoolean(index * 3 + 3, ligne.isInterdiction());
                        ++index;
                    }
                }
                Log.debug(pstm.toString());
                pstm.executeUpdate();
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
    }

    public void insertBulletinMedia2cc(BulletinMediaVH2 bulletin, Connection connection) {
        PreparedStatement pstm = null;
        try {
            try {
                String sql = "INSERT INTO prism.bulletin_media_2_cc( id_bulletin, id_ligne, id_heure, conditions) VALUES ";
                String sqlValue = "";
                for (Integer key : bulletin.getLignes().keySet()) {
                    for (BulletinMediaVH2Ligne ligne : ((TreeMap)bulletin.getLignes().get(key)).values()) {
                        Iterator iterator = ligne.getCcParHeure().keySet().iterator();
                        while (iterator.hasNext()) {
                            int keyHeure = (Integer)iterator.next();
                            if (!"".equals(sqlValue)) {
                                sqlValue = String.valueOf(sqlValue) + ", ";
                            }
                            sqlValue = String.valueOf(sqlValue) + "(?, ?, ?, ?)";
                        }
                    }
                }
                sql = String.valueOf(sql) + sqlValue + ";";
                pstm = connection.prepareStatement(sql);
                int index = 0;
                for (Integer key : bulletin.getLignes().keySet()) {
                    for (BulletinMediaVH2Ligne ligne : ((TreeMap)bulletin.getLignes().get(key)).values()) {
                        Iterator iterator = ligne.getCcParHeure().keySet().iterator();
                        while (iterator.hasNext()) {
                            int keyHeure = (Integer)iterator.next();
                            pstm.setInt(index * 4 + 1, bulletin.getId());
                            pstm.setInt(index * 4 + 2, ligne.getId_ligne());
                            pstm.setInt(index * 4 + 3, keyHeure);
                            pstm.setString(index * 4 + 4, (String)ligne.getCcParHeure().get(keyHeure));
                            ++index;
                        }
                    }
                }
                Log.debug(pstm.toString());
                if (index > 0) {
                    pstm.executeUpdate();
                } else {
                    Log.debug("pas de conditions de conduites renseign\u00e9es");
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
    }

    @Override
    public List<BarreauVHHisto> getBarreauxVHHistorique(String delegation, String centre, int circuit, boolean sansCoordoonees, Date dateDebut, Date dateFin) {
        ArrayList<BarreauVHHisto> liste = new ArrayList<BarreauVHHisto>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String mcig = " ,(SELECT u.nom FROM prism.utilisateur u,prism.mcig mcig WHERE u.id_utilisateur = mcig.id_utilisateur AND mcig_id = vh.donnees_vh_troncon_hist.mcig_id) as mcig_utilisateur, (SELECT mcig.type_poste FROM prism.mcig mcig WHERE mcig_id = vh.donnees_vh_troncon_hist.mcig_id) as mcig_type_poste ";
        String requete = circuit != -1 ? "SELECT * " + (sansCoordoonees ? "" : buffer) + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon_hist WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon_hist.id" + " AND donnees_metier.troncon_circuit_ext.idcircuit = ? " + " AND vh.donnees_vh_troncon_hist.date > ? AND vh.donnees_vh_troncon_hist.date < ? " + " ORDER BY date desc, indice, delegation, centre, id_groupe, troncon_id" : (GLS.estVide((String)delegation) ? "SELECT * " + (sansCoordoonees ? "" : buffer) + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon_hist WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon_hist.id" + " AND vh.donnees_vh_troncon_hist.date > ? AND vh.donnees_vh_troncon_hist.date < ? " + " ORDER BY date desc, indice, delegation, centre, id_groupe, troncon_id" : "SELECT * " + (sansCoordoonees ? "" : buffer) + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon_hist WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon_hist.id" + " AND donnees_metier.troncon_circuit_ext.idcircuit IN (SELECT id FROM circuit c WHERE (lower(c.delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + " ) " + " AND (lower(delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + " AND vh.donnees_vh_troncon_hist.date > ? AND vh.donnees_vh_troncon_hist.date < ? " + "ORDER BY date desc, indice, delegation, centre, id_groupe, troncon_id");
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                int i = 1;
                if (circuit != -1) {
                    pstm.setInt(1, circuit);
                } else if (!GLS.estVide((String)delegation)) {
                    pstm.setString(i++, delegation.toLowerCase());
                    if (!GLS.estVide((String)centre)) {
                        pstm.setString(i++, centre.toLowerCase());
                    }
                    pstm.setString(i++, delegation.toLowerCase());
                    if (!GLS.estVide((String)centre)) {
                        pstm.setString(i++, centre.toLowerCase());
                    }
                }
                int n = ++i;
                pstm.setTimestamp(n, new Timestamp(dateDebut.getTime()));
                int n2 = ++i;
                ++i;
                pstm.setTimestamp(n2, new Timestamp(dateFin.getTime()));
                rs = pstm.executeQuery();
                Log.debug("getBarreauxVH : " + pstm.toString());
                while (rs.next()) {
                    BarreauVHHisto troncon = new BarreauVHHisto();
                    VhDAOJDBC.fabriqueBarreauVHHisto(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<BarreauVHHisto> getBarreauxVHHistorique(BarreauVH barreauVh, Date dateDebut, Date dateFin) {
        ArrayList<BarreauVHHisto> liste = new ArrayList<BarreauVHHisto>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String mcig = " ,(SELECT u.nom FROM prism.utilisateur u,prism.mcig mcig WHERE u.id_utilisateur = mcig.id_utilisateur AND mcig_id = vh.donnees_vh_troncon_hist.mcig_id) as mcig_utilisateur, (SELECT mcig.type_poste FROM prism.mcig mcig WHERE mcig_id = vh.donnees_vh_troncon_hist.mcig_id) as mcig_type_poste ";
        String requete = "SELECT * " + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon_hist WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon_hist.id" + " AND donnees_metier.troncon_circuit_ext.id = ? " + " AND vh.donnees_vh_troncon_hist.date > ? AND vh.donnees_vh_troncon_hist.date < ? " + " ORDER BY date desc, indice, delegation, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                int i = 1;
                if (barreauVh != null) {
                    pstm.setInt(1, Integer.parseInt(barreauVh.getId()));
                }
                int n = ++i;
                pstm.setTimestamp(n, new Timestamp(dateDebut.getTime()));
                int n2 = ++i;
                ++i;
                pstm.setTimestamp(n2, new Timestamp(dateFin.getTime()));
                rs = pstm.executeQuery();
                Log.debug("getBarreauxVHHisto : " + pstm.toString());
                while (rs.next()) {
                    BarreauVHHisto troncon = new BarreauVHHisto();
                    VhDAOJDBC.fabriqueBarreauVHHisto(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    public static void fabriqueBarreauVHHisto(ResultSet rs, BarreauVHHisto troncon) throws SQLException {
        Vector coord;
        Vector coordPArGeometry;
        Vector<Object> ys;
        Vector<Object> xs;
        troncon.setId(rs.getString("id"));
        troncon.setCircuit(rs.getString("idcircuit"));
        troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("departementprdebut"), (String)""));
        troncon.setAxe(rs.getString("axe"));
        troncon.setLongueur(rs.getInt("longueur"));
        troncon.setDepartementPrFin(GLS.getString((String)rs.getString("departementprfin"), (String)""));
        troncon.setDescription(rs.getString("description"));
        troncon.setPrDebut(rs.getInt("prdebut"));
        troncon.setPrFin(rs.getInt("prfin"));
        troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
        troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
        troncon.setIdGroupe(rs.getString("id_groupe"));
        troncon.setDelegation(rs.getString("delegation"));
        troncon.setCentre(rs.getString("centre"));
        troncon.setCroisement1(rs.getString("croisement_1"));
        troncon.setCroisement2(rs.getString("croisement_2"));
        troncon.setLibelle(rs.getString("description"));
        troncon.setCode(rs.getString("description"));
        troncon.setTronconID(rs.getString("troncon_id"));
        troncon.setIdPatrouilleur(rs.getString("id_patrouilleur"));
        troncon.setMajDate((Date)rs.getTimestamp("date"));
        troncon.setMajDateServeur((Date)rs.getTimestamp("maj_transmis"));
        if (rs.findColumn("fk_niveau_service") > -1) {
            troncon.setNiveauService(Long.valueOf(rs.getLong("fk_niveau_service")));
        }
        try {
            if (rs.findColumn("libelle_niveau") > -1) {
                troncon.setClassification(rs.getString("libelle_niveau"));
            }
        }
        catch (Exception e) {
            troncon.setClassification(null);
        }
        troncon.setStatus(rs.getString("status"));
        troncon.setPublie(rs.getBoolean("publie"));
        try {
            troncon.setMajIdPartenaire(rs.getInt("maj_id_partenaire"));
        }
        catch (Exception ex) {
            troncon.setMajIdPartenaire(-1);
        }
        try {
            if (rs.getObject("coordonnees") != null) {
                xs = new Vector<Object>();
                ys = new Vector<Object>();
                coordPArGeometry = SQL.getPoints2DByGeometry((Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                int k = 0;
                while (k < coordPArGeometry.size()) {
                    coord = (Vector)coordPArGeometry.get(k);
                    int nbPoint = coord.size();
                    int i = 0;
                    while (i < nbPoint) {
                        xs.add(((Point2D.Double)coord.get((int)i)).x);
                        ys.add(((Point2D.Double)coord.get((int)i)).y);
                        ++i;
                    }
                    ++k;
                }
                float[] xf = new float[xs.size()];
                float[] yf = new float[ys.size()];
                int i = 0;
                while (i < xf.length) {
                    xf[i] = new Double((Double)xs.get(i)).floatValue();
                    yf[i] = new Double((Double)ys.get(i)).floatValue();
                    ++i;
                }
                troncon.setX(xf);
                troncon.setY(yf);
                try {
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    int k2 = 0;
                    while (k2 < coordPArGeometry.size()) {
                        Vector coord2 = (Vector)coordPArGeometry.get(k2);
                        int nbPoint = coord2.size();
                        double[] x = new double[nbPoint];
                        double[] y = new double[nbPoint];
                        int i2 = 0;
                        while (i2 < nbPoint) {
                            x[i2] = ((Point2D.Double)coord2.get((int)i2)).x;
                            y[i2] = ((Point2D.Double)coord2.get((int)i2)).y;
                            ++i2;
                        }
                        xsML.add(x);
                        ysML.add(y);
                        ++k2;
                    }
                    troncon.setXs(xsML);
                    troncon.setYs(ysML);
                }
                catch (Exception xsML) {}
            }
        }
        catch (Exception e) {
            troncon.setX(null);
            troncon.setY(null);
        }
        try {
            if (rs.getObject("buffer") != null) {
                xs = new Vector();
                ys = new Vector();
                coordPArGeometry = SQL.getPoints2DByGeometry((Geometry)SQL.getChampGeometry((Object)rs.getObject("buffer")));
                int k = 0;
                while (k < coordPArGeometry.size()) {
                    coord = (Vector)coordPArGeometry.get(k);
                    int nbPoint = coord.size();
                    double[] x = new double[nbPoint];
                    double[] y = new double[nbPoint];
                    int i = 0;
                    while (i < nbPoint) {
                        x[i] = ((Point2D.Double)coord.get((int)i)).x;
                        y[i] = ((Point2D.Double)coord.get((int)i)).y;
                        ++i;
                    }
                    xs.add(x);
                    ys.add(y);
                    ++k;
                }
                troncon.setXs(xs);
                troncon.setYs(ys);
            }
        }
        catch (Exception xs2) {
            // empty catch block
        }
        try {
            troncon.setCch(rs.getString("cch"));
            troncon.setCch2(rs.getString("cch2"));
            troncon.setTendanceCC(rs.getString("tendancecc"));
            troncon.setTraitement(rs.getString("traitement"));
            troncon.setMeteo(rs.getString("meteo"));
            troncon.setCommentaire(rs.getString("commentaire"));
            troncon.setEquipements(rs.getString("equipements"));
            troncon.setEtatChaussee(rs.getString("etat_chaussee"));
            troncon.setTemperature(rs.getString("temperature"));
            troncon.setVent(rs.getString("vent"));
            troncon.setCommentaireInterne(rs.getString("commentaire_interne"));
            int numSensInt = -1;
            int numSensChar = -1;
            int i = 1;
            while (i <= rs.getMetaData().getColumnCount()) {
                if ("sens".equals(rs.getMetaData().getColumnName(i))) {
                    if (rs.getMetaData().getColumnType(i) == 4) {
                        numSensInt = i;
                    } else {
                        numSensChar = i;
                    }
                }
                ++i;
            }
            if (numSensChar >= 0) {
                troncon.setSens(rs.getString(numSensChar));
            }
            if (numSensInt >= 0) {
                troncon.setSensNumerique(rs.getInt(numSensInt));
            }
            troncon.setDuree(rs.getInt("duree"));
            try {
                troncon.setIndice(rs.getInt("indice"));
            }
            catch (Exception ex) {
                troncon.setIndice(-1);
            }
        }
        catch (Exception ex) {
            troncon.setMajIdPartenaire(-1);
        }
        try {
            troncon.setMcig(rs.getString("mcig_id"));
            troncon.setUtilisateur(rs.getString("mcig_utilisateur"));
            troncon.setTypePoste(rs.getInt("mcig_type_poste"));
        }
        catch (Exception e) {
            troncon.setMcig(null);
        }
    }

    @Override
    public StatsCamionsVHBean getCamionsVH(Timestamp dateDebut, Timestamp dateFin, List<String> centres) {
        StatsCamionsVHBean retour = new StatsCamionsVHBean();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String req = SQL_CAMIONS_VH;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(req);
                pstm.setArray(1, connection.createArrayOf("text", centres.toArray()));
                pstm.setTimestamp(2, dateDebut);
                pstm.setTimestamp(3, dateFin);
                rs = pstm.executeQuery();
                Log.debug(pstm);
                retour.setDateDebut(dateDebut);
                retour.setDateFin(dateFin);
                while (rs.next()) {
                    StatsCamionsVHCentreBean statCentre = new StatsCamionsVHCentreBean();
                    statCentre.setCamions(rs.getInt("max_camion"));
                    statCentre.setCamionsDati(rs.getInt("max_camion_dati"));
                    statCentre.setCentre(rs.getString("nom_ct"));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(rs.getTimestamp("jour"));
                    statCentre.setMois(cal.get(2));
                    statCentre.setJour(cal.get(5));
                    statCentre.setDate(cal);
                    retour.getStatsCentres().add(statCentre);
                }
                pstm.close();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        System.out.println(retour);
        return retour;
    }
}

