/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.IUserDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.ActionProfil;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public class UserDAOJDBC
implements IUserDAO {
    private static final String SQL_LOGIN = "SELECT * FROM prism.utilisateur WHERE sna= ? AND password= ? AND mse = ? AND archive=0";
    private static final String SQL_LOGIN_LDAP = "SELECT * FROM prism.utilisateur WHERE sna= ? AND mse = ? AND archive=0";
    private static final String SQL_RECHERCHE_UTILISATEUR_LOGIN = "SELECT * FROM prism.utilisateur WHERE sna= ? AND mse = ?";
    private static final String SQL_PROFIL = "SELECT p.id as id, p.nom as nom, p.module_accueil as module_accueil, id_action as action,a.parametres FROM prism.profil as p JOIN prism.profil_action as a ON p.id = a.id_profil WHERE p.id=? AND est_actif='t'";
    private static final String SQL_TOUS_PROFIL = "SELECT p.id as id, p.nom as nom ,id_action as action,a.parametres FROM prism.profil as p LEFT OUTER JOIN prism.profil_action as a ON p.id = a.id_profil WHERE zone=? AND systeme = 0 AND (est_actif='t' OR est_actif IS NULL) ORDER BY p.id";
    private static final String SQL_GET_CONNECTION_TYPE_BY_LOGIN = "SELECT connection_type FROM utilisateur WHERE sna= ? AND mse = ? AND archive=0";
    private static final String SQL_RECHERCHE_TOUTUTILISATEUR_MCE = "SELECT nom, sna, id_profil,id_utilisateur,mail,telephone,delegation,centre,archive,password,admin_fonc FROM prism.utilisateur WHERE mse = ? and archive = 0 and id_profil IN (select p.id from (profil p inner join profil_action pa on p.id = pa.id_profil) inner join action a on pa.id_action = a.id where a.nom = 'MCE' and p.zone = ?) ORDER BY nom ASC";
    private static final String SQL_RECHERCHE_UTILISATEUR_DELEGATION = "SELECT nom, sna, id_profil,id_utilisateur,mail,telephone,delegation,centre,archive,connection_type,admin_fonc,systeme FROM prism.utilisateur WHERE mse = ? and (delegation = ? or delegation is null) ORDER BY nom ASC";
    private static final String SQL_RECHERCHE_UTILISATEUR = "SELECT nom, sna, id_profil,id_utilisateur,mail,telephone,delegation,centre,archive,connection_type,admin_fonc,systeme FROM prism.utilisateur WHERE mse = ? ORDER BY nom ASC";
    private static final String SQL_RECHERCHE_UTILISATEUR_DELEGATION_CENTRE = "SELECT nom, sna, id_profil,id_utilisateur,delegation,mail,telephone,centre,archive,connection_type,admin_fonc,systeme FROM prism.utilisateur WHERE mse = ? and (delegation = ? or delegation is null) and (centre = ? or centre is null) ORDER BY nom ASC";
    private static final String SQL_RECHERCHE_UTILISATEUR_DELEGATION_CENTRE_DYNAMIQUE = "SELECT u.nom, u.sna, u.id_profil,u.id_utilisateur,u.delegation,u.mail,u.telephone,u.centre,u.archive,u.connection_type,u.admin_fonc,systeme FROM prism.utilisateur u left outer join prism.centre_rattachement c on u.centre = c.nom WHERE u.mse = ? and (u.delegation = ? or u.delegation is null) and (c.path like ? or u.centre is null) ORDER BY u.nom ASC";
    private DAOFactory daoFactory;
    private IReferentielDAO refDAO;

    public UserDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO) {
        this.daoFactory = daoFactory;
        this.refDAO = refDAO;
    }

    @Override
    public PrismCentralUser login(String username, String password) throws DAOException {
        PrismCentralUser user = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LOGIN);
                pstm.setString(1, username);
                pstm.setString(2, MetierCommun.instanceOf().hashPassword(password));
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                Log.debug(pstm.toString());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    user = new PrismCentralUser();
                    user.setNom(rs.getString("nom"));
                    user.setCode(username);
                    user.setId(rs.getInt("id_utilisateur"));
                    user.setDelegation(rs.getString("delegation"));
                    user.setCentre(rs.getString("centre"));
                    user.setArchive(false);
                    user.setIdProfil(rs.getLong("id_profil"));
                    user.setSysteme(GLS.getBoolean((int)rs.getInt("systeme"), (boolean)false));
                    try {
                        user.setAdminUa(rs.getBoolean("isadminua"));
                        user.setSuperAdminUa(rs.getBoolean("issuperadmin"));
                    }
                    catch (Exception e) {
                        user.setAdminUa(false);
                        user.setSuperAdminUa(false);
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        if (user != null) {
            if (!user.isSuperAdmin()) {
                user.setProfil(this.loadProfil(user.getIdProfil()));
            } else {
                user.setProfil(this.getProfilSuperAdmin(user.getIdProfil()));
            }
        }
        Log.info("loged in user : " + user);
        return user;
    }

    @Override
    public PrismCentralUser loginLDAP(String login) throws DAOException {
        PrismCentralUser user = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LOGIN_LDAP);
                pstm.setString(1, login);
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                Log.debug(pstm.toString());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    user = new PrismCentralUser();
                    user.setNom(rs.getString("nom"));
                    user.setCode(login);
                    user.setId(rs.getInt("id_utilisateur"));
                    user.setDelegation(rs.getString("delegation"));
                    user.setCentre(rs.getString("centre"));
                    user.setArchive(false);
                    user.setIdProfil(rs.getLong("id_profil"));
                    user.setConnectionType(rs.getString("connection_type"));
                    user.setSysteme(GLS.getBoolean((int)rs.getInt("systeme"), (boolean)false));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        if (user != null) {
            if (!user.isSuperAdmin()) {
                user.setProfil(this.loadProfil(user.getIdProfil()));
            } else {
                user.setProfil(this.getProfilSuperAdmin(user.getIdProfil()));
            }
        }
        Log.info("loged in user : " + user);
        return user;
    }

    @Override
    public PrismCentralUser rechercheUtilisateurParLogin(String codeUtilisateur) {
        PrismCentralUser user = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_RECHERCHE_UTILISATEUR_LOGIN);
                pstm.setString(1, codeUtilisateur);
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                if (rs.next()) {
                    user = new PrismCentralUser();
                    user.setNom(rs.getString("nom"));
                    user.setCode(codeUtilisateur);
                    user.setId(rs.getInt("id_utilisateur"));
                    user.setDelegation(rs.getString("delegation"));
                    user.setCentre(rs.getString("centre"));
                    user.setArchive(rs.getInt("archive") == 1);
                    user.setTelephone(rs.getString("telephone"));
                    user.setMail(rs.getString("mail"));
                    user.setIdProfil(rs.getLong("id_profil"));
                    user.setAdminFonctionnel(rs.getBoolean("admin_fonc"));
                    try {
                        user.setConnectionType(rs.getString("connection_type"));
                    }
                    catch (Exception e) {
                        user.setConnectionType("prism");
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        if (user != null) {
            if (!user.isSuperAdmin()) {
                user.setProfil(this.loadProfil(user.getIdProfil()));
            } else {
                user.setProfil(this.getProfilSuperAdmin(user.getIdProfil()));
            }
        }
        return user;
    }

    private Profil getProfilSuperAdmin(long idProfil) {
        Profil p = new Profil();
        List<ActionProfil> actP = this.refDAO.getActionsProfil();
        HashSet<Integer> actions = new HashSet<Integer>();
        p.setActions(actions);
        p.setId((int)idProfil);
        p.setName("Super");
        p.setModule_accueil("");
        for (ActionProfil a : actP) {
            actions.add(a.getAction());
        }
        return p;
    }

    private Profil loadProfil(long idProfil) throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Profil p = new Profil();
        HashSet<Integer> actions = new HashSet<Integer>();
        HashMap<Integer, MapDescription> parametres = new HashMap<Integer, MapDescription>();
        p.setActions(actions);
        p.setParametres(parametres);
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_PROFIL);
                pstm.setLong(1, idProfil);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    p.setId(rs.getInt("id"));
                    p.setName(rs.getString("nom"));
                    p.setModule_accueil(rs.getString("module_accueil"));
                    actions.add(rs.getInt("action"));
                    try {
                        Array array = rs.getArray("parametres");
                        if (array == null) continue;
                        parametres.put(rs.getInt("action"), MapDescription.parse((String[])((String[])array.getArray())));
                    }
                    catch (Throwable t) {
                        Log.error("ERROR PARAMETRES PROFIL ACTION", t);
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return p;
    }

    @Override
    public List<Utilisateur> rechercheToutUtilisateurEmbarque() throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Utilisateur> liste = new ArrayList<Utilisateur>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_RECHERCHE_TOUTUTILISATEUR_MCE);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Utilisateur user = new Utilisateur();
                    user.setId(rs.getLong("id_utilisateur"));
                    user.setNom(rs.getString("nom"));
                    user.setCode(rs.getString("sna"));
                    user.setIdProfil(Long.valueOf(rs.getLong("id_profil")));
                    user.setDelegation(rs.getString("delegation"));
                    user.setCentre(rs.getString("centre"));
                    user.setPasswordHash(rs.getString("password"));
                    liste.add(user);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<PrismCentralUser> rechercheUtilisateurParDelegation(PrismCentralUser user) throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Vector<PrismCentralUser> liste = new Vector<PrismCentralUser>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_RECHERCHE_UTILISATEUR_DELEGATION);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, user.getDelegation());
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PrismCentralUser rsUser = new PrismCentralUser();
                    rsUser.setNom(rs.getString("nom"));
                    rsUser.setCode(rs.getString("sna"));
                    rsUser.setId(rs.getInt("id_utilisateur"));
                    rsUser.setIdProfil(rs.getLong("id_profil"));
                    rsUser.setArchive(rs.getInt("archive") == 1);
                    rsUser.setDelegation(rs.getString("delegation"));
                    rsUser.setCentre(rs.getString("centre"));
                    user.setTelephone(rs.getString("telephone"));
                    user.setMail(rs.getString("mail"));
                    user.setConnectionType(rs.getString("connection_type"));
                    rsUser.setAdminFonctionnel(rs.getBoolean("admin_fonc"));
                    liste.add(rsUser);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<PrismCentralUser> rechercheUtilisateurParDelegationCentre(PrismCentralUser user) throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Vector<PrismCentralUser> liste = new Vector<PrismCentralUser>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = !GLS.estVide((String)user.getCentre()) ? (this.refDAO.isDynamicUA() ? connection.prepareStatement(SQL_RECHERCHE_UTILISATEUR_DELEGATION_CENTRE_DYNAMIQUE) : connection.prepareStatement(SQL_RECHERCHE_UTILISATEUR_DELEGATION_CENTRE)) : (!GLS.estVide((String)user.getDelegation()) ? connection.prepareStatement(SQL_RECHERCHE_UTILISATEUR_DELEGATION) : connection.prepareStatement(SQL_RECHERCHE_UTILISATEUR));
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (!GLS.estVide((String)user.getDelegation())) {
                    pstm.setString(2, user.getDelegation());
                }
                if (!GLS.estVide((String)user.getCentre())) {
                    if (this.refDAO.isDynamicUA()) {
                        pstm.setString(3, DAOUtil.getValeurFiltreCeiDynamique(user.getCentre()));
                    } else {
                        pstm.setString(3, user.getCentre());
                    }
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PrismCentralUser rsUser = new PrismCentralUser();
                    rsUser.setNom(rs.getString("nom"));
                    rsUser.setCode(rs.getString("sna"));
                    rsUser.setId(rs.getInt("id_utilisateur"));
                    rsUser.setIdProfil(rs.getLong("id_profil"));
                    rsUser.setArchive(rs.getInt("archive") == 1);
                    rsUser.setDelegation(rs.getString("delegation"));
                    rsUser.setCentre(rs.getString("centre"));
                    rsUser.setTelephone(rs.getString("telephone"));
                    rsUser.setMail(rs.getString("mail"));
                    rsUser.setProfil(this.loadProfil(rsUser.getIdProfil()));
                    rsUser.setConnectionType(rs.getString("connection_type"));
                    rsUser.setAdminFonctionnel(rs.getBoolean("admin_fonc"));
                    rsUser.setSysteme(rs.getInt("systeme") == 1);
                    liste.add(rsUser);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<Profil> getProfils() {
        ArrayList<Profil> ret = new ArrayList<Profil>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TOUS_PROFIL);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                Profil encours = null;
                HashSet<Integer> actions = null;
                HashMap<Integer, MapDescription> parametres = null;
                while (rs.next()) {
                    int id = rs.getInt("id");
                    if (encours == null) {
                        encours = new Profil();
                        actions = new HashSet<Integer>();
                        parametres = new HashMap<Integer, MapDescription>();
                        encours.setActions(actions);
                        encours.setParametres(parametres);
                    } else if (encours.getId() != id) {
                        ret.add(encours);
                        encours = new Profil();
                        actions = new HashSet();
                        parametres = new HashMap();
                        encours.setActions(actions);
                        encours.setParametres(parametres);
                    }
                    encours.setId(id);
                    encours.setName(rs.getString("nom"));
                    actions.add(rs.getInt("action"));
                    try {
                        Array array = rs.getArray("parametres");
                        if (array == null) continue;
                        parametres.put(rs.getInt("action"), MapDescription.parse((String[])((String[])array.getArray())));
                    }
                    catch (Throwable t) {
                        Log.error("ERROR PARAMETRES PROFIL ACTION", t);
                    }
                }
                if (encours != null) {
                    ret.add(encours);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return ret;
    }

    @Override
    public String getUserConnectionType(String login) {
        String connectionType = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_CONNECTION_TYPE_BY_LOGIN);
                pstm.setString(1, login);
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                Log.debug(pstm.toString());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    connectionType = rs.getString("connection_type");
                }
            }
            catch (SQLException e) {
                DAOUtil.close(connection, pstm, rs);
                return "prism";
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return connectionType;
    }
}

