/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Activite;
import com.geolocsystems.prismandroid.model.Bounds;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.CircuitExploitation;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.Direction;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.NiveauExploitation;
import com.geolocsystems.prismandroid.model.ParametrePatrouille;
import com.geolocsystems.prismandroid.model.Point;
import com.geolocsystems.prismandroid.model.PointPassage;
import com.geolocsystems.prismandroid.model.PrismAction;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TypeUtilisateur;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.Voie;
import com.geolocsystems.prismandroid.model.ZoneSensible;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.RaccourciNature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAlternat;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampEntier;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampImages;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampPatrouilleProcedure;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampRadioBouton;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampSignature;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionLocalisation;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionMultiCheckBox;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionProfil;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiCheckBox;
import com.geolocsystems.prismandroid.model.tunnel.PointParticulier;
import com.geolocsystems.prismandroid.model.tunnel.Tube;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordFrequencePatrouilleBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordFrequencePatrouilleV2Bean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueCircuitBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueSchemaRoutierBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IIconDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.Jdbc.PrismBddConfigurationError;
import com.geolocsystems.prismcentral.DAO.Jdbc.RestrictionFactory;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.ActionProfil;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.BarreauVHHisto;
import com.geolocsystems.prismcentral.beans.Commune;
import com.geolocsystems.prismcentral.beans.ComposantBean;
import com.geolocsystems.prismcentral.beans.ComposantNatureCommunBean;
import com.geolocsystems.prismcentral.beans.DescriptionNatureBean;
import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.FiltreComposantNatureCommunBean;
import com.geolocsystems.prismcentral.beans.FiltreDescriptionNatureBean;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.ListeDiffusion;
import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.geolocsystems.prismcentral.beans.NatureBean;
import com.geolocsystems.prismcentral.beans.NiveauService;
import com.geolocsystems.prismcentral.beans.NiveauServicePeriode;
import com.geolocsystems.prismcentral.beans.Onglet;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentral.beans.Synthese;
import com.geolocsystems.prismcentral.beans.TypesMarques;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import com.google.gson.Gson;
import gls.geometry.Geometry;
import gls.localisation.InfoVoieLocalisation;
import gls.localisation.LocalisationInfo;
import gls.outils.GLS;
import gls.outils.Util;
import gls.outils.sql.SQL;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.Vector;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.PGbox2d;
import org.postgis.PGgeometry;
import org.postgis.Polygon;

public class ReferentielDAOJDBC
implements IReferentielDAO {
    private static final String SQL_NATURE_TOUTES = "SELECT code,libelle,code_categorie,code_module_metier,duree,indice,active FROM prism.nature_perso WHERE zone_routiere=? ORDER BY indice";
    private static final String SQL_NATURE_ACTIVE = "SELECT code,libelle,code_categorie,code_module_metier,duree,indice,active FROM prism.nature_perso WHERE active='1' AND zone_routiere=? ORDER BY indice";
    private static final String SQL_TYPE_COMPOSANTS = "SELECT nom,libelle FROM prism.type_composant ORDER BY nom";
    private static final String SQL_COMPOSANTS = "SELECT * FROM prism.composant ORDER BY nom";
    private static final String SQL_ONGLETSCHAMP = "SELECT nom,libelle FROM onglets WHERE zone_routiere=? ORDER BY indice";
    private static final String SQL_RACCOURCIS = "SELECT nature,libelle,icone,indice,code FROM nature_raccourci WHERE zone_routiere=?";
    private static final String SQL_SOUSCHAMPS = "SELECT nom,NULL as \"redif\",NULL as \"reres\",libelle,definition,type,parent,restrictions,defaut,style,hauteur,NULL as \"nom_onglet\" FROM prism.composant WHERE zone_routiere=? AND parent=? ORDER BY indice";
    private static final String SQL_DESCRIPTIONNATURE = "SELECT libelle FROM prism.description_nature_perso WHERE zone_routiere=? AND nature=? ORDER BY indice";
    private static final String SQL_DESCRIPTIONNATURECOMPLET = "SELECT code,libelle,indice FROM prism.description_nature_perso WHERE zone_routiere=? AND nature=? ORDER BY indice";
    private static final String SQL_TYPES_UTILISATEUR = "SELECT type,libelle FROM type_utilisateur";
    private static final String SQL_CHAMPSNATURE = "SELECT nom,composants_nature.indice,redefinition as \"redif\",composants_nature.rerestrictions as \"reres\",libelle,definition,type,parent,restrictions,defaut,nom_onglet,hauteur,style FROM prism.composants_nature JOIN prism.composant ON nom_composant=nom WHERE code_nature=? AND composants_nature.zone_routiere=? AND parent IS NULL ORDER BY indice";
    private static final String SQL_CHAMPSCOMMUNS = "SELECT nom,composants_commun.indice,redefinition as \"redif\",composants_commun.rerestrictions as \"reres\",composant.libelle,definition,type,parent,restrictions,defaut,nom_onglet,hauteur,style FROM prism.composants_commun JOIN prism.composant ON nom_composant=nom WHERE composants_commun.zone_routiere=? AND parent IS NULL AND (code_module_metier = -1 OR code_module_metier = ?) ORDER BY indice";
    private static final String SQL_MODULES_METIERS = "SELECT mmp.libelle as libelle_perso,mmp.module_herite,mmp.code, mm.* FROM prism.module_metier_perso mmp inner join prism.module_metier mm on mm.code = mmp.code WHERE zone_routiere=? ORDER BY mmp.indice";
    private static final String SQL_MODULE_METIER = "SELECT mmp.libelle, mm.nom, mmp.code, mm.activite_suivi FROM prism.module_metier_perso mmp inner join prism.module_metier mm on mm.code = mmp.code WHERE zone_routiere=? AND mm.libelle=?";
    private static final String SQL_CIRCUITS_MODULES_METIERS = "SELECT id,nom,delegation,systeme,centre FROM prism.circuit WHERE archive=0 AND zone_routiere=? AND type=?";
    private static final String SQL_CIRCUIT = "SELECT id,nom,delegation,systeme,centre,type FROM prism.circuit WHERE id=?";
    private static final String SQL_PRISM_ACTION = "SELECT * from prism.prism_action";
    private static final String SQL_ACTIVITES = "SELECT code,libelle from prism.activite ORDER BY code";
    private static final String SQL_ACTIONS = "SELECT id,nom,description,parent from prism.action ORDER BY nom";
    private static final String SQL_VEHICULES = "SELECT * from prism.vehicule WHERE zone_routiere=? ORDER BY ";
    private static final String SQL_MAJ_DONNEES_METIER = "SELECT * from prism.update_donnees_metiers WHERE zone_routiere=?";
    private static final String SQL_MARQUES_VEHICULES = "SELECT * from prism.marque_vehicule WHERE zone_routiere=? ORDER BY nom";
    private static final String SQL_TYPE_MARQUE = "SELECT code,libelle from prism.type_vehicule WHERE zone_routiere=?";
    private static final String SQL_DESTINATAIRE_MAIL = "SELECT mail,nom_destinataire_mail as nom,nom_categorie_destinataire_mail as cat,delegation,centre,id_destinataire as id from prism.destinataire_mail WHERE mse=?";
    private static final String SQL_LISTE_DESTINATAIRE_MAIL = "SELECT id_liste_destinataire_mail as id,nom_liste_destinataire_mail as nom FROM prism.liste_destinataire_mail WHERE zone_routiere=?";
    private static final String SQL_CATEGORIES_DESTINATAIRE_MAIL = "SELECT * from prism.categorie_destinataire_mail";
    private static final String SQL_LISTE_DIFFUSION = "SELECT * from prism.liste_diffusion WHERE zone_routiere=?";
    private static final String SQL_LISTE_DIFFUSION_EVT = "SELECT * from prism.liste_diffusion_evenement WHERE zone_routiere=?";
    private static final String SQL_ACTIVITES_CENTRE = "SELECT * FROM prism.centre_rattachement inner join prism.activite_centre ac on centre_rattachement.nom = ac.centre where ac.activite = ? ORDER BY nom";
    private static final String SQL_LISTE_VOIES_LOCALISATION = "SELECT * FROM carto.voies_localisation";
    private static final String SQL_ASTREINTE_COMMUNE = "SELECT * FROM astreinte_commune ORDER BY commune";
    private static final String SQL_DIRECTION_ROUTE = "SELECT axe,abscisseprdebut,prdebut,prfin,abscisseprfin,direction FROM donnees_metier.direction ORDER BY axe,prdebut";
    private static final String SQL_CATEGORIE_ROUTE = "SELECT axe,abscisseprdebut,prdebut,prfin,abscisseprfin,niveau FROM donnees_metier.niveau_exploitation ORDER BY axe,prdebut";
    private static final String SQL_TRAFIC_ROUTE = "SELECT axe,abscisseprdebut,prdebut,prfin,abscisseprfin,niveau FROM donnees_metier.niveau_trafic ORDER BY axe,prdebut";
    private static final String SQL_ZONE_SENSIBLE = "SELECT id,axe,departementprdebut,departementprfin,abscisseprdebut,prdebut,prfin,abscisseprfin,sens,voie,z.code_type_zone_sensible as type,description,vitesse,couleur,t.libelle_type_zone_sensible as libelletype,z.fk_niveau_service as niveau,st_force2d(coordonnees) as coordonnees,longueur,idcircuit FROM donnees_metier.zone_sensible z inner join donnees_metier.type_zone_sensible t on z.code_type_zone_sensible = t.code_type_zone_sensible WHERE longueur > -1 ORDER BY axe,prdebut";
    private static final String SQL_LISTE_NIVEAU_SERVICE = "SELECT id, libelle, type_periode, nb_periode, frequence FROM prism.niveau_service ORDER BY libelle";
    private static final String SQL_LISTE_NIVEAU_SERVICE_PERIODE = "SELECT id_periode, id_niveau_service, date_debut, date_fin FROM prism.niveau_service_periode ORDER BY id_niveau_service";
    private static final String SQL_RECHERCHE_TOUTUTILISATEUR = "SELECT nom, sna, id_profil,id_utilisateur,delegation,mail,telephone,centre,archive,connection_type,admin_fonc,systeme FROM prism.utilisateur WHERE mse = ? ORDER BY nom ASC";
    private static final String SQL_PARAMETRE_PATROUILLE = "SELECT nom,libelle,mm,type_saisie,type_champ,definition,description from parametre_patrouille ORDER BY nom";
    private static final String SQL_TUNNELS = "SELECT id,libelle from donnees_metier.tunnel ORDER BY libelle";
    private static final String SQL_TUBES = "SELECT id,libelle,sens from donnees_metier.tube  where tunnel = ? ORDER BY libelle";
    private static final String SQL_PP_TUNNEL = "SELECT pp.id,pp.libelle,pp.axe,pp.pr,pp.coordonnees,tpp.libelle as libelle_type,pp.tube,pp.tunnel from donnees_metier.pp_tunnel pp inner join donnees_metier.type_pp_tunnel tpp on pp.type = tpp.id where pp.tube = ? ";
    private static final String SQL_SCHEMA_ROUTIER_NIV_EXPLOITATION = "SELECT *  FROM stats.schema_routier_exploitation s, donnees_metier.schema_routier tc WHERE s.idtroncon = tc.oid";
    private static final String SQL_SCHEMA_ROUTIER_AXE = "SELECT distinct(axe) FROM donnees_metier.schema_routier tc ";
    private static final String SQL_SCHEMA_ROUTIER_AXE_ORDER = " ORDER BY axe";
    private static final String SQL_SCHEMA_FAUCHAGE_NIV_EXPLOITATION = "SELECT *  FROM fauchage.schema_fauchage_exploitation s, fauchage.schema_fauchage tc WHERE s.idtroncon = tc.oid";
    private static final String SQL_LIBELLE_CORRESPONDANCE = "SELECT * FROM libelle_correspondance WHERE id = ?";
    private Map<String, CCHStatus> listeCCH;
    private DAOFactory daoFactory;
    private IIconDAO iconDal;
    private Map<String, Voie> voies;
    private List<NatureOuRaccourci> natures;
    private Map<String, Nature> natureMap;
    private Map<String, Integer> natureMmMap;
    private Map<String, List<DescriptionNature>> descNatMap;
    private List<Onglet> onglets;
    private List<Delegation> delegations;
    private List<Delegation> delegationsActives;
    private Extension configuration;
    private Map<String, PrismCentralUser> utilisateurs;
    private Map<Integer, PrismCentralUser> codesUtilisateurs;
    private Map<Integer, ModuleMetier> modulesMetiers;
    private Map<Integer, List<String>> categoriesNatureMm;
    private Map<String, String> categoriesNature;
    private Map<String, List<Troncon>> categoriesRoute;
    private List<String> listeCategoriesRoute;
    private Map<String, List<Troncon>> traficRoute;
    private Map<String, List<Direction>> directionsRoute;
    private Map<String, List<ZoneSensible>> zonesSensibles;
    private Map<String, Circuit> circuits;
    private List<ActionProfil> actionsProfils;
    private List<Vehicule> vehicules;
    private List<MarqueVehicule> marquesVehicules;
    private Map<Integer, TypesMarques> typesMarques;
    private List<DestinataireMail> destinataireMails;
    private List<String> categoriesdestinataireMail;
    private List<ListeDestinataireMail> listeDestinatiresMail;
    private List<ListeDiffusion> listesDiffusions;
    private Map<String, Integer> mapDiffusionsEvenements;
    private Map<String, ReformulationDescription> reformulationMap;
    private Map<String, String[]> valeursReformulations;
    private List<String> listeCommunes;
    private Map<String, String> communesDelegation;
    private Map<String, List<String>> astreintesCommunes;
    private Map<String, Commune> communes;
    private List<ModuleMetier> listeModulesMetiers;
    private Map<String, String> listeTypeComposants;
    private Map<String, ComposantBean> listeComposants;
    private Map<String, ComposantBean> listeComposantsUtilises;
    private Map<String, String> correspondanceComposantChamp;
    private List<Restriction> stylesPublication;
    private Map<String, Map<String, List<Troncon>>> caracteristiquesRoute;
    private Map<String, Map<String, List<String>>> tronconsAffectation;
    private Map<String, List<Troncon>> tronconsCentre;
    private Map<String, String> codesCentre;
    private List<TypeUtilisateur> typesUtilisateur;
    private Map<String, Bounds> communesBounds;
    private List<Tunnel> tunnels;
    private List<ParametrePatrouille> parametrePatrouille;
    private Map<String, Map<String, List<PrismAction>>> listePrismActions;
    private String SQL_LISTE_NATURES_PERSO = "SELECT * FROM nature_perso";
    private String SQL_LISTE_COMPOSANTS = "SELECT * FROM composant ";
    private String SQL_LISTE_COMPOSANTS_NATURE = "SELECT cn.*,c.type FROM composants_nature cn inner join composant c on cn.nom_composant = c.nom";
    private String SQL_LISTE_COMPOSANTS_COMMUN = "SELECT cn.*,c.type FROM composants_commun cn inner join composant c on cn.nom_composant = c.nom";
    private String SQL_LISTE_DESCRIPTIONS_NATURE = "SELECT * FROM description_nature_perso";

    public ReferentielDAOJDBC(DAOFactory daoFactory, IIconDAO iconDal) {
        this.daoFactory = daoFactory;
        this.iconDal = iconDal;
    }

    @Override
    public void update() {
        this.natures = null;
        this.natureMap = null;
        this.onglets = null;
        this.delegations = null;
        this.configuration = null;
        this.utilisateurs = null;
        this.modulesMetiers = null;
        this.descNatMap = null;
        this.actionsProfils = null;
        this.vehicules = null;
        this.marquesVehicules = null;
        this.typesMarques = null;
        this.destinataireMails = null;
        this.categoriesdestinataireMail = null;
        this.listeDestinatiresMail = null;
        this.listesDiffusions = null;
        this.mapDiffusionsEvenements = null;
        this.reformulationMap = null;
        this.valeursReformulations = null;
        this.circuits = null;
        this.listeCommunes = null;
        this.communes = null;
        this.communesDelegation = null;
        this.communesBounds = null;
        this.voies = null;
        this.listeModulesMetiers = null;
        this.correspondanceComposantChamp = null;
        this.listeTypeComposants = null;
        this.listeComposants = null;
        this.listeComposantsUtilises = null;
        this.categoriesRoute = null;
        this.traficRoute = null;
        this.zonesSensibles = null;
        this.directionsRoute = null;
        this.codesCentre = null;
        this.tunnels = null;
        this.parametrePatrouille = null;
        this.typesUtilisateur = null;
        this.listeCategoriesRoute = null;
        this.listePrismActions = null;
        this.natureMmMap = null;
        this.categoriesNature = null;
        this.categoriesNatureMm = null;
        this.astreintesCommunes = null;
    }

    @Override
    public synchronized Extension getConfiguration() {
        if (this.configuration == null) {
            this.chargerConfiguration();
            this.chargerVariablesConfiguration();
        }
        return this.configuration;
    }

    private void chargerVariablesConfiguration() {
        this.stylesPublication = RestrictionFactory.getRestrictions((String)this.configuration.get((Object)"styles_publication"));
    }

    @Override
    public List<Restriction> getStylesPublication() {
        return this.stylesPublication;
    }

    @Override
    public synchronized List<Delegation> getDelegations() {
        if (this.delegations == null) {
            this.chargerDelegations();
        }
        return this.delegations;
    }

    @Override
    public synchronized List<Delegation> getDelegationsActives() {
        if (this.delegationsActives == null) {
            this.chargerDelegations();
        }
        return this.delegationsActives;
    }

    @Override
    public synchronized List<NatureOuRaccourci> getNatures() {
        if (this.natures == null || this.natureMap == null || this.descNatMap == null) {
            try {
                this.chargerNatureEtRaccourcis();
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la liste des natures", e);
            }
        }
        return this.natures;
    }

    @Override
    public Nature getNatureFromDescription(String codeDescription) {
        if (this.descNatMap != null && this.natureMap != null) {
            for (String n : this.descNatMap.keySet()) {
                for (DescriptionNature d : this.descNatMap.get(n)) {
                    if (!GLS.egal((String)codeDescription, (String)d.getCode())) continue;
                    return this.natureMap.get(n);
                }
            }
        }
        return null;
    }

    @Override
    public DescriptionNature getDescriptionFromCode(String codeDescription) {
        if (this.descNatMap != null && this.natureMap != null) {
            for (String n : this.descNatMap.keySet()) {
                for (DescriptionNature d : this.descNatMap.get(n)) {
                    if (!GLS.egal((String)codeDescription, (String)d.getCode())) continue;
                    return d;
                }
            }
        }
        return null;
    }

    @Override
    public synchronized String getNaturesJSON() {
        Gson g = new Gson();
        return g.toJson(this.getNatures());
    }

    protected synchronized Map<String, Voie> getVoies(Connection connection) {
        if (this.voies == null) {
            try {
                this.chargerVoiesLocalisation(connection);
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la liste des voies", e);
            }
        }
        return this.voies;
    }

    @Override
    public synchronized Map<String, List<Direction>> getDirections() {
        if (this.directionsRoute == null) {
            try {
                this.chargerDirectionRoute();
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la liste des directions", e);
            }
        }
        return this.directionsRoute;
    }

    @Override
    public Map<String, List<String>> getAstreintesCommune() {
        if (this.astreintesCommunes == null) {
            try {
                this.chargerAstreintesCommune();
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la liste des astreintes communes", e);
            }
        }
        return this.astreintesCommunes;
    }

    public Circuit getCircuit(String id) {
        return this.circuits.get(id);
    }

    @Override
    public Circuit getCircuitDirect(long id) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Circuit c = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_CIRCUIT);
                pstm.setLong(1, id);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    c = new Circuit();
                    c.setId(String.valueOf(rs.getInt("id")));
                    c.setCentre(rs.getString("centre"));
                    c.setDelegation(rs.getString("delegation"));
                    c.setNom(rs.getString("nom"));
                    c.setType(rs.getString("type"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return c;
    }

    @Override
    public Map<String, List<Troncon>> getCategoriesRoute() {
        if (this.categoriesRoute == null) {
            this.chargerCategoriesRoute();
        }
        return this.categoriesRoute;
    }

    @Override
    public Map<String, List<Troncon>> getTraficRoute() {
        if (this.traficRoute == null) {
            this.chargerTraficRoute();
        }
        return this.traficRoute;
    }

    @Override
    public Map<String, List<ZoneSensible>> getZonesSensibles() {
        if (this.zonesSensibles == null) {
            this.chargerZonesSensibles();
        }
        return this.zonesSensibles;
    }

    @Override
    public void validationPointsPassage(MainCourante m, Map<ZoneSensible, Long> l) {
        String REQ_UPDATE = "insert into donnees_metier.zone_sensible_hist (id_zone,date,mcig_id) values(?,?,?)";
        Log.debug("Validation point de passage --> " + l);
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(REQ_UPDATE);
                for (Map.Entry<ZoneSensible, Long> entry : l.entrySet()) {
                    ZoneSensible z = entry.getKey();
                    Long date = entry.getValue();
                    pstm.setInt(1, GLS.getInt((String)z.getId()));
                    pstm.setTimestamp(2, new Timestamp(date));
                    pstm.setString(3, m.getId());
                    pstm.execute();
                    Log.debug("Insertion du point de passage hist " + pstm);
                    pstm.clearParameters();
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, null);
        }
    }

    @Override
    public Map<String, Long> getZonesValidees(String zone, long dateDebut, long dateFin) {
        String requete = "select * from donnees_metier.zone_sensible_hist where date between ? and ?";
        Log.debug("Select point passage hist --> " + requete);
        requete = String.valueOf(requete) + " order by date asc";
        Connection connection = null;
        PreparedStatement pstm = null;
        HashMap<String, Long> zonesValidees = new HashMap<String, Long>();
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setTimestamp(1, new Timestamp(dateDebut));
                pstm.setTimestamp(2, new Timestamp(dateFin));
                Log.debug("Re zones validees hist --> " + pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    zonesValidees.put(rs.getString("id_zone"), rs.getTimestamp("date").getTime());
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return zonesValidees;
    }

    @Override
    public Map<String, Map<String, List<Troncon>>> getCaracteristiquesRoute() {
        if (this.caracteristiquesRoute == null) {
            this.caracteristiquesRoute = new HashMap<String, Map<String, List<Troncon>>>();
            this.caracteristiquesRoute.put("trafic", this.getTraficRoute());
            this.caracteristiquesRoute.put("categorie", this.getCategoriesRoute());
        }
        return this.caracteristiquesRoute;
    }

    @Override
    public synchronized Map<String, Nature> getNatureMap() {
        if (this.natures == null || this.natureMap == null || this.descNatMap == null) {
            try {
                Log.debug("ReferentielDAOJDBC -- getNatureMap() => chargerNatureEtRaccourcis");
                this.chargerNatureEtRaccourcis();
                Log.debug("ReferentielDAOJDBC -- getNatureMap() => chargerNatureEtRaccourcis DONE");
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la map des natures", e);
            }
        }
        return this.natureMap;
    }

    @Override
    public Map<String, Integer> getNatureMmMap() {
        if (this.natures == null || this.natureMap == null || this.descNatMap == null || this.natureMmMap == null) {
            try {
                this.chargerNatureEtRaccourcis();
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la map des natures", e);
            }
        }
        return this.natureMmMap;
    }

    private void chargerNatureEtRaccourcis() throws DAOException, PrismBddConfigurationError {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                Log.debug("chargerTypeComposants");
                this.chargerTypeComposants(connection);
                this.correspondanceComposantChamp = new HashMap<String, String>();
                this.listeComposantsUtilises = new HashMap<String, ComposantBean>();
                this.categoriesNatureMm = new HashMap<Integer, List<String>>();
                this.categoriesNature = new HashMap<String, String>();
                Log.debug("ReferentielDAOJDBC -- chargerCategoriesRoute");
                this.chargerCategoriesRoute(connection);
                Log.debug("ReferentielDAOJDBC -- chargerTraficRoute");
                this.chargerTraficRoute(connection);
                Log.debug("ReferentielDAOJDBC -- chargerZonesSensibles");
                this.chargerZonesSensibles(connection);
                Log.debug("ReferentielDAOJDBC -- chargerNatures");
                List<Nature> natures = this.chargerNatures(connection);
                this.natures = new ArrayList<NatureOuRaccourci>();
                this.natureMap = new HashMap<String, Nature>();
                this.descNatMap = new HashMap<String, List<DescriptionNature>>();
                this.natureMmMap = new HashMap<String, Integer>();
                Log.debug("ReferentielDAOJDBC -- foreach(nature): getDescriptionsNatureComplet");
                for (Nature nature : natures) {
                    this.natures.add((NatureOuRaccourci)nature);
                    this.natureMap.put(nature.getCode(), nature);
                    this.descNatMap.put(nature.getCode(), this.getDescriptionsNatureComplet(connection, nature));
                    this.natureMmMap.put(nature.getCode(), nature.getCodeMM());
                }
                Log.debug("ReferentielDAOJDBC -- chargerRaccourcis");
                List<RaccourciNature> raccourcis = this.chargerRaccourcis(connection);
                this.natures.addAll(raccourcis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private void chargerTypeComposants() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                this.chargerTypeComposants(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void chargerTypeComposants(Connection connection) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                PreparedStatement pstm = connection.prepareStatement(SQL_TYPE_COMPOSANTS);
                try {
                    try (ResultSet rs = pstm.executeQuery();){
                        this.listeTypeComposants = new HashMap<String, String>();
                        while (rs.next()) {
                            String nom = rs.getString("nom");
                            String libelle = rs.getString("libelle");
                            this.listeTypeComposants.put(nom, libelle != null ? libelle : "");
                        }
                    }
                    if (pstm == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (pstm == null) throw throwable;
                    pstm.close();
                    throw throwable;
                }
                pstm.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private void chargerComposants() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_COMPOSANTS);
                rs = pstm.executeQuery();
                this.listeComposants = new HashMap<String, ComposantBean>();
                while (rs.next()) {
                    this.listeComposants.put(rs.getString("nom"), this.lireComposant(rs));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    private ComposantBean lireComposant(ResultSet rs) {
        return this.lireComposant(rs, "definition");
    }

    private ComposantBean lireComposant(ResultSet rs, String definition) {
        ComposantBean c = new ComposantBean();
        try {
            c.setNom(rs.getString("nom"));
            c.setLibelle(rs.getString("libelle") == null ? "" : rs.getString("libelle"));
            c.setDefinition(rs.getString(definition));
            c.setType(rs.getString("type"));
            c.setParent(rs.getString("parent"));
            c.setHauteur(Integer.valueOf(rs.getInt("hauteur")));
            c.setZoneRoutiere(rs.getString("zone_routiere"));
            c.setStyle(Integer.valueOf(rs.getInt("style")));
            c.setIndice(Integer.valueOf(rs.getInt("indice")));
            c.setDefaut(rs.getString("defaut"));
            c.setRestrictions(rs.getString("restrictions"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return c;
    }

    private void chargerCategoriesRoute() throws DAOException, PrismBddConfigurationError {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                this.chargerCategoriesRoute(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private void chargerCategoriesRoute(Connection connection) throws DAOException, PrismBddConfigurationError {
        this.categoriesRoute = null;
        this.listeCategoriesRoute = null;
        this.categoriesRoute = new HashMap<String, List<Troncon>>();
        this.listeCategoriesRoute = new ArrayList<String>();
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_CATEGORIE_ROUTE);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setPrDebut(rs.getInt("prdebut"));
                    troncon.setPrFin(rs.getInt("prfin"));
                    troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                    troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                    troncon.setClassification(rs.getString("niveau"));
                    if (!MetierCommun.estDedans(this.listeCategoriesRoute, (Object)troncon.getClassification())) {
                        // empty if block
                    }
                    this.listeCategoriesRoute.add(troncon.getClassification());
                    if (this.categoriesRoute.containsKey(troncon.getAxe())) {
                        this.categoriesRoute.get(troncon.getAxe()).add(troncon);
                        continue;
                    }
                    ArrayList<Troncon> troncons = new ArrayList<Troncon>();
                    troncons.add(troncon);
                    this.categoriesRoute.put(troncon.getAxe(), troncons);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
    }

    private void chargerAstreintesCommune() throws DAOException, PrismBddConfigurationError {
        block7: {
            this.astreintesCommunes = null;
            this.astreintesCommunes = new HashMap<String, List<String>>();
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(SQL_ASTREINTE_COMMUNE);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        String commune = rs.getString("commune");
                        String libelle = rs.getString("libelle");
                        String valeur = rs.getString("valeur");
                        if (GLS.estVide((String)libelle) || GLS.estVide((String)valeur)) continue;
                        if (!this.astreintesCommunes.containsKey(commune)) {
                            this.astreintesCommunes.put(commune, new ArrayList());
                        }
                        String libelleAstreinte = libelle.concat(" : ").concat(valeur);
                        this.astreintesCommunes.get(commune).add(libelleAstreinte);
                    }
                }
                catch (SQLException e) {
                    Log.error("ERREUR CHARGEMENT ASTREINTE COMMUNE - L'OPTION N'EST PAS ACTIVE");
                    DAOUtil.close(connection, pstm, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    private void chargerTronconsCentre() throws DAOException, PrismBddConfigurationError {
        this.tronconsCentre = null;
        this.tronconsAffectation = null;
        this.tronconsCentre = new TreeMap<String, List<Troncon>>();
        this.tronconsAffectation = new TreeMap<String, Map<String, List<String>>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String table = "donnees_metier.troncon_centre";
        boolean avecGeometry = false;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String sql = "SELECT id,departementprdebut,departementprfin,longueur,prdebut,abscisseprdebut,prfin,abscisseprfin,axe,coordonnees,centre,delegation FROM " + table;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("id"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("departementprdebut"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setLongueur(rs.getInt("longueur"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("departementprfin"), (String)""));
                    troncon.setPrDebut(rs.getInt("prdebut"));
                    troncon.setPrFin(rs.getInt("prfin"));
                    troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                    troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                    String centre = rs.getString("centre");
                    String delegation = rs.getString("delegation");
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    if (this.tronconsCentre.containsKey(troncon.getAxe())) {
                        this.tronconsCentre.get(troncon.getAxe()).add(troncon);
                    } else {
                        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
                        troncons.add(troncon);
                        this.tronconsCentre.put(troncon.getAxe(), troncons);
                    }
                    if (this.tronconsAffectation.containsKey(delegation)) {
                        if (!this.tronconsAffectation.get(delegation).containsKey(centre)) {
                            ArrayList<String> axes = new ArrayList<String>();
                            axes.add(troncon.getAxe());
                            this.tronconsAffectation.get(delegation).put(centre, axes);
                            continue;
                        }
                        this.tronconsAffectation.get(delegation).get(centre).add(troncon.getAxe());
                        continue;
                    }
                    TreeMap map = new TreeMap();
                    ArrayList<String> axes = new ArrayList<String>();
                    axes.add(troncon.getAxe());
                    map.put(centre, axes);
                    this.tronconsAffectation.put(delegation, map);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    private void chargerDirectionRoute() throws DAOException, PrismBddConfigurationError {
        block7: {
            this.directionsRoute = null;
            this.directionsRoute = new HashMap<String, List<Direction>>();
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(SQL_DIRECTION_ROUTE);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        Direction troncon = new Direction();
                        troncon.setAxe(rs.getString("axe"));
                        troncon.setPrDebut(rs.getInt("prdebut"));
                        troncon.setPrFin(rs.getInt("prfin"));
                        troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                        troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                        troncon.setDirection(Direction.parseDirections((String)rs.getString("direction")));
                        troncon.setDirections(Direction.parseListeDirection((String)rs.getString("direction")));
                        if (this.directionsRoute.containsKey(troncon.getAxe())) {
                            this.directionsRoute.get(troncon.getAxe()).add(troncon);
                            continue;
                        }
                        ArrayList<Direction> troncons = new ArrayList<Direction>();
                        troncons.add(troncon);
                        this.directionsRoute.put(troncon.getAxe(), troncons);
                    }
                }
                catch (SQLException e) {
                    Log.error("ERREUR CHARGEMENT DIRECTION", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    private void chargerTraficRoute() throws DAOException, PrismBddConfigurationError {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                this.chargerTraficRoute(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private void chargerTraficRoute(Connection connection) throws DAOException, PrismBddConfigurationError {
        this.traficRoute = new HashMap<String, List<Troncon>>();
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_TRAFIC_ROUTE);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setPrDebut(rs.getInt("prdebut"));
                    troncon.setPrFin(rs.getInt("prfin"));
                    troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                    troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                    troncon.setClassification(rs.getString("niveau"));
                    this.traficRoute.computeIfAbsent(troncon.getAxe(), str -> new ArrayList()).add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
    }

    private void chargerZonesSensibles() throws DAOException, PrismBddConfigurationError {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                this.chargerZonesSensibles(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private void chargerZonesSensibles(Connection connection) throws DAOException, PrismBddConfigurationError {
        this.zonesSensibles = new HashMap<String, List<ZoneSensible>>();
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_ZONE_SENSIBLE);
                rs = pstm.executeQuery();
                HashMap<VerificationZoneSensibleCircuitFauchageKey, Boolean> cache = new HashMap<VerificationZoneSensibleCircuitFauchageKey, Boolean>();
                while (rs.next()) {
                    ZoneSensible troncon = new ZoneSensible();
                    troncon.setId(GLS.getString((Object)rs.getInt("id")));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setPrDebut(rs.getInt("prdebut"));
                    troncon.setPrFin(rs.getInt("prfin"));
                    troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                    troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                    troncon.setDepartementPrDebut(rs.getString("departementprdebut"));
                    troncon.setDepartementPrFin(rs.getString("departementprfin"));
                    troncon.setClassification(GLS.getString((Object)rs.getInt("niveau")));
                    troncon.setSensPr(rs.getInt("sens"));
                    troncon.setVitesse(rs.getInt("vitesse"));
                    troncon.setCouleur(rs.getString("couleur"));
                    troncon.setVoie(rs.getString("voie"));
                    troncon.setLongueur(rs.getInt("longueur"));
                    troncon.setLibelleType(rs.getString("libelletype"));
                    troncon.setType(rs.getInt("type"));
                    troncon.setDescription(rs.getString("description"));
                    try {
                        troncon.setCircuit(GLS.getString((Object)rs.getInt("idcircuit")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        float[][] coordonnees = null;
                        PGgeometry geometryPostgis = (PGgeometry)rs.getObject("coordonnees");
                        coordonnees = Geometry.getPointsToFloat((PGgeometry)geometryPostgis);
                        if (coordonnees != null) {
                            if (geometryPostgis.getGeometry() instanceof MultiLineString) {
                                org.postgis.Point[] points;
                                LineString l;
                                MultiLineString mutli = (MultiLineString)geometryPostgis.getGeometry();
                                org.postgis.Point debut = null;
                                org.postgis.Point fin = null;
                                HashMap<org.postgis.Point, Integer> hPoints = new HashMap<org.postgis.Point, Integer>();
                                LineString[] lineStringArray = mutli.getLines();
                                int n = lineStringArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    l = lineStringArray[n2];
                                    org.postgis.Point[] pointArray = points = l.getPoints();
                                    int n3 = points.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        org.postgis.Point p;
                                        Integer cpt = (Integer)hPoints.get(p = pointArray[n4]);
                                        hPoints.put(p, cpt != null ? cpt + 1 : 1);
                                        ++n4;
                                    }
                                    ++n2;
                                }
                                lineStringArray = mutli.getLines();
                                n = lineStringArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    org.postgis.Point finLigne;
                                    l = lineStringArray[n2];
                                    points = l.getPoints();
                                    org.postgis.Point debutLinge = points[0];
                                    if ((Integer)hPoints.get(debutLinge) == 1) {
                                        debut = debutLinge;
                                    }
                                    if ((Integer)hPoints.get(finLigne = points[points.length - 1]) == 1) {
                                        fin = finLigne;
                                    }
                                    ++n2;
                                }
                                if (debut != null) {
                                    troncon.setPointDebut(new Point((float)debut.getX(), (float)debut.getY()));
                                }
                                if (fin != null) {
                                    troncon.setPointFin(new Point((float)fin.getX(), (float)fin.getY()));
                                }
                                if (troncon.getId().equals("59707")) {
                                    Log.debug("59707 debut: " + debut.getX() + "/" + debut.getY());
                                    Log.debug("59707 fin: " + fin.getX() + "/" + fin.getY());
                                }
                            } else {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                            }
                            troncon.setX(coordonnees[0]);
                            troncon.setY(coordonnees[1]);
                        } else {
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            troncon.setX(null);
                            troncon.setY(null);
                        }
                    }
                    catch (Exception e) {
                        troncon.setX(null);
                        troncon.setY(null);
                        troncon.setPointDebut(null);
                        troncon.setPointFin(null);
                        Log.error("ERREUR COORDONNEES TRONCONS", e);
                    }
                    if (troncon.getCircuit() != null && !troncon.getCircuit().equals("") && !cache.computeIfAbsent(new VerificationZoneSensibleCircuitFauchageKey(troncon.getCircuit(), troncon.getClassification()), key -> this.verificationZoneSensibleCircuitFauchage(connection, key.getIdCircuit(), key.getClassification())).booleanValue()) continue;
                    this.zonesSensibles.computeIfAbsent(troncon.getAxe(), str -> new ArrayList()).add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
    }

    /*
     * Loose catch block
     */
    private boolean verificationZoneSensibleCircuitFauchage(Connection connection, String idCircuit, String classification) {
        ResultSet rs;
        PreparedStatement pstm;
        block4: {
            boolean bl;
            pstm = null;
            rs = null;
            try {
                String requete = "SELECT passe_type_id from prism.circuit c, fauchage.passe_circuit  pc where c.type = 3 and c.id = pc.passe_id_circuit and pc.passe_fin is null and c.id = ?";
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, Integer.valueOf(idCircuit));
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                String passeType = rs.getString("passe_type_id");
                bl = classification.equals(passeType);
            }
            catch (SQLException e) {
                DAOUtil.close(null, pstm, rs);
                return true;
                catch (Throwable throwable) {
                    DAOUtil.close(null, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(null, pstm, rs);
            return bl;
        }
        DAOUtil.close(null, pstm, rs);
        return true;
    }

    private List<Nature> chargerNatures() throws DAOException, PrismBddConfigurationError {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                return this.chargerNatures(connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private List<Nature> chargerNatures(Connection connection) throws DAOException, PrismBddConfigurationError {
        ArrayList<Nature> natures = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String requete = MetierCommun.getBoolean((String)ConfigurationFactory.getInstance().get("natures.toutes"), (boolean)false) ? SQL_NATURE_TOUTES : SQL_NATURE_ACTIVE;
                Log.debug("ReferentielDAOJDBC -- chargerNatures => prepareStatement");
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                Log.debug("ReferentielDAOJDBC -- chargerNatures => executeQuery");
                rs = pstm.executeQuery();
                natures = new ArrayList<Nature>();
                Log.debug("ReferentielDAOJDBC -- chargerNatures => parse ResultSet");
                while (rs.next()) {
                    Nature nat = new Nature();
                    nat.setCode(rs.getString("code"));
                    nat.setCodeMM(rs.getInt("code_module_metier"));
                    nat.setLabel(rs.getString("libelle"));
                    nat.setDuree(rs.getInt("duree"));
                    nat.setIndice(rs.getInt("indice"));
                    nat.setActive(rs.getBoolean("active"));
                    natures.add(nat);
                    if (this.categoriesNatureMm == null) continue;
                    this.categoriesNatureMm.computeIfAbsent(nat.getCodeMM(), i -> new ArrayList()).add(rs.getString("code_categorie"));
                    this.categoriesNature.put(nat.getCode(), rs.getString("code_categorie"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        Log.debug("chargerNatures => foreach(nature) ({}) -- " + natures.size());
        for (Nature nature : natures) {
            Log.debug("loop(nature)");
            Log.debug("\tcharcherChampsCommuns");
            List<Champ> champsCommuns = this.chargerChampsCommuns(connection, nature);
            Log.debug("\tcharcherChampsNature");
            List<Champ> champsNature = this.chargerChampsNature(connection, nature);
            ArrayList<Champ> champs = new ArrayList<Champ>(champsCommuns.size() + champsNature.size());
            LinkedHashMap<String, Champ> mapChamps = new LinkedHashMap<String, Champ>();
            for (Champ c : champsCommuns) {
                mapChamps.put(c.getNom(), c);
            }
            for (Champ c : champsNature) {
                mapChamps.put(c.getNom(), c);
            }
            for (Champ c : mapChamps.values()) {
                champs.add(c);
            }
            nature.setChamps(champs);
            if (nature.getDescription() == null || nature.getLocalisation() == null) {
                throw new PrismBddConfigurationError("les champs description et localisation sont obligatoires / nature " + nature.getCode());
            }
            Log.debug("ReferentielDAOJDBC -- \tverifierRestrictionNature");
            this.verifierRestrictionsNature(nature);
        }
        return natures;
    }

    @Override
    public Map<Integer, List<String>> getListeCategoriesNatureMm() {
        return this.categoriesNatureMm;
    }

    @Override
    public Map<String, String> getListeCategoriesNature() {
        return this.categoriesNature;
    }

    private void verifierRestrictionsNature(Nature n) {
        Map map = MetierCommun.getChamps((List)n.getChamps());
        ArrayList<String> erreurs = new ArrayList<String>();
        for (Champ c : map.values()) {
            if (GLS.estVide((List)c.getRestrictions())) continue;
            for (Restriction r : c.getRestrictions()) {
                Log.debug("[Restriction analyse]" + r);
                if (r instanceof RestrictionProfil) continue;
                if (!map.containsKey(r.getNomChamp())) {
                    String erreur = "ERREUR de configuration \u00e9v\u00e8nement champ restriction inconnu - " + n.getLabel() + " > " + c.getNom() + " > " + r.getNomChamp() + " n'existe pas";
                    Log.error(erreur);
                    erreurs.add(erreur);
                    continue;
                }
                Champ champRestriction = (Champ)map.get(r.getNomChamp());
                erreurs.addAll(this.verifierTypeRestriction(r, champRestriction, c, n));
            }
        }
        if (!GLS.estVide(erreurs)) {
            throw new PrismBddConfigurationError("\n".concat(GLS.getString(erreurs, (String)"\n")));
        }
    }

    private List<String> verifierTypeRestriction(Restriction r, Champ cr, Champ c, Nature n) {
        ArrayList<String> erreurs = new ArrayList<String>();
        if (cr != null && r != null) {
            if (r instanceof RestrictionChoixUnique && !(cr.getValeurChamp() instanceof ValeurChampCollectionChoixUnique)) {
                String erreur = "ERREUR de configuration \u00e9v\u00e8nement type restriction choixunique erron\u00e9e - Nature " + n.getCode() + " > Champ " + c.getNom() + " > Restriction " + cr.getNom();
                Log.error(erreur);
                erreurs.add(erreur);
            } else if (r instanceof RestrictionMultiCheckBox && !(cr.getValeurChamp() instanceof ValeurChampMultiCheckBox)) {
                String erreur = "ERREUR de configuration \u00e9v\u00e8nement type restriction choixMultiple erron\u00e9e - Nature " + n.getCode() + " > Champ " + c.getNom() + " > Restriction " + cr.getNom();
                Log.error(erreur);
                erreurs.add(erreur);
            } else if (r instanceof RestrictionLocalisation && !GLS.egal((String)cr.getNom(), (String)"localisation")) {
                String erreur = "ERREUR de configuration \u00e9v\u00e8nement type restriction localisation erron\u00e9e - Nature " + n.getCode() + " > Champ " + c.getNom() + " > Restriction " + cr.getNom();
                Log.error(erreur);
                erreurs.add(erreur);
            }
        }
        return erreurs;
    }

    private List<Champ> chargerChampsCommuns(Connection connection, Nature nature) throws DAOException {
        ArrayList<Champ> champs = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                Log.debug("chargerChampsCommuns => prepareStatement");
                pstm = connection.prepareStatement(SQL_CHAMPSCOMMUNS);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(2, nature.getCodeMM());
                Log.debug("chargerChampsCommuns => executeQuery");
                rs = pstm.executeQuery();
                champs = new ArrayList<Champ>();
                Log.debug("chargerChampsCommuns => parse ResultSet");
                while (rs.next()) {
                    Log.debug("\tlireChamp");
                    Champ champ = this.lireChamp(connection, nature, rs);
                    Log.debug("\tlireChamp OK (null? {}) -- " + champ == null);
                    if (champ == null) continue;
                    champs.add(champ);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return champs;
    }

    private void chargerVoiesLocalisation(Connection connection) throws DAOException {
        block9: {
            PreparedStatement pstm = null;
            ResultSet rs = null;
            ArrayList<InfoVoieLocalisation> l = new ArrayList<InfoVoieLocalisation>();
            this.voies = new HashMap<String, Voie>();
            try {
                try {
                    pstm = connection.prepareStatement(SQL_LISTE_VOIES_LOCALISATION);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        String libelle = rs.getString("libelle");
                        boolean pr = rs.getBoolean("pr");
                        boolean alertc = rs.getBoolean("alertc");
                        boolean adresse = rs.getBoolean("adresse");
                        InfoVoieLocalisation v = new InfoVoieLocalisation(libelle, GLS.getTableauString((String)rs.getString("couches_principales")), GLS.getTableauString((String)rs.getString("couches_secondaires")), alertc, pr, adresse);
                        l.add(v);
                        this.voies.put(libelle, new Voie(libelle, alertc, pr, adresse, v.getCouchesPrincipales(), v.getCouchesSecondaires()));
                    }
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(null, pstm, rs);
                    LocalisationInfo.initialiserVoiesLocalisation(l);
                    if (this.voies.isEmpty()) {
                        this.voies.put("ROUTE", ConstantesPrismCommun.VOIE_DEFAUT);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(null, pstm, rs);
                LocalisationInfo.initialiserVoiesLocalisation(l);
                if (this.voies.isEmpty()) {
                    this.voies.put("ROUTE", ConstantesPrismCommun.VOIE_DEFAUT);
                }
                throw throwable;
            }
            DAOUtil.close(null, pstm, rs);
            LocalisationInfo.initialiserVoiesLocalisation(l);
            if (this.voies.isEmpty()) {
                this.voies.put("ROUTE", ConstantesPrismCommun.VOIE_DEFAUT);
            }
        }
    }

    private List<TypeUtilisateur> chargerTypesUtilisateur() throws DAOException {
        ArrayList<TypeUtilisateur> types = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TYPES_UTILISATEUR);
                rs = pstm.executeQuery();
                types = new ArrayList<TypeUtilisateur>();
                while (rs.next()) {
                    TypeUtilisateur type = new TypeUtilisateur();
                    type.setCode(rs.getInt("type"));
                    type.setLibelle(rs.getString("libelle"));
                    types.add(type);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return types;
    }

    private List<Champ> chargerChampsNature(Connection connection, Nature nature) throws DAOException {
        ArrayList<Champ> champs = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_CHAMPSNATURE);
                pstm.setString(1, nature.getCode());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                champs = new ArrayList<Champ>();
                while (rs.next()) {
                    Champ champ = this.lireChamp(connection, nature, rs);
                    if (champ == null) continue;
                    champs.add(champ);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return champs;
    }

    private Champ lireChamp(Connection connection, Nature nature, ResultSet rs) throws SQLException {
        int style;
        String type = rs.getString("type");
        String[] nom = rs.getString("nom");
        String definition = rs.getString("redif");
        try {
            style = rs.getInt("style");
        }
        catch (Exception e) {
            style = 0;
        }
        if (definition == null) {
            definition = rs.getString("definition");
        }
        int hauteur = rs.getInt("hauteur");
        String restrictions = rs.getString("reres");
        if (restrictions == null) {
            restrictions = rs.getString("restrictions");
        }
        String defaut = rs.getString("defaut");
        ChampImages c = null;
        block25 : switch (type) {
            case "GLSTextBox": {
                ChampTexte champTexte = new ChampTexte((String)nom);
                MapDescription m = MapDescription.parse((String)definition);
                if (m.containsKey("type")) {
                    champTexte.setType(m.getString("type", "texte"));
                }
                c = champTexte;
                if (m.containsKey("valeur")) {
                    champTexte.setValeur(m.getString("valeur", ""));
                    break;
                }
                champTexte.setValeur(defaut == null ? "" : defaut);
                break;
            }
            case "GLSRadioBox": {
                ChampRadioBouton champRadioBouton = new ChampRadioBouton((String)nom);
                List valeurs = MetierCommun.getListe((String)definition);
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("les valeurs ne peuvent \u00eatre vides pour le composant " + (String)nom);
                }
                champRadioBouton.setValeurs(valeurs);
                if (defaut == null) {
                    champRadioBouton.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champRadioBouton.getValeurChamp()).setValeur((String)valeurs.get(0));
                } else {
                    champRadioBouton.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champRadioBouton.getValeurChamp()).setValeur(defaut);
                }
                c = champRadioBouton;
                break;
            }
            case "GLSImageMultiple": {
                ChampChoixImageMultiple champImageMulti = new ChampChoixImageMultiple((String)nom);
                MapDescription def = MapDescription.parse((String)definition);
                champImageMulti.setNcValeur(null);
                champImageMulti.setValeursSelectionnee(new ArrayList(0));
                champImageMulti.setHauteurImage(def.getInt("hauteur", 50));
                champImageMulti.setLargeurImage(def.getInt("largeur", 50));
                champImageMulti.setAutreLabel(null);
                List<String> valeurs = def.getList("valeurs");
                if (ChampChoixImageMultiple.estDynamique((List)valeurs)) {
                    valeurs = this.iconDal.getListeNomsImage((String)nom, null);
                }
                champImageMulti.setAfficheLibelle(def.getBoolean("afficheLibelle", false));
                champImageMulti.setValeurs(valeurs);
                c = champImageMulti;
                break;
            }
            case "GLSImageComboBox": {
                ChampChoixImage champChoixImage = new ChampChoixImage((String)nom);
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length < 2) {
                    throw new PrismBddConfigurationError("La configuration d'un composant choix image doit \u00eatre compos\u00e9e d'au moins deux parties s\u00e9par\u00e9es par ':' " + (String)nom);
                }
                List<String> valeurs = MetierCommun.getListe((String)definitionSplit[1]);
                Log.debug("Composant " + (String)nom);
                if (ChampChoixImage.estDynamique((List)valeurs)) {
                    valeurs = this.iconDal.getListeNomsImage((String)nom, definitionSplit[0]);
                }
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("La configuration d'un composant choix image doit au moins avoir une valeur " + (String)nom);
                }
                int indiceAutre = valeurs.indexOf(definitionSplit[0]);
                if (definitionSplit.length > 2) {
                    champChoixImage.setHauteurImage(GLS.getInt((String)definitionSplit[2], (int)50));
                } else {
                    champChoixImage.setHauteurImage(50);
                }
                champChoixImage.setIndiceAutreChoix(indiceAutre);
                champChoixImage.setValeurs(valeurs);
                if (defaut == null) {
                    champChoixImage.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champChoixImage.getValeurChamp()).setValeur(valeurs.get(0));
                } else {
                    champChoixImage.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champChoixImage.getValeurChamp()).setValeur(defaut);
                }
                c = champChoixImage;
                break;
            }
            case "GLSComboBox": {
                ChampDropListe champDropListe = new ChampDropListe((String)nom);
                boolean valeursSystemes = MetierCommun.estValeurSysteme((String)definition);
                if (valeursSystemes) {
                    champDropListe.setValeursSystemes(definition);
                } else {
                    champDropListe.setValeursSystemes(null);
                }
                List valeurs = MetierCommun.getListe((String)definition);
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("les valeurs ne peuvent \u00eatre vides pour le composant " + (String)nom);
                }
                champDropListe.setValeurs(valeurs);
                if (defaut == null) {
                    champDropListe.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur((String)valeurs.get(0));
                } else if (valeursSystemes) {
                    champDropListe.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur("");
                } else {
                    champDropListe.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur(defaut);
                }
                c = champDropListe;
                break;
            }
            case "ComposantChoix": {
                ChampDropListe champDropListe = new ChampDropListe((String)nom);
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length != 2) {
                    throw new PrismBddConfigurationError("La configuration d'un composant choix doit etre compos\u00e9e de deux parties s\u00e9par\u00e9es par ':' " + (String)nom);
                }
                List valeurs = MetierCommun.getListe((String)definitionSplit[1]);
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("les valeurs ne peuvent \u00ef\u00bf\u00bdtre vides pour le composant " + (String)nom);
                }
                int indiceAutre = valeurs.indexOf(definitionSplit[0]);
                champDropListe.setIndiceAutreChoix(indiceAutre);
                champDropListe.setValeurs(valeurs);
                if (defaut == null) {
                    champDropListe.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur((String)valeurs.get(0));
                } else {
                    champDropListe.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur(defaut);
                }
                c = champDropListe;
                break;
            }
            case "GLSIntBox": {
                ChampEntier champEntier = new ChampEntier((String)nom);
                MapDescription description = MapDescription.parse((String)definition);
                champEntier.setCheckbox(description.getBoolean("desactivable", false));
                champEntier.setValeurMin(description.getInt("min", 0));
                champEntier.setValeurMax(description.getInt("max", 1000));
                champEntier.setPas(description.getInt("pas", 1));
                if (defaut != null) {
                    champEntier.setValeur(GLS.getInt((String)defaut, (int)0));
                } else {
                    champEntier.setValeur(champEntier.getValeurMin());
                }
                c = champEntier;
                break;
            }
            case "GLSDecimalBox": {
                ChampDecimal champDecimal = new ChampDecimal((String)nom);
                MapDescription description = MapDescription.parse((String)definition);
                champDecimal.setCheckbox(description.getBoolean("desactivable", false));
                champDecimal.setValeurMin(description.getDouble("min", 0.0));
                champDecimal.setValeurMax(description.getDouble("max", 1000.0));
                champDecimal.setPas(description.getDouble("pas", 1.0));
                if (defaut != null) {
                    champDecimal.setValeur(GLS.getDouble((String)defaut, (double)0.0));
                }
                c = champDecimal;
                break;
            }
            case "GLSCheckBox": {
                ChampVraiFaux champVraiFaux = new ChampVraiFaux((String)nom);
                champVraiFaux.setValeur(false);
                c = champVraiFaux;
                break;
            }
            case "GLSMultiCheckBoxNC": {
                ChampMultiCheckBox champMultiCheckBox = new ChampMultiCheckBox((String)nom);
                champMultiCheckBox.setNcValeur(GLS.estVide((String)defaut) ? "NC" : defaut);
                champMultiCheckBox.setValeursSelectionnee(MetierCommun.getListe((String)champMultiCheckBox.getNcValeur()));
                champMultiCheckBox.setNcSelectionne(true);
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length > 1) {
                    champMultiCheckBox.setAutreLabel(definitionSplit[0]);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definitionSplit[1]));
                } else {
                    champMultiCheckBox.setAutreLabel(null);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definition));
                }
                c = champMultiCheckBox;
                break;
            }
            case "GLSMultiCheckBox": {
                ChampMultiCheckBox champMultiCheckBox = new ChampMultiCheckBox((String)nom);
                champMultiCheckBox.setNcValeur(null);
                List valeursParDefaut = MetierCommun.getListe((String)defaut, (String)";", new ArrayList(0));
                champMultiCheckBox.setValeursSelectionnee(valeursParDefaut);
                String[] definitionSplit = definition.split(":");
                if (MetierCommun.estValeurSysteme((String)definition)) {
                    champMultiCheckBox.setValeursSystemes(definition);
                } else {
                    champMultiCheckBox.setValeursSystemes(null);
                }
                if (definitionSplit.length > 1) {
                    champMultiCheckBox.setAutreLabel(definitionSplit[0]);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definitionSplit[1]));
                } else {
                    champMultiCheckBox.setAutreLabel(null);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definition));
                }
                c = champMultiCheckBox;
                break;
            }
            case "ComposantProcedurePatrouille": {
                MapDescription description = MapDescription.parse((String)definition);
                ChampPatrouilleProcedure champPP = new ChampPatrouilleProcedure((String)nom);
                champPP.setCompetences(MetierCommun.getListe((String)description.getString("competences", null)));
                champPP.setMesuresImmediate(MetierCommun.getListe((String)description.getString("mesuresPrisesReparation", null)));
                champPP.setMesureDifferee(MetierCommun.getListe((String)description.getString("mesuresPrisesSecurite", null)));
                champPP.setCompetenceCg(defaut);
                c = champPP;
                break;
            }
            case "ComposantVehiculesEnCause": {
                ChampVehiculeEnCause champVehiculeEnCause = new ChampVehiculeEnCause((String)nom);
                List valeurs = MetierCommun.getListe((String)definition);
                champVehiculeEnCause.setDisplayVl(valeurs.contains("vl"));
                champVehiculeEnCause.setDisplayPl(valeurs.contains("pl"));
                champVehiculeEnCause.setDisplayTmd(valeurs.contains("tmd"));
                champVehiculeEnCause.setDisplayVelo(valeurs.contains("velo"));
                champVehiculeEnCause.setDisplayMoto(valeurs.contains("moto"));
                champVehiculeEnCause.setDisplayScooter(valeurs.contains("scooter"));
                champVehiculeEnCause.setDisplayVtc(valeurs.contains("tc"));
                champVehiculeEnCause.setDisplayAutres(valeurs.contains("autres"));
                champVehiculeEnCause.setDisplayCampingCar(valeurs.contains("campingCar"));
                champVehiculeEnCause.setDisplayPietonCycle(valeurs.contains("pietonCycle"));
                champVehiculeEnCause.setDisplayDeuxRoues(valeurs.contains("deuxRoues"));
                champVehiculeEnCause.setDisplayCaravane(valeurs.contains("caravane"));
                champVehiculeEnCause.setDisplayTrain(valeurs.contains("train"));
                champVehiculeEnCause.setDisplayTramway(valeurs.contains("tramway"));
                champVehiculeEnCause.setDisplayEnginAgricole(valeurs.contains("enginAgricole"));
                champVehiculeEnCause.setDisplayAnimaux(valeurs.contains("animaux"));
                champVehiculeEnCause.setDisplayAutres(valeurs.contains("autres"));
                c = champVehiculeEnCause;
                break;
            }
            case "ComposantPrismAuto": {
                ChampMultiple champMultiple = new ChampMultiple((String)nom);
                List<Champ> champs = this.getSousChamps(connection, nature, (String)nom);
                champMultiple.setChamps(champs);
                c = champMultiple;
                break;
            }
            case "ComposantAlternat": {
                ChampAlternat champAlternat = new ChampAlternat((String)nom);
                List<Champ> champs = this.getSousChamps(connection, nature, (String)nom);
                if (champs.size() != 2) {
                    throw new PrismBddConfigurationError("Un champ alternat doit poss\u00e9der deux sous champs alternat-description et alternat-etat");
                }
                ChampRadioBouton alternatEtat = (ChampRadioBouton)champs.get(0);
                ChampRadioBouton alternatDescription = (ChampRadioBouton)champs.get(1);
                champAlternat.setDescriptions(alternatDescription.getValeurs());
                champAlternat.setEtatFauxLibele((String)alternatEtat.getValeurs().get(0));
                champAlternat.setEtatVraiLibele((String)alternatEtat.getValeurs().get(1));
                champAlternat.setDescriptionSelectionne("Aucun");
                champAlternat.setVraiSelectionne(false);
                c = champAlternat;
                break;
            }
            case "GLSCalendarBox": {
                MapDescription map;
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length == 1) {
                    map = MapDescription.newMap();
                    map.addValue("type=" + definition);
                    map.addValue("obligatoire=false");
                } else {
                    map = MapDescription.parse((String)definition);
                }
                switch (map.getString("type", "dateHeure")) {
                    case "dateHeure": 
                    case "0": {
                        ChampDateHeure champCalendrier = new ChampDateHeure((String)nom);
                        champCalendrier.setAfficheCheckBox(!map.getBoolean("obligatoire", false));
                        c = champCalendrier;
                        break block25;
                    }
                    case "1": 
                    case "date": {
                        c = new ChampDate((String)nom);
                        break block25;
                    }
                    case "2": 
                    case "heure": {
                        c = new ChampHeure((String)nom);
                        break block25;
                    }
                }
                throw new PrismBddConfigurationError("la description doit \u00eatre 0, 1 ou 2");
            }
            case "systeme": {
                String[] definitionSplit = nom;
                int n = -1;
                switch (nom.hashCode()) {
                    case -1724546052: {
                        if (definitionSplit.equals("description")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1012409792: {
                        if (definitionSplit.equals("localisation")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1626464000: {
                        if (definitionSplit.equals("localisation-definition")) {
                            n = 3;
                        }
                        break;
                    }
                    case 2103924538: {
                        if (definitionSplit.equals("commentaire")) {
                            n = 4;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        MapDescription mapDef = MapDescription.parse((String)definition);
                        ChampLocalisation champLocalisation = new ChampLocalisation();
                        champLocalisation.setPrDebut(-1);
                        champLocalisation.setPrFin(-1);
                        champLocalisation.setAbsPrDebut(-1);
                        champLocalisation.setAbsPrFin(-1);
                        champLocalisation.setX(new float[0]);
                        champLocalisation.setY(new float[0]);
                        champLocalisation.setSensPr(1);
                        champLocalisation.setLocalisationParGps(true);
                        champLocalisation.setVoies(this.convertVoies(connection, mapDef.getList("liste-voies")));
                        champLocalisation.setVoie(mapDef.getString("voie-defaut", ""));
                        champLocalisation.setDepartements(mapDef.getList("liste-dpts"));
                        if (mapDef.containsKey("type")) {
                            champLocalisation.setType(mapDef.getString("type", "lin\u00e9aire"));
                        } else {
                            champLocalisation.setType("lin\u00e9aire");
                        }
                        if (mapDef.containsKey("accrochage")) {
                            champLocalisation.setAccrochages(mapDef.getList("accrochage"));
                            champLocalisation.setAccrochage(Boolean.parseBoolean(mapDef.getString("accrochage-defaut", "true")));
                        }
                        if (mapDef.containsKey("afficher-sens")) {
                            champLocalisation.setAffichageSens(Boolean.parseBoolean(mapDef.getString("afficher-sens", "false")));
                        } else {
                            champLocalisation.setAffichageSens(Boolean.parseBoolean("false"));
                        }
                        if (mapDef.containsKey("caracteristiques")) {
                            champLocalisation.setCaracteristiques(mapDef.getList("caracteristiques"));
                        }
                        c = champLocalisation;
                        nature.setLocalisation(champLocalisation);
                        break block25;
                    }
                    case 4: {
                        ChampTexte champCommentaire = new ChampTexte((String)nom);
                        champCommentaire.setValeur(defaut);
                        c = champCommentaire;
                        break block25;
                    }
                    case 1: {
                        ChampDropListe champDescription = new ChampDropListe((String)nom);
                        List<String> valeurs = this.getDescriptionsNature(connection, nature);
                        champDescription.setValeurs(valeurs);
                        if (GLS.estVide(valeurs)) {
                            throw new PrismBddConfigurationError("les valeurs ne peuvent \u00eatre vides pour la description " + (String)nom);
                        }
                        champDescription.setIndexSelectionnee(0);
                        ((ValeurChampCollectionChoixUnique)champDescription.getValeurChamp()).setValeur(valeurs.get(0));
                        c = champDescription;
                        nature.setDescription(champDescription);
                        break block25;
                    }
                    case 3: {
                        if (nature.getLocalisation() != null) {
                            MapDescription mapDef = MapDescription.parse((String)definition);
                            if (mapDef.containsKey("liste-voies")) {
                                nature.getLocalisation().setVoies(this.convertVoies(connection, mapDef.getList("liste-voies")));
                            }
                            if (mapDef.containsKey("voie-defaut")) {
                                nature.getLocalisation().setVoie(mapDef.getString("voie-defaut", ""));
                            }
                            if (mapDef.containsKey("type")) {
                                nature.getLocalisation().setType(mapDef.getString("type", "lin\u00e9aire"));
                            }
                            if (mapDef.containsKey("accrochage")) {
                                nature.getLocalisation().setAccrochages(mapDef.getList("accrochage"));
                            }
                            if (mapDef.containsKey("accrochage-defaut")) {
                                nature.getLocalisation().setAccrochage(Boolean.parseBoolean(mapDef.getString("accrochage-defaut", "true")));
                            }
                            if (mapDef.containsKey("caracteristiques")) {
                                nature.getLocalisation().setCaracteristiques(mapDef.getList("caracteristiques"));
                            }
                            if (!GLS.estVide((String)restrictions)) {
                                nature.getLocalisation().setRestrictions(RestrictionFactory.getRestrictions(restrictions));
                            }
                        }
                        c = null;
                        break block25;
                    }
                }
                Log.debug("Champ syst\u00e8me non g\u00e9r\u00e9 : " + (String)nom);
                break;
            }
            case "GLSCoucheBox": {
                ChampCoucheBox champCoucheBox = new ChampCoucheBox((String)nom);
                MapDescription description = MapDescription.parse((String)definition);
                champCoucheBox.setNomCouche(description.getString("nomCouche", null));
                champCoucheBox.setChampCouche(description.getInt("champCouche", -1));
                champCoucheBox.setDistanceRecherche(description.getDouble("distanceRecherche", 500.0));
                c = champCoucheBox;
                break;
            }
            case "ComposantImages": {
                ChampImages champImages;
                c = champImages = new ChampImages((String)nom);
                break;
            }
            case "ComposantSignature": {
                ChampSignature champSignature = new ChampSignature((String)nom);
                c = champSignature;
                break;
            }
            case "ComposantDocuments": {
                ChampDocuments champDocuments = new ChampDocuments((String)nom);
                c = champDocuments;
                break;
            }
            case "GLSOneDriveFolderBox": {
                ChampOneDrive champOneDrive = new ChampOneDrive((String)nom);
                c = champOneDrive;
                break;
            }
            default: {
                throw new PrismBddConfigurationError("Type de champ non g\u00e9r\u00e9 : " + type);
            }
        }
        if (c != null) {
            c.setLibelle(rs.getString("libelle"));
            c.setRestrictions(RestrictionFactory.getRestrictions(restrictions));
            c.setOnglet(rs.getString("nom_onglet"));
            c.setStyle(style);
            c.setHauteur(hauteur);
            if (this.correspondanceComposantChamp == null) {
                this.correspondanceComposantChamp = new HashMap<String, String>();
            }
            this.correspondanceComposantChamp.put(c.getNom(), type);
        } else if (type != "systeme") {
            Log.debug("champ non g\u00e9r\u00e9 : " + (String)nom + " de type " + type);
        } else {
            Log.info("champ syst\u00e8me : " + (String)nom + " de type " + type);
        }
        ComposantBean cb = new ComposantBean();
        cb.setNom((String)nom);
        cb.setType(type);
        cb.setLibelle(rs.getString("libelle"));
        cb.setDefinition(definition);
        cb.setChamp((ChampAbstrait)c);
        if (this.listeComposantsUtilises == null) {
            this.listeComposantsUtilises = new HashMap<String, ComposantBean>();
        }
        this.listeComposantsUtilises.put(cb.getNom(), cb);
        return c;
    }

    private List<Voie> convertVoies(Connection connection, List<String> voies) {
        ArrayList<Voie> l = new ArrayList<Voie>();
        if (!GLS.estVide(voies)) {
            for (String v : voies) {
                l.add(this.getVoies(connection).get(v));
            }
        } else {
            l.add(ConstantesPrismCommun.VOIE_DEFAUT);
        }
        return l;
    }

    private List<String> getDescriptionsNature(Connection connection, Nature nature) throws DAOException {
        ArrayList<String> descriptions = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_DESCRIPTIONNATURE);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, nature.getCode());
                rs = pstm.executeQuery();
                descriptions = new ArrayList<String>();
                while (rs.next()) {
                    descriptions.add(rs.getString("libelle"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return descriptions;
    }

    @Override
    public void miseAJourOrdreNature(List<Nature> natures) {
        Connection connection = null;
        PreparedStatement pstm = null;
        TreeMap<Integer, Nature> naturesTriees = new TreeMap<Integer, Nature>();
        boolean errNature = false;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String requete = "update prism.nature_perso set indice = ? where code = ?";
                pstm = connection.prepareStatement(requete);
                for (Nature n : natures) {
                    pstm.setInt(1, n.getIndice());
                    pstm.setString(2, n.getCode());
                    pstm.execute();
                    pstm.clearParameters();
                    Nature natureRef = this.getNatureMap().get(n.getCode());
                    if (natureRef != null) {
                        natureRef.setIndice(n.getIndice());
                        naturesTriees.put(n.getIndice(), natureRef);
                        continue;
                    }
                    errNature = true;
                }
                this.natures = new ArrayList(naturesTriees.values());
            }
            catch (SQLException e) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (errNature) {
            this.natures = null;
        }
    }

    private List<DescriptionNature> getDescriptionsNatureComplet(Connection connection, Nature nature) throws DAOException {
        ArrayList<DescriptionNature> descriptions = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_DESCRIPTIONNATURECOMPLET);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, nature.getCode());
                rs = pstm.executeQuery();
                descriptions = new ArrayList<DescriptionNature>();
                while (rs.next()) {
                    DescriptionNature d = new DescriptionNature();
                    d.setCode(rs.getString("code"));
                    d.setLibelle(rs.getString("libelle"));
                    d.setIndice(rs.getInt("indice"));
                    descriptions.add(d);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return descriptions;
    }

    private List<Champ> getSousChamps(Connection connection, Nature nature, String nomParent) throws DAOException {
        ArrayList<Champ> champs = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_SOUSCHAMPS);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, nomParent);
                rs = pstm.executeQuery();
                champs = new ArrayList<Champ>();
                while (rs.next()) {
                    Champ champ = this.lireChamp(connection, nature, rs);
                    if (champ == null) continue;
                    champs.add(champ);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return champs;
    }

    @Override
    public List<Tunnel> getTunnels() {
        if (this.tunnels == null) {
            this.tunnels = this.chargerTunnels();
        }
        return this.tunnels;
    }

    @Override
    public List<TypeUtilisateur> getTypesUtilisateur() {
        if (this.typesUtilisateur == null) {
            this.typesUtilisateur = this.chargerTypesUtilisateur();
        }
        return this.typesUtilisateur;
    }

    @Override
    public List<ParametrePatrouille> getParametresPatrouille() {
        if (this.parametrePatrouille == null) {
            this.parametrePatrouille = this.chargerParametresPatrouille();
        }
        return this.parametrePatrouille;
    }

    @Override
    public Map<String, Map<String, List<PrismAction>>> getListePrismActions() {
        if (this.listePrismActions == null) {
            this.listePrismActions = this.chargerPrismActions();
        }
        return this.listePrismActions;
    }

    @Override
    public List<PrismAction> getPrismActions(String type, Evenement e) {
        if (this.getListePrismActions() != null && e != null && e.getValeurNature() != null) {
            List<DescriptionNature> listeDesc;
            int iDesc;
            Log.debug("[CODE NAT TRAVAUX] " + type + " - " + e.getValeurNature().getCode());
            if (this.listePrismActions.containsKey(type) && (iDesc = MetierCommun.getIndiceObjetListe(listeDesc = this.descNatMap.get(e.getValeurNature().getCode()), (Object)e.getValeurNature().getDescription().getValeur())) > -1) {
                IDescription desc = (IDescription)listeDesc.get(iDesc);
                String codeDescription = desc.getCode();
                Log.debug("[CODE NAT TRAVAUX] " + e.getCodeEvenement() + " -- " + codeDescription);
                return this.listePrismActions.get(type).get(codeDescription);
            }
        }
        return null;
    }

    private Map<String, Map<String, List<PrismAction>>> chargerPrismActions() {
        block9: {
            this.listePrismActions = null;
            this.listePrismActions = new HashMap<String, Map<String, List<PrismAction>>>();
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(SQL_PRISM_ACTION);
                    Log.debug("[REQ ACTIONS PRISM ACTIONS] " + pstm);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        PrismAction c = new PrismAction();
                        c.setDeclencheur(rs.getString("declencheur"));
                        c.setParametreDeclencheur(rs.getString("parametre_declencheur"));
                        c.setTypeDeclencheur(rs.getString("type_declencheur"));
                        c.setDeclenchement(rs.getString("declenchement"));
                        c.setParametreDeclenchement(rs.getString("parametre_declenchement"));
                        c.setTypeDeclenchement(rs.getString("type_declenchement"));
                        c.setParametres(rs.getString("parametres"));
                        c.setType(rs.getString("type"));
                        c.setAction(rs.getString("action"));
                        Map<String, List<PrismAction>> l = this.listePrismActions.get(c.getType());
                        String declencheur = c.getDeclencheur();
                        if (l == null) {
                            l = new HashMap<String, List<PrismAction>>();
                            l.put(declencheur, new ArrayList());
                            this.listePrismActions.put(c.getType(), l);
                        } else if (!l.containsKey(declencheur)) {
                            l.put(declencheur, new ArrayList());
                        }
                        l.get(declencheur).add(c);
                    }
                }
                catch (Exception ex) {
                    Log.error("[PRISM ACTIONS] ERREUR PRISM ACTIONS ", ex);
                    DAOUtil.close(connection, pstm, rs);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        Log.debug("[PRISM ACTIONS] " + this.listePrismActions + " -- " + this.listePrismActions.size());
        return this.listePrismActions;
    }

    private List<ParametrePatrouille> chargerParametresPatrouille() {
        ArrayList<ParametrePatrouille> parametresPatrouille = new ArrayList<ParametrePatrouille>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_PARAMETRE_PATROUILLE);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ParametrePatrouille pp = new ParametrePatrouille();
                    pp.setNom(rs.getString("nom"));
                    pp.setLibelle(rs.getString("libelle"));
                    pp.setModule(rs.getInt("mm"));
                    pp.setTypeSaisie(ParametrePatrouille.TypeSaisie.valueOf((int)rs.getInt("type_saisie")));
                    pp.setTypeChamp(ParametrePatrouille.TypeChamp.valueOf((int)rs.getInt("type_champ")));
                    pp.setDefinition(rs.getString("definition"));
                    pp.setDescription(rs.getString("description"));
                    parametresPatrouille.add(pp);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return parametresPatrouille;
    }

    private List<Tunnel> chargerTunnels() {
        ArrayList<Tunnel> tunnels = new ArrayList<Tunnel>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TUNNELS);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Tunnel t = new Tunnel();
                    t.setId(rs.getInt("id"));
                    t.setLibelle(rs.getString("libelle"));
                    t.setTubes(this.chargerTubes(t));
                    tunnels.add(t);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return tunnels;
    }

    private List<Tube> chargerTubes(Tunnel t) {
        ArrayList<Tube> tubes = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TUBES);
                pstm.setInt(1, t.getId());
                rs = pstm.executeQuery();
                tubes = new ArrayList<Tube>();
                while (rs.next()) {
                    Tube tube = new Tube();
                    tube.setId(rs.getInt("id"));
                    tube.setLibelle(rs.getString("libelle"));
                    tube.setSens(rs.getInt("sens"));
                    tube.setPp(this.chargerPointsParticuliers(tube));
                    tubes.add(tube);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return tubes;
    }

    private List<PointParticulier> chargerPointsParticuliers(Tube t) {
        ArrayList<PointParticulier> pps = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String classement = this.configuration.getString("tunnel.pp.classement", "Libelle");
                if (!GLS.estVide((String)classement)) {
                    classement = " ORDER BY " + classement;
                }
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_PP_TUNNEL.concat(classement));
                pstm.setInt(1, t.getId());
                rs = pstm.executeQuery();
                pps = new ArrayList<PointParticulier>();
                while (rs.next()) {
                    PointParticulier pp = new PointParticulier();
                    pp.setId(rs.getInt("id"));
                    pp.setLibelle(rs.getString("libelle"));
                    pp.setAxe(rs.getString("axe"));
                    pp.setPr(rs.getString("pr"));
                    pp.setTube(rs.getInt("tube"));
                    pp.setTunnel(rs.getInt("tunnel"));
                    pp.setLibelleType(rs.getString("libelle_type"));
                    PGgeometry point = (PGgeometry)rs.getObject("coordonnees");
                    org.postgis.Point p1 = (org.postgis.Point)point.getGeometry();
                    Point p = new Point((float)p1.getX(), (float)p1.getY());
                    pp.setCoordonnees(p);
                    pps.add(pp);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    private List<RaccourciNature> chargerRaccourcis(Connection connection) throws DAOException {
        ArrayList<RaccourciNature> raccourcis = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_RACCOURCIS);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                raccourcis = new ArrayList<RaccourciNature>();
                while (rs.next()) {
                    RaccourciNature raccourci = new RaccourciNature();
                    raccourci.setIndexDescription(rs.getInt("indice"));
                    raccourci.setLabel(rs.getString("libelle"));
                    raccourci.setNature(this.natureMap.get(rs.getString("nature")));
                    raccourci.setCode(rs.getString("code"));
                    raccourci.setIcone(rs.getString("icone"));
                    raccourcis.add(raccourci);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return raccourcis;
    }

    @Override
    public List<Onglet> getOngletsChamps() {
        if (this.onglets == null) {
            try {
                this.onglets = this.chargerOngletsChamps();
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la liste des onglets", e);
            }
        }
        return this.onglets;
    }

    private List<Onglet> chargerOngletsChamps() throws DAOException {
        ArrayList<Onglet> onglets = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_ONGLETSCHAMP);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                onglets = new ArrayList<Onglet>();
                while (rs.next()) {
                    Onglet onglet = new Onglet();
                    onglet.setNom(rs.getString("nom"));
                    onglet.setLibelle(rs.getString("libelle"));
                    onglets.add(onglet);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return onglets;
    }

    private void chargerConfiguration() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String requete = "SELECT * FROM configuration";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                Extension config = new Extension();
                while (rs.next()) {
                    config.put((Object)rs.getString("champ"), (Object)rs.getString("valeur"));
                }
                this.configuration = config;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    private void chargerDelegations() {
        this.codesCentre = null;
        this.codesCentre = new HashMap<String, String>();
        ArrayList<Delegation> delegations = new ArrayList<Delegation>();
        String requete = "SELECT * FROM  prism.delegation_rattachement where zone =? ORDER BY nom";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Delegation d = new Delegation();
                    d.setNom(rs.getString("nom"));
                    d.setCentres(this.getCentres(d.getNom()));
                    delegations.add(d);
                    d.setBounds(this.readBounds(rs));
                    d.setArchive(rs.getInt("attribution") == 0);
                }
                this.delegations = delegations;
                this.delegationsActives = MetierCommun.getDelegationsActives(delegations);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    private Bounds readBounds(ResultSet rs) throws SQLException {
        Bounds b = new Bounds();
        b.setMaxx(rs.getDouble("box_maxx"));
        if (rs.wasNull()) {
            return null;
        }
        b.setMaxy(rs.getDouble("box_maxy"));
        if (rs.wasNull()) {
            return null;
        }
        b.setMinx(rs.getDouble("box_minx"));
        if (rs.wasNull()) {
            return null;
        }
        b.setMiny(rs.getDouble("box_miny"));
        if (rs.wasNull()) {
            return null;
        }
        return b;
    }

    private ArrayList<Centre> getCentres(String delegation) {
        ArrayList<Centre> centres = new ArrayList<Centre>();
        String requete = "SELECT * FROM prism.centre_rattachement where delegation = ? and zone_routiere = ? ORDER BY nom";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, delegation);
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Centre centre = new Centre();
                    centre.setNom(rs.getString("nom"));
                    centre.setCode(this.getCodeCentre(centre.getNom(), rs));
                    centre.setDelegation(delegation);
                    centre.setArchive(rs.getInt("attribution") == 0);
                    centre.setBounds(this.readBounds(rs));
                    try {
                        centre.setPath(rs.getString("path"));
                        centre.setParent(rs.getString("parent"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    centres.add(centre);
                    this.codesCentre.put(centre.getNom(), centre.getCode());
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return centres;
    }

    private String getCodeCentre(String nom, ResultSet rs) {
        String code;
        try {
            code = rs.getString("code");
        }
        catch (Exception e) {
            Log.error("LA COLONNE CODE DE LA TABLE CENTRE N'EXISTE PAS", e);
            code = null;
        }
        if (code == null) {
            code = this.getCodeCentre(nom);
        }
        return code;
    }

    private String getCodeCentre(String nom) {
        if (!GLS.estVide((String)nom)) {
            if (nom.length() >= 3) {
                return nom.substring(0, 3).toUpperCase();
            }
            return nom.toUpperCase();
        }
        Log.error("erreur generation code centre - verifier tabl centre");
        return "!!!";
    }

    private ArrayList<Centre> getCentresParActivite(String activite) {
        ArrayList<Centre> centres = new ArrayList<Centre>();
        String requete = SQL_ACTIVITES_CENTRE;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, activite);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Centre centre = new Centre();
                    centre.setNom(rs.getString("nom"));
                    centre.setDelegation(rs.getString("delegation"));
                    centre.setArchive(rs.getInt("attribution") == 0);
                    centre.setBounds(this.readBounds(rs));
                    centres.add(centre);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return centres;
    }

    @Override
    public List<PrismCentralUser> rechercheToutUtilisateur() throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Vector<PrismCentralUser> liste = new Vector<PrismCentralUser>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_RECHERCHE_TOUTUTILISATEUR);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PrismCentralUser user = new PrismCentralUser();
                    user.setNom(rs.getString("nom"));
                    user.setCode(rs.getString("sna"));
                    user.setId(rs.getInt("id_utilisateur"));
                    user.setIdProfil(rs.getLong("id_profil"));
                    user.setArchive(rs.getInt("archive") == 1);
                    user.setDelegation(rs.getString("delegation"));
                    user.setCentre(rs.getString("centre"));
                    user.setTelephone(rs.getString("telephone"));
                    user.setMail(rs.getString("mail"));
                    user.setConnectionType(rs.getString("connection_type"));
                    user.setAdminFonctionnel(rs.getBoolean("admin_fonc"));
                    user.setSysteme(GLS.getBoolean((int)rs.getInt("systeme"), (boolean)false));
                    liste.add(user);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrismCentralUser getUtilisateur(String codeUtilisateur) {
        ReferentielDAOJDBC referentielDAOJDBC = this;
        synchronized (referentielDAOJDBC) {
            if (this.utilisateurs == null) {
                List<PrismCentralUser> users = this.rechercheToutUtilisateur();
                this.utilisateurs = new HashMap<String, PrismCentralUser>();
                this.codesUtilisateurs = new HashMap<Integer, PrismCentralUser>();
                for (PrismCentralUser user : users) {
                    this.utilisateurs.put(user.getCode(), user);
                    this.codesUtilisateurs.put(user.getId(), user);
                }
            }
        }
        return this.utilisateurs.get(codeUtilisateur);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrismCentralUser getUtilisateur(int codeUtilisateur) {
        ReferentielDAOJDBC referentielDAOJDBC = this;
        synchronized (referentielDAOJDBC) {
            if (this.codesUtilisateurs == null) {
                List<PrismCentralUser> users = this.rechercheToutUtilisateur();
                this.utilisateurs = new HashMap<String, PrismCentralUser>();
                this.codesUtilisateurs = new HashMap<Integer, PrismCentralUser>();
                for (PrismCentralUser user : users) {
                    this.utilisateurs.put(user.getCode(), user);
                    this.codesUtilisateurs.put(user.getId(), user);
                }
            }
        }
        return this.codesUtilisateurs.get(codeUtilisateur);
    }

    @Override
    public synchronized Map<Integer, ModuleMetier> getModulesMetiers() {
        if (this.modulesMetiers == null) {
            this.chargerModulesMetiers();
        }
        return this.modulesMetiers;
    }

    @Override
    public synchronized Map<String, List<DescriptionNature>> getDescriptionsNatureMap() {
        if (this.natures == null || this.natureMap == null || this.descNatMap == null) {
            try {
                this.chargerNatureEtRaccourcis();
            }
            catch (DAOException e) {
                throw new PrismBddConfigurationError("Erreur lors du chargement de la map des natures", e);
            }
        }
        return this.descNatMap;
    }

    private void chargerModulesMetiers() {
        this.modulesMetiers = new HashMap<Integer, ModuleMetier>();
        this.listeModulesMetiers = new ArrayList<ModuleMetier>();
        this.circuits = new HashMap<String, Circuit>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_MODULES_METIERS);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ModuleMetier mm = new ModuleMetier();
                    mm.setCode(rs.getInt("code"));
                    mm.setNom(rs.getString("nom"));
                    mm.setLibelle(rs.getString("libelle_perso"));
                    mm.setModuleHerite(rs.getInt("module_herite"));
                    mm.setActiviteDeSuivi(rs.getString("activite_suivi"));
                    mm.setCreationEvenementPatrouille(GLS.getBoolean((int)rs.getInt("creation_evenement_patrouille"), (boolean)false));
                    mm.setCircuits(this.chargerCircuits(mm, connection));
                    try {
                        if (rs.getObject("parametres") != null) {
                            mm.setParametres(MapDescription.parse((String)rs.getString("parametres")));
                        } else {
                            mm.setParametres(null);
                        }
                    }
                    catch (Exception ex) {
                        Log.error("!!! ERR COLUMN PARAMETRES MM N'EXISTE PAS !!!", ex);
                    }
                    this.modulesMetiers.put(mm.getCode(), mm);
                    this.listeModulesMetiers.add(mm);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<ModuleMetier> getListeModulesMetiers() {
        if (this.listeModulesMetiers == null) {
            this.chargerModulesMetiers();
        }
        return this.listeModulesMetiers;
    }

    @Override
    public Map<String, String> getMapTypeComposants() {
        if (this.listeTypeComposants == null) {
            this.chargerTypeComposants();
        }
        return this.listeTypeComposants;
    }

    @Override
    public Map<String, ComposantBean> getMapComposants() {
        if (this.listeComposants == null) {
            this.chargerComposants();
        }
        return this.listeComposants;
    }

    @Override
    public Map<String, String> getCodesCentre() {
        if (this.codesCentre == null) {
            this.chargerDelegations();
        }
        return this.codesCentre;
    }

    @Override
    public Map<String, ComposantBean> getMapComposantsUtilises() {
        return this.listeComposantsUtilises;
    }

    @Override
    public Map<String, String> getMapCorrespondanceComposantChamp() {
        if (this.correspondanceComposantChamp == null) {
            this.chargerNatures();
        }
        return this.correspondanceComposantChamp;
    }

    private List<Circuit> chargerCircuits(ModuleMetier mm, Connection connection) {
        ArrayList<Circuit> circuits = new ArrayList<Circuit>();
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = connection.prepareStatement(SQL_CIRCUITS_MODULES_METIERS);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(2, mm.getCode());
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Circuit c = new Circuit();
                    c.setId(String.valueOf(rs.getInt("id")));
                    c.setCentre(rs.getString("centre"));
                    c.setDelegation(rs.getString("delegation"));
                    c.setNom(rs.getString("nom"));
                    c.setType(String.valueOf(mm.getCode()));
                    c.setTroncons(this.getTroncons(c, connection));
                    circuits.add(c);
                    this.circuits.put(c.getId(), c);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return circuits;
    }

    private List<PointPassage> getPointPassage(Circuit c) {
        ArrayList<PointPassage> pps = new ArrayList<PointPassage>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT libelle,rd FROM prism.point_passage WHERE id_circuit=? ORDER BY indice");
                pstm.setInt(1, Integer.valueOf(c.getId()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    PointPassage pp = new PointPassage();
                    pp.setLibelle(rs.getString("libelle"));
                    pp.setRd(rs.getString("rd"));
                    pps.add(pp);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    private List<Troncon> getTroncons(Circuit c, Connection connection) {
        return this.getTroncons(c, false, 0.0, true, true, connection);
    }

    private List<Troncon> getTroncons(Circuit c, boolean lateralized, double lateralizedValue, boolean obligatoireUniquement, boolean avecGeometrie) {
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                return this.getTroncons(c, lateralized, lateralizedValue, obligatoireUniquement, avecGeometrie, connection);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private List<Troncon> getTroncons(Circuit c, boolean lateralized, double lateralizedValue, boolean obligatoireUniquement, boolean avecGeometrie, Connection connection) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String sqlComplement = "";
                if (obligatoireUniquement) {
                    sqlComplement = " AND obligatoire = true";
                }
                if (lateralized) {
                    pstm = connection.prepareStatement("SELECT lateralize_line(coordonnees, ?, 1) as coordonnees_lateralized, * FROM donnees_metier.troncon_circuit WHERE idcircuit = ?" + sqlComplement + " ORDER BY indice");
                    pstm.setDouble(1, lateralizedValue);
                    pstm.setInt(2, Integer.valueOf(c.getId()));
                } else {
                    pstm = connection.prepareStatement("SELECT * FROM donnees_metier.troncon_circuit WHERE idcircuit = ?" + sqlComplement + " ORDER BY indice");
                    pstm.setInt(1, Integer.valueOf(c.getId()));
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("id"));
                    troncon.setCircuit(rs.getString("idcircuit"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("departementprdebut"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setLongueur(rs.getInt("longueur"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("departementprfin"), (String)""));
                    troncon.setDescription(rs.getString("description"));
                    troncon.setPrDebut(rs.getInt("prdebut"));
                    troncon.setPrFin(rs.getInt("prfin"));
                    troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                    troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                    if (rs.getString("fk_niveau_service") != null) {
                        troncon.setNiveauService(Long.valueOf(rs.getLong("fk_niveau_service")));
                    } else {
                        troncon.setNiveauService(null);
                    }
                    troncon.setObligatoire(rs.getBoolean("obligatoire"));
                    if (rs.getString("grammage") != null) {
                        troncon.setSalage(true);
                        troncon.setGrammage(rs.getFloat("grammage"));
                        troncon.setLargeur(rs.getFloat("largeur"));
                    } else {
                        troncon.setSalage(false);
                        troncon.setGrammage(-1000.0f);
                        troncon.setLargeur(-1000.0f);
                    }
                    troncon.setSensNumerique(rs.getInt("sens"));
                    try {
                        troncon.setIndice(rs.getInt("indice"));
                    }
                    catch (Exception ex) {
                        troncon.setIndice(-1);
                    }
                    if (avecGeometrie) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = lateralized ? Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees_lateralized"))) : Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                        try {
                            Vector<double[]> xsML = new Vector<double[]>();
                            Vector<double[]> ysML = new Vector<double[]>();
                            Vector coordPArGeometry = lateralized ? SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees_lateralized"))) : SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                            int k = 0;
                            while (k < coordPArGeometry.size()) {
                                Vector coord = (Vector)coordPArGeometry.get(k);
                                int nbPoint = coord.size();
                                double[] x = new double[nbPoint];
                                double[] y = new double[nbPoint];
                                int i = 0;
                                while (i < nbPoint) {
                                    x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                    y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                    ++i;
                                }
                                xsML.add(x);
                                ysML.add(y);
                                ++k;
                            }
                            troncon.setXs(xsML);
                            troncon.setYs(ysML);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        return troncons;
    }

    @Override
    public List<Troncon> getTroncons(String table) {
        return this.getTroncons(table, true);
    }

    @Override
    public Map<String, List<Troncon>> getTronconsCentre() {
        if (this.tronconsCentre == null) {
            try {
                this.chargerTronconsCentre();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.tronconsCentre;
    }

    @Override
    public Map<String, Map<String, List<String>>> getTronconsAffectation() {
        if (this.tronconsAffectation == null) {
            try {
                this.chargerTronconsCentre();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.tronconsAffectation;
    }

    public List<Troncon> getTroncons(String table, boolean avecGeometry) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String sql = "SELECT id,departementprdebut,departementprfin,longueur,prdebut,abscisseprdebut,prfin,abscisseprfin,axe,coordonnees FROM " + table;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("id"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("departementprdebut"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setLongueur(rs.getInt("longueur"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("departementprfin"), (String)""));
                    troncon.setPrDebut(rs.getInt("prdebut"));
                    troncon.setPrFin(rs.getInt("prfin"));
                    troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
                    troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    @Override
    public void miseAJourCoordonneesTroncon(String table, List<Troncon> troncons) {
        for (Troncon t : troncons) {
            this.miseAJourCoordonneesTroncon(table, t);
        }
    }

    @Override
    public void miseAJourCoordonneesTroncon(String table, Troncon t) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                if (t.getLongueur() > 0) {
                    String requete = "update " + table + " set coordonnees = st_geometryfromtext(?,?), longueur = ? where id = ?";
                    pstm = connection.prepareStatement(requete);
                    String coordonnees = SQL.getGeometryLine((float[])t.getX(), (float[])t.getY());
                    pstm.setString(1, coordonnees);
                    pstm.setInt(2, 4326);
                    pstm.setInt(3, t.getLongueur());
                    pstm.setInt(4, GLS.getInt((String)t.getId()));
                } else {
                    String requete = "update " + table + " set coordonnees = null, longueur = -1 where id = ?";
                    pstm = connection.prepareStatement(requete);
                    pstm.setInt(1, GLS.getInt((String)t.getId()));
                }
                pstm.execute();
            }
            catch (SQLException e) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void miseAJourPRTroncon(String table, Troncon t) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                if (t.getLongueur() > 0) {
                    String requete = "update " + table + " set prdebut = ?,abscisseprdebut = ?,prfin = ?,abscisseprfin =?,longueur=?  where id = ?";
                    pstm = connection.prepareStatement(requete);
                    pstm.setInt(1, t.getPrDebut());
                    pstm.setInt(2, t.getAbscissePrDebut());
                    pstm.setInt(3, t.getPrFin());
                    pstm.setInt(4, t.getAbscissePrFin());
                    pstm.setInt(5, t.getLongueur());
                    pstm.setInt(6, GLS.getInt((String)t.getId()));
                } else {
                    String requete = "update " + table + " set coordonnees = null, longueur = -1 where id = ?";
                    pstm = connection.prepareStatement(requete);
                    pstm.setInt(1, GLS.getInt((String)t.getId()));
                }
                pstm.execute();
            }
            catch (SQLException e) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public synchronized List<ActionProfil> getActionsProfil() {
        if (this.actionsProfils == null) {
            this.chargerActionsProfil();
        }
        return this.actionsProfils;
    }

    private void chargerActionsProfil() {
        ArrayList<ActionProfil> pps = new ArrayList<ActionProfil>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_ACTIONS);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ActionProfil action = new ActionProfil();
                    action.setAction(rs.getInt("id"));
                    action.setNom(rs.getString("nom"));
                    action.setDescription(rs.getString("description"));
                    if (rs.getObject("parent") != null) {
                        action.setActionParent(Integer.valueOf(rs.getInt("parent")));
                    }
                    pps.add(action);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.actionsProfils = pps;
    }

    private List<Activite> getActivites() {
        ArrayList<Activite> pps = new ArrayList<Activite>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_ACTIVITES);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Activite a = new Activite();
                    a.setCode(rs.getString("code"));
                    a.setLibelle(rs.getString("libelle"));
                    pps.add(a);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return pps;
    }

    @Override
    public synchronized List<Vehicule> getListeVehicule() {
        if (this.vehicules == null) {
            this.chargerVehicules();
        }
        return this.vehicules;
    }

    private void chargerVehicules() {
        ArrayList<Vehicule> vs = new ArrayList<Vehicule>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String classement = (String)this.getConfiguration().getOrDefault((Object)"bdd.vehicule.classement", (Object)"code");
                pstm = connection.prepareStatement(SQL_VEHICULES.concat(classement));
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                Log.debug("REQ LISTE VEHICULES CHARGEMENT -- " + pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Vehicule v = new Vehicule();
                    v.setDelegation(rs.getString("delegation"));
                    v.setCentre(rs.getString("centre"));
                    v.setCode(rs.getString("code"));
                    v.setImmatriculation(rs.getString("immatriculation"));
                    v.setNumeroTelephone(rs.getString("numero_telephone"));
                    v.setNumeroRadio(rs.getString("numero_radio"));
                    v.setDescription(rs.getString("description"));
                    v.setType(rs.getInt("id_marque_vehicule"));
                    v.setArchive(rs.getBoolean("archive"));
                    vs.add(v);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.vehicules = vs;
    }

    @Override
    public synchronized List<MarqueVehicule> getMarquesVehicules() {
        if (this.marquesVehicules == null) {
            this.chargerMarquesVehicules();
        }
        return this.marquesVehicules;
    }

    private void chargerMarquesVehicules() {
        ArrayList<MarqueVehicule> vs = new ArrayList<MarqueVehicule>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_MARQUES_VEHICULES);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    MarqueVehicule v = new MarqueVehicule();
                    v.setType(rs.getInt("code_type_vehicule"));
                    v.setDescription(rs.getString("description"));
                    v.setIcone(rs.getInt("icone_vehicule"));
                    v.setId(rs.getInt("id"));
                    v.setNom(rs.getString("nom"));
                    vs.add(v);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.marquesVehicules = vs;
    }

    @Override
    public synchronized Map<Integer, TypesMarques> getTypesMarques() {
        if (this.typesMarques == null) {
            this.chargerTypesMarques();
        }
        return this.typesMarques;
    }

    private void chargerTypesMarques() {
        HashMap<Integer, TypesMarques> map = new HashMap<Integer, TypesMarques>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_TYPE_MARQUE);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TypesMarques tm = new TypesMarques();
                    tm.setCode(rs.getInt("code"));
                    tm.setLabel(rs.getString("libelle"));
                    map.put(tm.getCode(), tm);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.typesMarques = map;
    }

    @Override
    public synchronized List<DestinataireMail> getDestinatairesMail() {
        this.chargerDestinatairesMail();
        return this.destinataireMails;
    }

    private void chargerDestinatairesMail() {
        ArrayList<DestinataireMail> list = new ArrayList<DestinataireMail>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_DESTINATAIRE_MAIL);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    DestinataireMail dest = new DestinataireMail();
                    dest.setCategorie(rs.getString("cat"));
                    dest.setId(rs.getInt("id"));
                    dest.setMail(rs.getString("mail"));
                    dest.setNom(rs.getString("nom"));
                    dest.setCentre(rs.getString("centre"));
                    dest.setDelegation(rs.getString("delegation"));
                    list.add(dest);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.destinataireMails = list;
    }

    @Override
    public synchronized List<String> getCategoriesDestinatairesMail() {
        this.chargerCategoriesdestinataireMail();
        return this.categoriesdestinataireMail;
    }

    private void chargerCategoriesdestinataireMail() {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_CATEGORIES_DESTINATAIRE_MAIL);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString("nom_categorie_destinataire_mail"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.categoriesdestinataireMail = list;
    }

    @Override
    public synchronized List<ListeDestinataireMail> getListeDestinataireMails() {
        this.chargerListeDestinataireMails();
        return this.listeDestinatiresMail;
    }

    private void chargerListeDestinataireMails() {
        HashMap<Integer, ListeDestinataireMail> mapListe = new HashMap<Integer, ListeDestinataireMail>();
        ArrayList<ListeDestinataireMail> list = new ArrayList<ListeDestinataireMail>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LISTE_DESTINATAIRE_MAIL);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ListeDestinataireMail liste = new ListeDestinataireMail();
                    liste.setId(rs.getInt("id"));
                    liste.setNom(rs.getString("nom"));
                    liste.setDestinataires(new ArrayList());
                    mapListe.put(liste.getId(), liste);
                    list.add(liste);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        HashMap<Integer, DestinataireMail> mapDestinataires = new HashMap<Integer, DestinataireMail>();
        for (DestinataireMail destinataire : this.getDestinatairesMail()) {
            mapDestinataires.put(destinataire.getId(), destinataire);
        }
        connection = null;
        pstm = null;
        rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select * from prism.lien_destinataire");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    DestinataireMail d = (DestinataireMail)mapDestinataires.get(rs.getInt("id_destinataire"));
                    ListeDestinataireMail l = (ListeDestinataireMail)mapListe.get(rs.getInt("id_liste_destinataire_mail"));
                    if (l == null || d == null) continue;
                    l.getDestinataires().add(d);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
        this.listeDestinatiresMail = list;
    }

    @Override
    public synchronized List<ListeDiffusion> getListesDiffusions() {
        this.chargerListesDiffusions();
        return this.listesDiffusions;
    }

    private void chargerListesDiffusions() {
        HashMap<String, ListeDiffusion> map = new HashMap<String, ListeDiffusion>();
        ArrayList<ListeDiffusion> ret = new ArrayList<ListeDiffusion>();
        String[] stringArray = ListeDiffusion.KEYS;
        int n = ListeDiffusion.KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            ListeDiffusion l = new ListeDiffusion();
            l.setChamp(key);
            map.put(key, l);
            ++n2;
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LISTE_DIFFUSION);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ListeDiffusion d = (ListeDiffusion)map.get(rs.getString("champ"));
                    if (d == null) {
                        Log.error("le champ " + rs.getString("champ") + " d\u00e9fini dans la table liste_diffusion n'existe pas dans la classe ListeDiffusion");
                        continue;
                    }
                    int id = rs.getInt("id_liste_destinataire");
                    if (rs.wasNull()) {
                        id = -1;
                    }
                    d.setListe(id);
                    ret.add(d);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.listesDiffusions = ret;
    }

    @Override
    public synchronized Map<String, Integer> getDesciptionDiffusionEvt() {
        this.chargerDesciptionDiffusionEvt();
        return this.mapDiffusionsEvenements;
    }

    private void chargerDesciptionDiffusionEvt() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LISTE_DIFFUSION_EVT);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    int idDestinataire = rs.getInt("id_liste_destinataire");
                    if (rs.wasNull()) continue;
                    map.put(rs.getString("description_evenement"), idDestinataire);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.mapDiffusionsEvenements = map;
    }

    @Override
    public Map<String, Long> getMiseAJourDonneesMetiers() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, Long> map = new HashMap<String, Long>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_MAJ_DONNEES_METIER);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    map.put(rs.getString("champ"), rs.getTimestamp("date").getTime());
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return map;
    }

    @Override
    public long getDerniereDateMajDonneesMetiers() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        long dateDerniereMiseAJour = -1L;
        try {
            try {
                String requete = "select max(date) as max_date from prism.update_donnees_metiers WHERE zone_routiere = ? ";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                if (rs.next()) {
                    dateDerniereMiseAJour = rs.getString("max_date") != null ? rs.getTimestamp("max_date").getTime() : GregorianCalendar.getInstance().getTimeInMillis();
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return dateDerniereMiseAJour;
    }

    @Override
    public synchronized Map<String, ReformulationDescription> getReformulations() {
        if (this.reformulationMap == null) {
            this.chargerReformulations();
        }
        return this.reformulationMap;
    }

    private void chargerReformulations() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, ReformulationDescription> map = new HashMap<String, ReformulationDescription>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT d.code,d.nature,d.libelle,r.type1,r.type2,r.type3,r.type4,r.type5, r.valeur1,r.valeur2,r.valeur3,r.valeur4,r.valeur5 FROM prism.reformulation_description r JOIN prism.description_nature_perso d ON r.description=d.code WHERE mse=?");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ReformulationDescription r = new ReformulationDescription();
                    r.setCode(rs.getString("code"));
                    r.setCodeNature(rs.getString("nature"));
                    r.setLibelle(rs.getString("libelle"));
                    r.setType1(rs.getInt("type1"));
                    r.setType2(rs.getInt("type2"));
                    r.setType3(rs.getInt("type3"));
                    r.setType4(rs.getInt("type4"));
                    r.setType5(rs.getInt("type5"));
                    r.setValeur1(rs.getString("valeur1"));
                    r.setValeur2(rs.getString("valeur2"));
                    r.setValeur3(rs.getString("valeur3"));
                    r.setValeur4(rs.getString("valeur4"));
                    r.setValeur5(rs.getString("valeur5"));
                    map.put(r.getCode(), r);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.reformulationMap = map;
    }

    @Override
    public synchronized Map<String, String[]> getValeursReformulation() {
        if (this.valeursReformulations == null) {
            this.chargerValeursReformulation();
        }
        return this.valeursReformulations;
    }

    private void chargerValeursReformulation() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT nom,valeurs FROM prism.reformulation_champ WHERE mse=?");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String nom = rs.getString("nom");
                    String[] valeurs = (String[])rs.getArray("valeurs").getArray();
                    map.put(nom, valeurs);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.valeursReformulations = map;
    }

    @Override
    public Map<String, Circuit> getCircuits() {
        return this.circuits;
    }

    @Override
    public synchronized List<String> getListeCommunes() {
        if (this.listeCommunes == null) {
            this.chargerCommunes();
        }
        return this.listeCommunes;
    }

    private void chargerCommunes() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, Commune> mapCommune = new HashMap<String, Commune>();
        ArrayList<String> liste = new ArrayList<String>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.communes WHERE zone_routiere=? ORDER BY commune");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Log.debug(Commune.class.getProtectionDomain().getCodeSource().getLocation());
                    Commune c = new Commune();
                    c.setNom(rs.getString("commune"));
                    c.setDelegation(rs.getString("delegation"));
                    c.setCentre(this.getValeurColonne(rs, "centre", null));
                    c.setCodeInsee(this.getValeurColonne(rs, "insee", null));
                    c.setCodePostal(this.getValeurColonne(rs, "cp", null));
                    map.put(c.getNom(), c.getDelegation());
                    liste.add(c.getNom());
                    mapCommune.put(c.getNom(), c);
                }
                Collections.sort(liste);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.communesDelegation = map;
        this.listeCommunes = liste;
        this.communes = mapCommune;
    }

    private String getValeurColonne(ResultSet rs, String nomColonne, String valeurDefaut) {
        try {
            return rs.getString(nomColonne);
        }
        catch (Exception e) {
            return valeurDefaut;
        }
    }

    @Override
    public List<NiveauService> getNiveauxService() {
        ArrayList<NiveauService> list = new ArrayList<NiveauService>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LISTE_NIVEAU_SERVICE);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    NiveauService liste = new NiveauService();
                    liste.setId(rs.getLong("id"));
                    liste.setFrequence(rs.getInt("frequence"));
                    liste.setNbPeriode(rs.getInt("nb_periode"));
                    liste.setLibelle(rs.getString("libelle"));
                    liste.setTypePeriode(NiveauService.EnumTypePeriode.valueOf((String)rs.getString("type_periode")));
                    list.add(liste);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return list;
    }

    @Override
    public synchronized String getDelegationCommune(String commune) {
        if (this.communesDelegation == null) {
            this.chargerCommunes();
        }
        return this.communesDelegation.get(commune);
    }

    @Override
    public Commune getCommune(String commune) {
        if (this.communes == null) {
            this.chargerCommunes();
        }
        return this.communes.get(commune);
    }

    @Override
    public Bounds getBoundsCommune(String comm) {
        if (this.communesBounds == null) {
            this.chargerCommunesBounds();
        }
        return this.communesBounds.get(comm);
    }

    private void chargerCommunesBounds() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        HashMap<String, Bounds> map = new HashMap<String, Bounds>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT commune,box_minx,box_miny,box_maxx,box_maxy FROM prism.communes WHERE zone_routiere=? ORDER BY commune");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String commune = rs.getString("commune");
                    map.put(commune, this.readBounds(rs));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.communesBounds = map;
    }

    @Override
    public ModuleMetier getModuleMetier(String libelleModuleMetier) {
        ModuleMetier retour = null;
        if (this.modulesMetiers == null) {
            this.modulesMetiers = this.getModulesMetiers();
        }
        for (int key : this.modulesMetiers.keySet()) {
            if (!this.modulesMetiers.get(key).getNom().equals(libelleModuleMetier)) continue;
            retour = this.modulesMetiers.get(key);
        }
        return retour;
    }

    @Override
    public List<BarreauVH> getBarreauxVH() {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String requete = "SELECT *,((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id ORDER BY indice, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(boolean sansCoordoonees) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id ORDER BY indice, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(boolean sansCoordoonees, boolean sansCoordonnees2) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT  description,departementprdebut,axe,abscisseprdebut,prdebut,donnees_metier.troncon_circuit_ext.id as id,departementprfin,longueur,prfin,abscisseprfin,idcircuit,indice,croisement_1,croisement_2,id_groupe,centre,troncon_id,id_patrouilleur,maj,status,maj_transmis,maj_id_partenaire,delegation,fk_niveau_service,obligatoire,grammage,largeur,cch,cch2,tendancecc,traitement,meteo,commentaire,equipements,etat_chaussee,temperature,date,vent,duree,commentaire_interne,vh.donnees_vh_troncon.sens as sens,publie " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id ORDER BY indice, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(String delegation, String centre) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String requete = "SELECT *,((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id AND lower(delegation) like ? AND (lower(centre) like ? OR centre is null) ORDER BY indice, delegation, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, delegation.toLowerCase());
                pstm.setString(2, centre == null ? null : centre.toLowerCase());
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public BarreauVH getBarreauVH(String tronconId, boolean sansCoordoonees) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            BarreauVH barreauVH;
            String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
            String requete = "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id AND lower(troncon_id) = ? ORDER BY indice, delegation, centre, id_groupe, troncon_id";
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, tronconId.toLowerCase());
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                BarreauVH troncon = new BarreauVH();
                ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                barreauVH = troncon;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return barreauVH;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(String delegation, String centre, boolean sansCoordoonees) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id AND (lower(delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + " ORDER BY indice, delegation, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, delegation.toLowerCase());
                if (!GLS.estVide((String)centre)) {
                    pstm.setString(2, centre == null ? null : centre.toLowerCase());
                }
                rs = pstm.executeQuery();
                Log.debug(pstm.toString());
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(String delegation, String centre, boolean sansCoordoonees, boolean sansCoordoon) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT description,departementprdebut,axe,abscisseprdebut,prdebut,donnees_metier.troncon_circuit_ext.id as id,departementprfin,longueur,prfin,abscisseprfin,idcircuit,indice,croisement_1,croisement_2,id_groupe,centre,troncon_id,id_patrouilleur,maj,status,maj_transmis,maj_id_partenaire,delegation,fk_niveau_service,obligatoire,grammage,largeur,cch,cch2,tendancecc,traitement,meteo,commentaire,equipements,etat_chaussee,temperature,date,vent,duree,commentaire_interne,vh.donnees_vh_troncon.sens as sens,publie " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id " + (!GLS.estVide((String)delegation) ? "AND (lower(delegation) like ? OR delegation is null OR delegation = '')" : "") + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + " ORDER BY indice, delegation, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                if (!GLS.estVide((String)delegation)) {
                    pstm.setString(1, delegation == null ? null : delegation.toLowerCase());
                }
                if (!GLS.estVide((String)centre)) {
                    pstm.setString(2, centre == null ? null : centre.toLowerCase());
                }
                rs = pstm.executeQuery();
                Log.debug(pstm.toString());
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(String delegation, String centre, int circuit, boolean sansCoordoonees) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = circuit != -1 ? "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id" + " AND donnees_metier.troncon_circuit_ext.idcircuit = ? " + " ORDER BY indice, delegation, centre, id_groupe, troncon_id" : (GLS.estVide((String)delegation) ? "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id" + " ORDER BY indice, delegation, centre, id_groupe, troncon_id" : "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id" + " AND donnees_metier.troncon_circuit_ext.idcircuit IN (SELECT id FROM circuit c WHERE (lower(c.delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + " ) " + " AND (lower(delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + "ORDER BY indice, delegation, centre, id_groupe, troncon_id");
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                if (circuit != -1) {
                    pstm.setInt(1, circuit);
                } else if (!GLS.estVide((String)delegation)) {
                    int i = 1;
                    pstm.setString(i++, delegation.toLowerCase());
                    if (!GLS.estVide((String)centre)) {
                        pstm.setString(i++, centre.toLowerCase());
                    }
                    pstm.setString(i++, delegation.toLowerCase());
                    if (!GLS.estVide((String)centre)) {
                        pstm.setString(i++, centre.toLowerCase());
                    }
                }
                rs = pstm.executeQuery();
                Log.debug("getBarreauxVH : " + pstm.toString());
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    public static void fabriqueTroncon(ResultSet rs, BarreauVH troncon) throws SQLException {
        Vector coord;
        Vector coordPArGeometry;
        Vector<Object> ys;
        Vector<Object> xs;
        troncon.setId(rs.getString("id"));
        troncon.setCircuit(rs.getString("idcircuit"));
        troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("departementprdebut"), (String)""));
        troncon.setAxe(rs.getString("axe"));
        troncon.setLongueur(rs.getInt("longueur"));
        troncon.setDepartementPrFin(GLS.getString((String)rs.getString("departementprfin"), (String)""));
        troncon.setDescription(rs.getString("description"));
        troncon.setPrDebut(rs.getInt("prdebut"));
        troncon.setPrFin(rs.getInt("prfin"));
        troncon.setAbscissePrDebut(rs.getInt("abscisseprdebut"));
        troncon.setAbscissePrFin(rs.getInt("abscisseprfin"));
        troncon.setIdGroupe(rs.getString("id_groupe"));
        troncon.setDelegation(rs.getString("delegation"));
        troncon.setCentre(rs.getString("centre"));
        troncon.setCroisement1(rs.getString("croisement_1"));
        troncon.setCroisement2(rs.getString("croisement_2"));
        troncon.setLibelle(rs.getString("description"));
        troncon.setCode(rs.getString("description"));
        troncon.setTronconID(rs.getString("troncon_id"));
        troncon.setIdPatrouilleur(rs.getString("id_patrouilleur"));
        troncon.setMajDate((Date)rs.getTimestamp("maj"));
        troncon.setMajDateServeur((Date)rs.getTimestamp("maj_transmis"));
        if (rs.findColumn("fk_niveau_service") > -1) {
            troncon.setNiveauService(Long.valueOf(rs.getLong("fk_niveau_service")));
        }
        try {
            if (rs.findColumn("libelle_niveau") > -1) {
                troncon.setClassification(rs.getString("libelle_niveau"));
            }
        }
        catch (Exception e) {
            troncon.setClassification(null);
        }
        troncon.setStatus(rs.getString("status"));
        troncon.setPublie(rs.getBoolean("publie"));
        try {
            troncon.setMajIdPartenaire(rs.getInt("maj_id_partenaire"));
        }
        catch (Exception ex) {
            troncon.setMajIdPartenaire(-1);
        }
        try {
            if (rs.getObject("coordonnees") != null) {
                xs = new Vector<Object>();
                ys = new Vector<Object>();
                coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                int k = 0;
                while (k < coordPArGeometry.size()) {
                    coord = (Vector)coordPArGeometry.get(k);
                    int nbPoint = coord.size();
                    int i = 0;
                    while (i < nbPoint) {
                        xs.add(((Point2D.Double)coord.get((int)i)).x);
                        ys.add(((Point2D.Double)coord.get((int)i)).y);
                        ++i;
                    }
                    ++k;
                }
                float[] xf = new float[xs.size()];
                float[] yf = new float[ys.size()];
                int i = 0;
                while (i < xf.length) {
                    xf[i] = new Double((Double)xs.get(i)).floatValue();
                    yf[i] = new Double((Double)ys.get(i)).floatValue();
                    ++i;
                }
                troncon.setX(xf);
                troncon.setY(yf);
                try {
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    int k2 = 0;
                    while (k2 < coordPArGeometry.size()) {
                        Vector coord2 = (Vector)coordPArGeometry.get(k2);
                        int nbPoint = coord2.size();
                        double[] x = new double[nbPoint];
                        double[] y = new double[nbPoint];
                        int i2 = 0;
                        while (i2 < nbPoint) {
                            x[i2] = ((Point2D.Double)coord2.get((int)i2)).x;
                            y[i2] = ((Point2D.Double)coord2.get((int)i2)).y;
                            ++i2;
                        }
                        xsML.add(x);
                        ysML.add(y);
                        ++k2;
                    }
                    troncon.setXs(xsML);
                    troncon.setYs(ysML);
                }
                catch (Exception xsML) {}
            }
        }
        catch (Exception e) {
            troncon.setX(null);
            troncon.setY(null);
        }
        try {
            if (rs.getObject("buffer") != null) {
                xs = new Vector();
                ys = new Vector();
                coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("buffer")));
                int k = 0;
                while (k < coordPArGeometry.size()) {
                    coord = (Vector)coordPArGeometry.get(k);
                    int nbPoint = coord.size();
                    double[] x = new double[nbPoint];
                    double[] y = new double[nbPoint];
                    int i = 0;
                    while (i < nbPoint) {
                        x[i] = ((Point2D.Double)coord.get((int)i)).x;
                        y[i] = ((Point2D.Double)coord.get((int)i)).y;
                        ++i;
                    }
                    xs.add(x);
                    ys.add(y);
                    ++k;
                }
                troncon.setXs(xs);
                troncon.setYs(ys);
            }
        }
        catch (Exception xs2) {
            // empty catch block
        }
        try {
            troncon.setCch(rs.getString("cch"));
            troncon.setCch2(rs.getString("cch2"));
            troncon.setTendanceCC(rs.getString("tendancecc"));
            troncon.setTraitement(rs.getString("traitement"));
            troncon.setMeteo(rs.getString("meteo"));
            troncon.setCommentaire(rs.getString("commentaire"));
            troncon.setEquipements(rs.getString("equipements"));
            troncon.setEtatChaussee(rs.getString("etat_chaussee"));
            troncon.setTemperature(rs.getString("temperature"));
            troncon.setVent(rs.getString("vent"));
            troncon.setCommentaireInterne(rs.getString("commentaire_interne"));
            int numSensInt = -1;
            int numSensChar = -1;
            int i = 1;
            while (i <= rs.getMetaData().getColumnCount()) {
                if ("sens".equals(rs.getMetaData().getColumnName(i))) {
                    if (rs.getMetaData().getColumnType(i) == 4) {
                        numSensInt = i;
                    } else {
                        numSensChar = i;
                    }
                }
                ++i;
            }
            if (numSensChar >= 0) {
                troncon.setSens(rs.getString(numSensChar));
            }
            if (numSensInt >= 0) {
                troncon.setSensNumerique(rs.getInt(numSensInt));
            }
            troncon.setDuree(rs.getInt("duree"));
            try {
                troncon.setIndice(rs.getInt("indice"));
            }
            catch (Exception ex) {
                troncon.setIndice(-1);
            }
        }
        catch (Exception ex) {
            troncon.setMajIdPartenaire(-1);
        }
    }

    @Override
    public Synthese getSyntheseVH(String zoneRoutiere) {
        String requete = "SELECT commentaire, nom, date FROM vh.synthese WHERE nom = ?";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Synthese synthese = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, zoneRoutiere.toLowerCase());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    synthese = new Synthese();
                    synthese.setCommentaire(rs.getString("commentaire"));
                    synthese.setZoneRoutiere(zoneRoutiere);
                    synthese.setDate((Date)rs.getTimestamp("date"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return synthese;
    }

    @Override
    public Synthese getSynthesePublieVH(String zoneRoutiere) {
        String requete = "SELECT commentaire, nom, date FROM vh.synthese_publie WHERE nom = ?";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Synthese synthese = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, zoneRoutiere.toLowerCase());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    synthese = new Synthese();
                    synthese.setCommentaire(rs.getString("commentaire"));
                    synthese.setZoneRoutiere(zoneRoutiere);
                    synthese.setDate((Date)rs.getTimestamp("date"));
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return synthese;
    }

    @Override
    public void updateSyntheseVH(Synthese synthese) {
        String requete = "INSERT INTO vh.synthese (commentaire, date, nom) VALUES(?, ?, ?) ON CONFLICT (nom) DO UPDATE SET commentaire = ?, date = ?;";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, synthese.getCommentaire());
                pstm.setTimestamp(2, new Timestamp(synthese.getDate().getTime()));
                pstm.setString(3, synthese.getZoneRoutiere().toLowerCase());
                pstm.setString(4, synthese.getCommentaire());
                pstm.setTimestamp(5, new Timestamp(synthese.getDate().getTime()));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void updateSynthesePublieVH(Synthese synthese) {
        String requete = "INSERT INTO vh.synthese_publie (commentaire, date, nom) VALUES(?, ?, ?) ON CONFLICT (nom) DO UPDATE SET commentaire = ?, date = ?;";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, synthese.getCommentaire());
                pstm.setTimestamp(2, new Timestamp(synthese.getDate().getTime()));
                pstm.setString(3, synthese.getZoneRoutiere().toLowerCase());
                pstm.setString(4, synthese.getCommentaire());
                pstm.setTimestamp(5, new Timestamp(synthese.getDate().getTime()));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public long getMaxDateMiseAJourVH() {
        String requete = "select max(t.date) as date_max from vh.donnees_vh_troncon t";
        Connection connection = null;
        PreparedStatement pstm = null;
        Timestamp d = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    d = rs.getTimestamp("date_max");
                }
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (d != null) {
            return ((Date)d).getTime();
        }
        return -1L;
    }

    @Override
    public boolean UpdateComposantFromNature(NatureBean nature, ComposantNatureCommunBean composant) {
        boolean ret = false;
        String requete = composant.getIsComposantCommun() != false ? "UPDATE composants_commun SET redefinition=?,indice=?  WHERE zone_routiere=? AND nom_composant=?" : "UPDATE composants_nature SET redefinition=?,indice=? WHERE zone_routiere=? AND nom_composant=? AND code_nature=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, composant.getRedefinition());
                pstm.setInt(2, composant.getIndice());
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(4, composant.getNomComposant());
                if (!composant.getIsComposantCommun().booleanValue()) {
                    pstm.setString(5, nature.getCode());
                }
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    public boolean estComposantNatureReference(ComposantNatureCommunBean composant) {
        boolean ret = false;
        String requete = composant.getIsComposantCommun() != false ? "select nom from composants_commun WHERE nom_composant=?" : "select nom from composants_nature WHERE nom_composant=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, composant.getRedefinition());
                pstm.setInt(2, composant.getIndice());
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(4, composant.getNomComposant());
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public boolean DeleteComposantFromNature(NatureBean nature, ComposantNatureCommunBean composant) {
        String requete;
        boolean filtreComposant;
        boolean ret = false;
        boolean filtreNature = nature != null && !GLS.estVide((String)nature.getCode()) && (composant == null || composant.getIsComposantCommun() == false);
        boolean bl = filtreComposant = composant != null && !GLS.estVide((String)composant.getNomComposant());
        if (filtreComposant) {
            requete = composant.getIsComposantCommun() != false ? "DELETE FROM composants_commun WHERE zone_routiere=?" : "DELETE FROM composants_nature WHERE zone_routiere=?";
            requete = String.valueOf(requete) + " AND nom_composant=?";
            if (filtreNature) {
                requete = String.valueOf(requete) + " AND code_nature=?";
            }
        } else if (filtreNature) {
            requete = "DELETE FROM composants_nature WHERE zone_routiere=? AND code_nature=?";
        } else {
            return false;
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (filtreComposant) {
                    pstm.setString(2, composant.getNomComposant());
                }
                if (filtreNature) {
                    if (filtreComposant) {
                        pstm.setString(3, nature.getCode());
                    } else {
                        pstm.setString(2, nature.getCode());
                    }
                }
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public boolean deleteComposant(String composant) {
        boolean ret = false;
        String requete = "DELETE FROM composant WHERE nom=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, composant);
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public boolean CreateComposantFromNature(NatureBean nature, ComposantNatureCommunBean composant) {
        boolean ret = false;
        String requete = composant.getIsComposantCommun() != false ? "INSERT INTO composants_commun (nom_composant, zone_routiere, nom_onglet, indice, largeur, redefinition, libelle, code_module_metier) VALUES (?,?,?,?,?,?,?,?)" : "INSERT INTO composants_nature (nom_composant, zone_routiere, nom_onglet, indice, largeur, redefinition, code_nature) VALUES (?,?,?,?,?,?,?)";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, composant.getNomComposant());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (!GLS.estVide((String)composant.getNomOnglet())) {
                    pstm.setString(3, composant.getNomOnglet());
                } else {
                    pstm.setString(3, "general");
                }
                pstm.setInt(4, composant.getIndice());
                pstm.setInt(5, composant.getLargeur());
                pstm.setString(6, composant.getRedefinition());
                if (composant.getIsComposantCommun().booleanValue()) {
                    pstm.setString(7, composant.getLibelle());
                    pstm.setInt(8, composant.getCodeModuleMetier());
                } else {
                    pstm.setString(7, nature.getCode());
                }
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public List<NatureBean> getListeNaturePerso(boolean withZoneRoutiere) {
        ArrayList<NatureBean> liste = new ArrayList<NatureBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(this.SQL_LISTE_NATURES_PERSO);
                if (withZoneRoutiere) {
                    req.append(" WHERE zone_routiere = ? ");
                }
                req.append(" ORDER BY code_module_metier,indice");
                pstm = connection.prepareStatement(req.toString());
                if (withZoneRoutiere) {
                    pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    NatureBean n = new NatureBean();
                    n.setZoneRoutiere(rs.getString("zone_routiere"));
                    n.setCode(rs.getString("code"));
                    n.setLibelle(rs.getString("libelle"));
                    n.setActive(rs.getBoolean("active"));
                    n.setCodeCategorie(rs.getString("code_categorie"));
                    n.setCodeModuleMetier(rs.getInt("code_module_metier"));
                    n.setIndice(rs.getInt("indice"));
                    FiltreComposantNatureCommunBean filtre = new FiltreComposantNatureCommunBean();
                    filtre.setZoneRoutiere(n.getZoneRoutiere());
                    n.setListeComposantsCommun(this.getListComposantsCommun(filtre));
                    filtre.setCodeNature(n.getCode());
                    n.setListeComposantsNature(this.getListComposantsNature(filtre));
                    liste.add(n);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    private ChampAbstrait lireChamp(ComposantBean cb) throws SQLException {
        int style;
        String type = cb.getType();
        String nom = cb.getNom();
        String definition = cb.getDefinition();
        try {
            style = cb.getStyle();
        }
        catch (Exception e) {
            style = 0;
        }
        int hauteur = cb.getHauteur();
        String restrictions = cb.getRestrictions();
        String defaut = cb.getDefaut();
        ChampMultiple c = null;
        block24 : switch (type) {
            case "GLSTextBox": {
                ChampTexte champTexte = new ChampTexte(nom);
                MapDescription typeChamp = MapDescription.parse((String)definition);
                if (typeChamp.containsKey("type")) {
                    champTexte.setType(typeChamp.getString("type", "texte"));
                }
                c = champTexte;
                champTexte.setValeur(defaut == null ? "" : defaut);
                break;
            }
            case "GLSRadioBox": {
                ChampRadioBouton champRadioBouton = new ChampRadioBouton(nom);
                List valeurs = MetierCommun.getListe((String)definition);
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("les valeurs ne peuvent \u00eatre vides pour le composant " + nom);
                }
                champRadioBouton.setValeurs(valeurs);
                if (defaut == null) {
                    champRadioBouton.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champRadioBouton.getValeurChamp()).setValeur((String)valeurs.get(0));
                } else {
                    champRadioBouton.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champRadioBouton.getValeurChamp()).setValeur(defaut);
                }
                c = champRadioBouton;
                break;
            }
            case "GLSImageMultiple": {
                ChampChoixImageMultiple champImageMulti = new ChampChoixImageMultiple(nom);
                MapDescription def = MapDescription.parse((String)definition);
                champImageMulti.setNcValeur(null);
                champImageMulti.setValeursSelectionnee(new ArrayList(0));
                champImageMulti.setHauteurImage(def.getInt("hauteur", 50));
                champImageMulti.setLargeurImage(def.getInt("largeur", 50));
                champImageMulti.setAutreLabel(null);
                List<String> valeurs = def.getList("valeurs");
                if (ChampChoixImageMultiple.estDynamique((List)valeurs)) {
                    valeurs = this.iconDal.getListeNomsImage(nom, null);
                }
                champImageMulti.setAfficheLibelle(def.getBoolean("afficheLibelle", false));
                champImageMulti.setValeurs(valeurs);
                c = champImageMulti;
                break;
            }
            case "GLSImageComboBox": {
                ChampChoixImage champChoixImage = new ChampChoixImage(nom);
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length < 2) {
                    throw new PrismBddConfigurationError("La configuration d'un composant choix image doit etre compos\u00e9e d'au moins deux parties s\u00e9par\u00e9es par ':' " + nom);
                }
                List<String> valeurs = MetierCommun.getListe((String)definitionSplit[1]);
                Log.debug("Composant " + nom);
                if (ChampChoixImage.estDynamique((List)valeurs)) {
                    valeurs = this.iconDal.getListeNomsImage(nom, definitionSplit[0]);
                }
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("La configuration d'un composant choix image doit au moin avoir une valeur " + nom);
                }
                int indiceAutre = valeurs.indexOf(definitionSplit[0]);
                if (definitionSplit.length > 2) {
                    champChoixImage.setHauteurImage(GLS.getInt((String)definitionSplit[2], (int)50));
                } else {
                    champChoixImage.setHauteurImage(50);
                }
                champChoixImage.setIndiceAutreChoix(indiceAutre);
                champChoixImage.setValeurs(valeurs);
                if (defaut == null) {
                    champChoixImage.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champChoixImage.getValeurChamp()).setValeur(valeurs.get(0));
                } else {
                    champChoixImage.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champChoixImage.getValeurChamp()).setValeur(defaut);
                }
                c = champChoixImage;
                break;
            }
            case "GLSComboBox": {
                ChampDropListe champDropListe = new ChampDropListe(nom);
                List valeurs = MetierCommun.getListe((String)definition);
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("les valeurs ne peuvent \u00eatre vides pour le composant " + nom);
                }
                champDropListe.setValeurs(valeurs);
                if (defaut == null) {
                    champDropListe.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur((String)valeurs.get(0));
                } else {
                    champDropListe.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur(defaut);
                }
                c = champDropListe;
                break;
            }
            case "ComposantChoix": {
                ChampDropListe champDropListe = new ChampDropListe(nom);
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length != 2) {
                    throw new PrismBddConfigurationError("La configuration d'un composant choix doit etre compos\u00e9e de deux parties s\u00e9par\u00e9es par ':' " + nom);
                }
                List valeurs = MetierCommun.getListe((String)definitionSplit[1]);
                if (GLS.estVide((List)valeurs)) {
                    throw new PrismBddConfigurationError("les valeurs ne peuvent \u00eatre vides pour le composant " + nom);
                }
                int indiceAutre = valeurs.indexOf(definitionSplit[0]);
                champDropListe.setIndiceAutreChoix(indiceAutre);
                champDropListe.setValeurs(valeurs);
                if (defaut == null) {
                    champDropListe.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur((String)valeurs.get(0));
                } else {
                    champDropListe.setIndexSelectionnee(valeurs.indexOf(defaut));
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur(defaut);
                }
                c = champDropListe;
                break;
            }
            case "GLSIntBox": {
                ChampEntier champEntier = new ChampEntier(nom);
                MapDescription description = MapDescription.parse((String)definition);
                champEntier.setCheckbox(description.getBoolean("desactivable", false));
                champEntier.setValeurMin(description.getInt("min", 0));
                champEntier.setValeurMax(description.getInt("max", 1000));
                champEntier.setPas(description.getInt("pas", 1));
                if (defaut != null) {
                    champEntier.setValeur(GLS.getInt((String)defaut, (int)0));
                } else {
                    champEntier.setValeur(champEntier.getValeurMin());
                }
                c = champEntier;
                break;
            }
            case "GLSDecimalBox": {
                ChampDecimal champDecimal = new ChampDecimal(nom);
                MapDescription description = MapDescription.parse((String)definition);
                champDecimal.setCheckbox(description.getBoolean("desactivable", false));
                champDecimal.setValeurMin(description.getDouble("min", 0.0));
                champDecimal.setValeurMax(description.getDouble("max", 1000.0));
                champDecimal.setPas(description.getDouble("pas", 1.0));
                if (defaut != null) {
                    champDecimal.setValeur(GLS.getDouble((String)defaut, (double)0.0));
                }
                c = champDecimal;
                break;
            }
            case "GLSCheckBox": {
                ChampVraiFaux champVraiFaux = new ChampVraiFaux(nom);
                champVraiFaux.setValeur(false);
                c = champVraiFaux;
                break;
            }
            case "GLSMultiCheckBoxNC": {
                ChampMultiCheckBox champMultiCheckBox = new ChampMultiCheckBox(nom);
                champMultiCheckBox.setNcValeur(GLS.estVide((String)defaut) ? "NC" : defaut);
                champMultiCheckBox.setValeursSelectionnee(MetierCommun.getListe((String)champMultiCheckBox.getNcValeur()));
                champMultiCheckBox.setNcSelectionne(true);
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length > 1) {
                    champMultiCheckBox.setAutreLabel(definitionSplit[0]);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definitionSplit[1]));
                } else {
                    champMultiCheckBox.setAutreLabel(null);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definition));
                }
                c = champMultiCheckBox;
                break;
            }
            case "GLSMultiCheckBox": {
                ChampMultiCheckBox champMultiCheckBox = new ChampMultiCheckBox(nom);
                champMultiCheckBox.setNcValeur(null);
                champMultiCheckBox.setValeursSelectionnee(new ArrayList(0));
                String[] definitionSplit = definition.split(":");
                if (MetierCommun.estValeurSysteme((String)definition)) {
                    champMultiCheckBox.setValeursSystemes(definition);
                } else {
                    champMultiCheckBox.setValeursSystemes(null);
                }
                if (definitionSplit.length > 1) {
                    champMultiCheckBox.setAutreLabel(definitionSplit[0]);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definitionSplit[1]));
                } else {
                    champMultiCheckBox.setAutreLabel(null);
                    champMultiCheckBox.setValeurs(MetierCommun.getListe((String)definition));
                }
                c = champMultiCheckBox;
                break;
            }
            case "ComposantProcedurePatrouille": {
                MapDescription description = MapDescription.parse((String)definition);
                ChampPatrouilleProcedure champPP = new ChampPatrouilleProcedure(nom);
                champPP.setCompetences(MetierCommun.getListe((String)description.getString("competences", null)));
                champPP.setMesuresImmediate(MetierCommun.getListe((String)description.getString("mesuresPrisesReparation", null)));
                champPP.setMesureDifferee(MetierCommun.getListe((String)description.getString("mesuresPrisesSecurite", null)));
                champPP.setCompetenceCg(defaut);
                c = champPP;
                break;
            }
            case "ComposantVehiculesEnCause": {
                ChampVehiculeEnCause champVehiculeEnCause = new ChampVehiculeEnCause(nom);
                List valeurs = MetierCommun.getListe((String)definition);
                champVehiculeEnCause.setDisplayVl(valeurs.contains("vl"));
                champVehiculeEnCause.setDisplayPl(valeurs.contains("pl"));
                champVehiculeEnCause.setDisplayTmd(valeurs.contains("tmd"));
                champVehiculeEnCause.setDisplayVelo(valeurs.contains("velo"));
                champVehiculeEnCause.setDisplayMoto(valeurs.contains("moto"));
                champVehiculeEnCause.setDisplayScooter(valeurs.contains("scooter"));
                champVehiculeEnCause.setDisplayVtc(valeurs.contains("tc"));
                champVehiculeEnCause.setDisplayAutres(valeurs.contains("autres"));
                champVehiculeEnCause.setDisplayCampingCar(valeurs.contains("campingCar"));
                champVehiculeEnCause.setDisplayPietonCycle(valeurs.contains("pietonCycle"));
                champVehiculeEnCause.setDisplayDeuxRoues(valeurs.contains("deuxRoues"));
                champVehiculeEnCause.setDisplayCaravane(valeurs.contains("caravane"));
                champVehiculeEnCause.setDisplayTrain(valeurs.contains("train"));
                champVehiculeEnCause.setDisplayTramway(valeurs.contains("tramway"));
                champVehiculeEnCause.setDisplayEnginAgricole(valeurs.contains("enginAgricole"));
                champVehiculeEnCause.setDisplayAnimaux(valeurs.contains("animaux"));
                champVehiculeEnCause.setDisplayAutres(valeurs.contains("autres"));
                c = champVehiculeEnCause;
                break;
            }
            case "ComposantPrismAuto": {
                ChampMultiple champMultiple;
                c = champMultiple = new ChampMultiple(nom);
                break;
            }
            case "ComposantAlternat": {
                ChampAlternat champAlternat = new ChampAlternat(nom);
                c = champAlternat;
                break;
            }
            case "GLSCalendarBox": {
                MapDescription map;
                String[] definitionSplit = definition.split(":");
                if (definitionSplit.length == 1) {
                    map = MapDescription.newMap();
                    map.addValue("type=" + definition);
                    map.addValue("obligatoire=false");
                } else {
                    map = MapDescription.parse((String)definition);
                }
                switch (map.getString("type", "dateHeure")) {
                    case "dateHeure": 
                    case "0": {
                        ChampDateHeure champCalendrier = new ChampDateHeure(nom);
                        champCalendrier.setAfficheCheckBox(!map.getBoolean("obligatoire", false));
                        c = champCalendrier;
                        break block24;
                    }
                    case "1": 
                    case "date": {
                        c = new ChampDate(nom);
                        break block24;
                    }
                    case "2": 
                    case "heure": {
                        c = new ChampHeure(nom);
                        break block24;
                    }
                }
                throw new PrismBddConfigurationError("la description doit \u00eatre 0, 1 ou 2");
            }
            case "GLSCoucheBox": {
                Log.debug("Composant couchebox non impl\u00e9ment\u00e9.");
                ChampCoucheBox champCoucheBox = new ChampCoucheBox(nom);
                MapDescription description = MapDescription.parse((String)definition);
                champCoucheBox.setNomCouche(description.getString("nomCouche", null));
                champCoucheBox.setChampCouche(description.getInt("champCouche", -1));
                champCoucheBox.setDistanceRecherche(description.getDouble("distanceRecherche", 500.0));
                c = champCoucheBox;
                break;
            }
            case "ComposantImages": {
                ChampImages champImages = new ChampImages(nom);
                c = champImages;
                break;
            }
            case "ComposantSignature": {
                ChampSignature champSignature = new ChampSignature(nom);
                c = champSignature;
                break;
            }
            case "ComposantDocuments": {
                ChampDocuments champDocuments = new ChampDocuments(nom);
                c = champDocuments;
                break;
            }
            case "systeme": {
                if (GLS.egal((String)"description", (String)nom)) {
                    ChampDropListe champDropListe = new ChampDropListe(nom);
                    ArrayList<String> valeurs = new ArrayList<String>();
                    valeurs.add("");
                    champDropListe.setValeurs(valeurs);
                    champDropListe.setIndexSelectionnee(0);
                    ((ValeurChampCollectionChoixUnique)champDropListe.getValeurChamp()).setValeur((String)valeurs.get(0));
                    c = champDropListe;
                    break;
                }
                if (GLS.egal((String)"localisation", (String)nom)) {
                    ChampLocalisation champLocalisation = new ChampLocalisation();
                    champLocalisation.setPrDebut(-1);
                    champLocalisation.setPrFin(-1);
                    champLocalisation.setAbsPrDebut(-1);
                    champLocalisation.setAbsPrFin(-1);
                    champLocalisation.setX(new float[0]);
                    champLocalisation.setY(new float[0]);
                    champLocalisation.setSensPr(1);
                    champLocalisation.setLocalisationParGps(true);
                    c = champLocalisation;
                    break;
                }
                throw new PrismBddConfigurationError("Type de champ non g\u00e9r\u00e9 : " + type);
            }
            default: {
                throw new PrismBddConfigurationError("Type de champ non g\u00e9r\u00e9 : " + type);
            }
        }
        if (c != null) {
            c.setLibelle(cb.getLibelle());
            c.setRestrictions(RestrictionFactory.getRestrictions(restrictions));
            c.setStyle(style);
            c.setHauteur(hauteur);
            if (this.correspondanceComposantChamp == null) {
                this.correspondanceComposantChamp = new HashMap<String, String>();
            }
            this.correspondanceComposantChamp.put(c.getNom(), type);
        } else if (type != "systeme") {
            Log.debug("champ non g\u00e9r\u00e9 : " + nom + " de type " + type);
        } else {
            Log.info("champ syst\u00e8me : " + nom + " de type " + type);
        }
        return c;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ComposantBean getComposant(String nom, boolean withZoneRoutiere) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<ComposantBean> getListComposants(boolean withZoneRoutiere) {
        ArrayList<ComposantBean> liste = new ArrayList<ComposantBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(this.SQL_LISTE_COMPOSANTS);
                if (withZoneRoutiere) {
                    req.append(" WHERE zone_routiere = ? ");
                }
                req.append(" order by libelle");
                pstm = connection.prepareStatement(req.toString());
                if (withZoneRoutiere) {
                    pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ComposantBean c = new ComposantBean();
                    c.setNom(rs.getString("nom"));
                    c.setLibelle(rs.getString("libelle"));
                    c.setDefinition(rs.getString("definition"));
                    c.setType(rs.getString("type"));
                    c.setParent(rs.getString("parent"));
                    c.setHauteur(Integer.valueOf(rs.getInt("hauteur")));
                    c.setZoneRoutiere(rs.getString("zone_routiere"));
                    if (rs.getObject("style") != null) {
                        c.setStyle(Integer.valueOf(rs.getInt("style")));
                    }
                    if (rs.getObject("indice") != null) {
                        c.setIndice(Integer.valueOf(rs.getInt("indice")));
                    }
                    c.setDefaut(rs.getString("defaut"));
                    c.setRestrictions(rs.getString("restrictions"));
                    try {
                        c.setChamp(this.lireChamp(c));
                        liste.add(c);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<ComposantNatureCommunBean> getListComposantsCommun(FiltreComposantNatureCommunBean filtre) {
        ArrayList<ComposantNatureCommunBean> liste = new ArrayList<ComposantNatureCommunBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(this.SQL_LISTE_COMPOSANTS_COMMUN);
                boolean and = false;
                if (filtre.getNomComposant() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("nom_composant = ? ");
                }
                if (filtre.getNomOnglet() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("nom_onglet = ? ");
                }
                req.append(" ORDER BY indice");
                pstm = connection.prepareStatement(req.toString());
                int i = 1;
                if (filtre.getNomComposant() != null) {
                    pstm.setString(i++, filtre.getNomComposant());
                }
                if (filtre.getNomOnglet() != null) {
                    pstm.setString(i++, filtre.getNomOnglet());
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ComposantNatureCommunBean n = new ComposantNatureCommunBean();
                    n.setIsComposantCommun(Boolean.valueOf(true));
                    n.setNomComposant(rs.getString("nom_composant"));
                    n.setZoneRoutiere(rs.getString("zone_routiere"));
                    n.setNomOnglet(rs.getString("nom_onglet"));
                    n.setIndice(rs.getInt("indice"));
                    n.setLibelle(rs.getString("libelle"));
                    n.setLargeur(rs.getInt("largeur"));
                    n.setType(rs.getString("type"));
                    n.setRedefinition(rs.getString("redefinition"));
                    n.setCodeModuleMetier(rs.getInt("code_module_metier"));
                    liste.add(n);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<ComposantNatureCommunBean> getListComposantsNature(FiltreComposantNatureCommunBean filtre) {
        ArrayList<ComposantNatureCommunBean> liste = new ArrayList<ComposantNatureCommunBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(this.SQL_LISTE_COMPOSANTS_NATURE);
                boolean and = false;
                if (filtre.getCodeNature() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("code_nature = ? ");
                }
                if (filtre.getNomComposant() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("nom_composant = ? ");
                }
                if (filtre.getNomOnglet() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("nom_onglet = ? ");
                }
                req.append(" ORDER BY indice");
                pstm = connection.prepareStatement(req.toString());
                int i = 1;
                if (filtre.getCodeNature() != null) {
                    pstm.setString(i++, filtre.getCodeNature());
                }
                if (filtre.getNomComposant() != null) {
                    pstm.setString(i++, filtre.getNomComposant());
                }
                if (filtre.getNomOnglet() != null) {
                    pstm.setString(i++, filtre.getNomOnglet());
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ComposantNatureCommunBean n = new ComposantNatureCommunBean();
                    n.setIsComposantCommun(Boolean.valueOf(false));
                    n.setCodeNature(rs.getString("code_nature"));
                    n.setNomComposant(rs.getString("nom_composant"));
                    n.setZoneRoutiere(rs.getString("zone_routiere"));
                    n.setNomOnglet(rs.getString("nom_onglet"));
                    n.setIndice(rs.getInt("indice"));
                    n.setLargeur(rs.getInt("largeur"));
                    n.setType(rs.getString("type"));
                    n.setRedefinition(rs.getString("redefinition"));
                    liste.add(n);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public boolean creerNatureBean(NatureBean nature) {
        boolean ret = false;
        String requete = "INSERT INTO nature_perso (zone_routiere, code, libelle, active, code_categorie, code_module_metier, indice) VALUES (?,?,?,?,?,?,?) RETURNING code";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet res = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, nature.getCode());
                pstm.setString(3, nature.getLibelle());
                pstm.setBoolean(4, nature.isActive());
                pstm.setString(5, nature.getCodeCategorie());
                pstm.setInt(6, nature.getCodeModuleMetier());
                pstm.setInt(7, nature.getIndice());
                res = pstm.executeQuery();
                if (res.next()) {
                    FiltreComposantNatureCommunBean filtre = new FiltreComposantNatureCommunBean();
                    filtre.setZoneRoutiere(ConfigurationFactory.getInstance().get("zoneroutiere"));
                    HashMap<String, ComposantNatureCommunBean> mapCommuns = new HashMap<String, ComposantNatureCommunBean>();
                    for (ComposantNatureCommunBean com : this.getListComposantsCommun(filtre)) {
                        mapCommuns.put(com.getNomComposant(), com);
                    }
                    for (ComposantNatureCommunBean c : nature.getListeComposantsCommun()) {
                        if (!mapCommuns.containsKey(c.getNomComposant())) {
                            this.CreateComposantFromNature(nature, c);
                            continue;
                        }
                        Integer indice = c.getIndice();
                        Integer indiceCommun = ((ComposantNatureCommunBean)mapCommuns.get(c.getNomComposant())).getIndice();
                        String redefinition = c.getRedefinition();
                        String redefinitionCommun = ((ComposantNatureCommunBean)mapCommuns.get(c.getNomComposant())).getRedefinition();
                        if (redefinition == null && redefinitionCommun != null || redefinition != null && redefinitionCommun == null) {
                            this.UpdateComposantFromNature(nature, c);
                            continue;
                        }
                        if (redefinition == null && redefinitionCommun == null || redefinition.equals(redefinitionCommun) && indice == indiceCommun) continue;
                        this.UpdateComposantFromNature(nature, c);
                    }
                    for (ComposantNatureCommunBean c : nature.getListeComposantsNature()) {
                        this.CreateComposantFromNature(nature, c);
                    }
                }
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, res);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, res);
        return ret;
    }

    @Override
    public boolean updateNatureBean(NatureBean nature) {
        boolean ret = false;
        String requete = "UPDATE nature_perso SET libelle=?,active=?,code_categorie=?,code_module_metier=?,indice=?  WHERE zone_routiere=? AND code=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, nature.getLibelle());
                pstm.setBoolean(2, nature.isActive());
                pstm.setString(3, nature.getCodeCategorie());
                pstm.setInt(4, nature.getCodeModuleMetier());
                pstm.setInt(5, nature.getIndice());
                pstm.setString(6, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(7, nature.getCode());
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public List<DescriptionNatureBean> getListDescriptionsNature(FiltreDescriptionNatureBean filtre) {
        ArrayList<DescriptionNatureBean> liste = new ArrayList<DescriptionNatureBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(this.SQL_LISTE_DESCRIPTIONS_NATURE);
                boolean and = false;
                if (filtre.getCode() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("code = ? ");
                }
                if (filtre.getNature() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("nature = ? ");
                }
                if (filtre.getZoneRoutiere() != null) {
                    if (and) {
                        req.append(" AND ");
                    } else {
                        req.append(" WHERE ");
                    }
                    and = true;
                    req.append("zone_routiere = ? ");
                }
                req.append(" ORDER BY indice");
                pstm = connection.prepareStatement(req.toString());
                int i = 1;
                if (filtre.getCode() != null) {
                    pstm.setString(i++, filtre.getCode());
                }
                if (filtre.getNature() != null) {
                    pstm.setString(i++, filtre.getNature());
                }
                if (filtre.getZoneRoutiere() != null) {
                    pstm.setString(i++, filtre.getZoneRoutiere());
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    DescriptionNatureBean n = new DescriptionNatureBean();
                    n.setZoneRoutiere(rs.getString("zone_routiere"));
                    n.setCode(rs.getString("code"));
                    n.setLibelle(rs.getString("libelle"));
                    n.setNature(rs.getString("nature"));
                    n.setIndice(rs.getInt("indice"));
                    liste.add(n);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public boolean createDescriptionNature(DescriptionNatureBean d) {
        boolean ret = false;
        String requete = "INSERT INTO description_nature_perso (zone_routiere, code, libelle, nature, indice) VALUES (?,?,?,?,?) RETURNING code";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet res = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, d.getCode());
                pstm.setString(3, d.getLibelle());
                pstm.setString(4, d.getNature());
                pstm.setInt(5, d.getIndice());
                res = pstm.executeQuery();
                if (res.next()) {
                    ret = true;
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, res);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, res);
        return ret;
    }

    @Override
    public boolean updateDescriptionNature(DescriptionNatureBean d) {
        boolean ret = false;
        String requete = "UPDATE description_nature_perso SET libelle=?,indice=? WHERE zone_routiere=? AND code=? AND nature=?";
        String requeteEvent = "UPDATE evenement SET description=? WHERE departement=? AND phr=? AND dob=?";
        String requeteEventValope = "update evenement set valopedate = now(), mst=now() where etat=1 and fin is null and departement=? AND phr=? AND dob=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                try {
                    try {
                        pstm = connection.prepareStatement(requete);
                        pstm.setString(1, d.getLibelle());
                        pstm.setInt(2, d.getIndice());
                        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                        pstm.setString(4, d.getCode());
                        pstm.setString(5, d.getNature());
                        pstm.execute();
                        ret = true;
                    }
                    catch (SQLException e) {
                        if (connection != null) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw new DAOException(e);
                    }
                }
                finally {
                    DAOUtil.close(null, pstm);
                }
                try {
                    try {
                        pstm = connection.prepareStatement(requeteEvent);
                        pstm.setString(1, d.getLibelle());
                        pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                        pstm.setString(3, d.getCode());
                        pstm.setString(4, d.getNature());
                        pstm.execute();
                        ret = true;
                    }
                    catch (SQLException e) {
                        if (connection != null) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw new DAOException(e);
                    }
                }
                finally {
                    DAOUtil.close(null, pstm);
                }
                try {
                    try {
                        pstm = connection.prepareStatement(requeteEventValope);
                        pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                        pstm.setString(2, d.getCode());
                        pstm.setString(3, d.getNature());
                        pstm.execute();
                        ret = true;
                    }
                    catch (SQLException e) {
                        if (connection != null) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw new DAOException(e);
                    }
                }
                finally {
                    DAOUtil.close(null, pstm);
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, null);
        }
        return ret;
    }

    @Override
    public boolean deleteDescriptionNature(DescriptionNatureBean d) {
        boolean ret = false;
        String requete = "DELETE FROM description_nature_perso WHERE zone_routiere=? AND code=? AND nature=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, d.getCode());
                pstm.setString(3, d.getNature());
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public boolean creerComposantBean(ComposantBean c) {
        boolean ret = false;
        String requete = "INSERT INTO composant (nom, libelle, definition, type, parent, hauteur, zone_routiere, style, indice, defaut, restrictions) VALUES (?,?,?,?,?,?,?,?,?,?,?) RETURNING nom";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet res = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setString(1, c.getNom());
                if (c.getLibelle() != null) {
                    pstm.setString(2, c.getLibelle());
                } else {
                    pstm.setNull(2, 1);
                }
                if (c.getDefinition() != null) {
                    pstm.setString(3, c.getDefinition());
                } else {
                    pstm.setNull(3, 1);
                }
                pstm.setString(4, c.getType());
                if (!Util.isNullOrEmpty((String)c.getParent())) {
                    pstm.setString(5, c.getParent());
                } else {
                    pstm.setNull(5, 1);
                }
                if (c.getHauteur() != null) {
                    pstm.setInt(6, c.getHauteur());
                } else {
                    pstm.setInt(6, -1);
                }
                pstm.setString(7, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (c.getStyle() != null) {
                    pstm.setInt(8, c.getStyle());
                } else {
                    pstm.setNull(8, 4);
                }
                if (c.getIndice() != null) {
                    pstm.setInt(9, c.getIndice());
                } else {
                    pstm.setNull(9, 4);
                }
                if (c.getDefaut() != null) {
                    pstm.setString(10, c.getDefaut());
                } else {
                    pstm.setNull(10, 1);
                }
                if (c.getRestrictions() != null) {
                    pstm.setString(11, c.getRestrictions());
                } else {
                    pstm.setNull(11, 1);
                }
                res = pstm.executeQuery();
                if (res.next()) {
                    ret = true;
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, res);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, res);
        return ret;
    }

    @Override
    public boolean updateComposantBean(ComposantBean c) {
        boolean ret = false;
        String requete = "UPDATE composant SET libelle=?,definition=?,type=?,parent=?,hauteur=?,style=?,indice=?,defaut=?,restrictions=? WHERE zone_routiere=? AND nom=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                if (c.getLibelle() != null) {
                    pstm.setString(1, c.getLibelle());
                } else {
                    pstm.setNull(1, 1);
                }
                if (c.getDefinition() != null) {
                    pstm.setString(2, c.getDefinition());
                } else {
                    pstm.setNull(2, 1);
                }
                pstm.setString(3, c.getType());
                if (!Util.isNullOrEmpty((String)c.getParent())) {
                    pstm.setString(4, c.getParent());
                } else {
                    pstm.setNull(4, 1);
                }
                if (c.getHauteur() != null) {
                    pstm.setInt(5, c.getHauteur());
                } else {
                    pstm.setInt(5, -1);
                }
                if (c.getStyle() != null) {
                    pstm.setInt(6, c.getStyle());
                } else {
                    pstm.setNull(6, 4);
                }
                if (c.getIndice() != null) {
                    pstm.setInt(7, c.getIndice());
                } else {
                    pstm.setNull(7, 4);
                }
                if (c.getDefaut() != null) {
                    pstm.setString(8, c.getDefaut());
                } else {
                    pstm.setNull(8, 1);
                }
                if (c.getRestrictions() != null) {
                    pstm.setString(9, c.getRestrictions());
                } else {
                    pstm.setNull(9, 1);
                }
                pstm.setString(10, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(11, c.getNom());
                pstm.execute();
                ret = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return ret;
    }

    @Override
    public void publierBarreauxVH(List<BarreauVH> barreaux) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                for (BarreauVH barreau : barreaux) {
                    this.publierBarreauVH(connection, barreau, true);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    @Override
    public void depublierBarreauxVH(List<BarreauVH> barreaux) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                for (BarreauVH barreau : barreaux) {
                    this.publierBarreauVH(connection, barreau, false);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection);
            throw throwable;
        }
        DAOUtil.close(connection);
    }

    private void publierBarreauVH(Connection connection, BarreauVH barreau, boolean publie) {
        String requeteVH = "UPDATE vh.donnees_vh_troncon SET publie=? WHERE id=?";
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement(requeteVH);
                boolean i = true;
                pstm.setBoolean(1, publie);
                pstm.setInt(2, Integer.valueOf(barreau.getId()));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(null, pstm);
        }
    }

    @Override
    public List<NiveauExploitation> getNiveauExploitation(List<FiltreJava> filtresJava) throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<NiveauExploitation> niveauxExploitation = new ArrayList<NiveauExploitation>();
        String filtre = "";
        for (FiltreJava f : filtresJava) {
            filtre = String.valueOf(filtre) + " AND " + f.getChampNom() + " = ?";
        }
        String SQL_NIVEAU_EXPLOITATION = "SELECT n.*, max(date_heure_loc) as date_dernier_passage, donnees_metier.generate_indicator(niveau,  max(date_heure_loc)) as indicateur FROM donnees_metier.niveau_exploitation n, prism.localisation l WHERE n.axe = l.axe AND n.prdebut <= l.pr::integer AND n.abscisseprdebut <= l.abscisse_pr AND n.prfin >= l.pr::integer AND n.abscisseprfin >= l.abscisse_pr " + filtre + " GROUP BY n.id" + " UNION " + "SELECT n1.*, null, 2 as indicateur  from donnees_metier.niveau_exploitation n1 WHERE n1.id not IN (SELECT n.id FROM donnees_metier.niveau_exploitation n, prism.localisation l\t" + "WHERE n.axe = l.axe AND n.prdebut <= l.pr::integer AND n.abscisseprdebut <= l.abscisse_pr AND n.prfin >= l.pr::integer AND n.abscisseprfin >= l.abscisse_pr  GROUP BY n.id) " + filtre;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_NIVEAU_EXPLOITATION);
                int i = 0;
                while (i < filtresJava.size()) {
                    pstm.setString(i + 1, filtresJava.get(i).getValeur().toString());
                    pstm.setString(i + 1 + filtresJava.size(), filtresJava.get(i).getValeur().toString());
                    ++i;
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    NiveauExploitation niveauExploitation = new NiveauExploitation();
                    niveauExploitation.setCode(rs.getString("id"));
                    niveauExploitation.setDescription(rs.getString("description"));
                    niveauExploitation.setAxe(rs.getString("axe"));
                    niveauExploitation.setPrDeb(rs.getString("prdebut"));
                    niveauExploitation.setPrFin(rs.getString("prfin"));
                    niveauExploitation.setAbscisseDeb(rs.getInt("abscisseprdebut"));
                    niveauExploitation.setAbscisseFin(rs.getInt("abscisseprfin"));
                    niveauExploitation.setNiveau(rs.getString("niveau"));
                    if (rs.getDate("date_dernier_passage") != null) {
                        niveauExploitation.setDate(rs.getDate("date_dernier_passage").getTime());
                    }
                    niveauExploitation.setCentre("");
                    niveauExploitation.setDelegation("");
                    niveauExploitation.setIndicateur(rs.getInt("indicateur"));
                    niveauxExploitation.add(niveauExploitation);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return niveauxExploitation;
    }

    @Override
    public List<CircuitExploitation> getCircuitExploitation(String d, String c, Date debut, Date fin) throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String filtre = "";
        String filtre2 = "";
        String filtre3 = "";
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<String> params2 = new ArrayList<String>();
        if (d != null) {
            filtre = String.valueOf(filtre) + " AND delegation = ?";
            params.add(d);
            filtre3 = String.valueOf(filtre3) + " AND delegation = ?";
            params2.add(d);
        }
        if (c != null) {
            filtre = String.valueOf(filtre) + " AND centre = ?";
            params.add(c);
            filtre3 = String.valueOf(filtre3) + " AND centre = ?";
            params2.add(c);
        }
        if (debut != null) {
            filtre = String.valueOf(filtre) + " AND debut >= ?";
            params.add(debut.getTime());
        }
        if (fin != null) {
            filtre = String.valueOf(filtre) + " AND debut <= ?";
            params.add(fin.getTime());
            filtre2 = String.valueOf(filtre2) + ", ?";
        }
        ArrayList<CircuitExploitation> circuitsExploitation = new ArrayList<CircuitExploitation>();
        String SQL_CIRCUIT_EXPLOITATION = "SELECT c.*, p.fin as date_realisation, donnees_metier.generate_indicator(c.niveau, fin $2) as indicateur, (SELECT valeur::int from prism.configuration where champ = ('niveau_exploitation_'||niveau)) as frequence FROM prism.circuit c, prism.patrouille p where (id_circuit, fin) in (select id_circuit, max(fin) FROM prism.patrouille WHERE type = 0 $1 group by id_circuit) and p.id_circuit = c.id and c.systeme = 0 ";
        SQL_CIRCUIT_EXPLOITATION = String.valueOf(SQL_CIRCUIT_EXPLOITATION) + " UNION SELECT c.*, null as date_realisation, 0 as indicateur, (SELECT valeur::int from prism.configuration where champ = ('niveau_exploitation_'||niveau)) as frequence FROM prism.circuit c where (c.id) not in (select id_circuit FROM prism.patrouille WHERE type = 0 $1) and c.systeme = 0 and c.type = 0 $3";
        SQL_CIRCUIT_EXPLOITATION = SQL_CIRCUIT_EXPLOITATION.replace("$1", filtre);
        SQL_CIRCUIT_EXPLOITATION = SQL_CIRCUIT_EXPLOITATION.replace("$2", filtre2);
        SQL_CIRCUIT_EXPLOITATION = SQL_CIRCUIT_EXPLOITATION.replace("$3", filtre3);
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_CIRCUIT_EXPLOITATION);
                if (fin != null) {
                    pstm.setDate(1, new java.sql.Date(fin.getTime()));
                } else {
                    pstm.setDate(1, new java.sql.Date(new Date().getTime()));
                }
                int i = 1;
                while (i < params.size() + 1) {
                    Object o = params.get(i - 1);
                    if (o instanceof String) {
                        pstm.setString(i + 1, o.toString());
                        pstm.setString(i + 1 + params.size(), o.toString());
                    } else {
                        pstm.setDate(i + 1, new java.sql.Date(Long.valueOf(o.toString())));
                        pstm.setDate(i + 1 + params.size(), new java.sql.Date(Long.valueOf(o.toString())));
                    }
                    ++i;
                }
                i = 0;
                while (i < params2.size()) {
                    pstm.setString(i + 2 + params.size() * 2, params.get(i).toString());
                    ++i;
                }
                rs = pstm.executeQuery();
                Log.info(pstm);
                while (rs.next()) {
                    CircuitExploitation circuitExploitation = new CircuitExploitation();
                    if (rs.getDate("date_realisation") != null) {
                        circuitExploitation.setDateDernierPassage(rs.getDate("date_realisation").getTime());
                    } else {
                        circuitExploitation.setDateDernierPassage(-1L);
                    }
                    circuitExploitation.setNiveau(rs.getString("niveau"));
                    circuitExploitation.setIndicateur(rs.getInt("indicateur"));
                    circuitExploitation.setFrequence(rs.getInt("frequence"));
                    Circuit circuit = new Circuit();
                    circuit.setId(String.valueOf(rs.getInt("id")));
                    circuit.setCentre(rs.getString("centre"));
                    circuit.setDelegation(rs.getString("delegation"));
                    circuit.setNom(rs.getString("nom"));
                    circuit.setType(String.valueOf(rs.getString("type")));
                    circuit.setArchive(rs.getInt("archive") != 0);
                    circuitExploitation.setCircuit(circuit);
                    circuitsExploitation.add(circuitExploitation);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return circuitsExploitation;
    }

    @Override
    public List<CircuitExploitation> getFrequenceCircuitExploitation(Date debut, Date fin) throws DAOException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<CircuitExploitation> circuitsExploitation = new ArrayList<CircuitExploitation>();
        String SQL_FREQUENCE_CIRCUIT_EXPLOITATION = "SELECT id, nom, type, archive, delegation, centre, niveau, (SELECT valeur::int from prism.configuration where champ = ('niveau_exploitation_'||niveau)) as frequence, (SELECT COUNT(id) FROM patrouille WHERE patrouille.id_circuit = circuit.id AND debut BETWEEN ? AND ?) as nb_patrouilles FROM circuit WHERE systeme = 0";
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_FREQUENCE_CIRCUIT_EXPLOITATION);
                pstm.setDate(1, new java.sql.Date(debut.getTime()));
                pstm.setDate(2, new java.sql.Date(fin.getTime()));
                rs = pstm.executeQuery();
                Log.info(pstm);
                while (rs.next()) {
                    CircuitExploitation circuitExploitation = new CircuitExploitation();
                    circuitExploitation.setNiveau(rs.getString("niveau"));
                    circuitExploitation.setFrequence(rs.getInt("frequence"));
                    circuitExploitation.setNbPatrouilles(rs.getInt("nb_patrouilles"));
                    Circuit circuit = new Circuit();
                    circuit.setId(String.valueOf(rs.getInt("id")));
                    circuit.setCentre(rs.getString("centre"));
                    circuit.setDelegation(rs.getString("delegation"));
                    circuit.setNom(rs.getString("nom"));
                    circuit.setType(String.valueOf(rs.getString("type")));
                    circuit.setArchive(rs.getInt("archive") != 0);
                    circuitExploitation.setCircuit(circuit);
                    circuitsExploitation.add(circuitExploitation);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return circuitsExploitation;
    }

    @Override
    public List<CircuitExploitation> getCircuitsAnomalies(String division, String district, String departement, Date dateJourDebut, Date dateJourFin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<CircuitExploitation> circuitsExploitation = new ArrayList<CircuitExploitation>();
        String filtre = "";
        ArrayList<String> params = new ArrayList<String>();
        if (division != null) {
            filtre = String.valueOf(filtre) + " AND delegation = ?";
            params.add(division);
        }
        if (district != null) {
            filtre = String.valueOf(filtre) + " AND centre = ?";
            params.add(district);
        }
        String SQL_ANOMALIES_CIRCUIT_EXPLOITATION = "SELECT id, nom, type, archive, delegation, centre, niveau, (SELECT valeur::int from prism.configuration where champ = ('niveau_exploitation_'||niveau)) as frequence FROM circuit WHERE systeme = 0 $1";
        SQL_ANOMALIES_CIRCUIT_EXPLOITATION = SQL_ANOMALIES_CIRCUIT_EXPLOITATION.replace("$1", filtre);
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_ANOMALIES_CIRCUIT_EXPLOITATION);
                int i = 0;
                while (i < params.size()) {
                    Object o = params.get(i);
                    if (o instanceof String) {
                        pstm.setString(i + 1, o.toString());
                    } else {
                        pstm.setDate(i + 1, new java.sql.Date(Long.valueOf(o.toString())));
                    }
                    ++i;
                }
                Log.info(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    CircuitExploitation circuitExploitation = new CircuitExploitation();
                    circuitExploitation.setNiveau(rs.getString("niveau"));
                    circuitExploitation.setFrequence(rs.getInt("frequence"));
                    Circuit circuit = new Circuit();
                    circuit.setId(String.valueOf(rs.getInt("id")));
                    circuit.setCentre(rs.getString("centre"));
                    circuit.setDelegation(rs.getString("delegation"));
                    circuit.setNom(rs.getString("nom"));
                    circuit.setType(String.valueOf(rs.getString("type")));
                    circuit.setArchive(rs.getInt("archive") != 0);
                    circuitExploitation.setCircuit(circuit);
                    circuitsExploitation.add(circuitExploitation);
                }
                this.updateAnomalies(connection, circuitsExploitation, dateJourDebut, dateJourFin);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return circuitsExploitation;
    }

    private void updateAnomalies(Connection connection, List<CircuitExploitation> circuitsExploitation, Date dateDebut, Date dateFin) {
        String SQL_ANOMALIES_RELIQUAT = null;
        String SQL_ANOMALIES_SOLDE = null;
        String SQL_ANOMALIES_NOUVELLES = null;
        String SQL_ANOMALIES_TRAITEES = null;
        String SQL_ANOMALIES_TRAITEES_TMP = null;
        PreparedStatement pstm = null;
        PreparedStatement pstm2 = null;
        PreparedStatement pstm3 = null;
        PreparedStatement pstm4 = null;
        PreparedStatement pstm5 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        ResultSet rs4 = null;
        ResultSet rs5 = null;
        HashMap<String, Integer> mapReliquat = new HashMap<String, Integer>();
        HashMap<String, Integer> mapSolde = new HashMap<String, Integer>();
        HashMap<String, Integer> mapNouvelles = new HashMap<String, Integer>();
        HashMap<String, Integer> mapAnomaliesTraitees = new HashMap<String, Integer>();
        HashMap<String, Integer> mapAnomaliesTraiteesTmp = new HashMap<String, Integer>();
        SQL_ANOMALIES_RELIQUAT = "SELECT p2.id_circuit, COUNT(*) as reliquat FROM evenement e2, patrouille p2 WHERE (id_circuit, snm, erf, vnm) IN (SELECT distinct p.id_circuit, snm, erf, MAX(vnm) FROM evenement e, patrouille p WHERE p.id = e.id_patrouille AND e.inp < ? GROUP BY snm, erf, id_circuit) AND e2.fin IS NULL AND e2.id_patrouille = p2.id GROUP BY p2.id_circuit;";
        SQL_ANOMALIES_SOLDE = "SELECT p2.id_circuit, COUNT(*) as solde FROM evenement e2, patrouille p2 WHERE (id_circuit, snm, erf, vnm) IN (SELECT distinct p.id_circuit, snm, erf, MAX(vnm) FROM evenement e, patrouille p WHERE p.id = e.id_patrouille AND e.inp >= ? AND e.inp < ? GROUP BY snm, erf, id_circuit) AND e2.fin IS NULL AND e2.id_patrouille = p2.id GROUP BY p2.id_circuit;";
        SQL_ANOMALIES_NOUVELLES = "SELECT p2.id_circuit, COUNT(*) as nouvelles FROM evenement e2, patrouille p2 WHERE (id_circuit, snm, erf, vnm) IN (SELECT distinct p.id_circuit, snm, erf, MAX(vnm) FROM evenement e, patrouille p WHERE p.id = e.id_patrouille AND e.sta >= ? AND e.sta < ? GROUP BY snm, erf, id_circuit) AND e2.id_patrouille = p2.id GROUP BY p2.id_circuit;";
        SQL_ANOMALIES_TRAITEES = "SELECT p2.id_circuit, COUNT(*) as traitees FROM evenement e2, patrouille p2 WHERE (id_circuit, snm, erf, vnm) IN (SELECT distinct p.id_circuit, snm, erf, MAX(vnm) FROM evenement e, patrouille p WHERE p.id = e.id_patrouille AND e.inp >= ? AND e.inp < ? GROUP BY snm, erf, id_circuit) AND e2.fin = 'Y' AND e2.id_patrouille = p2.id GROUP BY p2.id_circuit;";
        SQL_ANOMALIES_TRAITEES_TMP = "SELECT p2.id_circuit, COUNT(*) as traitees_tmp FROM evenement e2, patrouille p2 WHERE (id_circuit, snm, erf, vnm) IN (SELECT distinct p.id_circuit, snm, erf, MAX(vnm) FROM evenement e, patrouille p WHERE p.id = e.id_patrouille AND e.inp >= ? AND e.inp < ? GROUP BY snm, erf, id_circuit) AND e2.fin IS NULL AND e2.id_patrouille = p2.id GROUP BY p2.id_circuit;";
        try {
            try {
                pstm = connection.prepareStatement(SQL_ANOMALIES_RELIQUAT);
                pstm.setDate(1, new java.sql.Date(dateDebut.getTime()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    mapReliquat.put(String.valueOf(rs.getInt("id_circuit")), rs.getInt("reliquat"));
                }
                pstm2 = connection.prepareStatement(SQL_ANOMALIES_SOLDE);
                pstm2.setDate(1, new java.sql.Date(dateFin.getTime()));
                pstm2.setDate(1, new java.sql.Date(dateDebut.getTime()));
                pstm2.setDate(2, new java.sql.Date(dateFin.getTime()));
                Log.info(pstm2);
                rs2 = pstm2.executeQuery();
                while (rs2.next()) {
                    mapSolde.put(String.valueOf(rs2.getInt("id_circuit")), rs2.getInt("solde"));
                }
                pstm3 = connection.prepareStatement(SQL_ANOMALIES_NOUVELLES);
                pstm3.setDate(1, new java.sql.Date(dateDebut.getTime()));
                pstm3.setDate(2, new java.sql.Date(dateFin.getTime()));
                rs3 = pstm3.executeQuery();
                while (rs3.next()) {
                    mapNouvelles.put(String.valueOf(rs3.getInt("id_circuit")), rs3.getInt("nouvelles"));
                }
                pstm4 = connection.prepareStatement(SQL_ANOMALIES_TRAITEES);
                pstm4.setDate(1, new java.sql.Date(dateDebut.getTime()));
                pstm4.setDate(2, new java.sql.Date(dateFin.getTime()));
                rs4 = pstm4.executeQuery();
                while (rs4.next()) {
                    mapAnomaliesTraitees.put(String.valueOf(rs4.getInt("id_circuit")), rs4.getInt("traitees"));
                }
                pstm5 = connection.prepareStatement(SQL_ANOMALIES_TRAITEES_TMP);
                pstm5.setDate(1, new java.sql.Date(dateDebut.getTime()));
                pstm5.setDate(2, new java.sql.Date(dateFin.getTime()));
                rs5 = pstm5.executeQuery();
                while (rs5.next()) {
                    mapAnomaliesTraiteesTmp.put(String.valueOf(rs5.getInt("id_circuit")), rs5.getInt("traitees_tmp"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm, rs);
            DAOUtil.close(null, pstm2, rs2);
            DAOUtil.close(null, pstm3, rs3);
            DAOUtil.close(null, pstm4, rs4);
            DAOUtil.close(null, pstm5, rs5);
            throw throwable;
        }
        DAOUtil.close(null, pstm, rs);
        DAOUtil.close(null, pstm2, rs2);
        DAOUtil.close(null, pstm3, rs3);
        DAOUtil.close(null, pstm4, rs4);
        DAOUtil.close(null, pstm5, rs5);
        for (CircuitExploitation circuitExploitation : circuitsExploitation) {
            if (mapReliquat.get(circuitExploitation.getCircuit().getId()) != null) {
                circuitExploitation.setReliquat(((Integer)mapReliquat.get(circuitExploitation.getCircuit().getId())).intValue());
            } else {
                circuitExploitation.setReliquat(0);
            }
            if (mapSolde.get(circuitExploitation.getCircuit().getId()) != null) {
                circuitExploitation.setSoldeAnomalies(((Integer)mapSolde.get(circuitExploitation.getCircuit().getId())).intValue());
            } else {
                circuitExploitation.setSoldeAnomalies(0);
            }
            if (mapNouvelles.get(circuitExploitation.getCircuit().getId()) != null) {
                circuitExploitation.setNouvellesAnomalies(((Integer)mapNouvelles.get(circuitExploitation.getCircuit().getId())).intValue());
            } else {
                circuitExploitation.setNouvellesAnomalies(0);
            }
            if (mapAnomaliesTraitees.get(circuitExploitation.getCircuit().getId()) != null) {
                circuitExploitation.setAnomaliesTraitees(((Integer)mapAnomaliesTraitees.get(circuitExploitation.getCircuit().getId())).intValue());
            } else {
                circuitExploitation.setAnomaliesTraitees(0);
            }
            if (mapAnomaliesTraiteesTmp.get(circuitExploitation.getCircuit().getId()) != null) {
                circuitExploitation.setAnomaliesTraiteesTmp(((Integer)mapAnomaliesTraiteesTmp.get(circuitExploitation.getCircuit().getId())).intValue());
                continue;
            }
            circuitExploitation.setAnomaliesTraiteesTmp(0);
        }
    }

    @Override
    public void updateTronconCircuit(Circuit v) {
        String REQUETE_DELETE = "delete from donnees_metier.troncon_circuit WHERE idcircuit = ?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                try {
                    try {
                        pstm = connection.prepareStatement(REQUETE_DELETE);
                        pstm.setInt(1, Integer.valueOf(v.getId()));
                        pstm.execute();
                    }
                    catch (SQLException e) {
                        if (connection != null) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        throw new DAOException(e);
                    }
                }
                finally {
                    DAOUtil.close(null, pstm);
                }
                if (v.getTroncons() != null && v.getTroncons().size() > 0) {
                    for (Troncon t : v.getTroncons()) {
                        if (v.getNiveauService() != null) {
                            t.setNiveauService(v.getNiveauService());
                        }
                        this.ajouterTroncon(connection, v.getId(), t);
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, null);
        }
    }

    @Override
    public List<Troncon> getCircuitTroncons(Circuit c) {
        return this.getTroncons(c, false, 0.0, false, true);
    }

    @Override
    public List<Troncon> getCircuitTroncons(Circuit c, boolean lateralized, double lateralizedValue, boolean obligatoireUniquement) {
        return this.getTroncons(c, lateralized, lateralizedValue, obligatoireUniquement, true);
    }

    @Override
    public List<Troncon> getCircuitTroncons(Circuit c, boolean lateralized, double lateralizedValue, boolean obligatoireUniquement, boolean avecGeometry) {
        return this.getTroncons(c, lateralized, lateralizedValue, obligatoireUniquement, avecGeometry);
    }

    @Override
    public void creerCircuitTroncons(Circuit v) {
        Connection connection = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                if (v.getTroncons() != null && v.getTroncons().size() > 0) {
                    for (Troncon t : v.getTroncons()) {
                        if (v.getNiveauService() != null) {
                            t.setNiveauService(v.getNiveauService());
                        }
                        this.ajouterTroncon(connection, v.getId(), t);
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, null);
        }
    }

    public boolean ajouterTroncon(Connection connection, String idCircuit, Troncon t) {
        String departementPrDebut = "";
        String departementPrFin = "";
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connection.prepareStatement("INSERT INTO donnees_metier.troncon_circuit (description,departementprdebut,axe,departementprfin,abscisseprdebut,prdebut,prfin,abscisseprfin,idcircuit,longueur,coordonnees, fk_niveau_service,obligatoire,grammage,largeur,sens,indice) VALUES (?,?,?,?,?,?,?,?,?,?,st_geometryfromtext(?,?),?,?,?,?,?,?)");
                pstm.setString(1, t.getDescription());
                pstm.setString(2, departementPrDebut);
                pstm.setString(3, t.getAxe());
                pstm.setString(4, departementPrFin);
                pstm.setInt(5, t.getAbscissePrDebut());
                pstm.setInt(6, t.getPrDebut());
                pstm.setInt(7, t.getPrFin());
                pstm.setInt(8, t.getAbscissePrFin());
                pstm.setInt(9, Integer.valueOf(idCircuit));
                pstm.setInt(10, t.getLongueur());
                String coordonnees = SQL.getGeometryLine((float[])t.getX(), (float[])t.getY());
                pstm.setString(11, coordonnees);
                pstm.setInt(12, 4326);
                if (t.getNiveauService() != null) {
                    pstm.setLong(13, t.getNiveauService());
                } else {
                    pstm.setNull(13, 4);
                }
                pstm.setBoolean(14, t.isObligatoire());
                if (t.isSalage()) {
                    pstm.setDouble(15, t.getGrammage());
                    pstm.setDouble(16, t.getLargeur());
                } else {
                    pstm.setNull(15, 8);
                    pstm.setNull(16, 8);
                }
                pstm.setInt(17, t.getSensNumerique());
                pstm.setInt(18, t.getIndice());
                pstm.execute();
            }
            catch (SQLException e) {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(null, pstm);
        }
        return true;
    }

    @Override
    public Map<Activite, List<Centre>> getCentresParActivite() {
        List<Activite> l = this.getActivites();
        HashMap<Activite, List<Centre>> m = new HashMap<Activite, List<Centre>>();
        if (!GLS.estVide(l)) {
            for (Activite a : l) {
                m.put(a, this.getCentresParActivite(a.getCode()));
            }
        }
        return m;
    }

    @Override
    public List<SyntheseTableauBordFrequencePatrouilleBean> getFrequencePatrouilleTroncons(Circuit circuit, Timestamp dateDebutInit, int bufferSize, double ratioParcours) {
        Calendar cal;
        ArrayList<SyntheseTableauBordFrequencePatrouilleBean> retour = new ArrayList<SyntheseTableauBordFrequencePatrouilleBean>();
        List<Troncon> troncons = this.getCircuitTroncons(circuit, false, 0.0, true);
        NiveauService niveauService = null;
        if (circuit.getNiveauService() != null) {
            for (NiveauService ns : this.getNiveauxService()) {
                if (ns.getId() != circuit.getNiveauService().longValue()) continue;
                niveauService = ns;
            }
        }
        HashMap<String, Integer> mapNbPassage = new HashMap<String, Integer>();
        HashMap<String, String> mapDernierPassage = new HashMap<String, String>();
        Timestamp dateDebut = dateDebutInit;
        Timestamp dateFin = null;
        int frequenceMin = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        if (niveauService != null) {
            cal = Calendar.getInstance();
            cal.setTime(dateDebut);
            if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.MOIS) {
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(11, 23);
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(2, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            } else if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.SEMAINE) {
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(11, 23);
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(4, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            } else {
                cal.add(7, niveauService.getNbPeriode());
                dateFin = new Timestamp(cal.getTimeInMillis());
            }
            if (niveauService.getTypePeriode() != NiveauService.EnumTypePeriode.JOUR || niveauService.getNbPeriode() != 1) {
                sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            }
            frequenceMin = niveauService.getFrequence();
        } else {
            cal = Calendar.getInstance();
            cal.setTime(dateDebut);
            cal.add(7, 1);
            dateFin = new Timestamp(cal.getTimeInMillis());
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.passage_troncon(?,?,?,?,?)");
                pstm.setInt(1, Integer.valueOf(circuit.getId()));
                pstm.setTimestamp(2, dateDebut);
                pstm.setTimestamp(3, dateFin);
                pstm.setInt(4, bufferSize);
                pstm.setObject(5, (Object)ratioParcours, 2);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Array arrayPassages = rs.getArray("date_dernier_passage");
                    Object[] derniersPassages = (Timestamp[])arrayPassages.getArray();
                    Arrays.sort(derniersPassages);
                    String dernierPassageString = "";
                    int i = 0;
                    while (i < derniersPassages.length) {
                        if (!"".equals(dernierPassageString)) {
                            dernierPassageString = String.valueOf(dernierPassageString) + ", ";
                        }
                        dernierPassageString = String.valueOf(dernierPassageString) + sdf.format(new Date(((Timestamp)derniersPassages[i]).getTime()));
                        ++i;
                    }
                    mapDernierPassage.put(String.valueOf(rs.getInt("id_troncon")), dernierPassageString);
                    mapNbPassage.put(String.valueOf(rs.getInt("id_troncon")), rs.getInt("nb_passage"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordFrequencePatrouilleBean(troncon.getId(), troncon.toString(), ((Integer)mapNbPassage.get(troncon.getId())).intValue(), frequenceMin, (String)mapDernierPassage.get(troncon.getId())));
        }
        return retour;
    }

    @Override
    public Rectangle2D getExtentCircuit(String circuitId) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            Rectangle2D rectangle2D;
            String requete = "SELECT st_expand(st_extent(coordonnees),0.01) AS extent FROM donnees_metier.troncon_circuit WHERE idcircuit = ? AND obligatoire = true";
            connection = null;
            pstm = null;
            rs = null;
            try {
                Object obj;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                pstm.setInt(1, Integer.valueOf(circuitId));
                rs = pstm.executeQuery();
                if (!rs.first() || (obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block4;
                Bounds b = new Bounds();
                PGbox2d ext = (PGbox2d)obj;
                Polygon p = new Polygon();
                Rectangle2D r = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                Log.debug(r.getHeight() + r.getWidth());
                b.setMaxx(ext.getURT().getX());
                b.setMinx(ext.getLLB().getX());
                b.setMaxy(ext.getURT().getY());
                b.setMiny(ext.getLLB().getY());
                rectangle2D = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2D;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public String getBarreauxJSON(boolean fromPublie) {
        ArrayList<BarreauVH> barreaux = new ArrayList<BarreauVH>();
        barreaux.addAll(this.getBarreauxFromWMS(fromPublie));
        barreaux.addAll(this.getBarreauxFromEvenementVHTable());
        if (this.getConfiguration().getBoolean("publication.donnees_externes.vh", false)) {
            barreaux.addAll(this.getBarreauxFromDonneesExternes());
        }
        StringBuilder geojson = new StringBuilder("{\"type\": \"FeatureCollection\",\"features\": [");
        NumberFormat df = DecimalFormat.getInstance(Locale.UK);
        df.setMaximumFractionDigits(5);
        boolean ajouterVirgule = false;
        int id = 0;
        for (BarreauVH barreau : barreaux) {
            String coordinates = "[";
            if (barreau.getXs() == null || barreau.getXs().size() <= 0) continue;
            Vector xs = barreau.getXs();
            Vector ys = barreau.getYs();
            int j = 0;
            while (j < xs.size()) {
                coordinates = String.valueOf(coordinates) + (j == 0 ? "" : ",") + "[";
                int i = 0;
                while (i < ((double[])xs.get(j)).length) {
                    coordinates = String.valueOf(coordinates) + (i == 0 ? "" : ",") + "[" + df.format(((double[])xs.get(j))[i]) + ", " + df.format(((double[])ys.get(j))[i]) + "]";
                    ++i;
                }
                coordinates = String.valueOf(coordinates) + "]";
                ++j;
            }
            coordinates = String.valueOf(coordinates) + "]";
            if (ajouterVirgule) {
                geojson.append(",");
            } else {
                ajouterVirgule = true;
            }
            String properties = "\"type\": \"BARREAU\"";
            properties = String.valueOf(properties) + ",\"id\": \"" + barreau.getId() + "\"";
            properties = String.valueOf(properties) + ",\"desc\": \"" + this.getStatus(barreau.getCch()) + "\"";
            properties = String.valueOf(properties) + ",\"maj\": \"" + barreau.getMajDate() + "\"";
            properties = String.valueOf(properties) + ",\"color\": \"" + this.getColor(barreau.getCch()) + "\"";
            properties = String.valueOf(properties) + ",\"network\": \"" + this.getNetwork(barreau.getClassification()) + "\"";
            properties = String.valueOf(properties) + ",\"width\": \"" + this.getWidth(barreau.getClassification()) + "\"";
            geojson.append("{\"id\":" + id++ + ", \"type\": \"Feature\",\"geometry\": {\"type\": \"MultiLineString\",\"coordinates\": " + coordinates + "},\"properties\": { " + properties + "} }");
        }
        geojson.append("]}");
        return geojson.toString();
    }

    private List<BarreauVH> getBarreauxFromEvenementVHTable() {
        ArrayList<BarreauVH> barreaux = new ArrayList<BarreauVH>();
        String requete = "SELECT  id,cch, now() AS maj, st_transform(coordonnees, 4326) as coordonnees FROM vh.evenement_vh  WHERE etat >= 1 AND id like 'ESVH%' ";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    troncon.setId(rs.getString("id"));
                    troncon.setCch(rs.getString("cch"));
                    troncon.setMajDate((Date)rs.getTimestamp("maj"));
                    try {
                        if (rs.getObject("coordonnees") != null) {
                            Vector<Double> xs = new Vector<Double>();
                            Vector<Double> ys = new Vector<Double>();
                            Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                            int k = 0;
                            while (k < coordPArGeometry.size()) {
                                Vector coord = (Vector)coordPArGeometry.get(k);
                                int nbPoint = coord.size();
                                int i = 0;
                                while (i < nbPoint) {
                                    xs.add(((Point2D.Double)coord.get((int)i)).x);
                                    ys.add(((Point2D.Double)coord.get((int)i)).y);
                                    ++i;
                                }
                                ++k;
                            }
                            float[] xf = new float[xs.size()];
                            float[] yf = new float[ys.size()];
                            int i = 0;
                            while (i < xf.length) {
                                xf[i] = new Double((Double)xs.get(i)).floatValue();
                                yf[i] = new Double((Double)ys.get(i)).floatValue();
                                ++i;
                            }
                            troncon.setX(xf);
                            troncon.setY(yf);
                            try {
                                Vector<double[]> xsML = new Vector<double[]>();
                                Vector<double[]> ysML = new Vector<double[]>();
                                int k2 = 0;
                                while (k2 < coordPArGeometry.size()) {
                                    Vector coord = (Vector)coordPArGeometry.get(k2);
                                    int nbPoint = coord.size();
                                    double[] x = new double[nbPoint];
                                    double[] y = new double[nbPoint];
                                    int i2 = 0;
                                    while (i2 < nbPoint) {
                                        x[i2] = ((Point2D.Double)coord.get((int)i2)).x;
                                        y[i2] = ((Point2D.Double)coord.get((int)i2)).y;
                                        ++i2;
                                    }
                                    xsML.add(x);
                                    ysML.add(y);
                                    ++k2;
                                }
                                troncon.setXs(xsML);
                                troncon.setYs(ysML);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception e) {
                        troncon.setX(null);
                        troncon.setY(null);
                    }
                    barreaux.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return barreaux;
    }

    private List<BarreauVH> getBarreauxFromWMS(boolean fromPublie) {
        ArrayList<BarreauVH> barreaux = new ArrayList<BarreauVH>();
        String requete = "";
        requete = fromPublie ? "SELECT d.id as id,d.cch as cch, d.date as maj,n.libelle as niveau,  t.coordonnees as coordonnees from (vh.donnees_vh_troncon_publie d inner join donnees_metier.troncon_circuit_ext t on t.id = d.id) left outer join niveau_service n on n.id = t.fk_niveau_service  where  not t.coordonnees is null ORDER BY date ASC" : "SELECT d.id as id,d.cch as cch, d.date as maj,n.libelle as niveau,  t.coordonnees as coordonnees from (vh.donnees_vh_troncon d inner join donnees_metier.troncon_circuit_ext t on t.id = d.id) left outer join niveau_service n on n.id = t.fk_niveau_service  where  not t.coordonnees is null ORDER BY date ASC";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    troncon.setId(rs.getString("id"));
                    troncon.setCch(rs.getString("cch"));
                    troncon.setClassification(rs.getString("niveau"));
                    troncon.setMajDate((Date)rs.getTimestamp("maj"));
                    try {
                        if (rs.getObject("coordonnees") != null) {
                            Vector<Double> xs = new Vector<Double>();
                            Vector<Double> ys = new Vector<Double>();
                            Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                            int k = 0;
                            while (k < coordPArGeometry.size()) {
                                Vector coord = (Vector)coordPArGeometry.get(k);
                                int nbPoint = coord.size();
                                int i = 0;
                                while (i < nbPoint) {
                                    xs.add(((Point2D.Double)coord.get((int)i)).x);
                                    ys.add(((Point2D.Double)coord.get((int)i)).y);
                                    ++i;
                                }
                                ++k;
                            }
                            float[] xf = new float[xs.size()];
                            float[] yf = new float[ys.size()];
                            int i = 0;
                            while (i < xf.length) {
                                xf[i] = new Double((Double)xs.get(i)).floatValue();
                                yf[i] = new Double((Double)ys.get(i)).floatValue();
                                ++i;
                            }
                            troncon.setX(xf);
                            troncon.setY(yf);
                            try {
                                Vector<double[]> xsML = new Vector<double[]>();
                                Vector<double[]> ysML = new Vector<double[]>();
                                int k2 = 0;
                                while (k2 < coordPArGeometry.size()) {
                                    Vector coord = (Vector)coordPArGeometry.get(k2);
                                    int nbPoint = coord.size();
                                    double[] x = new double[nbPoint];
                                    double[] y = new double[nbPoint];
                                    int i2 = 0;
                                    while (i2 < nbPoint) {
                                        x[i2] = ((Point2D.Double)coord.get((int)i2)).x;
                                        y[i2] = ((Point2D.Double)coord.get((int)i2)).y;
                                        ++i2;
                                    }
                                    xsML.add(x);
                                    ysML.add(y);
                                    ++k2;
                                }
                                troncon.setXs(xsML);
                                troncon.setYs(ysML);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception e) {
                        troncon.setX(null);
                        troncon.setY(null);
                    }
                    barreaux.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return barreaux;
    }

    private List<BarreauVH> getBarreauxFromDonneesExternes() {
        ArrayList<BarreauVH> barreaux = new ArrayList<BarreauVH>();
        String requete = "";
        requete = "SELECT id as id, cch as cch, date as maj, libelle as niveau,  coordonnees as coordonnees from donnees_externes.donnees_vh_troncon where not coordonnees is null ORDER BY date ASC";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    troncon.setId(rs.getString("id"));
                    troncon.setCch(rs.getString("cch"));
                    troncon.setClassification(rs.getString("niveau"));
                    troncon.setMajDate((Date)rs.getTimestamp("maj"));
                    try {
                        if (rs.getObject("coordonnees") != null) {
                            Vector<Double> xs = new Vector<Double>();
                            Vector<Double> ys = new Vector<Double>();
                            Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("coordonnees")));
                            int k = 0;
                            while (k < coordPArGeometry.size()) {
                                Vector coord = (Vector)coordPArGeometry.get(k);
                                int nbPoint = coord.size();
                                int i = 0;
                                while (i < nbPoint) {
                                    xs.add(((Point2D.Double)coord.get((int)i)).x);
                                    ys.add(((Point2D.Double)coord.get((int)i)).y);
                                    ++i;
                                }
                                ++k;
                            }
                            float[] xf = new float[xs.size()];
                            float[] yf = new float[ys.size()];
                            int i = 0;
                            while (i < xf.length) {
                                xf[i] = new Double((Double)xs.get(i)).floatValue();
                                yf[i] = new Double((Double)ys.get(i)).floatValue();
                                ++i;
                            }
                            troncon.setX(xf);
                            troncon.setY(yf);
                            try {
                                Vector<double[]> xsML = new Vector<double[]>();
                                Vector<double[]> ysML = new Vector<double[]>();
                                int k2 = 0;
                                while (k2 < coordPArGeometry.size()) {
                                    Vector coord = (Vector)coordPArGeometry.get(k2);
                                    int nbPoint = coord.size();
                                    double[] x = new double[nbPoint];
                                    double[] y = new double[nbPoint];
                                    int i2 = 0;
                                    while (i2 < nbPoint) {
                                        x[i2] = ((Point2D.Double)coord.get((int)i2)).x;
                                        y[i2] = ((Point2D.Double)coord.get((int)i2)).y;
                                        ++i2;
                                    }
                                    xsML.add(x);
                                    ysML.add(y);
                                    ++k2;
                                }
                                troncon.setXs(xsML);
                                troncon.setYs(ysML);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception e) {
                        troncon.setX(null);
                        troncon.setY(null);
                    }
                    barreaux.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return barreaux;
    }

    private String getStatus(String cch) {
        if (this.getConfiguration().get((Object)"CONFIG_LISTE_CCH_STATUS") != null) {
            if (this.listeCCH == null) {
                this.listeCCH = new HashMap<String, CCHStatus>();
                String[] stringArray = ((String)this.getConfiguration().get((Object)"CONFIG_LISTE_CCH_STATUS")).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    String[] valeurs = val.split(";");
                    CCHStatus cchStatus = new CCHStatus();
                    cchStatus.cch = valeurs[0];
                    cchStatus.status = valeurs[1];
                    cchStatus.couleur = valeurs[2];
                    this.listeCCH.put(valeurs[0], cchStatus);
                    ++n2;
                }
            }
            if (this.listeCCH.get(cch) != null) {
                return this.listeCCH.get((Object)cch).status;
            }
            return "Sans \u00e9v\u00e8nement signal\u00e9";
        }
        if (cch.equalsIgnoreCase("NR")) {
            return "Sans \u00e9v\u00e8nement signal\u00e9";
        }
        if (cch.equalsIgnoreCase("ES0")) {
            return "Sans \u00e9v\u00e8nement signal\u00e9";
        }
        if (cch.equalsIgnoreCase("ES1")) {
            return "Verglas localis\u00e9 ou givre";
        }
        if (cch.equalsIgnoreCase("ES2")) {
            return "Verglas g\u00e9n\u00e9ralis\u00e9";
        }
        if (cch.equalsIgnoreCase("ES3")) {
            return "Neige tass\u00e9e verglac\u00e9e";
        }
        if (cch.equalsIgnoreCase("ES4")) {
            return "Neige < 2 cm";
        }
        if (cch.equalsIgnoreCase("ES5")) {
            return "Neige comprise entre 2 et 5 cm";
        }
        if (cch.equalsIgnoreCase("ES6")) {
            return "Neige > 5 cm";
        }
        return "Sans \u00e9v\u00e8nement signal\u00e9";
    }

    private String getColor(String cch) {
        if (this.getConfiguration().get((Object)"CONFIG_LISTE_CCH_STATUS") != null) {
            if (this.listeCCH == null) {
                this.listeCCH = new HashMap<String, CCHStatus>();
                String[] stringArray = ((String)this.getConfiguration().get((Object)"CONFIG_LISTE_CCH_STATUS")).split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String val = stringArray[n2];
                    String[] valeurs = val.split(";");
                    CCHStatus cchStatus = new CCHStatus();
                    cchStatus.cch = valeurs[0];
                    cchStatus.status = valeurs[1];
                    cchStatus.couleur = valeurs[2];
                    this.listeCCH.put(valeurs[0], cchStatus);
                    ++n2;
                }
            }
            if (this.listeCCH.get(cch) != null) {
                return this.listeCCH.get((Object)cch).couleur;
            }
            return String.format("#%02x%02x%02x", 125, 125, 125);
        }
        if (cch.equalsIgnoreCase("NR")) {
            return String.format("#%02x%02x%02x", 206, 206, 206);
        }
        if (cch.equalsIgnoreCase("ES0")) {
            return String.format("#%02x%02x%02x", 245, 236, 154);
        }
        if (cch.equalsIgnoreCase("ES1")) {
            return String.format("#%02x%02x%02x", 248, 187, 208);
        }
        if (cch.equalsIgnoreCase("ES2")) {
            return String.format("#%02x%02x%02x", 244, 143, 177);
        }
        if (cch.equalsIgnoreCase("ES3")) {
            return String.format("#%02x%02x%02x", 240, 98, 146);
        }
        if (cch.equalsIgnoreCase("ES4")) {
            return String.format("#%02x%02x%02x", 187, 222, 253);
        }
        if (cch.equalsIgnoreCase("ES5")) {
            return String.format("#%02x%02x%02x", 100, 181, 246);
        }
        if (cch.equalsIgnoreCase("ES6")) {
            return String.format("#%02x%02x%02x", 33, 150, 243);
        }
        return String.format("#%02x%02x%02x", 125, 125, 125);
    }

    private int getWidth(String niveau) {
        int widthNiveauServiceDefaut = this.configuration.getInt("width_niveau_service_defaut", 5);
        if (!GLS.estVide((String)niveau)) {
            return this.configuration.getInt("width_niveau_service_" + niveau, widthNiveauServiceDefaut);
        }
        return widthNiveauServiceDefaut;
    }

    private int getNetwork(String niveau) {
        int networkNiveauServiceDefaut = this.configuration.getInt("network_niveau_service_defaut", 1);
        if (!GLS.estVide((String)niveau)) {
            return this.configuration.getInt("betwork_niveau_service_" + niveau, networkNiveauServiceDefaut);
        }
        return networkNiveauServiceDefaut;
    }

    @Override
    public List<BarreauVH> getBarreauxVH(int circuit, boolean sansCoordoonees) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String requete = "SELECT * " + (sansCoordoonees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id AND " + " donnees_metier.troncon_circuit_ext.idcircuit = ? " + " ORDER BY indice, delegation, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, circuit);
                rs = pstm.executeQuery();
                Log.debug(pstm.toString());
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public boolean changerEtatNiveauServiceCircuit(Circuit circuit, int etat) {
        String requete = "UPDATE prism.circuit SET etat_niveau_service=? WHERE id=?";
        boolean res = false;
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, etat);
                pstm.setInt(2, GLS.getInt((String)circuit.getId()));
                res = pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return res;
    }

    @Override
    public List<Circuit> getListeCircuitsParEtatNiveauService(int etatNiveauService) {
        ArrayList<Circuit> liste = new ArrayList<Circuit>();
        String requete = "SELECT * FROM prism.circuit WHERE etat_niveau_service=? AND systeme=0";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, etatNiveauService);
                rs = pstm.executeQuery();
                Log.debug(pstm.toString());
                while (rs.next()) {
                    Circuit c = new Circuit();
                    c.setId(String.valueOf(rs.getInt("id")));
                    c.setNom(rs.getString("nom"));
                    c.setDelegation(rs.getString("delegation"));
                    c.setType(rs.getString("type"));
                    c.setArchive(rs.getBoolean("archive"));
                    c.setCentre(rs.getString("centre"));
                    if (rs.getObject("fk_niveau_service") != null) {
                        c.setNiveauService(Long.valueOf(rs.getLong("fk_niveau_service")));
                    }
                    liste.add(c);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueCircuitBean> getStatistiqueCircuitTroncons(Circuit circuit, Timestamp dateDebutInit, int bufferSize, double ratioParcours, boolean tronconPreCalcules) {
        int frequenceMin;
        ArrayList<SyntheseTableauBordStatistiqueCircuitBean> retour = new ArrayList<SyntheseTableauBordStatistiqueCircuitBean>();
        List<Troncon> troncons = null;
        Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Date> mapDerniereDatePAssage = new HashMap<String, Date>();
        if (tronconPreCalcules) {
            return this.getStatTronconPrecalcule(null, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage);
        }
        troncons = this.getCircuitTroncons(circuit, false, 0.0, true, false);
        NiveauService niveauService = null;
        if (circuit.getNiveauService() != null) {
            for (NiveauService ns : this.getNiveauxService()) {
                if (ns.getId() != circuit.getNiveauService().longValue()) continue;
                niveauService = ns;
            }
        }
        int n = frequenceMin = niveauService != null ? niveauService.getFrequence() : 0;
        if (tronconPreCalcules) {
            this.getStatTronconPrecalcule(circuit, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage);
        } else {
            Calendar cal;
            Timestamp dateDebut = dateDebutInit;
            Timestamp dateFin = null;
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
            if (niveauService != null) {
                cal = Calendar.getInstance();
                cal.setTime(dateDebut);
                if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.MOIS) {
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(11, 23);
                    dateFin = new Timestamp(cal.getTimeInMillis());
                    cal.add(2, -niveauService.getNbPeriode());
                    dateDebut = new Timestamp(cal.getTimeInMillis());
                } else if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.SEMAINE) {
                    cal.set(12, 59);
                    cal.set(13, 59);
                    cal.set(11, 23);
                    dateFin = new Timestamp(cal.getTimeInMillis());
                    cal.add(4, -niveauService.getNbPeriode());
                    dateDebut = new Timestamp(cal.getTimeInMillis());
                } else if (niveauService.getNbPeriode() == 1) {
                    cal.add(7, niveauService.getNbPeriode());
                    dateFin = new Timestamp(cal.getTimeInMillis());
                } else {
                    dateFin = new Timestamp(cal.getTimeInMillis());
                    cal.add(6, -niveauService.getNbPeriode());
                    dateDebut = new Timestamp(cal.getTimeInMillis());
                }
                if (niveauService.getTypePeriode() != NiveauService.EnumTypePeriode.JOUR || niveauService.getNbPeriode() != 1) {
                    sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                }
            } else {
                cal = Calendar.getInstance();
                cal.setTime(dateDebut);
                cal.add(7, 1);
                dateFin = new Timestamp(cal.getTimeInMillis());
            }
            this.getStatTronconTempsReel(circuit, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, dateDebut, dateFin);
        }
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueCircuitBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), frequenceMin, (String[])mapPatrouillesId.get(troncon.getId()), (Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), circuit.getNom(), circuit.getDelegation(), circuit.getCentre()));
        }
        return retour;
    }

    private List<SyntheseTableauBordStatistiqueCircuitBean> getStatTronconPrecalcule(Circuit circuit, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage) {
        ArrayList<SyntheseTableauBordStatistiqueCircuitBean> retour = new ArrayList<SyntheseTableauBordStatistiqueCircuitBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM stats.circuit_exploitation s, donnees_metier.troncon_circuit tc, prism.circuit c  WHERE s.idtroncon = tc.id AND tc.idcircuit = c.id ORDER BY c.delegation,c.centre,c.nom");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    int pourcentage = rs.getInt("pourcentage_parcouru");
                    Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                    Timestamp datemaj = rs.getTimestamp("date_maj");
                    String nomCircuit = rs.getString("nom");
                    String delegation = rs.getString("delegation");
                    String centre = rs.getString("centre");
                    String prDebut = rs.getString("prdebut");
                    String abscissePrDebut = rs.getString("abscisseprdebut");
                    String prFint = rs.getString("prfin");
                    String abscissePrFin = rs.getString("abscisseprfin");
                    int niveau = rs.getInt("fk_niveau_service");
                    String description = rs.getString("axe");
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    try {
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    retour.add(new SyntheseTableauBordStatistiqueCircuitBean(tronocnID, description, pourcentage, niveau, derniersPassages, (Date)dateDernierPassage, (Date)datemaj, xsML, ysML, prDebut, abscissePrDebut, prFint, abscissePrFin, nomCircuit, delegation, centre));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private void getStatTronconTempsReel(Circuit circuit, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, Timestamp dateDebut, Timestamp dateFin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.troncon_circuit_stats_district(?,?,?,?,?)");
                pstm.setInt(1, Integer.valueOf(circuit.getId()));
                pstm.setTimestamp(2, dateDebut);
                pstm.setTimestamp(3, dateFin);
                pstm.setInt(4, bufferSize);
                pstm.setObject(5, (Object)1, 2);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                    Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                    mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                    try {
                        Vector<double[]> xsML = new Vector<double[]>();
                        Vector<double[]> ysML = new Vector<double[]>();
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<SyntheseTableauBordStatistiqueCircuitBean> getStatistiqueCircuitTroncons(List<Circuit> circuits, Timestamp dateDebutInit, int bufferSize, double ratioParcours) {
        Calendar cal;
        ArrayList<SyntheseTableauBordStatistiqueCircuitBean> retour = new ArrayList<SyntheseTableauBordStatistiqueCircuitBean>();
        NiveauService niveauService = null;
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        for (Circuit circuit : circuits) {
            troncons.addAll(this.getCircuitTroncons(circuit, false, 0.0, true));
            if (circuit.getNiveauService() == null) continue;
            for (NiveauService ns : this.getNiveauxService()) {
                if (ns.getId() != circuit.getNiveauService().longValue()) continue;
                niveauService = ns;
            }
        }
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap mapPositionXs = new HashMap();
        HashMap mapPositionYs = new HashMap();
        HashMap<String, java.sql.Date> mapDerniereDatePAssage = new HashMap<String, java.sql.Date>();
        Timestamp dateDebut = dateDebutInit;
        Timestamp dateFin = null;
        int frequenceMin = 0;
        Date dateMaj = GregorianCalendar.getInstance().getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        if (niveauService != null) {
            cal = Calendar.getInstance();
            cal.setTime(dateDebut);
            if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.MOIS) {
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(11, 23);
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(2, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            } else if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.SEMAINE) {
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(11, 23);
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(4, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            } else if (niveauService.getNbPeriode() == 1) {
                cal.add(7, niveauService.getNbPeriode());
                dateFin = new Timestamp(cal.getTimeInMillis());
            } else {
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(6, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            }
            if (niveauService.getTypePeriode() != NiveauService.EnumTypePeriode.JOUR || niveauService.getNbPeriode() != 1) {
                sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            }
            frequenceMin = niveauService.getFrequence();
        } else {
            cal = Calendar.getInstance();
            cal.setTime(dateDebut);
            cal.add(7, 1);
            dateFin = new Timestamp(cal.getTimeInMillis());
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.troncon_circuit_stats_district(?,?,?,?,?)");
                Object[] circuitId = new Object[circuits.size()];
                int index = 0;
                for (Circuit circuit : circuits) {
                    circuitId[index++] = Integer.valueOf(circuit.getId());
                }
                Array a = connection.createArrayOf("smallint", circuitId);
                pstm.setArray(1, a);
                pstm.setTimestamp(2, dateDebut);
                pstm.setTimestamp(3, dateFin);
                pstm.setInt(4, bufferSize);
                pstm.setObject(5, (Object)1, 2);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                    java.sql.Date dateDernierPassage = rs.getDate("date_dernier_passage");
                    mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                    try {
                        Vector<double[]> xsML = new Vector<double[]>();
                        Vector<double[]> ysML = new Vector<double[]>();
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        Circuit circuit = circuits.get(0);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueCircuitBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), frequenceMin, (String[])mapPatrouillesId.get(troncon.getId()), (Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), circuit.getNom(), circuit.getDelegation(), circuit.getCentre()));
        }
        return retour;
    }

    @Override
    public void miseAJourStatsCircuitExploitation(Circuit circuit, Timestamp dateDebutInit, int bufferSize, double ratioParcours) {
        Calendar cal;
        ArrayList retour = new ArrayList();
        List<Troncon> troncons = this.getCircuitTroncons(circuit, false, 0.0, true);
        NiveauService niveauService = null;
        if (circuit.getNiveauService() != null) {
            for (NiveauService ns : this.getNiveauxService()) {
                if (ns.getId() != circuit.getNiveauService().longValue()) continue;
                niveauService = ns;
            }
        }
        HashMap mapPourcentage = new HashMap();
        HashMap mapPatrouillesId = new HashMap();
        Timestamp dateDebut = dateDebutInit;
        Timestamp dateFin = null;
        int frequenceMin = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        if (niveauService != null) {
            cal = Calendar.getInstance();
            cal.setTime(dateDebut);
            if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.MOIS) {
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(11, 23);
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(2, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            } else if (niveauService.getTypePeriode() == NiveauService.EnumTypePeriode.SEMAINE) {
                cal.set(12, 59);
                cal.set(13, 59);
                cal.set(11, 23);
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(4, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            } else {
                dateFin = new Timestamp(cal.getTimeInMillis());
                cal.add(6, -niveauService.getNbPeriode());
                dateDebut = new Timestamp(cal.getTimeInMillis());
            }
            if (niveauService.getTypePeriode() != NiveauService.EnumTypePeriode.JOUR || niveauService.getNbPeriode() != 1) {
                sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            }
            frequenceMin = niveauService.getFrequence();
        } else {
            cal = Calendar.getInstance();
            cal.setTime(dateDebut);
            cal.add(7, 1);
            dateFin = new Timestamp(cal.getTimeInMillis());
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM stats.mise_a_jour_stats_circuit_exploitation_district(?,?,?,?,?)");
                pstm.setInt(1, Integer.valueOf(circuit.getId()));
                pstm.setTimestamp(2, dateDebut);
                pstm.setTimestamp(3, dateFin);
                pstm.setInt(4, bufferSize + 5);
                pstm.setObject(5, (Object)1, 2);
                pstm.executeQuery();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<BarreauVH> getBarreauxVH(boolean sansCoordonnees, int bufferSize) {
        ArrayList<BarreauVH> liste = new ArrayList<BarreauVH>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), " + bufferSize + ", 2), 4326))) as buffer";
        String requete = "SELECT * " + (sansCoordonnees ? "" : buffer) + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id ORDER BY indice, centre, id_groupe, troncon_id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    BarreauVH troncon = new BarreauVH();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatistiqueSchemaRoutier(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe, boolean dateDernierPassageConnu) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        List<Troncon> troncons = null;
        Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Date> mapDerniereDatePAssage = new HashMap<String, Date>();
        if (tronconPreCalcules) {
            return this.getStatSchemaRoutierTronconPrecalcule(centres, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, axe);
        }
        troncons = this.getTronconsFromSchemaRoutier(centres, false);
        this.getStatSchemaRoutierTronconTempsReel(centres, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, dateDebut, dateDernierPassageConnu);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueSchemaRoutierBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), -1, (String[])mapPatrouillesId.get(troncon.getId()), (Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), null, null, troncon.getCircuit(), troncon.getClassification(), troncon.getLongueur()));
        }
        return retour;
    }

    private void getStatSchemaRoutierTronconTempsReel(List<Centre> centres, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, Timestamp dateDebut, boolean dateDernierPassageConnu) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.get_stats_schema_routier_exploitation(?,?,?,?,?)");
                String centresNomSQL = "";
                for (Centre centre : centres) {
                    centresNomSQL = String.valueOf(centresNomSQL) + (centresNomSQL.equals("") ? "" : ",") + "'" + centre.getNom().replace("'", "''") + "'";
                }
                String conditionWhere = null;
                if (!centresNomSQL.equals("")) {
                    conditionWhere = " oid IN (SELECT oid FROM donnees_metier.schema_routier WHERE centre IN (" + centresNomSQL + ") ) ";
                }
                pstm.setTimestamp(1, dateDebut);
                pstm.setBoolean(2, dateDernierPassageConnu);
                pstm.setString(3, conditionWhere);
                pstm.setInt(4, bufferSize + 5);
                pstm.setObject(5, (Object)1, 2);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                    java.sql.Date dateDernierPassage = rs.getDate("date_dernier_passage");
                    mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                    try {
                        Vector<double[]> xsML = new Vector<double[]>();
                        Vector<double[]> ysML = new Vector<double[]>();
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    private List<Troncon> getTronconsFromSchemaRoutier(List<Centre> centres, boolean avecGeometry) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String nomCentreSqlIn = "";
                if (centres != null && centres.size() > 0) {
                    for (Centre centre : centres) {
                        nomCentreSqlIn = String.valueOf(nomCentreSqlIn) + (nomCentreSqlIn.equals("") ? "" : ",") + "'" + centre.getNom().replaceAll("'", "''") + "'";
                    }
                    nomCentreSqlIn = " WHERE centre IN (" + nomCentreSqlIn + ")";
                }
                String sql = "SELECT * FROM donnees_metier.schema_routier " + nomCentreSqlIn;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("oid"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                    troncon.setPrDebut(rs.getInt("plod"));
                    troncon.setPrFin(rs.getInt("plof"));
                    troncon.setAbscissePrDebut(rs.getInt("absd"));
                    troncon.setAbscissePrFin(rs.getInt("absf"));
                    troncon.setCircuit(rs.getString("centre"));
                    troncon.setClassification(rs.getString("niveau_exploitation"));
                    troncon.setTronconId(rs.getString("chaussee"));
                    try {
                        troncon.setLongueur(rs.getInt("longueur"));
                    }
                    catch (Exception e) {
                        troncon.setLongueur(-1);
                    }
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    private List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getStatSchemaRoutierTronconPrecalcule(List<Centre> centres, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, String axe) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String requete = SQL_SCHEMA_ROUTIER_NIV_EXPLOITATION;
                if (axe != null) {
                    requete = String.valueOf(requete) + " AND axe = ?";
                }
                pstm = connection.prepareStatement(requete);
                if (axe != null) {
                    pstm.setString(1, axe);
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    int pourcentage = rs.getInt("pourcentage_parcouru");
                    Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                    Timestamp datemaj = rs.getTimestamp("date_maj");
                    String delegation = null;
                    String centre = rs.getString("centre");
                    String prDebut = rs.getString("plod");
                    String abscissePrDebut = rs.getString("absd");
                    String prFint = rs.getString("plof");
                    String abscissePrFin = rs.getString("absf");
                    int niveau = rs.getInt("fk_niveau_service");
                    String description = rs.getString("axe");
                    String niveauExploitation = rs.getString("niveau_exploitation");
                    int longueur = -1;
                    try {
                        longueur = rs.getInt("longueur");
                    }
                    catch (Exception e) {
                        longueur = -1;
                    }
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    try {
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (centres != null && !centres.contains(centre)) continue;
                    retour.add(new SyntheseTableauBordStatistiqueSchemaRoutierBean(tronocnID, description, pourcentage, niveau, derniersPassages, (Date)dateDernierPassage, (Date)datemaj, xsML, ysML, prDebut, abscissePrDebut, prFint, abscissePrFin, null, delegation, centre, niveauExploitation, longueur));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<String> getSchemaRoutierAxes(Delegation delegation, Centre centre) {
        ArrayList<String> axes = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                if (centre != null) {
                    centre.getCode();
                }
                pstm = connection.prepareStatement("SELECT distinct(axe) FROM donnees_metier.schema_routier tc  ORDER BY axe");
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String axe = rs.getString("axe");
                    axes.add(axe);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return axes;
    }

    @Override
    public void precalculSchemaRoutier(Timestamp dateDebut, int bufferSize) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM stats.mise_a_jour_stats_schema_routier_exploitation(?,?,?)");
                pstm.setTimestamp(1, dateDebut);
                pstm.setInt(2, bufferSize + 5);
                pstm.setObject(3, (Object)1, 2);
                pstm.executeQuery();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void precalculSchemaExploitation(String fonctionExploitation, Timestamp dateDebut, int bufferSize) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM ?(?,?,?)");
                pstm.setString(1, fonctionExploitation);
                pstm.setTimestamp(2, dateDebut);
                pstm.setInt(3, bufferSize + 5);
                pstm.setObject(4, (Object)1, 2);
                Log.debug("PRECALCUL FAUCHAGE - " + pstm.toString());
                pstm.executeQuery();
            }
            catch (SQLException e) {
                Log.debug("ERR PRECALCUL FAUCHAGE - " + pstm.toString(), e);
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public Date getDateGenerationStatSchemaRoutier() {
        Timestamp timestamp;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT date_maj FROM stats.schema_routier_exploitation");
            rs = pstm.executeQuery();
            Timestamp date = null;
            while (rs.next()) {
                date = rs.getTimestamp("date_maj");
            }
            timestamp = date;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return timestamp;
    }

    @Override
    public boolean isDynamicUA() {
        return MetierCommun.isDynamicUA((Extension)this.getConfiguration());
    }

    @Override
    public List<String> getListeCaracteristiquesRoute() {
        if (this.listeCategoriesRoute == null) {
            this.getCaracteristiquesRoute();
        }
        return this.listeCategoriesRoute;
    }

    @Override
    public List<SyntheseTableauBordStatistiqueFauchageBean> getStatistiqueFauchageTroncons(List<Centre> centres, Timestamp dateDebut, int bufferSize, int ratioParcours, boolean tronconPreCalcules, String axe) {
        ArrayList<SyntheseTableauBordStatistiqueFauchageBean> retour = new ArrayList<SyntheseTableauBordStatistiqueFauchageBean>();
        List<Troncon> troncons = null;
        Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Date> mapDerniereDatePAssage = new HashMap<String, Date>();
        HashMap<String, Integer> mapDistanceCumulee = new HashMap<String, Integer>();
        if (tronconPreCalcules) {
            return this.getStatFauchageTronconPrecalcule(centres, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, axe);
        }
        troncons = this.getTronconsFromSchemaExploitation("fauchage.schema_fauchage", centres, false);
        this.getStatFauchageTronconTempsReel(centres, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, dateDebut, mapDistanceCumulee);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueFauchageBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), -1, (String[])mapPatrouillesId.get(troncon.getId()), (Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), null, null, troncon.getCircuit(), troncon.getClassification(), troncon.getLongueur(), ((Integer)mapDistanceCumulee.get(troncon.getId())).intValue()));
        }
        return retour;
    }

    private List<SyntheseTableauBordStatistiqueFauchageBean> getStatFauchageTronconPrecalcule(List<Centre> centres, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, String axe) {
        ArrayList<SyntheseTableauBordStatistiqueFauchageBean> retour = new ArrayList<SyntheseTableauBordStatistiqueFauchageBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String requete = SQL_SCHEMA_FAUCHAGE_NIV_EXPLOITATION;
                if (axe != null) {
                    requete = String.valueOf(requete) + " AND axe = ?";
                }
                pstm = connection.prepareStatement(requete);
                if (axe != null) {
                    pstm.setString(1, axe);
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("idtroncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    int pourcentage = rs.getInt("pourcentage_parcouru");
                    Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                    Timestamp datemaj = rs.getTimestamp("date_maj");
                    String delegation = null;
                    String centre = rs.getString("centre");
                    String prDebut = rs.getString("plod");
                    String abscissePrDebut = rs.getString("absd");
                    String prFint = rs.getString("plof");
                    String abscissePrFin = rs.getString("absf");
                    int niveau = rs.getInt("fk_niveau_service");
                    String description = rs.getString("axe");
                    String niveauExploitation = rs.getString("niveau_exploitation");
                    int longueur = -1;
                    try {
                        longueur = rs.getInt("longueur");
                    }
                    catch (Exception e) {
                        longueur = -1;
                    }
                    int distanceCumulee = -1;
                    try {
                        distanceCumulee = rs.getInt("distance_cumulee_parcourue");
                    }
                    catch (Exception e) {
                        distanceCumulee = -1;
                    }
                    Vector<double[]> xsML = new Vector<double[]>();
                    Vector<double[]> ysML = new Vector<double[]>();
                    try {
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (centres != null && !centres.contains(centre)) continue;
                    retour.add(new SyntheseTableauBordStatistiqueFauchageBean(tronocnID, description, pourcentage, niveau, derniersPassages, (Date)dateDernierPassage, (Date)datemaj, xsML, ysML, prDebut, abscissePrDebut, prFint, abscissePrFin, null, delegation, centre, niveauExploitation, longueur, distanceCumulee));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private void getStatFauchageTronconTempsReel(List<Centre> centres, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, Timestamp dateDebut, Map<String, Integer> mapDistanceCumulee) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM fauchage.get_stats_schema_fauchage_exploitation(?,?,?,?)");
                String centresNomSQL = "";
                for (Centre centre : centres) {
                    centresNomSQL = String.valueOf(centresNomSQL) + (centresNomSQL.equals("") ? "" : ",") + "'" + centre.getNom().replace("'", "''") + "'";
                }
                String conditionWhere = null;
                if (!centresNomSQL.equals("")) {
                    conditionWhere = " oid IN (SELECT oid FROM fauchage.schema_fauchage WHERE centre IN (" + centresNomSQL + ") ) ";
                }
                pstm.setTimestamp(1, dateDebut);
                pstm.setString(2, conditionWhere);
                pstm.setInt(3, bufferSize + 5);
                pstm.setObject(4, (Object)1, 2);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                    mapDistanceCumulee.put(tronocnID, rs.getInt("longueur_cumulee"));
                    java.sql.Date dateDernierPassage = rs.getDate("date_dernier_passage");
                    mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                    try {
                        Vector<double[]> xsML = new Vector<double[]>();
                        Vector<double[]> ysML = new Vector<double[]>();
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public Date getDateGenerationStatSchemaFauchage() {
        Timestamp timestamp;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT date_maj FROM fauchage.schema_fauchage_exploitation");
            rs = pstm.executeQuery();
            Timestamp date = null;
            while (rs.next()) {
                date = rs.getTimestamp("date_maj");
            }
            timestamp = date;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return timestamp;
    }

    @Override
    public List<String> getNiveauxExploitation() {
        ArrayList<String> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT distinct(niveau_exploitation) FROM donnees_metier.schema_routier ORDER BY niveau_exploitation ASC");
            rs = pstm.executeQuery();
            ArrayList<String> niveaux = new ArrayList<String>();
            while (rs.next()) {
                niveaux.add(rs.getString(1));
            }
            arrayList = niveaux;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    @Override
    public List<String> getNiveauxExploitation(String table) {
        ArrayList<String> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            connection = this.daoFactory.getConnection();
            pstm = connection.prepareStatement("SELECT distinct(niveau_exploitation) FROM " + table + " ORDER BY niveau_exploitation ASC");
            rs = pstm.executeQuery();
            ArrayList<String> niveaux = new ArrayList<String>();
            while (rs.next()) {
                niveaux.add(rs.getString(1));
            }
            arrayList = niveaux;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    @Override
    public void rechargerMarqueVehicule() {
        if (this.marquesVehicules != null) {
            this.chargerMarquesVehicules();
        }
    }

    @Override
    public void deleteZoneSensible(int typeZoneSensible) {
        String requete = typeZoneSensible != -1 ? "DELETE FROM donnees_metier.zone_sensible WHERE code_type_zone_sensible = ?" : "DELETE FROM donnees_metier.zone_sensible";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                if (typeZoneSensible != -1) {
                    pstm.setInt(1, typeZoneSensible);
                }
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void deleteBarreauxVH() {
        String requeteDeleteTronconCircuitExt = "DELETE FROM donnees_metier.troncon_circuit_ext";
        String requeteDeleteDonneesTronconVH = "DELETE FROM vh.donnees_vh_troncon";
        Connection connection = null;
        Statement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.createStatement();
                connection.prepareStatement(requeteDeleteDonneesTronconVH);
                pstm.execute(requeteDeleteDonneesTronconVH);
                pstm.execute(requeteDeleteTronconCircuitExt);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public List<SyntheseTableauBordStatistiqueSchemaRoutierBean> getModuleMetierStatistiqueSchema(ModuleMetier moduleMetier, List<Centre> centres, Timestamp dateDebut, Timestamp dateFin, int bufferSize, int ratioParcours, String axe, boolean dateDernierPassageConnue) {
        ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean> retour = new ArrayList<SyntheseTableauBordStatistiqueSchemaRoutierBean>();
        List<Troncon> troncons = null;
        Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Date> mapDerniereDatePAssage = new HashMap<String, Date>();
        troncons = this.getTronconsFromSchemaStats(moduleMetier, centres, axe, false);
        this.getStatModuleMetierSRTronconTempsReel(moduleMetier, centres, axe, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, dateDebut, dateFin, dateDernierPassageConnue);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueSchemaRoutierBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), -1, (String[])mapPatrouillesId.get(troncon.getId()), (Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), null, null, troncon.getCircuit(), troncon.getClassification(), troncon.getLongueur()));
        }
        return retour;
    }

    private List<Troncon> getTronconsFromSchemaStats(ModuleMetier mdouleMetier, List<Centre> centres, String axe, boolean avecGeometry) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String conditionWhere = "";
                String nomCentreSqlIn = "";
                if (centres != null && centres.size() > 0) {
                    for (Centre centre : centres) {
                        nomCentreSqlIn = String.valueOf(nomCentreSqlIn) + (nomCentreSqlIn.equals("") ? "" : ",") + "'" + centre.getNom().replaceAll("'", "''") + "'";
                    }
                    conditionWhere = "WHERE centre IN (" + nomCentreSqlIn + ")";
                }
                String axeWhere = "";
                if (axe != null && !"".equals(axe)) {
                    axeWhere = "axe = '" + axe + "'";
                    conditionWhere = String.valueOf(conditionWhere) + (conditionWhere.equals("") ? " WHERE " : " AND ") + axeWhere;
                }
                String sql = "SELECT * FROM stats.schema_routier_" + mdouleMetier.getCode() + " " + conditionWhere;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("oid"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                    troncon.setPrDebut(rs.getInt("plod"));
                    troncon.setPrFin(rs.getInt("plof"));
                    troncon.setAbscissePrDebut(rs.getInt("absd"));
                    troncon.setAbscissePrFin(rs.getInt("absf"));
                    troncon.setCircuit(rs.getString("centre"));
                    troncon.setClassification(rs.getString("niveau_exploitation"));
                    try {
                        troncon.setLongueur(rs.getInt("longueur"));
                    }
                    catch (Exception e) {
                        troncon.setLongueur(-1);
                    }
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    private void getStatModuleMetierSRTronconTempsReel(ModuleMetier moduleMetier, List<Centre> centres, String axe, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, Date> mapDerniereDatePAssage, Timestamp dateDebut, Timestamp dateFin, boolean dateDernierPassageConnue) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String conditionWhere;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM stats.get_stats_sr(?,?,?,?,?,?,?)");
                String centresNomSQL = "";
                if (centres != null && centres.size() > 0) {
                    String centreWhere;
                    for (Centre centre : centres) {
                        centresNomSQL = String.valueOf(centresNomSQL) + (centresNomSQL.equals("") ? "" : ",") + "'" + centre.getNom().replace("'", "''") + "'";
                    }
                    centresNomSQL = centreWhere = "centre IN (" + centresNomSQL + ")";
                }
                String axeWhere = "";
                if (axe != null && !"".equals(axe)) {
                    axeWhere = "axe = '" + axe + "'";
                }
                String string = conditionWhere = axeWhere.equals("") && centresNomSQL.equals("") ? null : "oid IN (SELECT oid FROM stats.schema_routier_" + moduleMetier.getCode() + " WHERE % % % )";
                if (conditionWhere != null) {
                    conditionWhere = conditionWhere.replaceFirst("%", centresNomSQL);
                    conditionWhere = !axeWhere.equals("") && !centresNomSQL.equals("") ? conditionWhere.replaceFirst("%", "AND ") : conditionWhere.replaceFirst("%", "");
                    conditionWhere = conditionWhere.replaceFirst("%", axeWhere);
                }
                pstm.setInt(1, moduleMetier.getCode());
                pstm.setTimestamp(2, dateDebut);
                pstm.setTimestamp(3, dateFin);
                pstm.setString(4, conditionWhere);
                pstm.setInt(5, bufferSize + 5);
                pstm.setObject(6, (Object)1, 2);
                pstm.setBoolean(7, dateDernierPassageConnue);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                    Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                    mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                    try {
                        Vector<double[]> xsML = new Vector<double[]>();
                        Vector<double[]> ysML = new Vector<double[]>();
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public Rectangle2D getExtentTroncons(List<String> tronconsId) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block6: {
            Rectangle2D rectangle2D;
            String requete = "SELECT st_expand(st_extent(coordonnees),0.01) AS extent FROM stats.schema_routier_1000 ";
            if (tronconsId != null && tronconsId.size() > 0) {
                requete = String.valueOf(requete) + " WHERE oid IN ?";
            }
            connection = null;
            pstm = null;
            rs = null;
            try {
                Object obj;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete, 1004, 1007);
                if (tronconsId != null && tronconsId.size() > 0) {
                    pstm.setArray(1, connection.createArrayOf("text", tronconsId.toArray()));
                }
                if (!(rs = pstm.executeQuery()).first() || (obj = rs.getObject("extent")) == null || !(obj instanceof PGbox2d)) break block6;
                Bounds b = new Bounds();
                PGbox2d ext = (PGbox2d)obj;
                Polygon p = new Polygon();
                Rectangle2D r = new Line2D.Double(new Point2D.Double(ext.getURT().getX(), ext.getURT().getY()), new Point2D.Double(ext.getLLB().getX(), ext.getLLB().getY())).getBounds2D();
                Log.debug(r.getHeight() + r.getWidth());
                b.setMaxx(ext.getURT().getX());
                b.setMinx(ext.getLLB().getX());
                b.setMaxy(ext.getURT().getY());
                b.setMiny(ext.getLLB().getY());
                rectangle2D = r;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return rectangle2D;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public List<NiveauServicePeriode> getNiveauxServicePeriodes(long id) {
        ArrayList<NiveauServicePeriode> list = new ArrayList<NiveauServicePeriode>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_LISTE_NIVEAU_SERVICE_PERIODE);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    NiveauServicePeriode liste = new NiveauServicePeriode();
                    liste.setId(rs.getInt("id_periode"));
                    liste.setNiveauServiceId(rs.getInt("id_niveau_service"));
                    liste.setDateDebut((Date)rs.getTimestamp("date_debut"));
                    liste.setDateFin((Date)rs.getTimestamp("date_fin"));
                    list.add(liste);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return list;
    }

    @Override
    public List<SyntheseTableauBordFrequencePatrouilleV2Bean> getFrequencePatrouilleV2Troncons(Circuit circuit, Timestamp dateDebutInit, int bufferSize, double ratioParcours) {
        ArrayList<SyntheseTableauBordFrequencePatrouilleV2Bean> retour = new ArrayList<SyntheseTableauBordFrequencePatrouilleV2Bean>();
        List<Troncon> troncons = this.getTronconsFromSchemaRoutier(null, false, "TYPE = 'BRETELLE'");
        HashMap<String, Troncon> tronconsUnique = new HashMap<String, Troncon>();
        for (Troncon t : troncons) {
            tronconsUnique.put(t.getId(), t);
        }
        Timestamp dateDebut = dateDebutInit;
        dateDebut.setHours(4);
        dateDebut.setMinutes(30);
        dateDebut.setSeconds(0);
        Timestamp dateFin = dateDebutInit;
        dateFin.setHours(4);
        dateFin.setMinutes(30);
        dateFin.setSeconds(0);
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateDebutInit);
        cal.set(12, 30);
        cal.set(13, 0);
        cal.set(11, 4);
        Calendar calFin = Calendar.getInstance();
        calFin.setTime(dateDebutInit);
        calFin.add(5, 1);
        calFin.set(12, 30);
        calFin.set(13, 0);
        calFin.set(11, 4);
        HashMap<String, ArrayList<Date>> mapDatesHeuresPassage = new HashMap<String, ArrayList<Date>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT z.description, h.date FROM donnees_metier.zone_sensible_hist h, donnees_metier.zone_sensible z WHERE z.id = h.id_zone AND date > ?  AND date <?");
                pstm.setTimestamp(1, new Timestamp(cal.getTimeInMillis()));
                pstm.setTimestamp(2, new Timestamp(calFin.getTimeInMillis()));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String tronconId = rs.getString("description");
                    Timestamp date = rs.getTimestamp("date");
                    ArrayList<Date> dates = (ArrayList<Date>)mapDatesHeuresPassage.get(tronconId);
                    if (dates == null) {
                        dates = new ArrayList<Date>();
                        mapDatesHeuresPassage.put(tronconId, dates);
                    }
                    dates.add(new Date(date.getTime()));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        for (Troncon troncon : tronconsUnique.values()) {
            retour.add(new SyntheseTableauBordFrequencePatrouilleV2Bean(troncon.getId(), troncon.getTronconId(), (List)mapDatesHeuresPassage.get(troncon.getTronconId())));
        }
        return retour;
    }

    private List<Troncon> getTronconsFromSchemaRoutier(List<Centre> centres, boolean avecGeometry, String whereCondition) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String nomCentreSqlIn = "";
                if (centres != null && centres.size() > 0) {
                    for (Centre centre : centres) {
                        nomCentreSqlIn = String.valueOf(nomCentreSqlIn) + (nomCentreSqlIn.equals("") ? "" : ",") + "'" + centre.getNom().replaceAll("'", "''") + "'";
                    }
                    nomCentreSqlIn = " WHERE centre IN (" + nomCentreSqlIn + ")";
                }
                String sql = "SELECT * FROM donnees_metier.schema_routier " + nomCentreSqlIn;
                sql = String.valueOf(sql) + (nomCentreSqlIn.equals("") ? "WHERE " : " AND ") + whereCondition;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("oid"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                    troncon.setPrDebut(rs.getInt("plod"));
                    troncon.setPrFin(rs.getInt("plof"));
                    troncon.setAbscissePrDebut(rs.getInt("absd"));
                    troncon.setAbscissePrFin(rs.getInt("absf"));
                    troncon.setCircuit(rs.getString("centre"));
                    troncon.setClassification(rs.getString("niveau_exploitation"));
                    troncon.setTronconId(rs.getString("chaussee"));
                    try {
                        troncon.setLongueur(rs.getInt("longueur"));
                    }
                    catch (Exception e) {
                        troncon.setLongueur(-1);
                    }
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    private List<Troncon> getTronconsFromSchemaExploitation(String table, List<Centre> centres, boolean avecGeometry) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String nomCentreSqlIn = "";
                if (centres != null && centres.size() > 0) {
                    for (Centre centre : centres) {
                        nomCentreSqlIn = String.valueOf(nomCentreSqlIn) + (nomCentreSqlIn.equals("") ? "" : ",") + "'" + centre.getNom().replaceAll("'", "''") + "'";
                    }
                    nomCentreSqlIn = " WHERE centre IN (" + nomCentreSqlIn + ")";
                }
                String sql = "SELECT * FROM " + table + " " + nomCentreSqlIn;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("oid"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                    troncon.setPrDebut(rs.getInt("plod"));
                    troncon.setPrFin(rs.getInt("plof"));
                    troncon.setAbscissePrDebut(rs.getInt("absd"));
                    troncon.setAbscissePrFin(rs.getInt("absf"));
                    troncon.setCircuit(rs.getString("centre"));
                    troncon.setClassification(rs.getString("niveau_exploitation"));
                    troncon.setTronconId(rs.getString("chaussee"));
                    try {
                        troncon.setLongueur(rs.getInt("longueur"));
                    }
                    catch (Exception e) {
                        troncon.setLongueur(-1);
                    }
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    @Override
    public List<BarreauVHHisto> getBarreauxVHExtend(String delegation, String centre, Integer circuit, boolean sansCoordonnees) {
        ArrayList<BarreauVHHisto> liste = new ArrayList<BarreauVHHisto>();
        String buffer = ",((transform(st_buffer(st_simplify(st_transform(st_setsrid(coordonnees,4326),2154), 10), 20, 2), 4326))) as buffer";
        String mcig = " ,(SELECT u.nom FROM prism.utilisateur u,prism.mcig mcig WHERE u.id_utilisateur = mcig.id_utilisateur AND mcig_id = vh.donnees_vh_troncon.mcig_id) as mcig_utilisateur, (SELECT mcig.type_poste FROM prism.mcig mcig WHERE mcig_id = vh.donnees_vh_troncon.mcig_id) as mcig_type_poste ";
        String requete = circuit != null && circuit != -1 ? "SELECT * " + (sansCoordonnees ? "" : buffer) + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id" + " AND donnees_metier.troncon_circuit_ext.idcircuit = ? " + " ORDER BY indice, delegation, centre, id_groupe, troncon_id" : (GLS.estVide((String)delegation) ? "SELECT * " + (sansCoordonnees ? "" : buffer) + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id" + " ORDER BY indice, delegation, centre, id_groupe, troncon_id" : "SELECT * " + (sansCoordonnees ? "" : buffer) + mcig + " FROM donnees_metier.troncon_circuit_ext, vh.donnees_vh_troncon WHERE donnees_metier.troncon_circuit_ext.id = vh.donnees_vh_troncon.id" + " AND donnees_metier.troncon_circuit_ext.idcircuit IN (SELECT id FROM circuit c WHERE (lower(c.delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + " ) " + " AND (lower(delegation) like ? OR delegation is null OR delegation = '') " + (!GLS.estVide((String)centre) ? "AND (lower(centre) like ? OR centre is null OR centre = '')" : "") + "ORDER BY indice, delegation, centre, id_groupe, troncon_id");
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                if (circuit != null && circuit != -1) {
                    pstm.setInt(1, circuit);
                } else if (!GLS.estVide((String)delegation)) {
                    int i = 1;
                    pstm.setString(i++, delegation.toLowerCase());
                    if (!GLS.estVide((String)centre)) {
                        pstm.setString(i++, centre.toLowerCase());
                    }
                    pstm.setString(i++, delegation.toLowerCase());
                    if (!GLS.estVide((String)centre)) {
                        pstm.setString(i++, centre.toLowerCase());
                    }
                }
                rs = pstm.executeQuery();
                Log.debug("getBarreauxVH : " + pstm.toString());
                while (rs.next()) {
                    BarreauVHHisto troncon = new BarreauVHHisto();
                    ReferentielDAOJDBC.fabriqueTroncon(rs, (BarreauVH)troncon);
                    this.ajoutTronconMcig(rs, troncon);
                    liste.add(troncon);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    private void ajoutTronconMcig(ResultSet rs, BarreauVHHisto troncon) {
        try {
            troncon.setMcig(rs.getString("mcig_id"));
            troncon.setUtilisateur(rs.getString("mcig_utilisateur"));
            troncon.setTypePoste(rs.getInt("mcig_type_poste"));
        }
        catch (Exception e) {
            troncon.setMcig(null);
        }
    }

    @Override
    public List<String> getSchemaAxes(Delegation delegation, Centre centre, String table) {
        ArrayList<String> axes = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                if (centre != null) {
                    centre.getCode();
                }
                pstm = connection.prepareStatement("SELECT distinct(axe) FROM " + table + " tc " + SQL_SCHEMA_ROUTIER_AXE_ORDER);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String axe = rs.getString("axe");
                    axes.add(axe);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return axes;
    }

    @Override
    public HashMap<Integer, HashMap<String, Boolean>> getDestinatairesFonctionsMail(int idListeDestinataire) {
        HashMap<Integer, HashMap<String, Boolean>> mapDiffusion = new HashMap<Integer, HashMap<String, Boolean>>();
        if (idListeDestinataire <= 0) {
            return mapDiffusion;
        }
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.lien_destinataire WHERE id_liste_destinataire_mail=?");
                pstm.setInt(1, idListeDestinataire);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    int idDest = rs.getInt("id_destinataire");
                    HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                    map.put("creation_evt", rs.getBoolean("creation_evt"));
                    map.put("modification_evt", rs.getBoolean("modification_evt"));
                    map.put("cloture_evt", rs.getBoolean("cloture_evt"));
                    map.put("traitement_evt", rs.getBoolean("traitement_evt"));
                    mapDiffusion.put(idDest, map);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return mapDiffusion;
    }

    @Override
    public String getDescriptionComposant(String nomComposant) {
        String retour = "";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select definition from composant c where c.nom = ?");
                pstm.setString(1, nomComposant);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    retour = rs.getString("definition");
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public Troncon getSchemaRoutierTroncons(int codeTroncon) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block9: {
            Troncon troncon;
            connection = null;
            pstm = null;
            rs = null;
            String table = "donnees_metier.schema_routier";
            boolean avecGeometry = true;
            try {
                connection = this.daoFactory.getConnection();
                String sql = "SELECT * FROM " + table + " WHERE oid = ?";
                pstm = connection.prepareStatement(sql);
                pstm.setInt(1, codeTroncon);
                rs = pstm.executeQuery();
                if (!rs.next()) break block9;
                Troncon troncon2 = new Troncon();
                troncon2.setId(rs.getString("oid"));
                troncon2.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                troncon2.setAxe(rs.getString("axe"));
                troncon2.setLongueur(rs.getInt("longueur"));
                troncon2.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                troncon2.setPrDebut(rs.getInt("plod"));
                troncon2.setPrFin(rs.getInt("plof"));
                troncon2.setAbscissePrDebut(rs.getInt("absd"));
                troncon2.setAbscissePrFin(rs.getInt("absf"));
                String centre = rs.getString("centre");
                String delegation = rs.getString("delegation");
                if (avecGeometry) {
                    try {
                        float[][] coordonnees = null;
                        coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                        if (coordonnees != null) {
                            troncon2.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                            troncon2.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                            troncon2.setX(coordonnees[0]);
                            troncon2.setY(coordonnees[1]);
                        } else {
                            troncon2.setPointDebut(null);
                            troncon2.setPointFin(null);
                            troncon2.setX(null);
                            troncon2.setY(null);
                        }
                    }
                    catch (Exception e) {
                        troncon2.setX(null);
                        troncon2.setY(null);
                        troncon2.setPointDebut(null);
                        troncon2.setPointFin(null);
                        Log.error("ERREUR COORDONNEES TRONCONS", e);
                    }
                }
                troncon = troncon2;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return troncon;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public String getLibelleCorrespondance(String code) {
        String retour;
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            String string;
            connection = null;
            pstm = null;
            rs = null;
            retour = code;
            try {
                connection = this.daoFactory.getConnection();
                String sql = SQL_LIBELLE_CORRESPONDANCE;
                pstm = connection.prepareStatement(sql);
                pstm.setString(1, code);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                string = retour = rs.getString("libelle");
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return string;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    private class CCHStatus {
        String cch;
        String status;
        String couleur;

        private CCHStatus() {
        }
    }

    class VerificationZoneSensibleCircuitFauchageKey {
        private final String idCircuit;
        private final String classification;

        public VerificationZoneSensibleCircuitFauchageKey(String idCircuit, String classification) {
            this.idCircuit = idCircuit;
            this.classification = classification;
        }

        public String getIdCircuit() {
            return this.idCircuit;
        }

        public String getClassification() {
            return this.classification;
        }

        public final boolean equals(Object o) {
            return o instanceof VerificationZoneSensibleCircuitFauchageKey && Objects.equals(this.idCircuit, ((VerificationZoneSensibleCircuitFauchageKey)o).idCircuit) && Objects.equals(this.classification, ((VerificationZoneSensibleCircuitFauchageKey)o).classification);
        }

        public int hashCode() {
            return Objects.hash(this.idCircuit, this.classification);
        }
    }
}

