/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IPartenaireDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Partenaire;
import gls.outils.GLS;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PartenaireDAOJDBC
implements IPartenaireDAO {
    private static final long serialVersionUID = 6773345755245660503L;
    private DAOFactory daoFactory;
    private static final Logger log = Logger.getLogger(PartenaireDAOJDBC.class);
    private static final String PARAMETRE_NATURE = "natures";
    private static List<Partenaire> partenairesEvenements;
    private static Map<String, List<Partenaire>> mapPartenairesEvenements;

    public PartenaireDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
        partenairesEvenements = null;
        mapPartenairesEvenements = null;
    }

    @Override
    public List<Partenaire> getListePartenaire(int type) throws SQLException {
        ArrayList<Partenaire> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Partenaire> liste = new ArrayList<Partenaire>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "SELECT * from export.partenaire where partenaire_actif = 1";
            if (type != -1) {
                requete = String.valueOf(requete) + " and type = ?";
            }
            pstm = connection.prepareStatement(requete);
            if (type != -1) {
                pstm.setInt(1, type);
            }
            rs = pstm.executeQuery();
            while (rs.next()) {
                Partenaire partenaire = this.lirePartenaire(rs);
                log.debug((Object)("Ajout du partenaire: " + partenaire.getLibelle()));
                liste.add(partenaire);
            }
            arrayList = liste;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    private Partenaire lirePartenaire(ResultSet rs) throws SQLException {
        Partenaire partenaire = new Partenaire();
        partenaire.setLibelle(rs.getString("libelle"));
        partenaire.setDescription(rs.getString("description"));
        partenaire.setPartenaireActif(rs.getInt("partenaire_actif"));
        partenaire.setNomServeur(rs.getString("nom_serveur"));
        partenaire.setPortServeur(rs.getInt("port_serveur"));
        partenaire.setLogin(rs.getString("login"));
        partenaire.setPassword(rs.getString("password"));
        partenaire.setCheminServeur(rs.getString("rep_partage"));
        partenaire.setPatternFichier(rs.getString("pattern_name"));
        partenaire.setNbConnexions(rs.getInt("nb_connexion"));
        partenaire.setModeTransfert(rs.getString("mode_transfert"));
        partenaire.setUseProxy(rs.getInt("use_proxy"));
        partenaire.setModeProxy(rs.getString("mode_proxy"));
        partenaire.setAdresseProxy(rs.getString("adresse_proxy"));
        partenaire.setPortProxy(rs.getString("port_proxy"));
        partenaire.setModeConnexion(rs.getString("mode_connexion"));
        partenaire.setRepArchivage(rs.getString("rep_archivage"));
        partenaire.setDelaiTraitement(rs.getInt("delai_traitement"));
        partenaire.setFormatEchange(rs.getString("format_echange"));
        partenaire.setNbTentative(rs.getInt("nb_tentative"));
        partenaire.setId(rs.getString("id"));
        partenaire.setRepDepotFtp(rs.getString("chemin_serveur"));
        try {
            partenaire.setDernierTransfert((Date)rs.getTimestamp("date_dernier_transfert"));
        }
        catch (Exception ex) {
            partenaire.setDernierTransfert(null);
        }
        try {
            partenaire.setFtpExtensionTemporaire(rs.getString("ftp_extension_temporaire"));
        }
        catch (Exception ex) {
            partenaire.setFtpExtensionTemporaire("");
        }
        try {
            partenaire.setParametres(rs.getString("parametres"));
        }
        catch (Exception ex) {
            partenaire.setParametres(null);
        }
        try {
            partenaire.setRepertoireReception(rs.getString("rep_reception"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            partenaire.setPattenFichierReception(rs.getString("pattern_fichier_reception"));
            log.debug((Object)("e.pattenFichierReception: " + partenaire.getPattenFichierReception()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            partenaire.setTypeEmission(Partenaire.EnumTypeEmission.valueOf((String)rs.getString("type_emission")));
            partenaire.setEMail(rs.getString("email"));
        }
        catch (Exception ex) {
            partenaire.setTypeEmission(Partenaire.EnumTypeEmission.FTP);
        }
        return partenaire;
    }

    @Override
    public List<Partenaire> getListePartenaireSERPEVH() throws SQLException {
        ArrayList<Partenaire> arrayList;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<Partenaire> liste = new ArrayList<Partenaire>();
        try {
            connection = this.daoFactory.getConnection();
            String requete = "SELECT * from export.partenaire  where partenaire_actif = 1 AND format_echange = 'XML_SERPEVH'";
            pstm = connection.prepareStatement(requete);
            rs = pstm.executeQuery();
            while (rs.next()) {
                Partenaire partenaire = this.lirePartenaire(rs);
                log.debug((Object)("Ajout du partenaire: " + partenaire.getLibelle()));
                liste.add(partenaire);
            }
            arrayList = liste;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return arrayList;
    }

    @Override
    public Partenaire getPartenaireSERPEVH() throws SQLException {
        Partenaire partenaire;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        Partenaire partenaire2 = null;
        try {
            connection = this.daoFactory.getConnection();
            String requete = "SELECT * from export.partenaire  where partenaire_actif = 1 AND format_echange = 'XML_SERPEVH'";
            pstm = connection.prepareStatement(requete);
            rs = pstm.executeQuery();
            if (rs.next()) {
                partenaire2 = this.lirePartenaire(rs);
                log.debug((Object)("Ajout du partenaire: " + partenaire2.getLibelle()));
            }
            partenaire = partenaire2;
        }
        catch (SQLException e) {
            try {
                throw new DAOException(e);
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
        }
        DAOUtil.close(connection, pstm, rs);
        return partenaire;
    }

    @Override
    public void miseAjourPartenaire(Partenaire partenaire, Date dateIterationCourante) throws SQLException {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String requete = "update export.partenaire set date_dernier_transfert = ? where id = ?";
                pstm = connection.prepareStatement(requete);
                pstm.setTimestamp(1, new Timestamp(dateIterationCourante.getTime()));
                pstm.setInt(2, Integer.parseInt(partenaire.getId()));
                pstm.executeUpdate();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<Partenaire> getListePartenaire() throws SQLException {
        return this.getListePartenaire(-1);
    }

    @Override
    public List<Partenaire> getListePartenaireExportEvenementAxione(String nature) {
        List<Partenaire> partenairesEvenement = this.getListePartenaireExportEvenement(nature);
        ArrayList<Partenaire> partenairesEvenementAxione = new ArrayList<Partenaire>();
        for (Partenaire p : partenairesEvenement) {
            if (!GLS.egal((String)p.getFormatEchange(), (String)"WS_AXIONE")) continue;
            partenairesEvenementAxione.add(p);
        }
        return partenairesEvenementAxione;
    }

    @Override
    public List<Partenaire> getListePartenaireExportEvenement(String nature) {
        List<Partenaire> partenairesEvenement = new ArrayList<Partenaire>();
        try {
            List<Partenaire> partenaires;
            if (partenairesEvenements == null) {
                partenairesEvenements = this.getListePartenaire(ConstantesPrismCommun.EnumPartenaire.EXPORT_EVENEMENT.getCode());
                mapPartenairesEvenements = new HashMap<String, List<Partenaire>>();
            }
            if (!GLS.estVide(partenaires = partenairesEvenements)) {
                if (!mapPartenairesEvenements.containsKey(nature)) {
                    for (Partenaire p : partenaires) {
                        MapDescription m = MapDescription.parse((String)p.getParametres());
                        List natures = m.getList(PARAMETRE_NATURE);
                        if (GLS.estVide((List)natures) || !GLS.estDansLaListe((List)natures, (Object)nature)) continue;
                        partenairesEvenement.add(p);
                    }
                    mapPartenairesEvenements.put(nature, partenairesEvenement);
                } else {
                    partenairesEvenement = mapPartenairesEvenements.get(nature);
                }
            }
        }
        catch (Exception e) {
            Log.error("ERR PARTENAIRE EVT OBTENTION", e);
        }
        return partenairesEvenement;
    }
}

