/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.IDescription;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IEvenementsDAO;
import com.geolocsystems.prismcentral.DAO.IImportEvenementDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BgBDDConfig;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreChampTexte;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import gls.geometry.Geometry;
import gls.outils.GLS;
import gls.outils.fichier.FichierCSV;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.postgis.LineString;
import org.postgis.PGgeometry;
import org.postgis.Point;

public class ImportEvenementDAOJDBC
implements IImportEvenementDAO {
    private DAOFactory daoFactory;
    private IReferentielDAO refDAO;
    private IEvenementsDAO evtsDAO;
    private static Map<String, Map<String, String>> correspondances = null;
    private static List<BgBDDConfig> configBgBdd = null;
    private static final String CODE_PRISM = "id_prism";
    private static final String CODE_IMPORT = "id_import";
    private static final String CLE = "cle";
    public static final String CHAMP_COORDONNEES = "coordonnees";
    public static final String CHAMP_CENTRE = "centre";
    public static final String CHAMP_DELEGATION = "delegation";
    public static final String CHAMP_DATE_CREATION = "sta";
    public static final String CHAMP_DATE_MODIFICATION = "inp";
    public static final String CHAMP_DESCRIPTION = "description";
    public static final String CHAMP_CODE_EVENEMENT = "bgcode";
    public static final String CHAMP_ROUTE = "axe";
    public static final String CHAMP_PR_DEB = "prDeb";
    public static final String CHAMP_ABSPRDEB = "absDeb";
    public static final String CHAMP_PR_FIN = "prFin";
    public static final String CHAMP_ABSPRFIN = "absFin";
    public static final String CHAMP_ID = "id";
    public static final String CHAMP_NATURE = "nature";
    public static final String CHAMP_X = "x";
    public static final String CHAMP_Y = "y";
    public static final String CHAMP_PROJECTION = "projection";
    public static final String PREFIXE_BG = "BG-";
    public static final String[] CHAMPS_SYSTEMES = new String[]{"axe", "prDeb", "absDeb", "prFin", "absFin", "coordonnees", "centre", "delegation", "sta", "inp", "description"};
    private static final String SQL_CORRESPONDANCES = "select cle, id_prism,id_import from ig4.correspondances";
    private static final String SQL_BG_CORRES_EVENEMENTS = "select code_nature,requete,bg_champs,prism_champs,champ_date,active from bg.evenements where active = 1";

    public ImportEvenementDAOJDBC(DAOFactory daoFactory, IReferentielDAO refDAO, IEvenementsDAO evtsDAO) {
        this.daoFactory = daoFactory;
        this.refDAO = refDAO;
        this.evtsDAO = evtsDAO;
    }

    private void init() {
        correspondances = new HashMap<String, Map<String, String>>();
        configBgBdd = new ArrayList<BgBDDConfig>();
        this.remplirCorrespondances();
        this.remplirBgCorresEvenements();
    }

    private static boolean aUneDerniereSynchro(long derniereSynchro) {
        return derniereSynchro > 0L;
    }

    private String getRequete(BgBDDConfig config, long derniereSynchro) {
        StringBuffer req = new StringBuffer();
        if (config != null) {
            req.append(config.getRequete());
            if (ImportEvenementDAOJDBC.aUneDerniereSynchro(derniereSynchro)) {
                req.append(" WHERE ");
                req.append(config.getChampDate());
                req.append(" > ?");
                req.append(" or ");
                req.append(config.getChampDate());
                req.append(" is null ");
            }
        }
        return req.toString();
    }

    private String genereCodeBG(String nature, String codeBG) {
        return PREFIXE_BG.concat(nature).concat("-").concat(codeBG);
    }

    @Override
    public List<Evenement> getEvenements(Connection connection, BgBDDConfig config, long derniereSynchro) {
        ArrayList<Evenement> evts;
        block9: {
            PreparedStatement pstm = null;
            ResultSet rs = null;
            String requete = this.getRequete(config, derniereSynchro);
            evts = new ArrayList<Evenement>();
            try {
                try {
                    pstm = connection.prepareStatement(requete);
                    if (ImportEvenementDAOJDBC.aUneDerniereSynchro(derniereSynchro)) {
                        pstm.setTimestamp(1, new Timestamp(derniereSynchro));
                    }
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        try {
                            evts.add(this.ligneToEvenement(rs, config));
                        }
                        catch (Exception e) {
                            Log.error("ERREUR INTEGRATION EVENEMENT BG ", e);
                        }
                    }
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return evts;
    }

    private Evenement getEvenementExistant(Nature nature, String code) {
        ArrayList evenements = new ArrayList();
        ArrayList<String> nat = new ArrayList<String>(1);
        nat.add(nature.getCode());
        IBusinessService.EvenementFiltre f = IBusinessService.EvenementFiltre.byNatures(null, null, nat);
        f.etat = 1;
        ArrayList<FiltreJava> fj = new ArrayList<FiltreJava>(1);
        ChampTexte c = new ChampTexte(CHAMP_CODE_EVENEMENT);
        ArrayList valeurs = new ArrayList();
        FiltreChampTexte filtreCode = new FiltreChampTexte(nature, (Champ)c, valeurs);
        fj.add((FiltreJava)filtreCode);
        List<Situation> situations = this.evtsDAO.getEvenements(f, fj);
        if (!GLS.estVide(situations)) {
            for (Situation s : situations) {
                evenements.addAll(s.getEvenements());
            }
        }
        if (evenements.isEmpty()) {
            return null;
        }
        return (Evenement)evenements.get(0);
    }

    public Evenement ligneToEvenement(ResultSet rs, BgBDDConfig conf) throws Exception {
        float[][] coordonnees;
        Position pointDebut = new Position();
        Position pointFin = new Position();
        PGgeometry geom = null;
        String champCoordonnees = this.getChampBGFromPrism(conf, CHAMP_COORDONNEES);
        if (DAOFactory.getValueFromResultSet(rs, champCoordonnees, null) != null) {
            geom = (PGgeometry)rs.getObject(champCoordonnees);
            coordonnees = Geometry.getPointsToFloat((PGgeometry)geom);
            if (geom.getGeometry() instanceof Point) {
                Point p1 = (Point)geom.getGeometry();
                pointDebut.setX((float)p1.getX());
                pointDebut.setY((float)p1.getY());
                pointDebut.setAltitude((float)p1.getZ());
                pointFin = null;
            } else if (geom.getGeometry() instanceof LineString) {
                LineString ls = (LineString)geom.getGeometry();
                Point p1 = ls.getFirstPoint();
                Point p2 = ls.getLastPoint();
                pointDebut.setX((float)p1.getX());
                pointDebut.setY((float)p1.getY());
                pointDebut.setAltitude((float)p1.getZ());
                pointFin.setX((float)p2.getX());
                pointFin.setY((float)p2.getY());
                pointFin.setAltitude((float)p2.getZ());
            }
        } else {
            Object coordonnees2 = null;
            throw new Exception("COORDONNEES NULLES - " + conf.getCodeNature());
        }
        this.refDAO.getNatures();
        if (this.refDAO.getNatureMap().containsKey(conf.getCodeNature())) {
            IDescription desc;
            Evenement evenement;
            String codeBG = this.getValeurString(rs, conf, CHAMP_CODE_EVENEMENT, null);
            Nature n = (Nature)DeepCopy.copy((Object)this.refDAO.getNatureMap().get(conf.getCodeNature()));
            Evenement evenementDejaExistant = null;
            if (!GLS.estVide((String)codeBG)) {
                evenementDejaExistant = this.getEvenementExistant(n, codeBG);
                if (evenementDejaExistant != null) {
                    if (DAOFactory.getValueFromResultSet(rs, CHAMP_DATE_MODIFICATION, null) == null) {
                        Log.error("Evenement deja int\u00e9gr\u00e9 avec une date de modification nulle " + codeBG);
                        throw new Exception("Evenement deja int\u00e9gr\u00e9 avec une date de modification nulle " + codeBG);
                    }
                    evenement = evenementDejaExistant;
                    evenement.setNumVersion(evenement.getNumVersion() + 1);
                    n.chargerValeurs(evenement.getValeurNature());
                } else {
                    evenement = new Evenement();
                    evenement.setIdReference(this.genereCodeBG(conf.getCodeNature(), codeBG));
                    evenement.setIdSituation(evenement.getIdReference());
                    evenement.setCodeEvenement(evenement.getIdReference());
                    evenement.setNumVersion(1);
                }
            } else {
                Log.debug("Aucun code evenement correspondant " + conf.getCodeNature());
                evenement = new Evenement();
                evenement.setNumVersion(1);
            }
            Map champs = MetierCommun.getChampsFiltresMap((Nature)n);
            this.majEvenement(conf, n, evenement, champs, rs);
            evenement.setValeurNature(n.extraireValeurs());
            ValeurChampCollectionChoixUnique d = evenement.getValeurNature().getDescription();
            ValeurChampLocalisation l = evenement.getValeurNature().getLocalisation();
            l.setPositionDebut(pointDebut);
            l.setPositionFin(pointFin);
            l.setX(coordonnees[0]);
            l.setY(coordonnees[1]);
            String axe = this.getValeurString(rs, conf, CHAMP_ROUTE, "");
            if (!GLS.estVide((String)axe)) {
                axe = axe.replace(" G", "");
            }
            l.setAxe(axe);
            l.setPrDebut(this.getValeurInt(rs, conf, CHAMP_PR_DEB, -1));
            l.setAbsPrDebut(this.getValeurInt(rs, conf, CHAMP_ABSPRDEB, -1));
            l.setPrFin(this.getValeurInt(rs, conf, CHAMP_PR_FIN, -1));
            l.setAbsPrFin(this.getValeurInt(rs, conf, CHAMP_ABSPRFIN, -1));
            List<DescriptionNature> listeDesc = this.refDAO.getDescriptionsNatureMap().get(n.getCode());
            evenement.setCodeUtilisateur("#BG");
            evenement.setType(3);
            Centre c = null;
            if (GLS.estDansLaListe((String[])conf.getPrismChamps(), (String)CHAMP_CENTRE)) {
                String champCentre = GLS.getCorrespondanceValeurListe((String)CHAMP_CENTRE, (String[])conf.getPrismChamps(), (String[])conf.getBgChamps());
                try {
                    c = MetierCommun.getCentreParNom(this.refDAO.getDelegations(), (String)rs.getString(champCentre));
                }
                catch (Exception e) {
                    Log.error("ERR CHAMP CENTRE", e);
                }
            } else {
                c = null;
            }
            evenement.setDateCreation(this.getValeurDate(rs, conf, CHAMP_DATE_CREATION, Calendar.getInstance().getTimeInMillis()));
            evenement.setDateMaj(this.getValeurDate(rs, conf, CHAMP_DATE_MODIFICATION, Calendar.getInstance().getTimeInMillis()));
            String description = this.getValeurString(rs, conf, CHAMP_DESCRIPTION, null);
            int iDesc = GLS.estVide((String)description) ? 0 : MetierCommun.getIndiceObjetListe(listeDesc, (Object)description);
            if (iDesc > -1) {
                desc = (IDescription)listeDesc.get(iDesc);
            } else {
                Log.error("erreur description nature impossible \u00e0 trouver ");
                desc = (IDescription)listeDesc.get(0);
            }
            if (c != null) {
                evenement.setDistrict(c.getDelegation());
                evenement.setCei(c.getNom());
            } else {
                Log.error("ERREUR CENTRE ");
            }
            d.setIndexSelectionnee(iDesc);
            d.setValeur(desc.getLibelle());
            evenement.setAnnule(false);
            evenement.setTermine(false);
            return evenement;
        }
        throw new Exception("Nature inexistante - " + conf.getCodeNature());
    }

    public void importationEvenement(String cheminFichier, String projection) throws Exception {
        FichierCSV fichier = new FichierCSV(cheminFichier);
        fichier.charger();
    }

    protected void majEvenement(BgBDDConfig conf, Nature n, Evenement evenement, Map<String, Champ> champs, ResultSet rs) {
        try {
            String[] stringArray = conf.getPrismChamps();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String champ = stringArray[n3];
                if (!GLS.estDansLaListe((String[])CHAMPS_SYSTEMES, (String)champ)) {
                    String champBg = this.getChampBGFromPrism(conf, champ);
                    if (champ != null) {
                        Object valeur = DAOFactory.getValueFromResultSet(rs, champBg, null);
                        if (valeur != null) {
                            Champ c = champs.get(champ);
                            if (c != null) {
                                c.setValeurChamp(c.parseValeur(String.valueOf(valeur)));
                            }
                        } else {
                            Log.error("Valeur nulle - champ prism ");
                        }
                    }
                }
                ++n3;
            }
        }
        catch (Exception e) {
            Log.error("", e);
        }
    }

    public String getChampBGFromPrism(BgBDDConfig conf, String champPrism) {
        String champ = null;
        if (GLS.estDansLaListe((String[])conf.getPrismChamps(), (String)champPrism)) {
            champ = GLS.getCorrespondanceValeurListe((String)champPrism, (String[])conf.getPrismChamps(), (String[])conf.getBgChamps());
        }
        return champ;
    }

    public Object getValeurObject(ResultSet rs, BgBDDConfig conf, String champPrism, Object defaut) {
        Object valeur = defaut;
        if (GLS.estDansLaListe((String[])conf.getPrismChamps(), (String)champPrism)) {
            String champ = GLS.getCorrespondanceValeurListe((String)champPrism, (String[])conf.getPrismChamps(), (String[])conf.getBgChamps());
            try {
                valeur = rs.getObject(champ);
            }
            catch (Exception e) {
                Log.error("ERR CHAMP MAJ", e);
            }
        }
        return valeur;
    }

    public long getValeurDate(ResultSet rs, BgBDDConfig conf, String champPrism, long defaut) {
        long date = defaut;
        if (GLS.estDansLaListe((String[])conf.getPrismChamps(), (String)champPrism)) {
            String champDate = GLS.getCorrespondanceValeurListe((String)champPrism, (String[])conf.getPrismChamps(), (String[])conf.getBgChamps());
            try {
                date = rs.getTimestamp(champDate).getTime();
            }
            catch (Exception e) {
                Log.error("ERR CHAMP MAJ", e);
            }
        }
        return date;
    }

    public String getValeurString(ResultSet rs, BgBDDConfig conf, String champPrism, String defaut) {
        String valeur = defaut;
        if (GLS.estDansLaListe((String[])conf.getPrismChamps(), (String)champPrism)) {
            String champ = GLS.getCorrespondanceValeurListe((String)champPrism, (String[])conf.getPrismChamps(), (String[])conf.getBgChamps());
            try {
                valeur = rs.getString(champ);
            }
            catch (Exception e) {
                Log.error("ERR CHAMP MAJ", e);
            }
        }
        return valeur;
    }

    public int getValeurInt(ResultSet rs, BgBDDConfig conf, String champPrism, int defaut) {
        int valeur = defaut;
        if (GLS.estDansLaListe((String[])conf.getPrismChamps(), (String)champPrism)) {
            String champ = GLS.getCorrespondanceValeurListe((String)champPrism, (String[])conf.getPrismChamps(), (String[])conf.getBgChamps());
            try {
                valeur = rs.getInt(champ);
            }
            catch (Exception e) {
                Log.error("ERR CHAMP MAJ", e);
            }
        }
        return valeur;
    }

    private void remplirBgCorresEvenements() {
        block6: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(SQL_BG_CORRES_EVENEMENTS);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        BgBDDConfig conf = new BgBDDConfig();
                        conf.setCodeNature(rs.getString("code_nature"));
                        conf.setRequete(rs.getString("requete"));
                        conf.setBgChamps(GLS.getTableauString((String)rs.getString("bg_champs"), (String)";"));
                        conf.setPrismChamps(GLS.getTableauString((String)rs.getString("prism_champs"), (String)";"));
                        conf.setChampDate(rs.getString("champ_date"));
                        configBgBdd.add(conf);
                    }
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    private void remplirCorrespondances() {
        block7: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(SQL_CORRESPONDANCES);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        String cle = rs.getString(CLE);
                        Map<String, String> corresCle = correspondances.get(cle);
                        if (corresCle == null) {
                            corresCle = new HashMap<String, String>();
                            correspondances.put(cle, corresCle);
                        }
                        corresCle.put(rs.getString(CODE_IMPORT), rs.getString(CODE_PRISM));
                    }
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public List<BgBDDConfig> getCorresBgBDDConfig() {
        if (configBgBdd == null) {
            this.init();
        }
        return configBgBdd;
    }

    @Override
    public Map<String, String> getCorrespondance(String cle) {
        if (correspondances == null) {
            this.init();
        }
        return correspondances.get(cle);
    }
}

