/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ZoneSensible;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IImportDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.geometry.PGGeometryConverter;
import gls.localisation.pr.LocalisantPr;
import gls.outils.GLS;
import gls.outils.fichier.Fichier;
import gls.outils.fichier.FichierCSV;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.postgis.Geometry;
import org.postgis.LineString;
import org.postgis.MultiLineString;
import org.postgis.PGgeometry;

public class ImportDAOJDBC
implements IImportDAO {
    private static final String LOG = "ImportDAOJDBC";
    private static final String PARAMETRE_NOM_TABLE = "$1";
    private static final String PARAMETRE_NOM_CHAMP = "$2";
    private static final String CHAMP_CLE_ID_NIVEAU = "ID";
    private static final int INDICE_CHAMP_ID_NIVEAU = 0;
    private static final String CHAMP_CLE_UTILISATEUR = "sna";
    private static final int INDICE_CHAMP_NOM_DEFAUT = 1;
    private static final int INDICE_CHAMP_SNA_DEFAUT = 0;
    private static final int INDICE_CHAMP_DELEGATION_DEFAUT = 2;
    private static final int INDICE_CHAMP_CENTRE_DEFAUT = 3;
    private static final int INDICE_CHAMP_PROFIL_DEFAUT = 4;
    private static final int INDICE_CHAMP_PASSWORD_DEFAUT = 5;
    private DAOFactory daoFactory;
    private static final String INSERT_UTILISATEUR = "insert into prism.utilisateur (nom,sna,delegation,centre,id_profil,mse,type,synchrodate,password,type_utilisateur,id_district,code_mode_vh,archive,id_utilisateur) values (?,?,?,?,(select p.id from prism.profil p where lower(nom)=lower(?)),?,1,now(),?,1,0,1,0,nextval('k_userid'));";
    private static final String INSERT_TRONCON_CARACTERISTIQUE = "INSERT INTO $1(description, departementprdebut, axe, coordonnees, abscisseprdebut,prdebut, departementprfin, longueur, prfin, abscisseprfin,$2,delegation,centre) VALUES (?, ?, ?, ?,?, ?, ?, ?, ?, ?,?,?,?);";
    private static final String INSERT_ZONE_SENSIBLE = "INSERT INTO donnees_metier.zone_sensible(description, departementprdebut, axe, coordonnees, abscisseprdebut,prdebut, departementprfin, longueur, prfin, abscisseprfin,fk_niveau_service,delegation,centre,sens,voie,vitesse,couleur,code_type_zone_sensible,zone_routiere) VALUES (?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?);";
    private static final String INSERT_BARREAU_VH = "INSERT INTO donnees_metier.troncon_circuit_ext (description, departementprdebut, axe, coordonnees, abscisseprdebut, prdebut, departementprfin, longueur, prfin, abscisseprfin, idcircuit, indice, croisement_1, croisement_2, id_groupe, centre, troncon_id, id_patrouilleur, maj, status, maj_transmis, maj_id_partenaire, buffer_test, delegation, obligatoire, grammage, largeur, fk_niveau_service, sens) VALUES(?, ?, ?, ?, ?, ?, ?, -1, ?, ?, 0, 0, '', '', ?, ?, ?, -1, now(), 'NR', now(), -1, null, ?, true, 0, 0, 0, ?);";

    public ImportDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public void importUtilisateurs(String fichierCSV) {
        block19: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            FichierCSV f = null;
            if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
                f = new FichierCSV(fichierCSV);
            } else {
                try {
                    f = new FichierCSV();
                }
                catch (Exception e) {
                    Log.error("ERREUR fichier impossible \u00e0 ouvrir", e);
                }
            }
            Log.info("ImportDAOJDBCD\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            if (f != null && f.isReady()) {
                try {
                    try {
                        int indice;
                        try {
                            indice = f.getIndiceChamp(CHAMP_CLE_UTILISATEUR);
                        }
                        catch (Exception ex) {
                            indice = 0;
                        }
                        f.initialiser();
                        f.setIndiceChampCle(indice);
                        f.charger();
                        connection = this.daoFactory.getConnection();
                        pstm = connection.prepareStatement(INSERT_UTILISATEUR);
                        for (String[] ligne : f.values()) {
                            pstm.setString(1, ligne[1]);
                            pstm.setString(2, ligne[0]);
                            if (GLS.estVide((String)ligne[2])) {
                                pstm.setNull(3, 12);
                            } else {
                                pstm.setString(3, ligne[2]);
                            }
                            if (GLS.estVide((String)ligne[3])) {
                                pstm.setNull(4, 12);
                            } else {
                                pstm.setString(4, ligne[3]);
                            }
                            pstm.setString(5, ligne[4]);
                            pstm.setString(6, ConfigurationFactory.getInstance().get("zoneroutiere"));
                            pstm.setString(7, ligne[5]);
                            try {
                                pstm.execute();
                            }
                            catch (Exception e) {
                                Log.error(LOG.concat(" - Erreur importation utilisateur").concat(GLS.getString((String[])ligne)), e);
                            }
                            pstm.clearParameters();
                        }
                    }
                    catch (Exception e) {
                        Log.error("erreur lors de l'import des utilisateurs", e);
                        DAOUtil.close(connection, pstm, rs);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(connection, pstm, rs);
            }
        }
    }

    @Override
    public void importTronconsPr(String table, String nomChamp, String fichierCSV) {
        block17: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            FichierCSV f = null;
            if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
                f = new FichierCSV(fichierCSV);
            } else {
                try {
                    f = new FichierCSV();
                }
                catch (Exception e) {
                    Log.error("ERREUR fichier impossible \u00e0 ouvrir", e);
                }
            }
            Log.info("ImportDAOJDBCD\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            if (f != null && f.isReady()) {
                try {
                    try {
                        f.initialiser();
                        f.setIndiceChampCle(-1);
                        f.charger();
                        connection = this.daoFactory.getConnection();
                        pstm = connection.prepareStatement(INSERT_TRONCON_CARACTERISTIQUE.replace(PARAMETRE_NOM_TABLE, table).replace(PARAMETRE_NOM_CHAMP, nomChamp));
                        for (String[] ligne : f.values()) {
                            pstm.setString(1, "-");
                            pstm.setString(2, "-");
                            pstm.setString(3, ligne[0]);
                            pstm.setNull(4, 0);
                            pstm.setInt(5, GLS.getInt((String)ligne[2]));
                            pstm.setInt(6, GLS.getInt((String)ligne[1]));
                            pstm.setString(7, "-");
                            pstm.setInt(8, -1);
                            pstm.setInt(9, GLS.getInt((String)ligne[3]));
                            pstm.setInt(10, GLS.getInt((String)ligne[4]));
                            pstm.setString(11, ligne[5]);
                            if (ligne.length > 6 && !GLS.estVide((String)ligne[6])) {
                                pstm.setString(12, ligne[6]);
                            } else {
                                pstm.setNull(12, 0);
                            }
                            if (ligne.length > 7 && !GLS.estVide((String)ligne[7])) {
                                pstm.setString(13, ligne[7]);
                            } else {
                                pstm.setNull(13, 0);
                            }
                            try {
                                pstm.execute();
                            }
                            catch (Exception e) {
                                Log.error(LOG.concat(" - Erreur importation " + table).concat(GLS.getString((String[])ligne)), e);
                            }
                            pstm.clearParameters();
                        }
                    }
                    catch (Exception e) {
                        Log.error("erreur lors de l'import des utilisateurs", e);
                        DAOUtil.close(connection, pstm, rs);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(connection, pstm, rs);
            }
        }
    }

    @Override
    public void importNiveauxExploitation(String fichierCSV) {
        this.importTronconsPr("donnees_metier.niveau_exploitation", "niveau", fichierCSV);
    }

    @Override
    public void importZoneOmbre(String fichierCSV) {
        block17: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            FichierCSV f = null;
            if (!GLS.estVide((String)fichierCSV) && Fichier.existe((String)fichierCSV)) {
                f = new FichierCSV(fichierCSV, StandardCharsets.UTF_8);
            } else {
                try {
                    f = new FichierCSV();
                }
                catch (Exception e) {
                    Log.error("ERREUR fichier impossible \u00e0 ouvrir", e);
                }
            }
            Log.info("ImportDAOJDBCD\u00e9but de l'importation du fichier - " + f.getCheminFichier());
            if (f != null && f.isReady()) {
                try {
                    try {
                        f.setIndiceChampCle(-1);
                        f.charger();
                        connection = this.daoFactory.getConnection();
                        pstm = connection.prepareStatement(INSERT_ZONE_SENSIBLE);
                        for (String[] ligne : f.values()) {
                            LocalisantPr prDebut = new LocalisantPr(ligne[1]);
                            LocalisantPr prFin = new LocalisantPr(ligne[2]);
                            int sens = -1;
                            MetierCommun.instanceOf();
                            int sensFichier = MetierCommun.getSensZone((String)ligne[3]);
                            if (prDebut.estAvant(prFin)) {
                                sens = 1;
                                if (sensFichier == 0) {
                                    sens = sensFichier;
                                    prDebut = new LocalisantPr(ligne[2]);
                                    prFin = new LocalisantPr(ligne[1]);
                                }
                            } else {
                                sens = 0;
                                if (sensFichier == 1) {
                                    sens = sensFichier;
                                    prDebut = new LocalisantPr(ligne[2]);
                                    prFin = new LocalisantPr(ligne[1]);
                                }
                            }
                            pstm.setString(1, ligne.length > 7 ? ligne[7] : "");
                            pstm.setString(2, String.valueOf(prDebut.getDepartement()));
                            pstm.setString(3, ligne[0]);
                            pstm.setNull(4, 0);
                            pstm.setInt(5, (int)prDebut.getDistancePr());
                            pstm.setInt(6, prDebut.getPr());
                            pstm.setString(7, String.valueOf(prFin.getDepartement()));
                            pstm.setInt(8, -1);
                            pstm.setInt(9, prFin.getPr());
                            pstm.setInt(10, (int)prFin.getDistancePr());
                            pstm.setNull(11, 0);
                            pstm.setNull(12, 0);
                            pstm.setNull(13, 0);
                            pstm.setInt(14, sens);
                            pstm.setString(15, ligne[4]);
                            pstm.setInt(16, ligne.length > 6 ? GLS.getInt((String)ligne[6]) : -1);
                            pstm.setString(17, ligne[5]);
                            pstm.setInt(18, 0);
                            try {
                                pstm.execute();
                            }
                            catch (Exception e) {
                                Log.error(LOG.concat(" - Erreur importation zone d'ombre").concat(GLS.getString((String[])ligne)), e);
                            }
                            pstm.clearParameters();
                        }
                    }
                    catch (Exception e) {
                        Log.error("erreur lors de l'import des utilisateurs", e);
                        DAOUtil.close(connection, pstm, rs);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
                DAOUtil.close(connection, pstm, rs);
            }
        }
    }

    public void importZoneOmbre(List<ZoneSensible> zonesOmbre) {
        block6: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(INSERT_ZONE_SENSIBLE);
                    for (ZoneSensible zoneOmbre : zonesOmbre) {
                        this.importZoneOmbre(zoneOmbre);
                    }
                }
                catch (SQLException e) {
                    Log.error("erreur lors de l'import des zones d'ombre", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public void importZoneOmbre(ZoneSensible zoneOmbre) {
        block14: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(INSERT_ZONE_SENSIBLE);
                    LocalisantPr prDebut = new LocalisantPr(zoneOmbre.getPrDebut(), (long)zoneOmbre.getAbscissePrDebut());
                    LocalisantPr prFin = new LocalisantPr(zoneOmbre.getPrFin(), (long)zoneOmbre.getAbscissePrFin());
                    int sens = -1;
                    MetierCommun.instanceOf();
                    int sensFichier = MetierCommun.getSensZone((String)(zoneOmbre.getSensPr() == 1 ? "Positif" : "N\u00e9gatif"));
                    if (prDebut.estAvant(prFin)) {
                        sens = 1;
                        if (sensFichier == 0) {
                            sens = sensFichier;
                            prDebut = new LocalisantPr(zoneOmbre.getPrFin(), (long)zoneOmbre.getAbscissePrFin());
                            prFin = new LocalisantPr(zoneOmbre.getPrDebut(), (long)zoneOmbre.getAbscissePrFin());
                        }
                    } else {
                        sens = 0;
                        if (sensFichier == 1) {
                            sens = sensFichier;
                            prDebut = new LocalisantPr(zoneOmbre.getPrFin(), (long)zoneOmbre.getAbscissePrFin());
                            prFin = new LocalisantPr(zoneOmbre.getPrDebut(), (long)zoneOmbre.getAbscissePrFin());
                        }
                    }
                    if (zoneOmbre.getDescription() == null) {
                        zoneOmbre.setDescription("");
                    }
                    pstm.setString(1, zoneOmbre.getDescription());
                    pstm.setString(2, zoneOmbre.getDepartementPrDebut());
                    String axeVerifie = MetierCommun.verificationAxe((String)zoneOmbre.getAxe());
                    pstm.setString(3, axeVerifie);
                    try {
                        String geometrieString = PGGeometryConverter.convert((List)zoneOmbre.getXs(), (List)zoneOmbre.getYs(), null, null);
                        Object geom = null;
                        geom = zoneOmbre.getXs().size() == 1 ? new LineString(geometrieString) : new MultiLineString(geometrieString);
                        geom.setSrid(32630);
                        pstm.setObject(4, new PGgeometry((Geometry)geom));
                    }
                    catch (Exception e) {
                        pstm.setNull(4, 0);
                    }
                    pstm.setInt(5, (int)prDebut.getDistancePr());
                    pstm.setInt(6, prDebut.getPr());
                    pstm.setString(7, zoneOmbre.getDepartementPrFin());
                    pstm.setInt(8, zoneOmbre.getLongueur() == 0 ? -1 : zoneOmbre.getLongueur());
                    pstm.setInt(9, prFin.getPr());
                    pstm.setInt(10, (int)prFin.getDistancePr());
                    pstm.setNull(11, 0);
                    pstm.setNull(12, 0);
                    pstm.setNull(13, 0);
                    pstm.setInt(14, sens);
                    pstm.setString(15, zoneOmbre.getVoie());
                    pstm.setInt(16, zoneOmbre.getVitesse());
                    pstm.setString(17, zoneOmbre.getCouleur().toString());
                    pstm.setInt(18, 0);
                    pstm.setString(19, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    try {
                        pstm.execute();
                    }
                    catch (Exception e) {
                        Log.error(LOG.concat(" - Erreur importation zone d'ombre" + zoneOmbre), e);
                    }
                    pstm.close();
                    String updateLongueurSRIDRequete = "UPDATE donnees_metier.zone_sensible SET longueur = st_length(coordonnees), coordonnees=st_transform(coordonnees, 4326) WHERE longueur = -1 AND coordonnees IS NOT NULL";
                    pstm = connection.prepareStatement(updateLongueurSRIDRequete);
                    pstm.execute();
                }
                catch (SQLException e1) {
                    Log.error("erreur lors de l'import des zones d'ombre", e1);
                    DAOUtil.close(connection, pstm, rs);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public void importBarreauVH(BarreauVH barreauVh) {
        block11: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(INSERT_BARREAU_VH);
                    pstm.setString(1, barreauVh.getDescription());
                    pstm.setString(2, barreauVh.getDepartementPrDebut());
                    pstm.setString(3, barreauVh.getAxe());
                    try {
                        String geometrieString = PGGeometryConverter.convert((List)barreauVh.getXs(), (List)barreauVh.getYs(), null, null);
                        Object geom = null;
                        geom = barreauVh.getXs().size() == 1 ? new LineString(geometrieString) : new MultiLineString(geometrieString);
                        geom.setSrid(32630);
                        pstm.setObject(4, new PGgeometry((Geometry)geom));
                    }
                    catch (Exception e) {
                        pstm.setObject(4, 0);
                    }
                    pstm.setInt(5, barreauVh.getAbscissePrDebut());
                    pstm.setInt(6, barreauVh.getPrDebut());
                    pstm.setString(7, barreauVh.getDepartementPrFin());
                    pstm.setInt(8, barreauVh.getPrFin());
                    pstm.setInt(9, barreauVh.getAbscissePrFin());
                    pstm.setString(10, barreauVh.getIdGroupe());
                    pstm.setString(11, barreauVh.getCentre());
                    pstm.setString(12, barreauVh.getTronconID());
                    pstm.setString(13, barreauVh.getDelegation());
                    if (barreauVh.getSens().equalsIgnoreCase("positif") || barreauVh.getSens().equalsIgnoreCase("1")) {
                        pstm.setInt(14, 1);
                    } else if (barreauVh.getSens().equalsIgnoreCase("negatif") || barreauVh.getSens().equalsIgnoreCase("n\u00e9gatif") || barreauVh.getSens().equalsIgnoreCase("0")) {
                        pstm.setInt(14, 0);
                    } else {
                        pstm.setInt(14, 2);
                    }
                    pstm.execute();
                }
                catch (SQLException e) {
                    Log.error("erreur lors de l'import des barreaux vh", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
    }

    @Override
    public void updateGeometryBarreauVH() {
        String requeteVH = "UPDATE donnees_metier.troncon_circuit_ext SET longueur=st_length(st_setsrid(coordonnees,32630)), coordonnees=st_transform(st_setsrid(coordonnees,32630), 4326) WHERE coordonnees is not null";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requeteVH);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm);
            throw throwable;
        }
        DAOUtil.close(null, pstm);
    }

    @Override
    public void updateDonnesVH() {
        String requeteVH = "INSERT INTO vh.donnees_vh_troncon(cch, cch2, tendancecc, traitement, meteo, commentaire, equipements, etat_chaussee, temperature, date, vent, duree, commentaire_interne, sens, publie, id)(select 'NR','NR', '=', 'NR','NR','NR','NR', '','','now()','',(select COALESCE(valeur::integer,2) from prism.configuration WHERE champ ='validiteTronconVH') ,'','les 2 sens','false',id from donnees_metier.troncon_circuit_ext)";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requeteVH);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(null, pstm);
            throw throwable;
        }
        DAOUtil.close(null, pstm);
    }
}

