/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.DonneesSynchro;
import com.geolocsystems.prismandroid.model.FauchageCircuitPasse;
import com.geolocsystems.prismandroid.model.FauchagePasse;
import com.geolocsystems.prismandroid.model.FauchagePasseType;
import com.geolocsystems.prismandroid.model.Point;
import com.geolocsystems.prismandroid.model.Releve;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TronconFauchage;
import com.geolocsystems.prismbirtbean.SyntheseTableauBordStatistiqueFauchageBean;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IFauchageDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.geometry.Geometry;
import gls.outils.GLS;
import gls.outils.GLSDate;
import gls.outils.sql.SQL;
import java.awt.geom.Point2D;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.postgis.PGgeometry;

public class FauchageDAOJDBC
implements IFauchageDAO {
    private static final String REQUETE_FAUCHAGE_PAR_DELEGATION_CENTRE = "select id_troncon,abs_pr_deb,pr_debut,abs_pr_fin,pr_fin,axe,centre,delegation,premiere_date_passage,derniere_date_passage,annee,longueur,nb_passage,st_transform(lateralize_line(coordonnees, 30, 1),4326) as coordonnees from fauchage.carte_fauchage where zone_routiere = ? and (delegation = ? or delegation is null) and (centre =? or centre is null) and (derniere_date_passage is null or derniere_date_passage > ?) and premiere_date_passage between ? and ? order by premiere_date_passage";
    private static final String REQUETE_FAUCHAGE_PAR_DELEGATION = "select id_troncon,abs_pr_deb,pr_debut,abs_pr_fin,pr_fin,axe,centre,delegation,premiere_date_passage,derniere_date_passage,annee,longueur,nb_passage,st_transform(lateralize_line(coordonnees, 30, 1),4326) as coordonnees from fauchage.carte_fauchage where zone_routiere = ? and (delegation = ? or delegation is null) and (derniere_date_passage is null or derniere_date_passage > ?) and premiere_date_passage between ? and ? order by premiere_date_passage";
    private static final String REQUETE_FAUCHAGE = "select id_troncon,abs_pr_deb,pr_debut,abs_pr_fin,pr_fin,axe,centre,delegation,premiere_date_passage,derniere_date_passage,annee,longueur,nb_passage,st_transform(lateralize_line(coordonnees, 30, 1),4326) as coordonnees from fauchage.carte_fauchage where zone_routiere = ? and (derniere_date_passage is null or derniere_date_passage > ?) and premiere_date_passage between ? and ? order by premiere_date_passage";
    private static final String REQUETE_DEBROUSSAILLAGE_PAR_DATE = "select axedeb,prdeb,communedeb,axefin,prfin,communefin,senspr,code_releve,mcig_id,l4,l20,den,arb,clo,voie,znc,zad,zd,date,st_transform(lateralize_line(coordonnees, (CASE l20 WHEN 'oui' THEN 15 ELSE 10 END), 1),4326) as coordonnees,longueur from fauchage.debroussaillage where date is null or date between ? and ? order by date";
    private static final String REQUETE_INSERTION_DEBROUSSAILLAGE = null;
    private DAOFactory daoFactory;

    public FauchageDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public List<TronconFauchage> getTronconFauchage(Delegation delegation, Centre centre, Calendar dateDebut, Calendar dateFin) {
        ArrayList<TronconFauchage> troncons;
        block17: {
            troncons = null;
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    String requete = delegation == null && centre == null ? REQUETE_FAUCHAGE : (centre == null ? REQUETE_FAUCHAGE_PAR_DELEGATION : REQUETE_FAUCHAGE_PAR_DELEGATION_CENTRE);
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    if (delegation == null && centre == null) {
                        pstm.setDate(2, new Date(dateFin.getTimeInMillis()));
                        pstm.setDate(3, new Date(dateDebut.getTimeInMillis()));
                        pstm.setDate(4, new Date(dateFin.getTimeInMillis()));
                    } else if (centre == null) {
                        pstm.setString(2, delegation.getNom());
                        pstm.setDate(3, new Date(dateFin.getTimeInMillis()));
                        pstm.setDate(4, new Date(dateDebut.getTimeInMillis()));
                        pstm.setDate(5, new Date(dateFin.getTimeInMillis()));
                    } else {
                        pstm.setString(2, delegation.getNom());
                        pstm.setString(3, centre.getNom());
                        pstm.setDate(4, new Date(dateFin.getTimeInMillis()));
                        pstm.setDate(5, new Date(dateDebut.getTimeInMillis()));
                        pstm.setDate(6, new Date(dateFin.getTimeInMillis()));
                    }
                    Log.debug("[FAUCHAGE] Requete fauchage " + pstm.toString());
                    rs = pstm.executeQuery();
                    troncons = new ArrayList<TronconFauchage>();
                    while (rs.next()) {
                        TronconFauchage t = new TronconFauchage();
                        t.setAbscissePrDebut(rs.getInt("abs_pr_deb"));
                        t.setPrDebut(rs.getInt("pr_debut"));
                        t.setAbscissePrFin(rs.getInt("abs_pr_fin"));
                        t.setPrFin(rs.getInt("pr_fin"));
                        t.setAxe(rs.getString("axe"));
                        t.setCentre(rs.getString("centre"));
                        t.setDelegation(rs.getString("delegation"));
                        GLS.getDate();
                        t.setPremiereDatePassage(GLSDate.toDate((long)rs.getDate("premiere_date_passage").getTime()));
                        if (rs.getObject("derniere_date_passage") != null) {
                            GLS.getDate();
                            t.setDerniereDatePassage(GLSDate.toDate((long)rs.getDate("derniere_date_passage").getTime()));
                        } else {
                            t.setDerniereDatePassage(null);
                        }
                        t.setAnnee(rs.getInt("annee"));
                        t.setLongueur(rs.getInt("longueur"));
                        t.setId(rs.getString("id_troncon"));
                        t.setNbPassage(rs.getInt("nb_passage"));
                        try {
                            float[][] coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                t.setX(coordonnees[0]);
                                t.setY(coordonnees[1]);
                            } else {
                                t.setX(null);
                                t.setY(null);
                            }
                        }
                        catch (Exception e) {
                            t.setX(null);
                            t.setY(null);
                            Log.error("", e);
                        }
                        troncons.add(t);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block17;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return troncons;
    }

    @Override
    public List<TronconFauchage> getTronconDebroussaillage() {
        ArrayList<TronconFauchage> troncons;
        block11: {
            troncons = null;
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement("select * from fauchage.debroussaillage");
                    Log.debug("[FAUCHAGE DEBROUSSAILLAGE] Requete fauchage " + pstm.toString());
                    rs = pstm.executeQuery();
                    troncons = new ArrayList<TronconFauchage>();
                    while (rs.next()) {
                        TronconFauchage t = new TronconFauchage();
                        t.setPrDebut(1);
                        t.setPrFin(2);
                        t.setAxe(rs.getString("axedeb"));
                        try {
                            float[][] coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                t.setX(coordonnees[0]);
                                t.setY(coordonnees[1]);
                            } else {
                                t.setX(null);
                                t.setY(null);
                            }
                        }
                        catch (Exception e) {
                            t.setX(null);
                            t.setY(null);
                            Log.error("", e);
                        }
                        troncons.add(t);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return troncons;
    }

    @Override
    public List<Releve> getReleveDebroussaillage(Calendar dateDebut, Calendar dateFin) {
        ArrayList<Releve> troncons;
        block13: {
            troncons = null;
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(REQUETE_DEBROUSSAILLAGE_PAR_DATE);
                    dateDebut.set(11, 0);
                    dateDebut.set(12, 0);
                    dateDebut.set(13, 0);
                    dateFin.set(11, 23);
                    dateFin.set(12, 59);
                    dateFin.set(13, 59);
                    pstm.setTimestamp(1, new Timestamp(dateDebut.getTimeInMillis()), dateDebut);
                    pstm.setTimestamp(2, new Timestamp(dateFin.getTimeInMillis()), dateFin);
                    Log.debug("[RELEVE DEB] Requete releve " + pstm.toString());
                    rs = pstm.executeQuery();
                    troncons = new ArrayList<Releve>();
                    while (rs.next()) {
                        Releve r = new Releve();
                        r.setPrDebut(rs.getString("prdeb"));
                        r.setPrFin(rs.getString("prfin"));
                        r.setAxeFin(rs.getString("axefin"));
                        r.setAxeDebut(rs.getString("axedeb"));
                        r.setCommuneDebut(rs.getString("communedeb"));
                        r.setCommuneFin(rs.getString("communefin"));
                        r.setLargeur4m(rs.getString("l4"));
                        r.setLargeur20m(rs.getString("l20"));
                        r.setDense(rs.getString("den"));
                        r.setArbre(rs.getString("arb"));
                        r.setCloture(rs.getString("clo"));
                        r.setVoie(rs.getString("voie"));
                        r.setZnc(rs.getString("znc"));
                        r.setZad(rs.getString("zad"));
                        r.setZd(rs.getString("zd"));
                        r.setLongueur(rs.getInt("longueur"));
                        if (rs.getObject("date") != null) {
                            GLS.getDate();
                            r.setDate(GLSDate.toDate((long)rs.getDate("date").getTime()));
                        } else {
                            r.setDate(null);
                        }
                        try {
                            float[][] coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                r.setX(coordonnees[0]);
                                r.setY(coordonnees[1]);
                            } else {
                                r.setX(null);
                                r.setY(null);
                            }
                        }
                        catch (Exception e) {
                            r.setX(null);
                            r.setY(null);
                            Log.error("", e);
                        }
                        troncons.add(r);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return troncons;
    }

    @Override
    public void insertionReleveDebroussaillage(DonneesSynchro d, Releve r) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        String projection = ConfigurationFactory.getInstance().get("bdd.projection");
        try {
            try {
                String requete = "insert into fauchage.debroussaillage (axedeb,prdeb,communedeb,axefin,prfin,communefin,l4,l20,den,arb,clo,voie,znc,zad,zd,mcig_id,coordonnees,date,longueur) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,GeomFromText(?," + projection + "),?,?)";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                List l = MetierCommun.estDebroussaillageVD((String)r.getVoie()) ? d.getVh().getPositions() : MetierCommun.inverser((List)d.getVh().getPositions());
                float[][] f = MetierCommun.toFloat((List)l);
                pstm.setString(1, r.getAxeDebut());
                pstm.setString(2, r.getPrDebut());
                pstm.setString(3, r.getCommuneDebut());
                pstm.setString(4, r.getAxeFin());
                pstm.setString(5, r.getPrFin());
                pstm.setString(6, r.getCommuneFin());
                pstm.setString(7, r.getLargeur4m());
                pstm.setString(8, r.getLargeur20m());
                pstm.setString(9, r.getDense());
                pstm.setString(10, r.getArbre());
                pstm.setString(11, r.getCloture());
                pstm.setString(12, r.getVoie());
                pstm.setString(13, r.getZnc());
                pstm.setString(14, r.getZad());
                pstm.setString(15, r.getZd());
                pstm.setString(16, d.getMainCourrante().getId());
                pstm.setString(17, SQL.getGeometryLineUTM((float[])f[0], (float[])f[1]));
                pstm.setTimestamp(18, new Timestamp(d.getDate()));
                pstm.setInt(19, Geometry.calculerLongueurLL((float[])f[0], (float[])f[1]));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<SyntheseTableauBordStatistiqueFauchageBean> getFauchageStatistiqueSchema(List<Centre> centres, Timestamp dateDebut, Timestamp dateFin, int bufferSize, int ratioParcours, String axe, boolean dateDernierPassageConnue) {
        ArrayList<SyntheseTableauBordStatistiqueFauchageBean> retour = new ArrayList<SyntheseTableauBordStatistiqueFauchageBean>();
        List<Troncon> troncons = null;
        java.util.Date dateMaj = GregorianCalendar.getInstance().getTime();
        HashMap<String, Integer> mapPourcentage = new HashMap<String, Integer>();
        HashMap<String, String[]> mapPatrouillesId = new HashMap<String, String[]>();
        HashMap<String, Vector<double[]>> mapPositionXs = new HashMap<String, Vector<double[]>>();
        HashMap<String, Vector<double[]>> mapPositionYs = new HashMap<String, Vector<double[]>>();
        HashMap<String, java.util.Date> mapDerniereDatePAssage = new HashMap<String, java.util.Date>();
        HashMap<String, Integer> mapDistanceCumulee = new HashMap<String, Integer>();
        troncons = this.getTronconsFromSchemaFauchage(centres, axe, false);
        this.getStatFauchageTronconTempsReel(centres, axe, bufferSize, mapPourcentage, mapPatrouillesId, mapPositionXs, mapPositionYs, mapDerniereDatePAssage, dateDebut, dateFin, dateDernierPassageConnue, mapDistanceCumulee);
        for (Troncon troncon : troncons) {
            retour.add(new SyntheseTableauBordStatistiqueFauchageBean(troncon.getId(), troncon.toString(), ((Integer)mapPourcentage.get(troncon.getId())).intValue(), -1, (String[])mapPatrouillesId.get(troncon.getId()), (java.util.Date)mapDerniereDatePAssage.get(troncon.getId()), dateMaj, (Vector)mapPositionXs.get(troncon.getId()), (Vector)mapPositionYs.get(troncon.getId()), String.valueOf(troncon.getPrDebut()), String.valueOf(troncon.getAbscissePrDebut()), String.valueOf(troncon.getPrFin()), String.valueOf(troncon.getAbscissePrFin()), null, null, troncon.getCircuit(), troncon.getClassification(), troncon.getLongueur(), ((Integer)mapDistanceCumulee.get(troncon.getId())).intValue()));
        }
        return retour;
    }

    private List<Troncon> getTronconsFromSchemaFauchage(List<Centre> centres, String axe, boolean avecGeometry) {
        ArrayList<Troncon> troncons = new ArrayList<Troncon>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String conditionWhere = "";
                String nomCentreSqlIn = "";
                if (centres != null && centres.size() > 0) {
                    for (Centre centre : centres) {
                        nomCentreSqlIn = String.valueOf(nomCentreSqlIn) + (nomCentreSqlIn.equals("") ? "" : ",") + "'" + centre.getNom().replaceAll("'", "''") + "'";
                    }
                    conditionWhere = "WHERE centre IN (" + nomCentreSqlIn + ")";
                }
                String axeWhere = "";
                if (axe != null && !"".equals(axe)) {
                    axeWhere = "axe = '" + axe + "'";
                    conditionWhere = String.valueOf(conditionWhere) + (conditionWhere.equals("") ? " WHERE " : " AND ") + axeWhere;
                }
                String sql = "SELECT * FROM fauchage.schema_fauchage " + conditionWhere;
                pstm = connection.prepareStatement(sql);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Troncon troncon = new Troncon();
                    troncon.setId(rs.getString("oid"));
                    troncon.setDepartementPrDebut(GLS.getString((String)rs.getString("deptd"), (String)""));
                    troncon.setAxe(rs.getString("axe"));
                    troncon.setDepartementPrFin(GLS.getString((String)rs.getString("deptf"), (String)""));
                    troncon.setPrDebut(rs.getInt("plod"));
                    troncon.setPrFin(rs.getInt("plof"));
                    troncon.setAbscissePrDebut(rs.getInt("absd"));
                    troncon.setAbscissePrFin(rs.getInt("absf"));
                    troncon.setCircuit(rs.getString("centre"));
                    troncon.setClassification(rs.getString("niveau_exploitation"));
                    try {
                        troncon.setLongueur(rs.getInt("longueur"));
                    }
                    catch (Exception e) {
                        troncon.setLongueur(-1);
                    }
                    if (avecGeometry) {
                        try {
                            float[][] coordonnees = null;
                            coordonnees = Geometry.getPointsToFloat((PGgeometry)((PGgeometry)rs.getObject("coordonnees")));
                            if (coordonnees != null) {
                                troncon.setPointDebut(new Point(coordonnees[0][0], coordonnees[1][0]));
                                troncon.setPointFin(new Point(coordonnees[0][coordonnees[0].length - 1], coordonnees[1][coordonnees[0].length - 1]));
                                troncon.setX(coordonnees[0]);
                                troncon.setY(coordonnees[1]);
                            } else {
                                troncon.setPointDebut(null);
                                troncon.setPointFin(null);
                                troncon.setX(null);
                                troncon.setY(null);
                            }
                        }
                        catch (Exception e) {
                            troncon.setX(null);
                            troncon.setY(null);
                            troncon.setPointDebut(null);
                            troncon.setPointFin(null);
                            Log.error("ERREUR COORDONNEES TRONCONS", e);
                        }
                    }
                    troncons.add(troncon);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return troncons;
    }

    private void getStatFauchageTronconTempsReel(List<Centre> centres, String axe, int bufferSize, Map<String, Integer> mapPourcentage, Map<String, String[]> mapPatrouillesId, Map<String, Vector<double[]>> mapPositionXs, Map<String, Vector<double[]>> mapPositionYs, Map<String, java.util.Date> mapDerniereDatePAssage, Timestamp dateDebut, Timestamp dateFin, boolean dateDernierPassageConnue, Map<String, Integer> mapDistanceCumulee) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String conditionWhere;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM fauchage.get_stats_fauchage(?,?,?,?,?,?)");
                String centresNomSQL = "";
                if (centres != null && centres.size() > 0) {
                    String centreWhere;
                    for (Centre centre : centres) {
                        centresNomSQL = String.valueOf(centresNomSQL) + (centresNomSQL.equals("") ? "" : ",") + "'" + centre.getNom().replace("'", "''") + "'";
                    }
                    centresNomSQL = centreWhere = "centre IN (" + centresNomSQL + ")";
                }
                String axeWhere = "";
                if (axe != null && !"".equals(axe)) {
                    axeWhere = "axe = '" + axe + "'";
                }
                String string = conditionWhere = axeWhere.equals("") && centresNomSQL.equals("") ? null : "oid IN (SELECT oid FROM fauchage.schema_fauchage WHERE % % % )";
                if (conditionWhere != null) {
                    conditionWhere = conditionWhere.replaceFirst("%", centresNomSQL);
                    conditionWhere = !axeWhere.equals("") && !centresNomSQL.equals("") ? conditionWhere.replaceFirst("%", "AND ") : conditionWhere.replaceFirst("%", "");
                    conditionWhere = conditionWhere.replaceFirst("%", axeWhere);
                }
                pstm.setTimestamp(1, dateDebut);
                pstm.setTimestamp(2, dateFin);
                pstm.setString(3, conditionWhere);
                pstm.setInt(4, bufferSize + 5);
                pstm.setObject(5, (Object)1, 2);
                pstm.setBoolean(6, dateDernierPassageConnue);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String[] derniersPassages = null;
                    Array arrayIdPatrouilles = rs.getArray("patrouille_id");
                    if (arrayIdPatrouilles != null) {
                        derniersPassages = (String[])arrayIdPatrouilles.getArray();
                    }
                    String tronocnID = String.valueOf(rs.getInt("id_troncon"));
                    mapPatrouillesId.put(tronocnID, derniersPassages);
                    mapPourcentage.put(tronocnID, rs.getInt("pourcentage"));
                    Timestamp dateDernierPassage = rs.getTimestamp("date_dernier_passage");
                    mapDerniereDatePAssage.put(tronocnID, dateDernierPassage);
                    try {
                        mapDistanceCumulee.put(tronocnID, rs.getInt("distance_cumulee_parcourue"));
                    }
                    catch (Exception e) {
                        mapDistanceCumulee.put(tronocnID, -1);
                    }
                    try {
                        Vector<double[]> xsML = new Vector<double[]>();
                        Vector<double[]> ysML = new Vector<double[]>();
                        Vector coordPArGeometry = SQL.getPoints2DByGeometry((org.postgis.Geometry)SQL.getChampGeometry((Object)rs.getObject("geom_non_parcourue")));
                        int k = 0;
                        while (k < coordPArGeometry.size()) {
                            Vector coord = (Vector)coordPArGeometry.get(k);
                            int nbPoint = coord.size();
                            double[] x = new double[nbPoint];
                            double[] y = new double[nbPoint];
                            int i = 0;
                            while (i < nbPoint) {
                                x[i] = ((Point2D.Double)coord.get((int)i)).x;
                                y[i] = ((Point2D.Double)coord.get((int)i)).y;
                                ++i;
                            }
                            xsML.add(x);
                            ysML.add(y);
                            ++k;
                        }
                        mapPositionXs.put(tronocnID, xsML);
                        mapPositionYs.put(tronocnID, ysML);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void creerFauchagePasse(FauchagePasse passe) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String requete = "insert into fauchage.passe_centre (passe_type_id, passe_debut, passe_fin,passe_delegation_id,passe_centre_nom,passe_coefficient) values (?,?,?,(select id from prism.delegation_rattachement where nom = ?),?,?)";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, passe.getType());
                pstm.setTimestamp(2, new Timestamp(passe.getPasseDebut()));
                pstm.setTimestamp(3, new Timestamp(passe.getPasseFin()));
                pstm.setString(4, passe.getDelegation());
                pstm.setString(5, passe.getCentre());
                pstm.setDouble(6, passe.getCoefficent());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void updateFauchagePasse(FauchagePasse passe) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                String requete = "update fauchage.passe_centre set passe_type_id=?, passe_debut=?, passe_fin=?,passe_delegation_id=(select id from prism.delegation_rattachement where nom = ? LIMIT 1),passe_centre_nom=?,passe_coefficient=? where passe_id = ?";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, passe.getType());
                pstm.setTimestamp(2, new Timestamp(passe.getPasseDebut()));
                pstm.setTimestamp(3, new Timestamp(passe.getPasseFin()));
                pstm.setString(4, passe.getDelegation());
                pstm.setString(5, passe.getCentre());
                pstm.setDouble(6, passe.getCoefficent());
                pstm.setDouble(7, passe.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public List<FauchagePasse> rechercheFauchage(String delegation, String centre) {
        ArrayList<FauchagePasse> passes;
        block7: {
            passes = null;
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            String REQUETE_PASSES = "SELECT passe_id, passe_type_id,(SELECT nom FROM prism.delegation_rattachement WHERE id = passe_delegation_id) as passe_delegation, passe_centre_nom,passe_coefficient,passe_debut,passe_fin FROM fauchage.passe_centre ";
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(REQUETE_PASSES);
                    Log.debug("[rechercheFauchage]Requete: " + pstm.toString());
                    rs = pstm.executeQuery();
                    passes = new ArrayList<FauchagePasse>();
                    while (rs.next()) {
                        FauchagePasse passe = new FauchagePasse();
                        passe.setId(rs.getInt("passe_id"));
                        passe.setType(rs.getInt("passe_type_id"));
                        passe.setDelegation(rs.getString("passe_delegation"));
                        passe.setCentre(rs.getString("passe_centre_nom"));
                        passe.setCoefficent(rs.getDouble("passe_coefficient"));
                        passe.setPasseDebut(rs.getTimestamp("passe_debut").getTime());
                        passe.setPasseFin(rs.getTimestamp("passe_fin").getTime());
                        passes.add(passe);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return passes;
    }

    @Override
    public List<FauchagePasseType> listeTypePasse() {
        ArrayList<FauchagePasseType> typePasses;
        block7: {
            typePasses = new ArrayList<FauchagePasseType>();
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            String REQUETE_PASSES = "SELECT passe_type_id, passe_type_libelle FROM fauchage.passe_type";
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(REQUETE_PASSES);
                    Log.debug("[rechercheFauchage]Requete: " + pstm.toString());
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        FauchagePasseType passe = new FauchagePasseType();
                        passe.setTypeId(rs.getInt("passe_type_id"));
                        passe.setLibelle(rs.getString("passe_type_libelle"));
                        typePasses.add(passe);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return typePasses;
    }

    @Override
    public List<FauchageCircuitPasse> rechercheFauchageCircuit(String delegation, String centre) {
        ArrayList<FauchageCircuitPasse> passes;
        block11: {
            passes = null;
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            String REQUETE_PASSES_PAR_DELEGATION_CENTRE = "SELECT passe_id, passe_id_circuit, passe_type_id,passe_coefficient,passe_debut,passe_fin, c.centre as centre, c.delegation as delegation FROM fauchage.passe_circuit pc, prism.circuit c WHERE pc.passe_fin IS null AND c.id = passe_id_circuit AND (c.delegation = ? or c.delegation is null) AND (c.centre =? or c.centre is null)";
            String REQUETE_PASSES_PAR_DELEGATION = "SELECT passe_id, passe_id_circuit, passe_type_id,passe_coefficient,passe_debut,passe_fin, c.centre as centre, c.delegation as delegation FROM fauchage.passe_circuit pc, prism.circuit c WHERE pc.passe_fin IS null AND c.id = passe_id_circuit AND (c.delegation = ? or c.delegation is null)";
            String REQUETE_PASSES = "SELECT passe_id, passe_id_circuit, passe_type_id,passe_coefficient,passe_debut,passe_fin, c.centre as centre, c.delegation as delegation FROM fauchage.passe_circuit pc, prism.circuit c WHERE pc.passe_fin IS null AND c.id = passe_id_circuit";
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    if (centre != null) {
                        pstm = connection.prepareStatement(REQUETE_PASSES_PAR_DELEGATION_CENTRE);
                        pstm.setString(1, delegation);
                        pstm.setString(2, centre);
                    } else if (delegation != null) {
                        pstm = connection.prepareStatement(REQUETE_PASSES_PAR_DELEGATION);
                        pstm.setString(1, delegation);
                    } else {
                        pstm = connection.prepareStatement(REQUETE_PASSES);
                    }
                    Log.debug("[rechercheFauchage]Requete: " + pstm.toString());
                    rs = pstm.executeQuery();
                    passes = new ArrayList<FauchageCircuitPasse>();
                    while (rs.next()) {
                        FauchageCircuitPasse passe = new FauchageCircuitPasse();
                        passe.setId(rs.getInt("passe_id"));
                        passe.setIdCircuit(rs.getInt("passe_id_circuit"));
                        passe.setType(rs.getInt("passe_type_id"));
                        passe.setCoefficent(rs.getDouble("passe_coefficient"));
                        passe.setPasseDebut(rs.getTimestamp("passe_debut").getTime());
                        passe.setDelegation(rs.getString("delegation"));
                        passe.setCentre(rs.getString("centre"));
                        passes.add(passe);
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return passes;
    }

    @Override
    public void updateFauchageCircuitPasse(FauchageCircuitPasse passe) {
        String requete;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                requete = "update fauchage.passe_circuit set  passe_fin=? where passe_id_circuit=? and passe_fin is null";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setTimestamp(1, new Timestamp(passe.getPasseDebut()));
                pstm.setInt(2, passe.getIdCircuit());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        try {
            try {
                requete = "insert into fauchage.passe_circuit(passe_type_id, passe_debut, passe_fin,passe_coefficient,passe_id_circuit) values (?, ?, ?,?, ?)";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, passe.getType());
                pstm.setTimestamp(2, new Timestamp(passe.getPasseDebut()));
                pstm.setNull(3, 93);
                pstm.setDouble(4, passe.getCoefficent());
                pstm.setInt(5, passe.getIdCircuit());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(connection, pstm, rs);
        }
    }
}

