/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IExportDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.DebutFinIntervention;
import com.geolocsystems.prismcentral.beans.InformationInterventionBean;
import com.geolocsystems.prismcentral.beans.InterventionAgentBean;
import com.geolocsystems.prismcentral.beans.NatureExport;
import com.geolocsystems.prismcentral.beans.SyntheseInterventionAgentBean;
import com.geolocsystems.prismcentral.beans.apachepoi.ApachePoiConvert;
import com.geolocsystems.prismcentral.beans.apachepoi.ApachePoiConvertElement;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExportDAOJDBC
implements IExportDAO {
    private DAOFactory daoFactory;
    private static final String SQL_GETNATURESEXPORT = "SELECT code, document, formats, type, titre, champs, libelle, code_mm FROM prism.nature_export WHERE zone_routiere = ? ORDER BY indice ASC";
    private static final String SQL_GETNATURESEXPORTPARCODE = "SELECT code, document, formats, type, titre, champs, libelle, code_mm FROM prism.nature_export WHERE zone_routiere = ? AND (code = ? OR code = '*') AND (code_mm = ? OR code_mm = -1) ORDER BY indice ASC";
    private static final String SQL_GETNATURESEXPORTPARCODES = "SELECT code, document, formats, type, titre, champs, libelle, code_mm FROM prism.nature_export WHERE zone_routiere = ? AND (code = ANY(?) OR code = '*') AND (code_mm = ANY(?) OR code_mm = -1)";
    private static final String SQL_GETNATURESEXPORTPARCODEETFORMAT = "SELECT code, document, formats, type, titre, champs, libelle, code_mm FROM prism.nature_export WHERE zone_routiere = ? AND (code = ? OR code = '*') AND (code_mm = ? OR code_mm = -1) AND formats LIKE ? ORDER BY indice ASC";
    private static final String SQL_GET_NATUREEXPORT_PAR_CODE_ET_LIBELLE = "SELECT document, formats, type, titre, champs, code_mm FROM prism.nature_export WHERE zone_routiere = ? AND code = ? AND libelle = ?;";
    private static final String SQL_GET_APACHE_POI_CONVERT = "SELECT id_config, direction_multiple, libelle FROM apache_poi_convert WHERE id_config = ?;";
    private static final String SQL_GET_APACHE_POI_CONVERT_ELEMENTS = "SELECT id_config, objet, champ, feuille, ligne, colonne, groupe, ordre, position FROM apache_poi_convert_element WHERE id_config = ? ORDER BY groupe ASC, ordre ASC;";
    private static final String SQL_GET_PARAMETRES_PATROUILLE = "select parametres from patrouille where id in (SELECT distinct e.id_patrouille FROM evenement e where concat(e.snm,e.erf) in (select concat(e2.snm, e2.erf) from evenement e2 WHERE e2.k_eventid = ?))";
    private static final String SQL_GET_DATE_HEURE_INTERVENTION_PAR_AGENT_DEBUT = "select p.debut, p.fin, u.nom, p.parametres FROM patrouille p, mcig m, utilisateur u WHERE p.mcig_id = m.mcig_id AND m.id_utilisateur = u.id_utilisateur AND p.debut BETWEEN ? AND ? AND p.type = 5";
    private static final String SQL_GET_DATE_HEURE_INTERVENTION_PAR_AGENT_FIN = " ORDER BY u.nom ASC, p.debut ASC";
    private List<NatureExport> naturesExport = new ArrayList<NatureExport>();
    private Map<String, List<NatureExport>> mapNaturesExport;

    public ExportDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    private void chargerNaturesExport() {
        this.naturesExport = null;
        this.naturesExport = new ArrayList<NatureExport>();
        this.mapNaturesExport = null;
        this.mapNaturesExport = new HashMap<String, List<NatureExport>>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GETNATURESEXPORT);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String code = rs.getString("code");
                    String document = rs.getString("document");
                    String formats = rs.getString("formats");
                    String type = rs.getString("type");
                    String titre = rs.getString("titre");
                    String champs = rs.getString("champs");
                    String libelle = rs.getString("libelle");
                    int code_mm = rs.getInt("code_mm");
                    NatureExport natureExport = new NatureExport(code, document, Arrays.asList(formats.toUpperCase().split(";")), type, titre, champs, libelle, code_mm);
                    this.naturesExport.add(natureExport);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void update() {
        this.mapNaturesExport = null;
        this.naturesExport = null;
    }

    public Map<String, List<NatureExport>> getMapNaturesExport() {
        if (this.mapNaturesExport == null) {
            this.chargerNaturesExport();
        }
        return this.mapNaturesExport;
    }

    private List<NatureExport> getNaturesExport() {
        if (this.naturesExport == null) {
            this.chargerNaturesExport();
        }
        return this.naturesExport;
    }

    private void chargerNaturesExport(Nature nature, String codeNature) {
        ArrayList<NatureExport> l = new ArrayList<NatureExport>();
        for (NatureExport natExp : this.getNaturesExport()) {
            if (!GLS.egal((String)natExp.getNature(), (String)"*") && !GLS.egal((String)natExp.getNature(), (String)nature.getCode()) || natExp.getCodeMM() != -1 && natExp.getCodeMM() != nature.getCodeMM()) continue;
            l.add(natExp);
        }
        this.mapNaturesExport.put(codeNature, l);
    }

    private String getCodeNature(Nature n) {
        if (GLS.egal((String)n.getCode(), (String)"*")) {
            return "[*" + GLS.getString((Object)n.getCodeMM()) + "]";
        }
        return n.getCode();
    }

    private void chargerNaturesExportSQL(Nature nature) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<NatureExport> retour = new ArrayList<NatureExport>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GETNATURESEXPORTPARCODE);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, nature.getCode());
                pstm.setInt(3, nature.getCodeMM());
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String code = rs.getString("code");
                    String document = rs.getString("document");
                    String formats = rs.getString("formats");
                    String type = rs.getString("type");
                    String titre = rs.getString("titre");
                    String champs = rs.getString("champs");
                    String libelle = rs.getString("libelle");
                    int code_mm = rs.getInt("code_mm");
                    NatureExport natureExport = new NatureExport(code, document, Arrays.asList(formats.toUpperCase().split(";")), type, titre, champs, libelle, code_mm);
                    retour.add(natureExport);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.getMapNaturesExport().put(nature.getCode(), retour);
    }

    @Override
    public List<NatureExport> getNaturesExport(Nature nature) {
        String codeNature = this.getCodeNature(nature);
        if (!this.getMapNaturesExport().containsKey(codeNature)) {
            this.chargerNaturesExport(nature, codeNature);
        }
        return this.getMapNaturesExport().get(codeNature);
    }

    @Override
    public NatureExport getNaturesExport(Nature nature, String format) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        NatureExport retour = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GETNATURESEXPORTPARCODEETFORMAT);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(2, nature.getCode());
                pstm.setString(3, "%" + format + "%");
                pstm.setInt(4, nature.getCodeMM());
                rs = pstm.executeQuery();
                if (rs.next()) {
                    String code = rs.getString("code");
                    String document = rs.getString("document");
                    String formats = rs.getString("formats");
                    String type = rs.getString("type");
                    String titre = rs.getString("titre");
                    String champs = rs.getString("champs");
                    String libelle = rs.getString("libelle");
                    int code_mm = rs.getInt("code_mm");
                    retour = new NatureExport(code, document, Arrays.asList(formats.toUpperCase().split(";")), type, titre, champs, libelle, code_mm);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public List<NatureExport> getNatureExport(List<Nature> natures) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<NatureExport> retour = new ArrayList<NatureExport>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GETNATURESEXPORTPARCODES);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                ArrayList<Integer> codeMMs = new ArrayList<Integer>();
                ArrayList<String> codeNatures = new ArrayList<String>();
                for (Nature nature : natures) {
                    codeNatures.add(nature.getCode());
                    if (codeMMs.contains(nature.getCodeMM())) continue;
                    codeMMs.add(nature.getCodeMM());
                }
                Array a = connection.createArrayOf("text", codeNatures.toArray());
                Array b = connection.createArrayOf("integer", codeMMs.toArray());
                pstm.setArray(2, a);
                pstm.setArray(3, b);
                rs = pstm.executeQuery();
                Log.debug(pstm);
                while (rs.next()) {
                    String code = rs.getString("code");
                    String document = rs.getString("document");
                    String formats = rs.getString("formats");
                    String type = rs.getString("type");
                    String titre = rs.getString("titre");
                    String champs = rs.getString("champs");
                    String libelle = rs.getString("libelle");
                    int code_mm = rs.getInt("code_mm");
                    if (natures.size() != 1 && !"*".equals(code)) continue;
                    NatureExport natureExport = new NatureExport(code, document, Arrays.asList(formats.toUpperCase().split(";")), type, titre, champs, libelle, code_mm);
                    retour.add(natureExport);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    /*
     * Exception decompiling
     */
    @Override
    public NatureExport getNatureExport(String code, String libelle) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ApachePoiConvert getApachePoiConvert(String idConfig) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ApachePoiConvert retour = new ApachePoiConvert();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_APACHE_POI_CONVERT);
                pstm.setString(1, idConfig);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    retour.setDirection(rs.getString("direction_multiple"));
                    retour.setLibelle(rs.getString("libelle"));
                }
                retour.setElements(this.getApachePoiConvertElement(idConfig, connection));
                for (ApachePoiConvertElement element : retour.getElements()) {
                    if (retour.getObjets().contains(element.getObjet())) continue;
                    retour.getObjets().add(element.getObjet());
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    public ArrayList<ApachePoiConvertElement> getApachePoiConvertElement(String idConfig, Connection connection) {
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<ApachePoiConvertElement> retour = new ArrayList<ApachePoiConvertElement>();
        try {
            try {
                pstm = connection.prepareStatement(SQL_GET_APACHE_POI_CONVERT_ELEMENTS);
                pstm.setString(1, idConfig);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ApachePoiConvertElement element = new ApachePoiConvertElement();
                    element.setObjet(rs.getString("objet"));
                    element.setChamp(rs.getString("champ"));
                    element.setFeuille(rs.getInt("feuille"));
                    element.setLigne(rs.getInt("ligne"));
                    element.setColonne(rs.getInt("colonne"));
                    element.setGroupe(rs.getString("groupe"));
                    element.setOrdre(rs.getInt("ordre"));
                    element.setPosition(rs.getString("position"));
                    retour.add(element);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(rs);
            DAOUtil.close(pstm);
            throw throwable;
        }
        DAOUtil.close(rs);
        DAOUtil.close(pstm);
        return retour;
    }

    @Override
    public List<InformationInterventionBean> getInformationIntervention(Evenement e) {
        return null;
    }

    @Override
    public List<InformationInterventionBean> getInformationIntervention(int keventid) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        ArrayList<InformationInterventionBean> retour = new ArrayList<InformationInterventionBean>();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_GET_PARAMETRES_PATROUILLE);
                pstm.setInt(1, keventid);
                Log.debug(pstm);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    InformationInterventionBean interventionBean = new InformationInterventionBean();
                    Array array = rs.getArray("parametres");
                    if (array == null) continue;
                    MapDescription parametres = MapDescription.newMap();
                    parametres.add(MapDescription.parse((String[])((String[])array.getArray())));
                    interventionBean.setParametresIntervention(parametres);
                    retour.add(interventionBean);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return retour;
    }

    @Override
    public SyntheseInterventionAgentBean getSyntheseInterventionAgentBean(Timestamp dateDebutValue, Timestamp dateFinValue, String delegationValue, String centreValue, String agentValue) {
        SyntheseInterventionAgentBean syntheseBean = new SyntheseInterventionAgentBean();
        syntheseBean.setDateDebut(dateDebutValue);
        syntheseBean.setDateFin(dateFinValue);
        syntheseBean.setDelegation(delegationValue);
        syntheseBean.setAgent(agentValue);
        syntheseBean.setCentre(centreValue);
        ArrayList<InterventionAgentBean> interventionAgentBeanList = new ArrayList<InterventionAgentBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String requette = SQL_GET_DATE_HEURE_INTERVENTION_PAR_AGENT_DEBUT;
                if (delegationValue != null) {
                    requette = String.valueOf(requette) + " AND u.delegation = ?";
                }
                if (centreValue != null) {
                    requette = String.valueOf(requette) + " AND u.centre = ?";
                }
                requette = String.valueOf(requette) + SQL_GET_DATE_HEURE_INTERVENTION_PAR_AGENT_FIN;
                pstm = connection.prepareStatement(requette);
                pstm.setTimestamp(1, dateDebutValue);
                pstm.setTimestamp(2, dateFinValue);
                int i = 3;
                if (delegationValue != null) {
                    pstm.setString(i++, delegationValue);
                }
                if (centreValue != null) {
                    pstm.setString(i++, centreValue);
                }
                System.out.println(pstm);
                rs = pstm.executeQuery();
                String nomAgent = "";
                HashMap<String, InterventionAgentBean> mapNomAgent = new HashMap<String, InterventionAgentBean>();
                while (rs.next()) {
                    Array array = rs.getArray("parametres");
                    SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
                    if (array == null) continue;
                    MapDescription parametres = MapDescription.newMap();
                    parametres.add(MapDescription.parse((String[])((String[])array.getArray())));
                    HashMap<String, InterventionAgentBean> mapAgent = new HashMap<String, InterventionAgentBean>();
                    HashMap<String, DebutFinIntervention> mapAgentIntervention = new HashMap<String, DebutFinIntervention>();
                    for (String key : parametres.getCles()) {
                        HashMap<String, Timestamp> dates;
                        if (!key.startsWith("agent")) continue;
                        String[] keys = key.split("-");
                        String codeAgent = keys[0];
                        InterventionAgentBean interventionBeanTmp = (InterventionAgentBean)mapAgent.get(codeAgent);
                        if (interventionBeanTmp == null) {
                            interventionBeanTmp = new InterventionAgentBean();
                        }
                        if (keys[1].equals("nom")) {
                            interventionBeanTmp.setNomAgent(parametres.getString(key, ""));
                            mapAgent.put(codeAgent, interventionBeanTmp);
                            continue;
                        }
                        DebutFinIntervention dateIntervention = (DebutFinIntervention)mapAgentIntervention.get(codeAgent);
                        if (dateIntervention == null) {
                            dateIntervention = new DebutFinIntervention();
                        }
                        if ((dates = dateIntervention.getDates()) == null) {
                            dates = new HashMap<String, Timestamp>();
                        }
                        try {
                            Timestamp date = new Timestamp(formatter.parse(parametres.getString(key, "")).getTime());
                            dates.put(keys[1], date);
                            if (keys[1].equals("dateDeclenchementIntervention")) {
                                dateIntervention.setDateDebut(date);
                            }
                            dateIntervention.setDates(dates);
                            mapAgentIntervention.put(codeAgent, dateIntervention);
                        }
                        catch (ParseException e) {
                            Log.error(String.valueOf(codeAgent) + " : " + parametres.getString(key, ""));
                        }
                    }
                    for (String agent : mapAgent.keySet()) {
                        if (agentValue != null && !((InterventionAgentBean)mapAgent.get(agent)).getNomAgent().contains(agentValue)) continue;
                        InterventionAgentBean interventionBean = (InterventionAgentBean)mapAgent.get(agent);
                        interventionBean.getDates().add((DebutFinIntervention)mapAgentIntervention.get(agent));
                        InterventionAgentBean interventionBeanTmp = (InterventionAgentBean)mapNomAgent.get(interventionBean.getNomAgent());
                        if (interventionBeanTmp == null) {
                            interventionBeanTmp = interventionBean;
                        } else {
                            interventionBeanTmp.getDates().addAll(interventionBean.getDates());
                        }
                        mapNomAgent.put(interventionBean.getNomAgent(), interventionBeanTmp);
                        interventionBean = new InterventionAgentBean();
                    }
                }
                for (InterventionAgentBean bean : mapNomAgent.values()) {
                    interventionAgentBeanList.add(bean);
                }
                syntheseBean.setInterventionAgentList(interventionAgentBeanList);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return syntheseBean;
    }
}

