/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.eq2r.DefinitionCritere;
import com.geolocsystems.eq2r.TronconEq2r;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IEq2rDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Eq2rDAOJDBC
implements IEq2rDAO {
    private DAOFactory daoFactory;
    private List<TronconEq2r> troncons;
    private List<Integer> critereDesactives;

    public Eq2rDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public synchronized List<TronconEq2r> getTronconsEq2r() {
        if (this.troncons == null) {
            this.loadTroncons();
        }
        return this.troncons;
    }

    private void loadTroncons() {
        ArrayList<TronconEq2r> troncons = new ArrayList<TronconEq2r>();
        String requete = "SELECT * FROM  eq2r.troncons ORDER BY axe,pr_debut";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    TronconEq2r t = new TronconEq2r();
                    t.setId(rs.getInt("id"));
                    t.setNom(rs.getString("nom"));
                    t.setAxe(rs.getString("axe"));
                    t.setPrDebut(rs.getInt("pr_debut"));
                    t.setPrFin(rs.getInt("pr_fin"));
                    t.setAbsPrDebut(rs.getInt("abs_pr_debut"));
                    t.setAbsPrFin(rs.getInt("abs_pr_fin"));
                    t.setLongueur(rs.getInt("longueur"));
                    t.setCommune(rs.getString("commune"));
                    t.setX((Float[])rs.getArray("x").getArray());
                    t.setY((Float[])rs.getArray("y").getArray());
                    troncons.add(t);
                }
                this.troncons = troncons;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void ajouterTronconEq2r(TronconEq2r troncon) {
        String requete = "INSERT INTO eq2r.troncons (nom,axe,pr_debut,pr_fin,abs_pr_debut,abs_pr_fin,longueur,commune,x,y) VALUES (?,?,?,?,?,?,?,?,?,?) returning id";
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO eq2r.troncons (nom,axe,pr_debut,pr_fin,abs_pr_debut,abs_pr_fin,longueur,commune,x,y) VALUES (?,?,?,?,?,?,?,?,?,?) returning id");
                pstm.setString(1, troncon.getNom());
                pstm.setString(2, troncon.getAxe());
                pstm.setInt(3, troncon.getPrDebut());
                pstm.setInt(4, troncon.getPrFin());
                pstm.setInt(5, troncon.getAbsPrDebut());
                pstm.setInt(6, troncon.getAbsPrFin());
                pstm.setInt(7, troncon.getLongueur());
                pstm.setString(8, troncon.getCommune());
                pstm.setArray(9, connection.createArrayOf("float4", troncon.getX()));
                pstm.setArray(10, connection.createArrayOf("float4", troncon.getY()));
                rs = pstm.executeQuery();
                if (rs.next()) {
                    troncon.setId(rs.getInt("id"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
    }

    @Override
    public void updateTronconEq2r(TronconEq2r troncon) {
        String requete = "UPDATE eq2r.troncons SET nom=?,axe=?,pr_debut=?,pr_fin=?,abs_pr_debut=?,abs_pr_fin=?,longueur=?,commune=?,x=?,y=? WHERE id=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE eq2r.troncons SET nom=?,axe=?,pr_debut=?,pr_fin=?,abs_pr_debut=?,abs_pr_fin=?,longueur=?,commune=?,x=?,y=? WHERE id=?");
                pstm.setString(1, troncon.getNom());
                pstm.setString(2, troncon.getAxe());
                pstm.setInt(3, troncon.getPrDebut());
                pstm.setInt(4, troncon.getPrFin());
                pstm.setInt(5, troncon.getAbsPrDebut());
                pstm.setInt(6, troncon.getAbsPrFin());
                pstm.setInt(7, troncon.getLongueur());
                pstm.setString(8, troncon.getCommune());
                pstm.setArray(9, connection.createArrayOf("float4", troncon.getX()));
                pstm.setArray(10, connection.createArrayOf("float4", troncon.getY()));
                pstm.setInt(11, troncon.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void deleteTronconEq2r(TronconEq2r troncon) {
        String requete = "DELETE FROM eq2r.troncons WHERE id=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM eq2r.troncons WHERE id=?");
                pstm.setInt(1, troncon.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public synchronized void refresh() {
        this.troncons = null;
        this.critereDesactives = null;
    }

    @Override
    public Map<Integer, Date> getDatesVisiteTronconsEq2r(Date date, List<TronconEq2r> troncons) {
        String requete = "select t.id as id, MAX(d.date_heure_loc) as date_visite FROM eq2r.troncons t JOIN prism.localisation d ON (t.axe = d.axe  AND (d.pr>t.pr_debut OR (d.pr=t.pr_debut AND d.abscisse_pr>=t.abs_pr_debut)) AND (d.pr<t.pr_fin OR (d.pr=t.pr_fin AND d.abscisse_pr<=t.abs_pr_fin))) WHERE date_heure_loc<? GROUP BY t.id";
        HashMap<Integer, Date> ret = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select t.id as id, MAX(d.date_heure_loc) as date_visite FROM eq2r.troncons t JOIN prism.localisation d ON (t.axe = d.axe  AND (d.pr>t.pr_debut OR (d.pr=t.pr_debut AND d.abscisse_pr>=t.abs_pr_debut)) AND (d.pr<t.pr_fin OR (d.pr=t.pr_fin AND d.abscisse_pr<=t.abs_pr_fin))) WHERE date_heure_loc<? GROUP BY t.id");
                pstm.setTimestamp(1, new Timestamp(date.getTime()));
                rs = pstm.executeQuery();
                ret = new HashMap<Integer, Date>();
                while (rs.next()) {
                    int id = rs.getInt("id");
                    Timestamp ts = rs.getTimestamp("date_visite");
                    ret.put(id, ts);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return ret;
    }

    @Override
    public List<DefinitionCritere> getDefinitionsCriteresEq2r() {
        String requete = "SELECT criteres.id,criteres.nom,criteres.nature,criteres.filtres,criteres.coef FROM eq2r.criteres";
        ArrayList<DefinitionCritere> ret = null;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT criteres.id,criteres.nom,criteres.nature,criteres.filtres,criteres.coef FROM eq2r.criteres");
                rs = pstm.executeQuery();
                ret = new ArrayList<DefinitionCritere>();
                while (rs.next()) {
                    DefinitionCritere critere = new DefinitionCritere();
                    critere.setId(rs.getInt("id"));
                    critere.setNom(rs.getString("nom"));
                    critere.setNature(rs.getString("nature"));
                    String filtres = rs.getString("filtres");
                    Log.debug("filtre string = " + filtres);
                    critere.setFiltres(MapDescription.parse((String)filtres));
                    critere.setCoef(rs.getInt("coef"));
                    ret.add(critere);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return ret;
    }

    @Override
    public List<Integer> getCriteresEq2rDesactives() {
        if (this.critereDesactives == null) {
            String requete = "SELECT id FROM eq2r.criteres_desactives";
            ArrayList<Integer> ret = null;
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement("SELECT id FROM eq2r.criteres_desactives");
                    rs = pstm.executeQuery();
                    ret = new ArrayList<Integer>();
                    while (rs.next()) {
                        ret.add(rs.getInt("id"));
                    }
                }
                catch (SQLException e) {
                    throw new DAOException(e);
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
            this.critereDesactives = ret;
        }
        return this.critereDesactives;
    }

    @Override
    public void supprimerCritereEq2r(int id) {
        String requete = "DELETE FROM eq2r.criteres  WHERE id=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM eq2r.criteres  WHERE id=?");
                pstm.setInt(1, id);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void activerCritereEq2r(int id, boolean enable) {
        String requete = enable ? "DELETE FROM eq2r.criteres_desactives WHERE id=?" : "INSERT INTO eq2r.criteres_desactives (id) VALUES (?)";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                pstm.setInt(1, id);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void ajouterCritereEq2r(DefinitionCritere crit) {
        String requete = "INSERT INTO eq2r.criteres (nom,nature,filtres,coef) VALUES (?,?,?,?)";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO eq2r.criteres (nom,nature,filtres,coef) VALUES (?,?,?,?)");
                pstm.setString(1, crit.getNom());
                pstm.setString(2, crit.getNature());
                pstm.setString(3, crit.getFiltres().serialize());
                pstm.setInt(4, crit.getCoef());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void updateCritereEq2r(DefinitionCritere crit) {
        String requete = "UPDATE eq2r.criteres SET nom=?, nature=?,filtres=?,coef=? WHERE id=?";
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE eq2r.criteres SET nom=?, nature=?,filtres=?,coef=? WHERE id=?");
                pstm.setString(1, crit.getNom());
                pstm.setString(2, crit.getNature());
                pstm.setString(3, crit.getFiltres().serialize());
                pstm.setInt(4, crit.getCoef());
                pstm.setInt(5, crit.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }
}

