/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.model.Document;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IDocumentDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DocumentDAOJDBC
implements IDocumentDAO {
    private DAOFactory daoFactory;

    public DocumentDAOJDBC(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public byte[] getDocumentData(String hash) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            byte[] byArray;
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT data FROM document.document WHERE hash=?");
                pstm.setString(1, hash);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                byArray = rs.getBytes(1);
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return byArray;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public Document getDocument(String hash) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            Document document;
            connection = null;
            pstm = null;
            rs = null;
            try {
                Document doc;
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT data, nom, synchronisation FROM document.document WHERE hash=?");
                pstm.setString(1, hash);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                document = doc = new Document(rs.getString(2), rs.getBytes(1), rs.getInt(3));
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return document;
        }
        DAOUtil.close(connection, pstm, rs);
        return null;
    }

    @Override
    public void sauvegarderDocument(String hash, byte[] data, String nom, int synchronisation) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = this.daoFactory.getConnection();){
                connection.setAutoCommit(false);
                this.sauvegarderDocument(connection, hash, data, nom, synchronisation);
                connection.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DAOException(e);
        }
    }

    private String verificationNom(String nom) {
        int indexSlash = nom.lastIndexOf("/");
        try {
            int indexPrefixUplaod;
            int indexAntiSlash;
            if (indexSlash != -1) {
                nom = nom.substring(indexSlash + 1);
            }
            if ((indexAntiSlash = nom.lastIndexOf("\\")) != -1) {
                nom = nom.substring(indexAntiSlash + 1);
            }
            if ((indexPrefixUplaod = nom.lastIndexOf("-d-")) != -1) {
                nom = nom.substring(indexPrefixUplaod + 3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nom;
    }

    @Override
    public boolean isDocumentExist(String hash) {
        ResultSet rs;
        PreparedStatement pstm;
        Connection connection;
        block4: {
            connection = null;
            pstm = null;
            rs = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT 1 FROM document.document WHERE hash=?");
                pstm.setString(1, hash);
                rs = pstm.executeQuery();
                if (!rs.next()) break block4;
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm, rs);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm, rs);
            return true;
        }
        DAOUtil.close(connection, pstm, rs);
        return false;
    }

    @Override
    public void sauvegarderDocument(Connection connectionInit, String hash, byte[] data, String nom, int synchronisation) {
        PreparedStatement pstm = null;
        try {
            try {
                pstm = connectionInit.prepareStatement("DELETE FROM document.document WHERE hash=?");
                pstm.setString(1, hash);
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connectionInit.prepareStatement("INSERT INTO document.document (hash,data,nom,synchronisation) VALUES (?,?,?,?)");
                pstm.setString(1, hash);
                pstm.setBytes(2, data);
                pstm.setString(3, this.verificationNom(nom));
                pstm.setInt(4, synchronisation);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        finally {
            DAOUtil.close(null, pstm);
        }
    }
}

