/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO.Jdbc;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.Parametre;
import com.geolocsystems.prismandroid.model.Ua;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismcentral.DAO.DAOFactory;
import com.geolocsystems.prismcentral.DAO.DAOUtil;
import com.geolocsystems.prismcentral.DAO.IAdminDAO;
import com.geolocsystems.prismcentral.DAO.IReferentielDAO;
import com.geolocsystems.prismcentral.DAO.exception.DAOException;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.Astreinte;
import com.geolocsystems.prismcentral.beans.ConfigurationBean;
import com.geolocsystems.prismcentral.beans.DestinataireMail;
import com.geolocsystems.prismcentral.beans.IntentionPatrouille;
import com.geolocsystems.prismcentral.beans.ListeDestinataireMail;
import com.geolocsystems.prismcentral.beans.MarqueVehicule;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.beans.ReformulationDescription;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import gls.outils.GLS;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AdminDAOJDBC
implements IAdminDAO {
    private DAOFactory daoFactory;
    private IReferentielDAO referentielDAO;
    private static final String REQUETE_FIN_EVENEMENT_MISSION = "update prism.evenement set fin='Y',mst=now(),valopedate=now() where dob in (select code from prism.nature_perso where code_categorie = 'mission')  and mcig_id in (select m.mcig_id from mcig m  where not m.date_heure_fin is null) and (fin is null or not fin = 'Y');";
    private static final String SQL_LISTE_CONFIGURATION_LIMITE_PUBLICATION = "SELECT * FROM prism.configuration WHERE champ IN ('validiteTronconVH','validiteSyntheseVH') AND zone_routiere = ? ORDER BY champ ASC";
    private static final String SQL_LISTE_CONFIGURATION_PUBLICATION_LIMITE_PUBLICATION = "SELECT * FROM prism.configuration_publication WHERE (code = 'date_debut_vh' OR code = 'date_fin_vh' or code = 'interval_maj' or code = 'afficher_bouton_restrictionPL') AND zone_routiere = ? ORDER BY code ASC";
    private static final String SQL_UTILISATEUR = "INSERT INTO prism.utilisateur (sna,mse,nom,type,synchrodate,password,delegation,centre,archive,id_profil,telephone,mail,connection_type,id_utilisateur) VALUES (?,?,?,1,now(),?,?,?,?,?,?,?,?,nextval('k_userid'))";
    private static final String SQL_UTILISATEUR_ADMIN_UA = "INSERT INTO prism.utilisateur (sna,mse,nom,type,synchrodate,password,delegation,centre,archive,id_profil,telephone,mail,connection_type,id_utilisateur,isadminua, issuperadmin) VALUES (?,?,?,1,now(),?,?,?,?,?,?,?,?,nextval('k_userid'),?,?)";
    private static final String SQL_CIRCUITS_MODULES_METIERS = "SELECT * FROM prism.circuit WHERE systeme=0 AND zone_routiere=? ORDER BY type, delegation, centre, nom, niveau";
    private static final String SQL_CIRCUITS_VH = "SELECT * FROM prism.circuit WHERE systeme=0 AND zone_routiere=? AND type = ? ORDER BY nom, type, delegation, centre, niveau";
    private static final String SQL_LISTE_CONFIGURATION = "SELECT * FROM prism.configuration ";
    private static final String REQUETE_SELECTION_UA = "SELECT uaid as id, c.nom as name, c.parent as parent, attribution, c.box_minx, c.box_miny, c.box_maxx, c.box_maxy FROM prism.centre_rattachement c UNION SELECT uaid as id, d.nom as name, 'DIR' as parent, attribution, d.box_minx, d.box_miny, d.box_maxx, d.box_maxy FROM  prism.delegation_rattachement d UNION SELECT 0,  'DIR' as name, null as parent, 1 as attribution, -1, -1, -1, -1 ;";

    public AdminDAOJDBC(DAOFactory daoFactory, IReferentielDAO referentielDAO) {
        this.daoFactory = daoFactory;
        this.referentielDAO = referentielDAO;
    }

    @Override
    public void creerProfil(Profil p) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.profil (nom,zone) VALUES (?,?) RETURNING id");
                pstm.setString(1, p.getName());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    p.setId(rs.getInt("id"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.updateProfilAction(p);
        this.updateDateModificationAdmin("profils");
        this.referentielDAO.update();
    }

    @Override
    public void updateProfil(Profil p) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.profil SET nom=? WHERE id=? AND zone=?");
                pstm.setString(1, p.getName());
                pstm.setInt(2, p.getId());
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateProfilAction(p);
        this.updateDateModificationAdmin("profils");
        this.updateDateModificationAdmin("utilisateurs");
        this.referentielDAO.update();
    }

    private void updateProfilAction(Profil p) {
        Connection connection = null;
        PreparedStatement pstm = null;
        PreparedStatement pstm2 = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.profil_action WHERE id_profil=?");
                pstm.setInt(1, p.getId());
                pstm.execute();
                pstm2 = connection.prepareStatement("INSERT INTO prism.profil_action (id_profil,id_action,est_actif,parametres) VALUES (?,?,true,?)");
                Iterator iterator = p.getActions().iterator();
                while (iterator.hasNext()) {
                    int action = (Integer)iterator.next();
                    pstm2.setInt(1, p.getId());
                    pstm2.setInt(2, action);
                    if (p.getParametres() != null && p.getParametres().containsKey(action) && p.getParametres().get(action) != null) {
                        pstm2.setArray(3, connection.createArrayOf("text", ((MapDescription)p.getParametres().get(action)).valuesOf()));
                    } else {
                        pstm2.setNull(3, 2003, "TEXT_ARRAY");
                    }
                    pstm2.addBatch();
                }
                pstm2.executeBatch();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(pstm);
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(pstm);
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void deleteProfil(int idProfil) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                pstm = connection.prepareStatement("UPDATE prism.utilisateur  SET id_profil=(SELECT id FROM prism.profil WHERE nom='#')  WHERE id_profil=?");
                pstm.setLong(1, idProfil);
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("DELETE FROM prism.profil_action WHERE id_profil=? ");
                pstm.setInt(1, idProfil);
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("DELETE FROM prism.profil  WHERE id=? ");
                pstm.setInt(1, idProfil);
                pstm.execute();
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("profils");
        this.referentielDAO.update();
    }

    @Override
    public void deleteUtilisateur(int idUtilisateur) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.utilisateur WHERE id_utilisateur=? ");
                pstm.setInt(1, idUtilisateur);
                pstm.execute();
                DAOUtil.close(pstm);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void creerUtilisateur(PrismCentralUser user, String newpwd) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(user.isSuperAdminUa() || user.isAdminUa() ? SQL_UTILISATEUR_ADMIN_UA : SQL_UTILISATEUR);
                pstm.setString(1, user.getCode());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(3, user.getNom());
                pstm.setString(4, MetierCommun.instanceOf().hashPassword(newpwd));
                if (user.getDelegation() != null) {
                    pstm.setString(5, user.getDelegation());
                } else {
                    pstm.setNull(5, 12);
                }
                if (user.getCentre() != null) {
                    pstm.setString(6, user.getCentre());
                } else {
                    pstm.setNull(6, 12);
                }
                pstm.setInt(7, user.isArchive() ? 1 : 0);
                pstm.setLong(8, user.getIdProfil());
                if (user.getTelephone() != null) {
                    pstm.setString(9, user.getTelephone());
                } else {
                    pstm.setNull(9, 12);
                }
                if (user.getMail() != null) {
                    pstm.setString(10, user.getMail());
                } else {
                    pstm.setNull(10, 12);
                }
                if (user.getConnectionType() != null) {
                    pstm.setString(11, user.getConnectionType());
                } else {
                    pstm.setNull(11, 12);
                }
                if (user.isAdminUa() || user.isSuperAdminUa()) {
                    pstm.setBoolean(12, user.isAdminUa());
                    pstm.setBoolean(13, user.isSuperAdminUa());
                }
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("utilisateurs");
        this.referentielDAO.update();
    }

    @Override
    public void updateUtilisateur(PrismCentralUser user, String newpwd) {
        this.updateUtilisateur(user, newpwd, false);
    }

    @Override
    public void updateUserPassword(String code, String newpwd, boolean hash) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.utilisateur SET password=? WHERE sna=? AND mse=?");
                pstm.setString(1, hash ? MetierCommun.instanceOf().hashPassword(newpwd) : newpwd);
                pstm.setString(2, code);
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("utilisateurs");
        this.referentielDAO.update();
    }

    @Override
    public int countUsersByProfile(int idProfil) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        int rowCount = 0;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT COUNT(*) FROM prism.utilisateur WHERE id_profil=?");
                pstm.setInt(1, idProfil);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    rowCount = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return rowCount;
    }

    @Override
    public void creerVehicule(Vehicule v) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.vehicule (code,immatriculation,numero_telephone,numero_radio,zone_routiere,id_marque_vehicule,delegation,centre,archive,description) VALUES (?,?,?,?,?,?,?,?,?,?)");
                pstm.setString(1, v.getCode());
                pstm.setString(2, v.getImmatriculation());
                pstm.setString(3, v.getNumeroTelephone());
                pstm.setString(4, v.getNumeroRadio());
                pstm.setString(5, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(6, v.getType());
                if (!GLS.estVide((String)v.getDelegation())) {
                    pstm.setString(7, v.getDelegation());
                } else {
                    pstm.setNull(7, 12);
                }
                if (!GLS.estVide((String)v.getCentre())) {
                    pstm.setString(8, v.getCentre());
                } else {
                    pstm.setNull(8, 12);
                }
                pstm.setBoolean(9, v.isArchive());
                pstm.setString(10, v.getDescription());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("vehicules");
        this.referentielDAO.update();
    }

    @Override
    public void creerVehiculeImportation(Vehicule v, String marque) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.vehicule (code,immatriculation,numero_telephone,numero_radio,zone_routiere,id_marque_vehicule,delegation,centre,archive) VALUES (?,?,?,?,?,(select m.id from marque_vehicule m where m.nom = ?),?,?,?)");
                pstm.setString(1, v.getCode());
                pstm.setString(2, v.getImmatriculation());
                pstm.setString(3, v.getNumeroTelephone());
                pstm.setString(4, v.getNumeroRadio());
                pstm.setString(5, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(6, marque);
                if (!GLS.estVide((String)v.getDelegation())) {
                    pstm.setString(7, v.getDelegation());
                } else {
                    pstm.setNull(7, 12);
                }
                if (!GLS.estVide((String)v.getCentre())) {
                    pstm.setString(8, v.getCentre());
                } else {
                    pstm.setNull(8, 12);
                }
                pstm.setBoolean(9, v.isArchive());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("vehicules");
        this.referentielDAO.update();
    }

    @Override
    public int getMarqueVehicule(String marque) {
        PreparedStatement pstm;
        Connection connection;
        block4: {
            int n;
            connection = null;
            pstm = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select m.id from marque_vehicule m where lower(m.nom) = lower(?)");
                pstm.setString(1, marque);
                ResultSet rs = pstm.executeQuery();
                Log.debug("RECUP MARQUE VEHICULE " + marque + " -- " + pstm.toString());
                if (!rs.next()) break block4;
                n = rs.getInt("id");
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm);
            return n;
        }
        DAOUtil.close(connection, pstm);
        return -1;
    }

    @Override
    public int getTypeVehicule(String type) {
        PreparedStatement pstm;
        Connection connection;
        block4: {
            int n;
            connection = null;
            pstm = null;
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select t.code from type_vehicule t where lower(t.libelle) = lower(?)");
                pstm.setString(1, type);
                ResultSet rs = pstm.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt("code");
            }
            catch (SQLException e) {
                try {
                    throw new DAOException(e);
                }
                catch (Throwable throwable) {
                    DAOUtil.close(connection, pstm);
                    throw throwable;
                }
            }
            DAOUtil.close(connection, pstm);
            return n;
        }
        DAOUtil.close(connection, pstm);
        return -1;
    }

    @Override
    public void updateVehicule(Vehicule v) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.vehicule  SET immatriculation=?,numero_telephone=?,numero_radio=?,id_marque_vehicule=?,delegation=?,centre=?,archive=?,description=? WHERE code=? AND zone_routiere=?");
                pstm.setString(1, v.getImmatriculation());
                pstm.setString(2, v.getNumeroTelephone());
                pstm.setString(3, v.getNumeroRadio());
                pstm.setInt(4, v.getType());
                if (!GLS.estVide((String)v.getDelegation())) {
                    pstm.setString(5, v.getDelegation());
                } else {
                    pstm.setNull(5, 12);
                }
                if (!GLS.estVide((String)v.getCentre())) {
                    pstm.setString(6, v.getCentre());
                } else {
                    pstm.setNull(6, 12);
                }
                pstm.setBoolean(7, v.isArchive());
                pstm.setString(8, v.getDescription());
                pstm.setString(9, v.getCode());
                pstm.setString(10, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("vehicules");
        this.referentielDAO.update();
    }

    @Override
    public void creerMarqueVehicule(MarqueVehicule marque) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.marque_vehicule (id,nom,code_type_vehicule,zone_routiere,description,icone_vehicule) VALUES (nextval('prism.marque_vehicule_id_seq'),?,?,?,?,?) ");
                pstm.setString(1, marque.getNom());
                pstm.setInt(2, marque.getType());
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setString(4, marque.getDescription());
                pstm.setInt(5, marque.getIcone());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("vehicules");
        this.referentielDAO.update();
    }

    @Override
    public boolean marqueVehiculeExiste(String nom) {
        Connection connection = null;
        PreparedStatement pstm = null;
        boolean existe = false;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select count(*) as nb from marque_vehicule where nom = ?", 1004, 1007);
                pstm.setString(1, nom);
                ResultSet rs = pstm.executeQuery();
                if (rs.first()) {
                    int nb = rs.getInt("nb");
                    existe = nb > 0;
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return existe;
    }

    @Override
    public boolean typeVehiculeExiste(String nom) {
        Connection connection = null;
        PreparedStatement pstm = null;
        boolean existe = false;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("select count(*) as nb from type_vehicule where libelle = ?", 1004, 1007);
                pstm.setString(1, nom);
                ResultSet rs = pstm.executeQuery();
                if (rs.first()) {
                    int nb = rs.getInt("nb");
                    existe = nb > 0;
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return existe;
    }

    @Override
    public void updateMarqueVehicule(MarqueVehicule marque) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.marque_vehicule SET nom=?,code_type_vehicule=?,description=?,icone_vehicule=?  WHERE id=?");
                pstm.setString(1, marque.getNom());
                pstm.setInt(2, marque.getType());
                pstm.setString(3, marque.getDescription());
                pstm.setInt(4, marque.getIcone());
                pstm.setInt(5, marque.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("vehicules");
        this.referentielDAO.update();
    }

    @Override
    public void creerDelegation(Delegation delegation) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.delegation_rattachement (nom,attribution,zone,box_minx,box_miny,box_maxx,box_maxy) VALUES (?,?,?,?,?,?,?) ");
                pstm.setString(1, delegation.getNom());
                pstm.setInt(2, delegation.isArchive() ? 0 : 1);
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (delegation.getBounds() == null) {
                    pstm.setNull(4, 8);
                    pstm.setNull(5, 8);
                    pstm.setNull(6, 8);
                    pstm.setNull(7, 8);
                } else {
                    pstm.setDouble(4, delegation.getBounds().getMinx());
                    pstm.setDouble(5, delegation.getBounds().getMiny());
                    pstm.setDouble(6, delegation.getBounds().getMaxx());
                    pstm.setDouble(7, delegation.getBounds().getMaxy());
                }
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
        this.referentielDAO.update();
    }

    private void majDelegationCentre(Connection connection, String centre, String delegation, String newCentre, String newDelegation, String path) throws SQLException {
        PreparedStatement pstm;
        StringBuffer sql = new StringBuffer();
        if (newCentre != null && centre != null) {
            sql = new StringBuffer();
            sql.append("UPDATE prism.centre_rattachement SET delegation=?, path=? WHERE zone_routiere=? ");
            sql.append(" AND nom=? ");
            pstm = connection.prepareStatement(sql.toString());
            pstm.setString(1, newDelegation);
            if (path != null) {
                pstm.setString(2, path);
            } else {
                pstm.setNull(2, 12);
            }
            pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
            pstm.setString(4, centre);
            pstm.execute();
            pstm.close();
        }
        sql = new StringBuffer();
        sql.append("UPDATE donnees_metier.troncon_circuit_ext SET delegation=?,centre=? ");
        if (centre == null) {
            sql.append(" WHERE centre is null ");
        } else {
            sql.append(" WHERE centre=? ");
        }
        sql.append(" AND delegation=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        if (centre == null) {
            pstm.setString(3, delegation);
        } else {
            pstm.setString(3, centre);
            pstm.setString(4, delegation);
        }
        pstm.execute();
        pstm.close();
        sql = new StringBuffer();
        sql.append("UPDATE prism.communes SET delegation=?,centre=? WHERE zone_routiere=? ");
        if (centre == null) {
            sql.append(" AND centre is null ");
        } else {
            sql.append(" AND centre=? ");
        }
        sql.append(" AND delegation=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
        if (centre == null) {
            pstm.setString(4, delegation);
        } else {
            pstm.setString(4, centre);
            pstm.setString(5, delegation);
        }
        pstm.execute();
        pstm.close();
        sql = new StringBuffer();
        sql.append("UPDATE prism.requete SET delegation=?,centre=? WHERE zone_routiere=? ");
        if (centre == null) {
            sql.append(" AND centre is null ");
        } else {
            sql.append(" AND centre=? ");
        }
        sql.append(" AND delegation=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
        if (centre == null) {
            pstm.setString(4, delegation);
        } else {
            pstm.setString(4, centre);
            pstm.setString(5, delegation);
        }
        pstm.execute();
        pstm.close();
        sql = new StringBuffer();
        sql.append("UPDATE prism.circuit SET delegation=?,centre=? WHERE zone_routiere=? ");
        if (centre == null) {
            sql.append(" AND centre is null ");
        } else {
            sql.append(" AND centre=? ");
        }
        sql.append(" AND delegation=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
        if (centre == null) {
            pstm.setString(4, delegation);
        } else {
            pstm.setString(4, centre);
            pstm.setString(5, delegation);
        }
        pstm.execute();
        pstm.close();
        sql = new StringBuffer();
        sql.append("UPDATE prism.vehicule SET delegation=?,centre=? WHERE zone_routiere=? ");
        if (centre == null) {
            sql.append(" AND centre is null ");
        } else {
            sql.append(" AND centre=? ");
        }
        sql.append(" AND delegation=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
        if (centre == null) {
            pstm.setString(4, delegation);
        } else {
            pstm.setString(4, centre);
            pstm.setString(5, delegation);
        }
        pstm.execute();
        pstm.close();
        sql = new StringBuffer();
        sql.append("UPDATE prism.utilisateur SET delegation=?,centre=? WHERE mse=? ");
        if (centre == null) {
            sql.append(" AND centre is null ");
        } else {
            sql.append(" AND centre=? ");
        }
        sql.append(" AND delegation=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
        if (centre == null) {
            pstm.setString(4, delegation);
        } else {
            pstm.setString(4, centre);
            pstm.setString(5, delegation);
        }
        pstm.execute();
        pstm.close();
        sql = new StringBuffer();
        sql.append("UPDATE prism.evenement SET district=?,cei=? WHERE departement=? ");
        if (centre == null) {
            sql.append(" AND cei is null ");
        } else {
            sql.append(" AND cei=? ");
        }
        sql.append(" AND district=? ");
        pstm = connection.prepareStatement(sql.toString());
        pstm.setString(1, newDelegation);
        if (newCentre != null) {
            pstm.setString(2, newCentre);
        } else {
            pstm.setNull(2, 12);
        }
        pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
        if (centre == null) {
            pstm.setString(4, delegation);
        } else {
            pstm.setString(4, centre);
            pstm.setString(5, delegation);
        }
        pstm.execute();
        pstm.close();
    }

    private List<Ua> recupererUaFils(List<Ua> uas, String parent) {
        ArrayList<Ua> uaFils = new ArrayList<Ua>();
        if (parent == null) {
            return uaFils;
        }
        for (Ua uaTemp : uas) {
            if (!parent.equals(uaTemp.getParent())) continue;
            uaFils.add(uaTemp);
            uaFils.addAll(this.recupererUaFils(uas, uaTemp.getName()));
        }
        return uaFils;
    }

    private Ua recupererUaParent(List<Ua> uas, String parent) {
        if (parent == null) {
            return null;
        }
        for (Ua uaTemp : uas) {
            if (!uaTemp.getName().equals(parent)) continue;
            return uaTemp;
        }
        return null;
    }

    private Ua recupererDelegation(List<Ua> uas, String parent) {
        Ua uaParent;
        if (parent == null) {
            return null;
        }
        do {
            Ua ua = uaParent = this.recupererUaParent(uas, parent);
            parent = ua.getParent();
        } while (uaParent != null && !uaParent.getParent().equals("DIR"));
        return uaParent;
    }

    private Ua recupererUa(List<Ua> uas, String nom) {
        for (Ua uaTemp : uas) {
            if (!uaTemp.getName().equals(nom)) continue;
            return uaTemp;
        }
        return null;
    }

    protected String calculerPath(List<Ua> uas, Ua ua) {
        Ua uaParent;
        if (ua.getParent() == null) {
            return null;
        }
        StringBuffer path = new StringBuffer();
        boolean bFirst = true;
        do {
            if (bFirst) {
                bFirst = false;
            } else {
                path.insert(0, "|");
            }
            path.insert(0, ua.getName());
            ua = uaParent = this.recupererUaParent(uas, ua.getParent());
        } while (uaParent != null && !uaParent.getParent().equals("DIR"));
        return path.toString();
    }

    @Override
    public void updateDelegationUA(Delegation delegation) {
        Connection connection = null;
        PreparedStatement pstm = null;
        boolean oldCentre = false;
        try {
            try {
                List<Ua> uas = this.getUas();
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                Ua oldUa = this.recupererUa(uas, delegation.getNom());
                boolean bl = oldUa != null ? !"DIR".equals(oldUa.getParent()) : (oldCentre = false);
                if (oldCentre) {
                    pstm = connection.prepareStatement("INSERT INTO prism.delegation_rattachement (nom,attribution,zone,box_minx,box_miny,box_maxx,box_maxy) VALUES (?,?,?,?,?,?,?) ");
                    pstm.setString(1, delegation.getNom());
                    pstm.setInt(2, delegation.isArchive() ? 0 : 1);
                    pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    if (delegation.getBounds() == null) {
                        pstm.setNull(4, 8);
                        pstm.setNull(5, 8);
                        pstm.setNull(6, 8);
                        pstm.setNull(7, 8);
                    } else {
                        pstm.setDouble(4, delegation.getBounds().getMinx());
                        pstm.setDouble(5, delegation.getBounds().getMiny());
                        pstm.setDouble(6, delegation.getBounds().getMaxx());
                        pstm.setDouble(7, delegation.getBounds().getMaxy());
                    }
                    pstm.execute();
                    pstm.close();
                    String oldDelegation = this.recupererDelegation(uas, (String)oldUa.getParent()).name;
                    this.majDelegationCentre(connection, oldUa.getName(), oldDelegation, null, delegation.getNom(), null);
                    oldUa.setParent("DIR");
                    for (Ua uaTemp : this.recupererUaFils(uas, delegation.getNom())) {
                        this.majDelegationCentre(connection, uaTemp.getName(), oldDelegation, uaTemp.getName(), delegation.getNom(), this.calculerPath(uas, uaTemp));
                    }
                    pstm = connection.prepareStatement("delete from prism.centre_rattachement where nom = ? and zone_routiere = ?");
                    pstm.setString(1, delegation.getNom());
                    pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    pstm.execute();
                } else {
                    pstm = connection.prepareStatement("UPDATE prism.delegation_rattachement SET attribution=?,box_minx=?,box_miny=?,box_maxx=?,box_maxy=?  WHERE nom=? AND zone=?");
                    pstm.setInt(1, delegation.isArchive() ? 0 : 1);
                    if (delegation.getBounds() == null) {
                        pstm.setNull(2, 8);
                        pstm.setNull(3, 8);
                        pstm.setNull(4, 8);
                        pstm.setNull(5, 8);
                    } else {
                        pstm.setDouble(2, delegation.getBounds().getMinx());
                        pstm.setDouble(3, delegation.getBounds().getMiny());
                        pstm.setDouble(4, delegation.getBounds().getMaxx());
                        pstm.setDouble(5, delegation.getBounds().getMaxy());
                    }
                    pstm.setString(6, delegation.getNom());
                    pstm.setString(7, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    pstm.execute();
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
        this.referentielDAO.update();
    }

    @Override
    public void updateDelegation(Delegation delegation) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.delegation_rattachement SET attribution=?,box_minx=?,box_miny=?,box_maxx=?,box_maxy=?  WHERE nom=? AND zone=?");
                pstm.setInt(1, delegation.isArchive() ? 0 : 1);
                if (delegation.getBounds() == null) {
                    pstm.setNull(2, 8);
                    pstm.setNull(3, 8);
                    pstm.setNull(4, 8);
                    pstm.setNull(5, 8);
                } else {
                    pstm.setDouble(2, delegation.getBounds().getMinx());
                    pstm.setDouble(3, delegation.getBounds().getMiny());
                    pstm.setDouble(4, delegation.getBounds().getMaxx());
                    pstm.setDouble(5, delegation.getBounds().getMaxy());
                }
                pstm.setString(6, delegation.getNom());
                pstm.setString(7, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
        this.referentielDAO.update();
    }

    @Override
    public void creerCentre(Centre centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.centre_rattachement (nom,attribution,zone_routiere,box_minx,box_miny,box_maxx,box_maxy,delegation,parent,path) VALUES (?,?,?,?,?,?,?,?,?,?) ");
                pstm.setString(1, centre.getNom());
                pstm.setInt(2, centre.isArchive() ? 0 : 1);
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (centre.getBounds() == null) {
                    pstm.setNull(4, 8);
                    pstm.setNull(5, 8);
                    pstm.setNull(6, 8);
                    pstm.setNull(7, 8);
                } else {
                    pstm.setDouble(4, centre.getBounds().getMinx());
                    pstm.setDouble(5, centre.getBounds().getMiny());
                    pstm.setDouble(6, centre.getBounds().getMaxx());
                    pstm.setDouble(7, centre.getBounds().getMaxy());
                }
                pstm.setString(8, centre.getDelegation());
                pstm.setString(9, centre.getParent());
                pstm.setString(10, centre.getPath());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
        this.referentielDAO.update();
    }

    @Override
    public void updateCentreUA(Centre centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        String oldDelegation = null;
        String oldParent = null;
        boolean isOldDelegation = false;
        try {
            try {
                List<Ua> uas = this.getUas();
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                Ua oldUa = this.recupererUa(uas, centre.getNom());
                boolean bl = isOldDelegation = oldUa != null ? "DIR".equals(oldUa.getParent()) : false;
                if (isOldDelegation) {
                    pstm = connection.prepareStatement("INSERT INTO prism.centre_rattachement (nom,attribution,zone_routiere,box_minx,box_miny,box_maxx,box_maxy,delegation,parent,path) VALUES (?,?,?,?,?,?,?,?,?,?) ");
                    pstm.setString(1, centre.getNom());
                    pstm.setInt(2, centre.isArchive() ? 0 : 1);
                    pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    if (centre.getBounds() == null) {
                        pstm.setNull(4, 8);
                        pstm.setNull(5, 8);
                        pstm.setNull(6, 8);
                        pstm.setNull(7, 8);
                    } else {
                        pstm.setDouble(4, centre.getBounds().getMinx());
                        pstm.setDouble(5, centre.getBounds().getMiny());
                        pstm.setDouble(6, centre.getBounds().getMaxx());
                        pstm.setDouble(7, centre.getBounds().getMaxy());
                    }
                    pstm.setString(8, centre.getDelegation());
                    pstm.setString(9, centre.getParent());
                    pstm.setString(10, centre.getPath());
                    pstm.execute();
                    pstm.close();
                    this.majDelegationCentre(connection, null, oldUa.getName(), centre.getNom(), centre.getDelegation(), centre.getNom());
                    oldUa.setParent(centre.getParent());
                    for (Ua uaTemp : this.recupererUaFils(uas, centre.getNom())) {
                        this.majDelegationCentre(connection, uaTemp.getName(), oldUa.getName(), uaTemp.getName(), centre.getDelegation(), this.calculerPath(uas, uaTemp));
                    }
                    pstm = connection.prepareStatement("delete from prism.delegation_rattachement where nom = ? and zone = ?");
                    pstm.setString(1, oldUa.getName());
                    pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    pstm.execute();
                } else {
                    String requete = "SELECT * FROM prism.centre_rattachement where nom = ? and zone_routiere = ?";
                    ResultSet rs = null;
                    pstm = connection.prepareStatement(requete);
                    pstm.setString(1, centre.getNom());
                    pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    rs = pstm.executeQuery();
                    if (rs.next()) {
                        oldDelegation = rs.getString("delegation");
                        oldParent = rs.getString("parent");
                    }
                    rs.close();
                    pstm.close();
                    pstm = connection.prepareStatement("UPDATE prism.centre_rattachement SET attribution=?,box_minx=?,box_miny=?,box_maxx=?,box_maxy=?,parent=?,path=?,delegation=?  WHERE nom=? AND zone_routiere=?");
                    pstm.setInt(1, centre.isArchive() ? 0 : 1);
                    if (centre.getBounds() == null) {
                        pstm.setNull(2, 8);
                        pstm.setNull(3, 8);
                        pstm.setNull(4, 8);
                        pstm.setNull(5, 8);
                    } else {
                        pstm.setDouble(2, centre.getBounds().getMinx());
                        pstm.setDouble(3, centre.getBounds().getMiny());
                        pstm.setDouble(4, centre.getBounds().getMaxx());
                        pstm.setDouble(5, centre.getBounds().getMaxy());
                    }
                    pstm.setString(6, centre.getParent());
                    pstm.setString(7, centre.getPath());
                    pstm.setString(8, centre.getDelegation());
                    pstm.setString(9, centre.getNom());
                    pstm.setString(10, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    pstm.execute();
                    if (oldDelegation != null && !oldDelegation.equals(centre.getDelegation())) {
                        oldUa.setParent(centre.getParent());
                        this.majDelegationCentre(connection, centre.getNom(), oldDelegation, centre.getNom(), centre.getDelegation(), this.calculerPath(uas, oldUa));
                        for (Ua uaTemp : this.recupererUaFils(uas, centre.getNom())) {
                            this.majDelegationCentre(connection, uaTemp.getName(), oldDelegation, uaTemp.getName(), centre.getDelegation(), this.calculerPath(uas, uaTemp));
                        }
                    } else if (oldParent != null && !oldParent.equals(centre.getParent())) {
                        oldUa.setParent(centre.getParent());
                        for (Ua uaTemp : this.recupererUaFils(uas, centre.getNom())) {
                            this.majDelegationCentre(connection, uaTemp.getName(), oldDelegation, uaTemp.getName(), centre.getDelegation(), this.calculerPath(uas, uaTemp));
                        }
                    }
                }
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
        this.referentielDAO.update();
    }

    @Override
    public void updateCentre(Centre centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.centre_rattachement SET attribution=?,box_minx=?,box_miny=?,box_maxx=?,box_maxy=?,parent=?,path=?  WHERE nom=? AND zone_routiere=?");
                pstm.setInt(1, centre.isArchive() ? 0 : 1);
                if (centre.getBounds() == null) {
                    pstm.setNull(2, 8);
                    pstm.setNull(3, 8);
                    pstm.setNull(4, 8);
                    pstm.setNull(5, 8);
                } else {
                    pstm.setDouble(2, centre.getBounds().getMinx());
                    pstm.setDouble(3, centre.getBounds().getMiny());
                    pstm.setDouble(4, centre.getBounds().getMaxx());
                    pstm.setDouble(5, centre.getBounds().getMaxy());
                }
                pstm.setString(6, centre.getParent());
                pstm.setString(7, centre.getPath());
                pstm.setString(8, centre.getNom());
                pstm.setString(9, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
        this.referentielDAO.update();
    }

    @Override
    public void creerDestinataireMail(DestinataireMail destinataire) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.destinataire_mail (id_destinataire,nom_destinataire_mail,mail,nom_categorie_destinataire_mail,delegation,centre,mse) VALUES (nextval('k_id_destinataire_mail_seq'),?,?,?,?,?,?) ");
                pstm.setString(1, destinataire.getNom());
                pstm.setString(2, destinataire.getMail());
                pstm.setString(3, destinataire.getCategorie());
                pstm.setString(4, destinataire.getDelegation());
                pstm.setString(5, destinataire.getCentre());
                pstm.setString(6, ConfigurationFactory.getInstance().get("zoneroutiere"));
                Log.debug("Requete create destinataire mail - " + pstm);
                pstm.execute();
            }
            catch (SQLException e) {
                Log.error("ERREUR Requete update destinataire mail - " + pstm);
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.referentielDAO.update();
    }

    @Override
    public void updateDestinataireMail(DestinataireMail destinataire) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.destinataire_mail SET nom_destinataire_mail=?,mail=?,nom_categorie_destinataire_mail=?,delegation=?,centre=?,mse=? WHERE id_destinataire=? ");
                pstm.setString(1, destinataire.getNom());
                pstm.setString(2, destinataire.getMail());
                pstm.setString(3, destinataire.getCategorie());
                pstm.setString(4, destinataire.getDelegation());
                pstm.setString(5, destinataire.getCentre());
                pstm.setString(6, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(7, destinataire.getId());
                Log.debug("Requete update destinataire mail - " + pstm);
                pstm.execute();
            }
            catch (SQLException e) {
                Log.error("ERREUR Requete update destinataire mail - " + pstm);
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.referentielDAO.update();
    }

    @Override
    public void deleteDestinataireMail(DestinataireMail dest) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.lien_destinataire WHERE id_destinataire=? ");
                pstm.setInt(1, dest.getId());
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("DELETE FROM prism.destinataire_mail  WHERE id_destinataire=? ");
                pstm.setInt(1, dest.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.referentielDAO.update();
    }

    @Override
    public int creerListeDestinatairesMail(ListeDestinataireMail liste) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.liste_destinataire_mail (nom_liste_destinataire_mail,zone_routiere,id_liste_destinataire_mail) VALUES (?,?,nextval('k_liste_destinataire_id_seq')) RETURNING id_liste_destinataire_mail as id");
                pstm.setString(1, liste.getNom());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    liste.setId(rs.getInt("id"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        this.updateLienDestinataires(liste);
        this.referentielDAO.update();
        return liste.getId();
    }

    @Override
    public void updateListeDestinatairesMail(ListeDestinataireMail liste) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.liste_destinataire_mail SET nom_liste_destinataire_mail=? WHERE id_liste_destinataire_mail=? ");
                pstm.setString(1, liste.getNom());
                pstm.setInt(2, liste.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateLienDestinataires(liste);
        this.referentielDAO.update();
    }

    @Override
    public void deleteListeDestinatairesMail(ListeDestinataireMail liste) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.lien_destinataire WHERE id_liste_destinataire_mail=? ");
                pstm.setInt(1, liste.getId());
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("DELETE FROM prism.liste_destinataire_mail  WHERE id_liste_destinataire_mail=? ");
                pstm.setInt(1, liste.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.referentielDAO.update();
    }

    private void updateLienDestinataires(ListeDestinataireMail liste) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.lien_destinataire WHERE id_liste_destinataire_mail=? ");
                pstm.setInt(1, liste.getId());
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("INSERT INTO prism.lien_destinataire (id_liste_destinataire_mail,id_destinataire) VALUES (?,?)");
                pstm.setInt(1, liste.getId());
                for (DestinataireMail dest : liste.getDestinataires()) {
                    pstm.setInt(2, dest.getId());
                    pstm.addBatch();
                }
                pstm.executeBatch();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void updateMailConfiguration(Map<String, Integer> diffusion, Map<String, Integer> evenements) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.liste_diffusion WHERE zone_routiere=?");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("INSERT INTO prism.liste_diffusion (id_liste_destinataire,champ,zone_routiere) VALUES (?,?,?)");
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                for (String key : diffusion.keySet()) {
                    pstm.setObject(1, diffusion.get(key));
                    pstm.setString(2, key);
                    pstm.addBatch();
                }
                pstm.executeBatch();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("DELETE FROM prism.liste_diffusion_evenement WHERE zone_routiere=?");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("INSERT INTO prism.liste_diffusion_evenement (id_liste_destinataire,description_evenement,zone_routiere) VALUES (?,?,?)");
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                for (String key : evenements.keySet()) {
                    pstm.setInt(1, evenements.get(key));
                    pstm.setString(2, key);
                    pstm.addBatch();
                }
                pstm.executeBatch();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.referentielDAO.update();
    }

    @Override
    public void updateReformulationPublication(ReformulationDescription reformulation) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.reformulation_description WHERE description=? AND mse=?");
                pstm.setString(1, reformulation.getCode());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
                DAOUtil.close(pstm);
                pstm = connection.prepareStatement("INSERT INTO prism.reformulation_description (description,mse,type1, type2, type3, type4,type5,valeur1,valeur2,valeur3,valeur4,valeur5) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
                pstm.setString(1, reformulation.getCode());
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(3, reformulation.getType1());
                pstm.setInt(4, reformulation.getType2());
                pstm.setInt(5, reformulation.getType3());
                pstm.setInt(6, reformulation.getType4());
                pstm.setInt(7, reformulation.getType5());
                pstm.setString(8, reformulation.getValeur1());
                pstm.setString(9, reformulation.getValeur2());
                pstm.setString(10, reformulation.getValeur3());
                pstm.setString(11, reformulation.getValeur4());
                pstm.setString(12, reformulation.getValeur5());
                pstm.execute();
                DAOUtil.close(pstm);
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.referentielDAO.update();
    }

    @Override
    public void updateDateModificationAdmin(String donnees) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.update_donnees_metiers SET date=now() WHERE zone_routiere=? " + (donnees != null ? "and champ = ?" : ""));
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (donnees != null) {
                    pstm.setString(2, donnees);
                }
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public int creerCircuit(Circuit v) {
        Connection connection = null;
        PreparedStatement pstm = null;
        int idCircuit = -1;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.circuit (nom, delegation, centre, archive, type, zone_routiere, fk_niveau_service) VALUES (?,?,?,?,?,?,?) returning id");
                pstm.setString(1, v.getNom());
                if (v.isArchive()) {
                    pstm.setInt(4, 1);
                } else {
                    pstm.setInt(4, 0);
                }
                pstm.setInt(5, Integer.parseInt(v.getType()));
                pstm.setString(6, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (v.getNiveauService() != null) {
                    pstm.setLong(7, v.getNiveauService());
                } else {
                    pstm.setNull(7, 4);
                }
                if (!GLS.estVide((String)v.getDelegation())) {
                    pstm.setString(2, v.getDelegation());
                } else {
                    pstm.setNull(2, 12);
                }
                if (!GLS.estVide((String)v.getCentre())) {
                    pstm.setString(3, v.getCentre());
                } else {
                    pstm.setNull(3, 12);
                }
                ResultSet rs = pstm.executeQuery();
                if (rs.next()) {
                    idCircuit = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("circuits");
        this.updateDateModificationAdmin("natures");
        this.referentielDAO.update();
        return idCircuit;
    }

    @Override
    public void updateCircuit(Circuit v) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.circuit  SET nom=?,delegation=?,centre=?,type=?,archive=?,fk_niveau_service=? WHERE id=? AND zone_routiere=?");
                pstm.setString(1, v.getNom());
                if (v.getDelegation() != null) {
                    pstm.setString(2, v.getDelegation());
                } else {
                    pstm.setNull(2, 0);
                }
                if (v.getCentre() != null) {
                    pstm.setString(3, v.getCentre());
                } else {
                    pstm.setNull(3, 0);
                }
                pstm.setInt(4, Integer.parseInt(v.getType()));
                if (v.isArchive()) {
                    pstm.setInt(5, 1);
                } else {
                    pstm.setInt(5, 0);
                }
                if (v.getNiveauService() != null) {
                    pstm.setLong(6, v.getNiveauService());
                } else {
                    pstm.setNull(6, 4);
                }
                pstm.setLong(7, Long.parseLong(v.getId()));
                pstm.setString(8, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("circuits");
        this.updateDateModificationAdmin("natures");
        this.referentielDAO.update();
    }

    @Override
    public List<Circuit> getListeCircuits() {
        ArrayList<Circuit> circuits = new ArrayList<Circuit>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_CIRCUITS_MODULES_METIERS);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Circuit c = new Circuit();
                    c.setId(String.valueOf(rs.getInt("id")));
                    c.setCentre(rs.getString("centre"));
                    c.setDelegation(rs.getString("delegation"));
                    c.setNom(rs.getString("nom"));
                    c.setType(String.valueOf(rs.getString("type")));
                    c.setArchive(rs.getInt("archive") != 0);
                    if (rs.getString("fk_niveau_service") != null) {
                        c.setNiveauService(Long.valueOf(rs.getLong("fk_niveau_service")));
                    } else {
                        c.setNiveauService(null);
                    }
                    c.setNiveau(rs.getString("niveau"));
                    circuits.add(c);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return circuits;
    }

    @Override
    public List<Circuit> getCircuitsVHActifs() {
        ArrayList<Circuit> circuits = new ArrayList<Circuit>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(SQL_CIRCUITS_VH);
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.setInt(2, 1);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Circuit c = new Circuit();
                    c.setId(String.valueOf(rs.getInt("id")));
                    c.setCentre(rs.getString("centre"));
                    c.setDelegation(rs.getString("delegation"));
                    c.setNom(rs.getString("nom"));
                    c.setType(String.valueOf(rs.getString("type")));
                    c.setArchive(rs.getInt("archive") != 0);
                    if (rs.getString("fk_niveau_service") != null) {
                        c.setNiveauService(Long.valueOf(rs.getLong("fk_niveau_service")));
                    } else {
                        c.setNiveauService(null);
                    }
                    c.setNiveau(rs.getString("niveau"));
                    circuits.add(c);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return circuits;
    }

    @Override
    public boolean updateOldPassword() {
        boolean updateOK = false;
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT sna,password FROM utilisateur WHERE mse=?");
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    String pwd = rs.getString(2);
                    if (pwd.length() == 40) continue;
                    this.updateUserPassword(rs.getString(1), pwd, true);
                }
                updateOK = true;
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return updateOK;
    }

    @Override
    public List<ConfigurationBean> getListConfiguration(boolean withZoneRoutiere) {
        ArrayList<ConfigurationBean> liste = new ArrayList<ConfigurationBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(SQL_LISTE_CONFIGURATION);
                if (withZoneRoutiere) {
                    req.append(" WHERE zone_routiere = ?");
                }
                pstm = connection.prepareStatement(req.toString());
                if (withZoneRoutiere) {
                    pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                }
                rs = pstm.executeQuery();
                while (rs.next()) {
                    ConfigurationBean c = new ConfigurationBean();
                    c.setChamp(rs.getString("champ"));
                    c.setValeur(rs.getString("valeur"));
                    c.setZoneRoutiere(rs.getString("zone_routiere"));
                    c.setLabel(rs.getString("label"));
                    if (rs.getObject("entier") != null) {
                        c.setEntier(Boolean.valueOf(rs.getBoolean("entier")));
                    }
                    c.setSysteme(rs.getInt("systeme"));
                    liste.add(c);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public void creerConfigurationBean(ConfigurationBean config) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.configuration (champ, valeur, zone_routiere, label, entier, systeme) VALUES (?,?,?,?,?,?)");
                pstm.setString(1, config.getChamp());
                pstm.setString(2, config.getValeur());
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                if (config.getLabel() != null) {
                    pstm.setString(4, config.getLabel());
                } else {
                    pstm.setNull(4, 12);
                }
                if (config.getEntier() != null) {
                    pstm.setBoolean(5, config.getEntier());
                } else {
                    pstm.setNull(5, 16);
                }
                pstm.setInt(6, config.getSysteme());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        this.referentielDAO.update();
    }

    @Override
    public void updateConfigurationBean(ConfigurationBean config) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.configuration  SET valeur=?,label=?,entier=?,systeme=? WHERE champ=? AND zone_routiere=?");
                pstm.setString(1, config.getValeur());
                if (config.getLabel() != null) {
                    pstm.setString(2, config.getLabel());
                } else {
                    pstm.setNull(2, 12);
                }
                if (config.getEntier() != null) {
                    pstm.setBoolean(3, config.getEntier());
                } else {
                    pstm.setNull(3, 16);
                }
                pstm.setInt(4, config.getSysteme());
                pstm.setString(5, config.getChamp());
                pstm.setString(6, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        this.referentielDAO.update();
    }

    @Override
    public void deleteConfigurationBean(String champ) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.configuration WHERE champ=? AND zone_routiere=?");
                pstm.setString(1, champ);
                pstm.setString(2, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        this.referentielDAO.update();
    }

    @Override
    public void creerIntentionPatrouille(IntentionPatrouille ip) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.intention_patrouille (date, etatRoute, tAir, hygrometrie, prevision, decision,commentaire,centre,delegation) VALUES (?,?,?,?,?,?,?,?,?)");
                pstm.setTimestamp(1, new Timestamp(ip.getDate()));
                pstm.setString(2, ip.getEtatRoute());
                pstm.setString(3, GLS.getString((String)ip.gettAir()));
                pstm.setString(4, GLS.getString((String)ip.getHygrometrie()));
                pstm.setString(5, GLS.getString((String)ip.getPrevision()));
                pstm.setInt(6, GLS.getInt((boolean)ip.isDecision()));
                pstm.setString(7, GLS.getString((String)ip.getCommentaire()));
                pstm.setString(8, GLS.getString((String)ip.getCentre()));
                pstm.setString(9, GLS.getString((String)ip.getDelegation()));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public void updateIntentionPatrouille(IntentionPatrouille ip) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("update prism.intention_patrouille set date=?, etat_route=?, tair=?, hygrometrie=?, prevision=?, decision=?,commentaire=? where id = ?");
                pstm.setTimestamp(1, new Timestamp(ip.getDate()));
                pstm.setString(2, ip.getEtatRoute());
                pstm.setString(3, GLS.getString((String)ip.gettAir()));
                pstm.setString(4, GLS.getString((String)ip.getHygrometrie()));
                pstm.setString(5, GLS.getString((String)ip.getPrevision()));
                pstm.setInt(6, GLS.getInt((boolean)ip.isDecision()));
                pstm.setString(7, GLS.getString((String)ip.getCommentaire()));
                pstm.setString(8, GLS.getString((String)ip.getCentre()));
                pstm.setString(9, GLS.getString((String)ip.getDelegation()));
                pstm.setLong(10, ip.getId());
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public List<IntentionPatrouille> getIntentionPatrouille(String delegation, String centre) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ArrayList<IntentionPatrouille> listeIP = new ArrayList<IntentionPatrouille>();
        try {
            try {
                String requete = "select date,etat_route,tair,hygrometrie,prevision,decision,commentaire,centre,delegation from prism.intention_patrouille where etat = 1";
                connection = this.daoFactory.getConnection();
                if (!GLS.estVide((String)delegation)) {
                    requete = String.valueOf(requete) + "and delegation = ?";
                }
                if (!GLS.estVide((String)centre)) {
                    requete = String.valueOf(requete) + "and centre = ?";
                }
                pstm = connection.prepareStatement(requete);
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    IntentionPatrouille ip = new IntentionPatrouille();
                    ip.setDate(rs.getTimestamp(1).getTime());
                    ip.setEtatRoute(rs.getString(2));
                    ip.settAir(rs.getString(3));
                    ip.setHygrometrie(rs.getString(4));
                    ip.setPrevision(rs.getString(5));
                    ip.setDecision(GLS.getBoolean((int)rs.getInt(6), (boolean)false));
                    ip.setCommentaire(rs.getString(7));
                    ip.setCentre(rs.getString(8));
                    ip.setDelegation(rs.getString(9));
                    listeIP.add(ip);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return listeIP;
    }

    @Override
    public void effacerEvenementMission() {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                Log.debug("Effacement \u00ef\u00bf\u00bdv\u00ef\u00bf\u00bdnements missions termin\u00ef\u00bf\u00bdes - update prism.evenement set fin='Y',mst=now(),valopedate=now() where dob in (select code from prism.nature_perso where code_categorie = 'mission')  and mcig_id in (select m.mcig_id from mcig m  where not m.date_heure_fin is null) and (fin is null or not fin = 'Y');");
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(REQUETE_FIN_EVENEMENT_MISSION);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }

    @Override
    public List<Astreinte> rechercheAstreintes(String delegation, String centre, Long timestamp) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ArrayList<Astreinte> liste = new ArrayList<Astreinte>();
        try {
            try {
                String requete = "SELECT * FROM prism.astreinte WHERE fin>?";
                connection = this.daoFactory.getConnection();
                if (!GLS.estVide((String)delegation)) {
                    requete = String.valueOf(requete) + "AND delegation = ?";
                }
                if (!GLS.estVide((String)centre)) {
                    requete = String.valueOf(requete) + "AND centre = ?";
                }
                pstm = connection.prepareStatement(requete);
                int i = 1;
                pstm.setTimestamp(i++, new Timestamp(timestamp));
                if (!GLS.estVide((String)delegation)) {
                    pstm.setString(i++, delegation);
                }
                if (!GLS.estVide((String)centre)) {
                    pstm.setString(i++, centre);
                }
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    Astreinte a = new Astreinte();
                    a.setId(rs.getLong("id"));
                    a.setTimestampStart(rs.getTimestamp("debut").getTime());
                    a.setTimestampEnd(rs.getTimestamp("fin").getTime());
                    a.setTypeAstreinte(rs.getString("type"));
                    a.setUser(this.getUtilisateur(rs.getInt("id_utilisateur")));
                    a.setDelegation(rs.getString("delegation"));
                    a.setCentre(rs.getString("centre"));
                    liste.add(a);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return liste;
    }

    private PrismCentralUser getUtilisateur(int idUser) {
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        PrismCentralUser user = new PrismCentralUser();
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("SELECT * FROM prism.utilisateur WHERE id_utilisateur = ?");
                pstm.setInt(1, idUser);
                rs = pstm.executeQuery();
                if (rs.next()) {
                    user.setNom(rs.getString("nom"));
                    user.setCode(rs.getString("sna"));
                    user.setId(rs.getInt("id_utilisateur"));
                    user.setIdProfil(rs.getLong("id_profil"));
                    user.setArchive(rs.getInt("archive") == 1);
                    user.setDelegation(rs.getString("delegation"));
                    user.setCentre(rs.getString("centre"));
                    user.setMail(rs.getString("mail"));
                    user.setTelephone(rs.getString("telephone"));
                    user.setConnectionType(rs.getString("connection_type"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return user;
    }

    @Override
    public boolean supprimerAstreinte(long id) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("DELETE FROM prism.astreinte WHERE id=?");
                pstm.setLong(1, id);
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        return true;
    }

    @Override
    public Long creerAstreinte(Astreinte a) {
        Connection connection = null;
        PreparedStatement pstm = null;
        Long id = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("INSERT INTO prism.astreinte (debut, fin, type, id_utilisateur, delegation, centre) VALUES (?,?,?,?,?,?) RETURNING id");
                int i = 1;
                pstm.setTimestamp(i++, new Timestamp(a.getTimestampStart()));
                pstm.setTimestamp(i++, new Timestamp(a.getTimestampEnd()));
                pstm.setString(i++, a.getTypeAstreinte());
                pstm.setInt(i++, a.getUser().getId());
                if (!GLS.estVide((String)a.getDelegation())) {
                    pstm.setString(i++, a.getDelegation());
                } else {
                    pstm.setNull(i++, 12);
                }
                if (!GLS.estVide((String)a.getCentre())) {
                    pstm.setString(i++, a.getCentre());
                } else {
                    pstm.setNull(i++, 12);
                }
                ResultSet rs = pstm.executeQuery();
                if (rs.next()) {
                    id = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        return id;
    }

    @Override
    public Long udapteAstreinte(Astreinte a) {
        Connection connection = null;
        PreparedStatement pstm = null;
        Long id = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.astreinte SET debut=?, fin=?, type=?, id_utilisateur=?, delegation=?, centre=? WHERE id = ? RETURNING id");
                int i = 1;
                pstm.setTimestamp(i++, new Timestamp(a.getTimestampStart()));
                pstm.setTimestamp(i++, new Timestamp(a.getTimestampEnd()));
                pstm.setString(i++, a.getTypeAstreinte());
                pstm.setInt(i++, a.getUser().getId());
                if (!GLS.estVide((String)a.getDelegation())) {
                    pstm.setString(i++, a.getDelegation());
                } else {
                    pstm.setNull(i++, 12);
                }
                if (!GLS.estVide((String)a.getCentre())) {
                    pstm.setString(i++, a.getCentre());
                } else {
                    pstm.setNull(i++, 12);
                }
                pstm.setLong(i++, a.getId());
                ResultSet rs = pstm.executeQuery();
                if (rs.next()) {
                    id = rs.getLong(1);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        return id;
    }

    @Override
    public List<String> listeTypeAstreintes() {
        Connection connection = null;
        PreparedStatement pstm = null;
        ArrayList<String> liste = new ArrayList<String>();
        try {
            try {
                String requete = "SELECT * FROM prism.type_astreinte";
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(requete);
                ResultSet rs = pstm.executeQuery();
                while (rs.next()) {
                    liste.add(rs.getString("libelle"));
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return liste;
    }

    @Override
    public List<ConfigurationBean> getListConfigurationPublication() {
        ArrayList<ConfigurationBean> liste = new ArrayList<ConfigurationBean>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                ConfigurationBean c;
                connection = this.daoFactory.getConnection();
                StringBuffer req = new StringBuffer();
                req.append(SQL_LISTE_CONFIGURATION_LIMITE_PUBLICATION);
                pstm = connection.prepareStatement(req.toString());
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    c = new ConfigurationBean();
                    c.setChamp(rs.getString("champ"));
                    c.setValeur(rs.getString("valeur"));
                    c.setZoneRoutiere(rs.getString("zone_routiere"));
                    c.setLabel(rs.getString("label"));
                    if (rs.getObject("entier") != null) {
                        c.setEntier(Boolean.valueOf(rs.getBoolean("entier")));
                    }
                    c.setSysteme(rs.getInt("systeme"));
                    liste.add(c);
                }
                rs.close();
                pstm.close();
                req = new StringBuffer();
                req.append(SQL_LISTE_CONFIGURATION_PUBLICATION_LIMITE_PUBLICATION);
                pstm = connection.prepareStatement(req.toString());
                pstm.setString(1, ConfigurationFactory.getInstance().get("zoneroutiere"));
                rs = pstm.executeQuery();
                while (rs.next()) {
                    c = new ConfigurationBean();
                    c.setChamp(rs.getString("code"));
                    c.setValeur(rs.getString("valeur"));
                    c.setZoneRoutiere(rs.getString("zone_routiere"));
                    c.setLabel(rs.getString("type"));
                    if (rs.getObject("type").equals("int")) {
                        c.setEntier(Boolean.valueOf(true));
                    }
                    c.setSysteme(0);
                    liste.add(c);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm, rs);
            throw throwable;
        }
        DAOUtil.close(connection, pstm, rs);
        return liste;
    }

    @Override
    public void updateConfigurationPublicationBean(ConfigurationBean config) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                if (config.getChamp().equals("validiteTronconVH")) {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement("UPDATE prism.configuration  SET valeur=? WHERE champ=? AND zone_routiere=?");
                    pstm.setString(1, config.getValeur());
                    pstm.setString(2, config.getChamp());
                    pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    pstm.execute();
                } else {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement("UPDATE prism.configuration_publication  SET valeur=? WHERE code=? AND zone_routiere=?");
                    pstm.setString(1, config.getValeur());
                    pstm.setString(2, config.getChamp());
                    pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                    pstm.execute();
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        try {
            this.daoFactory.getPublicationDAO(this.referentielDAO, null, null).datePublicationMaj();
        }
        catch (Exception e) {
            Log.error("Erreur maj date publication", e);
        }
        this.referentielDAO.update();
    }

    @Override
    public List<Ua> getUas() {
        ArrayList<Ua> uas;
        block7: {
            Connection connection = null;
            PreparedStatement pstm = null;
            ResultSet rs = null;
            uas = new ArrayList<Ua>();
            try {
                try {
                    connection = this.daoFactory.getConnection();
                    pstm = connection.prepareStatement(REQUETE_SELECTION_UA);
                    rs = pstm.executeQuery();
                    while (rs.next()) {
                        Ua ua = new Ua();
                        ua.setId(rs.getInt("id"));
                        ua.setName(rs.getString("name"));
                        ua.setParent(rs.getString("parent"));
                        ua.setArchivee(rs.getInt("attribution") == 0);
                        if (rs.getString("box_minx") != null) {
                            ua.setBoxMinX(Double.valueOf(rs.getDouble("box_minx")));
                            ua.setBoxMaxX(Double.valueOf(rs.getDouble("box_maxx")));
                            ua.setBoxMinY(Double.valueOf(rs.getDouble("box_miny")));
                            ua.setBoxMaxY(Double.valueOf(rs.getDouble("box_maxy")));
                        }
                        ua.setIdScoop(rs.getInt("id"));
                        uas.add(ua);
                    }
                }
                catch (Exception e) {
                    Log.error("", e);
                    DAOUtil.close(connection, pstm, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DAOUtil.close(connection, pstm, rs);
                throw throwable;
            }
            DAOUtil.close(connection, pstm, rs);
        }
        return uas;
    }

    @Override
    public void supprimerMarqueVehicule(MarqueVehicule marqueVehicule) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                connection.setAutoCommit(false);
                pstm = connection.prepareStatement("UPDATE prism.vehicule  SET id_marque_vehicule=null WHERE id_marque_vehicule=?");
                pstm.setLong(1, marqueVehicule.getId());
                pstm.execute();
                pstm.close();
                pstm = connection.prepareStatement("DELETE FROM prism.marque_vehicule WHERE id=?");
                pstm.setLong(1, marqueVehicule.getId());
                pstm.execute();
                connection.commit();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin("configuration");
        this.referentielDAO.rechargerMarqueVehicule();
    }

    @Override
    public List<Parametre> getParametres() {
        String REQUETE_CONFIGURATION = "SELECT * FROM prism.configuration WHERE configurable = true";
        ArrayList<Parametre> parametres = new ArrayList<Parametre>();
        Connection connection = null;
        PreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement(REQUETE_CONFIGURATION);
                rs = pstm.executeQuery();
                while (rs.next()) {
                    Parametre parametre = new Parametre();
                    parametre.setChamp(rs.getString("champ"));
                    parametre.setValeur(rs.getString("valeur"));
                    parametre.setLabel(rs.getString("label"));
                    parametre.setEntier(rs.getBoolean("entier"));
                    parametres.add(parametre);
                }
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        return parametres;
    }

    @Override
    public void updateParametre(String k, String valeurString) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.configuration SET valeur = ?  WHERE champ=? AND zone_routiere=?");
                pstm.setString(1, valeurString);
                pstm.setString(2, k);
                pstm.setString(3, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        this.updateDateModificationAdmin(null);
    }

    @Override
    public void updateUtilisateur(PrismCentralUser user, String newpwd, boolean avecColonneAdmin) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                String requeteUpdate = "UPDATE prism.utilisateur SET nom=?,telephone=?,mail=?,delegation=?,centre=?,archive=?,connection_type=?,id_profil=? WHERE sna=? AND mse=?";
                if (avecColonneAdmin) {
                    requeteUpdate = "UPDATE prism.utilisateur SET nom=?,telephone=?,mail=?,delegation=?,centre=?,archive=?,connection_type=?,id_profil=?, isadminua=?, issuperadmin = ? WHERE sna=? AND mse=?";
                }
                pstm = connection.prepareStatement(requeteUpdate);
                pstm.setString(1, user.getNom());
                if (user.getTelephone() != null) {
                    pstm.setString(2, user.getTelephone());
                } else {
                    pstm.setNull(2, 12);
                }
                if (user.getMail() != null) {
                    pstm.setString(3, user.getMail());
                } else {
                    pstm.setNull(3, 12);
                }
                if (user.getDelegation() != null) {
                    pstm.setString(4, user.getDelegation());
                } else {
                    pstm.setNull(4, 12);
                }
                if (user.getCentre() != null) {
                    pstm.setString(5, user.getCentre());
                } else {
                    pstm.setNull(5, 12);
                }
                pstm.setInt(6, user.isArchive() ? 1 : 0);
                if (user.getConnectionType() != null) {
                    pstm.setString(7, user.getConnectionType());
                } else {
                    pstm.setNull(7, 12);
                }
                pstm.setLong(8, user.getIdProfil());
                int indice = 9;
                if (avecColonneAdmin) {
                    pstm.setBoolean(indice++, user.isAdminUa());
                    pstm.setBoolean(indice++, user.isSuperAdminUa());
                }
                pstm.setString(indice++, user.getCode());
                pstm.setString(indice++, ConfigurationFactory.getInstance().get("zoneroutiere"));
                pstm.execute();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
        if (newpwd != null) {
            this.updateUserPassword(user.getCode(), newpwd, true);
        } else {
            this.updateDateModificationAdmin("utilisateurs");
            this.referentielDAO.update();
        }
    }

    @Override
    public void updateDestinatairesFonctionsMail(int idListe, HashMap<Integer, HashMap<String, Boolean>> mapDiffusion) {
        Connection connection = null;
        PreparedStatement pstm = null;
        try {
            try {
                connection = this.daoFactory.getConnection();
                pstm = connection.prepareStatement("UPDATE prism.lien_destinataire SET creation_evt=?,modification_evt=?,cloture_evt=?,traitement_evt=? WHERE id_liste_destinataire_mail=? AND id_destinataire=?");
                pstm.setInt(5, idListe);
                for (Map.Entry<Integer, HashMap<String, Boolean>> map : mapDiffusion.entrySet()) {
                    int idDest = map.getKey();
                    pstm.setBoolean(1, map.getValue().get("creation_evt"));
                    pstm.setBoolean(2, map.getValue().get("modification_evt"));
                    pstm.setBoolean(3, map.getValue().get("cloture_evt"));
                    pstm.setBoolean(4, map.getValue().get("traitement_evt"));
                    pstm.setInt(6, idDest);
                    pstm.addBatch();
                }
                pstm.executeBatch();
            }
            catch (SQLException e) {
                throw new DAOException(e);
            }
        }
        catch (Throwable throwable) {
            DAOUtil.close(connection, pstm);
            throw throwable;
        }
        DAOUtil.close(connection, pstm);
    }
}

