/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public final class DAOUtil {
    private DAOUtil() {
    }

    public static PreparedStatement prepareStatement(Connection connection, String sql, boolean returnGeneratedKeys, Object ... values) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql, returnGeneratedKeys ? 1 : 2);
        DAOUtil.setValues(preparedStatement, values);
        return preparedStatement;
    }

    public static void setValues(PreparedStatement preparedStatement, Object ... values) throws SQLException {
        int i = 0;
        while (i < values.length) {
            preparedStatement.setObject(i + 1, values[i]);
            ++i;
        }
    }

    public static java.sql.Date toSqlDate(Date date) {
        return date != null ? new java.sql.Date(date.getTime()) : null;
    }

    public static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                System.err.println("Closing Connection failed: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                System.err.println("Closing Statement failed: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                System.err.println("Closing ResultSet failed: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void close(Connection connection, Statement statement) {
        DAOUtil.close(statement);
        DAOUtil.close(connection);
    }

    public static void close(Connection connection, Statement statement, ResultSet resultSet) {
        DAOUtil.close(resultSet);
        DAOUtil.close(statement);
        DAOUtil.close(connection);
    }

    public static String getValeurFiltreCeiDynamique(String cei) {
        return "%" + cei + "%";
    }
}

