/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.DAO;

import com.geolocsystems.prismcentral.DAO.exception.DAOConfigurationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DAOProperties {
    private static final String PROPERTIES_FILE = "prismcentral.properties";
    private static final Properties PROPERTIES = new Properties();
    private String specificKey = "jdbc";

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream propertiesFile = classLoader.getResourceAsStream(PROPERTIES_FILE);
        if (propertiesFile == null) {
            throw new DAOConfigurationException("Properties file 'prismcentral.properties' is missing in classpath.");
        }
        try {
            PROPERTIES.load(propertiesFile);
        }
        catch (IOException e) {
            throw new DAOConfigurationException("Cannot load properties file 'prismcentral.properties'.", e);
        }
    }

    public String getProperty(String key, boolean mandatory) throws DAOConfigurationException {
        String fullKey = String.valueOf(this.specificKey) + "." + key;
        String property = PROPERTIES.getProperty(fullKey);
        if (property == null || property.trim().length() == 0) {
            if (mandatory) {
                throw new DAOConfigurationException("Required property '" + fullKey + "'" + " is missing in properties file '" + PROPERTIES_FILE + "'.");
            }
            property = null;
        }
        return property;
    }
}

