/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export.writer;

import com.geolocsystems.export.BarreauXML;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.EvenementInforoute;
import gls.outils.GLS;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class EvtWriterXML
extends BarreauXML {
    private static Logger log = Logger.getLogger(EvtWriterXML.class);
    private static String NORMALE = "C1";
    private static String FERME_PL = "oui";
    private static String OUVERT_PL = "non";
    private Element racine;
    private Document document = null;

    public EvtWriterXML(MapDescription parametres) {
        this.init(parametres);
        log.debug((Object)("Champ ID " + this.champId));
    }

    public EvtWriterXML() {
        this(null);
    }

    private String getStatut(boolean etat) {
        if (etat) {
            return "_ACTIF";
        }
        return "_INACTIF";
    }

    private String getTypeRepere(EvenementInforoute evt) {
        StringBuffer sb = new StringBuffer();
        if (evt != null) {
            if (!GLS.estVide((String)evt.getCc())) {
                sb.append(evt.getCc());
            } else {
                sb.append(NORMALE);
            }
            sb.append("_");
            if (evt.getFermePl()) {
                sb.append(FERME_PL);
            } else {
                sb.append(OUVERT_PL);
            }
        } else {
            sb.append(NORMALE.concat(OUVERT_PL));
        }
        return sb.toString();
    }

    public String getXmlString() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("ISO-8859-1"));
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            sortie.output(this.document, (OutputStream)b);
            return b.toString();
        }
        catch (IOException e) {
            log.error((Object)"[BarreauWriterXML][getXmlString]", (Throwable)e);
            return null;
        }
    }

    public void writeXmlFile(String fileName) {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("ISO-8859-1"));
            FileOutputStream f = new FileOutputStream(fileName);
            sortie.output(this.document, (OutputStream)f);
            f.close();
        }
        catch (IOException e) {
            log.error((Object)"[BarreauWriterXML][writeXmlFile]", (Throwable)e);
        }
    }

    public void genererXML(List<EvenementInforoute> evts) {
        this.racine = new Element("VH");
        this.racine.setAttribute(new Attribute("dateExport", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(GregorianCalendar.getInstance().getTime())));
        this.document = new Document(this.racine);
        for (EvenementInforoute evt : evts) {
            Element eltEvtVH = this.genererXML(evt);
            this.racine.addContent((Content)eltEvtVH);
        }
    }

    public Element genererXML(EvenementInforoute evt) {
        Element action = new Element("EVENT");
        action.setAttribute(new Attribute("updateDate", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(evt.getDateMaj())));
        action.addContent((Content)this.addElement("ID", String.valueOf(evt.getId())));
        action.addContent((Content)this.addElement("TYPE_REPERE", this.getTypeRepere(evt)));
        return action;
    }

    private Element addElement(String element, String valeur) {
        Element libelle = new Element(element);
        libelle.setText(valeur);
        return libelle;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Element genererXMLSerpeVH() {
        this.racine = new Element("VH");
        this.racine.setAttribute(new Attribute("dateExtraction", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(GregorianCalendar.getInstance().getTime())));
        this.document = new Document(this.racine);
        this.racine.addContent((Content)new Element("SyntheseNationale"));
        return this.racine;
    }

    public Element genererXMLDirSerpeVH(String nomZone, String synthese) {
        Element dir = new Element("DIR");
        dir.setAttribute(new Attribute("name", nomZone));
        dir.addContent((Content)this.addElement("SyntheseDir", synthese));
        return dir;
    }

    public Element genererXMLCentreSerpeVH(String centre, List<BarreauVH> barreaux) {
        Element district = new Element("District");
        district.setAttribute(new Attribute("name", centre));
        for (BarreauVH b : barreaux) {
            Element eltBarreauVH = this.genererXMLSerpeVH(b);
            district.addContent((Content)eltBarreauVH);
        }
        return district;
    }

    public Element genererXMLSerpeVH(BarreauVH barreau) {
        Element action = new Element("Itineraire");
        action.setAttribute(new Attribute("dateMaj", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(barreau.getMajDate())));
        action.setAttribute(new Attribute("id", barreau.getTronconID()));
        String cch = barreau.getStatus() == null ? "NR" : barreau.getStatus();
        action.addContent((Content)this.addElement("CCH", cch));
        action.addContent((Content)this.addElement("CCH2", barreau.getCch2() == null ? "NR" : barreau.getCch2()));
        action.addContent((Content)this.addElement("Commentaire", barreau.getCommentaire() == null ? "NR" : barreau.getCommentaire()));
        action.addContent((Content)this.addElement("CommentaireInterne", barreau.getCommentaireInterne() == null ? "NR" : barreau.getCommentaireInterne()));
        action.addContent((Content)this.addElement("Equipement", barreau.getEquipements() == null ? "NR" : barreau.getEquipements()));
        action.addContent((Content)this.addElement("Meteo", barreau.getMeteo() == null ? "NR" : barreau.getMeteo()));
        action.addContent((Content)this.addElement("TendanceCC", barreau.getTendanceCC() == null ? "NR" : barreau.getTendanceCC()));
        action.addContent((Content)this.addElement("Traitement", barreau.getTraitement() == null ? "NR" : barreau.getTraitement()));
        action.addContent((Content)this.addElement("EtatChaussee", barreau.getEtatChaussee() == null ? "NR" : barreau.getEtatChaussee()));
        action.addContent((Content)this.addElement("Temperature", barreau.getTemperature() == null ? "NR" : barreau.getTemperature()));
        action.addContent((Content)this.addElement("Vent", barreau.getVent() == null ? "NR" : barreau.getVent()));
        action.addContent((Content)this.addElement("Sens", barreau.getSens() == null ? "les 2 sens" : barreau.getSens()));
        return action;
    }
}

