/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export.writer;

import com.geolocsystems.export.BarreauXML;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BarreauxWriterXML
extends BarreauXML {
    private Element racine;
    private Document document = null;

    public BarreauxWriterXML(MapDescription parametres) {
        this.init(parametres);
        Log.debug("Champ ID " + this.champId);
    }

    public BarreauxWriterXML() {
        this(null);
    }

    public String getXmlString() {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("ISO-8859-1"));
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            sortie.output(this.document, (OutputStream)b);
            return b.toString("ISO-8859-1");
        }
        catch (IOException e) {
            Log.error("[BarreauWriterXML][getXmlString]", e);
            return null;
        }
    }

    public void writeXmlFile(String fileName) {
        try {
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat().setEncoding("ISO-8859-1"));
            FileOutputStream f = new FileOutputStream(fileName);
            sortie.output(this.document, (OutputStream)f);
            f.close();
        }
        catch (IOException e) {
            Log.error("[BarreauWriterXML][writeXmlFile]", e);
        }
    }

    public void writeSOAPXmlFile(String fileName) {
        try {
            Format format = Format.getPrettyFormat().setEncoding("ISO-8859-1");
            format.setOmitEncoding(true);
            format.setOmitDeclaration(true);
            XMLOutputter sortie = new XMLOutputter(format);
            FileOutputStream f = new FileOutputStream(fileName);
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            sb.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns=\"http://tipi.e2.rie.gouv.fr/ns/vh\">");
            sb.append("<soapenv:Header/>");
            sb.append("<soapenv:Body>");
            f.write(sb.toString().getBytes());
            sortie.output(this.document, (OutputStream)f);
            sb = new StringBuffer();
            sb.append("</soapenv:Body>");
            sb.append("</soapenv:Envelope>");
            f.write(sb.toString().getBytes());
            f.close();
        }
        catch (IOException e) {
            Log.error("[BarreauWriterXML][writeSOAPXmlFile]", e);
        }
    }

    public void genererXML(List<BarreauVH> barreaux) {
        this.racine = new Element("VH");
        this.racine.setAttribute(new Attribute("dateExport", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(GregorianCalendar.getInstance().getTime())));
        this.document = new Document(this.racine);
        for (BarreauVH b : barreaux) {
            Element eltBarreauVH = this.genererXML(b);
            this.racine.addContent((Content)eltBarreauVH);
        }
    }

    public Element genererXML(BarreauVH barreau) {
        Element action = new Element("Troncon");
        action.setAttribute(new Attribute("dateMaj", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(barreau.getMajDate())));
        action.addContent((Content)this.addElement(this.champId, barreau.getTronconID()));
        String cch = barreau.getStatus() == null ? "NR" : barreau.getStatus();
        action.addContent((Content)this.addElement("CCH", cch));
        action.addContent((Content)this.addElement("NomPatrouilleur", barreau.getIdPatrouilleur()));
        action.addContent((Content)this.addElement("CCH2", barreau.getCch2() == null ? "NR" : barreau.getCch2()));
        action.addContent((Content)this.addElement("Commentaire", barreau.getCommentaire() == null ? "NR" : barreau.getCommentaire()));
        action.addContent((Content)this.addElement("CommentaireInterne", barreau.getCommentaireInterne() == null ? "NR" : barreau.getCommentaireInterne()));
        action.addContent((Content)this.addElement("Equipement", barreau.getEquipements() == null ? "NR" : barreau.getEquipements()));
        action.addContent((Content)this.addElement("Meteo", barreau.getMeteo() == null ? "NR" : barreau.getMeteo()));
        action.addContent((Content)this.addElement("TendanceCC", barreau.getTendanceCC() == null ? "NR" : barreau.getTendanceCC()));
        action.addContent((Content)this.addElement("Traitement", barreau.getTraitement() == null ? "NR" : barreau.getTraitement()));
        action.addContent((Content)this.addElement("EtatChaussee", barreau.getEtatChaussee() == null ? "NR" : barreau.getEtatChaussee()));
        action.addContent((Content)this.addElement("Temperature", barreau.getTemperature() == null ? "NR" : barreau.getTemperature()));
        action.addContent((Content)this.addElement("Vent", barreau.getVent() == null ? "NR" : barreau.getVent()));
        action.addContent((Content)this.addElement("Sens", barreau.getSens() == null ? "NR" : barreau.getSens()));
        return action;
    }

    private Element addElement(String element, String valeur) {
        Element libelle = new Element(element);
        libelle.setText(valeur);
        return libelle;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Element genererXMLSerpeVH() {
        this.racine = new Element("VH");
        this.racine.setAttribute(new Attribute("dateExtraction", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(GregorianCalendar.getInstance().getTime())));
        this.document = new Document(this.racine);
        this.racine.addContent((Content)new Element("SyntheseNationale"));
        return this.racine;
    }

    public Element genererXMLDirSerpeVH(String nomZone, String synthese) {
        Element dir = new Element("DIR");
        dir.setAttribute(new Attribute("name", nomZone));
        dir.addContent((Content)this.addElement("SyntheseDir", synthese));
        return dir;
    }

    public Element genererXMLCentreSerpeVH(String centre, List<BarreauVH> barreaux) {
        Element district = new Element("District");
        district.setAttribute(new Attribute("name", centre));
        for (BarreauVH b : barreaux) {
            Element eltBarreauVH = this.genererXMLSerpeVH(b);
            district.addContent((Content)eltBarreauVH);
        }
        return district;
    }

    public Element genererXMLSerpeVH(BarreauVH barreau) {
        Element action = new Element("Itineraire");
        action.setAttribute(new Attribute("dateMaj", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(barreau.getMajDate())));
        action.setAttribute(new Attribute("id", barreau.getTronconID()));
        String cch = barreau.getStatus() == null ? "NR" : barreau.getStatus();
        action.addContent((Content)this.addElement("CCH", cch));
        action.addContent((Content)this.addElement("CCH2", barreau.getCch2() == null ? "NR" : barreau.getCch2()));
        action.addContent((Content)this.addElement("Commentaire", barreau.getCommentaire() == null ? "NR" : barreau.getCommentaire()));
        action.addContent((Content)this.addElement("CommentaireInterne", barreau.getCommentaireInterne() == null ? "NR" : barreau.getCommentaireInterne()));
        action.addContent((Content)this.addElement("Equipement", barreau.getEquipements() == null ? "NR" : barreau.getEquipements()));
        action.addContent((Content)this.addElement("Meteo", barreau.getMeteo() == null ? "NR" : barreau.getMeteo()));
        action.addContent((Content)this.addElement("TendanceCC", barreau.getTendanceCC() == null ? "NR" : barreau.getTendanceCC()));
        action.addContent((Content)this.addElement("Traitement", barreau.getTraitement() == null ? "NR" : barreau.getTraitement()));
        action.addContent((Content)this.addElement("EtatChaussee", barreau.getEtatChaussee() == null ? "NR" : barreau.getEtatChaussee()));
        action.addContent((Content)this.addElement("Temperature", barreau.getTemperature() == null ? "NR" : barreau.getTemperature()));
        action.addContent((Content)this.addElement("Vent", barreau.getVent() == null ? "NR" : barreau.getVent()));
        action.addContent((Content)this.addElement("Sens", barreau.getSens() == null ? "les 2 sens" : barreau.getSens()));
        return action;
    }
}

