/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.export.transfertFtp;

import com.geolocsystems.prismcentral.Log;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPHTTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;

public final class FTPClientExample {
    Logger rlog = Logger.getLogger((String)"exportVH");
    public static final String USAGE = "Usage: ftp [options] <hostname> <username> <password> [<remote file> [<local file>]]\n\nDefault behavior is to download a file and use ASCII transfer mode.\n\t-a - use local active mode (default is local passive)\n\t-A - anonymous login (omit username and password parameters)\n\t-b - use binary transfer mode\n\t-c cmd - issue arbitrary command (remote is used as a parameter if provided) \n\t-d - list directory details using MLSD (remote is used as the pathname if provided)\n\t-e - use EPSV with IPv4 (default false)\n\t-f - issue FEAT command (remote and local files are ignored)\n\t-h - list hidden files (applies to -l and -n only)\n\t-k secs - use keep-alive timer (setControlKeepAliveTimeout)\n\t-l - list files using LIST (remote is used as the pathname if provided)\n\t     Files are listed twice: first in raw mode, then as the formatted parsed data.\n\t-L - use lenient future dates (server dates may be up to 1 day into future)\n\t-n - list file names using NLST (remote is used as the pathname if provided)\n\t-p true|false|protocol[,true|false] - use FTPSClient with the specified protocol and/or isImplicit setting\n\t-s - store file on server (upload)\n\t-t - list file details using MLST (remote is used as the pathname if provided)\n\t-w msec - wait time for keep-alive reply (setControlKeepAliveReplyTimeout)\n\t-T  all|valid|none - use one of the built-in TrustManager implementations (none = JVM default)\n\t-PrH server[:port] - HTTP Proxy host and optional port[80] \n\t-PrU user - HTTP Proxy server username\n\t-PrP password - HTTP Proxy server password\n\t-# - add hash display during transfers\n";

    public static void main1(String[] args) throws UnknownHostException {
        boolean error;
        block127: {
            FTPClient ftp;
            String local;
            String remote;
            String doCommand;
            boolean lenient;
            boolean mlsd;
            boolean mlst;
            boolean feat;
            boolean useEpsvWithIPv4;
            boolean localActive;
            boolean listNames;
            boolean listFiles;
            boolean binaryTransfer;
            boolean storeFile;
            block126: {
                storeFile = false;
                binaryTransfer = false;
                error = false;
                listFiles = false;
                listNames = false;
                boolean hidden = false;
                localActive = false;
                useEpsvWithIPv4 = false;
                feat = false;
                boolean printHash = false;
                mlst = false;
                mlsd = false;
                lenient = false;
                long keepAliveTimeout = -1L;
                int controlKeepAliveReplyTimeout = -1;
                int minParams = 5;
                String protocol = null;
                doCommand = null;
                String trustmgr = null;
                String proxyHost = null;
                int proxyPort = 80;
                String proxyUser = null;
                String proxyPassword = null;
                String username = null;
                String password = null;
                int base = 0;
                base = 0;
                while (base < args.length) {
                    if (args[base].equals("-s")) {
                        storeFile = true;
                    } else if (args[base].equals("-a")) {
                        localActive = true;
                    } else if (args[base].equals("-A")) {
                        username = "anonymous";
                        password = String.valueOf(System.getProperty("user.name")) + "@" + InetAddress.getLocalHost().getHostName();
                    } else if (args[base].equals("-b")) {
                        binaryTransfer = true;
                    } else if (args[base].equals("-c")) {
                        doCommand = args[++base];
                        minParams = 3;
                    } else if (args[base].equals("-d")) {
                        mlsd = true;
                        minParams = 3;
                    } else if (args[base].equals("-e")) {
                        useEpsvWithIPv4 = true;
                    } else if (args[base].equals("-f")) {
                        feat = true;
                        minParams = 3;
                    } else if (args[base].equals("-h")) {
                        hidden = true;
                    } else if (args[base].equals("-k")) {
                        keepAliveTimeout = Long.parseLong(args[++base]);
                    } else if (args[base].equals("-l")) {
                        listFiles = true;
                        minParams = 3;
                    } else if (args[base].equals("-L")) {
                        lenient = true;
                    } else if (args[base].equals("-n")) {
                        listNames = true;
                        minParams = 3;
                    } else if (args[base].equals("-p")) {
                        protocol = args[++base];
                    } else if (args[base].equals("-t")) {
                        mlst = true;
                        minParams = 3;
                    } else if (args[base].equals("-w")) {
                        controlKeepAliveReplyTimeout = Integer.parseInt(args[++base]);
                    } else if (args[base].equals("-T")) {
                        trustmgr = args[++base];
                    } else if (args[base].equals("-PrH")) {
                        String[] parts;
                        if ((parts = (proxyHost = args[++base]).split(":")).length == 2) {
                            proxyHost = parts[0];
                            proxyPort = Integer.parseInt(parts[1]);
                        }
                    } else if (args[base].equals("-PrU")) {
                        proxyUser = args[++base];
                    } else if (args[base].equals("-PrP")) {
                        proxyPassword = args[++base];
                    } else {
                        if (!args[base].equals("-#")) break;
                        printHash = true;
                    }
                    ++base;
                }
                int remain = args.length - base;
                if (username != null) {
                    minParams -= 2;
                }
                if (remain < minParams) {
                    System.err.println(USAGE);
                    System.exit(1);
                }
                String server = args[base++];
                int port = 0;
                String[] parts = server.split(":");
                if (parts.length == 2) {
                    server = parts[0];
                    port = Integer.parseInt(parts[1]);
                }
                if (username == null) {
                    username = args[base++];
                    password = args[base++];
                }
                remote = null;
                if (args.length - base > 0) {
                    remote = args[base++];
                }
                local = null;
                if (args.length - base > 0) {
                    local = args[base++];
                }
                if (protocol == null) {
                    if (proxyHost != null) {
                        System.out.println("Using HTTP proxy server: " + proxyHost);
                        ftp = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
                    } else {
                        ftp = new FTPClient();
                    }
                } else {
                    String[] prot;
                    FTPSClient ftps = protocol.equals("true") ? new FTPSClient(true) : (protocol.equals("false") ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
                    ftp = ftps;
                    if ("all".equals(trustmgr)) {
                        ftps.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
                    } else if ("valid".equals(trustmgr)) {
                        ftps.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
                    } else if ("none".equals(trustmgr)) {
                        ftps.setTrustManager(null);
                    }
                }
                if (printHash) {
                    ftp.setCopyStreamListener(FTPClientExample.createListener());
                }
                if (keepAliveTimeout >= 0L) {
                    ftp.setControlKeepAliveTimeout(keepAliveTimeout);
                }
                if (controlKeepAliveReplyTimeout >= 0) {
                    ftp.setControlKeepAliveReplyTimeout(controlKeepAliveReplyTimeout);
                }
                ftp.setListHiddenFiles(hidden);
                ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), true));
                try {
                    if (port > 0) {
                        ftp.connect(server, port);
                    } else {
                        ftp.connect(server);
                    }
                    System.out.println("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort()));
                    int reply = ftp.getReplyCode();
                    if (!FTPReply.isPositiveCompletion((int)reply)) {
                        ftp.disconnect();
                        System.err.println("FTP server refused connection.");
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    if (ftp.isConnected()) {
                        try {
                            ftp.disconnect();
                        }
                        catch (IOException prot) {
                            // empty catch block
                        }
                    }
                    System.err.println("Could not connect to server.");
                    e.printStackTrace();
                    System.exit(1);
                }
                if (ftp.login(username, password)) break block126;
                ftp.logout();
                error = true;
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                break block127;
            }
            try {
                System.out.println("Remote system is " + ftp.getSystemType());
                if (binaryTransfer) {
                    ftp.setFileType(2);
                } else {
                    ftp.setFileType(0);
                }
                if (localActive) {
                    ftp.enterLocalActiveMode();
                } else {
                    ftp.enterLocalPassiveMode();
                }
                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                if (storeFile) {
                    FileInputStream input = new FileInputStream(local);
                    ftp.storeFile(remote, (InputStream)input);
                    ((InputStream)input).close();
                } else if (listFiles) {
                    if (lenient) {
                        FTPClientConfig config = new FTPClientConfig();
                        config.setLenientFutureDates(true);
                        ftp.configure(config);
                    }
                    FTPFile[] fTPFileArray = ftp.listFiles(remote);
                    int n = fTPFileArray.length;
                    int prot = 0;
                    while (prot < n) {
                        FTPFile f = fTPFileArray[prot];
                        System.out.println(f.getRawListing());
                        System.out.println(f.toFormattedString());
                        ++prot;
                    }
                } else if (mlsd) {
                    FTPFile[] fTPFileArray = ftp.mlistDir(remote);
                    int n = fTPFileArray.length;
                    int prot = 0;
                    while (prot < n) {
                        FTPFile f = fTPFileArray[prot];
                        System.out.println(f.getRawListing());
                        System.out.println(f.toFormattedString());
                        ++prot;
                    }
                } else if (mlst) {
                    FTPFile f = ftp.mlistFile(remote);
                    if (f != null) {
                        System.out.println(f.toFormattedString());
                    }
                } else if (listNames) {
                    String[] stringArray = ftp.listNames(remote);
                    int n = stringArray.length;
                    int prot = 0;
                    while (prot < n) {
                        String s = stringArray[prot];
                        System.out.println(s);
                        ++prot;
                    }
                } else if (feat) {
                    if (remote != null) {
                        if (ftp.hasFeature(remote)) {
                            System.out.println("Has feature: " + remote);
                        } else if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " was not detected");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                        String[] features = ftp.featureValues(remote);
                        if (features != null) {
                            String[] stringArray = features;
                            int n = features.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String f = stringArray[n2];
                                System.out.println("FEAT " + remote + "=" + f + ".");
                                ++n2;
                            }
                        } else if (FTPReply.isPositiveCompletion((int)ftp.getReplyCode())) {
                            System.out.println("FEAT " + remote + " is not present");
                        } else {
                            System.out.println("Command failed: " + ftp.getReplyString());
                        }
                    } else if (!ftp.features()) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else if (doCommand != null) {
                    if (!ftp.doCommand(doCommand, remote)) {
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else {
                    FileOutputStream output = new FileOutputStream(local);
                    ftp.retrieveFile(remote, (OutputStream)output);
                    ((OutputStream)output).close();
                }
                ftp.noop();
                ftp.logout();
            }
            catch (FTPConnectionClosedException e) {
                error = true;
                System.err.println("Server closed connection.");
                e.printStackTrace();
                if (ftp.isConnected()) {
                    try {
                        ftp.disconnect();
                    }
                    catch (IOException iOException) {}
                }
                break block127;
            }
            catch (IOException e) {
                try {
                    error = true;
                    e.printStackTrace();
                    break block127;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ftp.isConnected()) {
                        try {
                            ftp.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        System.exit(error ? 1 : 0);
    }

    private static CopyStreamListener createListener() {
        return new CopyStreamListener(){
            private long megsTotal = 0L;

            public void bytesTransferred(CopyStreamEvent event) {
                this.bytesTransferred(event.getTotalBytesTransferred(), event.getBytesTransferred(), event.getStreamSize());
            }

            public void bytesTransferred(long totalBytesTransferred, int bytesTransferred, long streamSize) {
                long megs = totalBytesTransferred / 1000000L;
                long l = this.megsTotal;
                while (l < megs) {
                    System.err.print("#");
                    ++l;
                }
                this.megsTotal = megs;
            }
        };
    }

    public void ftpRenamme(String[] args, int port, String server, String remote, String local, String username, String password, Vector<String> doCommand) throws UnknownHostException {
        FTPClient ftp;
        boolean storeFile = false;
        boolean binaryTransfer = false;
        boolean error = false;
        boolean listFiles = false;
        boolean listNames = true;
        boolean hidden = false;
        boolean localActive = false;
        boolean useEpsvWithIPv4 = false;
        boolean feat = false;
        boolean printHash = false;
        boolean mlst = false;
        boolean mlsd = false;
        boolean lenient = false;
        long keepAliveTimeout = -1L;
        int controlKeepAliveReplyTimeout = -1;
        int minParams = 5;
        String protocol = null;
        String trustmgr = null;
        String proxyHost = null;
        int proxyPort = 80;
        String proxyUser = null;
        String proxyPassword = null;
        int base = 0;
        base = 0;
        while (base < args.length) {
            if (args[base].equals("-s")) {
                storeFile = true;
            } else if (args[base].equals("-a")) {
                localActive = true;
            } else if (args[base].equals("-A")) {
                username = "anonymous";
                password = String.valueOf(System.getProperty("user.name")) + "@" + InetAddress.getLocalHost().getHostName();
            } else if (args[base].equals("-b")) {
                binaryTransfer = true;
            } else if (args[base].equals("-c")) {
                minParams = 3;
            } else if (args[base].equals("-d")) {
                mlsd = true;
                minParams = 3;
            } else if (args[base].equals("-e")) {
                useEpsvWithIPv4 = true;
            } else if (args[base].equals("-f")) {
                feat = true;
                minParams = 3;
            } else if (args[base].equals("-h")) {
                hidden = true;
            } else if (args[base].equals("-k")) {
                keepAliveTimeout = Long.parseLong(args[++base]);
            } else if (args[base].equals("-l")) {
                listFiles = true;
                minParams = 3;
            } else if (args[base].equals("-L")) {
                lenient = true;
            } else if (args[base].equals("-n")) {
                listNames = true;
                minParams = 3;
            } else if (args[base].equals("-p")) {
                protocol = args[++base];
            } else if (args[base].equals("-t")) {
                mlst = true;
                minParams = 3;
            } else if (args[base].equals("-w")) {
                controlKeepAliveReplyTimeout = Integer.parseInt(args[++base]);
            } else if (args[base].equals("-T")) {
                trustmgr = args[++base];
            } else if (args[base].equals("-PrH")) {
                String[] parts;
                if ((parts = (proxyHost = args[++base]).split(":")).length == 2) {
                    proxyHost = parts[0];
                    proxyPort = Integer.parseInt(parts[1]);
                }
            } else if (args[base].equals("-PrU")) {
                proxyUser = args[++base];
            } else if (args[base].equals("-PrP")) {
                proxyPassword = args[++base];
            } else {
                if (!args[base].equals("-#")) break;
                printHash = true;
            }
            ++base;
        }
        if (protocol == null) {
            if (proxyHost != null) {
                System.out.println("Using HTTP proxy server: " + proxyHost);
                ftp = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
            } else {
                ftp = new FTPClient();
            }
        } else {
            String[] prot;
            FTPSClient ftps = protocol.equals("true") ? new FTPSClient(true) : (protocol.equals("false") ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
            ftp = ftps;
            if ("all".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
            } else if ("valid".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
            } else if ("none".equals(trustmgr)) {
                ftps.setTrustManager(null);
            }
        }
        ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), false));
        try {
            if (port > 0) {
                ftp.connect(server, port);
            } else {
                ftp.connect(server);
            }
            this.rlog.debug((Object)("Connected to " + server + " on " + (port > 0 ? port : ftp.getDefaultPort())));
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                this.rlog.error((Object)"FTP server refused connection.");
                return;
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.rlog.error((Object)"Could not connect to server.", (Throwable)e);
            return;
        }
        try {
            if (!ftp.login(username, password)) {
                ftp.logout();
                error = true;
                return;
            }
            try {
                int n;
                Object[] objectArray;
                this.rlog.debug((Object)("Remote system is " + ftp.getSystemType()));
                if (binaryTransfer) {
                    ftp.setFileType(2);
                } else {
                    ftp.setFileType(0);
                }
                if (localActive) {
                    ftp.enterLocalActiveMode();
                } else {
                    ftp.enterLocalPassiveMode();
                }
                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                if (listFiles) {
                    if (lenient) {
                        FTPClientConfig config = new FTPClientConfig();
                        config.setLenientFutureDates(true);
                        ftp.configure(config);
                    }
                    objectArray = ftp.listFiles(remote);
                    n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FTPFile f = objectArray[n2];
                        System.out.println(f.getRawListing());
                        System.out.println(f.toFormattedString());
                        ++n2;
                    }
                }
                if (listNames) {
                    objectArray = ftp.listNames(remote);
                    n = objectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        FTPFile s = objectArray[n3];
                        System.out.println((String)s);
                        ++n3;
                    }
                }
                if (doCommand != null) {
                    for (String command : doCommand) {
                        if (ftp.doCommand(command, remote)) continue;
                        System.out.println("Failed: " + ftp.getReplyString());
                    }
                } else {
                    FileOutputStream output = new FileOutputStream(local);
                    ftp.retrieveFile(remote, (OutputStream)output);
                    ((OutputStream)output).close();
                }
                ftp.noop();
                ftp.logout();
            }
            catch (FTPConnectionClosedException e) {
                error = true;
                System.err.println("Server closed connection.");
                e.printStackTrace();
            }
            catch (IOException e) {
                error = true;
                e.printStackTrace();
            }
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void ftpRenamme(String cheminServeur, final String ftpExtensionTemp, String server, int port, String username, String password, String mode, String typeTransfer) throws UnknownHostException {
        FTPClient ftp;
        boolean storeFile = false;
        boolean binaryTransfer = false;
        boolean error = false;
        boolean listFiles = false;
        boolean listNames = true;
        boolean hidden = false;
        boolean localActive = false;
        boolean useEpsvWithIPv4 = false;
        boolean feat = false;
        boolean printHash = false;
        boolean mlst = false;
        boolean mlsd = false;
        boolean lenient = false;
        long keepAliveTimeout = -1L;
        int controlKeepAliveReplyTimeout = -1;
        int minParams = 5;
        String protocol = null;
        Object trustmgr = null;
        String proxyHost = null;
        int proxyPort = 80;
        String proxyUser = null;
        String proxyPassword = null;
        if (protocol == null) {
            if (proxyHost != null) {
                this.rlog.debug((Object)("[FTPClient]Using HTTP proxy server: " + proxyHost));
                ftp = new FTPHTTPClient(proxyHost, proxyPort, proxyUser, proxyPassword);
            } else {
                ftp = new FTPClient();
            }
        } else {
            String[] prot;
            FTPSClient ftps = protocol.equals("true") ? new FTPSClient(true) : (protocol.equals("false") ? new FTPSClient(false) : ((prot = protocol.split(",")).length == 1 ? new FTPSClient(protocol) : new FTPSClient(prot[0], Boolean.parseBoolean(prot[1]))));
            ftp = ftps;
            if ("all".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getAcceptAllTrustManager());
            } else if ("valid".equals(trustmgr)) {
                ftps.setTrustManager((TrustManager)TrustManagerUtils.getValidateServerCertificateTrustManager());
            } else if ("none".equals(trustmgr)) {
                ftps.setTrustManager(null);
            }
        }
        try {
            String fichierLog = ((FileAppender)this.rlog.getAppender("file")).getFile().concat(".ftp");
            ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(new FileWriter(fichierLog, true)), false));
        }
        catch (Exception e1) {
            ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out), false));
        }
        try {
            if (port > 0) {
                ftp.connect(server, port);
            } else {
                ftp.connect(server);
            }
            this.rlog.debug((Object)("[FTPClient]Connection \u00e0 " + server + " sur " + (port > 0 ? port : ftp.getDefaultPort())));
            int reply = ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftp.disconnect();
                this.rlog.error((Object)"[FTPClient]FTP server refused connection.");
                return;
            }
        }
        catch (IOException e) {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException prot) {
                    // empty catch block
                }
            }
            this.rlog.error((Object)"[FTPClient]Could not connect to server.", (Throwable)e);
            return;
        }
        try {
            if (!ftp.login(username, password)) {
                ftp.logout();
                error = true;
                return;
            }
            try {
                this.rlog.debug((Object)("[FTPClient]Remote system is " + ftp.getSystemType()));
                if (typeTransfer.equals("ASCII")) {
                    ftp.setFileType(0);
                } else {
                    ftp.setFileType(2);
                }
                if (mode.equals("1")) {
                    ftp.enterLocalActiveMode();
                } else {
                    ftp.enterLocalPassiveMode();
                }
                ftp.setUseEPSVwithIPv4(useEpsvWithIPv4);
                ftp.changeWorkingDirectory(cheminServeur);
                if (listNames) {
                    FTPFileFilter ftpFilter = new FTPFileFilter(){

                        public boolean accept(FTPFile file) {
                            return file.getName().endsWith(ftpExtensionTemp);
                        }
                    };
                    FTPFile[] fTPFileArray = ftp.listFiles(cheminServeur, ftpFilter);
                    int n = fTPFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FTPFile s = fTPFileArray[n2];
                        this.rlog.debug((Object)("[FTPClient]" + s.getName()));
                        ftp.rename(s.getName(), s.getName().substring(0, s.getName().length() - ftpExtensionTemp.length()));
                        ++n2;
                    }
                }
                ftp.noop();
                ftp.logout();
            }
            catch (FTPConnectionClosedException e) {
                error = true;
                this.rlog.error((Object)"Server closed connection.", (Throwable)e);
            }
            catch (IOException e) {
                error = true;
                this.rlog.error((Object)"Erreur.", (Throwable)e);
            }
        }
        finally {
            if (ftp.isConnected()) {
                try {
                    ftp.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void ftpSend(String repertoireEnvoi, String cheminServeur, String ftpExtensionTemp, String server, int port, String username, String password, String mode, String typeTransfer) throws UnknownHostException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean ftpSendOneTime(String repertoireEnvoi, String cheminServeur, String ftpExtensionTemp, String server, int port, String username, String password, String mode, String typeTransfer) throws UnknownHostException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void main(String[] args) throws UnknownHostException {
        FTPClientExample ftp = new FTPClientExample();
        try {
            ftp.ftpSendTEST("/", "/", ".tmp", "178.32.20.73", 21, "TLS", "florent", "Florent1234!", "0", "ASCII");
        }
        catch (Exception e) {
            Log.error("Renommage en erreur ", e);
        }
    }

    /*
     * Exception decompiling
     */
    public void ftpSendTEST(String repertoireEnvoi, String cheminServeur, String ftpExtensionTemp, String server, int port, String protocole, String username, String password, String mode, String typeTransfer) throws UnknownHostException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 27[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

