/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentralvaadin.config;

import com.geolocsystems.prismcentralvaadin.config.IConfiguration;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class PropertiesConfiguration
implements IConfiguration {
    private static final String PRISM_CENTRAL_PROPERTIES = "prismcentral.properties";
    private Properties properties = null;

    public PropertiesConfiguration(String filename) throws IOException {
        try {
            InputStream inputStream = PropertiesConfiguration.class.getClassLoader().getResourceAsStream(filename);
            this.properties = new Properties();
            this.properties.load(inputStream);
        }
        catch (Exception e) {
            FileInputStream inputStream = new FileInputStream("config/prismcentral.properties");
            this.properties = new Properties();
            this.properties.load(inputStream);
        }
    }

    public PropertiesConfiguration() throws IOException {
        this(PRISM_CENTRAL_PROPERTIES);
    }

    @Override
    public String get(String key) {
        return this.get(key, false);
    }

    @Override
    public String get(String key, boolean mandatory) {
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        if (mandatory) {
            throw new PrismConfigurationError("Missing key " + key + " in file prismcentral.properties");
        }
        return null;
    }

    @Override
    public boolean getBoolean(String key, boolean defaut) {
        try {
            String val = this.get(key);
            return Integer.parseInt(val) == 1;
        }
        catch (Exception e) {
            return defaut;
        }
    }

    @Override
    public int getInt(String key) {
        String val = this.get(key);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            throw new PrismConfigurationError("Unparsable int " + val + " for key " + key);
        }
    }

    @Override
    public double getDouble(String key) {
        String val = this.get(key);
        try {
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            throw new PrismConfigurationError("Unparsable double " + val + " for key " + key);
        }
    }

    @Override
    public double getDouble(String key, double defaut) {
        try {
            String val = this.get(key);
            return Double.parseDouble(val);
        }
        catch (Exception e) {
            return defaut;
        }
    }

    @Override
    public int getInt(String key, int value) {
        String val = this.get(key);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return value;
        }
    }
}

