/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.data.filtrejava;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampEntier;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJavaChampDynamique;
import java.util.List;

public class FiltreChampEntier
extends FiltreJavaChampDynamique {
    public FiltreChampEntier(Nature nature, Champ champ, List<String> valeurs) {
        super(nature, champ, FiltreChampEntier.getValeur(valeurs));
    }

    public FiltreChampEntier(Nature nature, Champ champ, int valeurs) {
        super(nature, champ, valeurs);
    }

    @Override
    public boolean accept(Evenement e) {
        ValeurChampEntier v = (ValeurChampEntier)this.getValeurChamp(this.champ.getNom(), e);
        if (v != null) {
            boolean acceptRestriction = true;
            if (this.champ.getRestrictions() != null) {
                for (Restriction r : MetierCommun.getRestrictionsValeurChamp(this.champ)) {
                    ValeurChamp valeurChampRestriction;
                    if (r.accept(valeurChampRestriction = this.getValeurChamp(r.getNomChamp(), e))) continue;
                    acceptRestriction = false;
                    break;
                }
            }
            if (acceptRestriction) {
                return v.getValeur() >= (Integer)this.valeur;
            }
        }
        return false;
    }

    private static int getValeur(List<String> valeurs) {
        if (valeurs != null && !valeurs.isEmpty()) {
            try {
                return Integer.parseInt(valeurs.get(0));
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }
}

