/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismcentral.beans;

import com.geolocsystems.prismcentral.beans.BarreauVH;

public class BulletinInforouteLigne {
    private int id;
    private int id_ligne;
    private int id_groupe;
    private String cc;
    private String commentaire;
    private int etatPrecipitation;
    private String precipitation;
    private String codeIntervention;
    private String intervention;
    private String codeEtatChaussee;
    private String etatChaussee;
    private Boolean interdiction;

    public BulletinInforouteLigne() {
    }

    public BulletinInforouteLigne(int id_groupe, int id_ligne, int id, String cc, String commentaire, int etatPrecipitation, String codeIntervention, String codeEtatChaussee, Boolean interdiction) {
        this.id_groupe = id_groupe;
        this.id_ligne = id_ligne;
        this.id = id;
        this.cc = cc;
        this.commentaire = commentaire;
        this.etatPrecipitation = etatPrecipitation;
        switch (etatPrecipitation) {
            case 1: {
                this.precipitation = "Neige";
            }
            case 2: {
                this.precipitation = "Pluie vergla\u00e7ante";
            }
            case 4: {
                this.precipitation = "Pluie";
            }
        }
        this.precipitation = "NR";
        this.codeEtatChaussee = codeEtatChaussee;
        this.etatChaussee = "S".equals(codeEtatChaussee) ? "S\u00e8che" : ("H".equals(codeEtatChaussee) ? "Humide" : ("V".equals(codeEtatChaussee) ? "Vergla\u00e7\u00e9e" : ("E".equals(codeEtatChaussee) ? "Enneig\u00e9e" : ("G".equals(codeEtatChaussee) ? "Givre" : ("N".equals(codeEtatChaussee) ? "Neige r\u00e9siduelle" : ("L".equals(codeEtatChaussee) ? "Verglas localis\u00e9" : "NR"))))));
        this.codeIntervention = codeIntervention;
        if ("E".equals(codeIntervention)) {
            this.intervention = "En cours";
        } else if ("T".equals(codeIntervention)) {
            this.intervention = "Termin\u00e9";
        }
        this.interdiction = interdiction;
    }

    public int getId_groupe() {
        return this.id_groupe;
    }

    public void setId_groupe(int id_groupe) {
        this.id_groupe = id_groupe;
    }

    public int getId_ligne() {
        return this.id_ligne;
    }

    public void setId_ligne(int id_ligne) {
        this.id_ligne = id_ligne;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getCommentaire() {
        return this.commentaire;
    }

    public void setCommentaire(String commentaire) {
        this.commentaire = commentaire;
    }

    public String getPrecipitation() {
        return this.precipitation;
    }

    public void setPrecipitation(String precipitation) {
        this.precipitation = precipitation;
    }

    public String getIntervention() {
        return this.intervention;
    }

    public void setIntervention(String intervention) {
        this.intervention = intervention;
    }

    public String getEtatChaussee() {
        return this.etatChaussee;
    }

    public void setEtatChaussee(String etatChaussee) {
        this.etatChaussee = etatChaussee;
    }

    public Boolean getInterdiction() {
        return this.interdiction;
    }

    public void setInterdiction(Boolean interdiction) {
        this.interdiction = interdiction;
    }

    public String toCC() {
        Object retour = "";
        if ("C2".equals(this.cc)) {
            retour = this.cc;
            if ("V".equals(this.codeEtatChaussee)) {
                retour = (String)retour + " verglas";
            }
            if ("E".equals(this.codeEtatChaussee)) {
                retour = (String)retour + " neige";
            }
            if ("L".equals(this.codeEtatChaussee)) {
                retour = (String)retour + " verglas localis\u00e9";
            }
            if ("N".equals(this.codeEtatChaussee)) {
                retour = (String)retour + " neige r\u00e9siduelle";
            }
        } else if ("C3".equals(this.cc) || "C4".equals(this.cc)) {
            retour = this.cc;
            if ("V".equals(this.codeEtatChaussee)) {
                retour = (String)retour + " verglas";
            }
            if ("E".equals(this.codeEtatChaussee)) {
                retour = (String)retour + " neige";
            }
        } else {
            retour = this.cc != null && !this.cc.equals("") ? this.cc : "NC";
        }
        return retour;
    }

    public String toString() {
        return "BulletinInforouteLigne [id=" + this.id + ", cc=" + this.cc + ", commentaire=" + this.commentaire + ", precipitation=" + this.precipitation + ", intervention=" + this.intervention + ", etatChaussee=" + this.etatChaussee + ", codeEtatChaussee=" + this.codeEtatChaussee + ", interdiction=" + String.valueOf(this.interdiction) + "]";
    }

    public boolean isEvt() {
        return this.id_groupe == 3;
    }

    public int getEtatPrecipitation() {
        return this.etatPrecipitation;
    }

    public void setEtatPrecipitation(int etatPrecipitation) {
        this.etatPrecipitation = etatPrecipitation;
    }

    public String getCodeEtatChaussee() {
        return this.codeEtatChaussee;
    }

    public void setCodeEtatChaussee(String codeEtatChaussee) {
        this.codeEtatChaussee = codeEtatChaussee;
    }

    public String getCodeIntervention() {
        return this.codeIntervention;
    }

    public void setCodeIntervention(String codeIntervention) {
        this.codeIntervention = codeIntervention;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof Integer) {
                return Integer.parseInt(String.valueOf(obj)) == this.id;
            }
            if (obj instanceof BarreauVH) {
                return ((BarreauVH)obj).getId() == String.valueOf(this.id);
            }
            return obj.equals(this.id);
        }
        return false;
    }
}

