/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismbirtbean;

import com.geolocsystems.prismbirtbean.SyntheseBilanInterventionDelegationBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SyntheseBilanInterventionBean {
    private Map<String, SyntheseBilanInterventionDelegationBean> bilanInterventionDelegation = new HashMap<String, SyntheseBilanInterventionDelegationBean>();
    private Map<String, Integer> pourcentageInterventionCentre = new HashMap<String, Integer>();
    private Map<String, Integer> pourcentageInterventionDelegation = new HashMap<String, Integer>();
    private Map<String, Integer> pourcentageTypeIntervention = new HashMap<String, Integer>();
    private Map<String, Integer> pourcentageDeclenchementIntervention = new HashMap<String, Integer>();
    private int totalInterventions = 0;
    private int totalTempsInterventionEnMinutes = 0;
    private String imageCarteBilan = null;

    public List<String> getDelegations() {
        return new ArrayList<String>(this.bilanInterventionDelegation.keySet());
    }

    public List<String> getDeclenchementsList() {
        ArrayList<String> retour = new ArrayList<String>();
        for (String delegation : this.bilanInterventionDelegation.keySet()) {
            for (String centre : this.bilanInterventionDelegation.get(delegation).getBilanInterventionCentre().keySet()) {
                for (String declenchement : this.bilanInterventionDelegation.get(delegation).getBilanInterventionCentre().get(centre).getDeclenchementIntervention().keySet()) {
                    if (retour.contains(declenchement)) continue;
                    retour.add(declenchement);
                }
            }
        }
        return retour;
    }

    public List<String> getTypesList() {
        ArrayList<String> retour = new ArrayList<String>();
        for (String delegation : this.bilanInterventionDelegation.keySet()) {
            for (String centre : this.bilanInterventionDelegation.get(delegation).getBilanInterventionCentre().keySet()) {
                for (String type : this.bilanInterventionDelegation.get(delegation).getBilanInterventionCentre().get(centre).getTypeIntervention().keySet()) {
                    if (retour.contains(type)) continue;
                    retour.add(type);
                }
            }
        }
        return retour;
    }

    public Map<String, SyntheseBilanInterventionDelegationBean> getBilanInterventionDelegation() {
        return this.bilanInterventionDelegation;
    }

    public void setBilanInterventionDelegation(Map<String, SyntheseBilanInterventionDelegationBean> bilanInterventionDelegation) {
        this.bilanInterventionDelegation = bilanInterventionDelegation;
    }

    public String getImageCarteBilan() {
        return this.imageCarteBilan;
    }

    public void setImageCarteBilan(String imageCarteBilan) {
        this.imageCarteBilan = imageCarteBilan;
    }

    public Map<String, Integer> getPourcentageInterventionCentre() {
        return this.pourcentageInterventionCentre;
    }

    public Map<String, Integer> getPourcentageInterventionDelegation() {
        return this.pourcentageInterventionDelegation;
    }

    public Map<String, Integer> getPourcentageDeclenchementIntervention() {
        return this.pourcentageDeclenchementIntervention;
    }

    public Map<String, Integer> getPourcentageTypeIntervention() {
        return this.pourcentageTypeIntervention;
    }

    public void calculPourcentage() {
        this.calculTotalIntervention();
        this.calculPourcentageInterventionCentre();
        this.calculPourcentageInterventionDelegation();
        this.calculPourcentageTypeIntervention();
        this.calculPourcentageDeclenchementIntervention();
        this.calculDureeTotaleIntervention();
    }

    public void calculDureeTotaleIntervention() {
        this.totalTempsInterventionEnMinutes = 0;
        for (String key : this.bilanInterventionDelegation.keySet()) {
            this.totalTempsInterventionEnMinutes += this.bilanInterventionDelegation.get(key).getDureeTotaleInterventionEnMinutes();
        }
    }

    public void calculTotalIntervention() {
        this.totalInterventions = 0;
        for (String key : this.bilanInterventionDelegation.keySet()) {
            this.totalInterventions += this.bilanInterventionDelegation.get(key).getNbInterventions();
        }
    }

    public int getNbIntervenantsTotal() {
        int retour = 0;
        for (SyntheseBilanInterventionDelegationBean delegationBean : this.bilanInterventionDelegation.values()) {
            retour += delegationBean.getNbIntervenantsTotal();
        }
        return retour;
    }

    public String toString() {
        return "SyntheseBilanInterventionBean [bilanInterventionDelegation=" + String.valueOf(this.bilanInterventionDelegation) + ", pourcentageInterventionCentre=" + String.valueOf(this.pourcentageInterventionCentre) + ", pourcentageInterventionDelegation=" + String.valueOf(this.pourcentageInterventionDelegation) + ", pourcentageTypeIntervention=" + String.valueOf(this.pourcentageTypeIntervention) + ", pourcentageDeclenchementIntervention=" + String.valueOf(this.pourcentageDeclenchementIntervention) + ", totalInterventions=" + this.totalInterventions + ", totalTempsInterventionEnMinutes=" + this.totalTempsInterventionEnMinutes + ", imageCarteBilan=" + this.imageCarteBilan + ", getNbIntervenantsTotal()=" + this.getNbIntervenantsTotal() + ", getMoyenneIntervenants()=" + this.getMoyenneIntervenants() + ", getTotalInterventions()=" + this.getTotalInterventions() + ", getNbIntervenenantsMoyen()=" + this.getNbIntervenenantsMoyen() + "]";
    }

    public int getMoyenneIntervenants() {
        return Math.round(this.getNbIntervenantsTotal() / this.totalInterventions);
    }

    public int getNbInterventionSemaine() {
        int retour = 0;
        for (SyntheseBilanInterventionDelegationBean delegationBean : this.bilanInterventionDelegation.values()) {
            retour += delegationBean.getNbInterventionSemaine();
        }
        return retour;
    }

    public int getNbInterventionWeekEnd() {
        int retour = 0;
        for (SyntheseBilanInterventionDelegationBean delegationBean : this.bilanInterventionDelegation.values()) {
            retour += delegationBean.getNbInterventionWeekEnd();
        }
        return retour;
    }

    public int getNbInterventionJoursFeries() {
        int retour = 0;
        for (SyntheseBilanInterventionDelegationBean delegationBean : this.bilanInterventionDelegation.values()) {
            retour += delegationBean.getNbInterventionJoursFeries();
        }
        return retour;
    }

    public void calculPourcentageInterventionCentre() {
        this.pourcentageInterventionCentre = new HashMap<String, Integer>();
        for (String keyDelegation : this.bilanInterventionDelegation.keySet()) {
            for (String keyCentre : this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().keySet()) {
                this.pourcentageInterventionCentre.put(keyDelegation + "_" + keyCentre, Math.round(this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getNbInterventions() * 10000 / this.totalInterventions));
            }
        }
    }

    public void calculPourcentageInterventionDelegation() {
        this.pourcentageInterventionDelegation = new HashMap<String, Integer>();
        for (String keyDelegation : this.bilanInterventionDelegation.keySet()) {
            this.pourcentageInterventionDelegation.put(keyDelegation, Math.round(this.bilanInterventionDelegation.get(keyDelegation).getNbInterventions() * 10000 / this.totalInterventions));
        }
    }

    public void calculPourcentageTypeIntervention() {
        this.pourcentageTypeIntervention = new HashMap<String, Integer>();
        for (String keyDelegation : this.bilanInterventionDelegation.keySet()) {
            for (String keyCentre : this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().keySet()) {
                for (String keyType : this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getTypeIntervention().keySet()) {
                    if (this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getTypeIntervention().get(keyType) == null) continue;
                    if (this.pourcentageTypeIntervention.get(keyType) != null) {
                        this.pourcentageTypeIntervention.put(keyType, this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getTypeIntervention().get(keyType) + this.pourcentageTypeIntervention.get(keyType));
                        continue;
                    }
                    this.pourcentageTypeIntervention.put(keyType, this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getTypeIntervention().get(keyType));
                }
            }
        }
        for (String keyType : this.getTypesList()) {
            this.pourcentageTypeIntervention.put(keyType, Math.round(this.pourcentageTypeIntervention.get(keyType) * 10000 / this.totalInterventions));
        }
    }

    public void calculPourcentageDeclenchementIntervention() {
        this.pourcentageDeclenchementIntervention = new HashMap<String, Integer>();
        for (String keyDelegation : this.bilanInterventionDelegation.keySet()) {
            for (String keyCentre : this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().keySet()) {
                for (String keyDeclenchement : this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getDeclenchementIntervention().keySet()) {
                    if (this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getDeclenchementIntervention().get(keyDeclenchement) == null) continue;
                    if (this.pourcentageDeclenchementIntervention.get(keyDeclenchement) != null) {
                        this.pourcentageDeclenchementIntervention.put(keyDeclenchement, this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getDeclenchementIntervention().get(keyDeclenchement) + this.pourcentageDeclenchementIntervention.get(keyDeclenchement));
                        continue;
                    }
                    this.pourcentageDeclenchementIntervention.put(keyDeclenchement, this.bilanInterventionDelegation.get(keyDelegation).getBilanInterventionCentre().get(keyCentre).getDeclenchementIntervention().get(keyDeclenchement));
                }
            }
        }
        for (String keyDeclenchement : this.getDeclenchementsList()) {
            this.pourcentageDeclenchementIntervention.put(keyDeclenchement, Math.round(this.pourcentageDeclenchementIntervention.get(keyDeclenchement) * 10000 / this.totalInterventions));
        }
    }

    public int getTotalInterventions() {
        return this.totalInterventions;
    }

    public int getDureeTotaleInterventionEnHeures() {
        return this.totalTempsInterventionEnMinutes / 60;
    }

    public String getDureeMoyenneInterventions() {
        int moyenneMinutes = this.totalTempsInterventionEnMinutes / this.totalInterventions;
        String retour = moyenneMinutes / 60 + ":";
        retour = moyenneMinutes % 60 < 10 ? retour + "0" + moyenneMinutes % 60 : retour + moyenneMinutes % 60;
        return retour;
    }

    public String getDureeTotaleInterventions() {
        int moyenneMinutes = this.totalTempsInterventionEnMinutes;
        String retour = moyenneMinutes / 60 + "H";
        retour = moyenneMinutes % 60 < 10 ? retour + "0" + moyenneMinutes % 60 : retour + moyenneMinutes % 60;
        return retour;
    }

    public float getNbIntervenenantsMoyen() {
        float retour = 0.0f;
        if (this.getTotalInterventions() != 0) {
            retour = Math.round(this.getNbIntervenantsTotal() * 10 / this.getTotalInterventions());
            retour /= 10.0f;
        }
        return retour;
    }
}

