/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.service.saleuse.parseur;

import com.geolocsystems.prismandroid.model.DonneesSaleuse;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ISaleuseParser;

class ThermosondeKmsimeImpl
implements ISaleuseParser {
    private static final String CODE_DONNEE_ERREUR = "ffff";

    ThermosondeKmsimeImpl() {
    }

    @Override
    public DonneesSaleuse parse(Object ligne) {
        if (ligne != null && ligne instanceof String) {
            String line = (String)ligne;
            if (!line.startsWith("$T")) {
                return null;
            }
            String[] parts = line.split(";|\\*");
            if (parts.length < 5) {
                return null;
            }
            DonneesSaleuse d = new DonneesSaleuse();
            d.init();
            try {
                int tempSol = this.getInt(parts[1]);
                d.setTemperatureSol(this.round((float)tempSol / 10.0f - 100.0f));
                int tempAir = this.getInt(parts[2]);
                d.setTemperatureAir(this.round((float)tempAir / 10.0f - 100.0f));
                int humAir = this.getInt(parts[3]);
                d.setTauxHumidite(this.round((float)humAir / 10.0f - 100.0f));
                int ptRose = this.getInt(parts[4]);
                d.setTemperaturePointRose(this.round((float)ptRose / 10.0f - 100.0f));
            }
            catch (Exception e) {
                e.printStackTrace();
                d.init();
            }
            return d;
        }
        return null;
    }

    private boolean estEnErreur(String donnee) {
        return donnee != null && donnee.compareToIgnoreCase(CODE_DONNEE_ERREUR) == 0;
    }

    private int getInt(String donnee) throws Exception {
        if (!this.estEnErreur(donnee)) {
            return Integer.parseInt(donnee, 16);
        }
        throw new Exception();
    }

    private float round(float v) {
        double p = Math.pow(10.0, 1.0);
        return (float)((double)Math.round((double)v * p) / p);
    }
}

