/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.service.saleuse.parseur;

import com.geolocsystems.prismandroid.model.DonneesSaleuse;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ISaleuseParser;

class SaleuseKupperWeisserImpl
implements ISaleuseParser {
    public static int DEBUT_TRAME = 1;
    public static int LARGEUR_DEBIT_SEL = 7;
    public static int LARGEUR_DEBIT_SAUMURE = 7;
    public static int LARGEUR_DEBIT_SEL_DOUBLE_TREMIE = 7;
    public static int LARGEUR_LARGEUR_TRAVAIL = 7;
    public static int LARGEUR_VITESSE_CAMION = 7;
    public static int LARGEUR_KM_PARCOURU = 7;
    public static int LARGEUR_KM_SALE = 7;
    public static int LARGEUR_TEMPERATURE_AIR = 6;
    public static int DEBUT_DEBIT_SAUMURE = 8;
    public static int DEBUT_DEBIT_SEL_DOUBLE_TREMIE = 15;
    public static int DEBUT_LARGEUR_TRAVAIL = 22;
    public static int DEBUT_VITESSE_CAMION = 28;
    public static int DEBUT_KM_PARCOURU = 35;
    public static int DEBUT_KM_SALE = 42;
    public static int DEBUT_TEMPERATURE_AIR = 49;

    SaleuseKupperWeisserImpl() {
    }

    @Override
    public DonneesSaleuse parse(Object val) {
        DonneesSaleuse donneesSaleuse = new DonneesSaleuse();
        String ligne = String.valueOf(val);
        try {
            donneesSaleuse.setDebitSel(Integer.parseInt(this.recupererValeur(ligne, DEBUT_TRAME, DEBUT_DEBIT_SAUMURE, "0")));
            donneesSaleuse.setDebitSaumure(Integer.parseInt(this.recupererValeur(ligne, DEBUT_DEBIT_SAUMURE, DEBUT_DEBIT_SEL_DOUBLE_TREMIE, "0")));
            donneesSaleuse.setDebitSelDoubleTremie(Integer.parseInt(this.recupererValeur(ligne, DEBUT_DEBIT_SEL_DOUBLE_TREMIE, DEBUT_LARGEUR_TRAVAIL, "0")));
            donneesSaleuse.setLargeurTravail(Float.parseFloat(this.recupererValeur(ligne, DEBUT_LARGEUR_TRAVAIL, DEBUT_VITESSE_CAMION, "0")));
            donneesSaleuse.setVitesseCamion(Integer.parseInt(this.recupererValeur(ligne, DEBUT_VITESSE_CAMION, DEBUT_KM_PARCOURU, "0")));
            donneesSaleuse.setKmParcouru(Float.parseFloat(this.recupererValeur(ligne, DEBUT_KM_PARCOURU, DEBUT_KM_SALE, "0")));
            donneesSaleuse.setKmSale(Float.parseFloat(this.recupererValeur(ligne, DEBUT_KM_SALE, DEBUT_TEMPERATURE_AIR, "0")));
            donneesSaleuse.setTemperatureAir(Float.parseFloat(this.recupererValeur(ligne, DEBUT_TEMPERATURE_AIR, DEBUT_TEMPERATURE_AIR + LARGEUR_TEMPERATURE_AIR, "-1000")));
            donneesSaleuse.setTemperatureSol(-1000.0f);
            donneesSaleuse.setTauxHumidite(-1000.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return donneesSaleuse;
    }

    private String recupererValeur(String readLine, int i, int j, String defaut) {
        String retour = "";
        try {
            retour = readLine.substring(i, j).replace(" ", "");
        }
        catch (Exception e) {
            throw new RuntimeException("error substring saleuse line", e);
        }
        if (retour.length() > 0) {
            return retour;
        }
        return defaut;
    }
}

