/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.service.saleuse.parseur;

import com.geolocsystems.prismandroid.model.DonneesSaleuse;
import com.geolocsystems.prismandroid.service.saleuse.parseur.ISaleuseParser;

class SaleuseKmtechImpl
implements ISaleuseParser {
    SaleuseKmtechImpl() {
    }

    @Override
    public DonneesSaleuse parse(Object ligne) {
        if (ligne != null && ligne instanceof String) {
            String line = (String)ligne;
            if (!line.startsWith("$ASALV2")) {
                return null;
            }
            String[] parts = line.split(";|\\*");
            if (parts.length < 7) {
                return null;
            }
            DonneesSaleuse d = new DonneesSaleuse();
            d.init();
            float debitSel = this.lireValeur(parts, 1);
            d.setDebitSel(Math.round(debitSel));
            d.setLargeurTravail(this.lireValeur(parts, 2));
            d.setDebitSaumure(Math.round(this.lireValeur(parts, 3)));
            int embSal = Integer.parseInt(parts[4]);
            if (embSal != 0 && embSal != 1) {
                return null;
            }
            d.setEmbrayageSaleuse(embSal);
            int embSam = Integer.parseInt(parts[5]);
            if (embSam != 0 && embSam != 1) {
                return null;
            }
            d.setEmbrayageSaumure(embSam);
            d.affiche();
            return d;
        }
        return null;
    }

    private float lireValeur(String[] parts, int index) {
        return (float)Integer.parseInt(parts[index], 16) / 10.0f;
    }
}

