/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs.restrictions;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionDefinition;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;

public class RestrictionEtatEvenement
extends RestrictionAbstrait {
    public static final String CHAMP_AFFICHAGE = "affichage";
    public static final String ETAT_CREATION = "cr\u00e9ation";
    public static final String ETAT_MODIFICATION = "modification";
    public static final String ETAT_FIN = "cloture";
    public static final String ETAT_PROGRAMMATION = "programmation";
    private static final long serialVersionUID = -3241349570938379277L;
    private String[] valeur;
    private boolean affichage;

    public RestrictionEtatEvenement(RestrictionDefinition resdef) {
        super(resdef);
        this.initialisationAffichage(resdef);
    }

    @Override
    protected void initialisationAffichage(RestrictionDefinition resdef) {
        this.affichage = MetierCommun.getBoolean((String)resdef.get(CHAMP_AFFICHAGE), false);
    }

    public boolean peutAfficherChamp() {
        return this.affichage;
    }

    private String getEtatEvenement(Evenement e) {
        String etat = "";
        if (e != null) {
            etat = e.isTermine() ? ETAT_FIN : (e.getNumVersion() <= 1 ? ETAT_CREATION : (e.isProgramme() ? ETAT_PROGRAMMATION : ETAT_MODIFICATION));
        }
        return etat;
    }

    public boolean accept(Evenement e) {
        String etat = this.getEtatEvenement(e);
        if (this.equal) {
            return MetierCommun.getIndiceObjetListe(this.valeur, (Object)etat) > -1;
        }
        return MetierCommun.getIndiceObjetListe(this.valeur, (Object)etat) == -1;
    }

    @Override
    public boolean accept(ValeurChamp valeurChamp) {
        return false;
    }

    @Override
    public void initialisationValeur(String valeur) {
        this.valeur = valeur.split(",");
    }

    @Override
    public String toString() {
        String ret = "profil" + (this.isEqual() ? "=" : "\u2260");
        StringBuffer buff = new StringBuffer();
        String[] stringArray = this.valeur;
        int n = this.valeur.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (buff.length() > 0) {
                buff.append(",");
            }
            buff.append(val);
            ++n2;
        }
        return ret + String.valueOf(buff);
    }
}

