/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampPatrouilleProcedure;
import java.util.ArrayList;
import java.util.List;

public class ChampPatrouilleProcedure
extends ChampAbstrait
implements ConstantesPrismCommun {
    private static final long serialVersionUID = 1038270930507953418L;
    private ValeurChampPatrouilleProcedure valeur;
    private String competenceCg;
    private List<String> competences;
    private List<String> mesuresImmediate;
    private List<String> mesureDifferee;

    public ChampPatrouilleProcedure(String nom) {
        super(nom);
        this.valeur = new ValeurChampPatrouilleProcedure(nom);
    }

    @Override
    public Object getView(IComposantFactory factory) {
        return factory.createView(this);
    }

    @Override
    public ValeurChamp getValeurChamp() {
        return this.valeur;
    }

    @Override
    public void setValeurChamp(ValeurChamp valeur) {
        this.valeur = (ValeurChampPatrouilleProcedure)valeur;
    }

    @Override
    public List<String[]> valueOf(ValeurChamp valeur) {
        ValeurChampPatrouilleProcedure v = (ValeurChampPatrouilleProcedure)valeur;
        ArrayList<String[]> value = new ArrayList<String[]>();
        ArrayList<String> s = new ArrayList<String>();
        if (v.getCompetence() != null) {
            s.add(ChampPatrouilleProcedure.valueOfString("pp-competence", v.getCompetence()));
        }
        if (v.getMesure() != null) {
            s.add(ChampPatrouilleProcedure.valueOfString("pp-mesure", v.getMesure()));
        }
        s.add(ChampPatrouilleProcedure.valueOfString("pp-urgence", Boolean.toString(v.isUrgence())));
        s.add(ChampPatrouilleProcedure.valueOfString("pp-immediate", Boolean.toString(v.getImmediate())));
        s.add(ChampPatrouilleProcedure.valueOfString("pp-compteRendu", Boolean.toString(v.getCompteRendu())));
        value.add(ChampPatrouilleProcedure.valueOf(this.nom, MetierCommun.getString(s, ":")));
        return value;
    }

    public ValeurChampPatrouilleProcedure getValeur() {
        return this.valeur;
    }

    public void setValeur(ValeurChampPatrouilleProcedure valeur) {
        this.valeur = valeur;
    }

    public List<String> getCompetences() {
        return this.competences;
    }

    public void setCompetences(List<String> competences) {
        this.competences = competences;
    }

    public List<String> getMesuresImmediate() {
        return this.mesuresImmediate;
    }

    public void setMesuresImmediate(List<String> mesuresImmediate) {
        this.mesuresImmediate = mesuresImmediate;
    }

    public List<String> getMesureDifferee() {
        return this.mesureDifferee;
    }

    public void setMesureDifferee(List<String> mesureDifferee) {
        this.mesureDifferee = mesureDifferee;
    }

    public String getCompetenceCg() {
        return this.competenceCg;
    }

    public void setCompetenceCg(String competenceCg) {
        this.competenceCg = competenceCg;
    }

    @Override
    public ValeurChamp parseValeur(String valeur) {
        ValeurChampPatrouilleProcedure valeurChamp = new ValeurChampPatrouilleProcedure(this.nom);
        MapDescription description = MapDescription.parse(valeur);
        valeurChamp.setCompetence(description.getString("pp-competence", this.getCompetenceCg()));
        valeurChamp.setUrgence(description.getBoolean("pp-urgence", false));
        valeurChamp.setImmediate(description.getBoolean("pp-immediate", false));
        valeurChamp.setCompteRendu(description.getBoolean("pp-compteRendu", false));
        valeurChamp.setMesure(description.getString("pp-mesure", ""));
        return valeurChamp;
    }
}

