/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model.evenements.champs;

import com.geolocsystems.prismandroid.model.evenements.champs.ChampAbstrait;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDecimal;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class ChampDecimal
extends ChampAbstrait {
    private static final long serialVersionUID = 692630123514755339L;
    private ValeurChampDecimal valeur;
    private double valeurMin;
    private double valeurMax;
    private double pas;
    private boolean checkbox;
    private int nbDecimal = 1;

    public ChampDecimal(String nom, double valeurMin, double valeurMax, boolean checkbox) {
        super(nom);
        this.valeur = new ValeurChampDecimal(nom);
        this.valeur.setValeur(valeurMin);
        this.valeurMin = valeurMin;
        this.valeurMax = valeurMax;
        this.checkbox = checkbox;
    }

    public ChampDecimal(String nom) {
        super(nom);
        this.valeur = new ValeurChampDecimal(nom);
        this.valeurMin = 0.0;
        this.valeurMax = 50.0;
        this.pas = 1.0;
    }

    public double getValeur() {
        if (this.valeur.isChecked()) {
            return this.valeur.getValeur();
        }
        return this.valeurMin;
    }

    public void setValeur(double valeur) {
        this.valeur.setValeur(valeur);
    }

    public boolean isChecked() {
        return this.valeur.isChecked();
    }

    public void setChecked(boolean checked) {
        this.valeur.setChecked(checked);
    }

    @Override
    public Object getView(IComposantFactory factory) {
        return factory.createView(this);
    }

    @Override
    public ValeurChamp getValeurChamp() {
        return this.valeur;
    }

    @Override
    public void setValeurChamp(ValeurChamp valeur) {
        this.valeur = (ValeurChampDecimal)valeur;
    }

    @Override
    public List<String[]> valueOf(ValeurChamp valeur) {
        ArrayList<String[]> value = new ArrayList<String[]>();
        if (((ValeurChampDecimal)valeur).isChecked()) {
            value.add(ChampDecimal.valueOf(this.nom, String.valueOf(((ValeurChampDecimal)valeur).getValeur())));
        }
        return value;
    }

    public double getValeurMin() {
        return this.valeurMin;
    }

    public void setValeurMin(double valeurMin) {
        this.valeurMin = valeurMin;
    }

    public double getValeurMax() {
        return this.valeurMax;
    }

    public void setValeurMax(double valeurMax) {
        this.valeurMax = valeurMax;
    }

    public boolean isCheckbox() {
        return this.checkbox;
    }

    public void setCheckbox(boolean checkbox) {
        this.checkbox = checkbox;
    }

    @Override
    public ValeurChamp parseValeur(String valeur) {
        ValeurChampDecimal valeurChamp = new ValeurChampDecimal(this.nom);
        try {
            valeurChamp.setValeur(Double.parseDouble(valeur));
            valeurChamp.setChecked(true);
        }
        catch (NumberFormatException e) {
            valeurChamp.setValeur(this.getValeurMin());
            valeurChamp.setChecked(false);
        }
        return valeurChamp;
    }

    public double getPas() {
        return this.pas;
    }

    public void setPas(double pas) {
        this.pas = pas;
        try {
            int scale = BigDecimal.valueOf(pas).scale();
            if (scale > 0) {
                this.nbDecimal = scale;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNbDecimal() {
        return this.nbDecimal;
    }
}

