/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.service.evenement.EvenementAvecDistance;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class Visite {
    public static DateFormat formatDateJour = new SimpleDateFormat("dd/MM/yyyy");
    private long date;
    private String prefixe;
    private String jour;
    private String libelle;

    public String getJour() {
        return this.jour;
    }

    public Visite() {
        this.date = -1L;
        this.jour = "*";
        this.libelle = "";
    }

    public boolean equals(Object obj) {
        if (obj != null && this.jour != null) {
            if (obj instanceof Visite) {
                return this.jour.equals(((Visite)obj).getJour());
            }
            return this.jour.equals(obj);
        }
        return false;
    }

    public Visite(long date, String prefixe) {
        this.date = date;
        this.prefixe = prefixe;
        if (date > 0L) {
            this.init(date);
            this.libelle = prefixe.concat(" ").concat(this.jour);
        } else {
            this.jour = "";
            this.libelle = "";
        }
    }

    public boolean accept(EvenementAvecDistance e) {
        return this.accept(e.e);
    }

    public boolean accept(Evenement e) {
        return this.jour.equals("*") || this.jour.equals(Visite.getJour(e.getDateCreation()));
    }

    public static String getJour(long date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(date);
        return formatDateJour.format(date);
    }

    public void init(long date) {
        this.jour = Visite.getJour(date);
    }

    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    public String getLibelle() {
        return this.libelle;
    }

    public void setLibelle(String libelle) {
        this.libelle = libelle;
    }

    public String toString() {
        return this.libelle;
    }
}

