/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid.model;

import com.geolocsystems.prismandroid.model.PrismAction;

public class PrismActionOnChange {
    private String typeAction;
    private String valeurDeclencheur;
    private String champDeclenchement;
    private String typeDeclenchement;
    private String valeurDeclenchement;
    private String parametreAction;

    public static PrismActionOnChange parse(PrismAction action) {
        PrismActionOnChange actionOnChange = new PrismActionOnChange();
        actionOnChange.typeAction = action.getAction();
        actionOnChange.champDeclenchement = action.getDeclenchement();
        actionOnChange.valeurDeclencheur = action.getParametreDeclencheur();
        actionOnChange.valeurDeclenchement = action.getParametreDeclenchement();
        actionOnChange.typeDeclenchement = action.getTypeDeclenchement();
        actionOnChange.parametreAction = action.getParametres();
        return actionOnChange;
    }

    public boolean estAjout() {
        return this.typeAction.equals("ajouter");
    }

    public boolean estHeure() {
        return this.typeDeclenchement.equals("heure");
    }

    public boolean estJour() {
        return this.typeDeclenchement.equals("jour");
    }

    public boolean estMois() {
        return this.typeDeclenchement.equals("mois");
    }

    public boolean estDateBaseInp() {
        return this.parametreAction.equals("inp");
    }

    public boolean estDateBaseSta() {
        return this.parametreAction.equals("sta");
    }

    public int getValeur() {
        try {
            return Integer.parseInt(this.valeurDeclenchement);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public String getValeurDeclencheur() {
        return this.valeurDeclencheur;
    }

    public String getChampDeclenchement() {
        return this.champDeclenchement;
    }
}

