/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.Activite;
import com.geolocsystems.prismandroid.model.ActiviteEntretien;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Commentaire;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.IUtilisateur;
import com.geolocsystems.prismandroid.model.MainCourante;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.PrismAction;
import com.geolocsystems.prismandroid.model.TypeUtilisateur;
import com.geolocsystems.prismandroid.model.Utilisateur;
import com.geolocsystems.prismandroid.model.ValeurSens;
import com.geolocsystems.prismandroid.model.Vehicule;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.Restriction;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionEtatEvenement;
import com.geolocsystems.prismandroid.model.evenements.champs.restrictions.RestrictionProfil;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChamp;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampCollectionChoixUnique;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDate;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDateHeure;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampHeure;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampVehiculeEnCause;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampVraiFaux;
import com.geolocsystems.prismandroid.model.tunnel.LocalisationTunnel;
import com.geolocsystems.prismandroid.model.tunnel.PointParticulier;
import com.geolocsystems.prismandroid.model.tunnel.Tube;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.geolocsystems.prismcentral.beans.BarreauVH;
import com.geolocsystems.prismcentral.beans.Extension;
import com.geolocsystems.prismcentral.beans.Profil;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentralvaadin.config.ConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MetierCommun
implements ConstantesPrismCommun {
    private static MetierCommun instance;
    private static final String SALT = "djazduieivbyyeljuffddsf";
    public static DateFormat formatDate;
    public static DateFormat formatHeure;
    public static DateFormat formatHeureComplete;
    public static DateFormat formatDateJour;
    public static final int[] LISTE_CARACTERES_NUMERIQUES;
    public Map<Integer, Integer> actionsMM = new HashMap<Integer, Integer>(30);
    public static Map<String, Integer> corresSens;

    static {
        formatDate = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        formatHeure = new SimpleDateFormat("HH:mm");
        formatHeureComplete = new SimpleDateFormat("HH:mm:ss");
        formatDateJour = new SimpleDateFormat("dd/MM/yyyy");
        LISTE_CARACTERES_NUMERIQUES = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
        corresSens = new HashMap<String, Integer>(4);
    }

    private MetierCommun() {
        this.initActionsMM();
        this.initCorresSens();
    }

    private void initCorresSens() {
        corresSens.put("Ind\u00e9fini", -1);
        corresSens.put("Positif", 1);
        corresSens.put("N\u00e9gatif", 0);
        corresSens.put("Double sens", 2);
    }

    private void initActionsMM() {
        this.actionsMM.put(0, 34);
        this.actionsMM.put(5, 36);
        this.actionsMM.put(7, 38);
        this.actionsMM.put(3, 41);
        this.actionsMM.put(1, 46);
        this.actionsMM.put(2, 48);
        this.actionsMM.put(999, 47);
        this.actionsMM.put(4, 445);
        this.actionsMM.put(6, 37);
        this.actionsMM.put(10, 401);
        this.actionsMM.put(102, 1003);
        this.actionsMM.put(101, 1006);
        this.actionsMM.put(100, 1005);
        this.actionsMM.put(1000, 2000);
        this.actionsMM.put(8, 7800);
        this.actionsMM.put(9, 901);
    }

    public static MetierCommun instanceOf() {
        if (instance == null) {
            instance = new MetierCommun();
        }
        return instance;
    }

    public Champ getChamp(List<Champ> champs, String nomChamp) throws Exception {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = champs == null || champs.size() == 0;
        while (!trouve && !fin) {
            if (champs.get(++i).equals(nomChamp)) {
                trouve = true;
            }
            boolean bl = fin = i == champs.size() - 1;
        }
        if (trouve) {
            return champs.get(i);
        }
        throw new Exception("ERREUR LE CHAMP " + nomChamp + " N'A PAS ETE TROUVE");
    }

    public static boolean estPatrouillage(Evenement e, List<NatureOuRaccourci> natures) {
        NatureOuRaccourci n;
        int indice = MetierCommun.getIndiceObjetListe(natures, (Object)e.getValeurNature().getCode());
        return indice > -1 && (n = natures.get(indice)).getCodeMM() == 0;
    }

    public static boolean estPatrimoine(Evenement e, List<NatureOuRaccourci> natures) {
        return MetierCommun.estModuleMetier(e, natures, 7);
    }

    public static boolean estEntretien(Evenement e, List<NatureOuRaccourci> natures) {
        return MetierCommun.estModuleMetier(e, natures, 2);
    }

    public static boolean estModuleMetier(Evenement e, List<NatureOuRaccourci> natures, int codeMm) {
        NatureOuRaccourci n;
        int indice = MetierCommun.getIndiceObjetListe(natures, (Object)e.getValeurNature().getCode());
        return indice > -1 && (n = natures.get(indice)).getCodeMM() == codeMm;
    }

    public static boolean estIntervention(Evenement e, List<NatureOuRaccourci> natures) {
        NatureOuRaccourci n;
        int indice = MetierCommun.getIndiceObjetListe(natures, (Object)e.getValeurNature().getCode());
        return indice > -1 && (n = natures.get(indice)).getCodeMM() == 5;
    }

    public static boolean estVide(String valeur) {
        return valeur == null || valeur.trim().equals("");
    }

    public static boolean estVide(List<?> valeur) {
        return valeur == null || valeur.size() <= 0;
    }

    public static boolean aPlusDunElement(List<?> valeur) {
        return valeur != null && valeur.size() > 1;
    }

    public static boolean estTypeDefautPrism(TypeUtilisateur t) {
        return MetierCommun.estTypeDefautPrism(t.getCode());
    }

    public static boolean estTypeDefautPrism(int code) {
        return code == 0 || code == 1;
    }

    public static boolean aPlusieursTypeUtilisateur(List<TypeUtilisateur> types) {
        if (!MetierCommun.estVide(types)) {
            for (TypeUtilisateur t : types) {
                if (MetierCommun.estTypeDefautPrism(t)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean aTypeUtilisateurAxione(List<TypeUtilisateur> types) {
        return MetierCommun.aTypeUtilisateur(types, 4);
    }

    public static boolean aTypeUtilisateurUsagers(List<TypeUtilisateur> types) {
        return MetierCommun.aTypeUtilisateur(types, 2);
    }

    public static boolean aTypeUtilisateur(List<TypeUtilisateur> types, int type) {
        if (!MetierCommun.estVide(types)) {
            for (TypeUtilisateur t : types) {
                if (t.getCode() != type) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Vehicule> getVehicules(List<Vehicule> vehicules, IUtilisateur u) {
        return MetierCommun.getVehicules(vehicules, u.getDelegation(), u.getCentre());
    }

    public static PointParticulier getPointParticulier(int id, List<Tunnel> tunnels) {
        for (Tunnel tunnel : tunnels) {
            for (Tube tube : tunnel.getTubes()) {
                for (PointParticulier pp : tube.getPp()) {
                    if (pp.getId() != id) continue;
                    return pp;
                }
            }
        }
        return null;
    }

    public static LocalisationTunnel getLocalisationTunnel(int id, List<Tunnel> tunnels) {
        LocalisationTunnel lt = new LocalisationTunnel();
        for (Tunnel tunnel : tunnels) {
            if (tunnel.getTubes() == null) continue;
            for (Tube tube : tunnel.getTubes()) {
                if (tube.getPp() == null) continue;
                for (PointParticulier pp : tube.getPp()) {
                    if (pp.getId() != id) continue;
                    lt.setPoint(pp);
                    lt.setTube(tube);
                    lt.setTunnel(tunnel);
                    return lt;
                }
            }
        }
        return lt;
    }

    public static Tube getTube(int id, List<Tunnel> tunnels) {
        for (Tunnel tunnel : tunnels) {
            for (Tube tube : tunnel.getTubes()) {
                if (tube.getId() != id) continue;
                return tube;
            }
        }
        return null;
    }

    public static Tunnel getTunnel(int id, List<Tunnel> tunnels) {
        for (Tunnel tunnel : tunnels) {
            if (tunnel.getId() != id) continue;
            return tunnel;
        }
        return null;
    }

    public static List<Vehicule> getVehicules(List<Vehicule> vehicules, String delegation, String centre) {
        List<Vehicule> liste;
        block5: {
            block4: {
                liste = new ArrayList<Vehicule>();
                if (!MetierCommun.estVide(delegation) || !MetierCommun.estVide(centre)) break block4;
                liste = vehicules;
                break block5;
            }
            if (MetierCommun.estVide(delegation)) break block5;
            if (!MetierCommun.estVide(centre)) {
                for (Vehicule v : vehicules) {
                    if (MetierCommun.estVide(v.getDelegation()) || !v.getDelegation().equals(delegation) || MetierCommun.estVide(v.getCentre()) || !v.getCentre().equals(centre)) continue;
                    liste.add(v);
                }
            } else {
                for (Vehicule v : vehicules) {
                    if (MetierCommun.estVide(v.getDelegation()) || !v.getDelegation().equals(delegation)) continue;
                    liste.add(v);
                }
            }
        }
        return liste;
    }

    public static List<Circuit> getCircuits(List<Circuit> circuits, IUtilisateur u) {
        return MetierCommun.getCircuits(circuits, u.getDelegation(), u.getCentre());
    }

    public static List<Circuit> getCircuits(List<Circuit> circuits, String delegation, String centre) {
        List<Circuit> liste;
        block5: {
            block4: {
                liste = new ArrayList<Circuit>();
                if (!MetierCommun.estVide(delegation) || !MetierCommun.estVide(centre)) break block4;
                liste = circuits;
                break block5;
            }
            if (MetierCommun.estVide(delegation)) break block5;
            if (!MetierCommun.estVide(centre)) {
                for (Circuit v : circuits) {
                    if (MetierCommun.estVide(v.getDelegation()) || !v.getDelegation().equals(delegation) || MetierCommun.estVide(v.getCentre()) || !v.getCentre().equals(centre)) continue;
                    liste.add(v);
                }
            } else {
                for (Circuit v : circuits) {
                    if (MetierCommun.estVide(v.getDelegation()) || !v.getDelegation().equals(delegation)) continue;
                    liste.add(v);
                }
            }
        }
        return liste;
    }

    public boolean canDoMM(Profil p, ModuleMetier mm) {
        try {
            return MetierCommun.canDo(p, this.actionsMM.get(this.getCodeMM(mm)));
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getCodeMM(ModuleMetier mm) {
        if (mm.getModuleHerite() > -1) {
            return mm.getModuleHerite();
        }
        return mm.getCode();
    }

    public static List<PrismAction> getPrismActions(String type, String declencheur, Map<String, Map<String, List<PrismAction>>> listePrismActions) {
        if (listePrismActions != null && declencheur != null && listePrismActions.containsKey(type)) {
            return listePrismActions.get(type).get(declencheur);
        }
        return null;
    }

    public static List<PrismAction> getPrismActionsOnChange(String declencheur, String declenchement, Map<String, Map<String, List<PrismAction>>> listePrismActions) {
        List<PrismAction> actionsDeclencheur;
        List actionsDeclenchement = null;
        if (listePrismActions != null && declencheur != null && listePrismActions.containsKey("onChange") && !MetierCommun.estVide(actionsDeclencheur = listePrismActions.get("onChange").get(declencheur))) {
            for (PrismAction action : actionsDeclencheur) {
                if (action.getDeclenchement() == null || declenchement == null || action.getDeclenchement().compareToIgnoreCase(declenchement) != 0) continue;
                actionsDeclenchement.add(action);
            }
        }
        return actionsDeclenchement;
    }

    public static List<PrismAction> getPrismActionsOnChange(String declencheur, Map<String, Map<String, List<PrismAction>>> listePrismActions) {
        List<PrismAction> actionsDeclencheur = null;
        if (listePrismActions != null && declencheur != null && listePrismActions.containsKey("onChange")) {
            actionsDeclencheur = listePrismActions.get("onChange").get(declencheur);
        }
        return actionsDeclencheur;
    }

    public static boolean canDo(Profil p, int codeAction) {
        return p != null && p.getActions() != null && p.getActions().contains(codeAction);
    }

    public static RestrictionProfil getRestrictionProfil(Champ champ) {
        if (champ.getRestrictions() != null) {
            for (Restriction r : champ.getRestrictions()) {
                if (!(r instanceof RestrictionProfil)) continue;
                return (RestrictionProfil)r;
            }
        }
        return null;
    }

    public static boolean peutModifierChamp(Profil p, Champ c) {
        RestrictionProfil r = MetierCommun.getRestrictionProfil(c);
        if (r != null) {
            return r.accept(p);
        }
        return true;
    }

    public static boolean peutAfficherChamp(Profil p, Champ c) {
        RestrictionProfil r = MetierCommun.getRestrictionProfil(c);
        if (r != null && !r.accept(p)) {
            return r.peutAfficherChamp();
        }
        return true;
    }

    public static ValeurChamp getValeurChamp(Evenement evenement, String nomChamp) throws Exception {
        return MetierCommun.getValeurChamp(evenement.getValeurNature().getValeurs(), nomChamp);
    }

    public static ValeurChamp getValeurChamp(List<ValeurChamp> champs, String nomChamp) throws Exception {
        boolean trouve = false;
        boolean fin = false;
        ValeurChamp v = null;
        int i = -1;
        fin = champs == null || champs.size() == 0;
        while (!trouve && !fin) {
            if (champs.get(++i).equals(nomChamp)) {
                v = champs.get(i);
            } else if (champs.get(i) instanceof ValeurChampMultiple) {
                v = MetierCommun.getValeurChampRecursif(((ValeurChampMultiple)champs.get(i)).getValeurs(), nomChamp);
            }
            trouve = v != null;
            boolean bl = fin = i == champs.size() - 1;
        }
        if (trouve) {
            return v;
        }
        throw new Exception("ERREUR LE CHAMP " + nomChamp + " N'A PAS ETE TROUVE");
    }

    public static ValeurChamp getValeurChampRecursif(List<ValeurChamp> champs, String nomChamp) {
        boolean trouve = false;
        boolean fin = false;
        ValeurChamp v = null;
        int i = -1;
        fin = champs == null || champs.size() == 0;
        while (!trouve && !fin) {
            if (champs.get(++i).equals(nomChamp)) {
                v = champs.get(i);
            } else if (champs.get(i) instanceof ValeurChampMultiple) {
                v = MetierCommun.getValeurChampRecursif(((ValeurChampMultiple)champs.get(i)).getValeurs(), nomChamp);
            }
            trouve = v != null;
            boolean bl = fin = i == champs.size() - 1;
        }
        if (trouve) {
            return v;
        }
        return null;
    }

    public static boolean updateValeurChamp(List<ValeurChamp> champs, String nomChamp, ValeurChamp valeur) throws Exception {
        boolean trouve = false;
        boolean fin = false;
        ValeurChamp v = null;
        int i = -1;
        fin = champs == null || champs.size() == 0;
        while (!trouve && !fin) {
            if (champs.get(++i).equals(nomChamp)) {
                v = champs.get(i);
                champs.set(i, valeur);
                trouve = v != null;
            } else if (champs.get(i) instanceof ValeurChampMultiple) {
                trouve = MetierCommun.updateValeurChamp(((ValeurChampMultiple)champs.get(i)).getValeurs(), nomChamp, valeur);
            }
            boolean bl = fin = i == champs.size() - 1;
        }
        return trouve;
    }

    public static boolean updateValeurChamp(Evenement e, String nomChamp, ValeurChamp valeur) throws Exception {
        if (e != null && e.getValeurNature() != null) {
            return MetierCommun.updateValeurChamp(e.getValeurNature().getValeurs(), nomChamp, valeur);
        }
        return false;
    }

    public static Map<String, Champ> getChamps(Nature n) {
        return MetierCommun.getChamps(n.getChamps());
    }

    public static Map<String, Champ> getChampsNatures(Collection<Nature> natures) {
        LinkedHashMap<String, Champ> champs = new LinkedHashMap<String, Champ>();
        for (Nature n : natures) {
            champs.putAll(MetierCommun.getChamps(n));
        }
        return champs;
    }

    public static Map<String, Champ> getChamps(List<Champ> listeChamps) {
        LinkedHashMap<String, Champ> champs = new LinkedHashMap<String, Champ>();
        for (Champ c : listeChamps) {
            champs.put(c.getNom(), c);
            if (!(c instanceof ChampMultiple)) continue;
            ChampMultiple ch = (ChampMultiple)c;
            champs.putAll(MetierCommun.getChamps(ch.getChamps()));
        }
        return champs;
    }

    public static String getStylePublication(Evenement e, List<Restriction> m) {
        if (m != null) {
            for (Restriction r : m) {
                try {
                    ValeurChamp v = MetierCommun.getValeurChamp(e, r.getNomChamp());
                    if (!r.accept(v)) continue;
                    return r.getCode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public String hashPassword(String password) {
        byte[] uniqueKey;
        try {
            uniqueKey = (password + SALT).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("SHA-1").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("no MD5 support in this VM");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer hashString = new StringBuffer();
        int i = 0;
        while (i < hash.length) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
            } else {
                hashString.append(hex.substring(hex.length() - 2));
            }
            ++i;
        }
        return hashString.toString();
    }

    public List<String> getListeOnglets(Nature n) {
        ArrayList<String> onglets = new ArrayList<String>();
        for (Champ c : n.getChamps()) {
            if (onglets.contains(c.getOnglet())) continue;
            onglets.add(c.getOnglet());
        }
        return onglets;
    }

    public File zipEvenement(Evenement evt, String cheminTemporaire, String cheminPhotos, boolean compresser) throws IOException {
        File rep = new File(cheminTemporaire);
        File zipFile = File.createTempFile("evt", ".evenement", rep);
        FileOutputStream stream = new FileOutputStream(zipFile);
        BufferedOutputStream bstream = new BufferedOutputStream(stream, 32000);
        ZipOutputStream zip = new ZipOutputStream(bstream);
        if (compresser) {
            zip.setLevel(1);
        } else {
            zip.setLevel(0);
        }
        zip.setMethod(8);
        File[] photos = new File(cheminPhotos).listFiles();
        if (photos != null) {
            for (String nomPhoto : evt.getPhotos()) {
                String photo = cheminPhotos.concat(nomPhoto);
                if (!new File(photo).exists()) continue;
                ZipEntry entry = new ZipEntry(nomPhoto);
                zip.putNextEntry(entry);
                BufferedInputStream reader = new BufferedInputStream(new FileInputStream(photo), 32000);
                byte[] buffer = new byte[4096];
                int lu = reader.read(buffer, 0, 4096);
                while (lu != -1) {
                    zip.write(buffer, 0, lu);
                    lu = reader.read(buffer, 0, 4096);
                }
                reader.close();
                zip.closeEntry();
            }
        }
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(arrayOutputStream);
        objectOutputStream.writeObject(evt);
        objectOutputStream.flush();
        objectOutputStream.close();
        ZipEntry entryfichier = new ZipEntry("fichier");
        zip.putNextEntry(entryfichier);
        arrayOutputStream.writeTo(zip);
        zip.closeEntry();
        zip.finish();
        zip.close();
        return zipFile;
    }

    public File zipEvenementPhotoDatabase(Evenement evt, String cheminTemporaire, IBusinessService business, boolean compresser) throws IOException {
        File rep = new File(cheminTemporaire);
        File zipFile = File.createTempFile("evt", ".evenement", rep);
        FileOutputStream stream = new FileOutputStream(zipFile);
        BufferedOutputStream bstream = new BufferedOutputStream(stream, 32000);
        ZipOutputStream zip = new ZipOutputStream(bstream);
        if (compresser) {
            zip.setLevel(1);
        } else {
            zip.setLevel(0);
        }
        zip.setMethod(8);
        for (String nomPhoto : evt.getPhotos()) {
            byte[] imagedata = business.getPhoto(nomPhoto);
            if (imagedata == null) continue;
            ZipEntry entry = new ZipEntry(nomPhoto);
            zip.putNextEntry(entry);
            zip.write(imagedata, 0, imagedata.length);
            zip.closeEntry();
        }
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(arrayOutputStream);
        objectOutputStream.writeObject(evt);
        objectOutputStream.flush();
        objectOutputStream.close();
        ZipEntry entryfichier = new ZipEntry("fichier");
        zip.putNextEntry(entryfichier);
        arrayOutputStream.writeTo(zip);
        zip.closeEntry();
        zip.finish();
        zip.close();
        return zipFile;
    }

    public String genereIdentifiantUniqueMainCourante(IUtilisateur utilisateur) {
        return this.genereIdentifiantUnique("mci-" + this.getPrefixeUtilisateur(utilisateur.getCode()));
    }

    public String genereIdentifiantUniquePatrouille(Utilisateur utilisateur) {
        return this.genereIdentifiantUnique("pat-" + this.getPrefixeUtilisateur(utilisateur.getCode()));
    }

    public String genereIdentifiantUniquePosition(String codeUtilisateur) {
        return this.genereIdentifiantUnique("pos-" + this.getPrefixeUtilisateur(codeUtilisateur));
    }

    public String genereIdentifiantUnique(String prefixe, Utilisateur utilisateur) {
        return this.genereIdentifiantUnique(prefixe + "-" + utilisateur.getCode());
    }

    public String getPrefixeUtilisateur(String codeUtilisateur) {
        if (codeUtilisateur != null && !codeUtilisateur.isEmpty()) {
            return codeUtilisateur.substring(0, 1);
        }
        return "";
    }

    public String genereIdentifiantUnique(String prefixe) {
        Random r = new Random();
        return prefixe + "-" + System.currentTimeMillis() + "-" + r.nextInt(999);
    }

    public File zipFiles(List<File> fichiers, String dossierTemporaire) throws IOException {
        File rep = new File(dossierTemporaire);
        File zipFile = File.createTempFile("synchro", ".zip", rep);
        FileOutputStream stream = new FileOutputStream(zipFile);
        BufferedOutputStream bstream = new BufferedOutputStream(stream, 32000);
        ZipOutputStream zip = new ZipOutputStream(bstream);
        zip.setLevel(1);
        zip.setMethod(8);
        for (File fichier : fichiers) {
            ZipEntry entry = new ZipEntry(fichier.getName());
            zip.putNextEntry(entry);
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(fichier), 32000);
            byte[] buffer = new byte[4096];
            int lu = reader.read(buffer, 0, 4096);
            while (lu != -1) {
                zip.write(buffer, 0, lu);
                lu = reader.read(buffer, 0, 4096);
            }
            reader.close();
            zip.closeEntry();
        }
        zip.finish();
        zip.close();
        return zipFile;
    }

    public static String getLibelleUnique(Vehicule v) {
        if (v != null) {
            try {
                return v.getCode();
            }
            catch (Exception e) {
                return v.getDescription();
            }
        }
        return "";
    }

    public static String getLibelleUnique(Utilisateur u) {
        if (u != null) {
            try {
                String libelleSna = "(".concat(u.getCode()).concat(")");
                if (u.getNom().endsWith(libelleSna)) {
                    return u.getNom();
                }
                return u.getNom().concat(" ").concat(libelleSna);
            }
            catch (Exception e) {
                return u.getNom();
            }
        }
        return "";
    }

    public static String getCodeUtilisateurFromLibelle(String libelle) {
        String code = "";
        if (libelle != null) {
            try {
                return libelle.substring(libelle.lastIndexOf("(") + 1, libelle.lastIndexOf(")"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return code;
    }

    public static String getString(List<?> liste, String separateur) {
        Object valeur = "";
        if (liste != null && liste.size() > 0) {
            int i = 0;
            while (i < liste.size() - 1) {
                valeur = (String)valeur + String.valueOf(liste.get(i)) + separateur;
                ++i;
            }
            valeur = (String)valeur + String.valueOf(liste.get(liste.size() - 1));
        }
        return valeur;
    }

    public static boolean estCoucheBretelle(String couche) {
        String[] couchesBretelles = new String[]{"bretelle", "sliproad", "sliproad2"};
        return MetierCommun.estDedans(couchesBretelles, (Object)couche);
    }

    public static boolean estNomRouteSIG(String axe) {
        return !MetierCommun.estVide(axe) && Character.isDigit(axe.charAt(0)) && axe.length() > 5;
    }

    public static String getLibelleUtilisateur(Utilisateur u) {
        String ret = u.getNom().trim();
        try {
            if (ret.length() > 15) {
                int i = ret.indexOf(" ");
                ret = i > -1 ? ret.substring(0, i + 1).concat(ret.substring(i + 1, i + 2)) : ret.substring(0, 15);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static String getLibelleVehicule(Vehicule v) {
        if (v.getCode().length() < 15) {
            return v.getCode();
        }
        if (!MetierCommun.estVide(v.getImmatriculation())) {
            return v.getImmatriculation();
        }
        if (v.getDescription() != null) {
            if (v.getDescription().length() < 15) {
                return v.getDescription();
            }
            return v.getDescription().substring(0, 15);
        }
        return "";
    }

    private static int getNbVehicule(String val) {
        int nbVehicule = 0;
        List<String> l = MetierCommun.getListe(val, " ");
        if (l.size() == 2) {
            nbVehicule = Integer.valueOf(l.get(1));
        }
        return nbVehicule;
    }

    public static String getValeurDate(ValeurChampHeure v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(11, v.getHeure());
            cal.set(12, v.getMinute());
            return formatHeure.format(cal.getTime());
        }
        return "";
    }

    public static long getValeurDateLong(ValeurChampHeure v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(11, v.getHeure());
            cal.set(12, v.getMinute());
            return cal.getTimeInMillis();
        }
        return -1L;
    }

    public static long getValeurDateLong(ValeurChamp v) {
        long ret = -1L;
        if (v != null) {
            if (v instanceof ValeurChampHeure) {
                ret = MetierCommun.getValeurDateLong((ValeurChampHeure)v);
            } else if (v instanceof ValeurChampDate) {
                ret = MetierCommun.getValeurDateLong((ValeurChampDate)v);
            } else if (v instanceof ValeurChampDateHeure) {
                ret = MetierCommun.getValeurDateLong((ValeurChampDateHeure)v);
            }
        }
        return ret;
    }

    public static String getValeurDate(ValeurChampDateHeure v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(1, v.getAnnee());
            cal.set(2, v.getMois());
            cal.set(5, v.getJour());
            cal.set(11, v.getHeure());
            cal.set(12, v.getMinute());
            return formatDate.format(cal.getTime());
        }
        return "";
    }

    public static long getValeurDateLong(ValeurChampDateHeure v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(1, v.getAnnee());
            cal.set(2, v.getMois());
            cal.set(5, v.getJour());
            cal.set(11, v.getHeure());
            cal.set(12, v.getMinute());
            return cal.getTimeInMillis();
        }
        return -1L;
    }

    public static Calendar getCalendrier(ValeurChampDateHeure v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(1, v.getAnnee());
            cal.set(2, v.getMois());
            cal.set(5, v.getJour());
            cal.set(11, v.getHeure());
            cal.set(12, v.getMinute());
            return cal;
        }
        return null;
    }

    public static boolean estDateRemplie(ValeurChamp v) {
        if (v != null) {
            if (v instanceof ValeurChampDate) {
                return MetierCommun.estDateRemplie((ValeurChampDate)v);
            }
            if (v instanceof ValeurChampDateHeure) {
                return MetierCommun.estDateRemplie((ValeurChampDateHeure)v);
            }
            if (v instanceof ValeurChampHeure) {
                return MetierCommun.estDateRemplie((ValeurChampHeure)v);
            }
        }
        throw new RuntimeException("ERREUR VALEUR DATE");
    }

    public static boolean estDateRemplie(ValeurChampDate v) {
        return v.getAnnee() != -1 && v.getMois() != -1 && v.getJour() != -1;
    }

    public static boolean estDateRemplie(ValeurChampDateHeure v) {
        return v.getAnnee() != -1 && v.getMois() != -1 && v.getJour() != -1 && v.getHeure() != -1 && v.getMinute() != -1;
    }

    public static boolean estDateRemplie(ValeurChampHeure v) {
        return v.getHeure() != -1 && v.getMinute() != -1;
    }

    public static String getValeurDate(ValeurChampDate v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(1, v.getAnnee());
            cal.set(2, v.getMois());
            cal.set(5, v.getJour());
            return formatDateJour.format(cal.getTime());
        }
        return "";
    }

    public static long getValeurDateLong(ValeurChampDate v) {
        if (v.isChecked() && MetierCommun.estDateRemplie(v)) {
            Calendar cal = GregorianCalendar.getInstance();
            cal.set(1, v.getAnnee());
            cal.set(2, v.getMois());
            cal.set(5, v.getJour());
            return cal.getTimeInMillis();
        }
        return -1L;
    }

    public static boolean estNumerique(String s) {
        if (s != null) {
            char[] cArray = s.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (!Character.isDigit(c)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public static ValeurChampDateHeure getValeurChampDateHeure(Champ champ, String d) {
        Calendar cal = GregorianCalendar.getInstance();
        ValeurChampDateHeure v = new ValeurChampDateHeure(champ.getNom());
        if (d != null && !d.isEmpty()) {
            if (!MetierCommun.estNumerique(d)) {
                try {
                    cal.setTime(formatDate.parse(d));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                cal.setTimeInMillis(Long.parseLong(d));
            }
            v.setAnnee(cal.get(1));
            v.setMois(cal.get(2));
            v.setJour(cal.get(5));
            v.setHeure(cal.get(11));
            v.setMinute(cal.get(12));
            v.setChecked(true);
        } else {
            v.setChecked(false);
        }
        return v;
    }

    public static ValeurChampHeure getValeurChampHeure(Champ champ, String d) {
        Calendar cal = GregorianCalendar.getInstance();
        ValeurChampHeure v = new ValeurChampHeure(champ.getNom());
        if (d != null && !d.isEmpty()) {
            if (!MetierCommun.estNumerique(d)) {
                try {
                    cal.setTime(formatHeure.parse(d));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                cal.setTimeInMillis(Long.parseLong(d));
            }
            v.setHeure(cal.get(11));
            v.setMinute(cal.get(12));
            v.setChecked(true);
        } else {
            v.setChecked(false);
        }
        return v;
    }

    public static ValeurChampDate getValeurChampDate(Champ champ, String d) {
        Calendar cal = GregorianCalendar.getInstance();
        ValeurChampDate v = new ValeurChampDate(champ.getNom());
        if (d != null && !d.isEmpty()) {
            if (!MetierCommun.estNumerique(d)) {
                try {
                    cal.setTime(formatDateJour.parse(d));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                cal.setTimeInMillis(Long.parseLong(d));
            }
            v.setAnnee(cal.get(1));
            v.setMois(cal.get(2));
            v.setJour(cal.get(5));
            v.setChecked(true);
        } else {
            v.setChecked(false);
        }
        return v;
    }

    public static ValeurChampVehiculeEnCause getVehiculesEnCause(Champ champ, String v) {
        String[] tV;
        ValeurChampVehiculeEnCause val = new ValeurChampVehiculeEnCause(champ.getNom());
        if (v != null && (tV = v.split(",")).length == 6) {
            val.setVl(MetierCommun.getNbVehicule(tV[0]));
            val.setPl(MetierCommun.getNbVehicule(tV[1]));
            val.setAutres(MetierCommun.getNbVehicule(tV[5]));
            val.setVelo(MetierCommun.getNbVehicule(tV[3]));
            val.setTmd(MetierCommun.getNbVehicule(tV[4]));
            val.setVtc(MetierCommun.getNbVehicule(tV[2]));
        }
        return val;
    }

    public static ModuleMetier getModuleMetier(List<ModuleMetier> liste, int code) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.size() == 0;
        while (!trouve && !fin) {
            if (liste.get(++i).getCode() == code) {
                trouve = true;
            }
            boolean bl = fin = i == liste.size() - 1;
        }
        if (trouve) {
            return liste.get(i);
        }
        return null;
    }

    public static List<NatureOuRaccourci> getNaturesMM(int mm, List<NatureOuRaccourci> nats) {
        ArrayList<NatureOuRaccourci> natsMM = new ArrayList<NatureOuRaccourci>();
        for (NatureOuRaccourci nat : nats) {
            if (nat.getCodeMM() != mm) continue;
            natsMM.add(nat);
        }
        return natsMM;
    }

    public static void copierChampsCommuns(ValeurNature source, Nature nouvelEvenement) {
        Map<String, Champ> champs = MetierCommun.getChamps(nouvelEvenement);
        for (ValeurChamp v : source.getValeurs()) {
            Champ c;
            if (v.getChamp().equals("description") || !champs.containsKey(v.getChamp()) || !(c = champs.get(v.getChamp())).getValeurChamp().getClass().getSimpleName().equals(v.getClass().getSimpleName())) continue;
            champs.get(v.getChamp()).setValeurChamp(v);
        }
    }

    public static ModuleMetier getModuleMetierIntervention(List<ModuleMetier> liste) {
        return MetierCommun.getModuleMetier(liste, 5);
    }

    public static ModuleMetier getModuleMetierPatrouillage(List<ModuleMetier> liste) {
        return MetierCommun.getModuleMetier(liste, 0);
    }

    public static ModuleMetier getModuleMetierVh(List<ModuleMetier> liste) {
        return MetierCommun.getModuleMetier(liste, 1);
    }

    public static ModuleMetier getModuleMetierAstreinte(List<ModuleMetier> liste) {
        return MetierCommun.getModuleMetier(liste, 9);
    }

    public static ModuleMetier getModuleMetierEsh(List<ModuleMetier> liste) {
        return MetierCommun.getModuleMetier(liste, 1000);
    }

    public static List<String> getListe(Object[] liste) {
        ArrayList<String> l;
        if (liste != null && liste.length > 0) {
            l = new ArrayList(liste.length);
            int i = 0;
            while (i < liste.length) {
                l.add(liste[i].toString());
                ++i;
            }
        } else {
            l = new ArrayList<String>(0);
        }
        return l;
    }

    public static List<Integer> getListe(int[] liste) {
        ArrayList<Integer> l;
        if (liste != null && liste.length > 0) {
            l = new ArrayList(liste.length);
            int i = 0;
            while (i < liste.length) {
                l.add(liste[i]);
                ++i;
            }
        } else {
            l = new ArrayList<Integer>(0);
        }
        return l;
    }

    public static List<String> getListe(String liste) {
        return MetierCommun.getListe(liste, ";");
    }

    public static List<String> getListe(String liste, List<String> defaut) {
        return MetierCommun.getListe(liste, ";", defaut);
    }

    public static List<String> getListe(String liste, String separateur) {
        return MetierCommun.getListe(liste, separateur, new ArrayList<String>(0));
    }

    public static List<String> getListe(String liste, String separateur, List<String> defaut) {
        List<String> l;
        if (liste != null && !liste.equals("")) {
            String[] t = null;
            t = liste.split(separateur);
            l = new ArrayList<String>(t.length);
            int i = 0;
            while (i < t.length) {
                l.add(t[i]);
                ++i;
            }
            if (liste.lastIndexOf(separateur) == liste.length() - 1) {
                l.add("");
            }
        } else {
            l = defaut;
        }
        return l;
    }

    public static String getCheminPhotosEvenement(String cheminStockagePhotos, Evenement e) {
        return MetierCommun.getCheminPhotosEvenement(cheminStockagePhotos, e.getIdSituation(), e.getIdReference());
    }

    public static String getDossierPhotosEvenement(Evenement e) {
        return e.getIdSituation() + File.separatorChar + e.getIdReference() + File.separatorChar;
    }

    public static String getCheminPhotosEvenement(String cheminStockagePhotos, String idSituation, String idReference) {
        String cheminPhotos = cheminStockagePhotos + File.separatorChar + idSituation + File.separatorChar + idReference + File.separatorChar;
        return cheminPhotos;
    }

    public static void ecrirePhoto(byte[] bin, String dossier, String nom) throws Exception {
        File photo = new File(dossier + nom);
        FileOutputStream fostream = new FileOutputStream(photo);
        fostream.write(bin);
        fostream.flush();
        fostream.close();
    }

    public static boolean estDedans(String[] liste, Object valeur) {
        return MetierCommun.getIndiceObjetListe(liste, valeur) > -1;
    }

    public static boolean estDedans(List<?> liste, Object valeur) {
        return MetierCommun.getIndiceObjetListe(liste, valeur) > -1;
    }

    public static int getIndiceObjetListe(List<?> liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.size() == 0;
        while (!trouve && !fin) {
            if (liste.get(++i).equals(valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.size() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static Profil getProfil(List<Profil> liste, long id) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.size() == 0;
        while (!trouve && !fin) {
            if ((long)liste.get(++i).getId() == id) {
                trouve = true;
            }
            boolean bl = fin = i == liste.size() - 1;
        }
        if (trouve) {
            return liste.get(i);
        }
        return null;
    }

    public static int getIndiceObjetListe(String[] liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.length == 0;
        while (!trouve && !fin) {
            if (liste[++i].equals(valeur)) {
                trouve = true;
            }
            boolean bl = fin = i == liste.length - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static boolean estDelegationVide(String d) {
        return d == null || d.equals("Aucune") || d.equals("");
    }

    public static boolean filtreDelegationCentre(String delegationUtilisateur, String centreUtilisateur, String delegationSelectionnee, String centreSelectionnee) {
        boolean valide = false;
        if (MetierCommun.estVide(delegationUtilisateur) || MetierCommun.estVide(delegationSelectionnee)) {
            valide = true;
        } else if (MetierCommun.estEgal(delegationUtilisateur, delegationSelectionnee) && (MetierCommun.estVide(centreUtilisateur) || MetierCommun.estVide(centreSelectionnee) || MetierCommun.estEgal(centreUtilisateur, centreSelectionnee))) {
            valide = true;
        }
        return valide;
    }

    public static boolean estCentreVide(String c) {
        return c == null || c.equals("Aucun") || c.equals("");
    }

    public static boolean estEgal(String a, String b) {
        return a != null && b != null && a.compareToIgnoreCase(b) == 0;
    }

    public static <T> List<T> trier(List<T> array) {
        if (!MetierCommun.estVide(array)) {
            TreeMap<String, T> map = new TreeMap<String, T>();
            for (T obj : array) {
                map.put(obj.toString(), obj);
            }
            Iterator it = map.values().iterator();
            ArrayList eltTrie = new ArrayList();
            while (it.hasNext()) {
                eltTrie.add(it.next());
            }
            return eltTrie;
        }
        return array;
    }

    public static void verifierCheminPhotosEvenements(String cheminStockagePhotos, String idSituation, String idReference) {
        MetierCommun.verifierChemin(MetierCommun.getCheminPhotosEvenement(cheminStockagePhotos, idSituation, idReference));
    }

    public static void verifierChemin(String chemin) {
        new File(chemin).mkdirs();
    }

    public static String md5(String s) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(s.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            int i = 0;
            while (i < messageDigest.length) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
                ++i;
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return s;
        }
    }

    public static HashMap<String, String> convertirAttributs(Nature n, Evenement e) {
        HashMap<String, String> mapValeurs = new HashMap<String, String>();
        List<Champ> champsFiltres = MetierCommun.getChampsFiltres(n);
        for (Champ c : champsFiltres) {
            try {
                List<String[]> values = c.valueOf();
                if (values == null) continue;
                for (String[] value : values) {
                    mapValeurs.put(value[0], value[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return mapValeurs;
    }

    public static void remplirPositionsLocalisation(ValeurChampLocalisation v, List<Position> positions) {
        if (v != null && positions != null) {
            float[] x = new float[positions.size()];
            float[] y = new float[positions.size()];
            int i = 0;
            while (i < positions.size()) {
                Position p = positions.get(i);
                x[i] = p.getX();
                y[i] = p.getY();
                ++i;
            }
            v.setX(x);
            v.setY(y);
        }
    }

    public static List<Restriction> getRestrictionsValeurChamp(Champ c) {
        ArrayList<Restriction> restrictionsChamp = new ArrayList<Restriction>();
        if (c.getRestrictions() != null) {
            for (Restriction r : c.getRestrictions()) {
                if (!MetierCommun.estRestrictionValeurChamp(r)) continue;
                restrictionsChamp.add(r);
            }
        }
        return restrictionsChamp;
    }

    public static boolean estRestrictionValeurChamp(Restriction r) {
        return r != null && r.getNomChamp() != null && !(r instanceof RestrictionProfil) && !(r instanceof RestrictionEtatEvenement);
    }

    public static <T> Map<String, T> getMapView(Nature n, IComposantFactory f) {
        HashMap<String, Object> mapView = new HashMap<String, Object>();
        Map<String, Champ> valeurMap = MetierCommun.getChamps(n);
        for (Champ c : valeurMap.values()) {
            boolean accept = true;
            if (c.getRestrictions() != null) {
                for (Restriction restriction : MetierCommun.getRestrictionsValeurChamp(c)) {
                    if (restriction.accept(valeurMap.get(restriction.getNomChamp()).getValeurChamp())) continue;
                    accept = false;
                    break;
                }
            }
            if (!accept) continue;
            mapView.put(c.getNom(), c.getView(f));
        }
        return mapView;
    }

    public static boolean estValeurOk(Map<String, String> mapValeursChamps, String noms, String valeurs) {
        String[] tValeurs;
        String[] tNoms;
        boolean ok = false;
        if (!MetierCommun.estVide(noms) && !MetierCommun.estVide(valeurs) && (tNoms = noms.split(":")).length == (tValeurs = valeurs.split(":")).length) {
            boolean fin = false;
            int i = 0;
            while (!ok && !fin) {
                try {
                    String valeur = mapValeursChamps.get(tNoms[i]);
                    String valeursOk = tValeurs[i];
                    if (valeur != null && valeursOk != null) {
                        String[] valeursConfigures = valeursOk.split(";");
                        String[] valeursSaisies = valeur.split(";");
                        String[] stringArray = valeursConfigures;
                        int n = valeursConfigures.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String val = stringArray[n2];
                            if (MetierCommun.estDedans(valeursSaisies, (Object)val)) {
                                ok = true;
                            }
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = fin = ++i == tNoms.length;
            }
        }
        return ok;
    }

    public static int getEtatValeurOk(Map<String, String> mapValeursChamps, String noms, String valeurs) {
        String[] tValeurs;
        String[] tNoms;
        int etat = -1;
        if (!MetierCommun.estVide(noms) && !MetierCommun.estVide(valeurs) && (tNoms = noms.split(":")).length == (tValeurs = valeurs.split(":")).length) {
            boolean fin = false;
            int i = 0;
            while (!fin) {
                try {
                    if (mapValeursChamps.containsKey(tNoms[i])) {
                        String valeur = mapValeursChamps.get(tNoms[i]);
                        String valeursOk = tValeurs[i];
                        if (valeur != null && valeursOk != null) {
                            String[] valeursConfigures = valeursOk.split(";");
                            String[] valeursSaisies = valeur.split(";");
                            String[] stringArray = valeursConfigures;
                            int n = valeursConfigures.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String val = stringArray[n2];
                                if (MetierCommun.estDedans(valeursSaisies, (Object)val)) {
                                    etat = 1;
                                } else if (etat != 1) {
                                    etat = 0;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = fin = ++i == tNoms.length;
            }
        }
        return etat;
    }

    public static Map<String, String> getMapViewCommentaire(Nature n, IComposantFactory f) {
        LinkedHashMap<String, String> mapView = new LinkedHashMap<String, String>();
        for (Champ c : MetierCommun.getChampsFiltresTest(n)) {
            if (c.getNom().equals("description")) continue;
            mapView.putAll((Map)c.getView(f));
        }
        return mapView;
    }

    public static List<Champ> getChampsFiltres(Nature n) {
        return MetierCommun.getChampsFiltres(n, n.getChamps());
    }

    public static Map<String, Champ> getChampsFiltresMap(Nature n) {
        ArrayList<Champ> champsASupprimer = new ArrayList<Champ>();
        Map<String, Champ> mapChamps = MetierCommun.getChamps(n);
        for (Champ c : mapChamps.values()) {
            boolean accept = true;
            if (c.getRestrictions() != null) {
                for (Restriction restriction : MetierCommun.getRestrictionsValeurChamp(c)) {
                    if (restriction.accept(mapChamps.get(restriction.getNomChamp()).getValeurChamp())) continue;
                    accept = false;
                    break;
                }
            }
            if (accept) continue;
            champsASupprimer.add(c);
        }
        for (Champ c : champsASupprimer) {
            mapChamps.remove(c.getNom());
        }
        return mapChamps;
    }

    public static List<Champ> getChampsFiltres(Nature n, List<Champ> champs) {
        ArrayList<Champ> champsFiltres = new ArrayList<Champ>();
        Map<String, Champ> mapChamps = MetierCommun.getChamps(n);
        for (Champ c : n.getChamps()) {
            boolean accept = true;
            if (c.getRestrictions() != null) {
                for (Restriction restriction : MetierCommun.getRestrictionsValeurChamp(c)) {
                    if (restriction.accept(mapChamps.get(restriction.getNomChamp()).getValeurChamp())) continue;
                    accept = false;
                    break;
                }
            }
            if (!accept) continue;
            champsFiltres.add(c);
        }
        return champsFiltres;
    }

    public static List<Champ> getChampsFiltresTest(Nature n) {
        return MetierCommun.getChampsFiltresTest(n.getChamps(), MetierCommun.getChamps(n.getChamps()));
    }

    public static Map<String, String> getMapChamps(Nature n) {
        return MetierCommun.getMapChamps(n, null);
    }

    public static Map<String, String> getMapChamps(Nature n, Evenement e) {
        HashMap<String, String> m = new HashMap<String, String>();
        Nature nature = DeepCopy.copy(n);
        if (e != null) {
            nature.chargerValeurs(e.getValeurNature());
        }
        Map<String, Champ> mapChampsFiltres = MetierCommun.getChampsFiltresMap(nature);
        for (Champ c : mapChampsFiltres.values()) {
            try {
                List<String[]> l = c.valueOf();
                for (String[] s : l) {
                    m.put(c.getNom(), s[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return m;
    }

    public static List<Champ> getChampsFiltresTest(List<Champ> champs, Map<String, Champ> mapChamps) {
        ArrayList<Champ> champsFiltres = new ArrayList<Champ>();
        for (Champ c : champs) {
            boolean accept = true;
            if (c.getRestrictions() != null) {
                for (Restriction restriction : MetierCommun.getRestrictionsValeurChamp(c)) {
                    if (restriction.accept(mapChamps.get(restriction.getNomChamp()).getValeurChamp())) continue;
                    accept = false;
                    break;
                }
            }
            if (c instanceof ChampMultiple) {
                ((ChampMultiple)c).setChamps(MetierCommun.getChampsFiltresTest(((ChampMultiple)c).getChamps(), mapChamps));
            }
            if (!accept) continue;
            champsFiltres.add(c);
        }
        return champsFiltres;
    }

    public static Map<String, ValeurChamp> getValeursChamp(Evenement e) {
        return MetierCommun.getValeursChamp(e.getValeurNature().getValeurs());
    }

    public static Map<String, ValeurChamp> getValeursChamp(List<ValeurChamp> liste) {
        HashMap<String, ValeurChamp> mapValeurs = new HashMap<String, ValeurChamp>();
        for (ValeurChamp v : liste) {
            if (v instanceof ValeurChampMultiple) {
                mapValeurs.putAll(MetierCommun.getValeursChamp(((ValeurChampMultiple)v).getValeurs()));
                continue;
            }
            mapValeurs.put(v.getChamp(), v);
        }
        return mapValeurs;
    }

    public static List<Champ> getChampsFiltres(Nature n, Evenement e) {
        if (e != null && n != null) {
            Map<String, ValeurChamp> mapValeurs = MetierCommun.getValeursChamp(e);
            return MetierCommun.getChampsFiltres(n.getChamps(), mapValeurs);
        }
        return null;
    }

    public static List<Champ> getChampsFiltres(List<Champ> champs, Map<String, ValeurChamp> mapChamps) {
        ArrayList<Champ> champsFiltres = new ArrayList<Champ>();
        for (Champ c : champs) {
            boolean accept = true;
            if (c.getRestrictions() != null) {
                for (Restriction restriction : MetierCommun.getRestrictionsValeurChamp(c)) {
                    if (restriction.accept(mapChamps.get(restriction.getNomChamp()))) continue;
                    accept = false;
                    break;
                }
            }
            if (c instanceof ChampMultiple) {
                ((ChampMultiple)c).setChamps(MetierCommun.getChampsFiltres(((ChampMultiple)c).getChamps(), mapChamps));
            }
            if (!accept) continue;
            champsFiltres.add(c);
        }
        return champsFiltres;
    }

    public static Commentaire genereCommentaire(String libelle) {
        return MetierCommun.genereCommentaire(libelle, System.currentTimeMillis(), null, -1);
    }

    public static Commentaire genereCommentaire(String libelle, Evenement evenement) {
        return MetierCommun.genereCommentaire(libelle, System.currentTimeMillis(), evenement, -1);
    }

    public static int getTypeVoieLocalisation(Evenement evenement) {
        evenement.getMainCourante().getCodeModuleMetier();
        return 0;
    }

    public static Commentaire genereCommentaire(String libelle, long date, Evenement evenement, int niveau) {
        return MetierCommun.genereCommentaire(libelle, date, evenement, niveau, 0);
    }

    public static Commentaire genereCommentaire(String libelle, long date, Evenement evenement, int niveau, int type) {
        Commentaire c = new Commentaire();
        c.setId(MetierCommun.instanceOf().genereIdentifiantUnique("com"));
        c.setDate(date);
        c.setLibelle(libelle);
        if (evenement != null) {
            c.setIdEvenement(evenement.getkEventid());
            c.setErf(evenement.getIdReference());
            c.setSnm(evenement.getIdSituation());
        }
        c.setNiveau(niveau);
        c.setType(type);
        return c;
    }

    public static Circuit getAucunCircuit() {
        Circuit c = new Circuit();
        c.setId("0");
        c.setNom("Sans circuit");
        return c;
    }

    public static boolean getBoolean(Map<String, String> m, String k, boolean defaut) {
        boolean ret = m.containsKey(k) ? m.get(k).equals("1") : defaut;
        return ret;
    }

    public static boolean getBoolean(String champ, boolean defaut) {
        if (MetierCommun.estVide(champ)) {
            return defaut;
        }
        if (MetierCommun.estNumerique(champ)) {
            if (champ.equals("1")) {
                return true;
            }
            if (champ.equals("0")) {
                return false;
            }
            return defaut;
        }
        if (champ.toLowerCase().equals("oui") || champ.toLowerCase().endsWith("y") || champ.toLowerCase().equals("true")) {
            return true;
        }
        if (champ.toLowerCase().equals("non") || champ.toLowerCase().endsWith("n") || champ.toLowerCase().equals("false")) {
            return false;
        }
        return defaut;
    }

    public static boolean estValeurSysteme(String definition) {
        return definition != null && definition.length() > 2 && definition.startsWith("<") && definition.endsWith(">");
    }

    public static String getLibelleTypePoste(int typePoste) {
        if (typePoste == 2) {
            return "bureau";
        }
        return "patrouille";
    }

    public static String getLibellePr(ValeurChampLocalisation v) {
        if (v.getPrDebut() != -1) {
            if (v.getPrFin() == -1 || v.getPrDebut() == v.getPrFin() && v.getAbsPrDebut() == v.getAbsPrFin()) {
                return "Au PR " + MetierCommun.getNumeroPr(v.getDeptDebut(), v.getPrDebut()) + MetierCommun.getLibelleAbscissePr(v.getAbsPrDebut());
            }
            return "Du PR " + MetierCommun.getNumeroPr(v.getDeptDebut(), v.getPrDebut()) + MetierCommun.getLibelleAbscissePr(v.getAbsPrDebut()) + " au PR " + MetierCommun.getNumeroPr(v.getDeptFin(), v.getPrFin()) + MetierCommun.getLibelleAbscissePr(v.getAbsPrFin());
        }
        return "";
    }

    public static String getLdapSecurityPrincipal(String login, String domain, String securityPrincipal) {
        if (!MetierCommun.estVide(securityPrincipal) && securityPrincipal.contains("<login>")) {
            return securityPrincipal.replace("<login>", login).replace("<domain>", domain);
        }
        return login.concat("@").concat(domain);
    }

    public static String getNumeroPr(String dpt, int pr) {
        if (dpt != null && !dpt.isEmpty() && !dpt.equals("-1")) {
            return "(" + dpt + ")" + String.valueOf(pr);
        }
        return String.valueOf(pr);
    }

    public static String getLibelleAbscissePr(int abscisse) {
        if (abscisse >= 0) {
            return "+" + String.valueOf(abscisse);
        }
        return String.valueOf(abscisse);
    }

    public static boolean estPonctuel(ValeurChampLocalisation v) {
        if (v.getPrDebut() == -1 && v.getPositionDebut() != null && (v.getPositionFin() == null || v.getPositionFin() != null && v.getPositionDebut().getX() == v.getPositionFin().getX() && v.getPositionDebut().getY() == v.getPositionFin().getY())) {
            return true;
        }
        return v.getPrDebut() != -1 && v.getPrFin() != -1 && v.getPrDebut() == v.getPrFin() && v.getAbsPrDebut() == v.getAbsPrFin();
    }

    public static boolean estLineaire(ValeurChampLocalisation v) {
        if (v.getPrDebut() == -1 && v.getPositionDebut() != null && v.getPositionFin() != null && v.getPositionDebut().getX() != v.getPositionFin().getX() && v.getPositionDebut().getY() != v.getPositionFin().getY()) {
            return true;
        }
        return v.getPrDebut() != -1 && v.getPrFin() != -1 && (v.getPrDebut() != v.getPrFin() || v.getPrDebut() == v.getPrFin() && v.getAbsPrDebut() != v.getAbsPrFin());
    }

    public static boolean estLineaireEnErreur(ValeurChampLocalisation v) {
        return MetierCommun.estLineaire(v) && v.getLongueur() <= 0;
    }

    public static String getDescriptionEvenement(Evenement e, Nature n) {
        StringBuffer s = new StringBuffer();
        s.append(n != null ? n.getLabel() : e.getValeurNature().getCode());
        s.append(" - ");
        s.append(e.getLocalisation().getCommune());
        s.append(" - ");
        s.append(e.getLocalisation().getAxe());
        s.append(" ");
        s.append(MetierCommun.getLibellePr(e.getLocalisation()));
        return s.toString();
    }

    public static String getDescriptionDetailleeEvenement(Evenement e, Nature n) {
        StringBuffer s = new StringBuffer();
        s.append(MetierCommun.getDescriptionEvenement(e, n));
        s.append("\n");
        s.append(e.getValeurNature().getDescription().getValeur());
        return s.toString();
    }

    public static Evenement deserialize(String chemin) {
        try {
            ObjectInputStream oistream = new ObjectInputStream(new FileInputStream(chemin));
            Evenement evenement = (Evenement)oistream.readObject();
            oistream.close();
            oistream = null;
            System.out.println(evenement);
            return evenement;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String ... a) {
        Evenement e = MetierCommun.deserialize("d:/fichier0.ser");
        System.out.println(e);
    }

    public static int getIndiceObjetRessemblantListe(List liste, Object valeur) {
        boolean trouve = false;
        boolean fin = false;
        int i = -1;
        fin = liste == null || liste.size() == 0;
        while (!trouve && !fin) {
            if (liste.get(++i).toString().toLowerCase().indexOf(valeur.toString().toLowerCase()) > -1) {
                trouve = true;
            }
            boolean bl = fin = i == liste.size() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public File zipBarreau(BarreauVH b, String cheminTemporaire, boolean compresser) throws IOException {
        File rep = new File(cheminTemporaire);
        File zipFile = File.createTempFile("barreau", "barreau", rep);
        FileOutputStream stream = new FileOutputStream(zipFile);
        BufferedOutputStream bstream = new BufferedOutputStream(stream, 32000);
        ZipOutputStream zip = new ZipOutputStream(bstream);
        if (compresser) {
            zip.setLevel(1);
        } else {
            zip.setLevel(0);
        }
        zip.setMethod(8);
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(arrayOutputStream);
        objectOutputStream.writeObject(b);
        objectOutputStream.flush();
        objectOutputStream.close();
        ZipEntry entryfichier = new ZipEntry("fichier");
        zip.putNextEntry(entryfichier);
        arrayOutputStream.writeTo(zip);
        zip.closeEntry();
        zip.finish();
        zip.close();
        return zipFile;
    }

    public File zipEvenement(Evenement evenement, IBusinessService business) throws Exception {
        String cheminImageEvenement = MetierCommun.getCheminPhotosEvenement(ConfigurationFactory.getInstance().get("photo.repertoire"), evenement);
        if (Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"))) {
            return this.zipEvenementPhotoDatabase(evenement, ConfigurationFactory.getInstance().get("dir.tmp"), business, false);
        }
        return this.zipEvenement(evenement, ConfigurationFactory.getInstance().get("dir.tmp"), cheminImageEvenement, false);
    }

    public static String getRepertoireTemporaire() {
        return ConfigurationFactory.getInstance().get("dir.tmp", true);
    }

    public File zipPhotos(List<Situation> situations, IBusinessService business) throws Exception {
        File zipFile;
        HashMap<CallSite, CallSite> repPhotos = new HashMap<CallSite, CallSite>();
        String repTmp = ConfigurationFactory.getInstance().get("dir.tmp", false);
        if (repTmp == null || repTmp.isEmpty() || !new File(repTmp).exists()) {
            zipFile = File.createTempFile("photos", ".zip");
        } else {
            File rep = new File(repTmp);
            zipFile = File.createTempFile("photos", ".zip", rep);
        }
        FileOutputStream stream = new FileOutputStream(zipFile);
        BufferedOutputStream bstream = new BufferedOutputStream(stream, 32000);
        ZipOutputStream zip = new ZipOutputStream(bstream);
        zip.setLevel(0);
        zip.setMethod(8);
        if (Boolean.parseBoolean(ConfigurationFactory.getInstance().get("photo.usedatabase"))) {
            for (Situation s : situations) {
                for (Evenement e : s.getEvenements()) {
                    for (String nomPhoto : e.getPhotos()) {
                        byte[] imagedata;
                        String repertoire = e.getCodeEvenement() + "/";
                        if (!repPhotos.containsKey(repertoire)) {
                            zip.putNextEntry(new ZipEntry(repertoire));
                            repPhotos.put((CallSite)((Object)repertoire), (CallSite)((Object)repertoire));
                        }
                        if ((imagedata = business.getPhoto(nomPhoto)) == null) continue;
                        Object ph = nomPhoto;
                        try {
                            if (nomPhoto != null && !nomPhoto.endsWith(".jpg")) {
                                ph = (String)ph + ".jpg";
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ZipEntry entry = new ZipEntry(repertoire + (String)ph);
                        zip.putNextEntry(entry);
                        zip.write(imagedata, 0, imagedata.length);
                        zip.closeEntry();
                    }
                }
            }
        } else {
            for (Situation s : situations) {
                for (Evenement e : s.getEvenements()) {
                    String cheminImageEvenement = MetierCommun.getCheminPhotosEvenement(ConfigurationFactory.getInstance().get("photo.repertoire"), e);
                    if (!new File(cheminImageEvenement).exists()) continue;
                    for (String nomPhoto : e.getPhotos()) {
                        String photo = cheminImageEvenement.concat(nomPhoto);
                        if (!new File(photo).exists()) continue;
                        String repertoire = e.getCodeEvenement() + "/";
                        if (!repPhotos.containsKey(repertoire)) {
                            zip.putNextEntry(new ZipEntry(repertoire));
                            repPhotos.put((CallSite)((Object)repertoire), (CallSite)((Object)repertoire));
                        }
                        ZipEntry entry = new ZipEntry(repertoire + nomPhoto);
                        zip.putNextEntry(entry);
                        BufferedInputStream reader = new BufferedInputStream(new FileInputStream(photo), 32000);
                        byte[] buffer = new byte[4096];
                        int lu = reader.read(buffer, 0, 4096);
                        while (lu != -1) {
                            zip.write(buffer, 0, lu);
                            lu = reader.read(buffer, 0, 4096);
                        }
                        reader.close();
                        zip.closeEntry();
                    }
                }
            }
        }
        zip.closeEntry();
        zip.finish();
        zip.close();
        return zipFile;
    }

    public static String getDelegationCentre(List<Delegation> l, String centre) {
        if (l != null) {
            for (Delegation d : l) {
                for (Centre c : d.getCentres()) {
                    if (!c.equals(centre)) continue;
                    return d.getNom();
                }
            }
        }
        return null;
    }

    public static boolean estInterventionAvecDegat(Situation s, Map<String, Nature> natures) {
        if (s != null && s.getEvenements() != null && s.getEvenements().size() > 1) {
            Nature n1 = natures.get(s.getEvenements().get(0).getValeurNature().getCode());
            Nature n2 = natures.get(s.getEvenements().get(1).getValeurNature().getCode());
            if (n1.getCodeMM() == 5 && n2.getCodeMM() == 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean estDDP(Situation s, Map<String, Nature> natures) {
        if (s != null && s.getEvenements() != null && s.getEvenements().size() > 1) {
            boolean trouveIntervention = false;
            boolean trouveDegat = false;
            boolean fin = false;
            int i = 0;
            while (!fin) {
                Nature n = natures.get(s.getEvenements().get(i).getValeurNature().getCode());
                if (!trouveIntervention && n.getCodeMM() == 5) {
                    trouveIntervention = true;
                }
                if (!trouveDegat && n.getCodeMM() == 0) {
                    trouveDegat = true;
                }
                boolean bl = fin = ++i == s.getEvenements().size() || trouveIntervention && trouveDegat;
            }
            return trouveIntervention && trouveDegat;
        }
        return false;
    }

    public static boolean estDDP(Evenement e) {
        boolean ddp = false;
        if (e != null) {
            try {
                ValeurChamp vc = MetierCommun.getValeurChamp(e.getValeurNature().getValeurs(), "ddp-ddp");
                if (vc != null) {
                    if (vc instanceof ValeurChampCollectionChoixUnique) {
                        ddp = MetierCommun.getBoolean(((ValeurChampCollectionChoixUnique)vc).getValeur(), false);
                    } else if (vc instanceof ValeurChampVraiFaux) {
                        ddp = ((ValeurChampVraiFaux)vc).isValeur();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ddp;
    }

    public static boolean estSituationPatrimoinePanneauAvecSupport(Situation s, Map<String, Nature> natures) {
        if (s != null && s.getEvenements() != null && s.getEvenements().size() > 1) {
            boolean affichageSituation = false;
            boolean fin = false;
            int i = 0;
            while (!fin) {
                Nature n = natures.get(s.getEvenements().get(i).getValeurNature().getCode());
                if (n.getCodeMM() == 7 && n.getCode().equals("signalisationVerticaleSupport")) {
                    affichageSituation = true;
                    fin = true;
                }
                boolean bl = fin = fin || ++i == s.getEvenements().size();
            }
            return affichageSituation;
        }
        return false;
    }

    public static boolean estEvenementPrincipalPatrimoinePanneauSupport(Evenement evt, Map<String, Nature> natures) {
        return MetierCommun.estEvenementPrincipal(evt, natures, "signalisationVerticaleSupport");
    }

    public static boolean estEvenementPrincipalPatrimoinePanneau(Evenement evt, Map<String, Nature> natures) {
        return MetierCommun.estEvenementSecondaire(evt, natures, "signalisationVerticalePanneau");
    }

    public static boolean estEvenementPrincipal(Evenement evt, Map<String, Nature> natures, String code) {
        return evt.getValeurNature().getCode().equals(code);
    }

    public static boolean estEvenementSecondaire(Evenement evt, Map<String, Nature> natures, String code) {
        return evt.getValeurNature().getCode().equals(code);
    }

    public static String getLibelleEvenementSecondaire(Evenement evenement, int nbEvenementSecondaire) {
        if (evenement.getValeurNature().getCode().equals("signalisationVerticaleSupport")) {
            return "Panneaux -- (" + nbEvenementSecondaire + ")";
        }
        return null;
    }

    public static boolean estNatureAssociation(NatureOuRaccourci natureOuRaccourci) {
        return natureOuRaccourci.getCode().equals("signalisationVerticaleSupport");
    }

    public static List<Position> getFloatToPositions(float[][] coordonnees) {
        ArrayList<Position> l = new ArrayList<Position>();
        if (coordonnees != null) {
            try {
                int taille = coordonnees[0].length;
                if (taille > 0) {
                    int i = 0;
                    while (i < taille) {
                        Position p = new Position();
                        p.setX(coordonnees[0][i]);
                        p.setY(coordonnees[1][i]);
                        l.add(p);
                        ++i;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return l;
    }

    public static List<Evenement> getEvenements(Situation s, Map<String, Nature> natures, int codeModuleMetier) {
        ArrayList<Integer> l = new ArrayList<Integer>(1);
        l.add(codeModuleMetier);
        return MetierCommun.getEvenements(s, natures, l);
    }

    public static List<Evenement> getEvenements(Situation s, Map<String, Nature> natures, List<Integer> codeModuleMetier) {
        ArrayList<Evenement> evenements = new ArrayList();
        if (!MetierCommun.estVide(codeModuleMetier)) {
            for (Evenement e : s.getEvenements()) {
                Nature n = natures.get(e.getValeurNature().getCode());
                if (n == null || !MetierCommun.estDedans(codeModuleMetier, (Object)n.getCodeMM())) continue;
                evenements.add(e);
            }
        } else {
            evenements = s.getEvenements();
        }
        return evenements;
    }

    public static String getComplementLocalisation(ValeurChampLocalisation v) {
        if (v.getComplementLocalisation() != null && !v.getComplementLocalisation().isEmpty()) {
            return v.getComplementLocalisation();
        }
        return "";
    }

    public static String getCaracteristiquesLocalisation(ValeurChampLocalisation v) {
        StringBuffer s = new StringBuffer();
        s.append("categorie");
        s.append("=");
        s.append(v.getCategorie());
        s.append(":");
        s.append("trafic");
        s.append("=");
        s.append(v.getTrafic());
        return s.toString();
    }

    public static MapDescription getCaracteristiquesLocalisation(String v) {
        return MapDescription.parse(v);
    }

    public static List<Delegation> getDelegationsActives(List<Delegation> delegations) {
        ArrayList<Delegation> delegationsActives = new ArrayList<Delegation>();
        for (Delegation d : delegations) {
            if (d.isArchive()) continue;
            Delegation dBis = new Delegation();
            dBis.setArchive(d.isArchive());
            dBis.setBounds(d.getBounds());
            dBis.setNom(d.getNom());
            dBis.setCentres(MetierCommun.getCentresActifs(d.getCentres()));
            delegationsActives.add(dBis);
        }
        return delegationsActives;
    }

    public static boolean estChampFin(String nom) {
        return nom != null && nom.equals("sto");
    }

    public static boolean estChampDebut(String nom) {
        return nom != null && nom.equals("sta");
    }

    public static Centre getCentreParNom(List<Delegation> listeDelegations, String nom) {
        Centre centre = null;
        for (Delegation d : listeDelegations) {
            for (Centre c : d.getCentres()) {
                if (c.getNom() == null || nom == null || !c.getNom().equalsIgnoreCase(nom)) continue;
                return c;
            }
        }
        return centre;
    }

    public static Centre getCentreParCode(List<Delegation> listeDelegations, String code) {
        Centre centre = null;
        for (Delegation d : listeDelegations) {
            for (Centre c : d.getCentres()) {
                if (c.getCode() == null || code == null || !c.getCode().equalsIgnoreCase(code)) continue;
                return c;
            }
        }
        return centre;
    }

    public static List<Centre> getCentresActifs(List<Centre> centres) {
        ArrayList<Centre> centresActifs = new ArrayList<Centre>();
        for (Centre c : centres) {
            if (c.isArchive()) continue;
            centresActifs.add(c);
        }
        return centresActifs;
    }

    public static List<Position> inverser(List<Position> l) {
        ArrayList<Position> li = new ArrayList<Position>(l.size());
        for (Position p : l) {
            li.add(0, p);
        }
        return li;
    }

    public static boolean estDebroussaillageVD(String releve) {
        return releve.toLowerCase().equals("vd");
    }

    public static float[][] toFloat(List<Position> listePoints) {
        if (listePoints != null) {
            float[][] pts = new float[2][];
            if (listePoints.size() != 1) {
                pts[0] = new float[listePoints.size()];
                pts[1] = new float[listePoints.size()];
                int i = 0;
                while (i < listePoints.size()) {
                    Position p = listePoints.get(i);
                    pts[0][i] = p.getX();
                    pts[1][i] = p.getY();
                    ++i;
                }
            } else {
                pts[0] = new float[2];
                pts[1] = new float[2];
                Position p = listePoints.get(0);
                int i = 0;
                while (i < 2) {
                    pts[0][i] = p.getX();
                    pts[1][i] = p.getY();
                    ++i;
                }
            }
            return pts;
        }
        return null;
    }

    public static String verificationAxe(ValeurChampLocalisation v) {
        return MetierCommun.verificationAxe(v.getAxe());
    }

    public static String verificationAxe(String axe) {
        if (!MetierCommun.estVide((String)axe) && ((String)axe).length() > 0) {
            if (MetierCommun.estNumerique(String.valueOf(((String)axe).charAt(0))) && ((String)axe).length() < 5) {
                axe = "D" + (String)axe;
            } else if (((String)axe).toLowerCase().charAt(0) == 'd' || ((String)axe).toLowerCase().charAt(0) == 'a' || ((String)axe).toLowerCase().charAt(0) == 'n') {
                axe = String.valueOf(((String)axe).charAt(0)).toUpperCase() + ((String)axe).substring(1).trim();
            } else if (((String)axe).length() > 1 && (((String)axe).toLowerCase().startsWith("rd") || ((String)axe).toLowerCase().startsWith("rn"))) {
                axe = String.valueOf(((String)axe).charAt(1)).toUpperCase() + ((String)axe).substring(2).trim();
            }
            while (((String)axe).length() > 3 && ((String)axe).charAt(1) == '0') {
                axe = ((String)axe).substring(0, 1) + ((String)axe).substring(2);
            }
        }
        return axe;
    }

    public static boolean estUtilisateurSysteme(String code) {
        return code.startsWith("#");
    }

    public static int getSensZone(String sens) {
        if (sens != null) {
            if (sens.compareToIgnoreCase("Positif") == 0) {
                return 1;
            }
            if (sens.compareToIgnoreCase("N\u00e9gatif") == 0) {
                return 0;
            }
        }
        return -1;
    }

    public static int getIndiceSens(List<ValeurSens> listeSens, Object direction) {
        int i = -1;
        boolean trouve = false;
        boolean fin = listeSens.size() == 0;
        while (!trouve && !fin) {
            if (listeSens.get(++i).equals(direction)) {
                trouve = true;
            }
            boolean bl = fin = i == listeSens.size() - 1;
        }
        if (trouve) {
            return i;
        }
        return -1;
    }

    public static String parse(Map<String, String> parametres) {
        return MetierCommun.parse(parametres, ";");
    }

    public static String parse(Map<String, String> parametres, String separateur) {
        ArrayList<String> val = new ArrayList<String>();
        if (parametres != null) {
            for (String k : parametres.keySet()) {
                val.add(k.concat("=").concat(parametres.get(k)));
            }
        }
        return MetierCommun.getString(val, separateur);
    }

    public static String getChampAgentIntervention(int indice, String nomChamp) {
        return "agent".concat(String.valueOf(indice)).concat("-").concat(nomChamp);
    }

    public static boolean estChampAutreVehicule(String nomChamp) {
        return !MetierCommun.estVide(nomChamp) && nomChamp.startsWith("autre-vehicule");
    }

    public static boolean estChampAgentInterventionVehicule(String nomChamp) {
        return !MetierCommun.estVide(nomChamp) && nomChamp.startsWith("agent") && nomChamp.startsWith("agent");
    }

    public static List<String> getChampsAgentsInterventionVehicule(Map<String, String> parametres) {
        ArrayList<String> champsVehicules = new ArrayList<String>();
        if (parametres != null) {
            for (String k : parametres.keySet()) {
                if (!MetierCommun.estChampAgentInterventionVehicule(k)) continue;
                champsVehicules.add(parametres.get(k));
            }
        }
        return champsVehicules;
    }

    public static List<String> getChampsAutresVehicule(Map<String, String> parametres) {
        ArrayList<String> champsVehicules = new ArrayList<String>();
        if (parametres != null) {
            for (String k : parametres.keySet()) {
                if (!MetierCommun.estChampAutreVehicule(k)) continue;
                champsVehicules.add(parametres.get(k));
            }
        }
        return champsVehicules;
    }

    public static String getChampAgentInterventionArriveeDomicile() {
        return MetierCommun.getChampAgentIntervention(1, "dateArriveeDomicile");
    }

    public static MainCourante genereMainCourante(IUtilisateur u) {
        return MetierCommun.genereMainCourante(MetierCommun.instanceOf().genereIdentifiantUniqueMainCourante(u), u.getCode());
    }

    public static MainCourante genereMainCourante(String mcigId, String codeUtilisateur) {
        MainCourante mc = new MainCourante();
        mc.setId(mcigId);
        mc.setCodeUtilisateur(codeUtilisateur);
        mc.setDateDebut(System.currentTimeMillis());
        mc.setDateFin(-1L);
        return mc;
    }

    public static Commentaire genereCommentaire(String comment, long time, int i, int niveauNormal) {
        return MetierCommun.genereCommentaire(comment, time, null, niveauNormal, i);
    }

    public static boolean estPublicationAutomatiqueBackOffice(Evenement e, Extension config) {
        List<String> l = MetierCommun.getListe((String)config.get("naturesPublicationAutoBackOffice"));
        return MetierCommun.estDedans(l, (Object)e.getValeurNature().getCode());
    }

    public static boolean isDynamicUA(Extension ext) {
        return ext.getBoolean("ua.dynamique", false);
    }

    public static List<ActiviteEntretien> parseActivites(ModuleMetier mm) {
        if (mm != null) {
            return MetierCommun.parseActivites(mm.getParametres());
        }
        return new ArrayList<ActiviteEntretien>();
    }

    public static List<ActiviteEntretien> parseActivites(MapDescription m) {
        ArrayList<ActiviteEntretien> activites = new ArrayList<ActiviteEntretien>();
        if (m != null) {
            List<String> l = m.getList("activites");
            for (String c : l) {
                ActiviteEntretien act = new ActiviteEntretien();
                act.setCode(c);
                act.setLibelle(m.getString(MetierCommun.getCleLibelleActivite(m, c), c));
                act.setActiviteAnnexe(MetierCommun.getActiviteAnnexe(m, act));
                activites.add(act);
            }
        }
        return activites;
    }

    public static String getCleLibelleActivite(MapDescription m, String codeActivite) {
        return codeActivite.concat("-").concat("libelle");
    }

    public static String getCleActiviteAnnexe(MapDescription m, String codeActivite) {
        return codeActivite.concat("-").concat("activiteAnnexe");
    }

    public static Activite getActiviteAnnexe(MapDescription m, ActiviteEntretien activite) {
        Activite actAnnexe;
        if (m.containsKey(MetierCommun.getCleActiviteAnnexe(m, activite.getCode()))) {
            actAnnexe = new Activite();
            actAnnexe.setCode(m.getString(MetierCommun.getCleActiviteAnnexe(m, activite.getCode()), "!!ERREUR!!"));
            actAnnexe.setLibelle(m.getString(MetierCommun.getCleLibelleActivite(m, actAnnexe.getCode()), actAnnexe.getCode()));
        } else {
            actAnnexe = null;
        }
        return actAnnexe;
    }
}

