/*
 * Decompiled with CFR 0.152.
 */
package com.geolocsystems.prismandroid;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismcentralvaadin.config.PrismConfigurationError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapDescription
implements Serializable {
    private static final long serialVersionUID = 3325412582689000472L;
    private final Map<String, String> map;
    private static final String SEPARATEUR = ":";

    public static MapDescription parse(String description, String separateur, boolean insertionValeurUnique) {
        try {
            if (description != null) {
                return MapDescription.parse(description.split(separateur), insertionValeurUnique);
            }
            return MapDescription.newMap();
        }
        catch (RuntimeException e) {
            throw new PrismConfigurationError("Erreur de lecture de la description", e);
        }
    }

    public static MapDescription parse(String description, String separateur) {
        return MapDescription.parse(description, separateur, false);
    }

    public static MapDescription parse(String[] pairs) {
        return MapDescription.parse(pairs, false);
    }

    public static MapDescription parse(String[] pairs, boolean insertionValeurUnique) {
        try {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            if (pairs != null) {
                String[] stringArray = pairs;
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    String pair = stringArray[n2];
                    MapDescription.addValue(map, pair, insertionValeurUnique);
                    ++n2;
                }
            }
            return new MapDescription(map);
        }
        catch (RuntimeException e) {
            throw new PrismConfigurationError("Erreur de lecture de la description", e);
        }
    }

    public void addValue(String value) {
        MapDescription.addValue(this.map, value, false);
    }

    public void addValue(String value, boolean insertionValeurUnique) {
        MapDescription.addValue(this.map, value, insertionValeurUnique);
    }

    public String valueOfKey(String k) throws Exception {
        if (this.map.containsKey(k)) {
            return k.concat("=").concat(this.map.get(k));
        }
        return null;
    }

    public String[] valuesOf() {
        String[] valuesOf = new String[this.map.values().size()];
        int i = 0;
        for (String k : this.map.keySet()) {
            try {
                valuesOf[i++] = this.valueOfKey(k);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valuesOf;
    }

    public static void addValue(Map<String, String> map, String value, boolean insertionValeurUnique) {
        String[] keyvalue = value.split("=");
        if (keyvalue.length == 2) {
            map.put(keyvalue[0], keyvalue[1]);
        } else if (insertionValeurUnique && !value.isEmpty()) {
            map.put(keyvalue[0], keyvalue[0]);
        }
    }

    public static MapDescription parse(String description) {
        return MapDescription.parse(description, SEPARATEUR, false);
    }

    public boolean containsKey(String k) {
        return this.map.containsKey(k);
    }

    public void add(MapDescription autreMap) {
        this.add(autreMap.map);
    }

    public void add(Map<String, String> autreMap) {
        this.map.putAll(autreMap);
    }

    public static MapDescription newMap() {
        return new MapDescription(new LinkedHashMap<String, String>());
    }

    public static MapDescription fromMap(Map<String, String> map) {
        return new MapDescription(map);
    }

    private MapDescription(Map<String, String> valeurs) {
        this.map = valeurs;
    }

    public String getString(String key, String defaut) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return defaut;
    }

    public List<String> getList(String key) {
        ArrayList<String> ret = null;
        if (this.map.containsKey(key)) {
            ret = new ArrayList<String>();
            ret.addAll(Arrays.asList(this.map.get(key).split(",")));
        }
        return ret;
    }

    public int getInt(String key, int defaut) {
        if (this.map.containsKey(key)) {
            return Integer.parseInt(this.map.get(key));
        }
        return defaut;
    }

    public double getDouble(String key, double defaut) {
        if (this.map.containsKey(key)) {
            return Double.parseDouble(this.map.get(key));
        }
        return defaut;
    }

    public boolean getBoolean(String key, boolean defaut) {
        if (this.map.containsKey(key)) {
            return MetierCommun.getBoolean(this.map.get(key), defaut);
        }
        return defaut;
    }

    public String serialize() {
        return this.serialize(SEPARATEUR);
    }

    public String serialize(String separateur) {
        StringBuffer buff = new StringBuffer();
        for (String key : this.map.keySet()) {
            String val = this.map.get(key);
            if (buff.length() > 0) {
                buff.append(separateur);
            }
            buff.append(key).append("=").append(val);
        }
        return buff.toString();
    }

    public String toString(String separateur) {
        return MetierCommun.parse(this.map, separateur);
    }

    public String toString() {
        return this.toString(SEPARATEUR);
    }

    public Set<String> getCles() {
        return this.map.keySet();
    }
}

